/**
 * Kendo UI v2022.3.913 (http://www.telerik.com/kendo-ui)
 * Copyright 2022 Progress Software Corporation and/or one of its subsidiaries or affiliates. All rights reserved.
 *
 * Kendo UI commercial licenses may be obtained at
 * http://www.telerik.com/purchase/license-agreement/kendo-ui-complete
 * If you do not own a commercial license, this file shall be governed by the trial license terms.
 */
!function(define){define("colorpicker/colorselector.min",["kendo.core.min"],function(){var e=window.kendo.jQuery,o=void 0,i=window.kendo,t=i.ui,a=t.Widget,n=i.parseColor,r=i.ui.Popup.TabKeyTrap,d=e.extend,s=".kendoColorTools",l="keydown"+s,p="k-disabled",u=a.extend({init:function(e,t){var o=this;a.fn.init.call(o,e,t);e=o.element;t=o.options;if(e.is("input")){o._initialValue();o._preventDefaultLabelClick()}else o._value=n(t.value);o._tabIndex=e.attr("tabIndex")||0;if(t._standalone)o._triggerSelect=o._triggerChange},options:{name:"ColorSelector",ARIATemplate:'Current selected color is #=data || "none"#',value:null,_standalone:true},events:["change","select","forceSelect","cancel"],color:function(e){if(e!==o){this._value=n(e);if(this.element.is("input"))this._updateInput(this._value);this._updateUI(this._value)}return this._value},value:function(e){e=this.color(e);if(e)if(this.options.opacity)e=e.toCssRgba();else e=e.toCss();return e||null},enable:function(e){if(arguments.length===0)e=true;if(this.element.is("input"))this.element.attr("disabled",!e);this.wrapper.toggleClass(p,!e);this._onEnable(e)},_attachFocusEvents:function(){this.wrapper.on(l,this._navKeydown.bind(this)).on("focusout"+s,this._navFocusout.bind(this))},_initialValue:function(){var e=this.element,t=this.options,o=t.value||e.attr("value");if(o)this._value=n(o,true);this.element.val(o)},_innerTabindex:function(e){var t=this.wrapper;t.find(".k-draghandle, .k-button, .k-input-inner").attr("tabindex",e)},_isInputTypeColor:function(){var e=this.element[0];return/^input$/i.test(e.tagName)&&/^color$/i.test(e.type)},_navFocusout:function(){var e=this,t=e.wrapper[0];setTimeout(function(){if(!t.contains(document.activeElement))e._releaseInnerFocus()})},_navKeydown:function(e){var t=this.wrapper;if(e.keyCode===i.keys.ENTER&&t.attr("tabindex")){e.preventDefault();this._trapInnerFocus()}else if(e.keyCode===i.keys.ESC&&t.attr("tabindex")===o){this._releaseInnerFocus();this.wrapper.trigger("focus")}},_releaseInnerFocus:function(){this._tabKeyTrap.removeTrap();this.wrapper.attr("tabindex",this._tabIndex);this._innerTabindex(-1)},_select:function(e,t){var o=this._value;e=this.color(e);if(!t)if(e&&(!o||!e.equals(o))||e===null&&e!==o){this.element.trigger("change");this.trigger("change",{value:this.value()})}else if(!this._standalone)this.trigger("cancel")},_navigation:function(){var e=this.value();if(e&&e.indexOf("rgba")>-1)e=e.replace("rgba","RGBA");if(this.options._otOfPicker){this._innerTabindex(-1);this._attachFocusEvents();this._tabKeyTrap=new r(this.wrapper);this._ariaTemplate=i.template(this.options.ARIATemplate);this.wrapper.attr({"aria-label":this._ariaTemplate(e||""),tabindex:this._tabIndex})}else{this.wrapper.removeAttr("tabindex");this.wrapper.removeAttr("aria-label");this.wrapper.removeAttr("role");this.wrapper.removeAttr("aria-keyshortcuts")}},_trapInnerFocus:function(){this._innerTabindex(0);this.wrapper.removeAttr("tabindex");this.wrapper.find(".k-hsv-draghandle").trigger("focus");this._tabKeyTrap.trap()},_triggerSelect:function(e){c(this,"select",e)},_triggerChange:function(e){c(this,"change",e)},destroy:function(){if(this.element)this.element.off(s);if(this.wrapper){this.wrapper.off(l);this.wrapper.off(s).find("*").off(s);this.wrapper=null}a.fn.destroy.call(this)},_preventDefaultLabelClick:function(){var e=this.element,t=e.closest("label"),o=e.attr("id");if(o)t=t.add('label[for="'+o+'"]');t.on("click",function(e){e.preventDefault()})},_updateUI:e.noop,_updateInput:function(e){var t="",o;if(e){if(this._isInputTypeColor()||e.a==1)t=e.toCss();else t=e.toCssRgba();this.element.val(t)}if(this.options._otOfPicker){if(!this._ariaTemplate)this._ariaTemplate=i.template(this.options.ARIATemplate);o=this.value();if(o&&o.indexOf("rgba")>-1)o=o.replace("rgba","RGBA");this.wrapper.attr("aria-label",this._ariaTemplate(o||""))}},_selectOnHide:function(){return null},_cancel:function(){this.trigger("cancel")}});function c(e,t,o){o=n(o);if(o&&!o.equals(e.color())||o!==e.color()){if(t=="change"){e._value=o;e._updateInput(e._value)}if(o&&o.a!=1)o=o.toCssRgba();else if(o)o=o.toCss();e.trigger(t,{value:o})}}return d(t,{colorpicker:{ColorSelector:u}}),window.kendo})}("function"==typeof define&&define.amd?define:function(e,t,o){(o||t)()}),function(define){define("colorpicker/contrastToolUtils.min",["kendo.core.min"],function(){var e=window.kendo.jQuery,t=void 0,s=kendo.ui.colorpicker,u=e.extend,l=kendo.Color,f=kendo.parseColor,i=4.5,a=7,n=16;function d(e,t){var o=Math.max(e,t);var i=Math.min(e,t);return(o+.05)/(i+.05)}function v(e,t){return d(o(r(e,t)),o(r(t,{r:0,g:0,b:0,a:1})))}function o(e){var t=[e.r,e.g,e.b].map(function(e){e/=255;return e<=.03928?e/12.92:Math.pow((e+.055)/1.055,2.4)});return t[0]*.2126+t[1]*.7152+t[2]*.0722}function r(e,t){var o=c(e.r,0,255);var i=c(e.g,0,255);var a=c(e.b,0,255);var n=c(e.a,0,1);var r=c(t.r,0,255);var s=c(t.g,0,255);var l=c(t.b,0,255);return{r:Math.round((1-n)*r+n*o),g:Math.round((1-n)*s+n*i),b:Math.round((1-n)*l+n*a)}}function c(e,t,o){if(!p(e)||isNaN(e))return t;return e<=t?t:e>=o?o:e}function p(e){return e!==null&&e!==t}function C(l,c,d){var p=function(e,t,o,i,a){var n=(o+i)/2;var r=u({},c,{s:t/l.width,v:1-n/l.height});var s=v(f(b(r)).toBytes(),f(d).toBytes());if(o+.5>i)if(s<e+1&&s>e-1)return n;else return null;if(a(s,e))return p(e,t,o,i-(i-o)/2,a);return p(e,t,o+(i-o)/2,i,a)};var r=function(e,t){return e>t};var s=function(e,t){return e<t};var e=function(e,t,o){var i=[];for(var a=0;a<=l.width;a+=l.width/t){var n=p(e,a,0,l.height,o?s:r);if(n!==null)i.push([a,n])}return i};var t=_(g(k));var o=h(e(i,n,false),t)+h(e(i,n,true),t)+h(e(a,n,false),t)+h(e(a,n,true),t);return'<svg xmlns="http://www.w3.org/2000/svg" style="position: absolute; overflow: visible; pointer-events: none; left: 0px; top: 0px; z-index: 3;" >'+o+"</svg>"}function h(e,a){if(e.length===0)return"";var t=function(e,t,o,i){return o===0?kendo.format("M {0},{1}",t[0],t[1]):kendo.format("{0} {1}",e,a(t,o,i))};var o=e.reduce(t,"");return kendo.format('<path d="{0}" fill="none" stroke="white" stroke-width="1"/>',o)}function _(n){return function(e,t,o){var i=n(o[t-1],o[t-2],e);var a=n(e,o[t-1],o[t+1],true);return kendo.format("C {0},{1} {2},{3} {4},{5}",i[0],i[1],a[0],a[1],e[0],e[1])}}function g(u){return function(e,t,o,i){var a=t||e;var n=o||e;var r=.1;var s=u(a,n);var l=s.angle+(i?Math.PI:0);var c=s.length*r;var d=e[0]+Math.cos(l)*c;var p=e[1]+Math.sin(l)*c;return[d,p]}}function k(e,t){var o=t[0]-e[0];var i=t[1]-e[1];return{length:Math.sqrt(Math.pow(o,2)+Math.pow(i,2)),angle:Math.atan2(i,o)}}function b(e){var t=c(e.h,0,359.9);var o=c(e.s,0,1);var i=c(e.v,0,1);var a=c(e.a,0,1);return l.fromHSV(t,o,i,a).toCssRgba()}return u(s,{contrastToolUtils:{getContrastFromTwoRGBAs:v,renderSvgCurveLine:C}}),window.kendo})}("function"==typeof define&&define.amd?define:function(e,t,o){(o||t)()}),function(define){define("colorpicker/colorgradient.min",["kendo.core.min","kendo.popup.min","./contrastToolUtils.min"],function(){var t={id:"colorgradient",name:"ColorGradient",category:"web",description:"ColorGradient allows selection of a color from an HSV canvas.",depends:["core","popup","textbox"]},r=window.kendo.jQuery,o=void 0,l=window.kendo,e=l.ui,i=l.Observable,c=l.parseColor,f=r.extend,d=l.Color,n=l.keys,v="background-color",p="#ffffff",u="#000000",h,s="keydown"+".kendoColorTools",a=e.colorpicker.ColorSelector,C=e.colorpicker.contrastToolUtils;function _(e){e.preventDefault()}function g(e,t){return function(){return e.apply(t,arguments)}}var k=i.extend({init:function(e,t){var o=this;o.element=e;o.options=t;o._viewModel=l.observable({switchMode:o.switchMode.bind(o),keydown:o.keydown.bind(o),mode:function(e){return e===this.get("format")},format:t.format,formats:t.formats,rgb:null,hex:function(){return this.get("rgb")!==null&&this.get("rgb").toCss({alpha:t.opacity})}});o._changeHandler=o.change.bind(o);o._viewModel.bind("change",o._changeHandler);o._render();o.element.on(s,o.keydown.bind(o));i.fn.init.call(o)},_template:l.template("# if (options.formats && options.formats.length > 1) { #"+'<div class="k-vstack">'+'<button class="k-colorgradient-toggle-mode" data-#:ns#role="button" data-#:ns#icon="arrows-kpi" data data-#:ns#bind="click: switchMode" data-#:ns#fill-mode="flat" data-#:ns#size="#: options.size #" title="#: options.messages.toggleFormat #">'+"</button>"+"</div>"+"# } #"+'# if (options.formats && options.formats.indexOf("hex") >= 0) { #'+'<div class="k-vstack k-flex-1" data-#:ns#bind="visible: mode(\'hex\')">'+'<input type="text" data-#:ns#bind="value: hex" data-#:ns#role="textbox" data-#:ns#size="#: options.size #" tabindex="#:options.tabindex#"  aria-label="#: options.messages.hex #"/>'+'<label class="k-colorgradient-input-label">HEX</label>'+"</div>"+"# } #"+'# if (options.formats && options.formats.indexOf("rgb") >= 0) { #'+'<div  class="k-vstack" data-#:ns#bind="visible: mode(\'rgb\')">'+'<input tabindex="#:options.tabindex#" data-#:ns#bind="value: rgb.r" data-#:ns#role="numerictextbox" data-#:ns#size="#: options.size #" data-#:ns#max="255" data-#:ns#min="0" data-#:ns#decimals="0" data-#:ns#spinners="false" data-#:ns#format="n0"  aria-label="#: options.messages.red #" />'+'<label class="k-colorgradient-input-label">R</label>'+"</div>"+'<div  class="k-vstack" data-#:ns#bind="visible: mode(\'rgb\')">'+'<input tabindex="#:options.tabindex#" data-#:ns#bind="value: rgb.g" data-#:ns#role="numerictextbox" data-#:ns#size="#: options.size #" data-#:ns#max="255" data-#:ns#min="0" data-#:ns#decimals="0" data-#:ns#spinners="false" data-#:ns#format="n0"  aria-label="#: options.messages.green #" />'+'<label class="k-colorgradient-input-label">G</label>'+"</div>"+'<div  class="k-vstack" data-#:ns#bind="visible: mode(\'rgb\')">'+'<input tabindex="#:options.tabindex#" data-#:ns#bind="value: rgb.b" data-#:ns#role="numerictextbox" data-#:ns#size="#: options.size #" data-#:ns#max="255" data-#:ns#min="0" data-#:ns#decimals="0" data-#:ns#spinners="false" data-#:ns#format="n0"  aria-label="#: options.messages.blue #"/>'+'<label class="k-colorgradient-input-label">B</label>'+"</div>"+"#if(options.opacity){#"+'<div  class="k-vstack" data-#:ns#bind="visible: mode(\'rgb\')">'+'<input tabindex="#:options.tabindex#" data-#:ns#bind="value: rgb.a" data-#:ns#role="numerictextbox" data-#:ns#size="#: options.size #" data-#:ns#step="0.1" data-#:ns#max="1" data-#:ns#min="0" data-#:ns#decimals="1" data-#:ns#spinners="false" data-#:ns#format="n1"  aria-label="#: options.messages.alpha #" />'+'<label class="k-colorgradient-input-label">A</label>'+"</div>"+"# } #"+"# } #"),destroy:function(){var e=this;e._viewModel.unbind("change",e._changeHandler);l.unbind(e.element);l.destroy(e.element);e.element.off(s);delete e._viewModel;delete e._changeHandler},change:function(e){var t=this;if(e.field.indexOf("rgb")>=0){t._color=t._tryParseColor(t._viewModel.rgb.toCssRgba());t._viewModel.set("hex",t._color.toCss({alpha:t.options.opacity}))}else if(e.field==="hex"){t._color=t._tryParseColor(e.sender[e.field]);t._viewModel.set("rgb",t._color)}if(!t._preventChangeEvent)t.trigger("change",{value:t._color})},keydown:function(e){var t=this,o=r(e.target).data("kendoTextBox");if(e.keyCode===n.ENTER&&r(e.target).is("input")){if(o&&o._change)o._change();t.trigger("change",{value:t._color});t.trigger("select",{value:t._color})}},reset:function(){var e=this;e._preventChangeEvent=true;e._viewModel.set("rgb",c(u));delete e._preventChangeEvent},switchMode:function(){var e=this,t=e._viewModel,o=t.format,i=t.formats.indexOf(o)+1;i=i>=t.formats.length?0:i;e._preventChangeEvent=true;e._viewModel.set("format",t.formats[i]);delete e._preventChangeEvent},value:function(e){var t=this;t._color=e&&e.toBytes()||c(u);t._preventChangeEvent=true;t._viewModel.set("rgb",t._color);delete t._preventChangeEvent},_render:function(){var e=this;e.element.append(e._template({ns:l.ns,guid:l.guid(),options:e.options})).parent();l.bind(e.element,e._viewModel);e.element.attr("data-"+l.ns+"stop","stop")},_tryParseColor:function(t){var o=this;try{t=c(t)||o._color}catch(e){t=o._color}return t}}),b=a.extend({init:function(e,t){var o=this,i;a.fn.init.call(o,e,t);t=o.options=l.deepExtend({},o.options,t);if(t.messages.previewInput)t.messages.hex=t.messages.previewInput;t.messages=t.messages?r.extend(o.options.messages,t.messages):o.options.messages;e=o.element;o._wrapper();o._sliders();o._hsvArea();i=o._value;o._gradientInputs();o._updateUI(i);o._navigation()},options:{name:"ColorGradient",opacity:false,hsvDragARIATemplate:'Color well with two-dimensional slider for selecting saturation and value. Selected color is #=data || "none"#',input:true,format:"hex",formats:["rgb","hex"],contrastTool:false,size:"medium",messages:{contrastRatio:"Contrast ratio:",fail:"Fail",pass:"Pass",hex:"HEX",toggleFormat:"Toggle format",red:"Red channel",green:"Green channel",blue:"Blue channel",alpha:"Alpha channel"},_otOfPicker:true},_template:l.template('<div class="k-colorgradient-canvas k-hstack">'+'<div class="k-hsv-rectangle"><div class="k-hsv-gradient"></div><div role="slider" aria-orientation="undefined" class="k-hsv-draghandle k-draghandle"></div></div>'+'<div class="k-hsv-controls k-hstack">'+'<input class="k-hue-slider k-colorgradient-slider" />'+"# if (opacity) { #"+'<input class="k-alpha-slider k-colorgradient-slider" />'+"# } #"+"</div>"+"</div>"+"# if (input) { #"+'<div class="k-colorgradient-inputs k-hstack">'+"</div>"+"# } #"+"# if (contrastTool) { #"+'<div class="k-colorgradient-color-contrast k-vbox">'+"</div>"+"# } #"),focus:function(){this._hsvHandle.focus()},setBackgroundColor:function(e){var t=this;if(t.options.contrastTool){t.options.contrastTool=r.isPlainObject(t.options.contrastTool)?f({},t.options.contrastTool,{backgroundColor:e}):{backgroundColor:e};t._updateColorContrast(t.color()||c(p))}},_getHSV:function(e,t,o,i){var a=this,n=a._hsvRect,r=n.width(),s=n.height(),l=this._hsvHandle.position();if(!r||!s)return a.color()?a.color().toHSV():c(u);if(e==null)e=a._hueSlider.value();if(t==null)t=l.left/r;if(o==null)o=1-l.top/s;if(i==null)i=a._opacitySlider?a._opacitySlider.value()/100:1;return d.fromHSV(e,t,o,i)},_gradientInputs:function(){var o=this,e=o.options;if(o._colorgradientInputs.length){o._colorInput=new k(o._colorgradientInputs,f({},e,{tabindex:0}));o._colorInput.bind("change",function(e){o._updateUI(e.value,true)});o._colorInput.bind("select",function(e){var t=c(e.value);o._select(t);o.trigger("forceSelect",{value:o.value()})})}},_hsvArea:function(){var c=this,e=c.wrapper,t=e.find(".k-hsv-rectangle"),o=t.find(".k-draghandle").attr("tabIndex",0).on(s,g(c._hsvKeydown,c)),i=this.value();if(i&&i.indexOf("rgba")>-1)i=i.replace("rgba","RGBA");if(!this._hsvDragAriaTemplate)this._hsvDragAriaTemplate=l.template(this.options.hsvDragARIATemplate);o.attr("aria-label",this._hsvDragAriaTemplate(i||""));function a(e,t){var o=this.offset,i=e-o.left,a=t-o.top,n=this.width,r=this.height,s,l;i=i<0?0:i>n?n:i;a=a<0?0:a>r?r:a;s=i/n;l=1-a/r;c._svChange(s,l)}c._hsvEvents=new l.UserEvents(t,{global:true,press:function(e){this.offset=l.getOffset(t);this.width=t.width();this.height=t.height();o.focus();a.call(this,e.x.location,e.y.location)},start:function(){t.addClass("k-dragging");o.focus()},move:function(e){e.preventDefault();a.call(this,e.x.location,e.y.location)},end:function(){t.removeClass("k-dragging")}});c._hsvRect=t;c._hsvHandle=o},_hsvKeydown:function(i){var a=this;function e(e,t){var o=a._getHSV();o[e]+=t*(i.shiftKey?.01:.05);if(o[e]<0)o[e]=0;if(o[e]>1)o[e]=1;a._updateUI(o);_(i)}function t(e){var t=a._getHSV();t.h+=e*(i.shiftKey?1:5);if(t.h<0)t.h=0;if(t.h>359)t.h=359;a._updateUI(t);_(i)}switch(i.keyCode){case n.LEFT:if(i.ctrlKey)t(-1);else e("s",-1);break;case n.RIGHT:if(i.ctrlKey)t(1);else e("s",1);break;case n.UP:e(i.ctrlKey&&a._opacitySlider?"a":"v",1);break;case n.DOWN:e(i.ctrlKey&&a._opacitySlider?"a":"v",-1);break;case n.ENTER:a._select(a._getHSV());break;case n.F2:a._colorInput.element.find("input").trigger("focus").select();break;case n.ESC:a._cancel();break}},_onEnable:function(e){var t=this.wrapper;this._hueSlider.enable(e);if(this._opacitySlider)this._opacitySlider.enable(e);t.find("input").attr("disabled",!e);if(this.options._standalone)if(e)t.removeAttr("aria-disabled");else t.attr("aria-disabled",true)},_reset:function(){var e=this;if(e._colorInput)e._colorInput.reset();e._resetHsv();e._resetColorContrast()},_resetColorContrast:function(){var e=this,t=e.options.contrastTool;if(e._contrastTool.length)e._updateColorContrast(t.backgroundColor?c(t.backgroundColor):c(p))},_resetHsv:function(){var e=this,t=c(u);e._updateHsv(t)},_sliders:function(){var t=this,e=t.wrapper,o=e.find(".k-hue-slider"),i=e.find(".k-alpha-slider");function a(e){t._updateUI(t._getHSV(e.value,null,null,null))}o.attr("aria-label","hue");t._hueSlider=o.kendoSlider({min:0,max:360,tickPlacement:"none",showButtons:false,orientation:"vertical",slide:a,change:a}).data("kendoSlider");function n(e){t._updateUI(t._getHSV(null,null,null,e.value/100))}i.attr("aria-label","opacity");t._opacitySlider=i.kendoSlider({min:0,max:100,tickPlacement:"none",showButtons:false,orientation:"vertical",slide:n,change:n}).data("kendoSlider")},_svChange:function(e,t){var o=this._getHSV(null,e,t,null);this._updateUI(o)},_updateColorContrast:function(e){var t=this,o=t.options.contrastTool,i=o.backgroundColor?c(o.backgroundColor):c(p),a=C.getContrastFromTwoRGBAs(c(e.toCssRgba()),i),n=l.template('<div class="k-contrast-ratio">'+'<span class="k-contrast-ratio-text">#:messages.contrastRatio# #:kendo.toString(ratio, "n2")#</span>'+'<span class="k-contrast-validation k-text-success">'+"#if (ratio > 4.5) {#"+'<span class="k-icon k-i-check"></span>'+"#}#"+"#if (ratio > 7) {#"+'<span class="k-icon k-i-check"></span>'+"#}#"+"</span></div>"),r=l.template("<div>"+"<span>#:level#: #:limit# </span>"+"#if (ratio > limit) {#"+'<span class="k-contrast-validation k-text-success">#:messages.pass# <span class="k-icon k-i-check"></span></span>'+"#} else {#"+'<span class="k-contrast-validation k-text-error">#:messages.fail# <span class="k-icon k-i-close"></span></span>'+"#}#"+"</div>"),s="";s+=n({messages:t.options.messages,ratio:a});s+=r({messages:t.options.messages,ratio:a,limit:4.5,level:"AA"});s+=r({messages:t.options.messages,ratio:a,limit:7,level:"AAA"});t._contrastTool.find(".k-contrast-ratio, div").remove();t._contrastTool.append(s);t._updateContrastSvg(i)},_updateContrastSvg:function(e){var t=this,o=t._hsvRect,i="k-color-contrast-svg",a={width:o.width(),height:o.height()},n;if(!a.width||!a.height)return;n=r(C.renderSvgCurveLine(a,t._getHSV(),e)).addClass(i);o.find("."+i).remove();o.append(n)},_updateHsv:function(e){var t=this,o=t._hsvRect;e=e.toHSV();t._hsvHandle.css({left:e.s*o.width()+"px",top:(1-e.v)*o.height()+"px"});t._hueElements.css(v,d.fromHSV(e.h,1,1,1).toCss());t._hueSlider.value(e.h);if(t._opacitySlider){t._opacitySlider.wrapper.find(".k-slider-track").css("background","linear-gradient(to top, transparent, "+d.fromHSV(e.h,1,1,1).toCss());t._opacitySlider.value(100*e.a)}t._updateHsvAria(e.s,e.v)},_updateHsvAria:function(e,t){var o=this.value();if(o&&o.indexOf("rgba")>-1)o=o.replace("rgba","RGBA");this._hsvHandle.attr({"aria-label":this._hsvDragAriaTemplate(o||""),"aria-valuenow":Math.round(e*100),"aria-valuetext":"saturation: "+Math.round(e*100)+"%, value: "+Math.round(t*100)+"%"})},_updateUI:function(e,t){var o=this;if(!e){o._reset();return}if(!t&&o._colorInput)o._colorInput.value(e);o._triggerSelect(e);o._updateHsv(e);if(o._contrastTool.length)o._updateColorContrast(e)},_wrapper:function(){var e=this.options,t;if(this.element.is("input"))t=this.element.addClass("k-hidden").wrap("<div>").parent();else t=this.element;t.addClass("k-colorgradient").attr({role:"textbox","aria-keyshortcuts":"Enter"}).append(this._template(e));this._hueElements=r(".k-hsv-rectangle, .k-alpha-slider .k-slider-track",t);this._colorgradientInputs=r(".k-colorgradient-inputs",t);this._contrastTool=r(".k-colorgradient-color-contrast",t);this.wrapper=t},destroy:function(){this._hsvEvents.destroy();this._hueSlider.destroy();if(this._opacitySlider)this._opacitySlider.destroy();if(this._colorInput)this._colorInput.destroy();this._hueSlider=this._opacitySlider=this._hsvRect=this._hsvHandle=this._hueElements=this._selectedColor=this._colorAsText=this._contrastTool=null;a.fn.destroy.call(this)}});return e.plugin(b),window.kendo})}("function"==typeof define&&define.amd?define:function(e,t,o){(o||t)()}),function(define){define("colorpicker/colorpalette.min",["kendo.core.min"],function(){var i=window.kendo.jQuery,o=void 0,a=window.kendo,e=a.ui,r=a.parseColor,s=a.keys,l=".",u="background-color",c="k-selected",d="k-focus",p="k-colorpalette-tile",f="000000,7f7f7f,880015,ed1c24,ff7f27,fff200,22b14c,00a2e8,3f48cc,a349a4,ffffff,c3c3c3,b97a57,ffaec9,ffc90e,efe4b0,b5e61d,99d9ea,7092be,c8bfe7",v="FFFFFF,FFCCFF,FF99FF,FF66FF,FF33FF,FF00FF,CCFFFF,CCCCFF,CC99FF,CC66FF,CC33FF,CC00FF,99FFFF,99CCFF,9999FF,9966FF,9933FF,9900FF,FFFFCC,FFCCCC,FF99CC,FF66CC,FF33CC,FF00CC,CCFFCC,CCCCCC,CC99CC,CC66CC,CC33CC,CC00CC,99FFCC,99CCCC,9999CC,9966CC,9933CC,9900CC,FFFF99,FFCC99,FF9999,FF6699,FF3399,FF0099,CCFF99,CCCC99,CC9999,CC6699,CC3399,CC0099,99FF99,99CC99,999999,996699,993399,990099,FFFF66,FFCC66,FF9966,FF6666,FF3366,FF0066,CCFF66,CCCC66,CC9966,CC6666,CC3366,CC0066,99FF66,99CC66,999966,996666,993366,990066,FFFF33,FFCC33,FF9933,FF6633,FF3333,FF0033,CCFF33,CCCC33,CC9933,CC6633,CC3333,CC0033,99FF33,99CC33,999933,996633,993333,990033,FFFF00,FFCC00,FF9900,FF6600,FF3300,FF0000,CCFF00,CCCC00,CC9900,CC6600,CC3300,CC0000,99FF00,99CC00,999900,996600,993300,990000,66FFFF,66CCFF,6699FF,6666FF,6633FF,6600FF,33FFFF,33CCFF,3399FF,3366FF,3333FF,3300FF,00FFFF,00CCFF,0099FF,0066FF,0033FF,0000FF,66FFCC,66CCCC,6699CC,6666CC,6633CC,6600CC,33FFCC,33CCCC,3399CC,3366CC,3333CC,3300CC,00FFCC,00CCCC,0099CC,0066CC,0033CC,0000CC,66FF99,66CC99,669999,666699,663399,660099,33FF99,33CC99,339999,336699,333399,330099,00FF99,00CC99,009999,006699,003399,000099,66FF66,66CC66,669966,666666,663366,660066,33FF66,33CC66,339966,336666,333366,330066,00FF66,00CC66,009966,006666,003366,000066,66FF33,66CC33,669933,666633,663333,660033,33FF33,33CC33,339933,336633,333333,330033,00FF33,00CC33,009933,006633,003333,000033,66FF00,66CC00,669900,666600,663300,660000,33FF00,33CC00,339900,336600,333300,330000,00FF00,00CC00,009900,006600,003300,000000",t=".kendoColorTools",h="focus"+t,C="click"+t,_="keydown"+t,g="blur"+t,n=e.colorpicker.ColorSelector;function k(e){e.preventDefault()}function b(e,t){return function(){return e.apply(t,arguments)}}function m(e,t,o){e=Array.prototype.slice.call(e);var i=e.length;var a=e.indexOf(t);if(a<0)return o<0?e[i-1]:e[0];a+=o;if(a<0)a+=i;else a%=i;return e[a]}var w=n.extend({init:function(e,t){var o=this;n.fn.init.call(o,e,t);o._tabIndex=this.element.attr("tabindex")||0;o._wrapper();t=o.options;o._selectedID=(t.ariaId||a.guid())+"_selected";o._ariaTemplate=a.template(o.options.ARIATemplate);if(o._value){o._updateUI(o._value);o.wrapper.find(l+d).removeClass(d)}o.wrapper.attr("aria-label",o._ariaTemplate(o.value()||""));o._attachEvents()},focus:function(){if(this.wrapper&&!this.wrapper.is("[unselectable='on']"))this.wrapper.trigger("focus")},options:{name:"ColorPalette",columns:10,tileSize:null,palette:"basic"},_attachEvents:function(){var t=this;t.wrapper.on(C,l+p,function(e){t._select(e.currentTarget)}).on(_,b(t._keydown,t)).on(g,function(){t.wrapper.find(l+p).removeClass(d)}).on(h,b(t._focus,t))},_colors:function(){var e=this.options,t=e.palette||"basic";if(t=="websafe"){t=v;e.columns=18}else if(t=="basic")t=f;if(typeof t=="string")t=t.split(",");if(Array.isArray(t))t=i.map(t,function(e){return r(e)});return t},_current:function(e){this.wrapper.find(l+p).removeClass(d).removeAttr("id");i(e).addClass(d).attr("id",this._selectedID);this.wrapper.removeAttr("aria-activedescendant").attr("aria-activedescendant",this._selectedID)},_focus:function(){var e=this.wrapper,t=e.find("#"+this._selectedID);if(t.length===0)this._current(e.find(l+p).first())},_keydown:function(e){var t,o=this.wrapper,i=o.find(l+p),a=i.filter(l+d).get(0)||i.filter(l+c).get(0),n=e.keyCode,r;if(a)r=Array.prototype.indexOf.call(a.parentNode.children,a);if(n==s.LEFT)t=a?a.previousSibling:i[i.length-1];else if(n==s.RIGHT)t=a?a.nextSibling:i[0];else if(n==s.DOWN)t=a?a.parentNode.nextSibling?a.parentNode.nextSibling.children[r]:null:i[0];else if(n==s.UP)t=a?a.parentNode.previousSibling?a.parentNode.previousSibling.children[r]:null:i.get[i.length-1];else if(n==s.ENTER){k(e);if(a){this._select(a);this.trigger("forceSelect",{value:this.value()});return}}else if(n==s.ESC)this._cancel();if(t&&t.nodeType!==1)t=null;if(t){k(e);this._current(t)}},_onEnable:function(e){if(this.options._standalone)if(e){this.wrapper.attr("tabindex",this._tabIndex);this.wrapper.removeAttr("aria-disabled")}else{this.wrapper.removeAttr("tabindex");this.wrapper.attr("aria-disabled",true)}},_select:function(e){var t=this,o=t.wrapper.find(l+p);e=i(e);n.fn._select.call(t,e.css(u));o.removeClass(c).removeAttr("aria-selected");e.addClass(c).attr("aria-selected",true)},_template:a.template('<div class="k-colorpalette-table-wrap">'+'<table class="k-colorpalette-table k-palette" role="presentation"><tr role="row">'+"# for (var i = 0; i < colors.length; ++i) { #"+"# var selected = colors[i].equals(value); #"+'# if (i && i % columns == 0) { # </tr><tr role="row"> # } #'+'<td role="gridcell" unselectable="on" style="background-color:#= colors[i].toCss() #"'+'#= selected ? " aria-selected=true" : "" # '+'#=(id && i === 0) ? "id=\\""+id+"\\" " : "" # '+'class="k-colorpalette-tile#= selected ? " '+c+'" : "" #" '+'aria-label="#= colors[i].toCss() #"></td>'+"# } #"+"</tr></table></div>"),_tileSize:function(){var e=this.options.tileSize,t,o;if(e){if(/number|string/.test(typeof e))t=o=parseFloat(e);else if(typeof e=="object"){t=parseFloat(e.width);o=parseFloat(e.height)}else throw new Error("Unsupported value for the 'tileSize' argument");this.wrapper.find(l+p).css({width:t,height:o})}},_updateUI:function(t){var o=null,e=this.wrapper.find(l+p);this.wrapper.find(l+p).each(function(){var e=r(i(this).css(u));if(e&&e.equals(t)){o=this;return false}});this._current(o);e.removeClass(c);if(o){i(o).addClass(c);this.wrapper.attr("aria-label",this._ariaTemplate(this.value()||""))}},_wrapper:function(){var e=this.options,t=this._colors(),o;if(this.element.is("input"))o=this.element.addClass("k-hidden").wrap("<div>").parent();else o=this.element;o.addClass("k-colorpalette").attr("role","grid").append(i(this._template({colors:t,columns:e.columns,tileSize:e.tileSize,value:this._value,id:e.ariaId}))).attr("tabindex",this._tabIndex);this.wrapper=o;this._tileSize()}});return e.plugin(w),window.kendo})}("function"==typeof define&&define.amd?define:function(e,t,o){(o||t)()}),function(define){define("colorpicker/flatcolorpicker.min",["./colorgradient.min","./colorpalette.min","kendo.html.button.min"],function(){var r=window.kendo.jQuery,o=void 0,a=window.kendo,e=a.ui,i=a.html,p=a.Color,n=r.extend,s="background-color",u,f=".kendoColorTools",t="click"+f,v="keydown"+f,l=e.colorpicker.ColorSelector,h=a.keys,c="k-no-color",C="k-selected",d=".k-color-preview-mask",_="aria-pressed",g="aria-disabled",k={gradient:e.ColorGradient,palette:e.ColorPalette};function b(e,t){return function(){return e.apply(t,arguments)}}var m=l.extend({init:function(e,t){var o=this;if(t&&t.autoupdate===false)t._standalone=false;l.fn.init.call(o,e,t);t=o.options=a.deepExtend({},o.options,t);e=o.element;o._wrapper();var i=o.color();o._changeView(t.view);o._setViewSize();if(i){o._updateUI(i);o._previousColor.children(d).css(s,i.toDisplay());o._selectedColor.children(d).css(s,i.toDisplay())}else{o._selectedColor.addClass(c);o._previousColor.addClass(c)}o._attachEvents();o._navigation()},destroy:function(){var e=this;l.fn.destroy.call(this);if(e._view){e._view.destroy();e._viewsContainer.empty()}e.element.off(f);e._selectedColor=e._previousColor=e._viewsContainer=e._view=null},options:{name:"FlatColorPicker",opacity:false,buttons:false,input:true,preview:true,clearButton:false,format:"hex",formats:["rgb","hex"],view:"gradient",views:["gradient","palette"],palette:null,autoupdate:true,backgroundColor:null,columns:10,tileSize:24,messages:{apply:"Apply",cancel:"Cancel",noColor:"no color",clearColor:"Clear color",previewInput:null,contrastRatio:"Contrast ratio:",fail:"Fail",pass:"Pass",hex:"HEX",toggleFormat:"Toggle format",red:"Red",green:"Green",blue:"Blue",alpha:"Alpha",gradient:"Gradient view",palette:"Palette view"},size:"medium",_otOfPicker:true},setBackgroundColor:function(e){var t=this;if(t._view&&t._view.setBackgroundColor)t._view.setBackgroundColor(e)},_attachEvents:function(){var o=this;o.wrapper.on(v,b(o._keydown,o)).on(t,".k-coloreditor-reset",function(){o._clearColor=true;o._updateUI(null);o._view.value(null)}).on(t,".k-coloreditor-apply",function(){if(o._clearColor)o._select(null);else o._select(o._view.color())}).on(t,".k-coloreditor-cancel",function(){delete o._clearColor;o._updateUI(o.color());o._cancel()}).on(t,".k-button[data-view]",function(e){var t=r(e.target).closest("[data-view]");if(t.is("."+C))return;o.wrapper.find(".k-button[data-view]").removeClass(C).attr(_,false);t.addClass(C).attr(_,true);o._changeView(t.data("view"))})},_select:function(e){var t=this;l.fn._select.call(t,e);t._updatePreviousColor(e)},_updatePreviousColor:function(e){var t=this;if(e){t._previousColor.removeClass(c);t._previousColor.children(d).css(s,e.toDisplay())}else{t._previousColor.addClass(c);t._previousColor.children(d).css(s,"")}},_changeView:function(e){var t=this,o=r.extend({},t.options),i=k[e],a,n;if(t._view&&t._view._colorInput)t.options.format=t._view._colorInput._viewModel.format;t.options.view=e;delete o.name;delete o.change;delete o.select;delete o.cancel;delete o._standalone;if(t._view){a=t._view.color();t._view.destroy();t._viewsContainer.empty()}if(a){a=a.toHSV();n=p.fromHSV(t._cachedHue||0,a.s,a.v,a.a);t._cachedHue=a.toHSV().h;a=a.equals(n)?n:a}o._otOfPicker=false;if(i){t._view=new k[e](r("<div></div>").appendTo(t._viewsContainer),o);t._view.value(a);t._view.bind("change",function(e){delete t._clearColor;t._updateUI(e.sender.color(),true)});t._view.bind("forceSelect",function(e){delete t._clearColor;t._select(e.sender.color())})}},_onEnable:function(e){var t=this;if(t._view)t._view._onEnable(e);if(t.options._standalone)if(e)t.wrapper.removeAttr(g);else t.wrapper.attr(g,true)},focus:function(){var e=this;if(e._view)e._view.focus()},_updateUI:function(e,t){var o=this;if(e&&e.toDisplay){o._selectedColor.removeClass(c);o._selectedColor.children(d).css(s,e.toDisplay())}else{o._selectedColor.addClass(c);o._selectedColor.children(d).css(s,"")}o._triggerSelect(e);if(o.options.autoupdate)o._updatePreviousColor(e);if(!t)o._view.value(e)},_setViewSize:function(){var e=this,t=e.wrapper[0],o=parseInt(e.options.tileSize.width||e.options.tileSize,10),i=parseInt(e.options.tileSize.width||e.options.tileSize,10),a=e.options.columns;t.style.setProperty("--kendo-color-preview-columns",a);t.style.setProperty("--kendo-color-preview-width",o+"px");t.style.setProperty("--kendo-color-preview-height",i+"px")},_keydown:function(e){if(e.keyCode==h.ESC)this._cancel()},_template:function(){var e=this,t=e.options,o=n({},t,{fillMode:"flat",themeColor:"base",rounded:"medium"});return a.template('<div class="k-coloreditor-header k-hstack">'+"# if (views && views.length > 1) { #"+'<div class="k-coloreditor-header-actions k-hstack">'+'<div role="group" class="k-button-group k-button-group-flat">'+i.renderButton('<button aria-pressed="false" data-view="gradient" title="#:messages.gradient#"></button>',n({icon:"color-canvas"},o))+i.renderButton('<button aria-pressed="false" data-view="palette" title="#:messages.palette#"></button>',n({icon:"palette"},o))+"</div>"+"</div>"+"# } #"+'<div class="k-spacer"></div>'+'<div class="k-coloreditor-header-actions k-hstack">'+"# if (clearButton) { #"+i.renderButton('<button class="k-coloreditor-reset" title="#:messages.clearColor#"></button>',n({icon:"reset-color"},o))+"# } #"+"# if (preview) { #"+'<div class="k-coloreditor-preview k-vstack">'+'<span class="k-coloreditor-preview-color k-color-preview">'+'<span class="k-color-preview-mask"></span>'+"</span>"+'<span class="k-coloreditor-current-color k-color-preview">'+'<span class="k-color-preview-mask"></span>'+"</span>"+"</div>"+"# } #"+"</div>"+"</div>"+'<div class="k-coloreditor-views k-vstack"></div>'+"# if (buttons) { #"+'<div class="k-coloreditor-footer k-actions k-hstack k-justify-content-end">'+i.renderButton('<button class="k-coloreditor-cancel" title="#:messages.cancel#">#: messages.cancel #</button>',n({},o,{fillMode:"solid"}))+i.renderButton('<button class="k-coloreditor-apply" title="#:messages.apply#">#: messages.apply #</button>',n({},o,{fillMode:"solid",themeColor:"primary"}))+"</div>"+"# } #")(t)},_wrapper:function(){var e=this.options,t;if(this.element.is("input"))t=this.element.addClass("k-hidden").wrap("<div>").parent();else t=this.element;t.addClass("k-flatcolorpicker k-coloreditor").attr({role:"textbox","aria-keyshortcuts":"Enter"}).append(this._template());this._selectedColor=r(".k-coloreditor-preview-color",t);this._previousColor=r(".k-coloreditor-current-color",t);this._viewsContainer=r(".k-coloreditor-views",t);t.find(".k-button[data-view="+e.view+"]").addClass(C).attr(_,true);this.wrapper=t}});return e.plugin(m),window.kendo})}("function"==typeof define&&define.amd?define:function(e,t,o){(o||t)()}),function(define){define("kendo.colorpicker.min",["kendo.core.min","kendo.color.min","kendo.popup.min","kendo.slider.min","kendo.userevents.min","kendo.button.min","kendo.binder.min","kendo.textbox.min","kendo.numerictextbox.min","kendo.html.button.min","./colorpicker/colorselector.min","./colorpicker/flatcolorpicker.min"],function(){var i={id:"colorpicker",name:"Color tools",category:"web",description:"Color selection widgets",depends:["core","color","popup","slider","userevents","button","binder","textbox","numerictextbox","html.button"]},s=window.kendo.jQuery,p=void 0,l=window.kendo,e=l.ui,c=e.Widget,u=l.Color,d=l.parseColor,o=l.keys,f="background-color",v={apply:"Apply",cancel:"Cancel",noColor:"no color",clearColor:"Clear color",previewInput:null,contrastRatio:"Contrast ratio:",fail:"Fail",pass:"Pass",hex:"HEX",toggleFormat:"Toggle format",red:"Red",green:"Green",blue:"Blue",alpha:"Alpha",gradient:"Gradient view",palette:"Palette view"},a=".kendoColorTools",n="click"+a,h="keydown"+a,t=e.colorpicker.ColorSelector,C=e.FlatColorPicker,_=c.extend({init:function(e,t){var o=this;if(t&&t.palette&&!t.view)t.view="palette";c.fn.init.call(o,e,t);t=o.options=l.deepExtend({},o.options,t);e=o.element;var i=e.attr("value")||e.val();if(i)i=d(i,true);else i=d(t.value,true);o._value=t.value=i;var a=l.html.renderButton('<button class="k-input-button" unselectable="on" aria-label="select" tabindex="-1"></button>',s.extend({},o.options,{icon:"arrow-s"}));var n=o._inputWrapper=o.wrapper=s(o._template(s.extend({},o.options,{_buttonHtml:a})));o._applyCssClasses();e.hide().after(n);if(e.is("input")){e.appendTo(n);o._preventDefaultLabelClick()}o._tabIndex=e.attr("tabIndex")||0;o.enable(!e.attr("disabled"));var r=e.attr("accesskey");if(r){e.attr("accesskey",null);n.attr("accesskey",r)}o.bind("activate",function(e){if(!e.isDefaultPrevented())o.toggle()});o._updateUI(i)},destroy:function(){this.wrapper.off(a).find("*").off(a);if(this._popup){this._selector.destroy();this._popup.destroy()}this._selector=this._popup=this.wrapper=null;c.fn.destroy.call(this)},enable:function(e){var t=this,o=t.wrapper,i=o.find(".k-input-button");if(arguments.length===0)e=true;t.element.attr("disabled",!e);o.attr("aria-disabled",!e);i.off(a).on("mousedown"+a,r);o.addClass("k-disabled").removeAttr("tabIndex").add("*",o).off(a);if(e)o.removeClass("k-disabled").attr("tabIndex",t._tabIndex).on("mouseenter"+a,function(){o.addClass("k-hover")}).on("mouseleave"+a,function(){o.removeClass("k-hover")}).on("focus"+a,function(){o.addClass("k-focus")}).on("blur"+a,function(){o.removeClass("k-focus")}).on(h,g(t._keydown,t)).on(n,".k-input-button",g(t.toggle,t)).on(n,".k-input-inner",function(){t.trigger("activate")});else t.close()},_template:l.template('<span role="textbox" aria-haspopup="true" class="k-colorpicker k-picker k-icon-picker">'+'<span  class="k-input-inner">'+'<span class="k-value-icon k-color-preview #: toolIcon ? "k-icon-color-preview" : "" #">'+"# if (toolIcon) { #"+'<span class="k-color-preview-icon k-icon #= toolIcon #"></span>'+"# } #"+'<span class="k-color-preview-mask"></span>'+"</span>"+"</span >"+"#= _buttonHtml #"+"</span>"),options:{name:"ColorPicker",closeOnSelect:false,contrastTool:false,palette:null,columns:10,toolIcon:null,value:null,messages:v,opacity:false,buttons:true,preview:true,clearButton:false,input:true,format:"hex",formats:["rgb","hex"],view:"gradient",views:["gradient","palette"],backgroundColor:null,ARIATemplate:'Current selected color is #=data || "none"#',size:"medium",rounded:"medium",fillMode:"solid"},events:["activate","change","select","open","close"],open:function(){if(!this.element.prop("disabled"))this._getPopup().open()},close:function(){var e=this._selector&&this._selector.options||{};e._closing=true;this._getPopup().close();delete e._closing},toggle:function(){if(!this.element.prop("disabled"))this._getPopup().toggle()},setBackgroundColor:function(e){var t=this,o=function(){t._selector.setBackgroundColor(e)};t.options.contrastTool.backgroundColor=e;if(t._selector&&(t._popup&&t._popup.visible()))t._selector.setBackgroundColor(e);else if(t._popup){t._popup.unbind("activate",o);t._popup.bind("activate",o)}},_noColorIcon:function(){return this.wrapper.find(".k-color-preview")},color:t.fn.color,value:t.fn.value,_select:t.fn._select,_triggerSelect:t.fn._triggerSelect,_isInputTypeColor:t.fn._isInputTypeColor,_preventDefaultLabelClick:function(){var t=this,e=t.element,o=e.closest("label"),i=e.attr("id");if(i)o=o.add('label[for="'+i+'"]');o.on("click",function(e){t.open();e.preventDefault()})},_updateUI:function(e,t){this._updateInput(e);this._triggerSelect(e);this.wrapper.find(".k-color-preview-mask").css(f,e?e.toDisplay():"");this._noColorIcon().toggleClass("k-no-color",!e);if(this._selector&&!t)this._selector.value(e)},_updateInput:function(e){var t="";if(e){if(this._isInputTypeColor()||e.a==1)t=e.toCss();else t=e.toCssRgba();this.element.val(t)}if(!this._ariaTemplate)this._ariaTemplate=l.template(this.options.ARIATemplate);this.wrapper.attr("aria-label",this._ariaTemplate(t))},_keydown:function(e){var t=e.keyCode;if(this._getPopup().visible()){if(t==o.ESC)this._selector._cancel();else this._selector._keydown(e);r(e)}else if(t==o.ENTER||t==o.DOWN){this.open();r(e)}},_getPopup:function(){var i=this,e=i._popup;if(!e){var t=i.options;var o;o=C;t.autoupdate=t.buttons!==true;delete t.select;delete t.change;delete t.cancel;t._otOfPicker=false;var a=l.guid();var n=s('<div id="'+a+'" class="k-colorpicker-popup"></div>').appendTo(document.body);var r=i._selector=new o(s("<div></div>").appendTo(n),t);i.wrapper.attr("aria-owns",a);i._popup=e=n.kendoPopup({anchor:i.wrapper,adjustSize:{width:5,height:0}}).data("kendoPopup");r.bind({select:function(e){i._updateUI(d(e.value),true)},change:function(e){if(i.options.buttons)i._select(r.color());else i._updateUI(d(e.value),true);if(i.options.buttons||i._selector.options.view==="palette"&&i.options.closeOnSelect)i.close()},cancel:function(){i.close()}});e.bind({close:function(e){if(i.trigger("close")){e.preventDefault();return}i.wrapper.removeClass("k-focus");var t=r.color();if(!i.options.buttons)i._select(t);else i._select(i.color());t=i.color();if(t&&t.h)i._cachedHue=t.h;var o=event&&event instanceof MouseEvent&&s(event.target).parents(".k-colorpicker-popup").length===0;if(!o)setTimeout(function(){if(i.wrapper&&!i.wrapper.is("[unselectable='on']"))i.wrapper.trigger("focus")},0)},open:function(e){if(i.trigger("open"))e.preventDefault();else i.wrapper.addClass("k-focus")},activate:function(){var e,t=i.color();if(t){t=t.toHSV();e=u.fromHSV(i._cachedHue||0,t.s,t.v,t.a);t=t.equals(e)?e:t}r.value(t);r.focus();i.wrapper.addClass("k-focus")}})}return e}});function r(e){e.preventDefault()}function g(e,t){return function(){return e.apply(t,arguments)}}return e.plugin(_),l.cssProperties.registerPrefix("ColorPicker","k-picker-"),l.cssProperties.registerValues("ColorPicker",[{prop:"rounded",values:l.cssProperties.roundedValues.concat([["full","full"]])}]),window.kendo})}("function"==typeof define&&define.amd?define:function(e,t,o){(o||t)()});
//# sourceMappingURL=kendo.colorpicker.min.js.map
