/**
 * Kendo UI v2022.3.913 (http://www.telerik.com/kendo-ui)
 * Copyright 2022 Progress Software Corporation and/or one of its subsidiaries or affiliates. All rights reserved.
 *
 * Kendo UI commercial licenses may be obtained at
 * http://www.telerik.com/purchase/license-agreement/kendo-ui-complete
 * If you do not own a commercial license, this file shall be governed by the trial license terms.
 */
!function(define){define("kendo.gantt.data.min",["kendo.data.min","kendo.treelist.min"],function(){var o={id:"gantt.data",name:"GanttData",category:"web",description:"The Gantt Data.",depends:["data","treelist"],hidden:true},f=window.kendo.jQuery,l=void 0,c=Array.isArray,t=f.extend,h=f.map,e=kendo.data,d=e.Query,i=e.DataSource,r=e.TreeListDataSource,p=e.TreeListModel,v="parentId",m=function(r,a){return function(e){e=c(e)?{data:e}:e;var t=e||{};var n=t.data;t.data=n;if(!(t instanceof r)&&t instanceof i)throw new Error("Incorrect DataSource type. Only "+a+" instances are supported");return t instanceof r?t:new r(t)}},g=function(e){if(e.filter("[name=end], [name=start], [name=plannedEnd], [name=plannedStart]").length){var t=e.attr("name"),n=kendo.widgetInstance(e,kendo.ui),r={},a=e,i,d;while(a!==window&&!i){a=a.parent();i=a.data("kendoEditable")}d=i?i.options.model:null;if(!d)return true;if(t.indexOf("planned")>=0){r.plannedStart=d.plannedStart;r.plannedEnd=d.plannedEnd}else{r.start=d.start;r.end=d.end}r[t]=n?n.value():kendo.parseDate(e.val());if(t.indexOf("planned")>=0)return r.plannedStart<=r.plannedEnd;else return r.start<=r.end}return true},n=kendo.data.Model.define({id:"id",fields:{id:{type:"number",editable:false},predecessorId:{type:"number"},successorId:{type:"number"},type:{type:"number"}}}),a=i.extend({init:function(e){i.fn.init.call(this,t(true,{},{schema:{modelBase:n,model:n}},e))},dependencies:function(e){var t=this.predecessors(e),n=this.successors(e);t.push.apply(t,n);return t},predecessors:function(e){return this._dependencies("successorId",e)},successors:function(e){return this._dependencies("predecessorId",e)},_dependencies:function(e,t){var n=this.view();var r={field:e,operator:"eq",value:t};n=new d(n).filter(r).toArray();return n}}),s=(a.create=m(a,"GanttDependencyDataSource"),p.define({fields:{id:{type:"number",editable:false},parentId:{type:"number",defaultValue:null,validation:{required:true},nullable:true},orderId:{type:"number",validation:{required:true}},title:{type:"string",defaultValue:"New task"},start:{type:"date",validation:{required:true}},end:{type:"date",validation:{required:true,dateCompare:g,message:"End date should be after or equal to the start date"}},percentComplete:{type:"number",validation:{required:true,min:0,max:1,step:.01}},summary:{type:"boolean"},expanded:{type:"boolean",defaultValue:true},plannedStart:{type:"date",defaultValue:null,nullable:true},plannedEnd:{type:"date",defaultValue:null,nullable:true,validation:{dateCompare:g,message:"Planned end date should be after or equal to the planned start date"}}},duration:function(){var e=this.end,t=this.start;return e-t},plannedDuration:function(){var e=this.plannedEnd,t=this.plannedStart;if(e&&t)return e-t;return 0},isMilestone:function(){return this.duration()===0},_offset:function(e){var t=["start","end"],n;for(var r=0;r<t.length;r++){n=new Date(this.get(t[r]).getTime()+e);this.set(t[r],n)}},_offsetPlanned:function(e){var t=["plannedStart","plannedEnd"],n;for(var r=0;r<t.length;r++){n=new Date(this.get(t[r]).getTime()+e);this.set(t[r],n)}}})),u=(s.define=function(e,t){if(t===l){t=e;e=s}var n=t.parentId||v;t.parentIdField=n;var r=p.define(e,t);if(n)r.parentIdField=n;return r},r.extend({init:function(e){r.fn.init.call(this,t(true,{},{schema:{modelBase:s,model:s},sort:{field:"orderId",dir:"asc"}},e))},add:function(e){if(!e)return;e=this._toGanttTask(e);return this.insert(this.taskSiblings(e).length,e)},insert:function(e,t){if(!t)return;t=this._toGanttTask(t);t.set("orderId",e);t=i.fn.insert.call(this,e,t);this._reorderSiblings(t,this.taskSiblings(t).length-1);this._resolveSummaryFields(this.taskParent(t));return t},remove:function(e){var t=e.get("parentId"),n=this.taskAllChildren(e);this._removeItems(n);e=r.fn.remove.call(this,e);this._childRemoved(t,e.get("orderId"));return e},taskAllChildren:function(e){var n=[],r=this;var a=function(e){var t=r.taskChildren(e);n.push.apply(n,t);h(t,a)};if(!!e)a(e);else n=this.view();return n},taskChildren:function(e,t){var n={field:"parentId",operator:"eq",value:null};var r=this._sort&&this._sort.length?this._sort:{field:"orderId",dir:"asc"};var a,i;if(t)i=this.view();else i=this.data();if(!!e){a=e.get("id");if(a===l||a===null||a==="")return[];n.value=a}i=new d(i).filter(n).sort(r).toArray();return i},taskLevel:function(e){var t=0,n=this.taskParent(e);while(n!==null){t+=1;n=this.taskParent(n)}return t},taskParent:function(e){if(!e||e.get("parentId")===null)return null;return this.get(e.parentId)},taskSiblings:function(e){if(!e)return null;var t=this.taskParent(e);return this.taskChildren(t)},taskTree:function(e){var t=[],n,r=this.taskChildren(e,true);for(var a=0,i=r.length;a<i;a++){n=r[a];t.push(n);if(n.get("expanded")){var d=this.taskTree(n);t.push.apply(t,d)}}return t},update:function(e,t){var i=this,r;var a=function(e,t){var n=i.taskAllChildren(e);for(var r=0,a=n.length;r<a;r++)n[r]._offset(t)};var d=function(e,t){var n=i.taskAllChildren(e);for(var r=0,a=n.length;r<a;r++)n[r]._offsetPlanned(t)};var n=function(e){var t=e.field,n=e.sender;switch(t){case"start":i._resolveSummaryStart(i.taskParent(n));a(n,n.get(t).getTime()-r.getTime());break;case"end":i._resolveSummaryEnd(i.taskParent(n));break;case"plannedStart":i._resolveSummaryPlannedStart(i.taskParent(n));if(n.get(t)&&r)d(n,n.get(t).getTime()-r.getTime());break;case"plannedEnd":i._resolveSummaryPlannedEnd(i.taskParent(n));break;case"percentComplete":i._resolveSummaryPercentComplete(i.taskParent(n));break;case"orderId":i._reorderSiblings(n,r);break}};if(t.parentId!==l){r=e.get("parentId");if(r!==t.parentId){e.set("parentId",t.parentId);i._childRemoved(r,e.get("orderId"));e.set("orderId",i.taskSiblings(e).length-1);i._resolveSummaryFields(i.taskParent(e))}delete t.parentId}e.bind("change",n);e.bind("equalSet",n);for(var s in t){r=e.get(s);if(s==="plannedStart"||s==="plannedEnd"){if(r!==l||t[s]!==null)e.set(s,t[s])}else if(s==="start"||s==="end")e.set(s,t[s]);else if(e.get(s)!==t[s])e.set(s,t[s])}e.unbind("change",n);e.unbind("equalSet",n)},_childRemoved:function(e,t){var n=e===null?null:this.get(e),r=this.taskChildren(n);for(var a=t,i=r.length;a<i;a++)r[a].set("orderId",a);this._resolveSummaryFields(n)},_resolveSummaryFields:function(e){if(!e)return;this._updateSummary(e);if(!this.taskChildren(e).length)return;this._resolveSummaryStart(e);this._resolveSummaryEnd(e);this._resolveSummaryPlannedStart(e);this._resolveSummaryPlannedEnd(e);this._resolveSummaryPercentComplete(e)},_resolveSummaryStart:function(e){var d=this;var t=function(e){var t=d.taskChildren(e);var n=t[0].start.getTime();var r;for(var a=1,i=t.length;a<i;a++){r=t[a].start.getTime();if(r<n)n=r}return new Date(n)};this._updateSummaryRecursive(e,"start",t)},_resolveSummaryEnd:function(e){var d=this;var t=function(e){var t=d.taskChildren(e);var n=t[0].end.getTime();var r;for(var a=1,i=t.length;a<i;a++){r=t[a].end.getTime();if(r>n)n=r}return new Date(n)};this._updateSummaryRecursive(e,"end",t)},_resolveSummaryPlannedStart:function(e){var d=this;var t=function(e){var t=d.taskChildren(e),n=null,r;for(var a=0,i=t.length;a<i;a++)if(t[a].plannedStart){r=t[a].plannedStart.getTime();if(!n||r<n)n=r}if(!n)return null;return new Date(n)};this._updateSummaryRecursive(e,"plannedStart",t)},_resolveSummaryPlannedEnd:function(e){var d=this;var t=function(e){var t=d.taskChildren(e),n=null,r;for(var a=0,i=t.length;a<i;a++)if(t[a].plannedEnd){r=t[a].plannedEnd.getTime();if(!n||r>n)n=r}if(!n)return null;return new Date(n)};this._updateSummaryRecursive(e,"plannedEnd",t)},_resolveSummaryPercentComplete:function(e){var r=this;var t=function(e){var t=r.taskChildren(e);var n=new d(t).aggregate([{field:"percentComplete",aggregate:"average"}]);return n.percentComplete.average};this._updateSummaryRecursive(e,"percentComplete",t)},_reorderSiblings:function(e,t){var n=e.get("orderId"),r=n>t,a=r?t:n,i=r?n:t,d=r?a:a+1,s=this.taskSiblings(e);if(!s.length)return;i=Math.min(i,s.length-1);for(var l=a;l<=i;l++){if(s[l]===e)continue;s[l].set("orderId",d);d+=1}},_toGanttTask:function(e){if(!(e instanceof s)){var t=e;e=i.fn._createNewModel.call(this);e.accept(t)}return e},_updateSummary:function(e){if(e!==null){var t=this.taskChildren(e).length;e.set("summary",t>0)}},_updateSummaryRecursive:function(e,t,n){if(!e)return;var r=n(e);e.set(t,r);var a=this.taskParent(e);if(a)this._updateSummaryRecursive(a,t,n)}}));return u.create=m(u,"GanttDataSource"),t(true,kendo.data,{GanttDataSource:u,GanttTask:s,GanttDependencyDataSource:a,GanttDependency:n}),window.kendo})}("function"==typeof define&&define.amd?define:function(e,t,n){(n||t)()});
//# sourceMappingURL=kendo.gantt.data.min.js.map
