/**
 * Kendo UI v2022.3.913 (http://www.telerik.com/kendo-ui)
 * Copyright 2022 Progress Software Corporation and/or one of its subsidiaries or affiliates. All rights reserved.
 *
 * Kendo UI commercial licenses may be obtained at
 * http://www.telerik.com/purchase/license-agreement/kendo-ui-complete
 * If you do not own a commercial license, this file shall be governed by the trial license terms.
 */
!function(define){define("kendo.tabstrip.min",["kendo.data.min"],function(){var e={id:"tabstrip",name:"TabStrip",category:"web",description:"The TabStrip widget displays a collection of tabs with associated tab content.",depends:["data"],features:[{id:"tabstrip-fx",name:"Animation",description:"Support for animation",depends:["fx"]}]},h=window.kendo.jQuery,a=void 0,g=window.kendo,r,o=g.keys,s=h.map,l=h.each,c=g.trim,_=h.extend,m=g.isFunction,t=g.template,f=g._outerWidth,x=g._outerHeight,i=g.ui.Widget,n=/^(a|div)$/i,d=".kendoTabStrip",p="img",b="href",v="prev",G="next",y="show",k="k-link",U="k-last",T="click",A="error",S=":empty",E="k-image",I="k-first",P="select",B="activate",R="k-tabstrip-content k-content",H="contentUrl",W="mouseenter",F="mouseleave",N="contentLoad",u="k-disabled",w="k-active",D="k-focus",q="k-hover",C="k-tab-on-top",L=".k-item:not(."+u+")",z=".k-item",M=".k-tabstrip-items > "+L+":not(."+w+")",j=200,O="aria-hidden",Q="aria-controls",V="aria-disabled",X="aria-selected",J="aria-orientation",$="aria-labelledby",K={content:t("<div class='k-tabstrip-content k-content' #= contentAttributes(data) # tabindex='0'>#= content(item) #</div>"),itemWrapper:t("<#= tag(item) # class='k-link' #= contentUrl(item) # #= textAttributes(item) #>"+"#= image(item) ##= sprite(item) ##= text(item) #"+"</#= tag(item) #>"),item:t("<li class='#= wrapperCssClass(group, item) #' role='tab' #=item.active ? \"aria-selected='true'\" : ''#>"+"#= itemWrapper(data) #"+"</li>"),image:t("<img class='k-image' alt='' src='#= imageUrl #' />"),sprite:t("<span class='k-sprite #= spriteCssClass #'></span>"),empty:t("")},Y={wrapperCssClass:function(t,e){var r=["k-tabstrip-item","k-item"],n=e.index;if(e.enabled===false)r.push("k-disabled");if(n===0)r.push("k-first");if(n==t.length-1)r.push("k-last");return r.join(" ")},textAttributes:function(t){return t.url?" href='"+t.url+"'":""},text:function(t){return t.encoded===false?t.text:g.htmlEncode(t.text)},tag:function(t){return t.url?"a":"span"},contentAttributes:function(t){return t.active!==true?" style='display:none' aria-hidden='true'":""},content:function(t){return t.content?t.content:t.contentUrl?"":"&nbsp;"},contentUrl:function(t){return t.contentUrl?g.attr("content-url")+'="'+t.contentUrl+'"':""}};function Z(t){t.children(p).addClass(E);t.children("a").addClass(k).children(p).addClass(E);t.filter("li[disabled]").addClass(u).attr(V,"true").prop("disabled",false);t.filter(":not([class*=k-state])").children("a").filter(":focus").parent().addClass(w+" "+C);t.attr("role","tab");t.filter("."+w).attr(X,true);t.each(function(){var t=h(this);if(!t.children("."+k).length)t.contents().filter(function(){return!this.nodeName.match(n)&&!(this.nodeType==3&&!c(this.nodeValue))}).wrapAll("<span UNSELECTABLE='on' class='"+k+"'/>")})}function tt(t){var e=t.children(".k-item");e.filter(".k-first:not(:first-child)").removeClass(I);e.filter(".k-last:not(:last-child)").removeClass(U);e.filter(":first-child").addClass(I);e.filter(":last-child").addClass(U)}function et(t,e){return"<span class='k-button k-button-md k-rounded-md k-button-flat k-button-flat-base k-icon-button k-tabstrip-"+t+"' unselectable='on'><span class='k-button-icon k-icon "+e+"'></span></span>"}var rt=i.extend({init:function(t,e){var r=this,n;i.fn.init.call(r,t,e);r._animations(r.options);e=r.options;r._contentUrls=e.contentUrls||[];r._wrapper();r._isRtl=g.support.isRtl(r.wrapper);r._tabindex();r._updateClasses();r._dataSource();r.tabGroup.attr("role","tablist");if(e.dataSource)r.dataSource.fetch();r._tabPosition();r._scrollable();r._processContentUrls();r._attachEvents();if(r.options.value)n=r.options.value;r._initialActivate();r.value(n);g.notify(r)},events:[P,B,y,A,N,"change","dataBinding","dataBound"],options:{name:"TabStrip",dataEncodedField:"",dataTextField:"",dataContentField:"",dataImageUrlField:"",dataUrlField:"",dataSpriteCssClass:"",dataContentUrlField:"",tabPosition:"top",animation:{open:{effects:"expand:vertical fadeIn",duration:200},close:{duration:200}},collapsible:false,navigatable:true,contentUrls:false,scrollable:{distance:j}},setDataSource:function(t){var e=this;e.options.dataSource=t;e._dataSource();e.dataSource.fetch()},setOptions:function(t){var e=this,r=e.options.animation;e._animations(t);if(t.contentUrls)e._contentUrls=t.contentUrls;t.animation=_(true,r,t.animation);if(t.navigatable)e.wrapper.on("keydown"+d,e._keyDownProxy);else e.wrapper.off("keydown"+d,e._keyDownProxy);i.fn.setOptions.call(e,t)},activateTab:function(t){if(this.tabGroup.children("[data-animating]").length)return;t=this.tabGroup.find(t);var e=this,r=e.options.animation,n=r.open,i=_({},r.close),d=i&&"effects"in i,a=t.parent().children(),s=a.filter("."+w),o=a.index(t),u=n&&"duration"in n&&"effects"in n;i=_(d?i:_({reverse:true},n),{hide:true});if(g.size(n.effects)){s.kendoRemoveClass(w,{duration:i.duration});t.kendoRemoveClass(q,{duration:i.duration})}else{s.removeClass(w);t.removeClass(q)}var f=e.contentAnimators;if(e.inRequest){e.xhr.abort();e.inRequest=false}if(f.length===0){e.tabGroup.find("."+C).removeClass(C);t.addClass(C).css("z-index");t.addClass(w);e._current(t);e.trigger("change");if(e._scrollableModeActive)e._scrollTabsToItem(t);return false}var l=f.filter("."+w),c=e.contentHolder(o),p=c.closest(".k-content");e.tabsHeight=x(e.tabGroup)+parseInt(e.wrapper.css("border-top-width"),10)+parseInt(e.wrapper.css("border-bottom-width"),10);if(c.length===0){l.removeClass(w).attr(O,true).kendoStop(true,true).kendoAnimate(i);return false}t.attr("data-animating",true);var h=(t.children("."+k).data(H)||e._contentUrls[o]||false)&&c.is(S),m=function(){s.removeAttr(X);t.attr(X,true);e._current(t);p.addClass(w).removeAttr(O).kendoStop(true,true).kendoAnimate(_({init:function(){e.trigger(y,{item:t[0],contentElement:c[0]});g.resize(c)}},n,{complete:function(){t.removeAttr("data-animating");e.trigger(B,{item:t[0],contentElement:c[0]});g.resize(c);if(u&&(g.support.browser.msie||g.support.browser.edge))c.finish().animate({opacity:.9},"fast","linear",function(){c.finish().animate({opacity:1},"fast","linear")})}}))},b=function(){if(!h){m();e.trigger("change")}else{t.removeAttr("data-animating");e.ajaxRequest(t,c,function(){t.attr("data-animating",true);m();e.trigger("change")})}if(e._scrollableModeActive)e._scrollTabsToItem(t)};var v=e.element.css("min-height");e.element.css("min-height",e.element.outerHeight());l.removeClass(w);e.tabGroup.find("."+C).removeClass(C);t.addClass(C).css("z-index");if(g.size(n.effects))t.kendoAddClass(w,{duration:n.duration});else t.addClass(w);l.attr(O,true);if(l.length)l.kendoStop(true,true).kendoAnimate(_({complete:b},i));else b();e.element.css("min-height",v);return true},ajaxRequest:function(i,a,s,o){i=this.tabGroup.find(i);var l=this,n=h.ajaxSettings.xhr,t=i.find("."+k),u={},e=i.width()/2,c=false,d=i.find(".k-loading").removeClass("k-complete");if(!d[0])d=h("<span class='k-loading'/>").prependTo(i);var f=e*2-d.width();var p=function(){d.animate({marginLeft:(parseInt(d.css("marginLeft"),10)||0)<e?f:0},500,p)};if(g.support.browser.msie&&g.support.browser.version<10)setTimeout(p,40);o=o||t.data(H)||l._contentUrls[i.index()]||t.attr(b);l.inRequest=true;var r={type:"GET",cache:false,url:o,dataType:"html",data:u,xhr:function(){var e=this,t=n(),r=e.progressUpload?"progressUpload":e.progress?"progress":false;if(t)h.each([t,t.upload],function(){if(this.addEventListener)this.addEventListener("progress",function(t){if(r)e[r](t)},false)});e.noProgress=!(window.XMLHttpRequest&&"upload"in new XMLHttpRequest);return t},progress:function(t){if(t.lengthComputable){var e=parseInt(t.loaded/t.total*100,10)+"%";d.stop(true).addClass("k-progress").css({width:e,marginLeft:0})}},error:function(t,e){if(l.trigger("error",{xhr:t,status:e}))this.complete()},stopProgress:function(){clearInterval(c);d.stop(true).addClass("k-progress")[0].style.cssText=""},complete:function(t){l.inRequest=false;if(this.noProgress)setTimeout(this.stopProgress,500);else this.stopProgress();if(t.statusText=="abort")d.remove()},success:function(t){d.addClass("k-complete");try{var e=this,r=10;if(e.noProgress){d.width(r+"%");c=setInterval(function(){e.progress({lengthComputable:true,loaded:Math.min(r,100),total:100});r+=10},40)}l.angular("cleanup",function(){return{elements:a.get()}});g.destroy(a);a.html(t)}catch(t){var n=window.console;if(n&&n.error)n.error(t.name+": "+t.message+" in "+o);this.error(this.xhr,"error")}if(s)s.call(l,a);l.angular("compile",function(){return{elements:a.get()}});l.trigger(N,{item:i[0],contentElement:a[0]})}};if(typeof o==="object"){r=h.extend(true,{},r,o);if(m(r.url))r.url=r.url()}l.xhr=h.ajax(r)},append:function(t){var r=this,n=r._create(t);l(n.tabs,function(t){var e=n.contents[t];r.tabGroup.append(this);if(r.options.tabPosition=="bottom")r.tabWrapper.before(e);else r.wrapper.append(e);r.angular("compile",function(){return{elements:[e]}})});tt(r.tabGroup);r._updateContentElements();r.resize(true);return r},contentElement:function(t){if(isNaN(t-0))return a;var e=this.contentElements&&this.contentElements[0]&&!g.kineticScrollNeeded?this.contentElements:this.contentAnimators;var r=h(this.tabGroup.children()[t]).attr(Q);if(e)for(var n=0,i=e.length;n<i;n++)if(e.eq(n).closest(".k-content")[0].id==r)return e[n];return a},contentHolder:function(t){var e=h(this.contentElement(t)),r=e.children(".km-scroll-container");return g.support.touch&&r[0]?r:e},deactivateTab:function(t){var e=this,r=e.options.animation,n=r.open,i=_({},r.close),a=i&&"effects"in i;t=e.tabGroup.find(t);i=_(a?i:_({reverse:true},n),{hide:true});if(g.size(n.effects))t.kendoRemoveClass(w,{duration:n.duration});else t.removeClass(w);t.removeAttr(X);e.contentAnimators.filter("."+w).kendoStop(true,true).kendoAnimate(i).removeClass(w).attr(O,true)},destroy:function(){var t=this;i.fn.destroy.call(t);if(t._refreshHandler)t.dataSource.unbind("change",t._refreshHandler);t.wrapper.off(d);t.tabGroup.off(d);if(t._scrollableModeActive){t._scrollPrevButton.off().remove();t._scrollNextButton.off().remove()}g.destroy(t.wrapper)},disable:function(t){this._toggleDisabled(t,false);return this},enable:function(t,e){this._toggleDisabled(t,e!==false);return this},insertAfter:function(t,n){if(h(t).is(h(n)))n=this.tabGroup.find(n).prev();else n=this.tabGroup.find(n);var i=this,a=i._create(t),s=i.element.find("[id='"+n.attr(Q)+"']");l(a.tabs,function(t){var e=a.contents[t];var r=a.newTabsCreated?i._contentUrls.length-(a.tabs.length-t):h(e).index()-1;n.after(this);s.after(e);i._moveUrlItem(r,h(this).index());i.angular("compile",function(){return{elements:[e]}})});tt(i.tabGroup);i._updateContentElements(a.newTabsCreated);i.resize(true);return i},insertBefore:function(t,n){if(h(t).is(h(n)))n=this.tabGroup.find(n).next();else n=this.tabGroup.find(n);var i=this,a=i._create(t),s=i.element.find("[id='"+n.attr(Q)+"']");l(a.tabs,function(t){var e=a.contents[t];var r=a.newTabsCreated?i._contentUrls.length-(a.tabs.length-t):h(e).index()-1;n.before(this);s.before(e);i._moveUrlItem(r,h(this).index());i.angular("compile",function(){return{elements:[e]}})});tt(i.tabGroup);i._updateContentElements(a.newTabsCreated);i.resize(true);return i},items:function(){return this.tabGroup[0].children},refresh:function(t){var e=this,r=e.options,n=g.getter(r.dataEncodedField),d=g.getter(r.dataTextField),u=g.getter(r.dataContentField),f=g.getter(r.dataContentUrlField),p=g.getter(r.dataImageUrlField),h=g.getter(r.dataUrlField),m=g.getter(r.dataSpriteCssClass),i,a=[],s,o,l=e.dataSource.view(),c;t=t||{};o=t.action;if(o)l=t.items;for(i=0,c=l.length;i<c;i++){s={text:d(l[i])};if(r.dataEncodedField)s.encoded=n(l[i]);if(r.dataContentField)s.content=u(l[i]);if(r.dataContentUrlField)s.contentUrl=f(l[i]);if(r.dataUrlField)s.url=h(l[i]);if(r.dataImageUrlField)s.imageUrl=p(l[i]);if(r.dataSpriteCssClass)s.spriteCssClass=m(l[i]);a[i]=s}if(t.action=="add")if(t.index<e.tabGroup.children().length)e.insertBefore(a,e.tabGroup.children().eq(t.index));else e.append(a);else if(t.action=="remove")for(i=0;i<l.length;i++)e.remove(t.index);else if(t.action=="itemchange"){i=e.dataSource.view().indexOf(l[0]);if(t.field===r.dataTextField)e.tabGroup.children().eq(i).find(".k-link").text(l[0].get(t.field));if(t.field===r.dataUrlField)e._contentUrls[i]=l[0].get(t.field)}else{e.trigger("dataBinding");e.remove("li");e._contentUrls=[];e.append(a);e.trigger("dataBound")}},reload:function(t){t=this.tabGroup.find(t);var n=this;var i=n._contentUrls;t.each(function(){var t=h(this),e=t.find("."+k).data(H)||i[t.index()],r=n.contentHolder(t.index());if(e)n.ajaxRequest(t,r,null,e)});return n},remove:function(t){var r=this;var e=typeof t;var n;if(e==="string")t=r.tabGroup.find(t);else if(e==="number")t=r.tabGroup.children().eq(t);n=t.map(function(){var t=h(this).index();var e=r.contentElement(t);g.destroy(e);r._removeUrlItem(t);return e});t.remove();n.empty();n.remove();r._updateContentElements();r.resize(true);return r},select:function(t){var r=this;if(arguments.length===0)return r.tabGroup.children("li."+w);if(!isNaN(t))t=r.tabGroup.children().get(t);t=r.tabGroup.find(t);h(t).each(function(t,e){e=h(e);if(!e.hasClass(w)&&!r.trigger(P,{item:e[0],contentElement:r.contentHolder(e.index())[0]}))r.activateTab(e)});return r},value:function(t){var e=this;if(t!==a){if(t!=e.value())e.tabGroup.children().each(function(){if(g.trim(h(this).text())==t)e.select(this)})}else return e.select().text()},_active:function(){var t=this.tabGroup.children().filter("."+w);t=t[0]?t:this._endItem("first");if(t[0])this._current(t)},_animations:function(t){if(t&&"animation"in t&&!t.animation)t.animation={open:{effects:{}},close:{effects:{}}}},_appendUrlItem:function(t){this._contentUrls.push(t)},_attachEvents:function(){var t=this,e=t.options;t.wrapper.on(W+d+" "+F+d,M,t._toggleHover).on("focus"+d,t._active.bind(t)).on("blur"+d,function(){t._current(null)});t._keyDownProxy=t._keydown.bind(t);if(e.navigatable)t.wrapper.on("keydown"+d,t._keyDownProxy);t.tabGroup.on(T+d,".k-disabled .k-link",false).on(T+d," > "+L,t._itemClick.bind(t))},_click:function(t){var e=this,r=t.find("."+k),n=r.attr(b),i=e.options.collapsible,a=t.index(),s=e.contentHolder(a),o,l,c=t.parent().children(),d=c.filter("."+D);if(t.closest(".k-widget")[0]!=e.wrapper[0])return;if(t.is("."+u+(!i?",."+w:""))){d.removeClass(D);e._focused=t;t.addClass(D);e._current(t);if(e._scrollableModeActive)e._scrollTabsToItem(t);return true}l=r.data(H)||e._contentUrls[a]||n&&(n.charAt(n.length-1)=="#"||n.indexOf("#"+e.element[0].id+"-")!=-1);o=!n||l;if(e.tabGroup.children("[data-animating]").length)return o;if(e.trigger(P,{item:t[0],contentElement:s[0]}))return true;if(o===false)return;if(i&&t.is("."+w)){e.deactivateTab(t);return true}if(e.activateTab(t))o=true;return o},_create:function(r){var n=this,t,e,i,a=false;r=r instanceof g.data.ObservableArray?r.toJSON():r;if(h.isPlainObject(r)||Array.isArray(r)){r=Array.isArray(r)?r:[r];a=true;t=s(r,function(t,e){n._appendUrlItem(r[e].contentUrl||null);return h(rt.renderItem({group:n.tabGroup,item:_(t,{index:e})}))});e=s(r,function(t,e){if(typeof t.content=="string"||t.contentUrl)return h(rt.renderContent({item:_(t,{index:e})}))})}else{if(typeof r=="string"&&r[0]!="<")t=n.element.find(r);else t=h(r);e=h();t.each(function(){if(/k-tabstrip-items/.test(this.parentNode.className)){var t=n.element.find("[id='"+this.getAttribute(Q)+"']");i=t}else i=h("<div class='"+R+"'/>");e=e.add(i)});Z(t)}return{tabs:t,contents:e,newTabsCreated:a}},_current:function(t){var e=this,r=e._focused;if(t===a)return r;if(r)r.removeClass(D);if(t)if(!t.hasClass(w))t.addClass(D);e._focused=t},_dataSource:function(){var t=this;if(t.dataSource&&t._refreshHandler)t.dataSource.unbind("change",t._refreshHandler);else t._refreshHandler=t.refresh.bind(t);t.dataSource=g.data.DataSource.create(t.options.dataSource).bind("change",t._refreshHandler)},_elementId:function(t,e,r){var n=t.attr("id"),i=this.element.attr("id"),a=g.guid();if(!n||n.indexOf(i+"-")>-1){var s=(i||a)+"-";if(r)s+="tab-";return s+(e+1)}return n},_endItem:function(t){return this.tabGroup.children(L)[t]()},_getItem:function(t){return this.tabGroup.children(z)[t]()},_initialActivate:function(){var t=this,e=t.tabGroup.children("li."+w),r=t.contentHolder(e.index());if(e[0]&&r.length>0&&r[0].childNodes.length===0)t.activateTab(e.eq(0))},_item:function(t,e){var r;if(e===v)r="last";else r="first";if(!t)return this._endItem(r);t=t[e]();if(!t[0])t=this.tabGroup.children(z)[r]();if(t.hasClass(u))t.addClass(D);if(t.hasClass(u)||t.hasClass(w))this._focused=t;return t},_itemClick:function(t){var e=this,r=e.wrapper[0];if(r!==document.activeElement){var n=g.support.browser.msie;if(n)try{r.setActive()}catch(t){r.focus()}else r.focus()}if(e._click(h(t.currentTarget)))t.preventDefault()},_keydown:function(t){var e=this,r=t.keyCode,n=e._current(),i=e._isRtl,a=/top|bottom/.test(e.options.tabPosition),s;if(t.target!=t.currentTarget||!n)return;if(r===o.DOWN&&!a)s=G;else if(r===o.UP&&!a)s=v;else if(r===o.RIGHT&&a)s=i?v:G;else if(r===o.LEFT&&a)s=i?G:v;else if(r==o.ENTER||r==o.SPACEBAR){e._click(n);t.preventDefault()}else if(r==o.HOME){e._click(e._getItem("first"));t.preventDefault();return}else if(r==o.END){e._click(e._getItem("last"));t.preventDefault();return}if(s){e._click(e._item(n,s));t.preventDefault()}},_moveUrlItem:function(t,e){this._contentUrls.splice(e,0,this._contentUrls.splice(t,1)[0])},_processContentUrls:function(){var n=this;if(n._contentUrls.length)n.tabGroup.children(".k-item").each(function(t,e){var r=n._contentUrls[t];if(typeof r==="string")h(e).find(">."+k).data(H,r)});else n._contentUrls.length=n.tabGroup.find("li.k-item").length},_removeUrlItem:function(t){this._contentUrls.splice(t,1)},_resize:function(){this._scrollable()},_scrollable:function(){var t=this,e=t.options,r,n,i,a;if(t._scrollableAllowed()){t.wrapper.addClass("k-tabstrip-scrollable");r=t.wrapper[0].offsetWidth;n=t.tabGroup[0].scrollWidth;if(n>r&&!t._scrollableModeActive){t._nowScrollingTabs=false;t._isRtl=g.support.isRtl(t.element);var s=g.support.touch?"touchstart":"mousedown";var o=g.support.touch?"touchend":"mouseup";var l=g.support.browser;var c=t._isRtl&&!l.msie&&!l.edge;t.tabWrapper.prepend(et("prev","k-i-arrow-60-left"));t.tabWrapper.append(et("next","k-i-arrow-60-right"));i=t._scrollPrevButton=t.tabWrapper.children(".k-tabstrip-prev");a=t._scrollNextButton=t.tabWrapper.children(".k-tabstrip-next");i.on(s+d,function(){t._nowScrollingTabs=true;t._scrollTabsByDelta(e.scrollable.distance*(c?1:-1))});a.on(s+d,function(){t._nowScrollingTabs=true;t._scrollTabsByDelta(e.scrollable.distance*(c?-1:1))});i.add(a).on(o+d,function(){t._nowScrollingTabs=false});t._scrollableModeActive=true;t._toggleScrollButtons()}else if(t._scrollableModeActive&&n<=r){t._scrollableModeActive=false;t.wrapper.removeClass("k-tabstrip-scrollable");t._scrollPrevButton.off().remove();t._scrollNextButton.off().remove()}else if(!t._scrollableModeActive)t.wrapper.removeClass("k-tabstrip-scrollable");else t._toggleScrollButtons()}},_scrollableAllowed:function(){var t=this.options;if(t.scrollable&&!t.scrollable.distance)t.scrollable={distance:j};return t.scrollable&&!isNaN(t.scrollable.distance)&&(t.tabPosition=="top"||t.tabPosition=="bottom")},_scrollTabsToItem:function(t){var e=this,r=e.tabGroup,n=g.scrollLeft(r),i=f(t),a=e._isRtl?t.position().left:t.position().left-r.children().first().position().left,s=r[0].offsetWidth,o=g.support.browser,l;if(e._isRtl&&(o.mozilla||o.webkit&&o.version>=85))n=n*-1;if(e._isRtl){if(a<0)l=n+a-(s-n);else if(a+i>s)l=n+a-i}else if(n+s<a+i)l=a+i-s;else if(n>a)l=a;r.finish().animate({scrollLeft:l},"fast","linear",function(){e._toggleScrollButtons()})},_scrollTabsByDelta:function(t){var e=this;var r=e.tabGroup;var n=g.scrollLeft(r);var i=g.support.browser;if(e._isRtl&&(i.mozilla||i.webkit&&i.version>=85))n=n*-1;r.finish().animate({scrollLeft:n+t},"fast","linear",function(){if(e._nowScrollingTabs&&!jQuery.fx.off)e._scrollTabsByDelta(t);else e._toggleScrollButtons()})},_tabPosition:function(){var t=this,e=t.options.tabPosition;t.wrapper.addClass("k-floatwrap k-tabstrip-"+e);if(e=="bottom")t.tabWrapper.appendTo(t.wrapper);if(e==="left"||e==="right")t.tabGroup.attr(J,"vertical");t.resize(true)},_toggleHover:function(t){h(t.currentTarget).toggleClass(q,t.type==W)},_toggleDisabled:function(t,e){t=this.tabGroup.find(t);t.each(function(){h(this).toggleClass(u,!e).attr(V,!e)})},_toggleScrollButtons:function(){var t=this,e=t.tabGroup,r=g.scrollLeft(e);t._scrollPrevButton.toggleClass("k-disabled",r===0);t._scrollNextButton.toggleClass("k-disabled",r===e[0].scrollWidth-e[0].offsetWidth)},_updateClasses:function(){var t=this,e,r,n;var i=/top|bottom/.test(t.options.tabPosition);t.wrapper.addClass("k-widget k-tabstrip");if(!t.tabGroup){t.tabGroup=t.wrapper.children("ul");t.tabGroup.wrap("<div />");t.tabWrapper=t.tabGroup.parent()}if(!t.tabGroup[0]){t.tabGroup=h("<ul />").prependTo(t.wrapper);t.tabGroup.wrap("<div />");t.tabWrapper=t.tabGroup.parent()}t.tabWrapper.addClass("k-tabstrip-items-wrapper");t.tabWrapper.addClass(i?"k-hstack":"k-vstack");t.tabGroup.addClass("k-tabstrip-items k-reset");e=t.tabGroup.find("li").addClass("k-tabstrip-item k-item");if(e.length){r=e.filter("."+w).index();n=r>=0?r:a;t.tabGroup.contents().filter(function(){return this.nodeType==3&&!c(this.nodeValue)}).remove()}if(r>=0)e.eq(r).addClass(C);t.contentElements=t.wrapper.children("div:not(.k-tabstrip-items-wrapper)");t.contentElements.addClass(R).eq(n).addClass(w).css({display:"block"});if(e.length){Z(e);tt(t.tabGroup);t._updateContentElements(true)}},_updateContentElements:function(i){var a=this,s=a._contentUrls,o=a.tabGroup.children(".k-item"),l=a.wrapper.children("div:not(.k-tabstrip-items-wrapper)"),c=a._elementId.bind(a);if(l.length&&o.length>l.length)l.each(function(t){var e=c(h(this),t),r=o.filter("[aria-controls="+(e||0)+"]")[0],n;if(!r&&i)r=o[t];if(r){r.setAttribute(Q,e);n=r.id=c(h(r),t,true);this.setAttribute($,n)}this.setAttribute("id",e)});else o.each(function(t){var e=l.eq(t),r=c(e,t),n;this.setAttribute(Q,r);n=this.id=c(h(this),t,true);if(!e.length&&s[t])h("<div class='"+R+"'/>").appendTo(a.wrapper).attr("id",r);else{e.attr("id",r);if(!h(this).children(".k-loading")[0]&&!s[t])h("<span class='k-loading k-complete'/>").prependTo(this)}e.attr("role","tabpanel");e.attr("tabindex","0");e.attr($,n);e.filter(":not(."+w+")").attr(O,true)});a.contentElements=a.contentAnimators=a.wrapper.children("div:not(.k-tabstrip-items-wrapper)");a.tabsHeight=x(a.tabGroup)+parseInt(a.wrapper.css("border-top-width"),10)+parseInt(a.wrapper.css("border-bottom-width"),10);if(g.kineticScrollNeeded&&g.mobile.ui.Scroller){g.touchScroller(a.contentElements);a.contentElements=a.contentElements.children(".km-scroll-container")}},_wrapper:function(){var t=this;if(t.element.is("ul"))t.wrapper=t.element.wrapAll("<div />").parent();else t.wrapper=t.element}});return _(rt,{renderItem:function(t){t=_({tabStrip:{},group:{}},t);var e=K.empty,r=t.item;return K.item(_(t,{image:r.imageUrl?K.image:e,sprite:r.spriteCssClass?K.sprite:e,itemWrapper:K.itemWrapper},Y))},renderContent:function(t){return K.content(_(t,Y))}}),g.ui.plugin(rt),window.kendo})}("function"==typeof define&&define.amd?define:function(t,e,r){(r||e)()});
//# sourceMappingURL=kendo.tabstrip.min.js.map
