/**
 * Kendo UI v2022.3.913 (http://www.telerik.com/kendo-ui)
 * Copyright 2022 Progress Software Corporation and/or one of its subsidiaries or affiliates. All rights reserved.
 *
 * Kendo UI commercial licenses may be obtained at
 * http://www.telerik.com/purchase/license-agreement/kendo-ui-complete
 * If you do not own a commercial license, this file shall be governed by the trial license terms.
 */
!function(define){define("kendo.tilelayout.min",["kendo.core.min","kendo.draganddrop.min","kendo.resizable.min"],function(){var t={id:"tilelayout",name:"TileLayout",category:"web",depends:["core"],features:[{id:"tilelayout-resizable",name:"Resizable",description:"Support for resizing",depends:["resizable"]},{id:"tilelayout-reorderable",name:"Reorderable",description:"Support for reordering",depends:["draganddrop"]}]},x=window.kendo.jQuery,v=window.kendo,e=v.ui,i=e.Widget,r=e.Draggable,n=v.keys,a=v.selectorFromClasses,o="resize",m="reorder",s=".kendoTileLayout",h="k-cursor-ns-resize",f="k-cursor-ew-resize",g="k-cursor-nwse-resize",y="k-cursor-nesw-resize",w="k-cursor-grab",d="k-cursor-grabbing",M=1,_="k-cursor-nesw-resize k-cursor-nwse-resize k-cursor-ew-resize k-cursor-ns-resize",l={wrapper:"k-widget k-tilelayout",item:"k-tilelayout-item k-card",itemHeader:"k-tilelayout-item-header k-card-header",itemHeaderTitle:"k-card-title",itemBody:"k-tilelayout-item-body k-card-body",reorderHint:"k-layout-item-hint k-layout-item-hint-reorder",resizeHint:"k-layout-item-hint k-layout-item-hint-resize"},I=i.extend({init:function(e,t){var r=this;i.fn.init.call(r,e,t);x.cssNumber.gridColumnStart=true;x.cssNumber.gridColumnEnd=true;x.cssNumber.gridRowStart=true;x.cssNumber.gridRowEnd=true;r.element=x(e).addClass(I.styles.wrapper);r._setWrapperStyles();r._initContainers();r._resizable();r._navigatable();r._reorderable()},events:[o,m],options:{name:"TileLayout",columns:null,gap:{columns:16,rows:16},containers:[],resizable:false,reorderable:false,navigatable:false,columnsWidth:"1fr",rowsHeight:"1fr",height:"",width:""},destroy:function(){i.fn.destroy.call(this);if(this._draggableInstance){this.element.find(".k-tilelayout-item").each(function(){var e=x(this);if(e.data("kendoDropTarget"))e.data("kendoDropTarget").destroy()});this._draggableInstance.destroy();this._draggableInstance=null}if(this.resizable){this.resizable.destroy();this.resizable=null}if(this.resizeHandle){this.resizeHandle.off(s).remove();this.resizeHandle=null}this.element.off(s)},setOptions:function(e){this.destroy();v.deepExtend(this.options,e);this.element.empty();this.init(this.element,this.options)},getOptions:function(){var e=x.extend(true,{},this.options);e.containers=v.deepExtend([],this.items);return e},_initContainers:function(){var i=this;var n=i.options.containers;var e=i.element.children();var c=!!e.length;var s;var t;var r;var a;var o;var d;var u;i.items=[];i.itemsMap={};if(c)e.each(function(e,t){s=v.guid();var r=x(t).addClass(I.styles.item).attr("id",s);i._addContainer(r,n[e],e,s)});else for(var l=0;l<n.length;l++){s=v.guid();d=n[l];t=x("<div></div>").addClass(I.styles.item).attr("id",s);a=d.header;if(a&&(a.template||a.text)){r=x("<div></div>").addClass(I.styles.itemHeader);if(i.options.reorderable)r.addClass(w);u=a.text?"<div class='"+I.styles.itemHeaderTitle+"'>"+a.text+"</div>":null;r.append(u||v.template(a.template)({}));r.appendTo(t)}o=x("<div></div>").addClass(I.styles.itemBody);if(!d.bodyTemplate)throw new Error("Having a bodyTemplate for the container is mandatory");o.append(v.template(d.bodyTemplate)({}));o.appendTo(t);t.appendTo(i.element);i._addContainer(t,d,l,s)}},_addContainer:function(e,t,r,i){var n=this;t.order=typeof t.order=="number"?t.order:r;e.attr(v.attr("index"),t.order);t.id=i;n._setContainerCoordinates(e,t);n.itemsMap[i]=t;n.items.push(n.itemsMap[i])},_setWrapperStyles:function(){var e=this;var t=e.options;e.element.css({"grid-template-columns":v.format("repeat({0}, minmax(0, {1}))",t.columns,typeof t.columnsWidth==="string"?t.columnsWidth:t.columnsWidth+"px"),"grid-auto-rows":v.format("minmax(0, {0})",typeof t.rowsHeight==="string"?t.rowsHeight:t.rowsHeight+"px"),"column-gap":t.gap.columns,width:typeof t.width==="string"?t.width:t.width+"px",height:typeof t.height==="string"?t.height:t.height+"px",padding:t.gap.rows+"px "+t.gap.columns+"px ","row-gap":t.gap.rows})},_setContainerCoordinates:function(e,t){if(!t)return;e.css({order:t.order,"grid-column-end":v.format("span {0}",t.colSpan),"grid-row-end":v.format("span {0}",t.rowSpan)}).attr(v.attr("index"),t.order)},_updateContainers:function(){var e=this;for(var t=0;t<e.items.length;t++)e._setContainerCoordinates(e.element.find("#"+e.items[t].id),e.items[t])},_createResizeHandle:function(e,t,r){var i=this;if(i._isresizing)return;if(i.resizeHandle&&i.resizeHandle.data("div")[0]!==e[0]){i.resizeHandle.off(s).remove();i.resizeHandle=null}if(!i.resizeHandle){i.resizeHandle=x('<div class="k-resize-handle"></div>');i.resizeHandle.appendTo(e)}i._positionResizeHandle(e,t,r)},_positionResizeHandle:function(e,t,r){var i=this;var c=parseFloat(e.css("borderRightWidth"));var u=parseFloat(e.css("borderBottomWidth"));var n=e.height();var s=e.width();var a=r?n-6.5-u:0;var p=t?s-4.5-c:0;var o=9;var d=9;var l;if(t&&r){d=o=25;a-=12.5;p-=12.5;l=v.support.isRtl(i.element)?y:g}else if(t&&!r){d=n;l=f}else if(!t&&r){o=s;l=h}i.resizeHandle.css({top:a,left:p,height:d,width:o}).attr("side",t).attr("down",r).removeClass(_).addClass(l).data("div",e).show()},_createResizeHint:function(e){var t=this;if(t.hint)return;var r=e.css("grid-column-end");var i=e.css("grid-row-end");var n=e.css("order");t.hint=x("<div class='"+I.styles.resizeHint+"'></div>").css({order:n,"grid-column-end":r,"grid-row-end":i}).insertAfter(e)},_removeResizeHint:function(){if(this._isresizing)return;if(this.hint){this.hint.remove();this.hint=null}},_positionHint:function(e,t){var r=this;if(e)r.hint.css("grid-column-end",v.format("span {0}",e));if(t)r.hint.css("grid-row-end",v.format("span {0}",t))},_removeAbsoluteStyles:function(e){e.css("position","");e.css("left","");e.css("top","");e.css("width","");e.css("height","");e.css("z-index","")},_positionAbsolutely:function(e){if(e.css("position")=="absolute")return;var t=e.position();var r=e.outerWidth();var i=e.outerHeight();e.css("position","absolute");e.css("left",t.left);e.css("top",t.top);e.css("width",r);e.css("height",i);e.css("z-index",2)},_navigatable:function(){if(!this.options.navigatable)return;var e=this;e.element.children().attr("tabindex",0);e.element.on("keydown"+s,e,e._keyDown.bind(e))},_keyDown:function(e){var t=x(e.target);var r=false;if(!t.is(".k-tilelayout-item.k-card"))return;if(e.ctrlKey&&e.keyCode==n.LEFT){r=true;this._resizeItem(t,"horizontal",-1)}if(e.ctrlKey&&e.keyCode==n.RIGHT){r=true;this._resizeItem(t,"horizontal",1)}if(e.ctrlKey&&e.keyCode==n.UP){r=true;this._resizeItem(t,"vertical",-1)}if(e.ctrlKey&&e.keyCode==n.DOWN){r=true;this._resizeItem(t,"vertical",1)}if(e.shiftKey&&e.keyCode==n.LEFT){r=true;this._reorderItem(t,-1)}if(e.shiftKey&&e.keyCode==n.RIGHT){r=true;this._reorderItem(t,1)}if(r)e.preventDefault()},_resizeItem:function(e,t,r){var i=this;var n=e.attr("id");var s;var a;if(!i.options.resizable)return;if(t==="horizontal"){s=parseInt(e.css("grid-column-end").replace("span",""),10)+r;a=i.element.css("grid-template-columns").split(" ").length;if(a>=s&&s>0){i.itemsMap[n].colSpan=s;e.css({"grid-column-end":v.format("span {0}",s)});i.trigger(o,{container:e})}}else{s=parseInt(e.css("grid-row-end").replace("span",""),10)+r;a=i.element.css("grid-template-rows").split(" ").length;if(a>=s&&s>0){i.itemsMap[n].rowSpan=s;e.css({"grid-row-end":v.format("span {0}",s)});i.trigger(o,{container:e})}}},_reorderItem:function(e,t){if(!this.options.reorderable)return;var r=parseInt(e.css("order"),10);var i=this.element.children().length;t=r+t;if(t>=0&&t<i){var n=this.element.find("> ["+v.attr("index")+"='"+t+"']");this.itemsMap[e.attr("id")].order=t;this.itemsMap[n.attr("id")].order=r;this._updateContainers();this._updateDOM();e.trigger("focus");this.trigger(m,{newIndex:t,oldIndex:r,container:e})}},_sortContainers:function(e){var n=v.attr("index");return e.sort(function(e,t){e=x(e);t=x(t);var r=e.attr(n);var i=t.attr(n);if(r===undefined)r=x(e).index();if(i===undefined)i=x(t).index();r=parseInt(r,10);i=parseInt(i,10);return r>i?1:r<i?-1:0})},_updateDOM:function(){var e=this;var t=e.element.children(":visible");t=e._sortContainers(t);t.each(function(){x(this).appendTo(e.element)})},_resizable:function(){var p=this;var h;var f;var v;var m;var g;var y;var H=0;var z=0;var w=0;var _=0;var b=0;var k=0;var C=0;var r;if(p.options.resizable){p.element.on("mousemove"+s,a(I.styles.item),function(e){var t;var r;var i=x(this);var n=i[0].getBoundingClientRect();t=Math.abs(n.right-e.clientX)<16;r=Math.abs(n.bottom-e.clientY)<16;if(t&&r)p._createResizeHandle(i,true,true);else if(t)p._createResizeHandle(i,true,false);else if(r)p._createResizeHandle(i,false,true)});p.resizable=new e.Resizable(p.element,{handle:"div.k-tilelayout-item > .k-resize-handle",start:function(e){var t=x(e.currentTarget);y=t.data("div");v=y.attr("id");h=t.attr("side");f=t.attr("down");r=p.element.css("grid-template-rows").split(" ").length;if(h){m=p._calculateFractionWidth();C=p._calculateRightEndSide(m);H=e.x.location;w=y.width();b=parseInt(y.css("grid-column-end").replace("span",""),10)}if(f){g=(p.element[0].scrollHeight-(r+1)*p.options.gap.rows)/r;z=e.y.location;_=y.height();k=parseInt(y.css("grid-row-end").replace("span",""),10)}p._isresizing=true},resize:function(e){var t=0;var r=0;var i=0;var n=0;var s;var a;var o=0;var d=0;var l=0;var c=p.element[0].getBoundingClientRect();var u=p.element[0].style.height?true:false;p._positionAbsolutely(y);p._createResizeHint(y);if(h=="true"){i=e.x.location-H;s=c.left+C-window.scrollX-e.x.location<p.options.gap.columns;a=w+i<m;if(!s&&!a){l=i/(m+p.options.gap.columns);o=i-Math.floor(l)*(m+p.options.gap.columns);t=b+Math.floor(l)+(o>=m/2?1:0);p.itemsMap[v].colSpan=Math.max(t,M)}else i=0}if(f=="true"){n=e.y.location-z;s=c.bottom+window.scrollY-e.y.location<p.options.gap.rows;a=_+n<=g;if(!a&&(!s||!u)){d=n/(g+p.options.gap.rows);o=n-Math.floor(d)*(g+p.options.gap.rows);r=k+Math.floor(d)+(o>=g/2?1:0);p.itemsMap[v].rowSpan=Math.max(r,M)}else n=0}p._positionHint(t,r);p._positionResizeHandle(y,h=="true",f=="true");if(n)y.css("height",_+n);if(i)y.css("width",w+i)},resizeend:function(){p._isresizing=false;p._setContainerCoordinates(y,p.itemsMap[v]);p._removeAbsoluteStyles(y);p._removeResizeHint();p.trigger(o,{container:y})}})}},_calculateFractionWidth:function(){var e=this;var t=e.element.children().first();var r=e.itemsMap[t.attr("id")].colSpan;var i=t.outerWidth();return(i-(r-1)*e.options.gap.columns)/r},_calculateRightEndSide:function(e){var t=this;var r=t.options.columns;var i=t.options.gap.columns;return r*(e+i)+i},_createDropHint:function(e){this.dropHint=x("<div class='"+I.styles.reorderHint+"'></div>").css({order:e.order,"grid-column-end":e.columnEnd,"grid-row-end":e.rowEnd}).attr(v.attr("index"),e.order).attr("direction",e.direction)},_insertDropHint:function(e,t){if(t=="right")this.dropHint.insertAfter(e);else this.dropHint.insertBefore(e)},_removeDropHint:function(){if(this.dropHint){this.dropHint.remove();this.dropHint=null}},_reorderable:function(){if(!this.options.reorderable)return;var p=this;var e=p.element;var h;var f=a(I.styles.item);var s=a(I.styles.itemHeader);var t=v.guid();this._draggableInstance=new r(this.element,{filter:s,autoScroll:true,ignore:":input",group:t,hint:function(e){var t=e.closest(f);var r=t.width();var i=t.height();var n=t.clone();n.find(s).removeClass(w).addClass(d);return n.width(r).height(i)},dragstart:function(e){h=x(e.currentTarget).closest(f)},drag:function(e){var t=v.elementUnderCursor(e);var r=e.sender.hint;var i;var n;var s;var a;var o;var d=p._draggableInstance.currentTarget.closest(f);var l;if(H(r[0],t)){r.hide();t=v.elementUnderCursor(e);if(!H(h[0],t)){if(p.dropHint&&p.dropHint[0]==t[0]){r.show();return}i=x(t);i=i.hasClass(I.styles.item)?i:i.closest(f);if(i.hasClass(I.styles.item)){n=i[0].getBoundingClientRect();s=e.clientX-n.left;a=n.right-e.clientX;o=s>a?"right":"left";l=i.css("order");if(p.dropHint&&p.dropHint.attr("direction")!==o){var c=p.dropHint.clone();c.css("order",l);p.dropHint.remove();p.dropHint=c;p._insertDropHint(i,o);p.dropHint.attr("direction",o).attr(v.attr("index"),l)}else if(!p.dropHint){var u=o=="right"?i.next():i.prev();if(u[0]!=h[0]){p._createDropHint({order:l,columnEnd:d.css("grid-column-end"),rowEnd:d.css("grid-row-end"),direction:o});h.hide();p._insertDropHint(i,o)}}}}r.show()}},dragend:function(e){if(!p.dropHint){e.sender.hint.remove();p._removeDropHint();return}var t=parseInt(p.dropHint.css("order"),10);var r=e.currentTarget.closest(f);var c=p.element.find(f);var i=parseInt(r.css("order"),10);var u=r.attr("id");var n=p.element.children(":visible");var s;var a;var o;var d;n=p._sortContainers(n);t=n.index(p.dropHint[0]);a=Math.max(t,i);s=Math.min(t,i);p.itemsMap[u].order=t;d=t>i?"right":"left";if(d=="left")a--;else s++;for(var l=s;l<=a;l++){o=c.filter("["+v.attr("index")+"='"+l+"']");p.itemsMap[o.attr("id")].order+=d=="left"?1:-1}r.show();p._updateContainers();e.sender.hint.remove();p._removeDropHint();if(p.options.navigatable)p._updateDOM();p.trigger(m,{newIndex:t,oldIndex:i,container:r})}});e.find(f).kendoDropTarget({group:t,dragenter:function(e){if(p._isresizing)return;var t=x(e.dropTarget);var r=p._draggableInstance.currentTarget.closest(f);var i;var n;var s;var a;var o;if(h[0]!=t[0]){i=t[0].getBoundingClientRect();n=e.clientX-i.left;s=i.right-e.clientX;o=n>s?"right":"left";a=o=="right"?t.next():t.prev();if(a[0]==h[0])return;p._removeDropHint();h.hide();p._createDropHint({order:t.css("order"),columnEnd:r.css("grid-column-end"),rowEnd:r.css("grid-row-end"),direction:o});h.hide();p._insertDropHint(t,o)}}})}});function H(e,t){try{return x.contains(e,t)||e==t}catch(e){return false}}return e.plugin(I),x.extend(true,I,{styles:l}),window.kendo})}("function"==typeof define&&define.amd?define:function(e,t,r){(r||t)()});
//# sourceMappingURL=kendo.tilelayout.min.js.map
