/**
 * Kendo UI v2022.3.913 (http://www.telerik.com/kendo-ui)
 * Copyright 2022 Progress Software Corporation and/or one of its subsidiaries or affiliates. All rights reserved.
 *
 * Kendo UI commercial licenses may be obtained at
 * http://www.telerik.com/purchase/license-agreement/kendo-ui-complete
 * If you do not own a commercial license, this file shall be governed by the trial license terms.
 */
!function(define){define("kendo.dialog.min",["kendo.core.min","kendo.popup.min","kendo.textbox.min"],function(){var e={id:"dialog",name:"Dialog",category:"web",description:"The dialog widget is a modal popup that brings information to the user.",depends:["core","popup","textbox"]},c=window.kendo.jQuery,o=void 0,s=window.kendo,a=s.ui.Widget,p=s.ui.Popup.TabKeyTrap,i=s.template,r=s.keys,f=s.isFunction,h="kendoWindow",v=".k-dialog",m=".k-window",_=".k-dialog-close",g="k-window-content k-dialog-content",k=".k-window-content",w="k-scroll",b="k-dialog-titleless",y=".k-dialog-title",x=".k-dialog-titlebar",l=".k-dialog-buttongroup",C=".k-button",O="k-alert",T="k-confirm",S="k-prompt",t=".k-input-inner",I=".k-overlay",d=":visible",H="zIndex",A="body",F="initOpen",D="touchstart",E="touchmove",R="open",z="close",W="show",M="hide",N={small:"k-window-sm",medium:"k-window-md",large:"k-window-lg"},B="hidden",j="overflow",K="original-overflow-rule",L="tap-y",P={okText:"OK",cancel:"Cancel",promptInput:"Input"},Y=Math.ceil,u,Q=":not(link,meta,script,style)";function V(e){return typeof e!="undefined"}function q(e,t,i){return Math.max(Math.min(parseInt(e,10),i===Infinity?i:parseInt(i,10)),parseInt(t,10))}function G(e){return e.keyCode==r.ENTER||e.keyCode==r.SPACEBAR}var J=a.extend({init:function(e,t){var i=this;a.fn.init.call(i,e,t);i._init(i.element,i.options);s.notify(i)},_init:function(e,t){var i=this,n;i._centerCallback=i._center.bind(i);i.appendTo=c(A);if(!V(t.visible)||t.visible===null)t.visible=e.is(d);if(i.wrapperTemplate===o)i.wrapperTemplate=u.wrapper;i._createDialog();n=i.wrapper=e.closest(v);if(t._defaultFocus===o)i._defaultFocus=e[0];i._tabindex(e);i._dimensions();this._tabKeyTrap=new p(n);if(!i.options.visible)i.wrapper.hide();else i._triggerOpen()},setOptions:function(e){var t=this;var i=t.options.size;e=c.extend(t.options,e);a.fn.setOptions.call(t,e);if(e.title!==o)t.title(e.title);if(e.content){s.destroy(t.element.children());t.element.html(e.content)}if(e.actions){t.wrapper.children(l).remove();t._createActionbar(t.wrapper)}t.wrapper.show();t._closable(t.wrapper);t.wrapper.removeClass(N[i]);t._dimensions();if(!e.visible)t.wrapper.hide();else t._triggerOpen();if(typeof e.modal!=="undefined"){var n=t.options.visible!==false;t._enableDocumentScrolling();t._overlay(e.modal&&n)}},_dimensions:function(){var e=this,t=e.wrapper,i=e.options,n=i.width,o=i.height,r=i.size,a=["minWidth","minHeight","maxWidth","maxHeight"];for(var s=0;s<a.length;s++){var l=i[a[s]];if(l&&l!=Infinity)t.css(a[s],l)}this._setElementMaxHeight();if(n)if(n.toString().indexOf("%")>0)t.width(n);else t.outerWidth(q(n,i.minWidth,i.maxWidth));if(o){if(o.toString().indexOf("%")>0)t.height(o);else t.outerHeight(q(o,i.minHeight,i.maxHeight));this._setElementHeight()}if(r&&N[r])t.addClass(N[r])},_setElementMaxHeight:function(){var e=this,t=e.element,i=e.options.maxHeight,n;if(i!=Infinity){n=parseFloat(i,10)-e._uiHeight();if(n>0)t.css({maxHeight:Y(n)+"px"})}},_setElementHeight:function(){var e=this,t=e.element,i=e.wrapper.outerHeight(true),n=parseFloat(i,10)-e._uiHeight();if(n<0)n=0;t.css({height:Y(n)+"px"});this._applyScrollClassName(t)},_applyScrollClassName:function(e){var t=e.get(0).scrollHeight>e.outerHeight();if(t)e.addClass(w);else e.removeClass(w)},_uiHeight:function(){var e=this,t=e.wrapper,i=t.children(l),n=i[0]&&i[0].offsetHeight||0,o=t.children(x),r=o[0]&&o[0].offsetHeight||0;return n+r},_overlay:function(e){var t=this.appendTo.children(I),i=this.wrapper;if(!t.length)t=c(u.overlay);t.insertBefore(i[0]).toggle(e).css(H,parseInt(i.css(H),10)-1);if(e)this._waiAriaOverlay();else this._removeWaiAriaOverlay();if(this.options.modal.preventScroll)this._stopDocumentScrolling();return t},_waiAriaOverlay:function(){var e=this.wrapper;this._overlayedNodes=e.prevAll(Q).add(e.nextAll(Q)).each(function(){var e=c(this);e.data("ariaHidden",e.attr("aria-hidden"));e.attr("aria-hidden","true")})},_removeWaiAriaOverlay:function(){return this._overlayedNodes&&this._overlayedNodes.each(function(){var e=c(this);var t=e.data("ariaHidden");if(t)e.attr("aria-hidden",t);else e.removeAttr("aria-hidden")})},_closeClick:function(e){e.preventDefault();this.close(false)},_closeKeyHandler:function(e){if(G(e)||e.keyCode==r.ESC)this.close(false)},_keydown:function(e){var t=this,i=t.options,n=e.keyCode;if(n==r.ESC&&!t._closing&&i.closable)t.close(false)},_createDialog:function(){var e=this,t=e.element,i=e.options,n=s.support.isRtl(t),o=c(u.titlebar(i)),r=(t.id||s.guid())+"_title",a=c(e.wrapperTemplate(i));a.toggleClass("k-rtl",n);t.addClass(g);e.appendTo.append(a);if(i.title!==false){a.append(o);o.attr("id",r);a.attr("aria-labelledby",r)}else a.addClass(b);e._closable(a);a.append(t);if(i.content){s.destroy(t.children());t.html(i.content)}if(i.actions.length)e._createActionbar(a)},_closable:function(e){var t=this;var i=t.options;var n=e.children(x);var o=n.find(".k-window-actions");var r=o.length?o.find(".k-dialog-close"):e.find(".k-dialog-close");r.remove();if(i.closable!==false){if(i.title!==false&&o.length)o.append(u.close(i));else e.prepend(u.close(i));e.autoApplyNS(h);t.element.autoApplyNS(h);e.find(_).on("click",t._closeClick.bind(t)).on("keydown",t._closeKeyHandler.bind(t));t.element.on("keydown",t._keydown.bind(t))}},_createActionbar:function(e){var t=this.options.buttonLayout==="stretched";var i=t?"stretch":"end";var n=c(u.actionbar({buttonLayout:i}));this._addButtons(n);e.append(n)},_addButtons:function(e){var t=this,i=t._actionClick.bind(t),n=t._actionKeyHandler.bind(t),o=t.options.actions,r=o.length,a,s;for(var l=0;l<r;l++){a=o[l];s=t._mergeTextWithOptions(a);c(u.action(a)).autoApplyNS(h).html(s).appendTo(e).addClass(a.cssClass).data("action",a.action).on("click",i).on("keydown",n)}},_mergeTextWithOptions:function(e){var t=e.text;return t?i(t)(this.options):""},_tabindex:function(e){var t=this;var i=t.wrapper;var n=i.find(_);var o=i.find(l+" "+C);a.fn._tabindex.call(this,e);var r=e.attr("tabindex");n.attr("tabIndex",r);o.attr("tabIndex",r)},_actionClick:function(e){if(this.wrapper.is(d))this._runActionBtn(e.currentTarget)},_actionKeyHandler:function(e){if(G(e)){e.preventDefault();this._runActionBtn(e.currentTarget)}else if(e.keyCode==r.ESC)this.close(false)},_runActionBtn:function(e){var t=this;if(t._closing)return;var i=c(e).data("action"),n=f(i)&&i({sender:t})===false;if(!n)t.close(false)},_triggerOpen:function(){var e=this;var t=e.options;var i=e.wrapper;e.toFront();e._triggerInitOpen();e.trigger(R);if(t.modal){e._overlay(i.is(d)).css({opacity:.5});e._focusDialog()}},open:function(){var e=this,t=e.wrapper,i=this._animationOptions(R),n=e.options,o,r;this._triggerInitOpen();if(!e.trigger(R)){if(e._closing)t.kendoStop(true,true);e._closing=false;e.toFront();n.visible=true;if(n.modal){r=!!e._modals().length;o=e._overlay(r);o.kendoStop(true,true);if(i.duration&&s.effects.Fade&&!r){var a=s.fx(o).fadeIn();a.duration(i.duration||0);a.endValue(.5);a.play()}else o.css("opacity",.5);o.show()}t.show().kendoStop().kendoAnimate({effects:i.effects,duration:i.duration,complete:e._openAnimationEnd.bind(e)});t.show()}return e},_animationOptions:function(e){var t=this.options.animation;var i={open:{effects:{}},close:{hide:true,effects:{}}};return t&&t[e]||i[e]},_openAnimationEnd:function(){if(this.options.modal)this._focusDialog();this.trigger(W)},_triggerInitOpen:function(){if(!V(this._initOpenTriggered)){this._initOpenTriggered=true;this.trigger(F)}},toFront:function(){var e=this,t=e.wrapper,o=+t.css(H),i=o;e.center();c(m).each(function(e,t){var i=c(t),n=i.css(H);if(!isNaN(n))o=Math.max(+n,o)});if(!t[0].style.zIndex||i<o)t.css(H,o+2);e.element.find("> .k-overlay").remove();t=null;return e},close:function(e){if(!arguments.length)e=true;this._close(e);this._stopCenterOnResize();return this},_close:function(e){var t=this,i=t.wrapper,n=t.options,o=this._animationOptions("open"),r=this._animationOptions("close");if(i.is(d)&&!t.trigger(z,{userTriggered:!e})){if(t._closing)return;t._closing=true;n.visible=false;this._removeOverlay();i.kendoStop().kendoAnimate({effects:r.effects||o.effects,reverse:r.reverse===true,duration:r.duration,complete:this._closeAnimationEnd.bind(this)})}return t},center:function(){this._center();this._centerOnResize()},_center:function(){var e=this,t=e.wrapper,i=c(window),n=0,o=0,r=o+Math.max(0,(i.width()-t.width())/2),a=n+Math.max(0,(i.height()-t.height()-parseInt(t.css("paddingTop"),10))/2);t.css({left:r,top:a});return e},_centerOnResize:function(){if(this._trackResize)return;s.onResize(this._centerCallback);this._trackResize=true},_stopCenterOnResize:function(){s.unbindResize(this._centerCallback);this._trackResize=false},_removeOverlay:function(){var e=this._modals();var t=this.options;var i=t.modal&&!e.length;if(i){this._overlay(false).remove();if(t.modal.preventScroll)this._enableDocumentScrolling()}else if(e.length){this._object(e.last())._overlay(true);if(t.modal.preventScroll)this._stopDocumentScrolling()}},_stopDocumentScrolling:function(){var e=this;var t=c("body");e._storeOverflowRule(t);t.css(j,B);var i=c("html");var n=i[0];e._storeOverflowRule(i);i.css(j,B);if(s.support.mobileOS.ios){n.addEventListener(D,e._touchStart,{passive:false});n.addEventListener(E,e._touchMove,{passive:false})}},_touchStart:function(e){c(this).data(L,e.changedTouches[0].pageY)},_touchMove:function(e){var t=e.target;var i=c(e.target);var n=e.changedTouches[0].pageY-c(this).data(L)>0;var o=i.is(k)&&(n&&i.scrollTop()===0)||!n&&i.scrollTop()===t.scrollHeight-t.clientHeight;if(!i.is(k)||o)e.preventDefault()},_enableDocumentScrolling:function(){var e=this;var t=c(document.body);var i=c("html");var n=i[0];e._restoreOverflowRule(t);e._restoreOverflowRule(i);if(s.support.mobileOS.ios){i.removeData(L);n.removeEventListener(D,e._touchStart,{passive:false});n.removeEventListener(E,e._touchMove,{passive:false})}},_storeOverflowRule:function(e){if(this._isOverflowStored(e))return;var t=e.get(0).style.overflow;if(typeof t==="string")e.data(K,t)},_isOverflowStored:function(e){return typeof e.data(K)==="string"},_restoreOverflowRule:function(e){var t=e.data(K);if(t!==null&&t!==o){e.css(j,t);e.removeData(K)}else e.css(j,"")},_closeAnimationEnd:function(){var e=this,t=e._previousFocus;e._closing=false;e.wrapper.hide().css("opacity","");e.trigger(M);if(e.options.modal){var i=e._object(e._modals().last());if(i)i.toFront();else if(t){e._previousFocus=null;setTimeout(function(){t.focus()})}}},_modals:function(){var t=this;var e=c(m).filter(function(){var e=t._object(c(this));return e&&e.options&&e.options.modal&&e.options.visible&&e.options.appendTo===t.options.appendTo&&!e.containment&&c(e.element).is(d)}).sort(function(e,t){return+c(e).css("zIndex")-+c(t).css("zIndex")});t=null;return e},_object:function(e){var t=e.children(k);var i=s.widgetInstance(t);if(i)return i;return o},destroy:function(){var e=this;e._destroy();a.fn.destroy.call(e);s.destroy(e.wrapper);e.wrapper.remove();e.wrapper=e.element=c()},_destroy:function(){var e=this;var t="."+h;e.wrapper.off(t);e.element.off(t);e.wrapper.find(_+","+l+" > "+C).off(t);e._stopCenterOnResize()},title:function(e){var t=this,i=t.wrapper,n=t.options,o=i.children(x),r=o.children(y),a=s.htmlEncode(e);if(!arguments.length)return r.html();if(e===false){o.remove();i.addClass(b)}else{if(!o.length){o=c(u.titlebar(n)).prependTo(i);r=o.children(y);i.removeClass(b)}r.html(a)}t.options.title=a;return t},content:function(e,i){var t=this,n=t.wrapper.children(k);if(!V(e))return n.html();this.angular("cleanup",function(){return{elements:n.children()}});s.destroy(n.children());n.html(e);this.angular("compile",function(){var e=[];for(var t=n.length;--t>=0;)e.push({dataItem:i});return{elements:n.children(),data:e}});t.options.content=e;return t},_focusDialog:function(){var e=this._object(this._modals().first());this._previousFocus=e&&e._previousFocus?e._previousFocus:document.activeElement;if(this._defaultFocus)this._focus(this._defaultFocus);this._tabKeyTrap.trap()},_focus:function(e){if(e)e.focus()},events:[F,R,z,W,M],options:{title:"",buttonLayout:"stretched",actions:[],modal:true,size:"auto",width:null,height:null,minWidth:0,minHeight:0,maxWidth:Infinity,maxHeight:Infinity,content:null,visible:null,appendTo:A,closable:true}}),U=J.extend({options:{name:"Dialog",messages:{close:"Close"}}}),n=(s.ui.plugin(U),J.extend({_init:function(e,t){var i=this;i.wrapperTemplate=u.alertWrapper;t._defaultFocus=null;i._ensureContentId(e);J.fn._init.call(i,e,t);i.bind(M,i.destroy.bind(i));i._ariaDescribedBy();i._initFocus()},_ensureContentId:function(e){var t=c(e);if(!t.attr("id"))t.attr("id",s.guid()+"_k-popup")},_ariaDescribedBy:function(){this.wrapper.attr("aria-describedby",this.element.attr("id"))},_initFocus:function(){var e=this.options;this._defaultFocus=this._chooseEntryFocus();if(this._defaultFocus&&e.visible&&e.modal)this._focusDialog()},_chooseEntryFocus:function(){return this.wrapper.find(l+" > "+C)[0]},options:{title:window.location.host,closable:false,messages:P}})),X=n.extend({_init:function(e,t){var i=this;n.fn._init.call(i,e,t);i.wrapper.addClass(O)},options:{name:"Alert",modal:true,actions:[{text:"#: messages.okText #"}]}}),Z=(s.ui.plugin(X),function(e){return c(u.alert).kendoAlert({content:e}).data("kendoAlert").open()}),$=n.extend({_init:function(e,t){var i=this;n.fn._init.call(i,e,t);i.wrapper.addClass(T);i.result=c.Deferred()},options:{name:"Confirm",modal:true,actions:[{text:"#: messages.okText #",primary:true,action:function(e){e.sender.result.resolve()}},{text:"#: messages.cancel #",action:function(e){e.sender.result.reject()}}]}}),ee=(s.ui.plugin($),function(e){var t=c(u.confirm).kendoConfirm({content:e}).data("kendoConfirm").open();return t.result}),te=n.extend({_init:function(e,t){var i=this;n.fn._init.call(i,e,t);i.wrapper.addClass(S);i._createPrompt();i.result=c.Deferred()},_createPrompt:function(){var e=this.options.value,t=c(u.promptInputContainer(this.options)).insertAfter(this.element);this.input=new s.ui.TextBox(t.find("input"));if(e)this.input.value(e);this._defaultFocus=this._chooseEntryFocus();this._focusDialog()},_chooseEntryFocus:function(){return this.wrapper.find(t)[0]},options:{name:"Prompt",modal:true,value:"",actions:[{text:"#: messages.okText #",primary:true,action:function(e){var t=e.sender,i=t.input.value();t.result.resolve(i)}},{text:"#: messages.cancel #",action:function(e){var t=e.sender,i=t.input.value();e.sender.result.reject(i)}}]}}),ie=(s.ui.plugin(te),function(e,t){var i=c(u.prompt).kendoPrompt({content:e,value:t}).data("kendoPrompt").open();return i.result});return u={wrapper:i("<div class='k-widget k-window k-dialog' role='dialog'></div>"),action:i("<button type='button' class='k-button k-button-md k-rounded-md k-button-solid # if (data.primary) { # k-button-solid-primary # } else { # k-button-solid-base # } #'></button>"),titlebar:i("<div class='k-window-titlebar k-dialog-titlebar k-hstack'>"+"<span class='k-window-title k-dialog-title'>#: title #</span>"+"<div class='k-window-actions k-dialog-actions k-hstack'></div>"+"</div>"),close:i("<a role='button' href='\\#' class='k-button k-button-md k-rounded-md k-button-flat k-button-flat-base k-icon-button k-window-action k-dialog-action k-dialog-close' title='#: messages.close #' aria-label='#: messages.close #' tabindex='-1'>"+"<span class='k-button-icon k-icon k-i-close'></span></a>"),actionbar:i("<div class='k-dialog-buttongroup k-actions k-hstack k-justify-content-#: buttonLayout #'></div>"),overlay:"<div class='k-overlay'></div>",alertWrapper:i("<div class='k-widget k-window k-dialog' role='alertdialog'></div>"),alert:"<div></div>",confirm:"<div></div>",prompt:"<div></div>",promptInputContainer:i("<div class='k-prompt-container'><input type='text' title='#: messages.promptInput #' aria-label='#: messages.promptInput #' /></div>")},s.alert=Z,s.confirm=ee,s.prompt=ie,window.kendo})}("function"==typeof define&&define.amd?define:function(e,t,i){(i||t)()});
//# sourceMappingURL=kendo.dialog.min.js.map
