/**
 * Kendo UI v2022.3.913 (http://www.telerik.com/kendo-ui)
 * Copyright 2022 Progress Software Corporation and/or one of its subsidiaries or affiliates. All rights reserved.
 *
 * Kendo UI commercial licenses may be obtained at
 * http://www.telerik.com/purchase/license-agreement/kendo-ui-complete
 * If you do not own a commercial license, this file shall be governed by the trial license terms.
 */
!function(define){define("kendo.scheduler.yearview.min",["kendo.scheduler.view.min","kendo.multiviewcalendar.min","kendo.tooltip.min"],function(){var e={id:"scheduler.yearview",name:"Scheduler Year View",category:"web",description:"The Scheduler Year View",depends:["scheduler.view","multiviewcalendar","tooltip"],hidden:true},d=window.kendo.jQuery,t=void 0,c=window.kendo,o=c.ui,i=o.SchedulerView,n=d.extend,a=c.template,f=c.date.firstDayOfYear,h=c.date.firstDayOfMonth,y=c.date.lastDayOfMonth,m="tabindex",_="day",r="navigate",l="keydown",D="activate",g="show",k="hide",w="click",u="focus",s=".",v=".kendoYearView",p={layout:"k-scheduler-layout k-scheduler-layout-flex k-scheduler-yearview",body:"k-scheduler-body",tooltip:"k-scheduler-tooltip",indicator:"k-day-indicator",event:"k-tooltip-event",hidden:"k-hidden",calendarView:"k-calendar-view",scheduler:"k-scheduler"},b=a("<div class='k-tooltip-title k-text-center'>"+"<div class='k-month'>#:kendo.format('{0:MMM}', date)#</div>"+"<div tabindex='0' class='k-link k-day k-text-primary'>#:kendo.format('{0:dd}', date)#</div>"+"</div>"+"#if(events.length){#"+"<div class='k-tooltip-events-container'>"+"<div class='k-tooltip-events'>"+"#for(var i = 0; i < events.length; i+=1){#"+"#var event = events[i]#"+"<div class='k-tooltip-event k-event' title='#:event.title#'"+"# if (event.resources[0]) { #"+"style='background-color: #: event.resources[0].color #; border-color: #: event.resources[0].color #;'"+"#}#>"+"<div class='k-event-title k-text-ellipsis'>#:event.title#</div>"+"<span class='k-spacer'></span>"+"<span class='k-event-time'>#:kendo.format('{0:t}', event.start)#</span>"+"</div>"+"#}#"+"</div>"+"</div>"+"#} else {#"+"<div class='k-no-data k-text-center'>#:messages.noData#</div>"+"#}#"),T=i.extend({init:function(e,t){var n=this;i.fn.init.call(n,e,t);n._yearRange();n._templates();n._layout();n._initCalendar();n._initTooltip()},options:{title:"Year",name:"year",months:12,startDate:null,messages:{noData:"No events on this date."},selectedDateFormat:"{0:yyyy}",selectedShortDateFormat:"{0:yyyy}",selectedMobileDateFormat:"{0:yyyy}",tooltipTemplate:b},name:"year",events:[r],_yearRange:function(){var e=this,t=e.options,n;e._startDate=t.startDate?h(t.startDate):f(t.date);e._startDate.setFullYear(t.date.getFullYear());n=new Date(e._startDate);n.setMonth(n.getMonth()+t.months);e._endDate=n},_templates:function(){var e=this.options,t=n({},c.Template,e.templateSettings);this.tooltipTemplate=c.template(e.tooltipTemplate,t)},_layout:function(){var e=this,t=p;e.content=d("<div/>").addClass(t.layout);e.element.append(e.content);e.body=d("<div/>").addClass(t.body);e.content.append(e.body)},_initCalendar:function(){var e=this,t=e.options,n=d("<div/>"),i,a;e.body.append(n);e.calendar=i=new o.MultiViewCalendar(n,{views:t.months,value:e.startDate(),showViewHeader:true,footer:false});a=i.element;if(!t.selectable)e._disableCalendarSelection();i.value(null);i.header.toggleClass(p.hidden);a.on(w+v,"td[role='gridcell']",e._calendarCellClick.bind(e));a.on(l+v,s+p.calendarView,e._calendarKeydown.bind(e));a.find(s+p.calendarView).removeAttr(m);i.bind(r,e._calendarNavigate.bind(e))},_calendarCellClick:function(e){var t=this,n=t.calendar.selectable.value().first();e.preventDefault();e.stopPropagation();t._displayTooltip(n)},_calendarKeydown:function(e){var t=this,n=c.keys,i=e.keyCode;if(i==n.ENTER||i==n.SPACEBAR){e.preventDefault();t._displayTooltip(t.calendar.selectable.value().first())}else if(i===n.TAB&&e.shiftKey){this._preventCalendarFocus=true;this.calendar.element.find(s+p.calendarView).removeAttr(m);this.element.closest(s+p.scheduler).trigger(u)}},_calendarNavigate:function(e){var t=this,n=e.sender,i=n._firstViewValue<t.startDate(),a=i?t.previousDate():t.nextDate();t.trigger(r,{view:"year",date:a});t._focusCellOnNavigate()},_focusCellOnNavigate:function(){var e=this,t=e.calendar||e.element.find(".k-calendar").getKendoMultiViewCalendar(),n,i;if(!t)return;n=t._firstViewValue<e.startDate();i=n?e.lastDateInRange():e.nextDate();t._focusCell(t._cellByDate(i),true)},_disableCalendarSelection:function(){var e=this;if(!e.calendar)return;e.calendar.value(null);e.calendar.element.off(l,e.calendar._move)},_initTooltip:function(){var e=this,t=e.content,n=e._buildTooltipTemplate.bind(e);e.tooltip=new o.Tooltip(t,{filter:".k-calendar td[role='gridcell']",showOn:w,position:"right",content:n,width:220});e._initTooltipPopup();e.tooltip.bind(g,e._tooltipShow.bind(e));e.tooltip.bind(k,e._tooltipHide.bind(e))},_initTooltipPopup:function(){var e=this,t=e.tooltip;if(!e.tooltip)return;t._initPopup();t.popup.element.addClass(p.tooltip);t.popup.element.on(w+v,".k-tooltip-title > .k-day",e._tooltipTitleClick.bind(e));t.popup.element.on(l+v,e,e._tooltipKeydown.bind(e))},_buildTooltipTemplate:function(){var t=this,n=c.parseDate(t.calendar.current()),e=t.eventsByDate||[];e=e.filter(function(e){return c.toString(new Date(e.value),"d")==c.toString(n,"d")});if(e&&e[0])e[0].items.map(function(e){e.resources=t.eventResources(e)||[]});return t.tooltipTemplate({date:n,events:e[0]?e[0].items:[],messages:t.options.messages})},_inverseTooltipEventsColor:function(){var e=this;d.each(e.tooltip.popup.element.find(s+p.event),function(){e._inverseEventColor(d(this))})},_tooltipShow:function(e){var t=this,n=e.sender;n.refresh();t._inverseTooltipEventsColor();n.popup.element.find(":kendoFocusable").first().trigger(u)},_tooltipHide:function(){if(!this.calendar)return;this.calendar.focus()},_tooltipTitleClick:function(){this._navigateToDayView()},_tooltipKeydown:function(e){var t=this,n=t.tooltip.popup.element,i=d(e.target),a=c.keys,o=e.keyCode,r=e.shiftKey;if(i.is(".k-day")&&o==a.ENTER||o==a.SPACEBAR){e.preventDefault();t._navigateToDayView()}if(o==a.TAB){var l=n.find(":kendoFocusable").first();var s=n.find(":kendoFocusable").last();if(r&&i.is(l)){s.trigger(u);e.preventDefault()}else if(i.is(s)){l.trigger(u);e.preventDefault()}}},_navigateToDayView:function(){var e=d.grep(this.options.views,function(e){return d.isPlainObject(e)&&e.type=="kendo.ui.DayView"||e===_}).length;if(e)this.trigger(r,{view:_,date:this.calendar.current()})},_displayTooltip:function(e){var t=this;if(!e.length)return;if(!t.options.selectable)e.removeClass("k-selected");setTimeout(function(){t.tooltip.show(e)},50)},_renderEventIndicators:function(){var e=this,t=e.calendar,n,i;t.element.find("."+p.indicator).remove();e.eventsByDate.forEach(function(e){n=t._currentView.toDateString(new Date(e.value));i=t.element[0].querySelector("[data-value='"+n+"']");if(e.items.length)d("<span/>").addClass(p.indicator).appendTo(i)})},_groupEventsByDate:function(e){var t=[],n;if(!e.length)return[];n=e.map(function(e){e.formattedDate=e.start.toDateString();return e});t=new c.data.Query(n).sort([{field:"start",dir:"asc"},{field:"end",dir:"desc"}]).group({field:"formattedDate"}).toArray();return t},lastDateInRange:function(){var e=new Date(this.previousDate());e.setMonth(e.getMonth()-1+this.options.months);return y(e)},nextDate:function(){return c.date.nextYear(this._startDate)},previousDate:function(){return c.date.previousYear(this._startDate)},startDate:function(){return this._startDate},endDate:function(){return this._endDate},moveToEvent:function(){return false},constrainSelection:function(){return false},inRange:function(){return true},select:function(e){this.clearSelection();if(e.start>=this.startDate()&&e.start<this.endDate())this.calendar.value(e.start);else{this.calendar.value(this.calendar._firstViewValue);e.start=e.end=this.calendar.value()}this.current(this.calendar.selectable.value()[0])},selectionByElement:function(e){if(!e.length)return;e=d(e);return{index:this.calendar._index,start:c.calendar.toDateObject(e),end:c.calendar.toDateObject(e),isAllDay:false,uid:0}},current:function(e){if(e!==t)this._current=e;else return this._current},render:function(e){var t=this;t._cachedEvents=e;t.eventsByDate=t._groupEventsByDate(e)||[];t._renderEventIndicators();t.trigger(D)},destroy:function(){var e=this;if(e.tooltip){e.tooltip.destroy();e.tooltip=null}if(e.calendar){e.calendar.destroy();e.calendar=null}if(e.element){e.content.remove();e.element.off(v)}i.fn.destroy.call(this)}});return n(true,o,{YearView:T}),window.kendo})}("function"==typeof define&&define.amd?define:function(e,t,n){(n||t)()});
//# sourceMappingURL=kendo.scheduler.yearview.min.js.map
