/**
 * Kendo UI v2022.3.913 (http://www.telerik.com/kendo-ui)
 * Copyright 2022 Progress Software Corporation and/or one of its subsidiaries or affiliates. All rights reserved.
 *
 * Kendo UI commercial licenses may be obtained at
 * http://www.telerik.com/purchase/license-agreement/kendo-ui-complete
 * If you do not own a commercial license, this file shall be governed by the trial license terms.
 */
!function(define){define("kendo.mediaplayer.min",["kendo.slider.min","kendo.toolbar.min","kendo.dropdownlist.min","kendo.tooltip.min"],function(){var d={id:"mediaplayer",name:"MediaPlayer",category:"web",description:"",depends:["slider","toolbar","dropdownlist","tooltip"]},a=window.kendo.jQuery,h=void 0,i=window.kendo,m="end",_="pause",p="play",f="ready",c="timeChange",y="volumeChange",l="k-i-full-screen",n="k-i-full-screen-exit",g="k-i-volume-off",v="k-i-volume-down",w="k-i-volume-up",b="k-mediaplayer-quality",r="k-i-play",T="k-i-pause",k="k-mediaplayer-titlebar",S="k-title",C="k-mediaplayer-toolbar-wrap",D="k-mediaplayer-toolbar",P="k-mediaplayer-seekbar",H="k-mediaplayer-volume",s="k-mediaplayer-media",I="k-mediaplayer-overlay",B="k-mediaplayer-yt",o=".",u=i.ui,e=".kendoMediaPlayer",R=new Date(1970,0,1),F=R.getTimezoneOffset()*60,V=i.ui.Widget,Y=Array.isArray,x={shortTime:"mm:ss",longTime:"HH:mm:ss"},M=i.template,O=i.keys,t={htmlPlayer:"<video class='"+s+"'> </video>",titleBar:M("<div class='"+k+"'><span class='"+S+"'>Video Title</span></div>"),toolBar:"<div class='"+C+"'><div class='"+D+"'></div></div>",youtubePlayer:"<div class='"+B+"'> </div>",toolBarTime:"<span class='k-mediaplayer-currenttime'>00:00:00</span> / <span class='k-mediaplayer-duration'>00:00:00</span>",slider:"<input class='"+P+"' value='0' title='seekbar' />",volumeSlider:"<input class='"+H+"' title='volume'/>",qualityDropDown:"<input class='"+b+"' title='video quality' />",toolTip:"#= kendo.toString(new Date(value), 'HH:mm:ss') #"},U=V.extend({init:function(e,t){this.wrapper=a(e);V.fn.init.call(this,e,t);this.wrapper.addClass("k-mediaplayer k-widget");t=this.options;this._currentIndex=0;this._createTitlebar();this._createToolbar();this._createDropDown();this._createSlider();this._createVolumeSlider();this._timers={};this._aria();this._navigatable();if(t.fullScreen)this.fullScreen(true);if(t.media)this.media(this.options.media);i.notify(this)},events:[m,_,p,f,c,y],options:{name:"MediaPlayer",autoPlay:false,autoRepeat:false,volume:100,fullScreen:false,mute:false,navigatable:false,forwardSeek:true,media:null,messages:{pause:"Pause",play:"Play",mute:"Mute",unmute:"Unmute",quality:"Quality",fullscreen:"Full Screen"}},_msToTime:function(e){var t=new Date(R.getTime());t.setSeconds(e);return t},_timeToSec:function(e){var t=new Date(e).getTime();return t/1e3},_createTitlebar:function(){this._titleBar=this.wrapper.find(o+k);if(this._titleBar.length===0){this.wrapper.append(t.titleBar);this._titleBar=this.wrapper.find(o+k)}},_createSlider:function(){var e=this.wrapper.find(o+P);if(!this._slider){this._sliderDragChangeHandler=this._sliderDragChange.bind(this);this._sliderDraggingHandler=this._sliderDragging.bind(this);e=this.wrapper.find(o+P);this._slider=new u.Slider(e[0],{smallStep:1e3,tickPlacement:"none",showButtons:false,change:this._sliderDragChangeHandler,slide:this._sliderDraggingHandler,tooltip:{template:t.toolTip},dragHandleTitle:this.options.messages.time})}},_createVolumeSlider:function(){var e=this.wrapper.find(o+H);if(!this._volumeSlider){this._volumeDraggingHandler=this._volumeDragging.bind(this);this._volumeChangeHandler=this._volumeChange.bind(this);e.width(87);this._volumeSlider=new u.Slider(e[0],{smallStep:1,min:0,max:100,value:this.options.volume,slide:this._volumeDraggingHandler,change:this._volumeChangeHandler,tickPlacement:"none",showButtons:false,tooltip:{enabled:false},dragHandleTitle:this.options.messages.volume})}},_resetTime:function(){if(this._youTubeVideo)this._ytmedia.seekTo(0,true);else this._media.currentTime=0;this._mediaTimeUpdate();a.grep(this._toolBar.options.items,function(e){return!!e.template}).template=t.toolBarTime},_currentUrl:function(){var e=this.media();return Y(e.source)?e.source[this._currentIndex].url:e.source},_isYouTubeUrl:function(){return!!this._currentUrl().match("youtube.com/|youtu.be/")},_setPlayerUrl:function(){var e=this._youTubeVideo;this.stop();this._youTubeVideo=this._isYouTubeUrl();if(e!==this._youTubeVideo){this.wrapper.find(o+B).toggle();this.wrapper.find(o+s).toggle()}var t=this._media||this._ytmedia;this._initializePlayer();if(t){this.mute(this.mute());this.volume(this.volume())}if(!this._youTubeVideo){this._videoOverlay.show();this.wrapper.find(o+s+" > source").remove();this.wrapper.find(o+s).attr("src",this._currentUrl());if(this.options.autoPlay)this.play()}else if(this._ytmedia){if(this._videoOverlay)this._videoOverlay.hide();if(this.options.autoPlay){this._ytmedia.loadVideoById(this._getMediaId());this._playStateToggle(true)}else{this._ytmedia.cueVideoById(this._getMediaId());this._playStateToggle(true)}}},_createToolbar:function(){var e=this.wrapper.find(o+D);if(e.length===0){this._toolbarClickHandler=this._toolbarClick.bind(this);this.wrapper.append(t.toolBar);e=this.wrapper.find(o+D);e.width(this.wrapper.find(o+s).width());this._toolBar=new u.ToolBar(e,{click:this._toolbarClickHandler,resizable:false,items:[{type:"button",attributes:{class:"k-play-button"},icon:"play",fillMode:"flat"},{template:t.toolBarTime,attributes:{class:"k-mediaplayer-currenttime-wrap"}},{type:"spacer"},{type:"button",attributes:{class:"k-volume-button"},icon:"volume-up",fillMode:"flat"},{template:t.volumeSlider,attributes:{class:"k-mediaplayer-volume-wrap"}},{template:t.qualityDropDown,attributes:{class:"k-mediaplayer-quality-wrap"}},{type:"button",attributes:{class:"k-fullscreen-button"},icon:"full-screen",fillMode:"flat"}]});this._toolBar.wrapper.off("keydown");e.before(t.slider);this._volumeButton=e.find(".k-volume-button");this._fullscreenButton=e.find(".k-fullscreen-button");this._volumeButton.attr("title",this.options.mute?this.options.messages.unmute:this.options.messages.mute);this._volumeButton.attr("aria-label",this.options.mute?this.options.messages.unmute:this.options.messages.mute);this._fullscreenButton.attr("title",this.options.messages.fullscreen);this._fullscreenButton.attr("aria-label",this.options.messages.fullscreen);e.width("auto");this._currentTimeElement=e.find(".k-mediaplayer-currenttime");this._durationElement=e.find(".k-mediaplayer-duration");this._playButton=e.find(".k-play-button");this._playButtonSpan=this._playButton.find(".k-i-play");if(this.options.autoPlay)this._playStateToggle(true);if(i.support.cssFlexbox===false)a([this._volumeButton[0],e.find(".k-mediaplayer-volume-wrap")[0],e.find(".k-mediaplayer-quality-wrap")[0],this._fullscreenButton[0]]).wrapAll("<div class='k-align-right' />")}},_createDropDown:function(){var e=this.wrapper.find(o+b);var t=this.media();if(typeof e.data("kendoDropDownList")==="undefined"){this._dropDownSelectHandler=this._dropDownSelect.bind(this);this._dropDown=new u.DropDownList(e,{dataTextField:"quality",dataValueField:"url",popup:{position:"bottom",origin:"top",appendTo:this.wrapper},animation:{open:{effects:"slideIn:up",duration:1}},select:this._dropDownSelectHandler});if(t&&Y(t.source)){this._dropDown.setDataSource(t.source);this._dropDown.select(0)}this._dropDown.wrapper.addClass("k-button k-button-md k-rounded-md k-button-flat k-button-flat-base");this._dropDown.wrapper.attr("title",this.options.messages.quality).hide();this._dropDown.wrapper.find("span.k-i-arrow-s").removeClass("k-i-arrow-s").addClass("k-icon k-i-hd");this._dropDown.list.addClass("k-quality-list")}},_dropDownSelect:function(e){if(this._currentIndex!==e.item.index()){this._currentIndex=e.item.index();this._setPlayerUrl()}},_toolbarClick:function(e){var t=a(e.target).children().first();var i=t.hasClass(r);if(!this.media())return;if(t.hasClass(r)||t.hasClass(T))if(i)this.play();else this.pause();if(t.hasClass(l)||t.hasClass(n))if(this._isInFullScreen){t.removeClass(n).addClass(l);this.fullScreen(false)}else{t.removeClass(l).addClass(n);this.fullScreen(true)}if(t.hasClass(g)||t.hasClass(v)||t.hasClass(w)){var s=this.mute();this.mute(!s)}},_sliderDragging:function(){if(!this.media())return;this._isDragging=true},_sliderDragChange:function(e){var t=this;var i=e.sender;var s=F*1e3;if(!this.media())return;t._sliderChangeFired=true;t._isDragging=false;if(!this.options.forwardSeek&&i.value()>this._seekBarLastPosition)setTimeout(function(){i.value(t._seekBarLastPosition)},1);else if(this._youTubeVideo)t._ytmedia.seekTo(t._timeToSec(e.value-s));else t._media.currentTime=t._timeToSec(e.value-s);t.trigger(c);t._preventPlay=true},_changeVolumeButtonImage:function(e){var t=this._volumeButton;var i=t.find("span");var s=i.attr("class");s=s.substring(0,s.lastIndexOf(" "));if(e===0){i.attr("class",s+" "+g);t.attr("title",this.options.messages.unmute);t.attr("aria-label",this.options.messages.unmute)}else if(e>0&&e<51){i.attr("class",s+" "+v);t.attr("title",this.options.messages.mute);t.attr("aria-label",this.options.messages.mute)}else{i.attr("class",s+" "+w);t.attr("title",this.options.messages.mute);t.attr("aria-label",this.options.messages.mute)}},_volumeDragging:function(e){if(!this.media())return;this.volume(e.value);this._changeVolumeButtonImage(e.value);this.trigger(y)},_volumeChange:function(e){if(!this.media())return;this.volume(e.value);this._changeVolumeButtonImage(e.value);this.trigger(y)},_mediaTimeUpdate:function(){var e=this._youTubeVideo?this._ytmedia.getCurrentTime():this._media.currentTime;e=e?e:0;var t=this._msToTime(e);this._currentTimeElement.text(i.toString(t,this._timeFormat));if(!this._isDragging){this._seekBarLastPosition=(e+F)*1e3;this._slider.value(this._seekBarLastPosition)}return this.isPlaying()},_playStateToggle:function(e){if(typeof e==="undefined")e=this._playButtonSpan.is(o+r);if(e){this._playButtonSpan.removeClass(r).addClass(T);this._playButton.attr("title",this.options.messages.pause);this._playButton.attr("aria-label",this.options.messages.pause)}else{this._playButtonSpan.removeClass(T).addClass(r);this._playButton.attr("title",this.options.messages.play);this._playButton.attr("aria-label",this.options.messages.play)}},_mediaEnded:function(){this._playStateToggle(false);this._currentTimeElement.text(i.toString(this._msToTime(0),this._timeFormat));this._slider.value((0+F)*1e3);this.trigger(m)},_mediaPlay:function(){this.trigger(p)},_mediaReady:function(){this.trigger(f)},_mediaDurationChange:function(){var e=this._msToTime(this._youTubeVideo?this._ytmedia.getDuration():this._media.duration);this._timeFormat=e.getHours()===0?x.shortTime:x.longTime;this._durationElement.text(i.toString(e,this._timeFormat));this._slider.setOptions({min:R.getTime(),max:e.getTime()});if(!this._isFirstRun){this._resetTime();this._isFirstRun=true}},_createYoutubePlayer:function(){this._mediaTimeUpdateHandler=this._mediaTimeUpdate.bind(this);this._mediaDurationChangeHandler=this._mediaDurationChange.bind(this);this.wrapper.prepend(t.youtubePlayer);this._ytPlayer=this.wrapper.find(o+B)[0];a(this._ytPlayer).css({width:this.wrapper.width(),height:this.wrapper.height()});if(!window.YT||!window.YT.Player){if(!window.onYouTubeIframeAPIReadyRegister){window.onYouTubeIframeAPIReadyRegister=[];a.getScript("https://www.youtube.com/iframe_api");window.onYouTubeIframeAPIReady=function(){if(window.onYouTubeIframeAPIReadyRegister)for(var e=0;e<window.onYouTubeIframeAPIReadyRegister.length;e++)window.onYouTubeIframeAPIReadyRegister[e]._youtubeApiReady();window.onYouTubeIframeAPIReadyRegister.length=0;window.onYouTubeIframeAPIReadyRegister=h}}window.onYouTubeIframeAPIReadyRegister[window.onYouTubeIframeAPIReadyRegister.length]=this}else this._configurePlayer()},_poll:function(i,s,a,e){var l=this;if(l._timers[i]!==null)clearTimeout(l._timers[i]);l._timers[i]=setTimeout(function(t){return function e(){if(s.call(t))l._timers[i]=setTimeout(e,a)}}(e),a);return l._timers[i]},_youtubeApiReady:function(){this._configurePlayer()},_configurePlayer:function(){var e={autoplay:+this.options.autoPlay,wmode:"transparent",controls:0,rel:0,showinfo:0};this._onYouTubePlayerReady=this._onYouTubePlayerReady.bind(this);window.onYouTubePlayerReady=this._onYouTubePlayerReady;this._onPlayerStateChangeHandler=this._onPlayerStateChange.bind(this);window.onPlayerStateChange=this._onPlayerStateChange;var t=new window.YT.Player(this.wrapper.find(o+B)[0],{height:this.wrapper.height(),width:this.wrapper.width(),videoId:this._getMediaId(),playerVars:e,events:{onReady:this._onYouTubePlayerReady,onStateChange:this._onPlayerStateChangeHandler}})},_onYouTubePlayerReady:function(e){this._ytmedia=e.target;this._ytmedia.getIframe().style.width="100%";this._ytmedia.getIframe().style.height="100%";this._youTubeVideo=true;this._mediaDurationChangeHandler();if(this.options.autoPlay){this._playStateToggle(true);this._ytmedia.loadVideoById(this._getMediaId())}else this._ytmedia.cueVideoById(this._getMediaId());if(this.options.mute)this.mute(true);this.trigger(f)},_updateTitle:function(){this.titlebar().text(this.media().title||this.media().source)},_onPlayerStateChange:function(e){if(e.data===0){this._slider.value(0);this._paused=false;this._playStateToggle(true);this.trigger(m);if(this.options.autoRepeat)this.play()}else if(e.data===1){this._mediaDurationChange();this._ytmedia.setVolume(this.volume());if(this._sliderChangeFired)this._sliderChangeFired=false;else this._uiDisplay(false);this.trigger(p);this._playStateToggle(true);this._poll("progress",this._mediaTimeUpdate,500,this);this._paused=false}else if(e.data===2)if(!this._paused){this._uiDisplay(true);this._playStateToggle(false);this.trigger(_);this._paused=true}},_getMediaId:function(){var e=this._currentUrl();var t=/^.*((youtu.be\/)|(v\/)|(\/u\/\w\/)|(embed\/)|(watch\?))\??v?=?([^#\&\?]*).*/;var i=e.match(t);if(i&&i[7].length===11)e=i[7];return e},_mouseClick:function(){if(this.isPaused())this.play();else this.pause()},_initializePlayer:function(){if(!this._mouseMoveHandler){this._mouseMoveHandler=this._mouseMove.bind(this);this._mouseInHandler=this._mouseIn.bind(this);this._mouseOutHandler=this._mouseOut.bind(this);a(this.wrapper).on("mouseenter"+e,this._mouseInHandler).on("mouseleave"+e,this._mouseOutHandler).on("mousemove"+e,this._mouseMoveHandler)}if(!this._ytmedia&&this._youTubeVideo)this._createYoutubePlayer();else if(!this._media&&!this._youTubeVideo)this._createHtmlPlayer()},_createHtmlPlayer:function(){if(!this._videoOverlay){this._mouseClickHanlder=this._mouseClick.bind(this);this.wrapper.append("<div class='"+I+"'></div>");this._videoOverlay=this.wrapper.find(".k-mediaplayer-overlay").on("click"+e,this._mouseClickHanlder)}this._mediaTimeUpdateHandler=this._mediaTimeUpdate.bind(this);this._mediaDurationChangeHandler=this._mediaDurationChange.bind(this);this._mediaEndedHandler=this._mediaEnded.bind(this);this._mediaCanPlayHandler=this._mediaReady.bind(this);this._mediaPlayHandler=this._mediaPlay.bind(this);this._videoOverlay.after(t.htmlPlayer);this._media=this.wrapper.find(o+s)[0];a(this._media).css({width:"100%",height:"100%"});if(this.options.mute)this.mute(true);this._media.ontimeupdate=this._mediaTimeUpdateHandler;this._media.ondurationchange=this._mediaDurationChangeHandler;this._media.oncanplay=this._mediaCanPlayHandler;this._media.onplay=this._mediaPlayHandler;this._media.onended=this._mediaEndedHandler;this._media.loop=this.options.autoRepeat},_mouseIn:function(){this._uiDisplay(true)},_mouseOut:function(){this._poll("mouseIdle",this._mouseIdle,3e3,this)},_mouseIdle:function(){this._uiDisplay(false);return false},_mouseMove:function(){if(!(this._titleBar.is(":animated")||this._toolBar.element.is(":animated")||this._slider.wrapper.is(":animated")))this._uiDisplay(true);this._poll("mouseIdle",this._mouseIdle,3e3,this)},_uiDisplay:function(e){var t="slow";var i=this._titleBar.add(this._toolBar.element.parent());if(e)i.fadeIn(t);else{i.fadeOut(t);if(this.options.navigatable)this.wrapper.trigger("focus")}},setOptions:function(e){V.fn.setOptions.call(this,e)},destroy:function(){V.fn.destroy.call(this);if(!this.isPaused())this.pause();this.element.off(e);this.element.find(o+I).off(e);this._timers=null;this._mouseMoveHandler=null;this._mouseOutHandler=null;this._mouseInHandler=null;this._mouseClickHanlder=null;this._keyDownHandler=null;this._fullscreenHandler=null;this._toolbarClickHandler=null;this._sliderDragChangeHandler=null;this._sliderDraggingHandler=null;this._volumeDraggingHandler=null;this._volumeChangeHandler=null;this._youtubeApiReadyHandler=null;this._onYouTubePlayerReady=null;this._onPlayerStateChangeHandler=null;this._dropDownSelectHandler=null;if(this._youTubeVideo)this._ytmedia.destroy();else{this._media.ontimeupdate=this._mediaTimeUpdateHandler=null;this._media.ondurationchange=this._mediaDurationChangeHandler=null;this._media.oncanplay=this._mediaCanPlayHandler=null;this._media.onplay=this._mediaPlayHandler=null;this._media.onended=this._mediaEndedHandler=null;this._media.src="";this._media.remove()}this._mouseMoveTimer=null;clearTimeout(this._mouseMoveTimer);i.destroy(this.element)},seek:function(e){if(typeof e==="undefined")return 1e3*this._youTubeVideo?this._ytmedia.getCurrentTime():this._media?this._media.currentTime:0;var t=e/1e3;if(this._youTubeVideo)if(t+3>=this._ytmedia.getDuration()|0)this._ytmedia.seekTo(this._ytmedia.getDuration()-3|0,true);else this._ytmedia.seekTo(t,true);else this._media.currentTime=t;return this},play:function(){if(this._youTubeVideo)this._ytmedia.playVideo();else{if(i.support.mobileOS)this._uiDisplay(false);this._media.play()}this._paused=false;this._playStateToggle(true);return this},stop:function(){if(this._youTubeVideo&&this._ytmedia)this._ytmedia.stopVideo();else if(this._media&&!this._youTubeVideo){if(i.support.mobileOS)this._uiDisplay(true);this._media.pause();this._media.currentTime=0}this._paused=true;this._playStateToggle(false);return this},pause:function(){if(this._youTubeVideo)this._ytmedia.pauseVideo();else{if(i.support.mobileOS)this._uiDisplay(true);this._media.pause()}this._paused=true;this._playStateToggle(false);this.trigger(_);return this},toolbar:function(){return this._toolBar},dropdown:function(){return this._dropDown},titlebar:function(){return this._titleBar},fullScreen:function(e){if(typeof e==="undefined")return this._isInFullScreen||false;var t=this.element.get(0);if(e){this.element.addClass("k-mediaplayer-fullscreen");if(t.requestFullscreen)t.requestFullscreen();else if(t.webkitRequestFullscreen)t.webkitRequestFullscreen();else if(t.mozRequestFullScreen)t.mozRequestFullScreen();else if(t.msRequestFullscreen)t.msRequestFullscreen();this._isInFullScreen=true}else{if(document.cancelFullscreen)document.cancelFullscreen();else if(document.webkitCancelFullScreen)document.webkitCancelFullScreen();else if(document.mozCancelFullScreen)document.mozCancelFullScreen();else if(document.msCancelFullscreen)document.msCancelFullscreen();else if(document.exitFullscreen)document.exitFullscreen();else if(document.msExitFullscreen)document.msExitFullscreen();this.element.removeClass("k-mediaplayer-fullscreen");this._isInFullScreen=false}this._slider.resize()},volume:function(e){if(typeof e==="undefined")return typeof this._volume!=="undefined"?this._volume:this._volume=this.options.volume;this._volume=e;this.mute(e<=0);if(this._youTubeVideo)this._ytmedia.setVolume(this._volume);else this._media.volume=this._volume/100;this._volumeSlider.value(e)},mute:function(e){var t=this._youTubeVideo?this._ytmedia&&this._ytmedia.isMuted():this._media&&this._media.muted;if(typeof e==="undefined"||e===t)return t;if(this._youTubeVideo)if(e)this._ytmedia.mute();else this._ytmedia.unMute();else this._media.muted=e;if(e)this._volumeSlider.value(0);else this._volumeSlider.value(this._media&&this._media.volume*100||this._ytmedia&&this._ytmedia.getVolume());this.trigger(y);this._changeVolumeButtonImage(this._volumeSlider.value())},isEnded:function(){if(this._youTubeVideo)return this._ytmedia.getPlayerState()===0;else return this._media.ended},media:function(e){var t=this.dropdown();if(typeof e==="undefined")return typeof this._mediaData!=="undefined"?this._mediaData:this._mediaData=this.options.media;if(Y(e.source)){t.setDataSource(e.source);t.wrapper.show()}else t.wrapper.hide();this._mediaData=e;this._updateTitle();this._setPlayerUrl()},isPaused:function(){return this._paused},isPlaying:function(){return!this.isEnded()&&!this._paused},_aria:function(){this.wrapper.attr("role","region")},_navigatable:function(){this._fullscreenHandler=this._fullscreen.bind(this);a(document).on("webkitfullscreenchange mozfullscreenchange fullscreenchange"+e,this._fullscreenHandler);if(this.options.navigatable){this.wrapper.attr("tabIndex",0);this._keyDownHandler=this._keyDown.bind(this);this.wrapper.on("keydown"+e,this._keyDownHandler)}},_fullscreen:function(){var e=document.fullScreen||document.mozFullScreen||document.webkitIsFullScreen;this._uiDisplay(true);this._slider.resize();if(!e){this.wrapper.find('span[class*="k-i-fullscreen"]').removeClass(n).addClass(l);this.fullScreen(false)}},_keyDown:function(e){e.preventDefault();var t=this.wrapper.find('span[class*="k-i-fullscreen"]');if(e.keyCode===O.SPACEBAR)if(this.isPlaying())this.pause();else this.play();else if(e.keyCode===O.ENTER&&!this._isInFullScreen){t.removeClass(l).addClass(n);this.fullScreen(true)}else if(e.keyCode===77){var i=this.mute();this.mute(!i)}else if(e.keyCode===O.ESC&&this._isInFullScreen){t.removeClass(n).addClass(l);this.fullScreen(false)}},_error:function(){},_progress:function(){}});return u.plugin(U),window.kendo})}("function"==typeof define&&define.amd?define:function(e,t,i){(i||t)()});
//# sourceMappingURL=kendo.mediaplayer.min.js.map
