/**
 * Kendo UI v2022.3.913 (http://www.telerik.com/kendo-ui)
 * Copyright 2022 Progress Software Corporation and/or one of its subsidiaries or affiliates. All rights reserved.
 *
 * Kendo UI commercial licenses may be obtained at
 * http://www.telerik.com/purchase/license-agreement/kendo-ui-complete
 * If you do not own a commercial license, this file shall be governed by the trial license terms.
 */
!function(define){define("kendo.scrollview.min",["kendo.fx.min","kendo.data.min","kendo.draganddrop.min"],function(){var t={id:"scrollview",name:"ScrollView",category:"web",description:"The Kendo ScrollView widget is used to scroll content wider than the device screen.",depends:["fx","data","draganddrop"]},h=window.kendo.jQuery,f=void 0,v=window.kendo,i=v.ui,p=v.effects.Transition,d=v.ui.Pane,r=v.keys,u=v.ui.PaneDimensions,m=i.DataBoundWidget,a=v.data.DataSource,e=Math,_=e.abs,w=e.ceil,b=e.round,P=e.max,x=e.min,y=e.floor,c="change",S="click",n="changing",s="refresh",k="primary",C="scrollview-page",T="function",R="itemChange",E="cleanup",o=".ScrollView",V=".",A="keydown",z="focus",D="focusout",l="k-focus",O="tabindex",W=3,B=-1,L=0,q=1,H=-1,M=0,I=1;function g(e){return"k-"+e}var N=v.Observable.extend({init:function(e){var t=this;this.dataSource=e;this.pendingRequestArray=[];this.initialFetch=false;this.useRanges=e.options.serverPaging;v.Observable.fn.init.call(this);e.bind("change",function(){t._change()})},_change:function(){this.trigger("reset",{offset:this.offset})},page:function(e,t){var i=this;if(!this.useRanges){this.dataSource.page(e+1);if(t)t(i.dataSource.view());else i.trigger("page",{page:e})}if(this.useRanges)this.dataSource.range(e*this.dataSource.pageSize(),this.dataSource.pageSize(),function(){if(t)t(i.dataSource.view());else i.trigger("page",{page:e})})},scrollTo:function(e){var t=Math.ceil(this.dataSource.total()/this.dataSource.pageSize()||1);var i=e-1;var a=i-1;var n=e;var s=t>0&&e+1>=t?-1:e+1;var r=t>0&&s+1>=t?-1:s+1;if(s>=0)this.pendingRequestArray.push(s);if(i>=0)this.pendingRequestArray.push(i);if(a>=0)this.pendingRequestArray.push(a);if(r>=0)this.pendingRequestArray.push(r);this.page(n)},getViewData:function(){var e=this.dataSource.view();var t;if(this.dataSource.options.pageSize>1){t=[];for(var i=0;i<e.length;i++)t.push(e[i])}else t=e[0];return t},destroy:function(){var e=this;e.dataSource.unbind();e.dataSource=null}}),F=(v.ui.ScrollViewDataReader=N,v.Class.extend({init:function(e){var t=this,i=h("<ul class='"+g("scrollview-nav")+"'/>"),a=h("<div class='"+g("scrollview-nav-wrap")+"'></div>");a.append(i);e._navigationContainer.append(a);this._changeProxy=t._change.bind(t);this._refreshProxy=t._refresh.bind(t);e.bind(c,this._changeProxy);e.bind(s,this._refreshProxy);i.on(S+o,"li.k-link",this._click.bind(e));h.extend(t,{element:i,scrollView:e});t._navigatable()},items:function(){return this.element.children()},_focus:function(){var e=this;e._focused=true;e._setCurrent(e.element.find(V+g(k)))},_blur:function(){var e=this;e._focused=false;if(e._current){e._current.removeClass(l);e._current.removeAttr("id");e.element.removeAttr("aria-activedescendant")}},_keyDown:function(e){var t=this;var i;var a;var n=t._current;var s=e.keyCode;if(s==r.LEFT){i=true;a=n.prev("li.k-link");if(a.length)t._setCurrent(a)}if(s==r.RIGHT){i=true;a=n.next("li.k-link");if(a.length)t._setCurrent(a)}if(e.keyCode==r.SPACEBAR||e.keyCode==r.ENTER){i=true;t._current.trigger("click")}if(i){e.preventDefault();e.stopPropagation()}},_setCurrent:function(e){if(!this._focused)return;var t=this;var i=v.guid();var a=h(e);if(t._current){h(t._current).removeClass(l).removeAttr("id");t.element.removeAttr("aria-activedescendant")}a.attr("id",i).addClass(l);t.element.attr("aria-activedescendant",i);t._current=a},_navigatable:function(){var e=this;var t=e.scrollView.options.pageable||{};if(!e.scrollView.options.navigatable)return;e.element.attr(O,0).attr("aria-label",e.scrollView.options.messages.pagerLabel).attr("role","listbox");e._ariaTemplate=v.template(t.ARIATemplate||"Item #=data.index#");e.element.on(A+o,e,e._keyDown.bind(e));e.element.on(z+o,e._focus.bind(e));e.element.on(D+o,e._blur.bind(e))},_refresh:function(e){var t="";var i=this.scrollView.options.navigatable;var a;for(var n=0;n<e.pageCount;n++)if(i)t+='<li class="k-link" role="option" aria-label="'+this._ariaTemplate({index:n})+'" aria-selected="false"></li>';else t+='<li class="k-link"></li>';this.element.html(t);a=this.items().eq(e.page);a.addClass(g(k));if(i)a.attr("aria-selected",true);this.scrollView._toggleNavigation({currentPage:e.page})},_change:function(e){if(e.isDefaultPrevented())return;var t=this.scrollView._navigationContainer.find(".k-scrollview-nav");var i=this.scrollView.element.width();var a=(i-t.width())/2;var n=t.find("li.k-link").eq(0).outerWidth(true)/2;var s=this.items();var r=this.scrollView.options.navigatable;var o;s.removeClass(g(k));o=s.eq(e.nextPage).addClass(g(k));if(r){s.attr("aria-selected",false);this._setCurrent(o);o.attr("aria-selected",true)}var l=this.items().eq(e.nextPage).length>0?this.items().eq(e.nextPage).position().left:0;if(l>i/2||l<v.scrollLeft(t)+i/2){var h=0;if(l>i/2)h=v.scrollLeft(t)+l-i/2;else h=v.scrollLeft(t)-(i/2-l);h+=a+n;t.animate({scrollLeft:h},300)}this.scrollView._toggleNavigation({currentPage:e.currentPage,nextPage:e.nextPage})},_click:function(e){var t=h(e.currentTarget).index();this.scrollTo(t)},destroy:function(){this.scrollView.unbind(c,this._changeProxy);this.scrollView.unbind(s,this._refreshProxy);this.element.off(o);this.element.remove()}})),U=(v.ui.ScrollViewPager=F,"transitionEnd"),G="dragStart",j="dragEnd",K=v.Observable.extend({init:function(e,t){var i=this;v.Observable.fn.init.call(this);this.element=e;this.container=e.parent();var a,n,s,r,o,l;a=new v.ui.Movable(i.element);n=new p({axis:"x",movable:a,onEnd:function(){i.trigger(U)}});s=new v.UserEvents(e,{fastTap:true,start:function(e){if(_(e.x.velocity)*2>=_(e.y.velocity))s.capture();else s.cancel();i.trigger(G,e);n.cancel()},allowSelection:true,end:function(e){i.trigger(j,e)}});r=new u({element:i.element,container:i.container});o=r.x;o.bind(c,function(){i.trigger(c)});l=new d({dimensions:r,userEvents:s,movable:a,elastic:true});h.extend(i,{duration:t&&t.duration||1,movable:a,transition:n,userEvents:s,dimensions:r,dimension:o,pane:l});this.bind([U,G,j,c],t)},size:function(){return{width:this.dimensions.x.getSize(),height:this.dimensions.y.getSize()}},total:function(){return this.dimension.getTotal()},offset:function(){return-this.movable.x},updateDimension:function(){this.dimension.update(true)},refresh:function(){this.dimensions.refresh();this.dimensions.y.enabled=false},moveTo:function(e){this.movable.moveAxis("x",-e)},transitionTo:function(e,t,i){if(i)this.moveTo(-e);else this.transition.moveTo({location:e,duration:this.duration,ease:t})},destroy:function(){var e=this;e.userEvents.destroy();e.unbind();e.movable=e.tansition=e.dimensions=e.dimension=e.pane=null;e.element.remove()}}),Q=(v.ui.ScrollViewElasticPane=K,v.Observable.extend({init:function(e,t,i){var a=this;v.Observable.fn.init.call(this);a.element=e;a.pane=t;a._getPages();this.page=0;this.pageSize=i.pageSize||1;this.contentHeight=i.contentHeight;this.enablePager=i.enablePager;this.pagerOverlay=i.pagerOverlay},scrollTo:function(e,t){var i=this;if(e==i.page&&!t)return;if(!i.trigger("resize",{currentPage:this.page,nextPage:e,data:f})){i.page=e;i.pane.transitionTo(-e*i.pane.size().width,p.easeOutExpo,t)}},paneMoved:function(e,c,t,i){var a=this,n=a.pane,s=n.size().width*a.pageSize,r=b,o=c?p.easeOutBack:p.easeOutExpo,l,h;if(e===H)r=w;else if(e===I)r=y;h=r(n.offset()/s);if(h<0||h>=a.pageCount){var g=h<0?0:-this.page*this.pane.size().width;return this.pane.transitionTo(g,o,i)}l=P(a.minSnap,x(-h*s,a.maxSnap));if(h!=a.page)if(t&&t({currentPage:a.page,nextPage:h}))l=-a.page*n.size().width;n.transitionTo(l,o,i)},updatePage:function(){var e=this.pane,t=b(e.offset()/e.size().width);if(t!=this.page){this.page=t;return true}return false},forcePageUpdate:function(){return this.updatePage()},resizeTo:function(e){var t=this.pane,i=e.width;this.pageElements.width(i);if(this.contentHeight==="100%"){var a=this.element.parent().height();if(this.enablePager===true){var n=this.element.parent().find("ul.k-scrollview-nav");if(!this.pagerOverlay&&n.length)a-=v._outerHeight(n,true)}this.element.css("height",a);this.pageElements.css("height",a)}t.updateDimension();if(!this._paged)this.page=y(t.offset()/i);this.scrollTo(this.page,true,true);this.pageCount=y(t.total()/i);this.minSnap=-(this.pageCount-1)*i;this.maxSnap=0},_getPages:function(){this.pageElements=this.element.find(v.roleSelector("page"));this._paged=this.pageElements.length>0},destroy:function(){var e=this;e.pane=null;e.element.remove()}})),J=(v.ui.ScrollViewContent=Q,v.Observable.extend({init:function(e,t,i){var a=this;v.Observable.fn.init.call(this);a.element=e;a.pane=t;a.options=i;a._templates();a.page=i.page||0;a.pages=[];a._initPages();a.resizeTo(a.pane.size());a.pane.dimension.forceEnabled()},setDataSource:function(e){this.dataSource=a.create(e);this._dataReader();this._pendingPageRefresh=false;this._pendingWidgetRefresh=false},_viewShow:function(){var e=this;if(e._pendingWidgetRefresh){setTimeout(function(){e._resetPages()},0);e._pendingWidgetRefresh=false}},_dataReader:function(){this.dataReader=new N(this.dataSource);this._pageProxy=this._onPage.bind(this);this._resetProxy=this._onReset.bind(this);this.dataReader.bind({page:this._pageProxy,reset:this._resetProxy})},_templates:function(){var e=this.options.template,t=this.options.emptyTemplate,i={},a={};if(typeof e===T){i.template=e;e="#=this.template(data)#"}this.template=v.template(e).bind(i);if(typeof t===T){a.emptyTemplate=t;t="#=this.emptyTemplate(data)#"}this.emptyTemplate=v.template(t).bind(a)},_initPages:function(){var e=this.pages,t=this.element,i;for(var a=0;a<W;a++){i=new X(t);e.push(i)}this.pane.updateDimension()},resizeTo:function(e){var t=this.pages,i=this.pane;for(var a=0;a<t.length;a++)t[a].setWidth(e.width);if(this.options.contentHeight==="auto")this.element.css("height",this.pages[1].element.height());else if(this.options.contentHeight==="100%"){var n=this.element.parent().height();if(this.options.enablePager===true){var s=this.element.parent().find("ul.k-scrollview-nav");if(!this.options.pagerOverlay&&s.length)n-=v._outerHeight(s,true)}this.element.css("height",n);t[0].element.css("height",n);t[1].element.css("height",n);t[2].element.css("height",n)}else if(this.options.contentHeight){t[0].element.css("height",this.options.contentHeight);t[1].element.css("height",this.options.contentHeight);t[2].element.css("height",this.options.contentHeight)}i.updateDimension();this._repositionPages();this.width=e.width},scrollTo:function(t,i,a){var n=this;var s=n.dataReader;if(t==n.page&&!i)return;s.page(t,function(e){if(a){s.scrollTo(t);return}if(!n.trigger("resize",{currentPage:n.page,nextPage:t,data:e})){if(!i){s.pagerScroll=t>n.page?-1:1;n.page=t+s.pagerScroll}else n.page=t;s.scrollTo(t)}})},paneMoved:function(e,c,t,i){var a=this,n=a.pane,g=n.size().width,s=n.offset(),r=Math.abs(s)>=g/3,p=c?v.effects.Transition.easeOutBack:v.effects.Transition.easeOutExpo,d=a.page+2>a.pageCount,o,l=0,h,u;if(e===I){if(a.page!==0)l=-1}else if(e===H&&!d)l=1;else if(s>0&&(r&&!d))l=1;else if(s<0&&r)if(a.page!==0)l=-1;o=a.page;if(l){o=l>0?o+1:o-1;if(a instanceof v.ui.VirtualScrollViewContent){a.dataReader.page(o);h=a.dataReader.getViewData()}else h=f;if(!(h instanceof Array))h=[h];u=a.pages?a.pages[1].element:f}if(t&&a.page!=o&&t({currentPage:a.page,nextPage:o,element:u,data:h}))l=0;if(l===0)a._cancelMove(p,i);else if(l===-1)a._moveBackward(i);else if(l===1)a._moveForward(i)},updatePage:function(){var e=this.pages;if(this.pane.offset()===0)return false;if(this.pane.offset()>0){e.push(this.pages.shift());this.page++;if(this.page+2<this.pageCount)this.dataReader.pendingRequestArray.push(this.page+2);if(this.page+1<this.pageCount)this.dataReader.page(this.page+1);if(this.page+1==this.pageCount)this.setPageContent(this.pages[2],null)}else{e.unshift(this.pages.pop());this.page--;if(this.page-2>=0)this.dataReader.pendingRequestArray.push(this.page-2);if(this.page-1>=0)this.dataReader.page(this.page-1)}this._repositionPages();this._resetMovable();return true},forcePageUpdate:function(){var e=this.pane.offset(),t=this.pane.size().width*3/4;if(_(e)>t)return this.updatePage();return false},_resetMovable:function(){this.pane.moveTo(0)},_moveForward:function(e){this.pane.transitionTo(-this.width,v.effects.Transition.easeOutExpo,e)},_moveBackward:function(e){this.pane.transitionTo(this.width,v.effects.Transition.easeOutExpo,e)},_cancelMove:function(e,t){this.pane.transitionTo(0,e,t)},_resetPages:function(){this.page=this.options.page||0;this._repositionPages();this.trigger("reset")},_onPage:function(e){if(e.page>=this.pageCount)this.setPageContent(this.pages[2],null);if(this.page==e.page)if(!this.dataReader.pagerScroll||this.dataReader.pagerScroll===0&&this.dataReader.initialFetch)this.setPageContent(this.pages[1],this.dataReader.getViewData());else{if(this.dataReader.pagerScroll<0)this._moveForward();else this._moveBackward();this.dataReader.pagerScroll=0;this.setPageContent(this.pages[1],this.dataReader.getViewData())}else if(this.page+1==e.page)this.setPageContent(this.pages[2],this.dataReader.getViewData());else if(this.page-1==e.page)this.setPageContent(this.pages[0],this.dataReader.getViewData());if(this.dataReader.pendingRequestArray.length>0&&this.dataReader.initialFetch){var t=this.dataReader.pendingRequestArray.shift();this.dataReader.page(t)}},_onReset:function(){this.pageCount=w(this.dataSource.total()/this.dataSource.pageSize())},_repositionPages:function(){var e=this.pages;e[0].position(B);e[1].position(L);e[2].position(q)},setPageContent:function(e,t){var i=this.template,a=this.emptyTemplate;if(t!==null&&t!==f)e.content(i(t));else e.content(a({}))},destroy:function(){var e=this;var t=e.pages;e.dataReader.unbind();e.dataSource.unbind();e.dataReader=e.dataSource=e.pane=null;for(var i=0;i<t.length;i++)t[i].destroy();e.element.remove()}})),X=(v.ui.VirtualScrollViewContent=J,v.Class.extend({init:function(e){this.element=h("<li class='"+g(C)+"'></li>");this.width=e.width();this.element.width(this.width);e.append(this.element)},content:function(e){this.element.html(e)},position:function(e){this.element.css("transform","translate3d("+this.width*e+"px, 0, 0)")},setWidth:function(e){this.width=e;this.element.width(e)},destroy:function(){var e=this;e.element.remove();e.element=null}})),Y=(v.ui.VirtualPage=X,m.extend({init:function(e,t){var a=this;m.fn.init.call(a,e,t);t=a.options;e=a.element;v.stripWhitespace(e[0]);if(e.children().length===0)e.wrapInner("<ul class='k-scrollview-wrap'/>");else e.wrapInner("<div class='k-scrollview-wrap'/>");a.itemsWrapper=e.find(".k-scrollview-wrap");e.addClass("k-widget "+g("scrollview"));a._initNavigation();if(this.options.pageable||this.options.enablePager){this.pager=new F(this);if(this.options.pagerOverlay)e.addClass(g("scrollview-overlay"))}else{this._changeProxy=a._toggleNavigation.bind(a);this.bind(c,this._changeProxy)}a.inner=e.children().first();a.page=0;a.inner.css("height",t.contentHeight);a.pane=new K(a.inner,{duration:this.options.duration,transitionEnd:this._transitionEnd.bind(this),dragStart:this._dragStart.bind(this),dragEnd:this._dragEnd.bind(this),change:this[s].bind(this)});a.bind("resize",function(){a.pane.refresh()});a.page=t.page;var i=this.inner.children().length===0;var n=i?new J(a.inner,a.pane,t):new Q(a.inner,a.pane,t);n.page=a.page;n.bind("reset",function(){this._pendingPageRefresh=false;a.trigger(s,{pageCount:n.pageCount,page:n.page});a._toggleNavigation({currentPage:n.page,nextPage:n.page})});n.bind("resize",function(e){var t=n.page;var i=e.nextPage;if(t!=i)e._defaultPrevented=a.trigger(c,{currentPage:n.page,nextPage:e.nextPage,data:e.data});a._toggleNavigation({currentPage:n.page,nextPage:e.nextPage})});n.bind(R,function(e){a.trigger(R,e);a.angular("compile",function(){return{elements:e.item,data:[{dataItem:e.data}]}})});n.bind(E,function(e){a.angular("cleanup",function(){return{elements:e.item}})});a._content=n;a.setDataSource(t.dataSource);a.viewInit();a.viewShow();a._navigatable()},options:{name:"ScrollView",ARIATemplate:"Item #=data.index# of #=data.total#",page:0,duration:400,velocityThreshold:.8,contentHeight:"auto",pageSize:1,bounceVelocityThreshold:1.6,enablePager:true,enableNavigationButtons:true,pagerOverlay:true,navigatable:false,autoBind:true,pageable:false,template:"",emptyTemplate:"",messages:{previousButtonLabel:"Previous",nextButtonLabel:"Next",pagerLabel:"ScrollView pager"}},events:[n,c,s],destroy:function(){m.fn.destroy.call(this);this._content.destroy();this.pane.destroy();if(this.pager)this.pager.destroy();this._navigationContainer.off(o);this._navigationContainer=null;this.itemsWrapper.off(o);this.itemsWrapper=null;if(this.options.navigatable)this.ariaLiveEl=this._current=null;this.inner=null;v.destroy(this.element)},viewInit:function(){if(this.options.autoBind)this._content.scrollTo(this._content.page,true,true)},viewShow:function(){this.pane.refresh()},refresh:function(){var e=this._content;var t=this.options;e.resizeTo(this.pane.size());this.page=e.page;if(e instanceof Q||e.dataReader.initialFetch)if(t.enablePager)this.trigger(s,{pageCount:e.pageCount,page:e.page});else this.trigger(c,{pageCount:e.pageCount,currentPage:e.page})},content:function(e){this.element.children().first().html(e);this._content._getPages();this.pane.refresh()},scrollTo:function(e,t,i){this._content.scrollTo(e,t,i)},prev:function(){var t=this,e=t._content.page-1;if(t._content instanceof J)t._content.paneMoved(I,f,function(e){return t.trigger(c,e)});else if(e>-1)t.scrollTo(e)},next:function(){var t=this,e=t._content.page+1;if(t._content instanceof J)t._content.paneMoved(H,f,function(e){return t.trigger(c,e)});else if(e<t._content.pageCount)t.scrollTo(e)},setDataSource:function(e){var t=this;if(!(this._content instanceof J))return;var i=!e;if(e instanceof a){e.options.pageSize=e.options.pageSize||1;this.dataSource=e=new a(e.options)}else this.dataSource=a.create(e);this._content.setDataSource(this.dataSource);if(this.options.autoBind&&!i)this.dataSource.fetch(function(){t._content.dataReader.initialFetch=true;t.scrollTo(t._content.page,true,true);t._content.trigger("reset")})},items:function(){return this.element.find(".k-"+C)},_updateAria:function(){var e=this._content;if(this.options.navigatable)this.ariaLiveEl.html(this._ariaTemplate({index:e.page+1,total:e.pageCount}))},_setCurrent:function(e){if(!this._focused)return;var t=this;var i=t._content.page;var a=v.guid();var n=t.itemsWrapper.children();var s=h(e||n.eq(i));if(t._content.pages){n.attr("aria-hidden",true);t._content.pages[1].element.removeAttr("aria-hidden");return}if(t._current){h(t._current).removeClass(l).removeAttr("id");n.attr("aria-hidden",true)}s.attr("id",a).removeAttr("aria-hidden").addClass(l);t.itemsWrapper.attr("aria-activedescendant",a);t._updateAria();t._current=s},_dragStart:function(){this._content.forcePageUpdate()},_dragEnd:function(e){var t=this,i=e.x.velocity,a=this.options.velocityThreshold,n=M,s=_(i)>this.options.bounceVelocityThreshold;if(i>a)n=I;else if(i<-a)n=H;this._content.paneMoved(n,s,function(e){return t.trigger(c,e)})},_transitionEnd:function(){this._content.updatePage();if(this.options.navigatable)this._setCurrent()},_initNavigation:function(){var e=this;var t;var i;var a=e.options.messages;var n=e._navigationContainer=h("<div class='k-scrollview-elements'></div>");if(e.options.navigatable){t=h('<a class="k-scrollview-prev" role="button" aria-label="'+a.previousButtonLabel+'"><span class="k-icon k-i-arrowhead-w"></span></a>');i=h('<a class="k-scrollview-next" role="button" aria-label="'+a.nextButtonLabel+'"><span class="k-icon k-i-arrowhead-e"></span></a>')}else{t=h('<a class="k-scrollview-prev"><span class="k-icon k-i-arrowhead-w"></span></a>');i=h('<a class="k-scrollview-next"><span class="k-icon k-i-arrowhead-e"></span></a>')}t.hide();i.hide();n.append(t);n.append(i);e.element.append(n);if(e.options.navigatable){e.ariaLiveEl=h("<div aria-live='polite' aria-atomic='true' class='k-sr-only'></div>");e.element.append(e.ariaLiveEl)}n.on(S+o,"a.k-scrollview-prev",e.prev.bind(e));n.on(S+o,"a.k-scrollview-next",e.next.bind(e))},_navigatable:function(){var e=this;var t=e._navigationContainer;if(!e.options.navigatable)return;e._ariaTemplate=v.template(e.options.ARIATemplate);t.find(">a.k-scrollview-prev").attr(O,0);t.find(">a.k-scrollview-next").attr(O,0);t.on(A+o,e,function(e){var t=h(e.target);if(e.keyCode==r.SPACEBAR||e.keyCode==r.ENTER){e.preventDefault();t.click()}});e.itemsWrapper.attr("aria-roledescription","carousel").attr(O,0);e.itemsWrapper.on(A+o,e,e._keyDown.bind(e));e.itemsWrapper.on(z+o,e._focus.bind(e));e.itemsWrapper.on(D+o,e._blur.bind(e))},_focus:function(){var e=this;e._focused=true;e._setCurrent()},_blur:function(){if(this._current){this._current.removeClass(l);this._current.removeAttr("id");this.itemsWrapper.removeAttr("aria-activedescendant")}},_keyDown:function(e){var t=this;var i;var a=e.keyCode;if(a==r.LEFT){i=true;t.prev()}if(a==r.RIGHT){i=true;t.next()}if(i){e.preventDefault();e.stopPropagation()}},_toggleNavigation:function(e){var t=e.nextPage||e.nextPage===0?e.nextPage:e.currentPage;var i=this._navigationContainer;var a=i.find(">a.k-scrollview-prev");var n=i.find(">a.k-scrollview-next");a.hide();n.hide();if(t||t===0){if(t!==0)a.show();if(t!=this._content.pageCount-1)n.show()}}}));return i.plugin(Y),window.kendo})}("function"==typeof define&&define.amd?define:function(e,t,i){(i||t)()});
//# sourceMappingURL=kendo.scrollview.min.js.map
