﻿<%@ Control Language="C#" AutoEventWireup="true" CodeBehind="ZadostOdobanaproj.ascx.cs"
    Inherits="KSPortal.Controls.ZadostOdobanaproj" %>
<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>
<style type="text/css">
    table.InnerTableForm > tbody > tr > td
    {
        padding: 5px;
    }
    table.InnerTableFormFieldset > tbody > tr > td, span.InnerTableFormFieldset
    {
        padding: 3px;
    }
</style>
<telerik:RadAjaxManagerProxy ID="RadAjaxManagerProxy1" runat="server">
    <AjaxSettings>
        <telerik:AjaxSetting AjaxControlID="FormView1">
            <UpdatedControls>
                <telerik:AjaxUpdatedControl ControlID="FormView1" UpdatePanelCssClass="" />
                <telerik:AjaxUpdatedControl ControlID="CV_obdobi" UpdatePanelCssClass="" />
                <telerik:AjaxUpdatedControl ControlID="TRG_doba_proj" />
                <telerik:AjaxUpdatedControl ControlID="RNTB_projekty" UpdatePanelCssClass="" />
                <telerik:AjaxUpdatedControl ControlID="RNTB_absence" UpdatePanelCssClass="" />
                <telerik:AjaxUpdatedControl ControlID="RNTB_celkem" UpdatePanelCssClass="" />
                <telerik:AjaxUpdatedControl ControlID="RNTB_fond" UpdatePanelCssClass="" />
            </UpdatedControls>
        </telerik:AjaxSetting>
        <telerik:AjaxSetting AjaxControlID="TRG_doba_proj">
            <UpdatedControls>
                <telerik:AjaxUpdatedControl ControlID="FormView1" UpdatePanelCssClass="" />
                <telerik:AjaxUpdatedControl ControlID="CV_obdobi" UpdatePanelCssClass="" />
                <telerik:AjaxUpdatedControl ControlID="TRG_doba_proj" />
                <telerik:AjaxUpdatedControl ControlID="RNTB_projekty" UpdatePanelCssClass="" />
                <telerik:AjaxUpdatedControl ControlID="RNTB_absence" UpdatePanelCssClass="" />
                <telerik:AjaxUpdatedControl ControlID="RNTB_celkem" UpdatePanelCssClass="" />
                <telerik:AjaxUpdatedControl ControlID="RNTB_fond" UpdatePanelCssClass="" />
            </UpdatedControls>
        </telerik:AjaxSetting>
    </AjaxSettings>
</telerik:RadAjaxManagerProxy>
<asp:ObjectDataSource ID="ObjectDataSource1" runat="server" InsertMethod="Insert"
    OldValuesParameterFormatString="original_{0}" SelectMethod="Retrieve" TypeName="KSProgram.Pozadavky.Pozadavekdobanaproj"
    UpdateMethod="Update" oninserting="ObjectDataSource1_Inserting" 
    oninserted="ObjectDataSource1_Inserted" 
    onupdated="ObjectDataSource1_Updated" onupdating="ObjectDataSource1_Updating">
    <InsertParameters>
        <asp:Parameter Direction="InputOutput" Name="id_poz" Type="Int32" />
        <asp:Parameter Name="obdobi" Type="DateTime" />
        <asp:Parameter Name="vyridit_do" Type="DateTime" />
        <asp:Parameter Name="cislo_pom" Type="Int16" />
        <asp:Parameter Name="adresat" Type="Decimal" />
    </InsertParameters>
    <SelectParameters>
        <asp:Parameter Name="id_pozadavku" Type="Int32" />
    </SelectParameters>
    <UpdateParameters>
        <asp:Parameter Direction="InputOutput" Name="id_poz" Type="Int32" />
        <asp:Parameter Name="vyridit_do" Type="DateTime" />
        <asp:Parameter Name="obdobi" Type="DateTime" />
    </UpdateParameters>
</asp:ObjectDataSource>

<asp:ObjectDataSource ID="ODS_cisl_proj" runat="server" OldValuesParameterFormatString="original_{0}"
    SelectMethod="Select" TypeName="KSProgram.Ciselniky.CisProjekty" 
    onselecting="ODS_cisl_proj_Selecting">
    <SelectParameters>
        <asp:Parameter Name="datum" Type="DateTime" />
    </SelectParameters>
</asp:ObjectDataSource>
<asp:ObjectDataSource ID="ODS_pomery_i" runat="server" OldValuesParameterFormatString="original_{0}"
    SelectMethod="GetPomery" TypeName="KSProgram.Funkce.Prac_pom" 
    onselecting="ODS_pomery_i_Selecting">
    <SelectParameters>
        <asp:Parameter DefaultValue="p" Name="co" Type="String" />
        <asp:Parameter DefaultValue="False" Name="use_prava" Type="Boolean" />
    </SelectParameters>
</asp:ObjectDataSource>
<kspwc:TFormView ID="FormView1" runat="server" DataSourceID="ObjectDataSource1">
    <EditItemTemplate>
        <table class="InnerTableForm">
            <tr class="tiskShow">
                <td>
                    <label>[%Zaměstnanec%]:</label>
                </td>
                <td>
                    <asp:Label runat="server" ID="L_jmeno_e" Text='<%# Eval("jmeno") %>'></asp:Label>
                </td>
                <td></td>
            </tr>
            <tr>
                <td>
                    <label>[%Období%]:</label>
                </td>
                <td>
                    <kspwc:TRadMonthYearPicker ID="TRMYP_obdobi_e" runat="server"
                        DbSelectedDate='<%# Bind("obdobi") %>' EnableTyping="False" 
                        HiddenInputTitleAttibute="Visually hidden input created for functionality purposes." 
                        >
                        <DateInput DateFormat="MMMM yyyy" DisplayDateFormat="MMMM yyyy" ReadOnly="True">
                        </DateInput>
                        <DatePopupButton Visible="False" />
                    </kspwc:TRadMonthYearPicker>
                </td>
                <td>
                </td>
            </tr>
            <tr>
                <td>
                    <label>[%Pracovní poměr%]:</label>
                </td>
                <td>
                    <kspwc:TRadComboBox ID="TRCB_pomer_e" runat="server" 
                        DataSourceID="ODS_pomery_i" DataTextField="naz_mist" DataValueField="cislo_pom" 
                         SelectedValue='<%# Bind("cislo_pom") %>' Enabled="False">
                    </kspwc:TRadComboBox>
                </td>
                 <td>
                </td>
            </tr>
            <tr>
                <td>
                    <label>[%Požadované datum vyřízení%]:</label>
                </td>
                <td>
                    <kspwc:TRadDatePicker ID="TRDP_vyriz_datum_e" runat="server"
                        DbSelectedDate='<%# Bind("vyriz_datum") %>' >
                        <DateInput DateFormat="d.M.yyyy" DisplayDateFormat="d.M.yyyy" CssClass="povinne-pole">
                        </DateInput>
                    </kspwc:TRadDatePicker>
                </td>
                <td>
                    <asp:RequiredFieldValidator ID="RFV_vyriz_datum_e" runat="server" ControlToValidate="TRDP_vyriz_datum_e"
                        Display="Dynamic" EnableClientScript="True" ErrorMessage="*"></asp:RequiredFieldValidator>
                </td>
            </tr>
        </table>
        </ItemTemplate>
    </EditItemTemplate>
    <InsertItemTemplate>
        <table class="InnerTableForm">
            <tr class="tiskShow">
                <td>
                    <label>[%Zaměstnanec%]:</label>
                </td>
                <td>
                    <asp:Label runat="server" ID="L_jmeno_i" Text='<%# Eval("jmeno") %>'></asp:Label>
                </td>
                <td></td>
            </tr>
            <tr>
                <td>
                    <label>[%Období%]:</label>
                </td>
                <td>
                    <kspwc:TRadMonthYearPicker ID="TRMYP_obdobi_i" runat="server"
                        DbSelectedDate='<%# Bind("obdobi") %>'
                         AutoPostBack="True">
                        <DateInput DateFormat="MMMM yyyy" DisplayDateFormat="MMMM yyyy" CssClass="povinne-pole">
                        </DateInput>
                    </kspwc:TRadMonthYearPicker>
                </td>
                <td>
                    <asp:RequiredFieldValidator ID="RFV_obdobi_i" runat="server" ControlToValidate="TRMYP_obdobi_i"
                        Display="Dynamic" EnableClientScript="True" ErrorMessage="*"></asp:RequiredFieldValidator>
                </td>
            </tr>
            <tr>
                <td>
                    <label>[%Pracovní poměr%]:</label>
                </td>
                <td>
                    <kspwc:TRadComboBox ID="TRCB_pomer_i" runat="server" 
                        DataSourceID="ODS_pomery_i" DataTextField="naz_mist" DataValueField="cislo_pom" 
                         SelectedValue='<%# Bind("cislo_pom") %>'>
                    </kspwc:TRadComboBox>
                </td>
                <td>
                    <asp:RequiredFieldValidator ID="RFV_pomer_i" runat="server" ControlToValidate="TRCB_pomer_i"
                        Display="Dynamic" EnableClientScript="True" ErrorMessage="*">
                    </asp:RequiredFieldValidator>
                </td>
            </tr>
            <tr>
                <td>
                    <label>[%Požadované datum vyřízení%]:</label>
                </td>
                <td>
                    <kspwc:TRadDatePicker ID="TRDP_vyriz_datum_i" runat="server" DbSelectedDate='<%# Bind("vyriz_datum") %>'
                         Width="110px">
                        <DateInput DateFormat="d.M.yyyy" DisplayDateFormat="d.M.yyyy" CssClass="povinne-pole">
                        </DateInput>
                    </kspwc:TRadDatePicker>
                </td>
                <td>
                    <asp:RequiredFieldValidator ID="RFV_vyriz_datum_i" runat="server" ControlToValidate="TRDP_vyriz_datum_i"
                        Display="Dynamic" EnableClientScript="True" ErrorMessage="*">
                    </asp:RequiredFieldValidator>
                </td>
            </tr>
        </table>
        </ItemTemplate>
    </InsertItemTemplate>
    <ItemTemplate>
        <table class="InnerTableForm">
            <tr class="tiskShow">
                <td>
                    <label>[%Zaměstnanec%]:</label>
                </td>
                <td>
                    <asp:Label runat="server" ID="L_jmeno" Text='<%# Eval("jmeno") %>'></asp:Label>
                </td>
                <td></td>
            </tr>
            <tr>
                <td>
                    <label>[%Období%]:</label>
                </td>
                <td>
                    <kspwc:TRadMonthYearPicker ID="TRMYP_obdobi_r" runat="server"
                        DbSelectedDate='<%# Eval("obdobi") %>' EnableTyping="False">
                        <DateInput DateFormat="MMMM yyyy" DisplayDateFormat="MMMM yyyy" ReadOnly="True">
                        </DateInput>
                        <DatePopupButton Visible="False" />
                    </kspwc:TRadMonthYearPicker>
                </td>
            </tr>
             <tr>
                <td>
                    <label>[%Pracovní poměr%]:</label>
                </td>
                <td>
                    <kspwc:TRadComboBox ID="TRCB_pomer_r" runat="server" 
                        DataSourceID="ODS_pomery_i" DataTextField="naz_mist" DataValueField="cislo_pom" 
                         SelectedValue='<%# Bind("cislo_pom") %>' Enabled="False">
                    </kspwc:TRadComboBox>
                </td>
            </tr>
            <tr>
                <td>
                    <label>[%Požadované datum vyřízení%]:</label>
                </td>
                <td>
                    <kspwc:TRadDatePicker ID="TRDP_vyriz_datum_r" runat="server"
                        DbSelectedDate='<%# Eval("vyriz_datum") %>' EnableTyping="False" 
                         Width="110px">
                        <DateInput DateFormat="d.M.yyyy" DisplayDateFormat="d.M.yyyy" ReadOnly="True">
                        </DateInput>
                        <DatePopupButton Visible="False" />
                    </kspwc:TRadDatePicker>
                </td>
            </tr>
        </table>
    </ItemTemplate>
</kspwc:TFormView>
<asp:CustomValidator ID="CV_obdobi" runat="server"></asp:CustomValidator>
<asp:ObjectDataSource ID="ods_proj_hod" runat="server" InsertMethod="SaveDobaNaProjektechMem"
    OldValuesParameterFormatString="original_{0}" SelectMethod="DobaNaProjektechMem"
    TypeName="KSProgram.Pozadavky.Pozadavekdobanaproj" UpdateMethod="SaveDobaNaProjektechMem"
    DeleteMethod="DeleteDobaNaProjektechMem" 
    OnInserting="ods_proj_hod_Inserting" onupdating="ods_proj_hod_Updating">
    <InsertParameters>
        <asp:Parameter Name="Id" Type="Int32" />
        <asp:Parameter Name="IdProj" Type="Int32" />
        <asp:Parameter Name="Hod" Type="Decimal" />
        <asp:Parameter Name="Poz" Type="String" />
        <asp:Parameter Name="Obd" Type="DateTime" />
        <asp:Parameter Name="OsCislo" Type="Decimal" />
        <asp:Parameter Name="CisloPom" Type="Int16" />
    </InsertParameters>
    <UpdateParameters>
        <asp:Parameter Name="Id" Type="Int32" />
        <asp:Parameter Name="IdProj" Type="Int32" />
        <asp:Parameter Name="Hod" Type="Decimal" />
        <asp:Parameter Name="Poz" Type="String" />
        <asp:Parameter Name="Obd" Type="DateTime" />
        <asp:Parameter Name="OsCislo" Type="Decimal" />
        <asp:Parameter Name="CisloPom" Type="Int16" />
    </UpdateParameters>
</asp:ObjectDataSource>
<asp:ObjectDataSource ID="ODS_cinn_hod" runat="server" OldValuesParameterFormatString="original_{0}"
    SelectMethod="CinnostiNaProjektechMem" TypeName="KSProgram.Pozadavky.Pozadavekdobanaproj"
    InsertMethod="SaveCinnostiNaProjektechMem" UpdateMethod="SaveCinnostiNaProjektechMem"
    DeleteMethod="DeleteCinnNaProjektechMem">
    <SelectParameters>
        <asp:Parameter Name="IdProjHod" Type="Int32" />
    </SelectParameters>
    <InsertParameters>
        <asp:Parameter Name="Id" Type="Int32" />
        <asp:Parameter Name="IdProjHod" Type="Int32" />
        <asp:Parameter Name="Hod" Type="Decimal" />
        <asp:Parameter Name="Nazev" Type="String" />
        <asp:Parameter Name="Popis" Type="String" />
    </InsertParameters>
    <UpdateParameters>
        <asp:Parameter Name="Id" Type="Int32" />
        <asp:Parameter Name="IdProjHod" Type="Int32" />
        <asp:Parameter Name="Hod" Type="Decimal" />
        <asp:Parameter Name="Nazev" Type="String" />
        <asp:Parameter Name="Popis" Type="String" />
    </UpdateParameters>
</asp:ObjectDataSource>
<br />
<kspwc:TRadGrid ID="TRG_doba_proj" runat="server" AllowMultiRowSelection="False"
    AutoGenerateColumns="False" AllowAutomaticDeletes="True" AllowAutomaticInserts="True"
    AllowAutomaticUpdates="True" DataSourceID="ods_proj_hod" 
    OnItemCommand="TRG_doba_proj_ItemCommand" GroupPanelPosition="Top" OnItemDeleted="TRG_doba_proj_ItemDeleted"
    OnItemInserted="TRG_doba_proj_ItemInserted" OnItemUpdated="TRG_doba_proj_ItemUpdated"
    OnItemCreated="TRG_doba_proj_ItemCreated">
    <ExportSettings>
        <Pdf PageWidth="">
        </Pdf>
    </ExportSettings>
    <ValidationSettings EnableValidation="true" CommandsToValidate="PefrormInsert" />
    <MasterTableView CommandItemDisplay="Top" DataSourceID="ods_proj_hod" Caption="[%Doba na projektech%]"
        DataKeyNames="Id" EditMode="InPlace" HierarchyLoadMode="Client" EnableHierarchyExpandAll="True"
        Name="Master" NoMasterRecordsText="[%Žádné projekty%]" >
        <CommandItemSettings AddNewRecordText="[%Přidat nový projekt%]" />
        <RowIndicatorColumn Visible="False">
        </RowIndicatorColumn>
        <DetailTables>
            <telerik:GridTableView runat="server" DataKeyNames="Id,IdProjHod" Name="Cinn" DataSourceID="ods_cinn_hod"
                EditMode="InPlace" CommandItemDisplay="Top" NoDetailRecordsText="[%Žádné aktivity%]">
                <ParentTableRelation>
                    <telerik:GridRelationFields DetailKeyField="IdProjHod" MasterKeyField="Id" />
                </ParentTableRelation>
                <CommandItemSettings AddNewRecordText="[%Přidat novou aktivitu%]" />
                <RowIndicatorColumn Visible="False">
                </RowIndicatorColumn>
                <Columns>
                    <telerik:GridEditCommandColumn ButtonType="ImageButton" />
                    <%--<telerik:GridBoundColumn DataField="Nazev" FilterControlAltText="Filter Nazev column"
                        HeaderText="[%Činnost%]" UniqueName="Nazev" MaxLength="25">
                    </telerik:GridBoundColumn>--%>
                    <telerik:GridTemplateColumn DataField="Nazev" FilterControlAltText="Filter Nazev column"
                        HeaderText="[%Činnost%]" UniqueName="Nazev">
                        <EditItemTemplate>
                            <kspwc:TRadComboBox ID="TRCB_edit_Nazev" runat="server" EnableLoadOnDemand="True"
                                EnableVirtualScrolling="True" Height="150px" ShowMoreResultsBox="True" DropDownAutoWidth="Enabled"
                                EmptyMessage="[%Činnost%]"  Text='<%# Bind("Nazev") %>' MaxLength="25">
                                <WebServiceSettings Method="GetCinnosti" Path="~/PrivateWebServices/AutoCompleteService.asmx" />
                            </kspwc:TRadComboBox>
                            <asp:RequiredFieldValidator ID="RFV_edit_Nazev" runat="server" ControlToValidate="TRCB_edit_Nazev"
                                Display="Dynamic" EnableClientScript="True" ErrorMessage="*"></asp:RequiredFieldValidator>
                        </EditItemTemplate>
                        <InsertItemTemplate>
                            <kspwc:TRadComboBox ID="TRCB_insert_Nazev" runat="server" EnableLoadOnDemand="True"
                                EnableVirtualScrolling="True" Height="150px" ShowMoreResultsBox="True" DropDownAutoWidth="Enabled"
                                EmptyMessage="[%Činnost%]"  Text='<%# Bind("Nazev") %>' MaxLength="25">
                                <WebServiceSettings Method="GetCinnosti" Path="~/PrivateWebServices/AutoCompleteService.asmx" />
                            </kspwc:TRadComboBox>
                            <asp:RequiredFieldValidator ID="RFV_insert_Nazev" runat="server" ControlToValidate="TRCB_insert_Nazev"
                                Display="Dynamic" EnableClientScript="True" ErrorMessage="*"></asp:RequiredFieldValidator>
                        </InsertItemTemplate>
                        <ItemTemplate>
                            <asp:Label ID="L_item_Nazev" runat="server" Text='<%# Eval("Nazev") %>'></asp:Label>
                        </ItemTemplate>
                    </telerik:GridTemplateColumn>
                    <telerik:GridNumericColumn DataField="Hod" DataType="System.Decimal" DecimalDigits="2"
                        FilterControlAltText="Filter Hod column" HeaderText="[%Hodiny%]" MaxValue="99999.99"
                        MinValue="0" UniqueName="Hod">
                        <ColumnValidationSettings EnableRequiredFieldValidation="True">
                            <RequiredFieldValidator Display="Dynamic" ErrorMessage="*" ForeColor="Red"></RequiredFieldValidator>
                        </ColumnValidationSettings>
                    </telerik:GridNumericColumn>
                    <telerik:GridBoundColumn DataField="Popis" FilterControlAltText="Filter Popis column"
                        HeaderText="[%Popis%]" UniqueName="Popis" MaxLength="250">
                    </telerik:GridBoundColumn>
                    <telerik:GridButtonColumn ConfirmText="[%Opravdu si přejete smazat záznam%]?" ConfirmDialogType="RadWindow"
                        ConfirmTitle="[%Mazání záznamu%]" ButtonType="ImageButton" CommandName="Delete" />
                </Columns>
            </telerik:GridTableView>
        </DetailTables>
        <RowIndicatorColumn Visible="False">
        </RowIndicatorColumn>
        <ExpandCollapseColumn Created="True">
        </ExpandCollapseColumn>
        <Columns>
            <telerik:GridEditCommandColumn ButtonType="ImageButton" />
            <telerik:GridDropDownColumn DataField="IdProj" FilterControlAltText="Filter IdProj column"
                HeaderText="[%Projekt%]" UniqueName="IdProj" DataSourceID="ODS_cisl_proj" ListTextField="cely_nazev"
                ListValueField="id" DropDownControlType="RadComboBox">
                <ColumnValidationSettings EnableRequiredFieldValidation="True">
                    <RequiredFieldValidator Display="Dynamic" ErrorMessage="*" ForeColor="Red"></RequiredFieldValidator>
                </ColumnValidationSettings>
            </telerik:GridDropDownColumn>
            <telerik:GridNumericColumn DataField="Hod" DataType="System.Decimal" DecimalDigits="2"
                FilterControlAltText="Filter Hod column" HeaderText="[%Hodiny%]" UniqueName="Hod"
                MaxValue="99999.99" MinValue="0">
                <ColumnValidationSettings EnableRequiredFieldValidation="True">
                    <RequiredFieldValidator Display="Dynamic" ErrorMessage="*" ForeColor="Red"></RequiredFieldValidator>
                </ColumnValidationSettings>
            </telerik:GridNumericColumn>
            <telerik:GridBoundColumn DataField="Poz" FilterControlAltText="Filter Poz column"
                HeaderText="[%Poznámka%]" UniqueName="Poz" MaxLength="250">
            </telerik:GridBoundColumn>
            <telerik:GridButtonColumn ConfirmText="[%Opravdu si přejete smazat záznam%]?" ConfirmDialogType="RadWindow"
                ConfirmTitle="[%Mazání záznamu%]" ButtonType="ImageButton" CommandName="Delete" />
        </Columns>
        <EditFormSettings>
            <EditColumn ButtonType="ImageButton">
            </EditColumn>
        </EditFormSettings>
    </MasterTableView>
</kspwc:TRadGrid>
<br />
<table runat="server" id="T_sumar" class="InnerTableForm ksprvek">
    <tr>
        <td>
            [%Celkem na projektech%]:
        </td>
        <td colspan="3">
            <telerik:RadNumericTextBox ID="RNTB_projekty" runat="server" ReadOnly="True">
            </telerik:RadNumericTextBox>
        </td>
    </tr>
    <tr>
        <td>
            [%Absence%]:
        </td>
        <td colspan="3">
            <telerik:RadNumericTextBox ID="RNTB_absence" runat="server" ReadOnly="True">
            </telerik:RadNumericTextBox>
        </td>
    </tr>
    <tr>
        <td>
            [%Celkem%]:
        </td>
        <td>
            <telerik:RadNumericTextBox ID="RNTB_celkem" runat="server" ReadOnly="True" Font-Bold="True">
            </telerik:RadNumericTextBox>
        </td>
        <td>
            [%Fond%]:
        </td>
        <td>
            <telerik:RadNumericTextBox ID="RNTB_fond" runat="server" ReadOnly="True">
            </telerik:RadNumericTextBox>
        </td>
    </tr>
</table>
