﻿<%@ Control Language="C#" AutoEventWireup="true" Inherits="Controls_ZadostOodmeny" CodeBehind="ZadostOodmeny.ascx.cs" %>
<%@ Register Assembly="WebControls" Namespace="KSProgram.WebControls" TagPrefix="wc" %>
<%@ Register Assembly="WebControlsAlone" Namespace="KSProgram.WebControlsAlone" TagPrefix="wca" %>
<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>
<%--<%@ Register assembly="AjaxControlToolkit" namespace="AjaxControlToolkit" tagprefix="ajax" %>--%>

<telerik:RadCodeBlock ID="RadCodeBlock1" runat="server">
    <script type="text/javascript">
        function ddl_prac_str_OnClientItemsRequesting(sender, eventArgs)
        {
            var context = eventArgs.get_context();
            context["podnik"] = "jen_akt";
            context["EmptyRow"] = "a";
            context["zdroj"] = "odmeny";
        }
        function showSestavu() {
            var WSodmSestava = $find("<%= rw_sestava_odmeny.ClientID %>");
            if (WSodmSestava){                
                WSodmSestava.show();
                WSodmSestava.maximize();
            }
        }
        var dd_dim1;
        var dd_dim2;
        var grid;
        function TRCB_DropDownClosed(sender, args) {
            //sender.clearItems();
            //alert("ha");
        }
        function clientLoad_combo_dim1(sender, args) {
            dd_dim1 = sender;
        }
        function clientLoad_combo_dim2(sender, args) {
            dd_dim2 = sender;           
        }
         function dd_dim1_OnClientItemsRequesting(sender, eventArgs) {
             var context = eventArgs.get_context();            
             context["obdobi"] = getRokMes();            
         }

        /*
         function dd_dim2_OnClientItemsRequesting(sender, eventArgs) {
            
             var masterTable = grid.get_MasterTableView();
             var index = -1;
             for (var i = 0; i < masterTable.get_dataItems().length; i++) {
                 var o = masterTable.get_dataItems()[i].findControl("dd_dim2");
                 if (o == sender) {
                     index = i;
                     break;
                 }
             }
             if (index > -1) {
                 var dd_dim1 = masterTable.get_dataItems()[index].findControl('dd_dim1');
                 var val = dd_dim.get_value();
                 alert(val);
             }


             var context = eventArgs.get_context();
             context["obdobi"] = getRokMes();
             context["projekt"] = dd_dim1.get_value();
         }           
       */
         function getRokMes() {
             var el = document.getElementById("ctl00_HlavniOblast_UserControl_FormView1_ddlb_obdobi");
             var rok = el.value.substring(3, 7);
             var mes = el.value.substring(0, 2);
             return rok + mes;
         }
        
       
        function GridCreated(sender, eventArgs) 
        {
            grid = sender;
        }
        
    </script>
    <style>
        .left {
          float: left;
          width:calc(100% - 30px);
          text-align: left;         
          display: inline
        }
        .right {
          float: left;
          text-align: right;  
          width:30px;       
          display: inline;
          color:blue;
          font-size:90%;        
        }
        .pozn{
            border: solid 1px #cdcdcd;
        }
    </style>
</telerik:RadCodeBlock>
<asp:ObjectDataSource ID="ObjectDataSource1" runat="server"
    OldValuesParameterFormatString="original_{0}" SelectMethod="Retrieve"
    TypeName="KSProgram.Pozadavky.Pozadavekodmeny" InsertMethod="Insert"
    OnInserting="ObjectDataSource1_Inserting"
    OnInserted="ObjectDataSource1_Inserted"
    OnUpdating="ObjectDataSource1_Updating" UpdateMethod="Update"
    OnDataBinding="ObjectDataSource1_DataBinding">
    <SelectParameters>
        <asp:Parameter Name="id_pozadavku" Type="Int32" />
    </SelectParameters>
    <InsertParameters>
        <asp:Parameter Name="id_poz" Type="Int32" Direction="InputOutput" />
        <asp:Parameter Name="duvod" Type="String" />
        <asp:Parameter Name="obdobi" Type="DateTime" />
        <asp:Parameter Name="vyridit_do" Type="DateTime" />
        <asp:Parameter Name="adresat" Type="Decimal" />
    </InsertParameters>
    <UpdateParameters>
        <asp:Parameter Name="id_poz" DefaultValue="1" Type="Int32" />
        <asp:Parameter Name="duvod" Type="String" DefaultValue="&quot;init&quot;" />
        <asp:Parameter Name="obdobi" Type="DateTime" DefaultValue="" />
        <asp:Parameter Name="vyridit_do" Type="DateTime" />
    </UpdateParameters>
</asp:ObjectDataSource>

<telerik:RadAjaxManagerProxy ID="RadAjaxManagerProxy1" runat="server">
    <AjaxSettings>
        <telerik:AjaxSetting AjaxControlID="TRG_Seznam">
            <UpdatedControls>
                <telerik:AjaxUpdatedControl ControlID="TRG_Seznam" />
                <telerik:AjaxUpdatedControl ControlID="gv_porizovak" />
            </UpdatedControls>
        </telerik:AjaxSetting>
        <telerik:AjaxSetting AjaxControlID="TRG_porizovak_rekapitulace">
            <UpdatedControls>
                <telerik:AjaxUpdatedControl ControlID="TRG_porizovak_rekapitulace" />
            </UpdatedControls>
        </telerik:AjaxSetting>
    </AjaxSettings>
    <AjaxSettings>
        <telerik:AjaxSetting AjaxControlID="TRG_porizovak_prohl">
            <UpdatedControls>
                <telerik:AjaxUpdatedControl ControlID="TRG_porizovak_prohl" />
            </UpdatedControls>
        </telerik:AjaxSetting>
    </AjaxSettings>
</telerik:RadAjaxManagerProxy>     
<asp:Label runat="server" ID="lab_zamek_info" Text="" Font-Size="Larger" ForeColor="Red"></asp:Label>
<asp:FormView ID="FormView1" runat="server" DefaultMode="ReadOnly"
    OnDataBound="FormView1_DataBound" OnItemUpdated="FormView1_ItemUpdated"
    OnModeChanged="FormView1_ModeChanged" 
    OnModeChanging="FormView1_ModeChanging">

    <ItemTemplate>
        
        <asp:Table runat="server" ID="TableItem" SkinID="RamAPozadi">
            <asp:TableHeaderRow runat="server" ID="TableHeaderRowItem">
                <asp:TableCell runat="server" ColumnSpan="4" ID="TableCellItem14x" SkinID="TitleRowStyle">
                    <asp:Label ID="Label7x" runat="server" Text="[%Požadavek na odměny%]"></asp:Label>
                </asp:TableCell>
            </asp:TableHeaderRow>

            <asp:TableRow runat="server" ID="TableRow1">
                <asp:TableCell runat="server" ID="TableCell1a" HorizontalAlign="Right" SkinID="DataFieldHeaderStyle">
                    <asp:Label ID="Label8a" runat="server" SkinID="DataFieldHeaderStyle" Text="[%Žadatel%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell ColumnSpan="3" runat="server" SkinID="DataFieldStyle" ID="TableCell2">
                    <asp:Label ID="Label9" runat="server" Text='<%# ( KSProgram.Funkce.Pracovnik.OsCisloPrijmeniJmeno(Convert.ToDecimal(DataBinder.Eval(Container.DataItem, "os_cislo")))) %>'></asp:Label>
                </asp:TableCell>
            </asp:TableRow>

            <asp:TableRow runat="server" ID="TableRow2">
                <asp:TableCell runat="server" ID="TableCell9" HorizontalAlign="Right" SkinID="DataFieldHeaderStyle">
                    <asp:Label ID="Label2" runat="server" SkinID="DataFieldHeaderStyle" Text="[%Období%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell ColumnSpan="3" runat="server" SkinID="DataFieldStyle" ID="TableCell10">
                    <asp:Label ID="Label5" runat="server" Text='<%# DataBinder.Eval(Container.DataItem, "obdobi") %>'></asp:Label>
                </asp:TableCell>
            </asp:TableRow>

            <asp:TableRow runat="server" ID="TableRow3">
                <asp:TableCell ColumnSpan="4" runat="server" SkinID="DataFieldStyle" ID="TableCell12">
                    <div style="padding: 4px;">                       
                        <kspwc:TRadGrid ID="TRG_porizovak_prohl" runat="server" DataSourceID="ds_porizovak_prohl" AutoGenerateColumns="false" AutoMasterGridWidth="true">
                            <MasterTableView Caption="[%Seznam zaměstnanců%]">
                                <Columns>
                                    <telerik:GridBoundColumn DataField="os_cislo" HeaderText="[%Os. číslo%]" />
                                    <telerik:GridBoundColumn DataField="cislo_pom" HeaderText="[%Č.P.%]" />
                                    <telerik:GridBoundColumn DataField="jmeno" HeaderText="[%Jméno%]" />
                                    <telerik:GridBoundColumn DataField="kod_cely" HeaderText="[%Kód%]" />                                    
                                    <telerik:GridBoundColumn DataField="dny" HeaderText="[%Dny%]" />
                                    <telerik:GridBoundColumn DataField="hodiny" HeaderText="[%Hodiny%]" />
                                    <telerik:GridBoundColumn DataField="sazba" HeaderText="[%Sazba%]" />
                                    <telerik:GridBoundColumn DataField="castka" HeaderText="[%Částka%]" /> 
                                    <telerik:GridBoundColumn DataField="prac_str" HeaderText="[%Středisko%]" />                                   
                                    <telerik:GridTemplateColumn HeaderText="[%Projekt%]"  UniqueName="id_projekt" >
                                        <itemtemplate>
                                            <asp:Label runat="server" id="lab_projekt" Text='<%# _projekt_cely_nazev(DataBinder.Eval(Container.DataItem,"id_vazby")) %>' ></asp:Label>
                                        </itemtemplate>
                                    </telerik:GridTemplateColumn>
                                    <telerik:GridBoundColumn DataField="c_pole1" HeaderText="[%Projekt%]" UniqueName="c_pole1" />  
                                    <telerik:GridBoundColumn DataField="c_pole2" HeaderText="[%Úloha%]"  UniqueName="c_pole2"/>
                                    <telerik:GridTemplateColumn UniqueName="">
                                        <ItemTemplate>
                                            </tr>
                                            <tr>
                                                <td></td>
                                                <td colspan="8">
                                                    <asp:Label runat="server" ID="txt_poznamka" Width="100%" Height="35" MaxLength="300" TextMode="MultiLine" CssClass="pozn"
                                                        Visible='<%# (PoznamkaVisible) %>' Text='<%# Eval("poznamka") %>'></asp:Label></td>
                                            </tr>
                                        </ItemTemplate>
                                    </telerik:GridTemplateColumn>
                                </Columns>
                            </MasterTableView>
                        </kspwc:TRadGrid>
                        <asp:ObjectDataSource runat="server" ID="ds_porizovak_prohl" OnDataBinding="ds_porizovak_prohl_DataBinding"
                            OldValuesParameterFormatString="original_{0}" SelectMethod="GetPorizZam"
                            TypeName="KSProgram.Pozadavky.Pozadavekodmeny">
                            <SelectParameters>
                                <asp:Parameter DefaultValue="0" Name="id_poz" Type="Int32" />
                            </SelectParameters>
                        </asp:ObjectDataSource>
                    </div>
                </asp:TableCell>
            </asp:TableRow>

            <asp:TableRow runat="server" ID="TableRowItem3">
                <asp:TableCell runat="server" ID="TableCellItem7" SkinID="DataFieldHeaderStyle" HorizontalAlign="Right">
                    <asp:Label ID="Label3x" runat="server" Text="[%Poznámka%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell ColumnSpan="3" runat="server" ID="TableCellItem8" SkinID="DataFieldStyle">
                    <%--<asp:Label ID="LabelDuvodx" runat="server" Text='<%# Bind("duvod") %>' Height="39px" Width="200px"></asp:Label>--%>
                    <telerik:RadTextBox runat="server" ID="RadTextBox3" Width="100%" TextMode="MultiLine" Text='<%# Bind("duvod") %>' Resize="None" ReadOnly="true"></telerik:RadTextBox>
                </asp:TableCell>
            </asp:TableRow>
            <asp:TableRow runat="server" ID="TableRowItem4">
                <asp:TableCell runat="server" ID="TableCellItem9" SkinID="DataFieldHeaderStyle" HorizontalAlign="Right">
                    <asp:Label ID="Label4x" runat="server" Text="[%Vyřešit do%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell runat="server" ID="TableCellItem10" SkinID="DataFieldStyle">
                    <asp:Label ID="LabelDatvyrizeni" runat="server" Text='<%# KSProgram.Funkce.F_DateTime.DateTimeToString(DataBinder.Eval(Container.DataItem,"vyridit_do"), "d") %>'></asp:Label>
                </asp:TableCell>
            </asp:TableRow>

            <asp:TableRow runat="server" ID="TableRow6">
                <asp:TableCell runat="server" ID="TableCell1" SkinID="DataFieldHeaderStyle" HorizontalAlign="Right">
                    <asp:Label ID="Label8" runat="server" Text="[%Aktuální stav a datum změny stavu%]:"></asp:Label>
                </asp:TableCell>

                <asp:TableCell ColumnSpan="2" runat="server" ID="TableCell4" SkinID="DataFieldStyle">
                    <asp:Label ID="Label11" runat="server" Text='<%# DataBinder.Eval(Container.DataItem,"stav") %>'></asp:Label>
                </asp:TableCell>

                <asp:TableCell runat="server" ID="TableCell3" SkinID="DataFieldStyle">
                    <asp:Label ID="Label10" runat="server" Text='<%# KSProgram.Funkce.F_DateTime.DateTimeToString(DataBinder.Eval(Container.DataItem,"vyriz_datum"), "d") %>'></asp:Label>
                </asp:TableCell>
            </asp:TableRow>


        </asp:Table>
    </ItemTemplate>
    <InsertItemTemplate>
        <asp:Table ID="TableInsert" runat="server" SkinID="RamAPozadi">
            <asp:TableHeaderRow runat="server" ID="TableHeaderRowInsert">
                <asp:TableCell runat="server" ColumnSpan="4" ID="TableCellItem14" SkinID="TitleRowStyle">
                    <asp:Label ID="Label7" runat="server" Text="[%Nový požadavek na odměny%]"></asp:Label>
                </asp:TableCell>
            </asp:TableHeaderRow>

            <asp:TableRow runat="server" ID="TableRow_obdobi">
                <asp:TableCell runat="server" ID="TableCell7" HorizontalAlign="right" SkinID="DataFieldHeaderStyle">
                    <asp:Label ID="Label1" runat="server" Text="[%Období%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell runat="server" ID="TableCell8" ColumnSpan="3" SkinID="DataFieldStyle">
                    <wc:DDLObdobi runat="server" ID="ddlb_obdobi" JenAktualniMzdove="true"></wc:DDLObdobi>
                </asp:TableCell>
            </asp:TableRow>

            <asp:TableRow runat="server" ID="row_porizovak">
                <asp:TableCell runat="server" ID="cell_porizovak" ColumnSpan="4" VerticalAlign="Top">
                    <table style="border-collapse: collapse;">
                        <tr>
                            <td style="padding: 5,0,10,0">
                                <wc:TLinkButton runat="server" ID="lb_prehled" Text="[%Rekapitulace%]" SkinID="button" OnCommand="lb_prehled_oncommand"></wc:TLinkButton>
                                <wc:TLinkButton runat="server" ID="lb_editace" Text="[%Editace%]" SkinID="button" OnCommand="lb_editace_oncommand" Visible="false"></wc:TLinkButton>
                            </td>
                        </tr>
                    </table>
                    <asp:Panel runat="server" ID="pan_poriz">
                        <table style="border-collapse: collapse;">
                            <tr>
                                <td style="vertical-align: top">                                  
                                   
                                    <kspwc:TRadGrid ID="TRG_Seznam" runat="server" AutoGenerateColumns="false" OnSelectedIndexChanged="TRG_Seznam_SelectedIndexChanged" UseSaveSetting="true" AllowPaging="True" AllowSorting="true" 
                                        AutoMasterGridWidth="true" OnDataBound="TRG_Seznam_DataBound" OnItemDataBound="TRG_Seznam_ItemDataBound" OnNeedDataSource="TRG_Seznam_NeedDataSource">
                                        <MasterTableView CommandItemDisplay="Top" PageSize="5" DataKeyNames="os_cislo,cislo_pom"  Caption="[%Seznam zaměstnanců%]" >
                                            <PagerStyle PageButtonCount="3" PageSizes="5,10,20,30,50,100,200,500" />
                                            <Columns>
                                                <telerik:GridButtonColumn Text="Select" UniqueName="select_col" CommandName="Select" ButtonType="ImageButton" ImageUrl="~/Images/Select_tel.png" />
                                                <telerik:GridBoundColumn DataField="os_cislo" HeaderText="[%Os. číslo%]" SortExpression="os_cislo" />
                                                <telerik:GridBoundColumn DataField="cislo_pom" HeaderText="[%Č.P.%]" SortExpression="cislo_pom" />
                                                <%--<telerik:GridBoundColumn DataField="cele_jmeno" HeaderText="[%Jméno%]" SortExpression="cele_jmeno" />--%>
                                                 <telerik:GridTemplateColumn HeaderText="[%Jméno%]" SortExpression="cele_jmeno" DataField="cele_jmeno">
                                                    <ItemTemplate>
                                                       <telerik:RadToolTip  ID="RadToolTip1" runat="server" TargetControlID="pocty_pozadavku"
                                                                    IsClientID="false" RelativeTo="Element" ShowEvent="OnMouseOver" HideEvent="LeaveTargetAndToolTip"
                                                                    Animation="Fade" ShowDelay="10" Width="200" Height="50" Position="TopRight"
                                                                    Text="[%Počet schválených / počet běžících požadavků ve stejném období%].">
                                                        </telerik:RadToolTip>
                                                     
                                                        <div class="left" >
                                                            <asp:Label runat="server" ID="lab_jmeno"  Text='<%# DataBinder.Eval(Container.DataItem,"cele_jmeno") %>'></asp:Label>
                                                        </div>  
                                                        <asp:Panel runat="server" ID="pocty_pozadavku" CssClass="right">
                                                             <asp:Label runat="server" ID="Label6"  Text='<%# DataBinder.Eval(Container.DataItem,"poz_schvalenych")+"/ "+ DataBinder.Eval(Container.DataItem,"poz_v_procesu") %>'></asp:Label>
                                                        </asp:Panel>                                                  
                                                       
                                                    </ItemTemplate>
                                                </telerik:GridTemplateColumn>
                                                <telerik:GridBoundColumn DataField="prac_str" HeaderText="[%Prac. stř.%]" SortExpression="prac_str" />
                                                <telerik:GridBoundColumn DataField="druh_pomeru" HeaderText="[%Druh p.p.%]" SortExpression="druh_pomeru" />
                                                <telerik:GridBoundColumn DataField="stav" HeaderText="[%Stav%]" SortExpression="stav" />
                                                <%--<telerik:GridBoundColumn DataField="pocty" HeaderText="" SortExpression="pocty" >
                                                    <ItemStyle Wrap="false" />
                                                </telerik:GridBoundColumn>--%>
                                                <telerik:GridRowIndicatorColumn></telerik:GridRowIndicatorColumn>
                                            </Columns>
                                            <CommandItemTemplate>
                                                <%--<kspwc:GridCommandItemControl ID="gcic" runat="server" RebindButton-Visible="false" ExportButton-Visible="false"></kspwc:GridCommandItemControl>--%>
                                                <kspwc:GridCommandItemControl ID="GridCommandItemControl1" runat="server" PracPomeryComboBox-Visible="true">
                                                    <ExportButton ID="ExportButton1" runat="server" ShowExportToExcelBIFFItem="true" ShowExportToExcelHtmlItem="false"/>
                                                    <PrimiPodrizeniButton ID="PrimiPodrizeniButton1" runat="server" Visible="true"></PrimiPodrizeniButton>
                                                    <PracPomeryComboBox runat="server" AutoPostBack="true" OnDataBound="combo_pomer_DataBound"></PracPomeryComboBox>
                                                </kspwc:GridCommandItemControl>
                                            </CommandItemTemplate>
                                        </MasterTableView>
                                    </kspwc:TRadGrid>
                                </td>

                                <td style="vertical-align: top">
                                    <asp:ObjectDataSource runat="server" ID="gs_porizovak"
                                        OldValuesParameterFormatString="original_{0}" SelectMethod="GetPorizZam"
                                        TypeName="KSProgram.Pozadavky.Pozadavekodmeny">
                                        <SelectParameters>
                                            <asp:Parameter DefaultValue="0" Name="id_poz" Type="Int32" />
                                            <asp:ControlParameter ControlID="TRG_Seznam" DefaultValue="" Name="os_cislo"
                                                PropertyName="SelectedValues[&quot;os_cislo&quot;]" Type="Decimal" />
                                            <asp:ControlParameter ControlID="TRG_Seznam" DefaultValue="" Name="cislo_pom"
                                                PropertyName="SelectedValues[&quot;cislo_pom&quot;]" Type="Int16" />
                                        </SelectParameters>
                                    </asp:ObjectDataSource>

                                    <wc:TGridView ID="gv_porizovak" runat="server" DataSourceID="gs_porizovak"
                                        ShowFooter="True" ShowFooterWhenEmpty="True"
                                        OnRowDataBound="gv_porizovak_RowDataBound"
                                        OnDataBinding="gv_porizovak_DataBinding"
                                        OnRowCreated="gv_porizovak_RowCreated"
                                        OnRowCommand="gv_porizovak_RowCommand">                                          
                                        <Columns>
                                            <asp:TemplateField HeaderText="[%Kód%]">
                                                <ItemTemplate>
                                                    <asp:Label ID="Lab_polozka" runat="server" Text='<%# Bind("kod_cely") %>'
                                                         Visible='<%# _visibleKod(DataBinder.Eval(Container.DataItem, "kod_cely").ToString()) %>'></asp:Label>
                                                    <asp:Panel runat="server" ID="pan_dd_kod"  Visible='<%# (!_visibleKod(DataBinder.Eval(Container.DataItem, "kod_cely").ToString())) %>'>
                                                    <kspwc:TRadComboBox ID="ddl_kod" runat="server" DropDownAutoWidth="Enabled" OnSelectedIndexChanged="ddl_kod_SelectedIndexChanged"                                                       
                                                        EnableLoadOnDemand="True" EnableVirtualScrolling="true" AutoPostBack="true" SelectedValue='<%# Bind("kod") %>'
                                                        Height="250px" 
                                                        ShowMoreResultsBox="True" Width="200px"  EnableAutomaticLoadOnDemand="true">
                                                        <WebServiceSettings Method="GetPorizovakKody"  Path="~/PrivateWebServices/AutoCompleteService.asmx" />
                                                    </kspwc:TRadComboBox>       
                                                        </asp:Panel>      
                                                </ItemTemplate>
                                                <FooterTemplate>
                                                </FooterTemplate>
                                            </asp:TemplateField>                                                                
                                             
                                            <asp:TemplateField HeaderText="[%Dny%]">
                                                <ItemTemplate>                                                   
                                                    <telerik:RadNumericTextBox ID="NumTextBox_dny" runat="server" DbValue='<%# Bind("dny") %>' OnTextChanged="TextBoxOnChanged"
                                                        Enabled='<%# Bind("dny_p") %>' Width="75" BackColor="LightBlue" DataType="System.Decimal" MaxValue="99" NumberFormat-DecimalDigits="1">
                                                    </telerik:RadNumericTextBox>
                                                </ItemTemplate>
                                            </asp:TemplateField>
                                            <asp:TemplateField HeaderText="[%Hodiny%]">
                                                <ItemTemplate>                                                   
                                                    <telerik:RadNumericTextBox ID="NumTextBox_hodiny" runat="server" DbValue='<%# Bind("hodiny") %>' OnTextChanged="TextBoxOnChanged"
                                                        Enabled='<%# Bind("hodiny_p") %>' Width="75" BackColor="LightBlue" DataType="System.Decimal" MaxValue="999" NumberFormat-DecimalDigits="2">
                                                    </telerik:RadNumericTextBox>
                                                </ItemTemplate>

                                            </asp:TemplateField>
                                            <asp:TemplateField HeaderText="[%Sazba%]">
                                                <ItemTemplate>                                                   
                                                    <telerik:RadNumericTextBox ID="NumTextBox_sazba" runat="server" DbValue='<%# Bind("Sazba") %>' OnTextChanged="TextBoxOnChanged"
                                                        Enabled='<%# Bind("sazba_p") %>' Width="75" BackColor="LightBlue" DataType="System.Decimal" NumberFormat-DecimalDigits="4">
                                                    </telerik:RadNumericTextBox>
                                                </ItemTemplate>

                                            </asp:TemplateField>
                                            <asp:TemplateField HeaderText="[%Částka%]">
                                                <ItemTemplate>                                                   
                                                    <telerik:RadNumericTextBox ID="NumTextBox_castka" runat="server" DbValue='<%# Bind("castka") %>' OnTextChanged="TextBoxOnChanged"
                                                        Enabled='<%# Bind("castka_p") %>' Width="75" BackColor="LightBlue" DataType="System.Decimal" NumberFormat-DecimalDigits="2">
                                                    </telerik:RadNumericTextBox>
                                                </ItemTemplate>
                                            </asp:TemplateField>
                                             <asp:TemplateField HeaderText="[%Středisko%]">
                                               <ItemTemplate> 
                                                    <kspwc:TRadComboBox ID="ddl_prac_str" runat="server" DropDownAutoWidth="Enabled" OnSelectedIndexChanged="ddl_prac_str_SelectedIndexChanged"
                                                        EnableLoadOnDemand="True" EnableVirtualScrolling="true" AutoPostBack="true" SelectedValue='<%# Bind("prac_str") %>'
                                                        Height="250px" OnClientItemsRequesting="ddl_prac_str_OnClientItemsRequesting"
                                                        ShowMoreResultsBox="True" Width="200px"  EnableAutomaticLoadOnDemand="true">
                                                        <WebServiceSettings Method="GetStred"  Path="~/PrivateWebServices/AutoCompleteService.asmx" />
                                                    </kspwc:TRadComboBox>                 
                                                </ItemTemplate>                                      
                                            </asp:TemplateField>          
                                            <asp:TemplateField HeaderText="[%Projekt%]"  >
                                                <ItemTemplate>                                                   
                                                    <kspwc:TRadComboBox ID="combo_projekt" runat="server" DropDownAutoWidth="Enabled" OnSelectedIndexChanged="combo_projekt_SelectedIndexChanged"
                                                        EnableLoadOnDemand="True" EnableVirtualScrolling="true" AutoPostBack="true" SelectedValue='<%# Bind("id_vazby") %>'
                                                        Height="250px"
                                                        ShowMoreResultsBox="True" Width="200px"  EnableAutomaticLoadOnDemand="true">
                                                        <WebServiceSettings Method="GetCisProjekty" Path="~/PrivateWebServices/AutoCompleteService.asmx" />
                                                    </kspwc:TRadComboBox>
                                                </ItemTemplate>
                                            </asp:TemplateField>
                                            <asp:TemplateField HeaderText="[%Projekt%]">
                                                <ItemTemplate>
                                                    <kspwc:TRadComboBox ID="dd_dim1" runat="server" DropDownAutoWidth="Enabled" OnSelectedIndexChanged="dd_dim1_SelectedIndexChanged"
                                                        EnableLoadOnDemand="True" EnableVirtualScrolling="true" AutoPostBack="true" SelectedValue='<%# Bind("c_pole1") %>'
                                                        Height="250px" OnClientItemsRequesting="dd_dim1_OnClientItemsRequesting" 
                                                        ShowMoreResultsBox="True" Width="200px"  EnableAutomaticLoadOnDemand="true">                                                        
                                                        
                                                       <WebServiceSettings Method="GetDim1"  Path="~/PrivateWebServices/AutoCompleteService.asmx" />
                                                    </kspwc:TRadComboBox>                                                    
                                                                 
                                                   
                                                    <asp:CustomValidator ID="sv_dim1" Display="Dynamic" runat="server" Text="[%Neplatná hodnota%]" ErrorMessage="[%Neplatná hodnota%]" ControlToValidate="dd_dim1"
                                                        ValidationGroup="edit" OnServerValidate="dim1_validate"></asp:CustomValidator>
                                                </ItemTemplate>
                                            </asp:TemplateField>

                                            <asp:TemplateField HeaderText="[%Úloha%]" >
                                                <ItemTemplate>
                                                     <kspwc:TRadComboBox AutoPostBack="true" ID="dd_dim2"  runat="server" DropDownAutoWidth="Enabled"  DataValueField="uloha" DataTextField="cely_nazev" OnDataBinding="dd_dim2_DataBinding"
                                          OnSelectedIndexChanged="dd_dim2_SelectedIndexChanged" Height="150px" DataSourceID="ds_uloha" Width="200px"  >
                                      
                                     </kspwc:TRadComboBox>
                                      <asp:ObjectDataSource runat="server" ID="ds_uloha"
                                                        OldValuesParameterFormatString="original_{0}" SelectMethod="Ulohy_pro_projekt"
                                                        TypeName="KSProgram.Dochazka.dch_poriz_ukolu">
                                          <SelectParameters>
                                              <asp:Parameter Name="projekt" DbType="String" />
                                              <asp:Parameter Name="obdobi" DbType="DateTime" />
                                              <asp:Parameter Name="emptyRow" DbType="Boolean" DefaultValue="true" />
                                          </SelectParameters>
                                      </asp:ObjectDataSource>
                                      <asp:CustomValidator ID="sv_dim2" runat="server" Display="Dynamic" Text="[%Neplatná hodnota%]" ErrorMessage="[%Neplatná hodnota%]" ControlToValidate="dd_dim2"
                                            ValidationGroup="edit" OnServerValidate="dim2_validate"></asp:CustomValidator>
                                                </ItemTemplate>
                                            </asp:TemplateField>
                                        
                                            <asp:TemplateField >
                                                <ItemTemplate>
                                                    </tr>
                                                    <tr>
                                                        <td></td>
                                        <td colspan="5"><telerik:RadTextBox runat="server" ID="txt_poznamka" Width="100%" Height="35" MaxLength="300" TextMode="MultiLine" CssClass="pozn"
                                            Visible='<%# (PoznamkaVisible) %>' Text='<%# Bind("poznamka") %>' AutoPostBack="false" OnTextChanged="txt_poznamka_TextChanged"></telerik:RadTextBox></td>
                                                        </tr>
                                                </ItemTemplate>
                                            </asp:TemplateField>
                                        
                                        </Columns>
                                    </wc:TGridView>

                                </td>
                            </tr>
                        </table>
                    </asp:Panel>
                    <asp:Panel runat="server" ID="pan_prohl" Visible="false">
                        <%--<wc:TGridView ID="gv_porizovak_rekapitulace" runat="server" DataSourceID="ds_porizovak_rekapitulace">
                            <Columns>
                                <asp:BoundField DataField="os_cislo" HeaderText="[%Os. číslo%]" />
                                <asp:BoundField DataField="cislo_pom" HeaderText="[%Č.P.%]" />
                                <asp:BoundField DataField="jmeno" HeaderText="[%Jméno%]" />
                                <asp:BoundField DataField="kod_cely" HeaderText="[%Kód%]" />
                                <asp:BoundField DataField="prac_str" HeaderText="[%Středisko%]" />
                                <asp:BoundField DataField="dny" HeaderText="[%Dny%]" />
                                <asp:BoundField DataField="hodiny" HeaderText="[%Hodiny%]" />
                                <asp:BoundField DataField="sazba" HeaderText="[%Sazba%]" />
                                <asp:BoundField DataField="castka" HeaderText="[%Částka%]" />
                            </Columns>
                        </wc:TGridView>--%>
                        <kspwc:TRadGrid ID="TRG_porizovak_rekapitulace" runat="server" DataSourceID="ds_porizovak_rekapitulace" AutoGenerateColumns="false" CaptionVisible="false" AutoMasterGridWidth="true">
                            <MasterTableView>
                                <Columns>
                                    <telerik:GridBoundColumn DataField="os_cislo" HeaderText="[%Os. číslo%]" />
                                    <telerik:GridBoundColumn DataField="cislo_pom" HeaderText="[%Č.P.%]" />
                                    <telerik:GridBoundColumn DataField="jmeno" HeaderText="[%Jméno%]" />
                                    <telerik:GridBoundColumn DataField="kod_cely" HeaderText="[%Kód%]" />
                                    
                                    <telerik:GridBoundColumn DataField="dny" HeaderText="[%Dny%]" />
                                    <telerik:GridBoundColumn DataField="hodiny" HeaderText="[%Hodiny%]" />
                                    <telerik:GridBoundColumn DataField="sazba" HeaderText="[%Sazba%]" />
                                    <telerik:GridBoundColumn DataField="castka" HeaderText="[%Částka%]" />
                                    <telerik:GridBoundColumn DataField="prac_str" HeaderText="[%Středisko%]" />
                                     <telerik:GridTemplateColumn HeaderText="[%Projekt%]"  UniqueName="id_projekt">
                                        <itemtemplate>
                                            <asp:Label runat="server" id="lab_projekt" Text='<%# _projekt_cely_nazev(DataBinder.Eval(Container.DataItem,"id_vazby")) %>' ></asp:Label>
                                        </itemtemplate>
                                    </telerik:GridTemplateColumn>
                                     <telerik:GridBoundColumn DataField="c_pole1" HeaderText="[%Projekt%]" UniqueName="c_pole1" />
                                    <telerik:GridBoundColumn DataField="c_pole2" HeaderText="[%Úloha%]" UniqueName="c_pole2" />

                                     <telerik:GridTemplateColumn UniqueName="poznamka" >
                                        <ItemTemplate>
                                           </tr>
                                            <tr>
                                                <td></td>
                                <td colspan="8"><asp:Label runat="server" ID="txt_poznamka" Width="100%" Height="35" MaxLength="300" TextMode="MultiLine" CssClass="pozn"
                                    Visible='<%# (PoznamkaVisible) %>' Text='<%# Eval("poznamka") %>'></asp:Label></td>
                                                </tr>
                                        </ItemTemplate>
                                    </telerik:GridTemplateColumn>
                                </Columns>
                            </MasterTableView>
                        </kspwc:TRadGrid>
                        <asp:ObjectDataSource runat="server" ID="ds_porizovak_rekapitulace" OnDataBinding="ds_porizovak_rekapitulace_DataBinding"
                            OldValuesParameterFormatString="original_{0}" SelectMethod="GetPorizZam"
                            TypeName="KSProgram.Pozadavky.Pozadavekodmeny"></asp:ObjectDataSource>
                    </asp:Panel>

                </asp:TableCell>
            </asp:TableRow>


            <asp:TableRow runat="server" ID="TableRowInsert4">
                <asp:TableCell runat="server" ID="TCInsert7" HorizontalAlign="right" SkinID="DataFieldHeaderStyle">
                    <asp:Label ID="Label3" runat="server" Text="[%Poznámka%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell runat="server" ID="TCInsert8" ColumnSpan="3" SkinID="DataFieldStyle" Style="padding-right: 10px;">
                   <%-- <asp:TextBox ID="LabelDuvod" runat="server" Text='<%# Bind("duvod") %>' MaxLength="999" TextMode="MultiLine" Width="100%" Height="200"></asp:TextBox>--%>
                     <telerik:RadTextBox ID="rdb_lDuvod" runat="server" Text='<%# Bind("duvod") %>' MaxLength="990" TextMode="MultiLine" Width="100%" Height="200"></telerik:RadTextBox>
                    <br />
                    <kspwc:TextValidator runat="server" ID="val1" ControlToValidate="rdb_lDuvod"></kspwc:TextValidator>
                </asp:TableCell>
            </asp:TableRow>
            <asp:TableRow runat="server" ID="TableRowInsert5">
                <asp:TableCell runat="server" ID="TCInsert9" HorizontalAlign="right" SkinID="DataFieldHeaderStyle">
                    <asp:Label ID="Label4" runat="server" Text="[%Požadované datum vyřízení%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell runat="server" ID="TCInsert10" ColumnSpan="3" SkinID="DataFieldStyle">
                    <kspwc:TRadDatePicker runat="server" ID="TextBoxDatVyrizeniInsert" DbSelectedDate='<%# Bind("vyridit_do") %>'></kspwc:TRadDatePicker>
                </asp:TableCell>
            </asp:TableRow>
            <asp:TableRow runat="server" ID="TableRowInsert6">
                <asp:TableCell runat="server" ID="TCInsert11" ColumnSpan="4">
                    <asp:CustomValidator ID="cv_nevyplněno" runat="server" ErrorMessage="Žádná položka není vyplněna" ValidationGroup="kontrola_ulozeni" OnServerValidate="cv_nevyplneno_servervalidate"></asp:CustomValidator>
                </asp:TableCell>
            </asp:TableRow>

        </asp:Table>
    </InsertItemTemplate>

    <EditItemTemplate>
        <asp:Table runat="server" ID="TableInsert" SkinID="RamAPozadi">
            <asp:TableHeaderRow runat="server" ID="TableHeaderRowInsert">
                <asp:TableCell runat="server" ColumnSpan="4" ID="TableCellItem14" SkinID="TitleRowStyle">
                    <asp:Label ID="Label7" runat="server" Text="[%Úprava požadavku na odměny%]"></asp:Label>
                </asp:TableCell>
            </asp:TableHeaderRow>

            <asp:TableRow runat="server" ID="TableRow_obdobi">
                <asp:TableCell runat="server" ID="TableCell7" HorizontalAlign="right" SkinID="DataFieldHeaderStyle">
                    <asp:Label ID="Label1" runat="server" Text="[%Období%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell runat="server" ID="TableCell8" ColumnSpan="3" SkinID="DataFieldStyle">
                    <wc:DDLObdobi runat="server" ID="ddlb_obdobi_edit" JenAktualniMzdove="true"></wc:DDLObdobi>
                </asp:TableCell>
            </asp:TableRow>

            <asp:TableRow runat="server" ID="row_porizovak">
                <asp:TableCell runat="server" ID="cell_porizovak" ColumnSpan="4" VerticalAlign="Top">
                    <table style="border-collapse: collapse;">
                        <tr>
                            <td style="padding: 5,0,10,0">
                                <wc:TLinkButton runat="server" ID="lb_prehled" Text="Rekapitulace" SkinID="button" OnCommand="lb_prehled_oncommand"></wc:TLinkButton>
                                <wc:TLinkButton runat="server" ID="lb_editace" Text="Editace" SkinID="button" OnCommand="lb_editace_oncommand" Visible="false"></wc:TLinkButton>
                            </td>
                        </tr>
                    </table>
                    <asp:Panel runat="server" ID="pan_poriz">
                        <table style="border-collapse: collapse;">
                            <tr>
                                <td style="vertical-align: top">

                                   <%-- <asp:ObjectDataSource ID="ds_Seznam" runat="server" OldValuesParameterFormatString="original_{0}"
                                        SelectMethod="GetPomery" TypeName="KSProgram.Pozadavky.Pozadavekodmeny">
                                        <SelectParameters>
                                            <asp:Parameter Name="os_cislo_nadriz" Type="Decimal" />
                                            <asp:Parameter DefaultValue="all" Name="co" Type="String" />
                                            <asp:Parameter DefaultValue="" Name="datum" Type="DateTime" />
                                        </SelectParameters>
                                    </asp:ObjectDataSource>--%>
                                  
                                    <kspwc:TRadGrid ID="TRG_Seznam" runat="server"  AutoGenerateColumns="false" AllowPaging="True" AllowSorting="true" AutoMasterGridWidth="true" UseSaveSetting="true" 
                                        OnDataBound="TRG_Seznam_DataBound" OnItemDataBound="TRG_Seznam_ItemDataBound" OnSelectedIndexChanged="TRG_Seznam_SelectedIndexChanged"  OnNeedDataSource="TRG_Seznam_NeedDataSource">
                                        <MasterTableView CommandItemDisplay="Top"  PageSize="5" DataKeyNames="os_cislo,cislo_pom" Caption="[%Seznam zaměstnanců%]">
                                            <PagerStyle PageButtonCount="3" PageSizes="5,10,20,30,50,100,200,500"/>
                                            <Columns>
                                                <telerik:GridButtonColumn Text="Select" UniqueName="select_col" CommandName="Select" ButtonType="ImageButton" ImageUrl="~/Images/Select_tel.png" />
                                                <telerik:GridBoundColumn DataField="os_cislo" HeaderText="[%Os. číslo%]" SortExpression="os_cislo" />
                                                <telerik:GridBoundColumn DataField="cislo_pom" HeaderText="[%Č.P.%]" SortExpression="cislo_pom" />
                                                <%--<telerik:GridBoundColumn DataField="cele_jmeno" HeaderText="[%Jméno%]" SortExpression="cele_jmeno" />--%>
                                               <telerik:GridTemplateColumn HeaderText="[%Jméno%]" SortExpression="cele_jmeno" DataField="cele_jmeno">
                                                    <ItemTemplate>
                                                      <telerik:RadToolTip  ID="RadToolTip1" runat="server" TargetControlID="pocty_pozadavku"
                                                                    IsClientID="false" RelativeTo="Element" ShowEvent="OnMouseOver" HideEvent="LeaveTargetAndToolTip"
                                                                    Animation="Fade" ShowDelay="10" Width="200" Height="50" Position="TopRight"
                                                                    Text="[%Počet schválených / počet běžících požadavků ve stejném období%].">
                                                        </telerik:RadToolTip>
                                                      

                                                        <div class="left" >
                                                            <asp:Label runat="server" ID="lab_jmeno"  Text='<%# DataBinder.Eval(Container.DataItem,"cele_jmeno") %>'></asp:Label>
                                                        </div>                                                   
                                                         <asp:Panel runat="server" ID="pocty_pozadavku" CssClass="right">
                                                             <asp:Label runat="server" ID="Label6"  Text='<%# DataBinder.Eval(Container.DataItem,"poz_schvalenych")+"/ "+ DataBinder.Eval(Container.DataItem,"poz_v_procesu") %>'></asp:Label>
                                                        </asp:Panel>        
                                                    </ItemTemplate>
                                                </telerik:GridTemplateColumn>
                                                <telerik:GridBoundColumn DataField="prac_str" HeaderText="[%Prac. stř.%]" SortExpression="prac_str" />
                                                <telerik:GridBoundColumn DataField="druh_pomeru" HeaderText="[%Druh p.p.%]" SortExpression="druh_pomeru" />
                                                <telerik:GridBoundColumn DataField="stav" HeaderText="[%Stav%]" SortExpression="stav" />
                                                <%--<telerik:GridBoundColumn DataField="pocty" HeaderText="" SortExpression="pocty" >
                                                    <ItemStyle Wrap="false" />
                                                </telerik:GridBoundColumn>--%>
                                                <telerik:GridRowIndicatorColumn></telerik:GridRowIndicatorColumn>
                                            </Columns>
                                            <CommandItemTemplate>
                                               <%-- <kspwc:GridCommandItemControl ID="gcic" runat="server" RebindButton-Visible="false" ExportButton-Visible="false" ></kspwc:GridCommandItemControl>--%>
                                                <kspwc:GridCommandItemControl ID="GridCommandItemControl1" runat="server" PracPomeryComboBox-Visible="true">
                                                <ExportButton ID="ExportButton1" runat="server" ShowExportToExcelBIFFItem="true" ShowExportToExcelHtmlItem="false"/>
                                                <PrimiPodrizeniButton ID="PrimiPodrizeniButton1" runat="server" Visible="true" Value="aktivni"></PrimiPodrizeniButton>
                                                <PracPomeryComboBox runat="server" AutoPostBack="true"  OnDataBound="combo_pomer_DataBound"></PracPomeryComboBox>
                                            </kspwc:GridCommandItemControl>
                                            </CommandItemTemplate>
                                        </MasterTableView>
                                    </kspwc:TRadGrid>
                                    <%----%>
                                </td>

                                <td style="vertical-align: top">
                                    <asp:ObjectDataSource runat="server" ID="ds_porizovak_oprava" OnDataBinding="ds_porizovak_oprava_DataBinding"
                                        OldValuesParameterFormatString="original_{0}" SelectMethod="GetPorizZamOprava"
                                        TypeName="KSProgram.Pozadavky.Pozadavekodmeny">
                                        <SelectParameters>
                                            <asp:Parameter DefaultValue="0" Name="id_poz" Type="Int32" />
                                            <asp:ControlParameter ControlID="TRG_Seznam" DefaultValue="" Name="os_cislo"
                                                PropertyName="SelectedValues[&quot;os_cislo&quot;]" Type="Decimal" />
                                            <asp:ControlParameter ControlID="TRG_Seznam" DefaultValue="" Name="cislo_pom"
                                                PropertyName="SelectedValues[&quot;cislo_pom&quot;]" Type="Int16" />
                                        </SelectParameters>
                                    </asp:ObjectDataSource>


                                    <wc:TGridView ID="gv_porizovak" runat="server" DataSourceID="ds_porizovak_oprava"
                                        ShowFooter="True" ShowFooterWhenEmpty="True"
                                        OnRowDataBound="gv_porizovak_RowDataBound"
                                        OnRowCreated="gv_porizovak_RowCreated"
                                        OnRowCommand="gv_porizovak_RowCommand"
                                        OnDataBinding="gv_porizovak_oprava_dataBinding">
                                        <Columns>
                                            <asp:TemplateField HeaderText="[%Kód%]">
                                                <ItemTemplate>
                                                     <%-- <asp:Label ID="Lab_polozka" runat="server" Text='<%# _nazevKodu(DataBinder.Eval(Container.DataItem,"kod")) %>'></asp:Label>--%>
                                                   
                                                    <asp:Label ID="Lab_polozka" runat="server" Text='<%# Bind("kod_cely") %>'
                                                         Visible='<%# _visibleKod(DataBinder.Eval(Container.DataItem, "kod_cely").ToString()) %>'></asp:Label>
                                                    <asp:Panel runat="server" ID="pan_dd_kod"  Visible='<%# (!_visibleKod(DataBinder.Eval(Container.DataItem, "kod_cely").ToString())) %>'>
                                                    <kspwc:TRadComboBox ID="ddl_kod" runat="server" DropDownAutoWidth="Enabled" OnSelectedIndexChanged="ddl_kod_SelectedIndexChanged"                                                       
                                                        EnableLoadOnDemand="True" EnableVirtualScrolling="true" AutoPostBack="true" SelectedValue='<%# Bind("kod") %>'
                                                        Height="250px" 
                                                        ShowMoreResultsBox="True" Width="200px"  EnableAutomaticLoadOnDemand="true">
                                                        <WebServiceSettings Method="GetPorizovakKody"  Path="~/PrivateWebServices/AutoCompleteService.asmx" />
                                                    </kspwc:TRadComboBox>       
                                                        </asp:Panel>     
                  
                                                </ItemTemplate>
                                                <FooterTemplate>
                                                </FooterTemplate>
                                            </asp:TemplateField>
                                            
                                      
                                           

                                            <asp:TemplateField HeaderText="[%Dny%]">
                                                <ItemTemplate>                                                   
                                                    <telerik:RadNumericTextBox ID="NumTextBox_dny" runat="server" DbValue='<%# Bind("dny") %>' OnTextChanged="TextBoxOnChanged"
                                                        Enabled='<%# Bind("dny_p") %>' Width="75" BackColor="LightBlue" DataType="System.Decimal" MaxValue="99" NumberFormat-DecimalDigits="1">
                                                    </telerik:RadNumericTextBox>
                                                </ItemTemplate>
                                            </asp:TemplateField>
                                            <asp:TemplateField HeaderText="[%Hodiny%]">
                                                <ItemTemplate>                                                   
                                                    <telerik:RadNumericTextBox ID="NumTextBox_hodiny" runat="server" DbValue='<%# Bind("hodiny") %>' OnTextChanged="TextBoxOnChanged"
                                                        Enabled='<%# Bind("hodiny_p") %>' Width="75" BackColor="LightBlue" DataType="System.Decimal" MaxValue="999" NumberFormat-DecimalDigits="2">
                                                    </telerik:RadNumericTextBox>
                                                </ItemTemplate>

                                            </asp:TemplateField>
                                            <asp:TemplateField HeaderText="[%Sazba%]">
                                                <ItemTemplate>                                                   
                                                    <telerik:RadNumericTextBox ID="NumTextBox_sazba" runat="server" DbValue='<%# Bind("Sazba") %>' OnTextChanged="TextBoxOnChanged"
                                                        Enabled='<%# Bind("sazba_p") %>' Width="75" BackColor="LightBlue" DataType="System.Decimal" NumberFormat-DecimalDigits="4">
                                                    </telerik:RadNumericTextBox>
                                                </ItemTemplate>

                                            </asp:TemplateField>
                                            <asp:TemplateField HeaderText="[%Částka%]">
                                                <ItemTemplate>                                                   
                                                    <telerik:RadNumericTextBox ID="NumTextBox_castka" runat="server" DbValue='<%# Bind("castka") %>' OnTextChanged="TextBoxOnChanged"
                                                        Enabled='<%# Bind("castka_p") %>' Width="75" BackColor="LightBlue" DataType="System.Decimal" NumberFormat-DecimalDigits="2">
                                                    </telerik:RadNumericTextBox>
                                                </ItemTemplate>

                                            </asp:TemplateField>

                                             <asp:TemplateField HeaderText="[%Středisko%]">
                                                <ItemTemplate>                
                                                    <kspwc:TRadComboBox ID="ddl_prac_str" runat="server" DropDownAutoWidth="Enabled" OnSelectedIndexChanged="ddl_prac_str_SelectedIndexChanged"
                                                        EnableLoadOnDemand="True" EnableVirtualScrolling="true" AutoPostBack="true" SelectedValue='<%# Bind("prac_str") %>'
                                                        Height="250px" OnClientItemsRequesting="ddl_prac_str_OnClientItemsRequesting"
                                                        ShowMoreResultsBox="True" Width="200px"  EnableAutomaticLoadOnDemand="true">
                                                        <WebServiceSettings Method="GetStred" Path="~/PrivateWebServices/AutoCompleteService.asmx" />
                                                    </kspwc:TRadComboBox>                           



                                                </ItemTemplate>
                                            </asp:TemplateField>

                                            <asp:TemplateField HeaderText="[%Projekt%]"  >
                                                <ItemTemplate>                                                
                                                    <kspwc:TRadComboBox ID="combo_projekt" runat="server" DropDownAutoWidth="Enabled" OnSelectedIndexChanged="combo_projekt_SelectedIndexChanged"
                                                        EnableLoadOnDemand="True" EnableVirtualScrolling="true" AutoPostBack="true" SelectedValue='<%# Bind("id_vazby") %>'
                                                        Height="250px"
                                                        ShowMoreResultsBox="True" Width="200px"  EnableAutomaticLoadOnDemand="true">
                                                        <WebServiceSettings Method="GetCisProjekty" Path="~/PrivateWebServices/AutoCompleteService.asmx" />
                                                    </kspwc:TRadComboBox>
                                                </ItemTemplate>
                                            </asp:TemplateField>
                                            <asp:TemplateField HeaderText="[%Projekt%]">
                                                <ItemTemplate>
                                                    <kspwc:TRadComboBox ID="dd_dim1" runat="server" DropDownAutoWidth="Enabled" OnSelectedIndexChanged="dd_dim1_SelectedIndexChanged"
                                                        EnableLoadOnDemand="True" EnableVirtualScrolling="true" AutoPostBack="true" SelectedValue='<%# Bind("c_pole1") %>'
                                                        Height="250px" OnClientItemsRequesting="dd_dim1_OnClientItemsRequesting" 
                                                        ShowMoreResultsBox="True" Width="200px"  EnableAutomaticLoadOnDemand="true">                                                        
                                                        
                                                       <WebServiceSettings Method="GetDim1"  Path="~/PrivateWebServices/AutoCompleteService.asmx" />
                                                    </kspwc:TRadComboBox>                                                    
                                                                 
                                                   
                                                    <asp:CustomValidator ID="sv_dim1" Display="Dynamic" runat="server" Text="[%Neplatná hodnota%]" ErrorMessage="[%Neplatná hodnota%]" ControlToValidate="dd_dim1"
                                                        ValidationGroup="edit" OnServerValidate="dim1_validate"></asp:CustomValidator>
                                                </ItemTemplate>
                                            </asp:TemplateField>

                                            <asp:TemplateField HeaderText="[%Úloha%]" >
                                                <ItemTemplate>
                                                     <kspwc:TRadComboBox AutoPostBack="true" ID="dd_dim2"  runat="server" DropDownAutoWidth="Enabled"  DataValueField="uloha" DataTextField="cely_nazev" OnDataBinding="dd_dim2_DataBinding"
                                          OnSelectedIndexChanged="dd_dim2_SelectedIndexChanged" Height="150px" DataSourceID="ds_uloha" Width="200px"  >
                                      
                                     </kspwc:TRadComboBox>
                                      <asp:ObjectDataSource runat="server" ID="ds_uloha"
                                                        OldValuesParameterFormatString="original_{0}" SelectMethod="Ulohy_pro_projekt"
                                                        TypeName="KSProgram.Dochazka.dch_poriz_ukolu">
                                          <SelectParameters>
                                              <asp:Parameter Name="projekt" DbType="String" />
                                              <asp:Parameter Name="obdobi" DbType="DateTime" />
                                              <asp:Parameter Name="emptyRow" DbType="Boolean" DefaultValue="true" />
                                          </SelectParameters>
                                      </asp:ObjectDataSource>
                                      <asp:CustomValidator ID="sv_dim2" runat="server" Display="Dynamic" Text="[%Neplatná hodnota%]" ErrorMessage="[%Neplatná hodnota%]" ControlToValidate="dd_dim2"
                                            ValidationGroup="edit" OnServerValidate="dim2_validate"></asp:CustomValidator>
                                                </ItemTemplate>
                                            </asp:TemplateField>
                                            <asp:TemplateField  >
                                                <ItemTemplate>
                                                    </tr>
                                                    <tr>
                                                        <td></td>
                                        <td colspan="5"><telerik:RadTextBox runat="server" ID="txt_poznamka" Width="100%" Height="35" MaxLength="300" TextMode="MultiLine" CssClass="pozn" Text='<%# Bind("poznamka") %>' AutoPostBack="false" OnTextChanged="txt_poznamka_TextChanged"></telerik:RadTextBox></td>
                                                        </tr>
                                                </ItemTemplate>
                                            </asp:TemplateField>
                                        </Columns>
                                    </wc:TGridView>
                                </td>
                            </tr>
                        </table>
                    </asp:Panel>
                    <asp:Panel runat="server" ID="pan_prohl" Visible="false">
                        <%--<wc:TGridView ID="gv_porizovak_rekapitulace" runat="server" DataSourceID="ds_porizovak_rekapitulace_oprava">
                            <Columns>
                                <asp:BoundField DataField="os_cislo" HeaderText="[%Os. číslo%]" />
                                <asp:BoundField DataField="cislo_pom" HeaderText="[%Č.P.%]" />
                                <asp:BoundField DataField="jmeno" HeaderText="[%Jméno%]" />
                                <asp:BoundField DataField="kod_cely" HeaderText="[%Kód%]" />
                                <asp:BoundField DataField="prac_str" HeaderText="[%Středisko%]" />
                                <asp:BoundField DataField="dny" HeaderText="[%Dny%]" />
                                <asp:BoundField DataField="hodiny" HeaderText="[%Hodiny%]" />
                                <asp:BoundField DataField="sazba" HeaderText="[%Sazba%]" />
                                <asp:BoundField DataField="castka" HeaderText="[%Částka%]" />
                            </Columns>
                        </wc:TGridView>--%>
                        <kspwc:TRadGrid ID="TRG_porizovak_rekapitulace" runat="server" DataSourceID="ds_porizovak_rekapitulace_oprava" AutoGenerateColumns="false" CaptionVisible="false" AutoMasterGridWidth="true">
                            <MasterTableView>
                                <Columns>
                                    <telerik:GridBoundColumn DataField="os_cislo" HeaderText="[%Os. číslo%]" />
                                    <telerik:GridBoundColumn DataField="cislo_pom" HeaderText="[%Č.P.%]" />
                                    <telerik:GridBoundColumn DataField="jmeno" HeaderText="[%Jméno%]" />
                                    <telerik:GridBoundColumn DataField="kod_cely" HeaderText="[%Kód%]" />                                    
                                    <telerik:GridBoundColumn DataField="dny" HeaderText="[%Dny%]" />
                                    <telerik:GridBoundColumn DataField="hodiny" HeaderText="[%Hodiny%]" />
                                    <telerik:GridBoundColumn DataField="sazba" HeaderText="[%Sazba%]" />
                                    <telerik:GridBoundColumn DataField="castka" HeaderText="[%Částka%]" />
                                    <telerik:GridBoundColumn DataField="prac_str" HeaderText="[%Středisko%]" />
                                     <telerik:GridTemplateColumn HeaderText="[%Projekt%]"  UniqueName="id_projekt" >
                                        <itemtemplate>
                                            <asp:Label runat="server" id="lab_projekt" Text='<%# _projekt_cely_nazev(DataBinder.Eval(Container.DataItem,"id_vazby")) %>' ></asp:Label>
                                        </itemtemplate>
                                    </telerik:GridTemplateColumn>
                                    <telerik:GridBoundColumn DataField="c_pole1" HeaderText="[%Projekt%]" UniqueName="c_pole1" />
                                    <telerik:GridBoundColumn DataField="c_pole2" HeaderText="[%Úloha%]" UniqueName="c_pole2" />
                                </Columns>
                            </MasterTableView>
                        </kspwc:TRadGrid>
                        <asp:ObjectDataSource runat="server" ID="ds_porizovak_rekapitulace_oprava" OnDataBinding="ds_porizovak_rekapitulace_oprava_DataBinding"
                            OldValuesParameterFormatString="original_{0}" SelectMethod="GetPorizZamOprava"
                            TypeName="KSProgram.Pozadavky.Pozadavekodmeny">
                            <SelectParameters>
                                <asp:Parameter DefaultValue="0" Name="id_poz" Type="Int32" />
                            </SelectParameters>
                        </asp:ObjectDataSource>
                    </asp:Panel>
                </asp:TableCell>
            </asp:TableRow>
            <asp:TableRow runat="server" ID="TableRowInsert4">
                <asp:TableCell runat="server" ID="TCInsert7" HorizontalAlign="right" SkinID="DataFieldHeaderStyle">
                    <asp:Label ID="Label3" runat="server" Text="[%Poznámka%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell runat="server" ID="TCInsert8" ColumnSpan="3" SkinID="DataFieldStyle" Style="padding-right:10px">
                    <%--<asp:TextBox ID="tx_duvod_edit" runat="server" Text='<%# Bind("duvod") %>' MaxLength="999" TextMode="MultiLine" Width="100%" Height="200"></asp:TextBox>--%>
                    <telerik:RadTextBox ID="tx_duvod_edit" runat="server" Text='<%# Bind("duvod") %>' MaxLength="990" TextMode="MultiLine" Width="100%" Height="200"></telerik:RadTextBox>
                    <br />
    <kspwc:TextValidator runat="server" ID="val2" ControlToValidate="tx_duvod_edit"></kspwc:TextValidator>
                </asp:TableCell>
            </asp:TableRow>
            <asp:TableRow runat="server" ID="TableRowInsert5">
                <asp:TableCell runat="server" ID="TCInsert9" HorizontalAlign="right" SkinID="DataFieldHeaderStyle">
                    <asp:Label ID="Label4" runat="server" Text="[%Požadované datum vyřízení%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell runat="server" ID="TCInsert10" ColumnSpan="3" SkinID="DataFieldStyle">
                    <kspwc:TRadDatePicker runat="server" ID="TextBoxDatVyrizeniEdit" DbSelectedDate='<%# Bind("vyridit_do") %>'></kspwc:TRadDatePicker>
                </asp:TableCell>
            </asp:TableRow>
            <asp:TableRow runat="server" ID="TableRowInsert6">
                <asp:TableCell runat="server" ID="TCInsert11" ColumnSpan="4">
                    <asp:CustomValidator ID="cv_nevyplněno" runat="server" ErrorMessage="Žádná položka není vyplněna" ValidationGroup="kontrola_ulozeni" OnServerValidate="cv_nevyplneno_servervalidate"></asp:CustomValidator>
                </asp:TableCell>
            </asp:TableRow>
        </asp:Table>
    </EditItemTemplate>
</asp:FormView>
<asp:CustomValidator ID="cv_zamek" runat="server" ErrorMessage="[%Agenda je zamčena, nelze pokračovat%]" OnServerValidate="cv_zamek_validate"></asp:CustomValidator>
<telerik:RadWindowManager  Behaviors="Close" ID="RadWindowManager" DestroyOnClose="false" runat="server">
    <Windows>               
        <telerik:RadWindow   ID="rw_sestava_odmeny" Title="[%Požadavky na odměny%]"  runat="server">
        </telerik:RadWindow>
    </Windows>
</telerik:RadWindowManager>



