﻿<%@ Control Language="C#" AutoEventWireup="true" CodeBehind="DashBoardPanel_Jubilea.ascx.cs" Inherits="KSPortal.DashBoard.DashBoardPanel_Jubilea" %>

<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>

<style type="text/css">
    .ksShedulerDashJub .k-scheduler-timecolumn {
        display: none;
    }
</style>

<div id="scheduler" class="ksShedulerDashJub"></div>
<script src='<%= ResolveUrl("~/kendo/js/kendo.timezones.min.js") %>' type="text/javascript" defer></script>
<telerik:RadScriptBlock ID="RSB_warns" runat="server">
    <script type="text/javascript">
        function initSchedulerWhenReady() {
            if (window.kendo && window.kendo.ui && kendo.ui.Scheduler && kendo.timezone && kendo.timezone.zones["Europe/Prague"]) {
                $("#scheduler").kendoScheduler({
                    date: new Date(),
                    height: 300,
                    timezone: "Europe/Prague",
                    editable: false,
                    views: [
                        {
                            type: "agenda",
                        },
                    ],
                    navigate: function (e) {
                        if (e.view === 'agenda')
                            if (e.action === 'previous') {
                                var newDate = kendo.date.addDays(e.date, -6);
                                e.sender.date(newDate);
                                e.preventDefault();
                            }
                            else if (e.action === 'next') {
                                var newDate = kendo.date.addDays(e.date, 6);
                                e.sender.date(newDate);
                                e.preventDefault();
                            }
                    },
                    dataSource: {
                        serverFiltering: true,
                        transport: {
                            read: {
                                url: KSMaster.baseUrl + "/api/Sheduler/GetJubilea",
                                dataType: "json",
                                contentType: "application/json; charset=utf-8",
                                type: "POST",
                                async: true,
                            },
                            parameterMap: function (options, operation) {
                                if (operation === "read") {
                                    var scheduler = $("#scheduler").data("kendoScheduler");

                                    var result = {
                                        start: formatWithOffset(scheduler.view().startDate()),
                                        end: formatWithOffset(scheduler.view().endDate())
                                    }
                                    return JSON.stringify(result);
                                }
                                return JSON.stringify(options);
                            }
                        },
                        schema: {
                            model: {
                                id: "taskID",
                                fields: {
                                    taskID: { from: "TaskID", type: "string" },
                                    title: { from: "Title", defaultValue: "No title", validation: { required: true } },
                                    start: { type: "date", from: "Start" },
                                    end: { type: "date", from: "End" },
                                    startTimezone: { from: "StartTimezone" },
                                    endTimezone: { from: "EndTimezone" },
                                    description: { from: "Description" },
                                    recurrenceId: { from: "RecurrenceID" },
                                    recurrenceRule: { from: "RecurrenceRule" },
                                    recurrenceException: { from: "RecurrenceException" },
                                    //ownerId: { from: "OwnerID", defaultValue: 1 },
                                    isAllDay: { type: "boolean", from: "IsAllDay" }
                                }
                            }
                        },
                    },
                });
            } else {
                setTimeout(initSchedulerWhenReady, 500); // retry
            }
        }

        $(document).ready(function () {
            initSchedulerWhenReady();
        });

        function formatWithOffset(date) {
            const pad = (n) => n.toString().padStart(2, '0');

            const year = date.getFullYear();
            const month = pad(date.getMonth() + 1);
            const day = pad(date.getDate());
            const hour = pad(date.getHours());
            const minute = pad(date.getMinutes());
            const second = pad(date.getSeconds());

            const offset = -date.getTimezoneOffset(); // v minutách
            const sign = offset >= 0 ? '+' : '-';
            const offsetHours = pad(Math.floor(Math.abs(offset) / 60));
            const offsetMinutes = pad(Math.abs(offset) % 60);

            return `${year}-${month}-${day}T${hour}:${minute}:${second}${sign}${offsetHours}:${offsetMinutes}`;
        }

    </script>
</telerik:RadScriptBlock>