﻿<%@ Control Language="C#" AutoEventWireup="true" CodeBehind="DashBoardPanel_VolnePozice.ascx.cs" Inherits="KSPortal.DashBoard.DashBoardPanel_VolnePozice" %>
<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>

<style type="text/css">
    .ksPozice {
        border: solid 2px lightgrey;
        border-radius: 10px;
        padding: 4px 4px 4px 8px;
        margin: 15px;
        transition: 0.4s;
        color: var(--kscolor2text);
    }

        .ksPozice:hover {
            box-shadow: rgba(0, 0, 0, 0.15) 0px 15px 15px !important;
            border-color: var(--kscolor1) !important;
        }

        .ksPozice p {
            font-size: 20px !important;
            font-weight: bold !important;
            text-decoration: none !important;
        }

        .ksDbLiFs a {
            text-decoration: none !important;
        }
</style>

<telerik:RadScriptBlock ID="RSB_pozice" runat="server">
    <script type="text/javascript">
        //<![CDATA[

        function RD_VolnePozice_ClientDockPositionChanged(sender, args) {

        }
        function ParseVP(sender, args) {
            var response = args.get_response().d;
            if (response) {
                args.set_parsedData(response.Data);
            }
        }

        function _emptyPozice() {
            return '<%=KSProgram.Obecne.ReadGlobalResource.ZmenaTextu("[%Žádné volné pozice%]")%>';
        }

    </script>
</telerik:RadScriptBlock>

<telerik:RadListView runat="server" ID="RLV_pozice" AllowPaging="false" ItemPlaceholderID="ItemsPlaceHolder" ClientDataSourceID="RCDS_pozice">
    <LayoutTemplate>
        <div id="ItemsPlaceHolder" runat="server">
        </div>
    </LayoutTemplate>
    <ClientSettings>
        <DataBinding>
            <ItemTemplate>
                <fieldset class="ksDbLiFs">
                    <div>
                        <a href="#= url #">
                            <div class="ksPozice"">
                              <p>#= nazev #</p>
                            </div>
                        </a>
                    </div>
                </fieldset>
            </ItemTemplate>
            <EmptyDataTemplate>
               <fieldset class="ksDbLiFs" style="border:none;">
                                <div>
                                    <p class="zadneBull">
                                        <i class="fi fi-briefcase"></i>
                                        <label>#=_emptyPozice()#</label>
                                    </p>
                                </div>
                            </fieldset>
            </EmptyDataTemplate>
        </DataBinding>
    </ClientSettings>
</telerik:RadListView>


<telerik:RadClientDataSource ID="RCDS_pozice" runat="server" AllowBatchOperations="false">
    <ClientEvents OnDataParse="ParseVP" />
    <DataSource>
        <WebServiceDataSourceSettings>
            <Select Url="DashBoard/WebMethods.aspx/GetVolnePozice" DataType="JSON" RequestType="Post" ContentType="application/json; charset=utf-8" />
        </WebServiceDataSourceSettings>
    </DataSource>
    <Schema>
        <Model>
            <telerik:ClientDataSourceModelField FieldName="nazev" DataType="String" Editable="False" />
            <telerik:ClientDataSourceModelField FieldName="url" DataType="String" Editable="False" />
        </Model>
    </Schema>
</telerik:RadClientDataSource>
