﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Main.Master" AutoEventWireup="true" CodeBehind="ClientSignTest.aspx.cs" Inherits="KSPortal.Dokumenty.ClientSignTest" %>
<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>

<asp:Content ID="Content1" ContentPlaceHolderID="HeadContent" runat="server">
    <style type="text/css">
        .ksOdstavec {
             text-align: justify;
             text-align-last: left;
        }
    </style>
</asp:Content>

<asp:Content ID="Content2" ContentPlaceHolderID="HlavniOblast" runat="server">
    <telerik:RadAjaxManagerProxy runat="server" ID="RAMP_signtest">
        <AjaxSettings>
            <telerik:AjaxSetting AjaxControlID="RB_nahled">
                <UpdatedControls></UpdatedControls>
            </telerik:AjaxSetting>
            <telerik:AjaxSetting AjaxControlID="TRB_send">
                <UpdatedControls></UpdatedControls>
            </telerik:AjaxSetting>
            <telerik:AjaxSetting AjaxControlID="TRB_install">
                <UpdatedControls></UpdatedControls>
            </telerik:AjaxSetting>
        </AjaxSettings>
    </telerik:RadAjaxManagerProxy>
    <telerik:RadScriptBlock runat="server" ID="RSB_fix">
        <script type="text/javascript">
            const signApi = new KSClientSign();

            var oldPageLoad1 = !oldPageLoad1 ? KSMaster.onPageLoad : oldPageLoad1;
            KSMaster.onPageLoad = async function () {
                oldPageLoad1.apply();
                const apiOk = await signApi.testApi();
                if (apiOk) {
                    const certificates = await signApi.getCertificates(); // Zajistěte, že getCertificates vrací Promise

                    // Najdeme RadComboBox
                    const rcbCertificates = $find("<%= RCB_certificates.ClientID %>");
                    if (!rcbCertificates) {
                        console.error("RadComboBox nebyl nalezen.");
                        return;
                    }

                    // Začneme sledovat změny
                    rcbCertificates.trackChanges();

                    // Vyčistíme existující položky
                    rcbCertificates.get_items().clear();

                    // Přidáme certifikáty do RadComboBox pomocí smyčky for
                    for (let i = 0; i < certificates.length; i++) {
                        const cert = certificates[i];
                        const comboItem = new Telerik.Web.UI.RadComboBoxItem();
                        comboItem.set_text(cert.name); // Zobrazovaný text
                        comboItem.set_value(cert.thumbprint); // Hodnota
                        rcbCertificates.get_items().add(comboItem);
                    }

                    // Nastavíme výchozí vybranou položku (volitelně)
                    if (certificates.length > 0) {
                        rcbCertificates.get_items().getItem(0).select();
                    }

                    // Potvrdíme změny
                    rcbCertificates.commitChanges();
                }
            };
            KSMaster.onPageLoad.prototype = oldPageLoad1.prototype;

            var tsUrl = "<%= KSProgram.Parametry.ParametrCti("CasoveRazitkoHR", "").Trim() %>";
            var tsUser = "<%= KSProgram.Parametry.ParametrCti("CasoveRazLoginHR", "").Trim() %>";
            var tsPass = "<%= KSProgram.Parametry.ParametrCti("CasoveRazHesloHR", "").Trim() %>";

            function RB_Sign_Clicked(sender, args) {
                const rcbCertificates = $find("<%= RCB_certificates.ClientID %>");
                var thumb = rcbCertificates.get_selectedItem().get_value();

                const rtbKotva = $find("<%= RTB_kotva.ClientID %>");
                var kotva = rtbKotva.get_value();
                PageMethods.GetTestDokument(function (result) {
                    signApi.signPdf(result, kotva, thumb, 0, tsUrl, tsUser, tsPass)
                        .then(signedfile => {
                            PageMethods.SendFile(signedfile.file, signedfile.id, function () {
                                const btnSend = $find("<%= TRB_send.ClientID %>");
                                btnSend.click();
                            });
                        })
                        .catch(error => {
                            console.error("Chyba při podpisu PDF:", error);
                        });
                });
            }

        </script>
    </telerik:RadScriptBlock>
    <label class="nadpis1">[%Testování podepisování pomocí KS Client Service%]</label><br />
    <telerik:RadLabel runat="server" ID="RL_info" Width="500" CssClass="ksOdstavec"
        Text="[%Tato stránka slouží k&nbsp;testování podepisování dokumentů pomocí služby <b>KS&#8239;Client&#8239;Service</b>, která musí být nainstalována a&nbsp;spuštěna na&nbsp;vašem počítači. Tato služba umožňuje aplikaci <b>KS&#8239;portál</b> využít certifikáty uložené ve&nbsp;vašem systémovém úložišti certifikátů (<b>Windows&nbsp;→&nbsp;Správa certifikátů uživatelů&nbsp;→&nbsp;Osobní</b>), včetně těch na&nbsp;hardwarových tokenech a&nbsp;čipových kartách.<br><br>Pokud jsou certifikáty dostupné v&nbsp;systémovém úložišti certifikátů díky specializovanému softwaru, jako je <b>SecureStore Card Manager</b> (I.CA), <b>SafeNet Authentication Client</b> (Thales) nebo <b>Bit4id Middleware</b>, může je služba KS Client Service využít pro&nbsp;elektronický podpis.<br><br>Pokud služba <b>KS&#8239;Client&#8239;Service</b> na&nbsp;vašem počítači neběží nebo je neaktuální, při načítání této stránky se zobrazilo okno s&nbsp;nadpisem '<b>Chyba&#8239;API</b>', výběr certifikátů zůstal prázdný a&nbsp;jejich použití není možné. Pro zajištění správné funkčnosti si můžete službu stáhnout a&nbsp;nainstalovat pomocí tlačítka níže.<br><br><b>Podpis dokumentu ve workflow</b><br>Pokud chcete využít podepisování certifikátem uloženým v&nbsp;úložišti v&nbsp;rámci workflow <b>Podpis dokumentu</b>, je nutné aktivovat rozšíření <b>KS&#8239;Client&#8239;Service</b>.%]">        
    </telerik:RadLabel><br /><br />
    <kspwc:TRadComboBox ID="RCB_certificates" runat="server" Width="500" DropDownAutoWidth="Enabled" Label="[%Vyber certifikát%]" ToolTip="[%Zde jsou osobní platné certifikáty nalezené ve vašem systémovém úložišti, které lze použít k podpisu dokumentu.%]"></kspwc:TRadComboBox>
    <br />
    <br />
    <telerik:RadTextBox ID="RTB_kotva" runat="server" Width="500" AutoPostBack="false" Label="[%Podpisová značka v dokumentu%]"
        EmptyMessage="[%například sign1%]" Text="sign1" ToolTip="[%Vyplňte požadovanou podepisovací značku, na kterou chcete umístit podpis (sign1 až sign9).%]">
    </telerik:RadTextBox><br />
    <br />
    <br />
    
    <kspwc:TRadButton ID="RB_nahled" runat="server" Text="[%Testovací dokument před podpisem%]" ToolTip="[%Stáhne testovací dokumet bez podpisů k nahlédnutí%]" CssClass="kstlacitko no-block-ui" OnClick="RB_nahled_Click"></kspwc:TRadButton>
    <kspwc:TRadButton ID="RB_Sign" runat="server" Text="[%Podepiš%]" ToolTip="[%Podepíše testovací dokument na zvolenou podepisovací značku a stáhne jeho podepsanou verzi%]" OnClientClicked="RB_Sign_Clicked" AutoPostBack="false"></kspwc:TRadButton>
    <kspwc:TRadButton ID="TRB_send" runat="server" Text="odeslat" OnClick="TRB_send_Click" CssClass="hidden no-block-ui"></kspwc:TRadButton><br /><br />
    <kspwc:TRadButton ID="TRB_install" runat="server" Text="[%Stáhnout instalátor služby%]" ToolTip="[%Stáhne aktuální instalátor služby KS Cient Service%]" CssClass="kstlacitko no-block-ui" OnClick="TRB_install_Click"></kspwc:TRadButton>

</asp:Content>
