﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Main.Master" AutoEventWireup="true"
    CodeBehind="PravaRoleUzivatel.aspx.cs" Inherits="KSPortal.Obecne.PravaRoleUzivatel" %>

<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>
<asp:Content ID="Content1" ContentPlaceHolderID="HeadContent" runat="server">
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="HlavniOblast" runat="server">
    <asp:ObjectDataSource ID="ds_allRoles" runat="server" SelectMethod="GetAllRoles"
        TypeName="KSProgram.Prava.PravaAkce"></asp:ObjectDataSource>
    <telerik:RadComboBox ID="RadComboBoxRole" runat="server" EmptyMessage="[%Role%]"
        DataSourceID="ds_allRoles" DataTextField="roleName" 
        DataValueField="roleId" AutoPostBack="True"
        OnSelectedIndexChanged="RadComboBoxRole_SelectedIndexChanged" 
        DropDownWidth="350px" Width="350px">
    </telerik:RadComboBox>
    <br />
    <br />
    <asp:ObjectDataSource ID="ODS_Users" runat="server" OldValuesParameterFormatString="original_{0}"
        SelectMethod="GetAllUsersWithRoleMark" TypeName="KSProgram.Prava.PortalUsers">
        <SelectParameters>
            <asp:ControlParameter ControlID="RadComboBoxRole" Name="roleId" PropertyName="SelectedValue"
                Type="Int32" />
        </SelectParameters>
    </asp:ObjectDataSource>
    <kspwc:TRadGrid ID="RadGridUsers" runat="server" AutoGenerateColumns="False" 
        Visible="False" AllowPaging="true">
        <ExportSettings>
            <Pdf PageWidth="">
            </Pdf>
        </ExportSettings>
        <MasterTableView EditMode="EditForms" AllowFilteringByColumn="True" AllowSorting="True"
            DataKeyNames="login" Caption="[%Uživatelé%]">
            <PagerStyle PageSizes="10,20,50,100,200,500,1000" />
            <Columns>
                <telerik:GridTemplateColumn DataField="isMember" DataType="System.Boolean" FilterControlAltText="Filter isMember column"
                    SortExpression="isMember" UniqueName="isMember" HeaderText="[%Je členem%]">
                    <ItemTemplate>
                        <asp:CheckBox ID="CB_isMember" runat="server" AutoPostBack="True" Checked='<%# Bind("isMember") %>'
                            OnCheckedChanged="CB_isMember_CheckedChanged"></asp:CheckBox>
                    </ItemTemplate>
                </telerik:GridTemplateColumn>
                <telerik:GridBoundColumn DataField="login" FilterControlAltText="Filter login column"
                    HeaderText="[%Login%]" UniqueName="login" ReadOnly="True">
                </telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="osCislo" DataType="System.Decimal" FilterControlAltText="Filter osCislo column"
                    HeaderText="[%Osobní číslo%]" SortExpression="osCislo" UniqueName="osCislo" ReadOnly="True">
                </telerik:GridBoundColumn>
                <kspwc:GridFotoZamColumn UniqueName="foto" DataOsCisloField="osCislo"></kspwc:GridFotoZamColumn>
                <telerik:GridBoundColumn DataField="prijmeni" FilterControlAltText="Filter prijmeni column"
                    HeaderText="[%Příjmení%]" ReadOnly="True" SortExpression="prijmeni" UniqueName="prijmeni">
                </telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="jmeno" FilterControlAltText="Filter jmeno column"
                    HeaderText="[%Jméno%]" ReadOnly="True" SortExpression="jmeno" UniqueName="jmeno">
                </telerik:GridBoundColumn>
            </Columns>
        </MasterTableView>
    </kspwc:TRadGrid>
</asp:Content>
