﻿<%@ Control Language="C#" AutoEventWireup="true" CodeBehind="ExportGridButtonC.ascx.cs" Inherits="KSPortal.Controls.ExportGridButtonC" %>
<%@ Register assembly="Telerik.Web.UI" namespace="Telerik.Web.UI" tagprefix="telerik" %>
<telerik:RadScriptBlock ID="RadScriptBlock1" runat="server">
    <script type="text/javascript" id="telerikClientEvents2">
        function showExportMenu(sender, args) {
            var contextMenu = $find('<%= RCM_ExportGridButtonC.ClientID %>');
            if (contextMenu) {
                var currentLocation = $telerik.getBounds(sender.get_element());
                contextMenu.showAt(currentLocation.x, currentLocation.y + currentLocation.height);
            }
        }
    </script>
</telerik:RadScriptBlock>
<kspwc:TRadButton ID="TRB_ExportGridButtonC" runat="server" Text="[%Export%]" AutoPostBack="False"
    OnClientClicked="showExportMenu">
    <Icon PrimaryIconUrl="~/ImagesN/export.png" />
</kspwc:TRadButton>
<telerik:RadContextMenu ID="RCM_ExportGridButtonC" Runat="server" 
    onitemclick="RCM_ExportGridButtonC_ItemClick">
    <Targets>
        <telerik:ContextMenuControlTarget ControlID="TRB_ExportGridButtonC" />
    </Targets>
    <Items>
        <telerik:RadMenuItem runat="server" Text="Excel Html" ImageUrl="~/ImagesN/export_exel.gif" Value="exel_html">
        </telerik:RadMenuItem>
        <telerik:RadMenuItem runat="server" Text="Excel ML" ImageUrl="~/ImagesN/export_exel.gif" Value="exel_ml">
        </telerik:RadMenuItem>
        <telerik:RadMenuItem runat="server" Text="Excel BIFF" ImageUrl="~/ImagesN/export_exel.gif" Value="exel_biff">
        </telerik:RadMenuItem>
        <telerik:RadMenuItem runat="server" Text="Word" ImageUrl="~/ImagesN/export_word.gif" Value="word">
        </telerik:RadMenuItem>
        <telerik:RadMenuItem runat="server" Text="Csv" ImageUrl="~/ImagesN/export_csv.gif" Value="csv">
        </telerik:RadMenuItem>
        <telerik:RadMenuItem runat="server" Text="Pdf" ImageUrl="~/ImagesN/export_pdf.gif" Value="pdf">
        </telerik:RadMenuItem>
    </Items>
</telerik:RadContextMenu>

