﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="DchUkolyKody.aspx.cs" MasterPageFile="~/Main.Master" Inherits="KSPortal.Dochazka.DchUkolyKody" %>
<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>

<asp:Content ID="Content1" ContentPlaceHolderID="HeadContent" runat="server">
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="HlavniOblast" runat="server">
    <telerik:RadCodeBlock runat="server" ID="code_block">          
            <script type="text/javascript">
        //<![CDATA[                      
                (function () {
                })();
                function GetRadWindow() {
                    var oWindow = null;
                    if (window.radWindow) oWindow = window.radWindow;
                    else if (window.frameElement.radWindow) oWindow = window.frameElement.radWindow;
                    return oWindow;
                }
                function SetValue(val, kam) {
                    GetRadWindow().BrowserWindow.SetValueTxBox(val, kam);
                    // Tip: you can pass an argument to provide data to the called function
                }
                function RowDblClickKod(sender, eventArgs) {
                    var dkval = eventArgs.getDataKeyValue("vyr_kod");
                    SetValue(dkval, "txt_kod");                   
                }        
                function RowDblClickProjekt(sender, eventArgs) {
                    var dkval = eventArgs.getDataKeyValue("projekt");//tady doplním projekt                   
                    SetValue(dkval, "txt_projekt");
                }
                function RowDblClickUloha(sender, eventArgs) {
                    var dkval = eventArgs.getDataKeyValue("uloha");//tady doplním ulohu                   
                    SetValue(dkval, "txt_ukol");
                }                
                 //]]>
            </script>
      </telerik:RadCodeBlock>
    <div style="width:550px;">
    <asp:MultiView runat="server" ID="mv" >
        <asp:View ID="v_CisPolozek" runat="server">
          <kspwc:TRadGrid ID="tgv_CisPolozek" runat="server" IdPravaEditace="23" ExportSettings-ExportOnlyData="true" ExportSettings-Csv-ColumnDelimiter="Semicolon"
         DataKeyNames="vyr_kod"  AllowSorting="true" CaptionVisible="false"
          OnNeedDataSource="tgv_CisPolozek_NeedDataSource" >
        <ClientSettings EnableRowHoverStyle="true">
            <ClientEvents OnRowDblClick="RowDblClickKod" />
            <Selecting AllowRowSelect="True"></Selecting>        
        </ClientSettings>
        <MasterTableView AutoGenerateColumns="false" TableLayout="Fixed"  DataKeyNames="vyr_kod" ClientDataKeyNames="vyr_kod">            
            <Columns>             
                <telerik:GridTemplateColumn HeaderText="[%Kód%]" SortExpression="vyr_kod">                
                    <ItemTemplate>
                        <asp:Label ID="Label178" runat="server" Text='<%# Bind("vyr_kod") %>'></asp:Label>
                    </ItemTemplate>
                </telerik:GridTemplateColumn>
                <telerik:GridBoundColumn DataField="nazev" HeaderText="[%Název%]"
                    SortExpression="nazev" />
                </Columns>
            </MasterTableView>        
        </kspwc:TRadGrid>  
        </asp:View>
        <asp:View ID="v_projekty" runat="server" >
            <kspwc:TRadGrid ID="tgv_projekty" runat="server" IdPravaEditace="23" ExportSettings-ExportOnlyData="true" ExportSettings-Csv-ColumnDelimiter="Semicolon"
         DataKeyNames="projekt"  AllowSorting="true" CaptionVisible="false"
          OnNeedDataSource="tgv_projekty_NeedDataSource" >
        <ClientSettings EnableRowHoverStyle="true">
            <ClientEvents OnRowDblClick="RowDblClickProjekt" />
            <Selecting AllowRowSelect="True"></Selecting>        
        </ClientSettings>
        <MasterTableView AutoGenerateColumns="false" TableLayout="Fixed"  DataKeyNames="projekt" ClientDataKeyNames="projekt">            
            <Columns>             
                <telerik:GridTemplateColumn HeaderText="[%Projekt%]" SortExpression="projekt">                
                    <ItemTemplate>
                        <asp:Label ID="Label178" runat="server" Text='<%# Bind("projekt") %>'></asp:Label>
                    </ItemTemplate>
                </telerik:GridTemplateColumn>
                <telerik:GridBoundColumn DataField="nazev" HeaderText="[%Název%]"
                    SortExpression="nazev" />
                </Columns>
            </MasterTableView>        
        </kspwc:TRadGrid>    
        </asp:View>
        <asp:View ID="v_ukoly" runat="server">
            <kspwc:TRadGrid ID="tgv_ukoly" runat="server" IdPravaEditace="23" ExportSettings-ExportOnlyData="true" ExportSettings-Csv-ColumnDelimiter="Semicolon"
         DataKeyNames="uloha"  AllowSorting="true" CaptionVisible="false"
          OnNeedDataSource="tgv_ukoly_NeedDataSource" >
        <ClientSettings EnableRowHoverStyle="true">
            <ClientEvents OnRowDblClick="RowDblClickUloha" />
            <Selecting AllowRowSelect="True"></Selecting>        
        </ClientSettings>
        <MasterTableView AutoGenerateColumns="false" TableLayout="Fixed"  DataKeyNames="uloha" ClientDataKeyNames="uloha">            
            <Columns>             
                <telerik:GridTemplateColumn HeaderText="[%Úkol%]" SortExpression="uloha">                
                    <ItemTemplate>
                        <asp:Label ID="Label178" runat="server" Text='<%# Bind("uloha") %>'></asp:Label>
                    </ItemTemplate>
                </telerik:GridTemplateColumn>
                <telerik:GridBoundColumn DataField="nazev" HeaderText="[%Název%]"
                    SortExpression="nazev" />
                <telerik:GridBoundColumn DataField="plati_od" HeaderText="[%Platnost od%]"
                    SortExpression="plati_do" />
                <telerik:GridBoundColumn DataField="plati_do" HeaderText="[%Platnost do%]"
                    SortExpression="plati_do" />
                </Columns>
            </MasterTableView>        
        </kspwc:TRadGrid>    
        </asp:View>
    </asp:MultiView> 
    </div>   
</asp:Content>