﻿<%@ Control Language="C#" AutoEventWireup="true" CodeBehind="DokumentyKPodpisu.ascx.cs" Inherits="KSPortal.Dokumenty.DokumentyKPodpisu" %>

<%@ Register Assembly="AjaxControlToolkit" Namespace="AjaxControlToolkit" TagPrefix="asp" %>
<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>
<%@ Register Src="~/Dokumenty/PdfViewer.ascx" TagName="PdfViewer" TagPrefix="pdf" %>

<telerik:RadAjaxManagerProxy ID="RAMP_UC_DKP" runat="server">
    <AjaxSettings>
        <telerik:AjaxSetting AjaxControlID="TRadGrid_dokumenty">
            <UpdatedControls>
                <telerik:AjaxUpdatedControl ControlID="TRadGrid_dokumenty" />
                <telerik:AjaxUpdatedControl ControlID="RadWindowPodpis" />
            </UpdatedControls>
        </telerik:AjaxSetting>
        <telerik:AjaxSetting AjaxControlID="podepsatDok1">
            <UpdatedControls>
            </UpdatedControls>
        </telerik:AjaxSetting>
        <telerik:AjaxSetting AjaxControlID="ExportTo_file">
            <UpdatedControls>
            </UpdatedControls>
        </telerik:AjaxSetting>
    </AjaxSettings>
</telerik:RadAjaxManagerProxy>

<telerik:RadPersistenceManagerProxy ID="RPMP_DkPodpControl" runat="server">
    <PersistenceSettings>
        <telerik:PersistenceSetting ControlID="TRadGrid_dokumenty" />
    </PersistenceSettings>
</telerik:RadPersistenceManagerProxy>


<kspwc:TRadGrid ID="TRadGrid_dokumenty" runat="server" AllowPaging="True" ShowGroupPanel="True" KSGridType="AutoFit,Rolovani"
    AllowSorting="true" AutoGenerateColumns="false" OnNeedDataSource="TRadGrid_dokumenty_NeedDataSource1"
    AutoFilterControlWidth="false" MasterTableView-ShowFooter="False" AllowMultiRowSelection="true"
    OnItemCommand="TRadGrid_dokumenty_ItemCommand" OnDataBound="TRadGrid_dokumenty_DataBound" EnableLinqExpressions="false">
    <GroupingSettings CaseSensitive="False" CollapseAllTooltip="Collapse all groups" ShowUnGroupButton="true"></GroupingSettings>
    <MasterTableView CommandItemDisplay="Top" Caption="[%Dokumenty k podpisu%]" PageSize="50" PagerStyle-Visible="true" GroupLoadMode="Client"
        EnableGroupsExpandAll="true" EnableHeaderContextMenu="true"
        DataKeyNames="typ,id_blob,stav_id,kod_podpisu,id_dok_agenda,id_poz">
        <PagerStyle PageSizes="20,50,100,200" />
        <ColumnGroups>
            <telerik:GridColumnGroup Name="a" HeaderText="[%Podepisuje%]"></telerik:GridColumnGroup>
            <telerik:GridColumnGroup Name="v" HeaderText="[%Vlastník dokumentu%]"></telerik:GridColumnGroup>
            <telerik:GridColumnGroup Name="m" HeaderText="[%Mzdové údaje vlastníka%]"></telerik:GridColumnGroup>
        </ColumnGroups>
        <Columns>
            <telerik:GridClientSelectColumn UniqueName="select"></telerik:GridClientSelectColumn>
            <telerik:GridBoundColumn DataField="os_cislo_adresat" ColumnGroupName="a" HeaderText="[%Os.cislo%]" SortExpression="os_cislo_adresat" />
            <kspwc:GridFotoZamColumn DataOsCisloField="os_cislo_adresat" ColumnGroupName="a" UniqueName="foto_pod"></kspwc:GridFotoZamColumn>
            <telerik:GridBoundColumn DataField="jmeno_adresata" ColumnGroupName="a" HeaderText="[%Jméno%]" SortExpression="jmeno_adresata" />
            <telerik:GridBoundColumn DataField="id" HeaderText="id" Display="False" />
            <telerik:GridNumericColumn DataField="vl_os_cislo" ColumnGroupName="v" HeaderText="[%Os.číslo%]" UniqueName="vl_os_cislo"></telerik:GridNumericColumn>
            <kspwc:GridFotoZamColumn DataOsCisloField="vl_os_cislo" ColumnGroupName="v" UniqueName="foto"></kspwc:GridFotoZamColumn>
            <telerik:GridBoundColumn DataField="vl_jmeno" ColumnGroupName="v" HeaderText="[%Jméno%]" UniqueName="vl_jmeno" />
            <telerik:GridBoundColumn DataField="vl_prijmeni" ColumnGroupName="v" HeaderText="[%Příjmení%]" UniqueName="vl_prijmeni" />
            <telerik:GridBoundColumn DataField="uziv_druh_text" ColumnGroupName="v" HeaderText="[%Druh poměru%]" UniqueName="uziv_druh_text" />
            <telerik:GridDateTimeColumn DataField="datum_nastupu" ColumnGroupName="v" HeaderText="[%Datum nástupu%]" DataFormatString="{0:d.M.yyyy}" UniqueName="datum_nastupu" />
            <telerik:GridBoundColumn DataField="cis_pracmist" ColumnGroupName="v" HeaderText="[%Číslo místa%]" UniqueName="cis_pracmist" />
            <telerik:GridBoundColumn DataField="naz_pracmist" ColumnGroupName="v" HeaderText="[%Pracovní místo%]" UniqueName="naz_pracmist" />
            <telerik:GridBoundColumn DataField="agenda" HeaderText="[%Agenda%]" UniqueName="agenda" />
            <telerik:GridBoundColumn DataField="sablona" HeaderText="[%Šablona dokumentu%]" UniqueName="sablona" Display="false" />
            <telerik:GridBoundColumn DataField="nazevDokumentu" HeaderText="[%Název dokumentu%]" SortExpression="nazevDokumentu" />
            <telerik:GridTemplateColumn UniqueName="nahled" AllowFiltering="false" AllowSorting="false">
                <ItemTemplate>
                    <kspwc:TRadButton runat="server" CommandName="preview" ToolTip="[%Náhled%]" >
                        <Icon PrimaryIconCssClass="fi fi-search" />
                    </kspwc:TRadButton>
                </ItemTemplate>
            </telerik:GridTemplateColumn>
            <telerik:GridBoundColumn DataField="typ" HeaderText="[%typ%]" SortExpression="typ" Display="False" />
            <telerik:GridBoundColumn DataField="pocet_podpisu" HeaderText="pocet_podpisu" SortExpression="pocet_podpisu" Display="False" />
            <telerik:GridBoundColumn DataField="kod_podpisu" HeaderText="[%Kód podpisu%]" SortExpression="kod_podpisu" Display="false" />
            <telerik:GridBoundColumn DataField="stav" HeaderText="[%Stav%]" SortExpression="stav" />
            <telerik:GridBoundColumn DataField="stav_id" HeaderText="[%Stav ID%]" SortExpression="stav_id" Display="false" />
            <telerik:GridDateTimeColumn DataField="dat_zal" HeaderText="[%Dat. vytvoření%]" SortExpression="dat_zal" DataFormatString="{0:d.M.yyyy}" />
            <telerik:GridBoundColumn DataField="id_blob" HeaderText="id_blob" Display="False" />
            <telerik:GridBoundColumn DataField="id_poz" HeaderText="id_poz" Display="False" />
            <telerik:GridNumericColumn DataField="tarif" ColumnGroupName="m" HeaderText="[%Tarif%]" UniqueName="tarif"></telerik:GridNumericColumn>
            <telerik:GridNumericColumn DataField="os_hodn" ColumnGroupName="m" HeaderText="[%Os. hodn.%]" UniqueName="os_hodn"></telerik:GridNumericColumn>
            <telerik:GridNumericColumn DataField="typ_premii" ColumnGroupName="m" HeaderText="[%Typ prémií%]" UniqueName="typ_premii"></telerik:GridNumericColumn>
            <telerik:GridBoundColumn DataField="typ_premii_text" ColumnGroupName="m" HeaderText="[%Název pol.%]" UniqueName="typ_premii_text" />
            <telerik:GridNumericColumn DataField="prem_cast" ColumnGroupName="m" HeaderText="[%Částka prémií%]" UniqueName="prem_cast"></telerik:GridNumericColumn>

        </Columns>
        <CommandItemTemplate>
            <kspwc:GridCommandItemControl ID="GcIc3" runat="server">
                <ExportButton runat="server" Visible="false"></ExportButton>
            </kspwc:GridCommandItemControl>

            <div style="padding: 2px; height: 100%">
                <kspwc:TRadButton runat="server" ID="podepsatDok1" Text="[%Podepsat vybrané%]" OnClick="podepsatDok_Click" Icon-PrimaryIconCssClass="fi fi-edit"></kspwc:TRadButton>
                <kspwc:TRadButton ID="ExportTo_file" runat="server" OnClick="downloadBtn_Click" Text="[%Uložit vybrané%]" Icon-PrimaryIconCssClass="fi fi-disk"></kspwc:TRadButton>
                <kspwc:TRadButton ID="TRB_delete_poz" runat="server" OnClick="TRB_delete_poz_Click" Text="[%Smazat vybrané%]" Icon-PrimaryIconCssClass="fi fi-trash" IdPrava="-1" ConfirmTitle="[%Mazání požadavků%]" ConfirmText="[%Všechny vybrané požadavky na podpis dokumentu budou smazány. Všechny podepsané verze dokumentů ve výběru s již obsaženými podpisy budou smazány. Zůstanou pouze nepodepsané verze dokumentů v dokumentech vystavených, u kterých bude nutné znovu založit požadavek na podpis.%]"></kspwc:TRadButton>
            </div>
            <%--<kspwc:TRadButton AutoPostBack="true" runat="server" OnClick="TRB_SelectAll_Click" ID="TRB_SelectAll" Text="[%Podepsat vše%]" style="margin-top:2px;"/>--%>
        </CommandItemTemplate>
    </MasterTableView>
    <ClientSettings AllowDragToGroup="True">
        <Selecting AllowRowSelect="true" />
        <%--Dovolí vybrat položku z tabulky --%>
    </ClientSettings>
</kspwc:TRadGrid>


    <telerik:RadWindow ID="RadWindowPodpis" runat="server" Behaviors="Close,Resize,Move,Pin" Modal="false" 
        Title="[%Dokument%]" VisibleOnPageLoad="true" OnItemCommand="WindowClosed" AutoSize="false" Top="60" Height="1024" Width="800">
        <ContentTemplate>
            <pdf:PdfViewer runat="server" ID="PV_viewer" Height="100%" Width="100%" ParentWindowPozice="Right"></pdf:PdfViewer>
        </ContentTemplate>
    </telerik:RadWindow>