﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Main.Master" AutoEventWireup="true" Inherits="Sestavy_HodnoceniVzdelAkce" Codebehind="HodnoceniVzdelAkce.aspx.cs" %>

<%@ Register Assembly="WebControls" Namespace="KSProgram.WebControls" TagPrefix="wc" %>
<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>

<asp:Content ID="Content1" ContentPlaceHolderID="HlavniOblast" runat="Server">
    <telerik:RadAjaxManagerProxy ID="RadAjaxManagerProxy1" runat="server">
        <AjaxSettings>
            <telerik:AjaxSetting AjaxControlID="TRadGrid_sestava">
                <UpdatedControls>
                    <telerik:AjaxUpdatedControl ControlID="TRadGrid_sestava" />
                </UpdatedControls>
            </telerik:AjaxSetting>
        </AjaxSettings>
    </telerik:RadAjaxManagerProxy>
    <asp:Label ID="Label1" runat="server" Text="[%Hodnocení vzdělávacích akcí%]" CssClass="nadpis1"></asp:Label>
    <table style="border: 1px solid #808080; border-collapse: collapse" class="ksprvek HodnoceniToolbar">
        <tr>
            <td>
                <asp:Label ID="Label3" runat="server" Text="[%Hodnotící akce%]:"></asp:Label>
            </td>
            <td style="border-right-style: solid; border-width: 1px; border-color: #808080" colspan="2">
                <asp:ObjectDataSource ID="ODS_akce" runat="server" OldValuesParameterFormatString="original_{0}"
                    SelectMethod="HodnoticiAkce" TypeName="KSProgram.Hodnoceni.Hodnoceni">
                    <SelectParameters>
                        <asp:Parameter Name="zamceno" DbType="Int16" />
                        <asp:Parameter Name="jen_primi" Type="Boolean" DefaultValue="false" />
                        <asp:Parameter Name="existujeOdkazDo" Type="String" DefaultValue="hz_hod_sko.idp;" />
                    </SelectParameters>
                </asp:ObjectDataSource>
                <wc:TDropDown ID="TDD_akce" runat="server" DataSourceID="ODS_akce" DataTextField="nazev"
                    DataValueField="id" OnDataBound="TDD_akce_DataBound" AutoPostBack="True">
                </wc:TDropDown>
            </td>
            <td colspan="2">
                <asp:RadioButtonList ID="RBL_zamceno" runat="server" RepeatDirection="Horizontal"
                    AutoPostBack="True">
                    <asp:ListItem Selected="True" Value="2">[%Všechny%]</asp:ListItem>
                    <asp:ListItem Selected="False" Value="0">[%Neuzavřeno%]</asp:ListItem>
                    <asp:ListItem Selected="False" Value="1">[%Uzavřeno%]</asp:ListItem>
                </asp:RadioButtonList>
            </td>
        </tr>
        <tr>
            <td colspan="2" style="border-width: 1px; border-color: #808080; font-weight: bold; border-right-style: solid; border-top-style: solid;">[%Filtr zaměstnanců%]</td>
            <td style="border-width: 1px; border-color: #808080; font-weight: bold; border-right-style: solid; border-top-style: solid;">[%Shrnout zaměstnance%]</td>
            <td style="border-width: 1px; border-color: #808080; font-weight: bold; border-right-style: solid; border-top-style: solid;">[%Filtr vzd. aktivity%]</td>
            <td style="border-width: 1px; border-color: #808080; font-weight: bold; border-top-style: solid;">[%Shrnout vzdělávání%]</td>
        </tr>
        <tr>
            <td>
                <asp:Label ID="L_divize" runat="server" Text="[%Divize%]:"></asp:Label>
                <br />
                <asp:ObjectDataSource ID="ODS_divize" runat="server" OldValuesParameterFormatString="original_{0}"
                    SelectMethod="cislDivize" TypeName="KSProgram.Sestavy.DefSestavy_HodnKompetence">
                    <SelectParameters>
                        <asp:ControlParameter ControlID="TDD_akce" Name="Id_ha" PropertyName="SelectedValue"
                            Type="String" />
                        <asp:ControlParameter ControlID="RBL_zamceno" DefaultValue="2" Name="zamceno" PropertyName="SelectedValue"
                            Type="Int16" />
                    </SelectParameters>
                </asp:ObjectDataSource>
                <wc:TDropDown ID="TDD_divize" runat="server" DataSourceID="ODS_divize" DataTextField="naz_divize"
                    DataValueField="cis_divize" AutoPostBack="True">
                </wc:TDropDown>
            </td>
            <td style="border-right-style: solid; border-width: 1px; border-color: #808080">
                <asp:Label ID="L_stredisko" runat="server" Text="[%Středisko%]:"></asp:Label>
                <br />
                <asp:ObjectDataSource ID="ODS_Stredisko" runat="server" OldValuesParameterFormatString="original_{0}"
                    SelectMethod="cislStredisko" TypeName="KSProgram.Sestavy.DefSestavy_HodnKompetence">
                    <SelectParameters>
                        <asp:ControlParameter ControlID="TDD_akce" Name="Id_ha" PropertyName="SelectedValue"
                            Type="String" />
                        <asp:ControlParameter ControlID="TDD_divize" Name="cis_divize" PropertyName="SelectedValue"
                            Type="String" />
                        <asp:ControlParameter ControlID="TDD_skupinaStred" Name="skup_str" PropertyName="SelectedValue"
                            Type="String" />
                        <asp:ControlParameter ControlID="RBL_zamceno" DefaultValue="" Name="zamceno" PropertyName="SelectedValue"
                            Type="Int16" />
                    </SelectParameters>
                </asp:ObjectDataSource>
                <wc:TDropDown ID="TDD_stredisko" runat="server" DataSourceID="ODS_Stredisko" DataTextField="nazev"
                    DataValueField="str" AutoPostBack="True">
                </wc:TDropDown>
            </td>
            <td style="border-right-style: solid; border-width: 1px; border-color: #808080" rowspan="3">
                <asp:RadioButtonList ID="RBL_group_zam" runat="server" RepeatColumns="2" AutoPostBack="True">
                    <asp:ListItem Value="4">[%Za všechny%]</asp:ListItem>
                    <asp:ListItem Value="1">[%Po divizích%]</asp:ListItem>
                    <asp:ListItem Value="2">[%Po skupinách středisek%]</asp:ListItem>
                    <asp:ListItem Value="3">[%Po střediscích%]</asp:ListItem>
                    <asp:ListItem Selected="True" Value="0">[%Po zaměstnancích%]</asp:ListItem>
                </asp:RadioButtonList>
            </td>
            <td style="border-right-style: solid; border-width: 1px; border-color: #808080">
                <asp:Label ID="L_typ_osve" runat="server" Text="[%Typ vzd. aktivity%]:"></asp:Label>
                <br />
                <asp:ObjectDataSource ID="ODS_typy_akci" runat="server" OldValuesParameterFormatString="original_{0}"
                    SelectMethod="cislTypySkolAkci" TypeName="KSProgram.Sestavy.DefSestavy_HodnVzdelAkce">
                    <SelectParameters>
                        <asp:ControlParameter ControlID="TDD_akce" Name="Id_ha" PropertyName="SelectedValue"
                            Type="String" />
                        <asp:ControlParameter ControlID="RBL_zamceno" Name="zamceno" PropertyName="SelectedValue"
                            Type="Int16" />
                        <asp:ControlParameter ControlID="TDD_divize" Name="cis_divize" PropertyName="SelectedValue"
                            Type="String" />
                        <asp:ControlParameter ControlID="TDD_skupinaStred" Name="skup_str" PropertyName="SelectedValue"
                            Type="String" />
                        <asp:ControlParameter ControlID="TDD_stredisko" Name="str" PropertyName="SelectedValue"
                            Type="String" />
                        <asp:ControlParameter ControlID="TDD_zamestnanec" Name="os_cislo" PropertyName="SelectedValue"
                            Type="String" />
                    </SelectParameters>
                </asp:ObjectDataSource>
                <wc:TDropDown ID="TDD_typy_skoleni" runat="server" DataSourceID="ODS_typy_akci" DataTextField="nazev_typu"
                    DataValueField="typ_akce" AutoPostBack="True">
                </wc:TDropDown>
            </td>
            <td rowspan="3">
                <asp:RadioButtonList ID="RBL_group_vzd" runat="server" AutoPostBack="True">
                    <asp:ListItem Value="3">[%Za hodnocení%]</asp:ListItem>
                    <asp:ListItem Value="2">[%Po typech vzd. aktivit%]</asp:ListItem>
                    <asp:ListItem Value="1">[%Po vzd. aktivitách%]</asp:ListItem>
                    <asp:ListItem Selected="True" Value="0" >[%Po otázkách%]</asp:ListItem>
                </asp:RadioButtonList>
            </td>
        </tr>
        <tr>
            <td rowspan="2">
                <asp:Label ID="L_skupinaStred" runat="server" Text="[%Skup. středisek%]:"></asp:Label>
                <br />
                <asp:ObjectDataSource ID="ODS_SkupinaStred" runat="server" OldValuesParameterFormatString="original_{0}"
                    SelectMethod="cislSkupinaStred" TypeName="KSProgram.Sestavy.DefSestavy_HodnKompetence">
                    <SelectParameters>
                        <asp:ControlParameter ControlID="TDD_akce" Name="Id_ha" PropertyName="SelectedValue"
                            Type="String" />
                        <asp:ControlParameter ControlID="RBL_zamceno" DefaultValue="" Name="zamceno" PropertyName="SelectedValue"
                            Type="Int16" />
                    </SelectParameters>
                </asp:ObjectDataSource>
                <wc:TDropDown ID="TDD_skupinaStred" runat="server" DataSourceID="ODS_SkupinaStred"
                    DataTextField="skup_nazev" DataValueField="skup_str" AutoPostBack="True">
                </wc:TDropDown>
            </td>
            <td style="border-right-style: solid; border-width: 1px; border-color: #808080" rowspan="2">
                <asp:Label ID="L_zamestnanec" runat="server" Text="[%Zaměstnanec%]:"></asp:Label>
                <br />
                <asp:ObjectDataSource ID="ODS_Zamestnanec" runat="server" OldValuesParameterFormatString="original_{0}"
                    SelectMethod="cislZamestnanec" TypeName="KSProgram.Sestavy.DefSestavy_HodnKompetence">
                    <SelectParameters>
                        <asp:ControlParameter ControlID="TDD_akce" Name="Id_ha" PropertyName="SelectedValue"
                            Type="String" />
                        <asp:ControlParameter ControlID="TDD_divize" Name="cis_divize" PropertyName="SelectedValue"
                            Type="String" />
                        <asp:ControlParameter ControlID="TDD_skupinaStred" Name="skup_str" PropertyName="SelectedValue"
                            Type="String" />
                        <asp:ControlParameter ControlID="TDD_stredisko" Name="str" PropertyName="SelectedValue"
                            Type="String" />
                        <asp:ControlParameter ControlID="RBL_zamceno" DefaultValue="" Name="zamceno" PropertyName="SelectedValue"
                            Type="Int16" />
                    </SelectParameters>
                </asp:ObjectDataSource>
                <wc:TDropDown ID="TDD_zamestnanec" runat="server" DataSourceID="ODS_Zamestnanec"
                    DataTextField="jmeno" DataValueField="os_cislo" AutoPostBack="True">
                </wc:TDropDown>
            </td>
            <td style="border-right-style: solid; border-width: 1px; border-color: #808080">
                <asp:Label ID="L_osvedceni" runat="server" Text="[%Vzdělávací aktivita%]:"></asp:Label>
                <br />
                <asp:ObjectDataSource ID="ODS_osvedceni" runat="server" OldValuesParameterFormatString="original_{0}"
                    SelectMethod="cislOsvedceni" TypeName="KSProgram.Sestavy.DefSestavy_HodnVzdelAkce">
                    <SelectParameters>
                        <asp:ControlParameter ControlID="TDD_akce" Name="Id_ha" PropertyName="SelectedValue"
                            Type="String" />
                        <asp:ControlParameter ControlID="RBL_zamceno" Name="zamceno" PropertyName="SelectedValue"
                            Type="Int16" />
                        <asp:ControlParameter ControlID="TDD_divize" Name="cis_divize" PropertyName="SelectedValue"
                            Type="String" />
                        <asp:ControlParameter ControlID="TDD_skupinaStred" Name="skup_str" PropertyName="SelectedValue"
                            Type="String" />
                        <asp:ControlParameter ControlID="TDD_stredisko" Name="str" PropertyName="SelectedValue"
                            Type="String" />
                        <asp:ControlParameter ControlID="TDD_zamestnanec" Name="os_cislo" PropertyName="SelectedValue"
                            Type="String" />
                        <asp:ControlParameter ControlID="TDD_typy_skoleni" Name="TypOsvedceni" PropertyName="SelectedValue"
                            Type="String" />
                    </SelectParameters>
                </asp:ObjectDataSource>
                <wc:TDropDown ID="TDD_osvedceni" runat="server" DataSourceID="ODS_osvedceni" DataTextField="text_osve"
                    DataValueField="cislo" AutoPostBack="True">
                </wc:TDropDown>
            </td>
        </tr>
        <tr>
            <td style="border-right-style: solid; border-width: 1px; border-color: #808080">
                [%Hodnotící otázka%]:<br />
                <asp:ObjectDataSource ID="ODS_otazky" runat="server" OldValuesParameterFormatString="original_{0}"
                    SelectMethod="cislOtazky" TypeName="KSProgram.Sestavy.DefSestavy_HodnVzdelAkce">
                    <SelectParameters>
                        <asp:ControlParameter ControlID="TDD_akce" Name="Id_ha" PropertyName="SelectedValue"
                            Type="String" />
                        <asp:ControlParameter ControlID="RBL_zamceno" Name="zamceno" PropertyName="SelectedValue"
                            Type="Int16" />
                        <asp:ControlParameter ControlID="TDD_divize" Name="cis_divize" PropertyName="SelectedValue"
                            Type="String" />
                        <asp:ControlParameter ControlID="TDD_skupinaStred" Name="skup_str" PropertyName="SelectedValue"
                            Type="String" />
                        <asp:ControlParameter ControlID="TDD_stredisko" Name="str" PropertyName="SelectedValue"
                            Type="String" />
                        <asp:ControlParameter ControlID="TDD_zamestnanec" Name="os_cislo" PropertyName="SelectedValue"
                            Type="String" />
                        <asp:ControlParameter ControlID="TDD_typy_skoleni" Name="TypOsvedceni" PropertyName="SelectedValue"
                            Type="String" />
                        <asp:ControlParameter ControlID="TDD_osvedceni" Name="Osvedceni" PropertyName="SelectedValue"
                            Type="String" />
                    </SelectParameters>
                </asp:ObjectDataSource>
                <wc:TDropDown ID="TDD_otazky" runat="server" DataSourceID="ODS_otazky" DataTextField="vyznam"
                    DataValueField="otazka">
                </wc:TDropDown>
            </td>
        </tr>
        <tr>
            <td colspan="5" style="border-top-style: solid; border-width: 1px; border-color: #808080">
                <asp:Label ID="Label4" runat="server" Text="[%Sloupce%]:"></asp:Label>
                <wc:TCheckBoxList ID="CBL_show" runat="server" RepeatDirection="Horizontal" UseSaveSetting="True" OnPreRender="CBL_show_PreRender">
                </wc:TCheckBoxList>
            </td>
        </tr>
    </table>
    <br />
    <wc:TLinkButton runat="server" ID="lb_nacist" Text="[%Vytvořit%]" CssClass="kstlacitko"
        SkinID="button" OnCommand="lb_nacist_Command"></wc:TLinkButton>
    <br />
    <br />
    <asp:ObjectDataSource ID="ODS_sestava" runat="server" OldValuesParameterFormatString="original_{0}"
        SelectMethod="Retrieve" TypeName="KSProgram.Sestavy.DefSestavy_HodnVzdelAkce">
        <SelectParameters>
            <asp:Parameter Name="Id_ha" Type="String" />
            <asp:Parameter Name="cis_divize" Type="Int32" />
            <asp:Parameter Name="skup_str" Type="Int32" />
            <asp:Parameter Name="str" Type="String" />
            <asp:Parameter Name="os_cislo" Type="String" />
            <asp:Parameter Name="typ_osvedceni" Type="String" />
            <asp:Parameter Name="osvedceni" Type="String" />
            <asp:Parameter Name="otazka" Type="String" />
            <asp:Parameter Name="groupZam" Type="String" />
            <asp:Parameter Name="groupVzd" Type="String" />
            <asp:Parameter Name="zamceno" Type="Int16" />
            <asp:Parameter Name="columns" Type="String" />
        </SelectParameters>
    </asp:ObjectDataSource>
    <%--
    <wc:TGridView ID="TGV_sestava" runat="server" AllowMultiColumnSorting="True" PovolFiltraci="True"
        ShowTitleRow="True" TitleText="[%Hodnocení vzdělávacích akcí%]" ControlPanelPosition="TitleRow"
        PovolExport="True" AllowPaging="True">
        <Columns>
            <asp:BoundField DataField="os_cislo" HeaderText="[%Os. číslo%]" SortExpression="os_cislo" />
            <asp:BoundField DataField="jmeno" HeaderText="[%Jméno%]" SortExpression="jmeno" />
            <asp:BoundField DataField="prac_misto" HeaderText="[%Prac. místo%]" SortExpression="prac_misto" />
            <asp:BoundField DataField="divize" HeaderText="[%Divize%]" SortExpression="divize" />
            <asp:BoundField DataField="skup_str" HeaderText="[%Skup. středisek%]" SortExpression="skup_str" />
            <asp:BoundField DataField="str" HeaderText="[%Středisko%]" SortExpression="str" />
            <asp:BoundField DataField="typ_osvedceni" HeaderText="[%Typ vzd. aktivity%]" SortExpression="typ_osvedceni" />
            <asp:BoundField DataField="osvedceni" HeaderText="[%Vzdělávací aktivita%]" SortExpression="osvedceni" />
            <asp:BoundField DataField="dat_od" HeaderText="[%Absolvováno%]" SortExpression="dat_od"
                DataFormatString="{0:d}" />
            <asp:BoundField DataField="akce" HeaderText="[%Název akce%]" SortExpression="akce" />
            <asp:BoundField DataField="splneno" HeaderText="[%Splněno%]" SortExpression="splneno" />
            <asp:BoundField DataField="hodnoceni" HeaderText="[%Splnilo očekávání%]" SortExpression="hodnoceni" />
            <asp:BoundField DataField="doporuceni" HeaderText="[%Doporučení%]" SortExpression="doporuceni" />
        </Columns>
        <PagerTemplate>
            <wc:PagerNavigationBar runat="server" ID="page_nastaveni" />
        </PagerTemplate>
    </wc:TGridView>
        --%>
    <kspwc:TRadGrid ID="TRadGrid_sestava" runat="server" ShowGroupPanel="True" AllowPaging="True" 
                     AllowSorting="true" AutoGenerateColumns="false"
                    AutoFilterControlWidth="false">
        <ClientSettings AllowDragToGroup="True">
        </ClientSettings>
        <GroupingSettings ShowUnGroupButton="true"></GroupingSettings>
        <PagerStyle Mode="NextPrevNumericAndAdvanced"></PagerStyle>
        <ExportSettings HideStructureColumns="true" OpenInNewWindow="true">
        </ExportSettings>
        <MasterTableView CommandItemDisplay="Top">
            <Columns>
                <telerik:GridNumericColumn DataType="System.Decimal" DataField="os_cislo" HeaderText="[%Os. číslo%]" SortExpression="os_cislo" FilterControlWidth="45" />
                <kspwc:GridFotoZamColumn UniqueName="foto" DataOsCisloField="os_cislo"></kspwc:GridFotoZamColumn>
                <telerik:GridBoundColumn DataField="jmeno" HeaderText="[%Jméno%]" SortExpression="jmeno" />
                <telerik:GridBoundColumn DataField="prac_misto" HeaderText="[%Prac. místo%]" SortExpression="prac_misto" />
                <telerik:GridBoundColumn DataField="divize" HeaderText="[%Divize%]" SortExpression="divize" />
                <telerik:GridBoundColumn DataField="skup_str" HeaderText="[%Skup. středisek%]" SortExpression="skup_str" />
                <telerik:GridBoundColumn DataField="str" HeaderText="[%Středisko%]" SortExpression="str" />
                <telerik:GridBoundColumn DataField="typ_osvedceni" HeaderText="[%Typ vzd. aktivity%]" SortExpression="typ_osvedceni" />
                <telerik:GridBoundColumn DataField="osvedceni" HeaderText="[%Vzdělávací aktivita%]" SortExpression="osvedceni" />
                <telerik:GridDateTimeColumn DataField="dat_od" HeaderText="[%Absolvováno%]" SortExpression="dat_od" DataFormatString="{0:d.M.yyyy}" />
                <telerik:GridBoundColumn DataField="akce" HeaderText="[%Název akce%]" SortExpression="akce" />
                <telerik:GridBoundColumn DataField="splneno" HeaderText="[%Splněno%]" SortExpression="splneno" />
                <telerik:GridBoundColumn DataField="hodnoceni" HeaderText="[%Splnilo očekávání%]" SortExpression="hodnoceni" />
                <telerik:GridBoundColumn DataField="doporuceni" HeaderText="[%Doporučení%]" SortExpression="doporuceni" />
                <telerik:GridBoundColumn DataField="otazka_t" HeaderText="[%Hodnotící otázka%]" SortExpression="otazka_t" />
                <telerik:GridNumericColumn DataType="System.Decimal" DataField="hodnoceni_ho" HeaderText="[%Hodnocení%]" SortExpression="hodnoceni_ho" FilterControlWidth="45" />
                <telerik:GridBoundColumn DataField="hodnoceni_ho_text" HeaderText="[%Hodnocení slovně%]" SortExpression="hodnoceni_ho_text" />
                <telerik:GridBoundColumn DataField="poznamka" HeaderText="[%Poznámka%]" SortExpression="poznamka" />
            </Columns>
            <CommandItemTemplate>
                <kspwc:GridCommandItemControl ID="GridCommandItemControl1" runat="server" RebindButton-Enabled="False" RebindButton-Visible="False" >
                </kspwc:GridCommandItemControl> 
            </CommandItemTemplate>
        </MasterTableView>
    </kspwc:TRadGrid>
</asp:Content>
