﻿<%@ Page Language="C#" %>
<%@ Import namespace="System.Net" %>
<%@ Import namespace="System.Net.NetworkInformation" %>
<%@ Import namespace="System.IO" %>
<%@ Import namespace="KSProgram.Funkce" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head id="Head1" runat="server">
    <title>KS portál - ČNB test</title>
</head>
<body>
  <h2><%= "KS portál " + KSProgram.Globals.Verze + " - ČNB test" %></h2>
  
  <% 
  int timeout = (Request.QueryString["timeout"] == null) ? 5000 : int.Parse(Request.QueryString["timeout"]);
  try {
        string proto = (Request.QueryString["proto"] == "http") ? "http" : "https";
        
        string proxyUrl, proxyPort, proxyUsername, proxyPassword;
        proxyUrl = proxyPort = proxyUsername = proxyPassword = null;
        proxyUrl = AppConfiguration.GetAppSetting<string>("proxyUrl", null);
        proxyPort = AppConfiguration.GetAppSetting<string>("proxyPort", null);
        proxyUsername = AppConfiguration.GetAppSetting<string>("proxyUsername", null);
        proxyPassword = AppConfiguration.GetAppSetting<string>("proxyPassword", null);
        WebProxy customProxy = null;
        if (proxyUrl != null || proxyPort != null || proxyUsername != null || proxyPassword != null)
        {
            int pPort;
            if (!string.IsNullOrEmpty(proxyPort))
            {
                if (!string.IsNullOrEmpty(proxyUrl) && int.TryParse(proxyPort, out pPort))
                {
                    customProxy = new WebProxy(proxyUrl + ":" + proxyPort);
                    if (!string.IsNullOrEmpty(proxyUsername) && !string.IsNullOrEmpty(proxyPassword))
                        customProxy.Credentials = new NetworkCredential(proxyUsername, proxyPassword);
                }
            }
        }
        Response.Write("<p>");
        Response.Write("Parametry: <br/>");
        Response.Write("Protokol: " + proto.ToUpper() + "<br/>");
        Response.Write("Timeout: " + timeout + "<br/>");
        if (customProxy != null) 
           Response.Write("Proxy: " + proxyUrl + ":" + proxyPort + "<br/>");
        else
           Response.Write("Proxy: NE <br/>");
        Response.Write("</p>");

        string url = proto + "://www.cnb.cz/cs/financni_trhy/devizovy_trh/kurzy_devizoveho_trhu/denni_kurz.txt?date=" + (DateTime.Today.Day - 1) + "." + DateTime.Today.Month + "." + DateTime.Today.Year;
    
        ServicePointManager.SecurityProtocol = SecurityProtocolType.Tls12;
        WebRequest req = WebRequest.Create(url);
        if (customProxy != null)
            req.Proxy = customProxy;
        req.Timeout = timeout;
        Response.Write(DateTime.Now.ToString("hh:mm:ss.fff") + ": GET "+ url + "<br/>");
        WebResponse response = req.GetResponse();
        StreamReader stream = new StreamReader(response.GetResponseStream());
        Response.Write(DateTime.Now.ToString("hh:mm:ss.fff") + ": OUTPUT:<br/><PRE>" + stream.ReadToEnd() + "</PRE>");
    }
    catch (Exception exc)
    {
        Response.Write(DateTime.Now.ToString("hh:mm:ss.fff") + ": Chyba: " + exc.GetType() + " " + exc.Message);
    }
    try
    {
        Ping ping = new Ping();
        Response.Write("<br/>" + DateTime.Now.ToString("hh:mm:ss.fff") + ": PING www.cnb.cz<br/>");
        PingReply pingReply = ping.Send("www.cnb.cz", timeout);
        if (pingReply.Status == IPStatus.Success)
            Response.Write(DateTime.Now.ToString("hh:mm:ss.fff") + ": OK<br/>");
        else
            Response.Write(DateTime.Now.ToString("hh:mm:ss.fff") + ": fail<br/>");
    }
    catch (Exception exc)
    {
        Response.Write(DateTime.Now.ToString("hh:mm:ss.fff") + ": Chyba: " + exc.GetType() + " " + exc.Message);
    }
  %>
</body>
</html>
