﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Main.Master" AutoEventWireup="true" CodeBehind="Metrika.aspx.cs" Inherits="KSPortal.Obecne.Metrika" %>

<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>

<asp:Content ID="Content1" ContentPlaceHolderID="HeadContent" runat="server">
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="HlavniOblast" runat="server">
    <telerik:RadCodeBlock ID="RadCodeBlock1" runat="server">
        <style>
            .contentWrapper {
                padding-top: 10px;
            }
            .panelG{
                margin-top:20px;
                text-align:center;
            }
            .tab_rekap_h{
                text-align:right;
                background-color:#E5E5E5; 
                border-color:#CDCDCD;
                border-width:1px;
                border-style:Solid; 
                width:130px;                
            }
            .tab_rekap_d{
                text-align:right;
                background-color:white; 
                border-color:#CDCDCD;
                border-width:1px;
                border-style:Solid; 
                width:70px;             
            }
            .tab_rekap{
                margin-left:40px;
                border-collapse:collapse;
                border-color:#CDCDCD;
                border-width:1px;
                border-style:Solid;
            }
        </style>
        <script type="text/javascript">
            //<![CDATA[
            var startTime;
            var DT;
            function getLatency() {
                var startTime;
                $.ajax({
                    type: "POST",
                    url: "Metrika.aspx/Latence",
                    data: "{data:''}",
                    async: false,
                    contentType: "application/json",
                    dataType: "json",
                    beforeSend: function () {
                        startTime = new Date();
                    },
                    error: function (xhr, ajaxOptions, thrownError) {
                        alert(xhr.status);
                        alert(xhr.responseText);
                        alert(thrownError);
                    },
                    complete: function (jqXHR, textStatus) {
                        var data = (new Date()) - startTime;
                        DT = data;
                        //alert("vysl:"+data);
                    }
                });
            }
            function LatencyTest() {
                var pocet = 10;
                var radialGauge = $find("<%=RadRadialGauge1.ClientID %>");
                var radialGauge2 = $find("<%=RadRadialGauge2.ClientID %>"); 
               
                var min = -1;
                var max = -1;
                var pom = 0;
                var celk = 0;
                for (var i = 0; i < pocet; i++) {
                    getLatency();
                    pom = parseInt(DT);
                    if (min>pom||min==-1)min=pom;
                    if (max<pom||max==-1)max=pom;
                    celk +=pom;                    
                }
                var prum=(celk / pocet).toFixed(1);
                setPointerValue(radialGauge, min, 0);
                setPointerValue(radialGauge, max, 1);
                setPointerValue(radialGauge, prum, 2);
                
                document.getElementById('<%=lab_min.ClientID%>').textContent = min+" ms";
                document.getElementById('<%=lab_max.ClientID%>').textContent = max+" ms";
                document.getElementById('<%=lab_prum.ClientID%>').textContent = prum+" ms";
              
                measureBW(10, function (e) {
                    //alert(e);
                    var pom = (e / 1024).toFixed(1);
                    setPointerValue(radialGauge2, pom, 0);
                    document.getElementById('<%=lab_prum_r.ClientID%>').textContent = pom + " Mbits";                    
                });                

            }
        function setPointerValue(gaugeControl, value, pointerIndex) {
            gaugeControl.getGauge().pointers[pointerIndex].value(value);
        }
        //velikost souboru test_stahovani.bmp je 238 KB
        function measureBW(cnt, cb) {
            var start = new Date().getTime();
            var bandwidth;
            var i = 0;
            (function rec() {
                var xmlHttp = new XMLHttpRequest();
                xmlHttp.open('GET', "<%=this.ResolveUrl(@"~/images/test_stahovani.png")%>" +'?rand =' + Math.random(), true);
               

                xmlHttp.onreadystatechange = function () {
                    if (xmlHttp.readyState == 4) {
                        var x = new Date().getTime() - start;
                        bw = Number(((238 / (x / 1000))));
                        bandwidth = ((bandwidth || bw) + bw) / 2;
                        i++;
                        if (i < cnt) {
                            start = new Date().getTime(); rec();
                        }
                        else cb(bandwidth.toFixed(0));
                    }
                };
                xmlHttp.send(null);
            })();
        }
        //]]>
        </script>
    </telerik:RadCodeBlock>
    <telerik:RadAjaxManagerProxy ID="RadAjaxManagerProxy1" runat="server">
        <AjaxSettings>
            <telerik:AjaxSetting AjaxControlID="lb_jazyky">
                <UpdatedControls>
                    <telerik:AjaxUpdatedControl ControlID="Grid1" />
                </UpdatedControls>
            </telerik:AjaxSetting>
            <telerik:AjaxSetting AjaxControlID="Grid1">
                <UpdatedControls>
                    <telerik:AjaxUpdatedControl ControlID="Grid1" />
                </UpdatedControls>
            </telerik:AjaxSetting>
        </AjaxSettings>
    </telerik:RadAjaxManagerProxy>
    <telerik:RadTabStrip  runat="server"
        ID="RadTabStrip1"
        AutoPostBack="true"
        MultiPageID="RadMultiPage1"
        SelectedIndex="0">
        <Tabs>
            <telerik:RadTab Text="[%Rychlost%]"></telerik:RadTab>
            <telerik:RadTab Text="[%Kontrola knihoven%]"></telerik:RadTab>
        </Tabs>
    </telerik:RadTabStrip>
    <telerik:RadMultiPage runat="server" ID="RadMultiPage1" SelectedIndex="0" CssClass="ksprvek marginBottom">
        <telerik:RadPageView runat="server" Height="460px" ID="RadPageView1">
            <div class="contentWrapper">
               <kspwc:TRadButton ID="btnPrimary" runat="server" AutoPostBack="false" Width="250" OnClientClicked="LatencyTest"  Text="[%Spustit test%]" Icon-PrimaryIconCssClass="fi fi fi-tachometer-fast"></kspwc:TRadButton>
                <div  style="float:left;" class="panelG">
                    <asp:Label ID="Label2" runat="server" Text="[%Latence%]" CssClass="nadpis1"></asp:Label>
                    <telerik:RadRadialGauge runat="server" ID="RadRadialGauge1" Width="300px" Height="300px">                       
                        <Pointers>
                            <telerik:RadialPointer Value="0" Color="#9fe8ef"></telerik:RadialPointer>
                            <telerik:RadialPointer Value="0" Color="#9fe8ef"></telerik:RadialPointer>
                            <telerik:RadialPointer Value="0" Cap-Size="0.1" Color="#1b8892"></telerik:RadialPointer>
                        </Pointers>
                        <Scale Min="0" Max="30" MajorUnit="5">
                            <Labels Format="{0} ms" />
                            <Ranges>
                                <telerik:GaugeRange Color="#8dcb2a" From="0" To="10" />
                                <telerik:GaugeRange Color="#ffc700" From="10" To="15" />
                                <telerik:GaugeRange Color="#ff7a00" From="15" To="20" />
                                <telerik:GaugeRange Color="#c20000" From="20" To="30" />
                            </Ranges>
                        </Scale>
                    </telerik:RadRadialGauge>
                    <table class="tab_rekap">
                        <tr>
                            <td  class="tab_rekap_h"><asp:Label runat="server" ID="lab_m" Text="[%Minimální%]:" ></asp:Label></td>
                             <td class="tab_rekap_d"><asp:Label runat="server" ID="lab_min" Text=""></asp:Label></td>                            
                        </tr>
                        <tr>
                            <td class="tab_rekap_h"><asp:Label runat="server" ID="Label3" Text="[%Maximální%]:" ></asp:Label></td>
                             <td class="tab_rekap_d"><asp:Label runat="server" ID="lab_max" Text=""></asp:Label></td>                            
                        </tr>
                        <tr>
                            <td class="tab_rekap_h"><asp:Label runat="server" ID="Label5" Text="[%Průměr%]:" ></asp:Label></td>
                            <td class="tab_rekap_d"><asp:Label runat="server" ID="lab_prum" Text=""></asp:Label></td>                            
                        </tr>
                    </table>
                </div>
                <div  style="float:right;" class="panelG">
                    <asp:Label ID="Label1" runat="server" Text="[%Rychlost%]" CssClass="nadpis1"></asp:Label>
                    <telerik:RadRadialGauge runat="server" ID="RadRadialGauge2" Width="300px" Height="300px">                      
                        <Pointers>                           
                            <telerik:RadialPointer Value="0" Cap-Size="0.1" Color="#1b8892"></telerik:RadialPointer>
                        </Pointers>
                        <Scale Min="0" Max="40" MajorUnit="10">
                            <Labels Format="{0} Mbits" />
                            <Ranges>
                                <telerik:GaugeRange Color="#c20000" From="0" To="4" />
                                <telerik:GaugeRange Color="#ff7a00" From="4" To="8" />
                                <telerik:GaugeRange Color="#ffc700" From="8" To="15" />
                                <telerik:GaugeRange Color="#8dcb2a" From="15" To="40" />
                            </Ranges>
                        </Scale>
                    </telerik:RadRadialGauge>
                    <table class="tab_rekap">
                        <tr>
                            <td class="tab_rekap_h"><asp:Label runat="server" ID="Label4" Text="[%Průměr z deseti pokusů%]:" ></asp:Label></td>
                             <td class="tab_rekap_d"><asp:Label runat="server" ID="lab_prum_r" Text=""></asp:Label></td>                            
                        </tr>                        
                    </table>
                </div>
            </div>
        </telerik:RadPageView>
        <telerik:RadPageView runat="server" ID="RadPageView2">
            <div class="contentWrapper">
                <kspwc:TRadGrid runat="server" ID="Grid1" CaptionVisible="false" OnNeedDataSource="Grid1_NeedDataSource" OnItemDataBound="Grid1_ItemDataBound" AllowSorting="true" AllowPaging="false">
                    <MasterTableView AutoGenerateColumns="false" CommandItemDisplay="Top">
                        <RowIndicatorColumn Visible="False">
                        </RowIndicatorColumn>
                        <Columns>
                            <telerik:GridBoundColumn DataField="nazev" SortExpression="nazev" HeaderText="[%Název%]" UniqueName="nazev_id" FilterControlAltText="Filter nazev_id column">
                            </telerik:GridBoundColumn>
                            <telerik:GridBoundColumn DataField="verze" SortExpression="verze" HeaderText="[%Verze%]" UniqueName="verze_id" FilterControlAltText="Filter verze_id column">
                            </telerik:GridBoundColumn>
                            <telerik:GridBoundColumn DataField="culture" SortExpression="culture" HeaderText="Culture" UniqueName="culture_id" FilterControlAltText="Filter culture_id column">
                            </telerik:GridBoundColumn>
                            <telerik:GridBoundColumn DataField="publicKeyToken" SortExpression="publicKeyToken" HeaderText="Public Key Token" UniqueName="publicKeyToken_id" FilterControlAltText="Filter publicKeyToken_id column">
                            </telerik:GridBoundColumn>
                            <telerik:GridTemplateColumn UniqueName="distribuce_id" Visible="false" DataField="distribuce" SortExpression="distribuce" HeaderText="[%Distribuce%]">
                                <ItemTemplate>
                                    <asp:Image ID="Image_d" runat="server" />
                                </ItemTemplate>
                                <ItemStyle HorizontalAlign="Center" />
                            </telerik:GridTemplateColumn>
                            <telerik:GridTemplateColumn UniqueName="skutecnost_id" Visible="false" DataField="skutecnost" SortExpression="skutecnost" HeaderText="[%Skutečnost%]">
                                <ItemTemplate>
                                    <asp:Image ID="Image_s" runat="server" />
                                </ItemTemplate>
                                <ItemStyle HorizontalAlign="Center" />
                            </telerik:GridTemplateColumn>
                            <telerik:GridTemplateColumn UniqueName="porovnani_id" Visible="false" DataField="porovnani" SortExpression="porovnani" HeaderText="[%Porovnání%]">
                                <ItemTemplate>
                                    <asp:Image ID="Image_p" runat="server" />
                                </ItemTemplate>
                                <ItemStyle HorizontalAlign="Center" />
                            </telerik:GridTemplateColumn>
                            <telerik:GridRowIndicatorColumn></telerik:GridRowIndicatorColumn>
                        </Columns>
                         <CommandItemTemplate>
                            <kspwc:GridCommandItemControl ID="GridCommandItemControl1" runat="server">
                                <ExportButton ID="ExportButton1" runat="server" ShowExportToExcelHtmlItem="false" ShowExportToExcelBIFFItem="true"/>          
                            </kspwc:GridCommandItemControl>
                        </CommandItemTemplate>
                    </MasterTableView>
                </kspwc:TRadGrid>
            </div>
        </telerik:RadPageView>
    </telerik:RadMultiPage>
</asp:Content>

