﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Main.Master" AutoEventWireup="true" CodeBehind="HodnoceniPrenosMzdyResidomo.aspx.cs" Inherits="KSPortal.Pis.HodnoceniPrenosMzdyResidomo" %>

<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>
<asp:Content ID="Content1" ContentPlaceHolderID="HeadContent" runat="server">
    <style type="text/css">
        .thisRg .rgFilterRow .rgFilterBox, .thisRg .rgFilterRow .riSingle {
            width: calc(100% - 21px) !important;
        }

        td.thisEditColl > div > span {
            width: 100% !important;
        }

        .akceCombo {
            padding: 2px 2px 0px 2px;
        }
    </style>
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="HlavniOblast" runat="server">

    <kspwc:TLabel runat="server" ID="ConfirmText" CssClass="hidden" Text="[%V tabulce jsou neuložené změny, které budou touto akcí ztraceny. Chcete opravdu provézt akci a zahodit změny?%]"></kspwc:TLabel>

    <label class="nadpis1">[%Přenos do mezd%]</label>

    <telerik:RadAjaxManagerProxy ID="RadAjaxManagerProxy1" runat="server">
        <AjaxSettings>
            <telerik:AjaxSetting AjaxControlID="TRG_prenos">
                <UpdatedControls>
                    <telerik:AjaxUpdatedControl ControlID="TRG_prenos" />
                </UpdatedControls>
            </telerik:AjaxSetting>
        </AjaxSettings>
    </telerik:RadAjaxManagerProxy>

    <telerik:RadPersistenceManagerProxy ID="RadPersistenceManagerProxy1" runat="server">
    </telerik:RadPersistenceManagerProxy>

    <kspwc:TRadGrid runat="server" ID="TRG_prenos" ClientDataSourceID="RCDS_Prenos" AutoMasterGridWidth="True" ShowGroupPanel="True" AllowPaging="True" AllowSorting="True" AutoFilterWidth="True" CssClass="thisRg" onkeydown="handleEnterKey(this, event);" IdPravaEditace="290">
        <GroupingSettings CaseSensitive="False" CollapseAllTooltip="Collapse all groups" ShowUnGroupButton="True"></GroupingSettings>
        <ClientSettings AllowDragToGroup="True">
            <ClientEvents OnDataBound="TRG_prenos_DataBound" OnUserAction="UserAction" OnGridCreated="grid_OnGridCreateHandler" OnDataBinding="grid_OnDataBinding" />
            <Resizing AllowColumnResize="true" AllowResizeToFit="true" />
        </ClientSettings>
        <MasterTableView CommandItemDisplay="Top" DataKeyNames="id" ClientDataKeyNames="id" EditMode="Batch" ShowFooter="true" EnableGroupsExpandAll="true" ShowGroupFooter="true" AllowFilteringByColumn="true">
            <BatchEditingSettings OpenEditingEvent="MouseOver" EditType="Row" />
            <CommandItemTemplate>
                <kspwc:GridCommandItemControl runat="server" ID="GCIC_prenos">
                    <RebindButton runat="server" AutoPostBack="false" OnClientClicked="OnRebindButton"></RebindButton>
                    <FilterButton runat="server" AutoPostBack="false" OnClientCheckedChanged="showHideFilter" Checked="true"></FilterButton>
                    <SaveButton runat="server" Visible="true"></SaveButton>
                    <ExportButton runat="server" OnExporting="Unnamed_Exporting" />
                    <ContentTemplate>
                        <kspwc:TRadComboBox runat="server" ID="TRCB_akce" DropDownAutoWidth="Enabled" DataSourceID="odsAkce" DataTextField="nazev" DataValueField="id" CssClass="akceCombo" OnClientSelectedIndexChanging="TRCB_akce_ClientSelectedIndexChanging" OnClientSelectedIndexChanged="TRCB_akce_ClientSelectedIndexChanged">
                        </kspwc:TRadComboBox>
                    </ContentTemplate>
                </kspwc:GridCommandItemControl>
            </CommandItemTemplate>
            <Columns>
                <telerik:GridNumericColumn HeaderText="[%Os. číslo%]" ReadOnly="True" DataField="os_cislo" DataType="System.Decimal" UniqueName="os_cislo"></telerik:GridNumericColumn>
                <telerik:GridNumericColumn HeaderText="[%Číslo pom.%]" ReadOnly="True" DataField="cislo_pom" DataType="System.Int16" UniqueName="cislo_pom"></telerik:GridNumericColumn>
                <telerik:GridBoundColumn HeaderText="[%Příjmení%]" ReadOnly="True" DataField="prijmeni" UniqueName="prijmeni"></telerik:GridBoundColumn>
                <telerik:GridBoundColumn HeaderText="[%Jméno%]" ReadOnly="True" DataField="jmeno" UniqueName="jmeno"></telerik:GridBoundColumn>
                <telerik:GridBoundColumn HeaderText="[%Kmen. stř.%]" ReadOnly="True" DataField="stredisko" UniqueName="stredisko"></telerik:GridBoundColumn>
                <telerik:GridBoundColumn HeaderText="[%Prac. stř.%]" ReadOnly="True" DataField="prac_str" UniqueName="prac_str"></telerik:GridBoundColumn>
                <telerik:GridBoundColumn HeaderText="[%Pracovní místo%]" ReadOnly="True" DataField="prac_misto" UniqueName="prac_misto"></telerik:GridBoundColumn>
                <telerik:GridNumericColumn HeaderText="[%Nárok%]" ReadOnly="True" DataField="narok" DataType="System.Decimal" UniqueName="narok" DecimalDigits="2" DataFormatString="{0:n2}" Aggregate="Sum" FooterAggregateFormatString="{0:n2}"></telerik:GridNumericColumn>
                <telerik:GridNumericColumn HeaderText="[%Vypočtená odměna%]" ReadOnly="True" DataField="vcastka" DataType="System.Decimal" UniqueName="vcastka" DecimalDigits="2" DataFormatString="{0:n2}"></telerik:GridNumericColumn>
                <telerik:GridNumericColumn HeaderText="[%Částka k editaci%]" ReadOnly="false" DataField="castka" DataType="System.Decimal" UniqueName="castka" MinValue="0" DataFormatString="{0:n2}" MaxValue="9999999999" MaxLength="10" DecimalDigits="2" Aggregate="Sum" FooterAggregateFormatString="{0:n2}">
                    <ItemStyle CssClass="thisEditColl" />
                </telerik:GridNumericColumn>
                <%--<telerik:GridTemplateColumn HeaderText="[%Částka k editaci%]" ReadOnly="false" DataField="castka" DataType="System.Decimal" UniqueName="castka">
                    <ClientItemTemplate>
                        <span id="span_hod_vyznam">#= kendo.toString(castka, "n2") #</span>
                    </ClientItemTemplate>
                    <EditItemTemplate>
                        <telerik:RadNumericTextBox runat="server" ID="RNTB_castka"></telerik:RadNumericTextBox>
                    </EditItemTemplate>
                </telerik:GridTemplateColumn>--%>
                <telerik:GridCalculatedColumn HeaderText="[%Do mezd%]" DataFields="koeficient_h2m,castka" Expression="(({0} == null) ? 0 : {0} ) * (({1} == null) ? 0 : {1})" DataType="System.Decimal" UniqueName="prepocet_koeficient_h2m"></telerik:GridCalculatedColumn>
                <telerik:GridDateTimeColumn HeaderText="[%Obdobi%]" ReadOnly="True" DataField="obdobi" DataType="System.Decimal" UniqueName="obdobi" DataFormatString="{0:MMMM yyyy}"></telerik:GridDateTimeColumn>
                <telerik:GridDateTimeColumn HeaderText="[%Datum%]" ReadOnly="True" DataField="datum" DataType="System.Decimal" UniqueName="datum" DataFormatString="{0:d.M.yyyy}"></telerik:GridDateTimeColumn>
            </Columns>
        </MasterTableView>
    </kspwc:TRadGrid>

    <asp:ObjectDataSource ID="odsAkce" runat="server" OldValuesParameterFormatString="original_{0}"
        SelectMethod="SeznamAkce" TypeName="KSProgram.Hodnoceni.PrenosMzdy"></asp:ObjectDataSource>

    <telerik:RadClientDataSource ID="RCDS_Prenos" runat="server" AllowBatchOperations="true">
        <ClientEvents OnCustomParameter="ParameterMap" OnDataParse="Parse" />
        <DataSource>
            <WebServiceDataSourceSettings BaseUrl="../Pis/HodnoceniPrenosMzdyResidomo.aspx/">
                <Select Url="GetHzH2M" DataType="JSON" RequestType="Post" ContentType="application/json; charset=utf-8" />
                <Update Url="UpdateHzH2M" DataType="JSON" RequestType="Post" ContentType="application/json; charset=utf-8" />
            </WebServiceDataSourceSettings>
        </DataSource>
        <Schema>
            <Model ID="id">
                <telerik:ClientDataSourceModelField FieldName="id" DataType="Number" Nullable="False" />
                <telerik:ClientDataSourceModelField FieldName="idh" DataType="Number" Nullable="False" />
                <telerik:ClientDataSourceModelField FieldName="id_ha" DataType="Number" Nullable="False" />
                <telerik:ClientDataSourceModelField FieldName="os_cislo" DataType="Number" Nullable="False" />
                <telerik:ClientDataSourceModelField FieldName="prijmeni" DataType="String" Nullable="False" />
                <telerik:ClientDataSourceModelField FieldName="jmeno" DataType="String" />
                <telerik:ClientDataSourceModelField FieldName="cislo_pom" DataType="Number" Nullable="False" />
                <telerik:ClientDataSourceModelField FieldName="stredisko" DataType="String" />
                <telerik:ClientDataSourceModelField FieldName="prac_str" DataType="String" />
                <telerik:ClientDataSourceModelField FieldName="id_pracmist" DataType="Number" />
                <telerik:ClientDataSourceModelField FieldName="cis_pracmist" DataType="String" />
                <telerik:ClientDataSourceModelField FieldName="naz_pracmist" DataType="String" />
                <telerik:ClientDataSourceModelField FieldName="prac_misto" DataType="String" />
                <telerik:ClientDataSourceModelField FieldName="kod" DataType="Number" />
                <telerik:ClientDataSourceModelField FieldName="typ" DataType="Number" Nullable="False" />
                <telerik:ClientDataSourceModelField FieldName="vkoeficient" DataType="Number" Nullable="False" />
                <telerik:ClientDataSourceModelField FieldName="koeficient" DataType="Number" />
                <telerik:ClientDataSourceModelField FieldName="koeficient_h2m" DataType="Number" />
                <telerik:ClientDataSourceModelField FieldName="narok" DataType="Number" />
                <telerik:ClientDataSourceModelField FieldName="vcastka" DataType="Number" Nullable="False" />
                <telerik:ClientDataSourceModelField FieldName="castka" DataType="Number" />
                <telerik:ClientDataSourceModelField FieldName="prepocet_koeficient_h2m" DataType="Number" />
                <telerik:ClientDataSourceModelField FieldName="obdobi" DataType="Date" />
                <telerik:ClientDataSourceModelField FieldName="datum" DataType="Date" />
            </Model>
        </Schema>
    </telerik:RadClientDataSource>
    <telerik:RadCodeBlock ID="RadCodeBlock2" runat="server">
        <script type="text/javascript">
            //<![CDATA[
            function OnRebindButton(sender, args) {
                var gridv = $find("<%=TRG_prenos.ClientID %>").get_masterTableView();
                if (confirmDoingAction()) {
                    gridv.rebind();
                }
            }

            function ParameterMap(sender, args) {
                if (args.get_type() == "read") {
                    var grid = $find("<%=TRG_prenos.ClientID %>");
                    var TRCB_akce = $telerik.findControl(grid.get_element(), "TRCB_akce");

                    args.set_parameterFormat("{ 'id': " + TRCB_akce.get_selectedItem().get_value() + " }");
                }
                if (args.get_type() != "read" && args.get_data()) {
                    args.set_parameterFormat("{ 'items': " + kendo.stringify(args.get_data().models) + " }");
                }
            }

            function Parse(sender, args) {
                var response = args.get_response().d;
                if (response) {
                    args.set_parsedData(response.Data);
                }
            }

            function TRG_prenos_DataBound(sender, args) {
                resizeHodnoceniSkoleniColumns();
            }

            function resizeHodnoceniSkoleniColumns() {
                var grid = $find('<%= TRG_prenos.ClientID %>');
                var columns = grid.get_masterTableView().get_columns();
                for (var i = 0; i < columns.length; i++) {
                    grid.get_masterTableView().resizeColumn(i, 0);
                    //if ("Vyznam" == columns[i].get_uniqueName()) {
                    //    grid.get_masterTableView().resizeColumn(i, 150);
                    //}
                    //else {
                    columns[i].resizeToFit(false, true);
                    //}
                }
                grid.repaint();
            }

            function TRCB_akce_ClientSelectedIndexChanging(sender, args) {
                if (!confirmDoingAction()) {
                    args.set_cancel(true);
                }
            }
            function TRCB_akce_ClientSelectedIndexChanged(sender, args) {
                var gridv = $find("<%=TRG_prenos.ClientID %>").get_masterTableView();
                gridv.rebind();
            }

            function handleEnterKey(element, ev) {
                if (ev.keyCode == 13) {
                    preventEvent(ev);
                    var grid = $find(element.id);
                    var batchManager = grid.get_batchEditingManager();
                    var tableView = grid.get_masterTableView();
                    batchManager._tryCloseEdits(tableView);
                    setTimeout(function () {
                        batchManager.saveChanges(grid.get_masterTableView());
                    })
                }
            }

            function preventEvent(e) {
                var evt = e ? e : window.event;
                if (evt.stopPropagation) evt.stopPropagation();
                if (evt.preventDefault) evt.preventDefault();
                if (evt.cancelBubble != null) evt.cancelBubble = true;
                if (evt.stopImmediatePropagation) evt.stopImmediatePropagation();
                evt.returnValue = false;
            }

            function UserAction(sender, args) {
                var label = $get("<%=ConfirmText.ClientID %>");
                if (!confirmDoingAction()) {
                    args.set_cancel(true);
                }
            }
            function confirmDoingAction() {
                var grid = $find("<%=TRG_prenos.ClientID %>");
                var gridv = grid.get_masterTableView();
                var label = $get("<%=ConfirmText.ClientID %>");
                if (grid.get_batchEditingManager().hasChanges(gridv) &&
                    !confirm(label.innerText)) {
                    return false;
                }
                else {
                    return true;
                }
            }

            //*************************************************** zde začíná persistance frameWork
            
            function grid_OnGridCreateHandler(sender, args) {
                sender.add_command(grid_OnCommandHandler);
                //sender.add_dataBinding(grid_OnDataBinding);

                loadGridState(sender);
            }

            function CancelEventHandler(sender, args) {//handler zastaví event způsobený načítáním uloženého nastavení gridu
                args.set_cancel(true);
            }

            function grid_OnDataBinding(sender, args) {//
                var a = 1;
            }

            function grid_OnCommandHandler(sender, args) {
                var table = sender.get_masterTableView();
                var com = args.get_commandName();
                if (com == "PageSize") {
                    saveGridState(sender);
                    //args.set_cancel(true);
                }
                if (com == "Filter" || com == "Sort") {
                    saveGridState(sender);
                }
            }

            function showHideFilter(sender, args) {
                var grid = $find("<%=TRG_prenos.ClientID %>");
                var gridv = grid.get_masterTableView();
                if (args.get_checked()) {
                    gridv.showFilterItem();
                }
                else {
                    gridv.hideFilterItem();
                    gridv.get_filterExpressions().clear();//smazání filtrů

                    var columns = gridv.get_columns();//smazání filter textboxů
                    for (var i = 0; i < columns.length; i++) {
                        gridv._updateFilterControlValue("", columns[i].get_uniqueName(), "");
                    }

                    saveGridState(grid);
                    gridv.rebind();

                }
            }

            function getGridState() {
                var stateStr = KSMaster.HF_TRadGridStateHolder.value;
                if (stateStr) {
                    try {
                        return $telerik.$.parseJSON(stateStr);
                    }
                    catch (e) { }
                }
                return null;
            }

            var saveGridStateTimeOut;
            function saveGridState(grids) { // metoda uloží 
                var states = getGridState();
                states = states ? states : [];
                for (var gridi = 0; gridi < arguments.length; gridi++) {
                    var grid = arguments[gridi];
                    var table = grid.get_masterTableView();

                    var stateIndex = -1;
                    $.each(states, function (i, val) {
                        if (val.ID == grid.ClientID) {
                            stateIndex = i;
                            return;
                        }
                    });

                    var collvisible = {};
                    var collorder = [];
                    var columns = table.get_columns();
                    for (var i = 0; i < columns.length; i++) {
                        collvisible[columns[i].get_uniqueName()] = columns[i].get_visible();
                        collorder.push(columns[i].get_uniqueName());
                    }
                    
                    gridState =
                        {
                            ID: grid.ClientID,
                            ColumnVisible: collvisible,
                            ColumnOrder: collorder,
                            PageSize: table.get_pageSize(),
                            //PageIndex: table.get_pageIndex(),
                            CurrentPageIndex: table.get_currentPageIndex(),
                            FilterExpression: table._filterExpressions,
                            SortExpression: table.get_sortExpressions()
                        }

                    if (stateIndex == -1)
                        states.push(gridState);
                    else
                        states[stateIndex] = gridState;
                }
                var json = kendo.stringify(states);

                if (KSMaster.HF_TRadGridStateHolder) {
                    KSMaster.HF_TRadGridStateHolder.value = json;
                }
                if (saveGridStateTimeOut)
                    clearTimeout(saveGridStateTimeOut);
                saveGridStateTimeOut = setTimeout(function () { PageMethods.SaveTRadGridClientSetting(json); }, 500);
            }

            gridStateLoading = false;

            function loadGridState(grids) {
                gridStateLoading = true;
                var states = getGridState();
                if (states) {
                    for (var gridi = 0; gridi < arguments.length; gridi++) {
                        var grid = arguments[gridi];
                        for (var statei = 0; statei < states.length; statei++) {
                            var gridState = states[statei];
                            if (grid.ClientID == gridState.ID) {
                                var table = grid.get_masterTableView();
                                var cols = table.get_columns();

                                // pořadí sloupců
                                if (gridState && gridState.ColumnOrder) {
                                    grid.add_columnSwapping(CancelEventHandler);
                                    for (var i in gridState.ColumnOrder) {
                                        var from = gridState.ColumnOrder[i];
                                        var to = cols[i].get_uniqueName();
                                        if (from != to) {
                                            tableView.reorderColumns(from, to);
                                            cols = tableView.get_columns();
                                        }
                                    }
                                    grid.remove_columnSwapping(CancelEventHandler);
                                }

                                //viditelnost sloupců
                                if (gridState && gridState.ColumnVisible) {
                                    for (var key in gridState.ColumnVisible) {
                                        if (gridState.ColumnVisible.hasOwnProperty(key)) {
                                            var colum = table.getColumnByUniqueName(key);
                                            if (colum) {
                                                var index = 0;
                                                for (var i = 0; i < cols.length; i++) {
                                                    if (cols[i].get_uniqueName() == key) {
                                                        index = i;
                                                    }
                                                }

                                                if (colum.get_visible() != gridState.ColumnVisible[key]) {
                                                    if (gridState.ColumnVisible[key]) {
                                                        grid.add_columnShowing(CancelEventHandler);
                                                        table.showColumn(index);
                                                        grid.remove_columnShowing(CancelEventHandler);
                                                    }
                                                    else {
                                                        grid.add_columnHiding(CancelEventHandler);
                                                        table.hideColumn(index);
                                                        grid.remove_columnHiding(CancelEventHandler);
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }

                                if (gridState && gridState.FilterExpression) {
                                    grid.remove_command(grid_OnCommandHandler);
                                    for (var i in gridState.FilterExpression._array) {
                                        var fexpr = gridState.FilterExpression._array[i];
                                        addGridFilterExpression(grid, fexpr.ColumnUniqueName, fexpr.FieldName, fexpr.FilterFunction, fexpr.DataTypeName, fexpr.FieldValue);
                                    }
                                    grid.add_command(grid_OnCommandHandler);
                                }

                                if (gridState && gridState.SortExpression) {
                                    grid.remove_command(grid_OnCommandHandler);
                                    for (var i in gridState.SortExpression._array) {
                                        var sortexpr = gridState.SortExpression._array[i];
                                        addGridSortExpression(grid, sortexpr.FieldName, sortexpr.SortOrder);
                                    }
                                    grid.add_command(grid_OnCommandHandler);
                                }

                                //velikost stránky
                                if (gridState && gridState.PageSize && table.get_pageSize() != gridState.PageSize) {
                                    grid.remove_command(grid_OnCommandHandler); 
                                    grid.add_command(CancelEventHandler);
                                    table.set_pageSize(gridState.PageSize);
                                    grid.remove_command(CancelEventHandler);
                                    grid.add_command(grid_OnCommandHandler);
                                }

                                //page index
                                if (gridState && gridState.PageIndex && table.get_pageIndex() != gridState.PageIndex) {
                                    table.set_pageIndex(gridState.PageIndex);
                                }
                            }
                        }
                    }
                }
                gridStateLoading = false;
            }

            function addGridFilterExpression(grid, columnUniqueName, dataField, filterFunction, filterDataType, filterValue) {
                var filterExpression = new Telerik.Web.UI.GridFilterExpression();
                var founded = 0;
                var foundExp = $.grep(grid.get_masterTableView()._filterExpressions._array, function (e) { return e.FieldName == dataField; });
                founded = foundExp.length;
                if (founded != 0) {
                    filterExpression = foundExp[0];
                }

                var column = grid.get_masterTableView().getColumnByUniqueName(columnUniqueName);
                if (column != null)
                    column.set_filterFunction("Contains");
                filterExpression.set_fieldName(dataField);
                filterExpression.set_fieldValue(filterValue);
                filterExpression.set_dataTypeName(filterDataType);
                filterExpression.set_filterFunction(filterFunction);
                filterExpression.set_columnUniqueName(columnUniqueName);
                if (column != null) {
                    grid.get_masterTableView()._updateFilterControlValue(filterValue, columnUniqueName, filterFunction);
                }
                if (founded == 0) {
                    grid.get_masterTableView()._filterExpressions.add(filterExpression);
                }
            }

            function addGridSortExpression(grid, fieldName, sortOrder) {
                var sortExpression = new Telerik.Web.UI.GridSortExpression();
                sortExpression.set_fieldName(fieldName);
                sortExpression.set_sortOrder(sortOrder);
                grid.get_masterTableView()._sortExpressions.add(sortExpression);
                grid.get_masterTableView()._showSortIconForField(fieldName, sortOrder);
            }

            //]]>
        </script>
    </telerik:RadCodeBlock>
</asp:Content>
