﻿<%@ Page Language="C#" AutoEventWireup="true" MasterPageFile="~/Main.Master" CodeBehind="OdmenyPoznamka.aspx.cs" Inherits="KSPortal.Pozadavky.OdmenyPoznamka" %>
<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>

<asp:Content ID="Content1" ContentPlaceHolderID="HeadContent" runat="server">
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="HlavniOblast" runat="server">

    <telerik:RadCodeBlock ID="RadCodeBlock1" runat="server">
        <script type="text/javascript">
            var co = "";
            var kod = 0;
            var idPozadavku = 0;
            var zakazEditace = false;
            var useBudgety = false;
            var errMess = "";
            function OnBatchEditCellValueChanging(sender, args) {
                var grid = sender;               
                var columnUniqueName = args.get_columnUniqueName();
                var editorValue = args.get_editorValue();               
                var masterTableView = grid.get_masterTableView();
                var editorValue = args.get_editorValue();
                var rowIndex = args.get_row().id.split("__")[1];

                var dataItem = masterTableView.get_dataItems()[rowIndex];
                var os_cislo = dataItem.getDataKeyValue("os_cislo");
                var cislo_pom = dataItem.getDataKeyValue("cislo_pom");
                if (columnUniqueName == "hodnota") {
                    editorValue = editorValue.replace(",", ".");
                    if ((editorValue != "") && (isNaN(editorValue))) {
                        args.set_cancel(true);
                        return;
                    }
                }      
                
                if (columnUniqueName == "hodnota") {
                    var budget_id = null;
                    if (masterTableView.getColumnByUniqueName("budget")) {                       
                        var v = $telerik.$(dataItem.get_cell("budget")).text().trim();
                        if (v != "") {
                            budget_id = v.split("-")[0];
                        }
                    }
                    var err = SendData(os_cislo, cislo_pom, kod, co, editorValue, idPozadavku, typ, budget_id);
                    if (err != "") {
                        args.set_cancel(true);
                        return;
                    }
                }
                else if (columnUniqueName == "poznamka")
                {
                    SendData(os_cislo, cislo_pom, kod, "poznamka", editorValue, idPozadavku, typ, null);
                }                
            }          

            function nacist(kod, co)
            {     
                showLoadingAnimation();
                location.reload();                
            }
           

            function SendData(os_cislo, cislo_pom, kod, co, hodnota, id_pozadavku, typ, id_budgetu) {
                var d = [];
                var item = { "os_cislo": os_cislo }; d.push(item);
                item = { "cislo_pom": cislo_pom }; d.push(item);
                item = { "kod": kod }; d.push(item);
                item = { "co": co }; d.push(item);
                item = { "hodnota": hodnota }; d.push(item);
                item = { "id_pozadavku": id_pozadavku }; d.push(item);
                item = { "typ": typ }; d.push(item);
                item = { "budget_id": id_budgetu }; d.push(item);
                var data_send = JSON.stringify(d);

                if (useBudgety) {
                    $.ajax({
                        type: "POST",
                        url: KSMaster.baseUrl + "/Controls/ZadostOodmenysl_pom.aspx/TestujZustatekBudgetu",

                        data: "{data:'" + data_send + "'}",
                        async: false,
                        contentType: "application/json",
                        dataType: "json",
                        error: function (xhr, ajaxOptions, thrownError) {
                            alert(xhr.status);
                            alert(xhr.responseText);
                            alert(thrownError);
                        },
                        success: function (msg) {
                            errMess = msg.d;
                        }
                    });

                }
                if (errMess === "") {

                    $.ajax({
                        type: "POST",
                        url: KSMaster.baseUrl + "/Controls/ZadostOodmenysl_pom.aspx/Save",

                        data: "{data:'" + data_send + "'}",
                        async: false,
                        contentType: "application/json",
                        dataType: "json",
                        error: function (xhr, ajaxOptions, thrownError) {
                            alert(xhr.status);
                            alert(xhr.responseText);
                            alert(thrownError);
                        },
                        success: function (msg) {
                            if (useBudgety) {
                                retrieveOdmenyGrid();
                            }
                        }
                    });
                }
                else {
                    radalert(errMess, 350, 150, "", null, null);
                }
                return errMess;
            }

            function retrieveOdmenyGrid() {               
                if (useBudgety)
                    getOdmenyData();
            }
            function getOdmenyData() {               
                $find("<%= RALP_TRadGrid.ClientID %>").show("<%= TRadGrid_budgety.ClientID %>");
                var grid = $find("<%= TRadGrid_budgety.ClientID %>");
                if (grid) {
                    var tableView = grid.get_masterTableView();
                    if (tableView != null) {
                        PageMethods.GetBudgetyRekap(idPozadavku, !zakazEditace, updateOdmenyGrid);
                    }
                }                
            }
            function updateOdmenyGrid(result) {
                var tableView = $find("<%= TRadGrid_budgety.ClientID %>").get_masterTableView();
                tableView.set_dataSource(result.Data);
                tableView.dataBind();                
                var wnd = $find("<%= RW_budgety.ClientID %>");
                if (wnd.isClosed())
                    wnd.show();
                $find("<%= RALP_TRadGrid.ClientID %>").hide("<%= TRadGrid_budgety.ClientID %>");
            }

            function batchEditOpening(sender, args)
            {
                if (zakazEditace) {
                    args.set_cancel(true);
                    return;
                }            
                var fItem = sender.get_masterTableView().get_dataItems()[args.get_row().rowIndex - 1];
                var psl = fItem.getDataKeyValue("povolene_sloupce");
                if (psl.indexOf(","+kod.toString()+"_"+co+"," ) == -1)
                    args.set_cancel(true);
            }

            function close_button_OnClientClicked() {                
                var window = GetRadWindow();
                setTimeout(() => { window.close() }, 500);                
            }

            function GetRadWindow() {
                var oWindow = null;
                if (window.radWindow) oWindow = window.radWindow;
                else if (window.frameElement.radWindow) oWindow = window.frameElement.radWindow;
                return oWindow;
            }

            function CellClick(index, cell) {
                if (zakazEditace) return;

                rowIndex = index;
                var grid = $find("<%=TRGrid.ClientID %>");
                var row = grid.get_masterTableView().get_dataItems()[rowIndex];
                var pocet = parseInt(row.getDataKeyValue("budget_count"));
                if (pocet < 2 || pocet == null) {
                    combo_budety_setvisible(false);
                    return;
                }
                else {
                    var txt = row.get_cell(cell).innerHTML;
                    txt = txt.split("<")[0];
                    combo_budety_setvisible(true, cell, index, txt);
                    return;
                }
            }

            function combo_budety_setvisible(p, cell, index, value) {
                var combo = $find("<%= combo_budgety.ClientID %>");

                 var combo_el = combo.get_element();

                if (p) {              
                     var el = document.getElementById(cell + "_" + index);
                     $(combo_el).detach().appendTo(el);

                     $(combo_el).removeClass("hidden");
                     $(combo_el).addClass("show");
                     $(combo_el).offset($(el).offset());
                     if (value != "") {
                         combo.set_text(value);
                         combo.set_value(value.split("-")[0]);
                     }
                 }
                 else {
                     combo.clearItems();
                     combo.clearSelection();
                     combo.set_text("");

                     $(combo_el).removeClass("show");
                     $(combo_el).addClass("hidden");
                 }
            }

            function budget_clientRequesting(sender, args) {
                row = rowByIndex();

                var bd_all = row.getDataKeyValue("budgety_all");
                var bdarr = bd_all.split("|");

                sender.trackChanges();
                for (var i = 0; i < bdarr.length; i++) {
                    var id = bdarr[i].split("-")[0];
                    var item = new Telerik.Web.UI.RadComboBoxItem();

                    item.set_text(bdarr[i]);
                    item.set_value(id);

                    sender.get_items().add(item);
                }
                sender.commitChanges();
                args.set_cancel(true);
            }

            function rowByIndex() {
                var Rows = $find('<%= TRGrid.ClientID %>').get_masterTableView().get_dataItems();
                return Rows[rowIndex];
            }

            function budget_OnClientDropDownClosed(sender, args) {
                sender.clearItems();
                sender.trackChanges();
            }

            function budget_OnClientSelectedIndexChanged(sender, args) {
                row = rowByIndex();
                var oc = row.getDataKeyValue("os_cislo");
                var cp = row.getDataKeyValue("cislo_pom");
                var err = GetRadWindow().BrowserWindow.SendData(oc, cp, kod, "id_budgetu", sender.get_value(), idPozadavku, typ, "", sender.get_value(), true);
                if (err != "") {                   
                    var grid = $find("<%=TRGrid.ClientID %>");
                     var row = grid.get_masterTableView().get_dataItems()[rowIndex];
                     var cell = row.get_cell("hodnota");
                    grid.get_batchEditingManager().changeCellValue(cell, "0");
                    radalert(err, 350, 150, "", null, null);
                }               
                row.get_cell("budget").innerHTML = sender.get_text();
            }

            function budget_OnClientBlur(sender, args) {
                combo_budety_setvisible(false);
            }

            function load() {
                retrieveOdmenyGrid();
                combo_budety_setvisible(false);
            }

            function TRadGrid_budgety_refresh(sender, args) {
                getOdmenyData();
            }

            Sys.Application.add_load(load);
        </script>
    <style type="text/css">
         .oznBorder{
            padding:1px !important;
            background-color:lightblue;           
        }
        .rgBatchContainer input {
            width: 60px !important;
            background-color: white;
            border-style: none;
            text-align:center;
        }
        .rgBatchContainer
        {
            text-align:center !important;
        }
        .gridWidth{
            table-layout:fixed !important;
        }
        table.table_hodn td{
            padding:3px;
        }
        .editpozn input
        {
            width:100% !important;
            text-align:left !important;
        }
        
        .edithodnota.rgBatchContainer
        {          
        }
        .headerhodnota
        {
            width:60px !important;
        }

        #RadWindowWrapper_ctl00_HlavniOblast_RW_budgety .rgCaption
        {
            display:none;
        }

        [id^="RadWindowWrapper_alert"] { 
            z-index:100001 !important;
        }

        #ctl00_HlavniOblast_close_button{
            margin-top: 10px;
        }

    </style>  
    </telerik:RadCodeBlock>

 <telerik:RadAjaxManagerProxy ID="RadAjaxManagerProxy1" runat="server">
        <AjaxSettings>
            <telerik:AjaxSetting AjaxControlID="TRGrid">
                <UpdatedControls>
                    <telerik:AjaxUpdatedControl ControlID="TRGrid" />
                </UpdatedControls>
            </telerik:AjaxSetting>
        </AjaxSettings>
    </telerik:RadAjaxManagerProxy>
    <div style="width:100%; text-align:right;">
         <telerik:RadButton runat="server" ID="close_button" Text="[%Zpět%]" AutoPostBack="false" OnClientClicked="close_button_OnClientClicked" CssClass="kstlacitko" Icon-PrimaryIconCssClass="fi fi-arrow-small-left" >
         </telerik:RadButton>
    </div>
    <asp:Label ID="Label1" runat="server" Text="[%Požadavky na odměny%]" CssClass="nadpis1"></asp:Label>
    <br />
        <kspwc:TRadGrid CaptionVisible="true"  runat="server" ID="TRGrid" OnNeedDataSource="TRGrid_NeedDataSource" AutoGenerateColumns="false" OnItemDataBound="TRGrid_ItemDataBound"
             OnPreRender="TRGrid_PreRender"        AllowSorting="true" AllowPaging="False" UseSaveSetting="false"  >
            <ClientSettings ClientEvents-OnBatchEditOpening="batchEditOpening" ClientEvents-OnBatchEditCellValueChanging="OnBatchEditCellValueChanging"></ClientSettings>
             <PagerStyle PageSizes="50" />
        <MasterTableView  CommandItemDisplay="None" Caption=" " ShowFooter="true" AllowPaging="true" EditMode="Batch" ClientDataKeyNames="os_cislo,cislo_pom,povolene_sloupce" >   
            
            <Columns>
                <telerik:GridNumericColumn DataType="System.Decimal" DataField="os_cislo" HeaderText="[%Os. číslo%]" SortExpression="os_cislo" ReadOnly="true" ><ItemStyle Width="80" /><HeaderStyle Width="80" /></telerik:GridNumericColumn>
                <telerik:GridNumericColumn DataType="System.Int16" DataField="cislo_pom" HeaderText="[%Č. P.%]" SortExpression="cislo_pom" ReadOnly="true"><ItemStyle Width="80" /><HeaderStyle Width="80" /></telerik:GridNumericColumn>
                <telerik:GridBoundColumn DataField="jmeno" HeaderText="[%Jméno%]" SortExpression="jmeno" ReadOnly="true"><ItemStyle Width="200" /><HeaderStyle Width="200" /></telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="prac_str" HeaderText="[%Prac. stř.%]" SortExpression="prac_str" ReadOnly="true"  ><ItemStyle Width="100" /><HeaderStyle Width="100" /></telerik:GridBoundColumn>
                 <telerik:GridBoundColumn DataField="budget" HeaderText="[%Budget%]" SortExpression="budget" ReadOnly="true"><ItemStyle Width="200" /><HeaderStyle Width="200" /></telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="budget_count" HeaderText="" SortExpression="" ReadOnly="true"><ItemStyle Width="20" /><HeaderStyle Width="20" /></telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataType="System.Decimal"  DataField="hodnota" HeaderText="[%Hodnota%]" SortExpression="hodnota" HeaderStyle-CssClass="headerhodnota" ItemStyle-CssClass="edithodnota" ><ItemStyle HorizontalAlign="Center" /></telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="poznamka" HeaderText="[%Poznámka%]" SortExpression="poznamka" ItemStyle-CssClass="editpozn" MaxLength="10" ></telerik:GridBoundColumn>
                <telerik:GridRowIndicatorColumn Visible="false"></telerik:GridRowIndicatorColumn>
            </Columns>                
            <CommandItemTemplate>
                <kspwc:GridCommandItemControl ID="gcic" runat="server" ExportButton-ShowExportToExcelBIFFItem="true" ExportButton-ShowExportToCsvItem="false" ExportButton-ShowExportToExcelHtmlItem="false">
                </kspwc:GridCommandItemControl>
            </CommandItemTemplate>
        </MasterTableView>
       <ClientSettings AllowKeyboardNavigation="true" >
                </ClientSettings>
    </kspwc:TRadGrid>

   <telerik:RadWindowManager Behaviors="Close" ID="RadWindowManager" DestroyOnClose="false" runat="server" >
    <Windows>
         <telerik:RadWindow style="z-index:2003 !important;" runat="server" ID="RW_budgety" Title="[%Budgety%] - [%zůstatky%]" AutoSize="true"  AutoSizeBehaviors="Height, Width" MinWidth="710px" Behaviors="Move, Pin, Resize, Minimize, Maximize, Reload" InitialBehaviors="Move,Resize" KeepInScreenBounds="True" Modal="False" VisibleStatusbar="False">
        <ContentTemplate>
            <kspwc:TRadGrid CaptionVisible="false" ID="TRadGrid_budgety" runat="server" ShowGroupPanel="False" AllowPaging="false" EnableViewState="false"
                                     AllowSorting="false" AutoGenerateColumns="false" 
                                     ShowFooter="false" >               
                                    <MasterTableView Caption="" CommandItemDisplay="Top" AllowSorting="false" CommandItemSettings-ShowRefreshButton="false"  CommandItemSettings-ShowAddNewRecordButton="false" ShowGroupFooter="false" ShowHeader="True" AllowFilteringByColumn="false">                                     
                                            <CommandItemTemplate >                                         
                                                <kspwc:TRadButton ID="TRB_rebind" runat="server" Text="[%Načíst%]" AutoPostBack="False"  OnClientClicked="TRadGrid_budgety_refresh">
                                                    <Icon PrimaryIconCssClass="rbRefresh" PrimaryIconLeft="4" PrimaryIconTop="3"></Icon>
                                                </kspwc:TRadButton>
                                        </CommandItemTemplate>
                                        <Columns>                                           
                                            <telerik:GridBoundColumn DataType="System.String" DataField="Nazev" HeaderText="[%Budget%]" >     
                                                <ItemStyle Wrap="true" />
                                            </telerik:GridBoundColumn> 
                                            <telerik:GridBoundColumn DataType="System.String" DataField="Kod" HeaderText="[%Mzd. kód%]" >                                            
                                            </telerik:GridBoundColumn> 
                                            <telerik:GridBoundColumn DataType="System.Decimal" DataField="ZustZacatek" HeaderText="[%Zůstatek na začátku období%]" > </telerik:GridBoundColumn>
                                            <telerik:GridBoundColumn DataType="System.Decimal" DataField="Rezervovano" HeaderText="[%Rezervace%]"> </telerik:GridBoundColumn>                                            
                                            <telerik:GridBoundColumn DataType="System.Decimal" DataField="Cerpano" HeaderText="[%Čerpáno%]"></telerik:GridBoundColumn>
                                            <telerik:GridBoundColumn DataType="System.Decimal" DataField="Zustatek" HeaderText="[%Zůstatek%]">
                                                <ItemStyle Font-Bold="true" /><HeaderStyle Font-Bold="true" />
                                            </telerik:GridBoundColumn>  
                                            <telerik:GridBoundColumn DataType="System.Decimal" DataField="VPozadavku" HeaderText="[%V požadavku%]"> 
                                                 <ItemStyle Font-Bold="true" /><HeaderStyle Font-Bold="true" />
                                            </telerik:GridBoundColumn>
                                        </Columns>                                       
                                    </MasterTableView>                                    
                                   <ClientSettings >                                       
                                       <ClientEvents OnCommand="function(){}" /> 
                                   </ClientSettings>
                </kspwc:TRadGrid>
             <telerik:RadAjaxLoadingPanel runat="server" ID="RALP_TRadGrid" ></telerik:RadAjaxLoadingPanel>
        </ContentTemplate>
    </telerik:RadWindow>
    </Windows>
</telerik:RadWindowManager>  

    <kspwc:TRadComboBox  runat="server" ID="combo_budgety"  EnableLoadOnDemand="true" OnClientItemsRequesting="budget_clientRequesting"
                                                                                 OnClientDropDownClosed="budget_OnClientDropDownClosed" 
                                                                                 OnClientSelectedIndexChanged="budget_OnClientSelectedIndexChanged"
                                                                                 OnClientBlur="budget_OnClientBlur"  >
     <WebServiceSettings Method="GetBudgety" Path="~/PrivateWebServices/AutoCompleteService.asmx" />
</kspwc:TRadComboBox>
    </asp:Content>
    
   
