﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="SestavaOverovani.aspx.cs"
    Inherits="KSPortal.ZakSpec.SestavaOpravneni" MasterPageFile="~/Main.Master" %>
<%@ Register Assembly="WebControls" Namespace="KSProgram.WebControls" TagPrefix="wc" %>
<%@ Register Assembly="WebControlsAlone" Namespace="KSProgram.WebControlsAlone" TagPrefix="wca" %>
<%@ Register Src="../Controls/ZadostOoverovani.ascx" TagName="ZadostOoverovani" TagPrefix="uc1" %>
<%@ Register Assembly="AjaxControlToolkit" Namespace="AjaxControlToolkit" TagPrefix="aj" %>

<asp:Content ID="Content1" ContentPlaceHolderID="HlavniOblast" runat="Server">
    <table style="border-collapse:collapse;">
        <tr>
            <td>
                <table>
                    <tr>                        
                        <td><asp:Label ID="Label1" runat="server" Text="[%Datum od%]:"></asp:Label></td>
                        <td>
                            <wca:ObdobiText runat="server" ID="obdobi_od"></wca:ObdobiText>
                        </td>
                        <td style="padding-left:10px"><asp:Label ID="Label2" runat="server" Text="[%Datum do%]:"></asp:Label></td>
                        <td>
                            <wca:ObdobiText runat="server" ID="obdobi_do"></wca:ObdobiText>
                        </td>
                        <td  style="padding-left:10px">
                            <kspwc:TLinkButton ID="LinkButton1" runat="server" Text="[%Vytvořit%]" SkinID="button" 
                                oncommand="LinkButton1_Command"></kspwc:TLinkButton>
                        </td> 
                    </tr>
                </table>
                
            </td>
        </tr>
        <tr>
            <td>
                <asp:ObjectDataSource ID="ObjectDataSource1" runat="server" 
                    OldValuesParameterFormatString="original_{0}" SelectMethod="Retrieve" 
                    TypeName="KSProgram.Sestavy.DefSestavy_overovani">
                    <SelectParameters>
                        <asp:Parameter Name="datum_od" Type="DateTime" />
                        <asp:Parameter Name="datum_do" Type="DateTime" />
                    </SelectParameters>
                </asp:ObjectDataSource>
                <wc:TGridView ID="TGridView1" runat="server" ShowTitleRow="True" 
                    TitleText="Ověřování zaměstnanců" DataKeyNames="id_poz" 
                    onrowcommand="TGridView1_RowCommand" 
                     PovolFiltraci="True" 
                    ControlPanelPosition="TitleRow" AllowPaging="True" ShowFooterWhenEmpty="True">                    
                    <Columns>
                        <asp:BoundField DataField="id_poz" SortExpression="id_poz" HeaderText="Id" />
                        <asp:BoundField DataField="os_cislo" SortExpression="os_cislo" HeaderText="[%Os. číslo%]" />
                        <asp:TemplateField HeaderText="Jméno" SortExpression="jmeno">
                            <EditItemTemplate>
                                <asp:TextBox ID="TextBox1" runat="server" Text='<%# Bind("jmeno") %>'></asp:TextBox>
                            </EditItemTemplate>
                            <ItemTemplate>                              
                                    <asp:Label ID="lab_jmeno" runat="server" Text='<%# Bind("jmeno") %>'></asp:Label>
                            </ItemTemplate>
                        </asp:TemplateField>
                        <asp:BoundField DataField="datum" SortExpression="datum" HeaderText="[%Datum%]" 
                            DataFormatString="{0:d}" />
                        <asp:BoundField DataField="reference_1" SortExpression="reference_1" HeaderText="1. [%reference ano/ne%]" />
                        <asp:BoundField DataField="reference_2" SortExpression="reference_2" HeaderText="2. [%reference ano/ne%]" />
                        <asp:BoundField DataField="vysledek_3" SortExpression="vysledek_3" HeaderText="3. [%výsledek dotazníku%]" />
                        <asp:BoundField DataField="nalezen_4" SortExpression="nalezen_4" HeaderText="4. [%nalezen v IBL%]" />
                        <asp:BoundField DataField="insolvence_5" SortExpression="insolvence_5" HeaderText="5. [%insolvence ano/ne%]" />
                        <asp:BoundField DataField="obchod_konflikt_7" SortExpression="obchod_konflikt_7" HeaderText="6. [%exekuce ano/ne%]" />
                        <asp:BoundField DataField="zivnost_konflikt_7"  SortExpression="zivnost_konflikt_7" HeaderText="8. [%Ž.R. konflikt ano/ne%]" />
                        <asp:BoundField DataField="obchod_konflikt_7"  SortExpression="obchod_konflikt_7" HeaderText="8. [%O.R. konflikt ano/ne%]" />
                    </Columns>
                    <PagerTemplate>
                        <wc:PagerNavigationBar ID="pager_seznam" runat="server" />
                    </PagerTemplate>
                </wc:TGridView> 
            </td>
        </tr>
    </table>
</asp:Content>
