﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Main.Master" AutoEventWireup="true"
    CodeBehind="UkolyProZamestnance.aspx.cs" Inherits="KSPortal.ZakSpec.UkolyOdmeny.UkolyProZamestnance" %>

<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>
<asp:Content ID="Content1" ContentPlaceHolderID="HeadContent" runat="server">
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="HlavniOblast" runat="server">
    <asp:ObjectDataSource ID="ODS_Zamestnanci" runat="server" OldValuesParameterFormatString="original_{0}"
        SelectMethod="CiselnikZamestnancu" TypeName="KSProgram.ZakSpec.UkolyOdmeny2">
    </asp:ObjectDataSource>
    <table>
        <tr>
            <td>
                <kspwc:TRadComboBox ID="TRCB_Zamestnanci" runat="server" AutoPostBack="true" DataSourceID="ODS_Zamestnanci"
                     DropDownWidth="650px" MaxHeight="400px" HighlightTemplatedItems="true"
                    Width="650px" Height="400px" DataTextField="zamestnanec_rcb" DataValueField="os_cislo"
                    OnDataBound="TRCB_Zamestnanci_DataBound" OnSelectedIndexChanged="TRCB_Zamestnanci_SelectedIndexChanged"
                    OnItemDataBound="TRCB_Zamestnanci_ItemDataBound">
                    <HeaderTemplate>
                        <table>
                            <tr>
                                <td style="width: 100px" align="right">
                                    [%Os. číslo%]
                                </td>
                                <td style="width: 50px" align="right">
                                    [%Č.p.%]
                                </td>
                                <td style="width: 200px">
                                    [%Zaměstnanec%]
                                </td>
                                <td style="width: 70px" align="right">
                                    [%Přiděleno%]
                                </td>
                                <td style="width: 70px" align="right">
                                    [%Vyplaceno%]
                                </td>
                                <td style="width: 90px" align="right">
                                    [%Zbývá vyplatit%]
                                </td>
                            </tr>
                        </table>
                    </HeaderTemplate>
                    <ItemTemplate>
                        <table>
                            <tr>
                                <td style="width: 100px" align="right">
                                    <%# DataBinder.Eval(Container.DataItem, "os_cislo") %>
                                </td>
                                <td style="width: 50px" align="right">
                                    <%# DataBinder.Eval(Container.DataItem, "cislo_pom") %>
                                </td>
                                <td style="width: 200px">
                                    <%# DataBinder.Eval(Container.DataItem, "zamestnanec") %>
                                </td>
                                <td style="width: 70px" align="right">
                                    <%# DataBinder.Eval(Container.DataItem, "prideleno", "{0:#,##0}") %>
                                </td>
                                <td style="width: 70px" align="right">
                                    <%# DataBinder.Eval(Container.DataItem, "vyplaceno", "{0:#,##0}")%>
                                </td>
                                <td style="width: 90px" align="right">
                                    <%# DataBinder.Eval(Container.DataItem, "zbyva_vyplatit", "{0:#,##0}")%>
                                </td>
                            </tr>
                        </table>
                    </ItemTemplate>
                </kspwc:TRadComboBox>
            </td>
            <td>
                <telerik:RadButton ID="RB_print" runat="server" Text="[%Zadávací list%]" OnClick="RB_print_Click">
                    <Icon PrimaryIconCssClass="fi fi-print" PrimaryIconLeft="4" PrimaryIconTop="3"></Icon>
                </telerik:RadButton>
            </td>
        </tr>
    </table>
    <br />
    <br />
    <kspwc:TRadGrid ID="TRadGrid1" runat="server" AllowPaging="True" AllowSorting="True"
        AutoGenerateColumns="False" OnNeedDataSource="TRadGrid1_NeedDataSource" OnItemDataBound="TRadGrid1_ItemDataBound"
        PageSize="50" AutoFilterControlWidth="False">
        <ClientSettings AllowDragToGroup="True">
        </ClientSettings>
        <MasterTableView DataKeyNames="id_uk,id_odm,ind_castec,obd_vyplaceni,schvaleno,kc_odm,kc_vyplaceni">
            <Columns>
                <telerik:GridNumericColumn DataField="id_uk" DataType="System.Int32" DecimalDigits="0"
                    FilterControlAltText="Filter id_uk column" HeaderText="Id" UniqueName="id_uk">
                </telerik:GridNumericColumn>
                <telerik:GridBoundColumn DataField="popis" FilterControlAltText="Filter popis column"
                    HeaderText="[%Název úkolu%]" UniqueName="popis">
                </telerik:GridBoundColumn>
                <telerik:GridCheckBoxColumn DataField="ind_cilodm" DataType="System.Boolean" FilterControlAltText="Filter ind_castec column"
                    HeaderText="[%Cílová odměna%]" UniqueName="ind_cilodm">
                </telerik:GridCheckBoxColumn>
                <telerik:GridCheckBoxColumn DataField="ind_castec" DataType="System.Boolean" FilterControlAltText="Filter ind_castec column"
                    HeaderText="[%Částečné plnění%]" UniqueName="ind_castec">
                </telerik:GridCheckBoxColumn>
                <%--<telerik:GridTemplateColumn DataField="ind_castec" DataType="System.Boolean" FilterControlAltText="Filter ind_castec column"
                    HeaderText="[%Plnění%]" UniqueName="ind_castec" ReadOnly="true">
                    <ItemTemplate>
                        <telerik:RadButton ID="RB_plneni" runat="server" ToggleType="CheckBox" Checked='<%# Eval("ind_castec") %>' ReadOnly="true">
                            <ToggleStates>
                                <telerik:RadButtonToggleState Text="[%Plnění%]" PrimaryIconCssClass="rbToggleCheckboxChecked"
                                    Value="True"></telerik:RadButtonToggleState>
                                <telerik:RadButtonToggleState Text="[%Celé%]" PrimaryIconCssClass="rbToggleCheckbox"
                                    Value="False"></telerik:RadButtonToggleState>
                            </ToggleStates>
                        </telerik:RadButton>
                    </ItemTemplate>
                </telerik:GridTemplateColumn>--%>
                <telerik:GridTemplateColumn DataField="prihlasen" DataType="System.Boolean" FilterControlAltText="Filter prihlasen column"
                    HeaderText="[%Zařazen%]" UniqueName="prihlasen" SortExpression="prihlasen">
                    <ItemTemplate>
                        <telerik:RadButton ID="RB_prihlasen" runat="server" ToggleType="CheckBox" Checked='<%# Eval("prihlasen") %>'
                            CommandArgument='<%# Eval("os_cislo") %>' OnToggleStateChanged="RB_prihlasen_ToggleStateChanged">
                            <ToggleStates>
                                <telerik:RadButtonToggleState Text="[%Je zařazen%]" PrimaryIconCssClass="fi fi-checkbox"
                                    Value="True"></telerik:RadButtonToggleState>
                                <telerik:RadButtonToggleState Text="[%Není zařazen%]" PrimaryIconCssClass="fi fi-square"
                                    Value="False"></telerik:RadButtonToggleState>
                            </ToggleStates>
                        </telerik:RadButton>
                    </ItemTemplate>
                </telerik:GridTemplateColumn>
                <telerik:GridTemplateColumn DataField="kc_odm" DataType="System.Decimal" FilterControlAltText="Filter kc_odm column"
                    HeaderText="[%Celková odměna%]" UniqueName="kc_odm" SortExpression="kc_odm">
                    <ItemTemplate>
                        <telerik:RadNumericTextBox ID="RNTB_kc_odm" runat="server" DbValue='<%# Bind("kc_odm") %>'
                            DbValueFactor="1" Enabled='<%# Eval("prihlasen") %>' LabelWidth="64px" 
                            Type="Number" Width="110px" DataType="System.Decimal" OnTextChanged="RNTB_kc_odm_TextChanged"
                            AutoPostBack="True" MinValue="0" ShowSpinButtons="true">
                            <NumberFormat DecimalDigits="0" />
                            <EnabledStyle HorizontalAlign="Right" />
                            <IncrementSettings Step="1000" />
                        </telerik:RadNumericTextBox>
                    </ItemTemplate>
                </telerik:GridTemplateColumn>
                <telerik:GridNumericColumn DataField="kc_vyplaceni" DataType="System.Decimal" DecimalDigits="2"
                    FilterControlAltText="Filter kc_vyplaceni column" HeaderText="[%Vyplaceno%]"
                    UniqueName="kc_vyplaceni" DataFormatString="{0:#,##0}">
                    <ItemStyle HorizontalAlign="Right"></ItemStyle>
                </telerik:GridNumericColumn>
                <telerik:GridNumericColumn DataField="zbyva_vyplatit" DataType="System.Decimal" DecimalDigits="2"
                    FilterControlAltText="Filter zbyva_vyplatit column" HeaderText="[%Zbývá vyplatit%]"
                    UniqueName="zbyva_vyplatit" DataFormatString="{0:#,##0}">
                    <ItemStyle HorizontalAlign="Right"></ItemStyle>
                </telerik:GridNumericColumn>
                <telerik:GridTemplateColumn DataField="kc_posledni" DataType="System.Decimal" FilterControlAltText="Filter kc_posledni column"
                    HeaderText="[%K výplatě%]" UniqueName="kc_posledni" SortExpression="kc_posledni">
                    <ItemTemplate>
                        <telerik:RadNumericTextBox ID="RNTB_kc_posledni" runat="server" DbValue='<%# Bind("kc_posledni") %>'
                            DbValueFactor="1" Enabled='<%# Eval("prihlasen") %>' LabelWidth="64px" 
                            Type="Number" Width="110px" DataType="System.Decimal" OnTextChanged="RNTB_kc_posledni_TextChanged"
                            AutoPostBack="True" ShowSpinButtons="true" MinValue="0">
                            <NumberFormat DecimalDigits="0" />
                            <EnabledStyle HorizontalAlign="Right" />
                            <IncrementSettings Step="1000" />
                        </telerik:RadNumericTextBox>
                    </ItemTemplate>
                </telerik:GridTemplateColumn>
                <telerik:GridTemplateColumn DataField="obd_vyplaceni" DataType="System.DateTime"
                    FilterControlAltText="Filter obd_vyplaceni column" HeaderText="[%Obdobi výplaty%]"
                    UniqueName="obd_vyplaceni" SortExpression="obd_vyplaceni">
                    <ItemTemplate>
                        <kspwc:TRadMonthYearPicker ID="TRadMonthYearPicker1" runat="server" Culture="cs-CZ"
                            DbSelectedDate='<%# Bind("obd_vyplaceni") %>' Enabled='<%# Eval("prihlasen") %>'
                            HiddenInputTitleAttibute="Visually hidden input created for functionality purposes."
                             OnSelectedDateChanged="TRadMonthYearPicker1_SelectedDateChanged"
                            AutoPostBack="True" Width="120px">
                            <DateInput AutoPostBack="True" DateFormat="MMMM yyyy" DisplayDateFormat="MMMM yyyy"
                                LabelWidth="40%">
                                <EmptyMessageStyle Resize="None" />
                                <ReadOnlyStyle Resize="None" />
                                <FocusedStyle Resize="None" />
                                <DisabledStyle Resize="None" />
                                <InvalidStyle Resize="None" />
                                <HoveredStyle Resize="None" />
                                <EnabledStyle Resize="None" />
                            </DateInput>
                            <DatePopupButton HoverImageUrl="" ImageUrl="" />
                            <MonthYearNavigationSettings DateIsOutOfRangeMessage="Cancel" />
                        </kspwc:TRadMonthYearPicker>
                    </ItemTemplate>
                    <ItemStyle HorizontalAlign="Right" />
                </telerik:GridTemplateColumn>
                <telerik:GridNumericColumn DataField="zbyv_k_rozdel" DataType="System.Decimal" DecimalDigits="2"
                    FilterControlAltText="Filter zbyv_k_rozdel column" HeaderText="[%Zbývá k rozdělení%]"
                    UniqueName="zbyv_k_rozdel" DataFormatString="{0:#,##0}">
                    <ItemStyle HorizontalAlign="Right"></ItemStyle>
                </telerik:GridNumericColumn>
                <telerik:GridNumericColumn DataField="zbyv_k_vyplac" DataType="System.Decimal" DecimalDigits="2"
                    FilterControlAltText="Filter zbyv_k_vyplac column" HeaderText="[%Zbývá k vyplacení%]"
                    UniqueName="zbyv_k_vyplac" DataFormatString="{0:#,##0}">
                    <ItemStyle HorizontalAlign="Right"></ItemStyle>
                </telerik:GridNumericColumn>
                <telerik:GridDateTimeColumn DataField="schvaleno" DataFormatString="{0:d.M.yyyy}"
                    DataType="System.DateTime" FilterControlAltText="Filter schvaleno column" FilterControlWidth="100px"
                    FilterDateFormat="{0:d.M.yyyy}" HeaderText="[%Schváleno%]" ReadOnly="True" UniqueName="schvaleno">
                </telerik:GridDateTimeColumn>
            </Columns>
        </MasterTableView>
    </kspwc:TRadGrid>
</asp:Content>
