﻿<%@ Page Language="C#" MasterPageFile="~/Main.Master" AutoEventWireup="true" Inherits="KSPortal.Zamestnanec.PracPomerMzd"
    CodeBehind="PracPomerMzd.aspx.cs" %>

<%@ Register Src="../Controls/LimityControl.ascx" TagName="LimityControl" TagPrefix="uc1" %>

<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>

<asp:Content ID="Content2" ContentPlaceHolderID="HeadContent" runat="server">
    <style type="text/css">
        @media only screen and (max-width: 768px) {
            #div_limity {
                overflow-x: auto;
                width: 95vw;
            }
        }

        .ks_dl_item {
            vertical-align: top !important;
        }

        .KsUnderlineTable {
            width: 90% !important;
            margin: auto;
            margin-bottom: 10px;
        }

        .KsUnderlineGrid table{
            margin: 15px;
            font-size: 13px;
            min-width: 550px;
        }

        .KsUnderlineGrid tr{
            height: 35px;
        }

        .KsUnderlineGrid td{
           border-right: none !important;
        }

        .KsUnderlineGrid tr:first-child{
            height: 0px;
        }

        .KsUnderlineGrid td:nth-child(1){
            opacity: 0.6;
        }

        .KsUnderlineGrid td:nth-child(2){
            text-align: right;
            padding-left: 15px;
        }
        .KsUnderlineTable span.ksSmallFont{
            font-size: 10px;
        }
    </style>
</asp:Content>


<asp:Content ID="Content1" ContentPlaceHolderID="HlavniOblast" runat="Server">
    <telerik:RadAjaxManagerProxy ID="RAMP_pom_mzd" runat="server">
        <AjaxSettings>
            <telerik:AjaxSetting AjaxControlID="TRB_aktivni_switch">
                <UpdatedControls>
                    <telerik:AjaxUpdatedControl ControlID="RLV_pomery" />
                </UpdatedControls>
            </telerik:AjaxSetting>
            <telerik:AjaxSetting AjaxControlID="TRadGrid_priplatky">
                <UpdatedControls>
                    <telerik:AjaxUpdatedControl ControlID="TRadGrid_priplatky" />
                </UpdatedControls>
            </telerik:AjaxSetting>
        </AjaxSettings>
    </telerik:RadAjaxManagerProxy>
    <asp:Label ID="Label1x" runat="server" Text="[%Pracovní poměry - mzdové údaje%]" CssClass="nadpis1"></asp:Label>
    <asp:ObjectDataSource ID="ObjectDataSource1" runat="server" SelectMethod="PomeryMzd"
        TypeName="KSProgram.Personal.PracovniPomery">
        <SelectParameters>
            <asp:ControlParameter ControlID="TRB_aktivni_switch" Name="vcetneUkoncenych" Type="Boolean" PropertyName="Checked" />
        </SelectParameters>
    </asp:ObjectDataSource>
    <br />
    <kspwc:TRadButton runat="server" ID="TRB_aktivni_switch" Text="[%Včetně ukončených%]" ButtonType="ToggleButton" ToggleType="CheckBox" Checked="false" OnCheckedChanged="TRB_aktivni_switch_CheckedChanged" CssClass="pozadiText"></kspwc:TRadButton>
    <div style="width: 100%; display: flex; flex-direction: row; flex-wrap: wrap;">
        <telerik:RadListView runat="server" ID="RLV_pomery" ItemPlaceholderID="PH_pomery" DataSourceID="ObjectDataSource1" OnItemDataBound="RLV_pomery_ItemDataBound" CssClass="PPMRLV">
            <LayoutTemplate>
                <div style="display: flex; flex-direction: row; flex-wrap: wrap;">
                    <div id="PH_pomery" runat="server"></div>
                </div>
            </LayoutTemplate>
            <ItemTemplate>
                <div style="margin: 10px; width: 400px" class="ksprvek">
                    <div class="rgCaption"><%# Eval("cislo_pom") + " - " + Eval("druh_pom_j")%></div>
                    <kspwc:BindTable ID="BindTable1" runat="server" HeaderText="[%Identifikace pracovního poměru%]" CssClass="KsUnderlineTable">
                        <TextFieldStyle Width="120px" />
                        <Rows>
                            <kspwc:BindRow DataField="cislo_pom" Text="[%Číslo poměru%]">
                            </kspwc:BindRow>
                            <kspwc:BindRow DataField="druh_pom_j" Text="[%Druh poměru%]">
                            </kspwc:BindRow>
                            <kspwc:BindRow DataField="prac_str" Text="[%Pracovní středisko%]">
                            </kspwc:BindRow>
                            <kspwc:BindRow DataField="datum_nastupu" Text="[%Datum nástupu%]" DataFormatString="{0:d}">
                            </kspwc:BindRow>
                            <kspwc:BindRow DataField="datum_ukonc" Text="[%Datum ukončení%]" DataFormatString="{0:d}" HideWhenEmpty="true">
                            </kspwc:BindRow>
                        </Rows>
                    </kspwc:BindTable>
                    <kspwc:BindTable ID="BindTable2" runat="server" HeaderText="[%Mzda%]" CssClass="KsUnderlineTable" OnLoad="BindTable2_Load">
                        <TextFieldStyle Width="170px" />
                        <Rows>
                            <kspwc:BindRow DataField="typ_mzdy" Text="[%Typ mzdy%]">
                            </kspwc:BindRow>
                            <kspwc:BindRow DataField="trida" Text="[%Třída%]" HideWhenEmpty="true">
                            </kspwc:BindRow>
                            <kspwc:BindRow DataField="mzd_stup" Text="[%Stupeň%]" HideWhenEmpty="true">
                            </kspwc:BindRow>
                            <kspwc:BindRow DataField="tarif" Text="[%Tarif%]" DataFormatString="{0:N}" HtmlEncode="false" HideWhenEmpty="true">
                            </kspwc:BindRow>
                            <kspwc:BindRow DataField="os_hodn" Text="[%Osobní příplatek%]" DataFormatString="{0:N}" HtmlEncode="false" HideWhenEmpty="true">
                            </kspwc:BindRow>
                            <kspwc:BindRow DataField="pripl_vedeni" Text="[%Přípl. za vedení%]" DataFormatString="{0:N}" HtmlEncode="false" HideWhenEmpty="true">
                            </kspwc:BindRow>
                            <kspwc:BindRow DataField="pripl_zvlastni" Text="[%Přípl. zvláštní%]" DataFormatString="{0:N}" HtmlEncode="false" HideWhenEmpty="true">
                            </kspwc:BindRow>
                            <kspwc:BindRow DataField="prum_dov" Text="[%Průměr pro prac. práv. účely%]" DataFormatString="{0:N}" HideWhenEmpty="true">
                            </kspwc:BindRow>
                        </Rows>
                    </kspwc:BindTable>
                    <kspwc:BindTable ID="BindTable3" runat="server" HeaderText="[%Prémie%]" CssClass="KsUnderlineTable">
                        <TextFieldStyle Width="120px" />
                        <Rows>
                            <kspwc:BindRow DataField="typ_premii" Text="[%Typ%]" HideWhenEmpty="true">
                            </kspwc:BindRow>
                            <kspwc:BindRow DataField="prem_cast" Text="[%Částka%]" DataFormatString="{0:N}" HideWhenEmpty="true">
                            </kspwc:BindRow>
                        </Rows>
                    </kspwc:BindTable>
                    <div id="dl_priplatky" class="KsUnderlineTable" style="">
                        <telerik:RadListView runat="server" ID="RLV_priplatky" ItemPlaceholderID="PH_priplatky_items" OnNeedDataSource="RLV_priplatky_NeedDataSource">
                            <LayoutTemplate>
                                <table class="KsBindTable" style="margin: auto; width: 100%">
                                    <tbody>
                                        <tr>
                                            <td colspan="2">
                                                <%# _priplatkyNazev %>
                                            </td>
                                        </tr>
                                        <asp:PlaceHolder ID="PH_priplatky_items" runat="server"></asp:PlaceHolder>
                                    </tbody>
                                </table>
                            </LayoutTemplate>
                            <ItemTemplate>
                                <tr>
                                    <td>
                                        <%# Eval("nazev") %>
                                    </td>
                                    <td>
                                        <%# Eval("castka","{0:### ### ##0.00}") %>
                                    </td>
                                </tr>
                            </ItemTemplate>
                        </telerik:RadListView>
                    </div>
                </div>
            </ItemTemplate>
        </telerik:RadListView>

        <br />
        <div id="div_limity" class="ksprvek KsUnderlineGrid" style="width: fit-content; height: fit-content; margin: 10px;">
            <uc1:LimityControl runat="server" ID="LimityControl1" IdPravaProhlizeni="321" TypKontrolky="BindTable" />
        </div>
        <div id="div_premie" runat="server" style="padding-top: 20px;">
            <kspwc:TRadGrid ID="TRadGrid_priplatky" runat="server" AllowPaging="True" EnableHeaderContextMenu="true"
                AllowSorting="true" AutoGenerateColumns="false"
                AutoFilterControlWidth="false" AutoFilterWidth="true" ShowFooter="false" OnNeedDataSource="TRadGrid_priplatky_NeedDataSource">
                <ClientSettings AllowDragToGroup="False">
                </ClientSettings>
                <PagerStyle Mode="NextPrevNumericAndAdvanced"></PagerStyle>
                <ExportSettings HideStructureColumns="true" OpenInNewWindow="true">
                </ExportSettings>
                <MasterTableView CommandItemDisplay="None" ShowGroupFooter="false">
                    <FooterStyle BackColor="#c9c9c9" Font-Bold="true"></FooterStyle>
                    <Columns>
                        <telerik:GridNumericColumn DataType="System.String" DataField="polozka" HeaderText="[%Mzdová položka%]" FilterControlAltText="Filter polozka column" SortExpression="polozka" FilterControlWidth="30px" />
                        <%--<telerik:GridNumericColumn DataType="System.Decimal" DataField="castka" HeaderText="[%Částka%]" SortExpression="castka" DataFormatString="{0:N}" FilterControlAltText="filter castka column" ItemStyle-HorizontalAlign="Right" />--%>
                        <telerik:GridTemplateColumn DataField="castka" SortExpression="castka" AllowSorting="true">
                            <HeaderStyle HorizontalAlign="Center" />
                            <HeaderTemplate>
                                <asp:Label runat="server" ID="lab_castka" Text="[%Částka%]"></asp:Label><span class="rbHelp16 rbPredefinedIcons" runat="server" id="image"></span>
                                <telerik:RadToolTip runat="server" Text="[%Částka se na základě periody zahrnuje do mzdy jen v některých měsících%]" ID="tooltip" TargetControlID="image">
                                </telerik:RadToolTip>
                            </HeaderTemplate>
                            <ItemTemplate>
                                <asp:Label runat="server" ID="it_castka" Text='<%# Eval("castka", "{0:#}") %>'></asp:Label>
                            </ItemTemplate>
                        </telerik:GridTemplateColumn>
                        <telerik:GridNumericColumn DataType="System.Decimal" DataField="mes_castka" HeaderText="[%Měsíční částka%]" SortExpression="mes_castka" DataFormatString="{0:#}" FilterControlAltText="filter mes_castka column" Aggregate="Sum" ItemStyle-HorizontalAlign="Right" />
                        <telerik:GridDateTimeColumn DataType="System.DateTime" DataField="dat_od" HeaderText="[%Platí od%]" SortExpression="dat_od" FilterControlAltText="Filter dat_od column" DataFormatString="{0:d.M.yyyy}" />
                        <telerik:GridDateTimeColumn DataType="System.DateTime" DataField="dat_do" HeaderText="[%Platí do%]" SortExpression="dat_do" FilterControlAltText="Filter dat_do column" DataFormatString="{0:d.M.yyyy}" />
                        <telerik:GridNumericColumn DataType="System.Int16" DataField="perioda" HeaderText="[%Perioda%]" FilterControlAltText="Filter perioda column" SortExpression="perioda" FilterControlWidth="30px" ItemStyle-HorizontalAlign="Center" />
                        <telerik:GridRowIndicatorColumn></telerik:GridRowIndicatorColumn>
                    </Columns>

                </MasterTableView>
            </kspwc:TRadGrid>
            <%--<telerik:RadToolTipManager  runat="server" AnimationDuration="300"
                                   ID="RadToolTipManager1" Width="480px" Height="227px" RelativeTo="Element"
                                   Animation="Slide" Position="BottomCenter"  >  --%>



            <%-- </telerik:RadToolTipManager>--%>
        </div>
    </div>
</asp:Content>
