﻿<%@ Control Language="C#" AutoEventWireup="true" CodeBehind="LekProhlRezervace.ascx.cs" Inherits="KSPortal.Controls.LekProhlRezervace" %>

<%@ Register Assembly="AjaxControlToolkit" Namespace="AjaxControlToolkit" TagPrefix="asp" %>
<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>

<telerik:RadCodeBlock ID="RadCodeBlock2" runat="server">
    <script type="text/javascript">

        function gridCommand(sender, args) {
            if (args.get_commandName() == "DownloadAttachment") {
                var manager = $find('<%= RadAjaxManager.GetCurrent(Page).ClientID %>');
                manager.set_enableAJAX(false);

                setTimeout(function () {
                    manager.set_enableAJAX(true);
                }, 0);
            }
        }

        function OnSaveButton_Clicked(sender, args) {

            var grid = $find("<%=TRadGridNabidkaTerminu.ClientID %>");
            var batchManager = grid.get_batchEditingManager();
            batchManager._tryCloseEdits(grid.get_masterTableView());
            setTimeout(function () {
                batchManager.saveChanges(grid.get_masterTableView());
            });

        }



        function ZmenaRezervaceTerminu(args) {
            if (args) {
                setTimeout(function () {
                    ZmenaRezervaceTerminuPost();
                }, 1);
            }
        }


        function ZmenaRezervaceTerminuPost() {
            

                var hiddenFieldId = '<%= hidenIdTerminu.ClientID %>';
                var idTerminu = document.getElementById(hiddenFieldId).value;
          
                $.ajax({
                    type: "POST",
                    url: KSMaster.baseUrl + "/Manazer/WebMethodsReSys.aspx/ZmenaRezervaceTerminu",
                    data: "{aIdTerminu: '" + idTerminu + "'}",
                    async: false,
                    contentType: "application/json",
                    dataType: "json",
                    failure: function (response) {
                        //alert("Chyba: " + JSON.parse(response.responseText).Message);
                        alert("Chyba 111: " + id + response.responseText);
                    },
                    error: function (response) {
                        //alert("Chyba: ", JSON.parse(response.responseText).Message);
                        alert("Chyba 222: " + id + response.responseText);
                    },
                    success: function (msg) {
                        //hiddenFieldId.value = '1234';
                        __doPostBack('<%= btnPostBack.UniqueID %>', '');
                    }
                });         
        }


    </script>
</telerik:RadCodeBlock>

<style type="text/css">
    input.kstlacitko {
        height: 20px;
        background: inherit !important;
    }

    .RadButton_Metro.rbButton.rbToggled {
        background-color: transparent !important;
        color: inherit !important;
        border-color: #e0dfdf !important;
    }

    .RadButton_Metro.rbButton .fi-check-circle {
        color: green;
    }

    .RadButton_Metro.rbButton .fi-cross-circle {
        color: red;
    }

    .custom-toggle-state:not(:checked) {
        background-color: transparent !important;
    }
</style>

<telerik:RadAjaxManagerProxy ID="RadAjaxManagerProxy1" runat="server">
    <AjaxSettings>
        <telerik:AjaxSetting AjaxControlID="TRadGridNabidkaTerminu">
            <UpdatedControls>
                <telerik:AjaxUpdatedControl ControlID="TRadGridNabidkaTerminu" UpdatePanelCssClass="" />
                <telerik:AjaxUpdatedControl ControlID="RadWindow1" UpdatePanelCssClass="" />
                <telerik:AjaxUpdatedControl ControlID="RadWindow1Field" UpdatePanelCssClass="" />                
                <telerik:AjaxUpdatedControl ControlID="hidenIdTerminu" UpdatePanelCssClass="" />
            </UpdatedControls>
        </telerik:AjaxSetting>
    </AjaxSettings>
</telerik:RadAjaxManagerProxy>

<asp:HiddenField runat="server" ID="hidenIdTerminu" />
<asp:Button ID="btnPostBack" runat="server" Text="PostBack Button" OnClick="btnPostBack_Click" style="display:none;" />

<kspwc:TRadGrid ID="TRadGridNabidkaTerminu" runat="server" AllowPaging="True" AllowSorting="True" ShowGroupPanel="True" NotifikaceDisable="true"
    OnItemCreated="TRadGridNabidkaTerminu_ItemCreated" PageSize="50" OnItemCommand="TRadGridNabidkaTerminu_ItemCommand"
    OnNeedDataSource="TRadGridNabidkaTerminu_NeedDataSource" OnDeleteCommand="TRadGridNabidkaTerminu_DeleteCommand"
    GroupingEnabled="false" GroupPanelPosition="Top" AllowMultiRowSelection="true" ClientSettings-Selecting-AllowRowSelect="true">
    <ExportSettings HideStructureColumns="true" ExportOnlyData="true">
    </ExportSettings>
    <ClientSettings AllowDragToGroup="True">
    </ClientSettings>
    <GroupingSettings ShowUnGroupButton="true"></GroupingSettings>
    <PagerStyle Mode="NextPrevNumericAndAdvanced"></PagerStyle>
    <MasterTableView GroupLoadMode="Client" HierarchyLoadMode="Conditional" CommandItemDisplay="Top" AutoGenerateColumns="False" EditMode="InPlace"
        EnableGroupsExpandAll="True" Caption="[%Přihlášení k lékařské prohlídce%]" DataKeyNames="id,idterminu,termin,cas,misto,lekar_id,prihlasen,stav_zam" AllowMultiColumnSorting="true">
        <BatchEditingSettings OpenEditingEvent="Click" EditType="Cell" />

        <%--        <GroupByExpressions>
            <telerik:GridGroupByExpression>
                <GroupByFields>
                    <telerik:GridGroupByField FieldName="lekar" HeaderText="[%Lékař%]" SortOrder="Ascending" />
                    <telerik:GridGroupByField FieldName="misto" HeaderText="[%Místo%]" SortOrder="Ascending" />
                </GroupByFields>
                  <SelectFields>
                    <telerik:GridGroupByField FieldName="idterminu" HeaderText="[%ID termínu%]"/>
                </SelectFields>
            </telerik:GridGroupByExpression>
        </GroupByExpressions>--%>

        <Columns>
            <%--Editační button--%>
            <telerik:GridEditCommandColumn UniqueName="editace_radku"/>
            <%--Označovací button--%>
            <telerik:GridClientSelectColumn UniqueName="oznac_zaznam" Visible="false" Exportable="false"></telerik:GridClientSelectColumn>

            <%--ID termínu--%>
            <telerik:GridBoundColumn UniqueName="idterminu" DataField="idterminu" SortExpression="idterminu" HeaderText="[%ID termínu%]" ReadOnly="true"></telerik:GridBoundColumn>

            <%--Termín Povolen/Blokován--%>
            <telerik:GridTemplateColumn DataField="povolen" DataType="System.Boolean" HeaderText="[%Povolen%]" ItemStyle-HorizontalAlign="Center"
                FilterControlAltText="Filter povolen column" UniqueName="povolen" SortExpression="povolen" Exportable="false" Display="false">
                <ItemTemplate>
                    <i class="fi fi-check-circle" style='<%# (bool)Eval("povolen")?"display: block; color: green;font-size:20px": "display: none" %>'></i>
                    <i class="fi fi-cross-circle" style='<%# (bool)Eval("povolen")?"display: none": "display: block; color: red;font-size:20px" %>'></i>
                </ItemTemplate>
            </telerik:GridTemplateColumn>

            <%--Status termínu--%>
            <telerik:GridTemplateColumn DataField="stav_ter" FilterControlAltText="Filter stav_ter column"
                UniqueName="stav_ter" DataType="System.Boolean" HeaderText="[%Status termínu%]"
                GroupByExpression="Group By stav_ter" SortExpression="stav_ter" Exportable="false">
                <ItemTemplate>
                    <telerik:RadButton ID="RadButtonTer" runat="server" ToggleType="CheckBox" Checked='<%# Eval("povolen") %>'
                        CommandArgument='<%# Eval("idterminu") %>' OnToggleStateChanged="RadButtonMan_ToggleStateChanged" ButtonType="LinkButton">
                        <ToggleStates>
                            <telerik:RadButtonToggleState Text="[%Termín je publikovaný%]" PrimaryIconCssClass="fi fi-check-circle"
                                Value="True"></telerik:RadButtonToggleState>
                            <telerik:RadButtonToggleState Text="[%Termín je blokovaný%]" PrimaryIconCssClass="fi fi-cross-circle"
                                Value="False"></telerik:RadButtonToggleState>
                        </ToggleStates>
                    </telerik:RadButton>
                </ItemTemplate>
            </telerik:GridTemplateColumn>

            <%--Zaměstnanec Přihlášen/Nepřihlášen--%>
            <telerik:GridTemplateColumn DataField="prihlasen" DataType="System.Boolean" HeaderText="[%%]" ItemStyle-HorizontalAlign="Center"
                FilterControlAltText="Filter prihlasen column" UniqueName="prihlasen" SortExpression="prihlasen" Exportable="false" Display="false">
                <ItemTemplate>
                    <i class="fi fi-check-circle" style='<%# (bool)Eval("prihlasen")?"display: block; color: green;font-size:20px": "display: none" %>'></i>
                    <i class="fi fi-cross-circle" style='<%# (bool)Eval("prihlasen")?"display: none": "display: block; color: red;font-size:20px" %>'></i>
                </ItemTemplate>
            </telerik:GridTemplateColumn>

            <%--Status zaměstnance--%>
            <telerik:GridTemplateColumn DataField="stav_zam" FilterControlAltText="Filter stav_zam column"
                UniqueName="stav_zam" DataType="System.Boolean" HeaderText="[%Status přihlášení%]"
                GroupByExpression="Group By stav_zam" SortExpression="stav_zam" Exportable="false">
                <ItemTemplate>
                    <telerik:RadButton ID="RadButtonZam" runat="server" ToggleType="CheckBox" Checked='<%# Eval("prihlasen") %>'
                        CommandArgument='<%# Eval("idterminu") %>' CssClass="custom-toggle-state"
                        OnToggleStateChanged="RadButtonZam_ToggleStateChanged" ButtonType="LinkButton">
                        <ToggleStates>
                            <telerik:RadButtonToggleState Text="[%Jste přihlášen(a) na termín%]" PrimaryIconCssClass="fi fi-check-circle"
                                Value="True"></telerik:RadButtonToggleState>
                            <telerik:RadButtonToggleState Text="[%Nejste přihlášen(a) na termín%]" PrimaryIconCssClass="fi fi-cross-circle"
                                Value="False"></telerik:RadButtonToggleState>
                        </ToggleStates>
                    </telerik:RadButton>
                </ItemTemplate>
            </telerik:GridTemplateColumn>

            <%--Datum prohlídky--%>
            <telerik:GridDateTimeColumn DataField="termin" DataFormatString="{0:d.M.yyyy}" DataType="System.DateTime"
                HeaderText="[%Termín%]" UniqueName="termin" ReadOnly="true"
                FilterDateFormat="d.M.yyyy" FilterControlWidth="100px">
            </telerik:GridDateTimeColumn>
            <%--Čas prohlídky--%>
            <telerik:GridBoundColumn DataField="cas" FilterControlAltText="Filter cas column" ReadOnly="true"
                HeaderText="[%Čas%]" UniqueName="cas">
            </telerik:GridBoundColumn>
            <%--Lékař--%>
            <telerik:GridBoundColumn DataField="lekar" FilterControlAltText="Filter lekar column" ReadOnly="true"
                HeaderText="[%Lékař%]" UniqueName="lekar">
            </telerik:GridBoundColumn>
            <%--Místo prohlídky--%>
            <telerik:GridBoundColumn DataField="misto" FilterControlAltText="Filter misto column" ReadOnly="true"
                HeaderText="[%Místo%]" UniqueName="misto">
            </telerik:GridBoundColumn>
            <%--Kapacita prohlídky--%>
            <telerik:GridBoundColumn DataField="kapacita" FilterControlAltText="Filter kapacita column" ReadOnly="true"
                HeaderText="[%Kapacita%]" UniqueName="kapacita">
            </telerik:GridBoundColumn>
            <%--Počet přihlášených--%>
            <telerik:GridBoundColumn DataField="prihlasenych" FilterControlAltText="Filter prihlasenych column" ReadOnly="true"
                HeaderText="[%Přihlášených%]" UniqueName="prihlasenych">
            </telerik:GridBoundColumn>
            <%--Poznámka k termínu--%>
            <telerik:GridTemplateColumn DataField="poznamka" FilterControlAltText="Filter misto column" AllowSorting="false"
                HeaderText="[%Poznámka%]" UniqueName="poznamka">
                <ItemTemplate>
                    <asp:Label ID="lpoznamka" runat="server" Text='<%# Eval("poznamka") %>' Width="400px"></asp:Label>
                </ItemTemplate>
                <EditItemTemplate>
                    <telerik:RadTextBox ID="epoznamka" runat="server" Text='<%# Eval("poznamka").ToString().Trim() %>' TextMode="MultiLine" Width="100%" MaxLength="250"></telerik:RadTextBox>
                </EditItemTemplate>
            </telerik:GridTemplateColumn>
            <%--Okno se Seznamem přihlášených--%>
            <telerik:GridButtonColumn UniqueName="prihlaseni" ImageUrl="../Skins/ikony/uicons-regular-rounded/svg/fi-rr-users.svg" ButtonType="ImageButton" Text="[%Detail přihlášených%]" Exportable="false" CommandName="showDetail" HeaderText="[%Přihlášení%]" ItemStyle-HorizontalAlign="Center" ButtonCssClass="kstlacitko"></telerik:GridButtonColumn>
            <%--Os.číslo přihlášeného--%>
            <telerik:GridBoundColumn DataField="pr_os_cislo" FilterControlAltText="Filter pr_os_cislo column" ReadOnly="true"
                HeaderText="[%Os.číslo%]" UniqueName="pr_os_cislo" Visible="false">
            </telerik:GridBoundColumn>
            <%--Jméno přihlášeného--%>
            <telerik:GridBoundColumn DataField="pr_jmeno" FilterControlAltText="Filter pr_jmeno column" ReadOnly="true"
                HeaderText="[%Jméno%]" UniqueName="pr_jmeno" Visible="false">
            </telerik:GridBoundColumn>
            <%--Příjmení přihlášeného--%>
            <telerik:GridBoundColumn DataField="pr_prijmeni" FilterControlAltText="Filter pr_prijmeni column" ReadOnly="true"
                HeaderText="[%Příjmení%]" UniqueName="pr_prijmeni" Visible="false">
            </telerik:GridBoundColumn>
            <%--Kmen. středisko přihlášeného--%>
            <telerik:GridBoundColumn DataField="pr_kmen_str" FilterControlAltText="Filter pr_kmen_str column" ReadOnly="true"
                HeaderText="[%Kmen.středisko%]" UniqueName="pr_kmen_str" Visible="false">
            </telerik:GridBoundColumn>
            <%--Mazání záznamu--%>
            <telerik:GridTemplateColumn UniqueName="smaz_zaznam" Visible="false" AllowFiltering="false"  >
                <ItemTemplate>
                    <kspwc:TRadButton runat="server" ID="TRB_DeleteR" Icon-PrimaryIconCssClass="fi fi-trash" CommandName="Delete" ConfirmText="[%Opravdu chcete smazat záznam?%]" ConfirmDialogType="RadWindow"
                        ConfirmTitle="[%Mazání záznamu o úrazu%]">
                    </kspwc:TRadButton>
                </ItemTemplate>
            </telerik:GridTemplateColumn>
        </Columns>

        <CommandItemTemplate>
            <kspwc:GridCommandItemControl ID="GCIC1" runat="server" DateControl="TRadDatePicker">
                <%--<ExportButton runat="server" ID="ExportE" Visible="false"></ExportButton>--%>
                <ExportButton ID="ExportButton1" runat="server" ShowExportToExcelMLItem="true" ShowExportToWordItem="false" ShowExportToWordDocxItem="false" ShowExportToExcelHtmlItem="false" OnExporting="On_Exporting" on />
            </kspwc:GridCommandItemControl>
            <kspwc:TRadButton ID="TRB_smaz" runat="server" OnClick="TRB_smaz_Click"
                Text="[%Smazat označené%]" Icon-PrimaryIconCssClass="fi fi-trash" ConfirmText="Opravdu chcete označené termíny smazat?">
            </kspwc:TRadButton>
        </CommandItemTemplate>

    </MasterTableView>
</kspwc:TRadGrid>

<asp:Label runat="server" ID="Label_Error" Text="" ForeColor="Red"></asp:Label>

<asp:HiddenField ID="RadWindow1Field" Value="false" runat="server" />
<telerik:RadWindow ID="RadWindow1" Title="Přihlášení na termín" runat="server" Behaviors="Close" Modal="true"
    Width="1200" Height="800" Visible="true" VisibleOnPageLoad="true" OnClientClose="Window1Close">
    <ContentTemplate>
        <kspwc:TRadGrid ID="TRadGridPrihlaseni" runat="server" AutoFilterControlWidth="false" AutoFilterWidth="true"
            AllowSorting="false" AutoGenerateColumns="False" CssClass="revertShadow" CaptionVisible="false"
            OnNeedDataSource="TRadGridPrihlaseni_NeedDataSource">
            <GroupingSettings CaseSensitive="False" CollapseAllTooltip="Collapse all groups"></GroupingSettings>
            <MasterTableView CommandItemDisplay="None" DataKeyNames="idterminu" EnableNoRecordsTemplate="true">
                <NoRecordsTemplate>
                    <div class="NoRecordsTemplate">
                        <i class="fi fi-eye-crossed"></i>
                        <label>[%Žádná data k zobrazení%]</label>
                    </div>
                </NoRecordsTemplate>
                <Columns>
                    <telerik:GridBoundColumn UniqueName="termin" DataField="termin" SortExpression="termin" HeaderText="[%Datum%]"></telerik:GridBoundColumn>
                    <telerik:GridBoundColumn UniqueName="cas" DataField="cas" SortExpression="cas" HeaderText="[%Čas%]"></telerik:GridBoundColumn>
                    <telerik:GridBoundColumn UniqueName="zamestnanec" DataField="zamestnanec" SortExpression="zamestnanec" HeaderText="[%Zaměstnanec%]"></telerik:GridBoundColumn>
                    <telerik:GridBoundColumn UniqueName="stredisko" DataField="stredisko" SortExpression="stredisko" HeaderText="[%Středisko%]"></telerik:GridBoundColumn>
                </Columns>
            </MasterTableView>
        </kspwc:TRadGrid>
    </ContentTemplate>
</telerik:RadWindow>

<telerik:RadScriptBlock runat="server" ID="RadScript">

    <script type="text/javascript">
        function Window1Close(sender, args) {
            $get("<%=RadWindow1Field.ClientID %>").value = "false";
        }
    </script>

</telerik:RadScriptBlock>

