﻿<%@ Control Language="C#" AutoEventWireup="true" CodeBehind="WfZmenaStavu.ascx.cs" Inherits="KSPortal.Controls.WfZmenaStavu" %>
<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>
<%@ Register Assembly="WebControls" Namespace="KSProgram.WebControls" TagPrefix="wc" %>
<%@ Register TagPrefix="uc" TagName="poz_prilohy" Src="~/Controls/PrilohyManager.ascx" %>

<telerik:RadScriptBlock ID="RadScriptBlock1" runat="server">
    <script type="text/javascript" id="telerikClientEventsWFZS">
        //<![CDATA[            
        var validni_os_cislo;
        function TRCB_AdresatJmeno_ItemsRequesting(sender, args) {
            var context = args.get_context();
            context["contextKey"] = "poz_adresat";
        }

        function showDiskusi() {
            var wsDiskuse = $find("<%= DiskusePopup.ClientID %>");
                if (wsDiskuse) {
                    adrDiskuseInit();
                    wsDiskuse.show();
                }
        }
        function showSlucPole() {
            var wsSlucPole = $find("<%= SlucPolePopup.ClientID %>");
            if (wsSlucPole) {                 
                 wsSlucPole.show();
             }
         }

        function img_save_diskuse_Clicked() {           
                var wsDiskuse = $find("<%= DiskusePopup.ClientID %>");
                if (wsDiskuse) {
                    if (!Page_ClientValidate("")) {
                        return;
                    }
                    var obj = $telerik.$("[id$='TextBoxDiskuse_e']").get(0).control;
                    if (obj != null) {
                        var txt = obj.get_textBoxValue();
                        //ocharana proti script injection
                        txt = $($.parseHTML(txt)).text();

                        var adr_os_c = $telerik.$("[id$='TB_DiskuseAdresatOsCislo']").get(0).control;
                        var adresat = 0;
                        if (adr_os_c) {
                            adresat = adr_os_c.get_textBoxValue();
                        }
                        var d = [];
                        var item = { "co": "diskuse" }; d.push(item);
                        item = { "text": txt }; d.push(item);
                        item = { "adresat": adresat }; d.push(item);                        
                        item = { "PozId": KSMaster.idPozadavku }; d.push(item);                      
                        sendData("diskuse", d);
                    }
                    var obj = $telerik.$("[id$='TextBoxDiskuse_e']").get(0);
                    if (obj != null) {
                        obj.control.set_value("");
                    }
                    adrChange();
                    wsDiskuse.close();                    
                }
            }

            function sendData(co, d) {
                var async = true;
                if (co == "os_cislo_exists")
                    async = false;

                var data_send = JSON.stringify(d);
                $.ajax({
                    type: "POST",
                    url: KSMaster.baseUrl +"/Pozadavky/PozadavekDetail.aspx/SaveDiskusi",
                    data: "{data:'" + data_send + "'}",
                    contentType: "application/json",
                    dataType: "json",
                    async: async,
                    error: function (xhr, ajaxOptions, thrownError) {
                        alert(xhr.status);
                        alert(xhr.responseText);
                        alert(thrownError);
                    },
                    success: function (msg) {
                        if (co == "diskuse") {                           
                            if (msg.d!="N") KSMaster.NotifikaceInfoUlozeni();//PH 4.12.2019
                            //PH 20.6.2019
                            retrieveProcessGrid();                            
                        } else if (co == "adresat") {
                            $telerik.$("[id$='TB_DiskuseAdresatOsCislo']").get(0).control.set_value(msg.d);
                        }
                        else if (co == "os_cislo") {
                            var c = $telerik.$("[id$='TRCB_DiskuseAdresatJmeno']").get(0).control;
                            var txt = c.get_text();
                            if (txt !== msg.d)
                                $telerik.$("[id$='TRCB_DiskuseAdresatJmeno']").get(0).control.set_text(msg.d);
                        }
                        else if (co == "os_cislo_exists") {
                            //console.log("send_data:"+msg.d);
                            validni_os_cislo = msg.d;
                        }
                    }
                });
            }
           
            function adrDiskuseInit() {               
                $('#span_adr_jmena').show();
                $telerik.$("[id$='TB_DiskuseAdresatOsCislo']").get(0).control.set_visible(false);
                $telerik.$("[id$='TRCB_DiskuseAdresatJmeno']").get(0).control.set_visible(false);
                $telerik.$("[id$='RB_DiskAdrChange']").get(0).control.set_visible(true);

                $telerik.$("[id$='TB_DiskuseAdresatOsCislo']").get(0).control.set_value("");
                $telerik.$("[id$='TRCB_DiskuseAdresatJmeno']").get(0).control.set_value("");
            }

            function adrChange() {               
                $('#span_adr_jmena').hide();
                $telerik.$("[id$='TB_DiskuseAdresatOsCislo']").get(0).control.set_visible(true);
                $telerik.$("[id$='TRCB_DiskuseAdresatJmeno']").get(0).control.set_visible(true);
                $telerik.$("[id$='RB_DiskAdrChange']").get(0).control.set_visible(false);
            }
            function TRCB_DiskuseAdresatJmeno_onClientSelectedIndexChanged(sender, args) {
                var arr = [];
                var text_osc = $telerik.$("[id$='TB_DiskuseAdresatOsCislo']").get(0).control;
                if (sender.get_value() == "")
                    text_osc.set_value("");
                else {
                    var pp = sender.get_value();
                    var arr = pp.split(",");
                }
                if (arr.length == 2) {
                    var d = [];
                    var item = { "co": "adresat" }; d.push(item);
                    item = { "prijmeni": arr[0] }; d.push(item);
                    item = { "jmeno": arr[1] }; d.push(item);                   
                    sendData("adresat", d);
                }
            }

            function TB_AdresatOsCislo_TextChanged(sender, args) {
                var text_jm = $telerik.$("[id$='TRCB_DiskuseAdresatJmeno']");
                if (text_jm) {
                    var val = sender.get_textBoxValue();
                    if (val === "") {
                        text_jm.set_value("");
                    }
                    else {
                        var d = [];
                        var item = { "co": "os_cislo" }; d.push(item);
                        item = { "os_cislo": val }; d.push(item);
                        sendData("os_cislo", d);
                    }
                }
            }
            function cv_platne_os_cislo_validate(sender, args) {
                args.IsValid = true;
                if (args.Value == "") return;
                var d = [];
                var item = { "co": "os_cislo_exists" }; d.push(item);
                item = { "os_cislo": args.Value }; d.push(item);

                sendData("os_cislo_exists", d)                
                var viz = $telerik.$("[id$='TB_DiskuseAdresatOsCislo']").get(0).control.get_visible();
                if (viz == true)
                    args.IsValid = (validni_os_cislo === "true");
        }
       

        function sluc_pole_ClientShow(sender, args) {            
            PageMethods.getSlucovaciPole(KSMaster.idPozadavku, onSuccessSlucPole, onFailedSlucPole)
        }
       
        function onSuccessSlucPole(result) {
            var mtv = $telerik.$("[id$='grid_sluc_pole']").get(0).control.get_masterTableView();           
            var array = JSON.parse(result);
            mtv.set_dataSource(array);
            mtv.dataBind();
        }
        
        function onFailedSlucPole(error) {
            console.error(error);
            alert(error);
        }
        
        //]]>
    </script>
</telerik:RadScriptBlock>

<style type="text/css">
    #ctl00_HlavniOblast_UC_ZmenaStavu_SlucPolePopup_C_grid_sluc_pole_GridHeader .rgCaption
    {
        display:none;
    }
    #RadWindowWrapper_ctl00_HlavniOblast_UC_ZmenaStavu_SlucPolePopup
    {
        overflow:hidden !important;
    }
</style>

<telerik:RadAjaxManagerProxy ID="RadAjaxManagerProxy1" runat="server">
    <AjaxSettings>

        <telerik:AjaxSetting AjaxControlID="P_Form_zs">
            <UpdatedControls>
                <telerik:AjaxUpdatedControl ControlID="P_Form" />
            </UpdatedControls>
        </telerik:AjaxSetting>
        <telerik:AjaxSetting AjaxControlID="RB_DiskAdrChange">
            <UpdatedControls>
                <telerik:AjaxUpdatedControl ControlID="PanelDiskuse" />
            </UpdatedControls>
        </telerik:AjaxSetting>
        <telerik:AjaxSetting AjaxControlID="RB_ViceInfo">
            <UpdatedControls>
                <telerik:AjaxUpdatedControl ControlID="PanelZmenaStavu" />
            </UpdatedControls>
        </telerik:AjaxSetting>
    </AjaxSettings>
</telerik:RadAjaxManagerProxy>

<asp:HiddenField ID="HF_id_poz" runat="server" />
<asp:HiddenField ID="HF_view_id" runat="server" />

<asp:Panel ID="P_Form_zs" runat="server" Width="100%">
    <asp:Panel runat="server" ID="pan_prilohy">
        <uc:poz_prilohy ID="uc_prilohy" runat="server" Vlastnik="workfl_hl" />
    </asp:Panel>
    <div style="height: 10px;"></div>
    <div class="tiskHide">
        <%--RetrieveDummy vrací prázdný řádek, kde je vyplněno pouze id_poz a faze--%>
        <asp:ObjectDataSource ID="dsZmenaStavu" runat="server" OldValuesParameterFormatString="original_{0}"
            TypeName="KSProgram.Pozadavky.WorkflowProces" SelectMethod="RetrieveDummy" UpdateMethod="KrokProcesuTrans">
            <SelectParameters>
                <asp:Parameter Name="id_poz" Type="Int32" />
            </SelectParameters>
            <UpdateParameters>
                <asp:Parameter Name="id_poz" Type="Int32" />
                <asp:Parameter Name="stav" Type="String" />
                <asp:Parameter Name="duvod" Type="String" />
                <asp:Parameter Name="adresat" Type="Decimal" />
            </UpdateParameters>
        </asp:ObjectDataSource>
        <%--<asp:ObjectDataSource ID="dsStavyEdit" runat="server" OldValuesParameterFormatString="original_{0}"
            SelectMethod="StavyPozadavkuProTyp" TypeName="KSProgram.Pozadavky.WorkflowProces">
            <SelectParameters>
                <asp:Parameter Name="id_poz" Type="Int32" />
                <asp:Parameter Name="typ" Type="String" />
                <asp:Parameter Name="emptyRow" Type="Boolean" DefaultValue="true" />
            </SelectParameters>
        </asp:ObjectDataSource>--%>
        <asp:Panel ID="PanelZmenaStavu" runat="server" Visible="false" Style="width: 100%">
            <br />
            <wc:TDetailsView runat="server" ID="DetailsViewZmenaStavu" AutoGenerateRows="False" Style="width: 100%" CssClass="ksprvek"
                DataSourceID="dsZmenaStavu" DefaultMode="Edit"
                OnItemInserting="DetailsViewZmenaStavu_ItemInserting"
                OnItemUpdated="DetailsViewZmenaStavu_ItemUpdated" DataKeyNames=""
                OnItemCommand="DetailsViewZmenaStavu_ItemCommand" HeaderText="[%Nový krok procesu řešení%]">
                <Fields>
                    <asp:BoundField DataField="id_poz" Visible="False">
                        <HeaderStyle Height="0px" />
                        <ItemStyle Height="0px" Width="0px" />
                    </asp:BoundField>
                    <asp:TemplateField HeaderText="[%Stav%]" HeaderStyle-Width="80">
                        <EditItemTemplate>
                            <asp:DropDownList ID="RCM_ZmenaStavu" runat="server" SelectedValue='<%# Bind("stav") %>'  EmptyMessage="[%Změna stavu%]">
                                <asp:ListItem Value="" Text=""></asp:ListItem>
                            </asp:DropDownList><%--AutoPostBack="true"
                                OnSelectedIndexChanged="RCM_ZmenaStavu_OnSelectedIndexChanged"--%><%-- DataSourceID="dsStavyEdit" DataTextField="popis" DataValueField="hodnota"--%>
                            <asp:Label runat="server" ID="lab_hvezda" ForeColor="Red" Text="*"></asp:Label>
                            <asp:Label ID="lab_stav_info" runat="server" Text="Info: [%Bez změny stavu nedojde ke schválení či posunutí žádosti%]!" ForeColor="#009933"></asp:Label>
                            <asp:CustomValidator runat="server" ID="cv_ZmenaStavu" ControlToValidate="RCM_ZmenaStavu"
                                Display="Dynamic" OnServerValidate="cv_ZmenaStavu_ServerValidate" ErrorMessage=""></asp:CustomValidator>
                        </EditItemTemplate>
                        <%--<ItemTemplate>
                            <asp:Label ID="Label2" runat="server" Text='<%# Bind("stav") %>'></asp:Label>
                        </ItemTemplate>--%>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="[%Důvod%]">
                        <EditItemTemplate>
                            <telerik:RadTextBox ID="TextBoxDuvod" runat="server" Height="35px" Text='<%# Bind("duvod") %>'
                                TextMode="MultiLine" Width="100%" MaxLength="999"  Resize="Both">
                            </telerik:RadTextBox><%--Visible="false"--%>
                            <br />
                            <wc:TextValidator runat="server" ID="text_val1_e" ControlToValidate="TextBoxDuvod"></wc:TextValidator>
                        </EditItemTemplate>
                        <%--<ItemTemplate>
                            <asp:Label ID="Label1" runat="server" Text='<%# Bind("duvod") %>'></asp:Label>
                        </ItemTemplate>--%>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="" >
                        <EditItemTemplate>
                            <wc:TRadButton ID="RB_ViceInfo" runat="server" Text="[%Řešitel%] .." OnClick="RB_ViceInfo_Click" CausesValidation="False" Icon-PrimaryIconCssClass="fi fi-user-add"></wc:TRadButton>
                        </EditItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="[%Nový krok%]" HeaderStyle-CssClass="hidden" ItemStyle-CssClass="hidden"><%----%>
                        <EditItemTemplate>
                            <asp:Label ID="Lab_novy_krok" runat="server" Text=""></asp:Label>
                        </EditItemTemplate>
                        <ItemTemplate>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="[%Nový řešitel%]" HeaderStyle-CssClass="hidden" ItemStyle-CssClass="hidden"><%----%>
                        <EditItemTemplate>
                            <asp:Label ID="Lab_adresati_jmena" runat="server" Text=""></asp:Label>
                            <wc:TRadButton ID="RB_AdrChange" runat="server" Text="[%Změnit%]" OnClick="RB_AdrChange_Click" CausesValidation="False" Icon-PrimaryIconCssClass="fi fi-user-pen"></wc:TRadButton>
                            <kspwc:TRadComboBox ID="TRCB_AdresatJmeno" runat="server" Visible="false"
                                EnableLoadOnDemand="True"
                                EnableVirtualScrolling="True" Height="150px" ShowMoreResultsBox="True" DropDownAutoWidth="Enabled"
                                AutoPostBack="True"
                                OnClientItemsRequesting="TRCB_AdresatJmeno_ItemsRequesting"
                                OnTextChanged="TRCB_AdresatJmeno_TextChanged" EmptyMessage="[%Jméno%]">
                                <WebServiceSettings Method="JmenoZam2" Path="~/PrivateWebServices/AutoCompleteService.asmx" />
                            </kspwc:TRadComboBox>
                            <telerik:RadTextBox ID="TB_AdresatOsCislo" runat="server" Visible="false"
                                AutoPostBack="True" OnTextChanged="TB_AdresatOsCislo_TextChanged" EmptyMessage="[%Os. číslo%]">
                            </telerik:RadTextBox>
                            <br />
                            <asp:CustomValidator ID="cv_platne_os_cislo" runat="server" ErrorMessage="[%Neplatné osobní číslo nebo neaktivní zaměstnanec%]"
                                ControlToValidate="TB_AdresatOsCislo" OnServerValidate="cv_platne_os_cislo_validate" Display="Dynamic"></asp:CustomValidator>
                        </EditItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="[%Oznámení%]" HeaderStyle-CssClass="hidden" ItemStyle-CssClass="hidden"><%----%>
                        <EditItemTemplate>
                            <asp:Label ID="Lab_oznam_jmena" runat="server" Text=""></asp:Label>
                        </EditItemTemplate>
                    </asp:TemplateField>
                </Fields>
                <%--<FooterTemplate>
                    <wc:TRadButton ID="RB_ViceInfo" runat="server" Text="[%Řešitel%] .." OnClick="RB_ViceInfo_Click" CausesValidation="True"></wc:TRadButton>
                </FooterTemplate>--%>
            </wc:TDetailsView>
        </asp:Panel>
        <%-- OnClientShow="setCustomPosition"--%>
        <telerik:RadWindow ID="DiskusePopup" runat="server" Title="[%Diskusní příspěvek%]" Modal="true" Behaviors="Close,Resize,Move" AutoSize="true"
            AutoSizeBehaviors="Width,Height" KeepInScreenBounds="true" DestroyOnClose="false" VisibleStatusbar="false">
            <ContentTemplate>
                <asp:Panel ID="PanelDiskuse" runat="server" Visible="false" Width="400px">
                    <asp:ObjectDataSource ID="dsDiskuse" runat="server" OldValuesParameterFormatString="original_{0}"
                        SelectMethod="RetrieveDummyDiskuse" TypeName="KSProgram.Pozadavky.WorkflowProces"
                        UpdateMethod="KrokProcesuDiskuseTrans">
                        <UpdateParameters>
                            <asp:Parameter Name="id_poz" Type="Int32" />
                            <asp:Parameter Name="duvod" Type="String" />
                            <asp:Parameter Name="adresat" Type="Decimal" />
                            <asp:Parameter Name="adresat_txt" Type="String" />
                        </UpdateParameters>
                        <SelectParameters>
                            <asp:Parameter Name="id_poz" Type="Int32" />
                        </SelectParameters>
                    </asp:ObjectDataSource>
                    <br />
                    <wc:TDetailsView ID="DetailsViewDiskuse" runat="server" AutoGenerateRows="False" Width="100%"
                        DataSourceID="dsDiskuse" DefaultMode="Edit" HeaderText=""
                        Height="50px" OnItemCommand="DetailsViewDiskuse_ItemCommand" OnItemUpdated="DetailsViewDiskuse_ItemUpdated">
                        <Fields>
                            <asp:TemplateField HeaderText="[%Text%]" HeaderStyle-Width="80">
                                <EditItemTemplate>
                                    <telerik:RadTextBox ID="TextBoxDiskuse_e" AutoPostBack="false" runat="server" Height="150px" TextMode="MultiLine"
                                        Width="100%" Text='<%# Bind("duvod") %>' MaxLength="999" CausesValidation="true">
                                    </telerik:RadTextBox>
                                    <br />
                                </EditItemTemplate>
                                <InsertItemTemplate>
                                    <telerik:RadTextBox ID="TextBoxDiskuse_i" runat="server"></telerik:RadTextBox>
                                    <br />                         
                                </InsertItemTemplate>
                                <ItemTemplate>
                                    <asp:Label ID="Label1_item" runat="server"></asp:Label>
                                </ItemTemplate>
                            </asp:TemplateField>
                            <asp:TemplateField HeaderText="[%Oznámení%]">
                                <EditItemTemplate>
                                    <span id="span_adr_jmena">
                                        <asp:Label ID="Lab_diskuse_adresati_jmena" runat="server" Text='<%# Eval("adresat_jmena") %>'></asp:Label>
                                    </span>
                                    <asp:HiddenField ID="HF_diskuse_adresat_txt" runat="server" Value='<%# Bind("adresat_txt") %>' />
                                    <%--OnClick="RB_AdrChange_Click"--%>
                                    <%-- ontextchanged="TRCB_AdresatJmeno_TextChanged"--%>
                                    <wc:TRadButton ID="RB_DiskAdrChange" CausesValidation="false" runat="server" Text="[%Změnit%]" AutoPostBack="false" OnClientClicked="adrChange" Icon-PrimaryIconCssClass="fi fi-user-pen"></wc:TRadButton>
                                    <kspwc:TRadComboBox ID="TRCB_DiskuseAdresatJmeno" runat="server"
                                        OnClientSelectedIndexChanged="TRCB_DiskuseAdresatJmeno_onClientSelectedIndexChanged"
                                        EnableLoadOnDemand="True"
                                        EnableVirtualScrolling="True"
                                        Height="150px" ShowMoreResultsBox="True" DropDownAutoWidth="Enabled"
                                        AutoPostBack="False" 
                                        OnClientItemsRequesting="TRCB_AdresatJmeno_ItemsRequesting"
                                        CausesValidation="false"
                                        EmptyMessage="[%Jméno%]">
                                        <WebServiceSettings Method="JmenoZam2" Path="~/PrivateWebServices/AutoCompleteService.asmx" />
                                    </kspwc:TRadComboBox>
                                    <%-- OnTextChanged="TB_AdresatOsCislo_TextChanged"--%>
                                    <telerik:RadTextBox ID="TB_DiskuseAdresatOsCislo" runat="server" ClientEvents-OnValueChanged="TB_AdresatOsCislo_TextChanged"
                                        AutoPostBack="False" EmptyMessage="[%Os. číslo%]">
                                    </telerik:RadTextBox>
                                    <%-- OnServerValidate="cv_platne_os_cislo_validate"--%>
                                    <asp:CustomValidator ID="cv_diskuse_platne_os_cislo" runat="server" ErrorMessage="[%Neplatné osobní číslo nebo neaktivní zaměstnanec%]" Text="[%Neplatné osobní číslo nebo neaktivní zaměstnanec%]" ClientValidationFunction="cv_platne_os_cislo_validate" ValidateEmptyText="false"
                                        ControlToValidate="TB_DiskuseAdresatOsCislo" Display="Dynamic"></asp:CustomValidator>
                                </EditItemTemplate>
                            </asp:TemplateField>
                        </Fields>
                    </wc:TDetailsView>
                    <asp:Panel runat="server" ID="PanelCommand">
                        <table style="border-collapse: collapse; margin: 5px 0px 0px 0px; width: 100%;">
                            <tr>
                                <td>
                                    <wc:TRadButton ID="img_save_diskusi" runat="server" AutoPostBack="false" CausesValidation="true" Style="margin: 4px;" Text="[%Uložit%]" OnClientClicked="img_save_diskuse_Clicked" Icon-PrimaryIconCssClass="fi fi-disk" />
                                </td>
                            </tr>
                        </table>
                    </asp:Panel>
                </asp:Panel>
            </ContentTemplate>
        </telerik:RadWindow>





         <telerik:RadWindow ID="SlucPolePopup" runat="server" Title="[%Slučovací pole pro šablony emailových notifikací%]" Modal="true"  Behaviors="Close,Move" Width="800" Height="350" DestroyOnClose="false" OnClientShow="sluc_pole_ClientShow" >
            <ContentTemplate>              
                    <kspwc:TRadGrid runat="server" ID="grid_sluc_pole" OnNeedDataSource="grid_sluc_pole_NeedDataSource1" Height="270" >
                        <ClientSettings  >
                             <Scrolling AllowScroll="True" UseStaticHeaders="true" />
                            <ClientEvents />
                           </ClientSettings>
                        <MasterTableView AutoGenerateColumns="false">
                            <Columns>
                                <telerik:GridBoundColumn ReadOnly="true" DataField="Nazev" HeaderText="[%Položka%]">
                                </telerik:GridBoundColumn>
                                <telerik:GridBoundColumn ReadOnly="true" DataField="Hodnota" HeaderText="[%Hodnota%]">
                                </telerik:GridBoundColumn>
                            </Columns>
                        </MasterTableView>
                    </kspwc:TRadGrid>                  
            </ContentTemplate>
        </telerik:RadWindow>




        <asp:Panel runat="server" ID="PanelValidator" Visible="true">
            <%--musí být visible jinak se validator nevyhodnotí--%>
            <table style="border-collapse: collapse; margin: 5px 0px 0px 0px; width: 550px;">
                <tr>
                    <td style="padding: 4px 4px 4px 0px; width: 100%">
                        <asp:CustomValidator ID="CustomValidator1" runat="server" ErrorMessage="CustomValidator"
                            OnServerValidate="CustomValidator1_ServerValidate" Display="Dynamic"></asp:CustomValidator>
                    </td>
                </tr>
            </table>
        </asp:Panel>
    </div>
</asp:Panel>
