﻿<%@ Control Language="C#" AutoEventWireup="true" CodeBehind="ZRZ_MF_2018.ascx.cs" Inherits="KSPortal.Controls.ZRZ_MF_2018" %>
<%@ Register assembly="WebControls" namespace="KSProgram.WebControls" tagprefix="kspwc" %>
<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>

<asp:ObjectDataSource ID="ODS_manzelky" runat="server" TypeName="KSProgram.Pozadavky.pozadavekzroczuct" SelectMethod="GetManzelky" EnableCaching="false">
    <SelectParameters>
        <asp:Parameter Name="osc" DbType="Decimal" />
        <asp:Parameter Name="keDni" DbType="DateTime" />
    </SelectParameters>
</asp:ObjectDataSource>

<asp:ObjectDataSource ID="ODS_deti" runat="server" TypeName="KSProgram.Pozadavky.pozadavekzroczuct" SelectMethod="GetDeti" EnableCaching="false">
    <SelectParameters>
        <asp:Parameter Name="osc" DbType="Decimal" />
        <asp:Parameter Name="keDni" DbType="DateTime" />
    </SelectParameters>
</asp:ObjectDataSource>

<asp:ObjectDataSource ID="ODS_rodprisl" runat="server" TypeName="KSProgram.Pozadavky.pozadavekzroczuct" SelectMethod="GetRodprislNeDeti" EnableCaching="false">
    <SelectParameters>
        <asp:Parameter Name="osc" DbType="Decimal" />
        <asp:Parameter Name="keDni" DbType="DateTime" />
    </SelectParameters>
</asp:ObjectDataSource>

<style type="text/css">
        .HTMLpageOkraj {
            position: relative;
            padding: 5mm;
            width: 193mm;
            height: 279mm;
            border: 1px solid grey;
            background-color: #FFE5E3;
            page-break-after: always;
            page-break-inside: avoid;            
        }

        .HTMLpage {
            direction: ltr;
            padding: 0mm;
            margin: 0mm;
            width: 193mm;
            height: 279mm;
            position: relative;
            /*border: 1px solid red;*/
            font-family: Arial, Helvetica, sans-serif;
            font-size: 3mm;
        }

        .HTMLpage > div {
            position: absolute;
            /*white-space: nowrap;*/
            overflow: hidden;
        }
        .HTMLpage > table {
            position: absolute;
            /*white-space: nowrap;*/
            overflow: hidden;
            padding: 0mm;
            margin: 0mm;
            border-collapse: separate;
            border-spacing: 0mm;
            text-align: left;
            vertical-align: middle;
            font-family: Arial, Helvetica, sans-serif;
            font-size: 3mm;
        }
        .HTMLpage th {
            text-align: center;
            font-weight: normal;
        }
        .HTMLpage td {
            padding: 0mm 1mm 0mm 1mm;
        }
        
        sup {
            font-size: 90%;
            line-height: 50%;
        }

        .roundBorder {
            border: 1px solid black;
            border-radius: 2mm;
        }

        .BorderRadius {
            border-radius: 2mm;
        }

        .BorderTLRadius {
            border-top-left-radius: 2mm;
        }

        .BorderTRRadius {
            border-top-right-radius: 2mm;
        }

        .BorderBLRadius {
            border-bottom-left-radius: 2mm;
        }

        .BorderBRRadius {
            border-bottom-right-radius: 2mm;
        }

        .BorderTL {
            border-top: 1px solid black;
            border-left: 1px solid black;
        }

        .BorderBR {
            border-bottom: 1px solid black;
            border-right: 1px solid black;
        }

        .Border {
            border: 1px solid black;
        }

        .HTMLpage .input
        {   
            box-sizing: border-box;
            -moz-box-sizing: border-box;
            -webkit-box-sizing: border-box;
            border-color:#000000;border-style:solid;border-width:0px;background:#fff;color:black;height:22px;
            font-family:'Segoe UI',Arial,Helvetica,sans-serif; 
            font-size:11px; 
            font-weight:bold;
            vertical-align:middle; /*tímto se srovná bottom-line s RadDropDown*/
        }
        .HTMLpage .input:hover{color:black;border-color:#767676;border-width:1px;}
        .HTMLpage .input:focus{border-color:var(--kscolor1);border-width:1px;}
        .HTMLpage .input:disabled{background-color:gainsboro;color:black;filter: alpha(opacity=50);opacity: 0.5;}
        

        /*telerikovske tridy kvuli vykopirovani casti html do souboru*/
        .HTMLpage .RadDropDownList {
         width:160px;
         line-height:1.3333;
         text-align:left;
         display:inline-block;
         vertical-align:middle;
         white-space:nowrap;
         cursor:default;
         *zoom:1;
         *display:inline
        }
        .HTMLpage .RadDropDownList .rddlInner {
         padding:2px 22px 2px 5px;
         border-width:0px;
         display:block;
         position:relative;
         overflow:hidden;
         background-color:white;
        }
        .HTMLpage .RadDropDownList .rddlFocused {
            color: black;
            border-color:var(--kscolor1);border-width:1px;
        }
        .HTMLpage .RadDropDownList .rddlDisabled {         
            background-color:gainsboro;         
        }

        .HTMLpage .RadDropDownList .rddlInner:hover{border-color:#767676;border-width:1px;}

        .HTMLpage .RadDropDownList .rddlFakeInput {
         margin:0;
         padding:0;
         width:100%;
         min-height:16px;
         display:block;
         overflow:hidden;
         font-weight:bold;
        }
        .HTMLpage .RadDropDownList .rddlIcon {
         width:16px;
         height:100%;
         border:0;
         background-repeat:no-repeat;
         position:absolute;
         top:0;
         right:0
        }        
        .HTMLpage .RadDropDownList .rddlDisabled .rddlIcon {         
         background-image:none;         
        }

        
        /*.RadDropDownList {         
            border-width:0px;border-style:none;
        }*/
        .Pad0>.rddlInner {        
            padding-top:0px; padding-bottom:0px;
        }
        .Pad0>.rddlInner>.rddlFakeInput {        
            min-height:10px;
            line-height:1;
        }

        .Pad0>.rddlInner>.rddlIcon {
            background-position-y: -22px;
        }

        input[type=checkbox] {
            margin-bottom: 0px; margin-top: 0px; height:12px;
        }

        .bottomLine{
            border-bottom: 1px solid black !important; 
            
        }
                
        @media print {
            

            body {
                margin: 0;
                padding: 0;
                width: 193mm;
            }

            .HTMLpageOkraj {
                padding: 0;
                border: none;
                background-color: none;
                page-break-after: always;                
            }

            .HTMLpage {
                /*width: 21%;
            height: 21%;*/
                /*height: 126mm;*/
                padding: 0;
                margin: 0;
                border: none;
                /*transform-origin: left top;
            transform: scale(0.75, 0.75);*/
            }

            .HTMLpage > div {
                /*transform-origin: left top;
                transform: translate(-40mm, -30mm);*/
            }
            .HTMLpage .RadButton {display: none;}

            .HTMLpage .rdllFocused {
                border: none;
            }
            .HTMLpage :disabled.input {
                background-color: none;
                color: black;
                filter: alpha(opacity=100);
                opacity: 1;
            }
            .RadDropDownList .rddlDisabled {
                filter: alpha(opacity=100);
                opacity: 1;
            }
        }
</style>
<span class="tiskHide">
            <asp:CustomValidator runat="server" ID="ValidPre"  OnServerValidate="ValidPre_ServerValidate" ValidationGroup="PreValidace"></asp:CustomValidator>
        </span>
<asp:FormView ID="FormView1" runat="server" CssClass="noclass" OnItemInserted="FormView1_ItemInserted"
    OnItemUpdated="FormView1_ItemUpdated" OnDataBound="FormView1_DataBound" DataSourceID="ObjectDataSource1" OnItemCommand="FormView1_ItemCommand">
    <ItemTemplate>
        
        <div class="HTMLform">
        <div class="HTMLpageOkraj">
        <div class="HTMLpage">

            <div style="left: 41.74px; top: 0px; font-size: 31.6px; width: 660px; text-align: center; font-weight: bold; letter-spacing: 2mm;">ŽÁDOST</div>

            <div style="left: 41.74px; top: 34px; font-size: 18.43px; width: 660px; text-align: center; font-weight: bold;">o roční zúčtování záloh a daňového zvýhodnění</div>
            <div style="left: 41.74px; top: 56px; font-size: 18.43px; width: 660px; text-align: center; font-weight: bold; padding:2px;">
              za zdaňovací období
               <span class="roundBorder" style="position:relative; background-color: white; padding: 1px 8px;">
                 <kspwc:TTextBox ID="H_obd_rok" runat="server" Text='<%# Bind("H_obd_rok") %>' CssClass="input" style="text-align:center;font-size:12px;font-weight:bold;height:21px;vertical-align:top" Width="14mm" MaxLength="4" ReadOnly="true"></kspwc:TTextBox>
               </span>
            </div>

            <div class="roundBorder" style="left: 41.74px; top: 90px; width: 660px; height: 105px; background-color: white;"></div>

            <div style="left: 57.38px; top: 95px; font-size: 10.4px; font-weight: bold;">Identifikace poplatníka</div>
            <div style="left: 57.38px; top: 118px; font-size: 10.4px; ">Příjmení  <kspwc:TTextBox ID="H_prijmeni_pop"	runat="server" Text='<%# Bind("H_prijmeni_pop") %>' Width="40mm" CssClass="input bottomLine"  ReadOnly="true"></kspwc:TTextBox> </div>
            <div style="left: 292px; top: 118px; font-size: 10.4px; ">Jméno(-a)   <kspwc:TTextBox ID="H_jmeno_pop" runat="server" Text='<%# Bind("H_jmeno_pop") %>' Width="35mm" CssClass="input bottomLine"  ReadOnly="true"></kspwc:TTextBox>    </div>
            <div style="left: 499.29px; top: 118px; font-size: 10.4px; ">Rodné číslo  <kspwc:TTextBox ID="H_rc_pop"	runat="server" Text='<%# Bind("H_rc_pop") %>' Width="35mm" CssClass="input bottomLine"  ReadOnly="true"></kspwc:TTextBox></div>
            <div style="left: 499.29px; top: 142px; font-size: 10.4px; ">příp. datum narození <kspwc:TTextBox ID="H_datNar_pop"	runat="server" Text='<%# Bind("H_datNar_pop","{0:d}") %>' Width="20mm" CssClass="input bottomLine" ReadOnly="true" MaxLength="10"></kspwc:TTextBox></div>
            <div style="left: 57.38px; top: 149px; font-size: 10.4px; font-weight: bold;">Identifikace plátce daně (název)</div>
            <div style="left: 57.38px; top: 170px; font-size: 10.4px; "><kspwc:TTextBox ID="H_nazev_pl"	runat="server" Text='<%# Bind("H_nazev_pl") %>' Width="165mm" CssClass="input bottomLine" ReadOnly="True"></kspwc:TTextBox></div>

            
            <div style="left: 41.74px; top: 203px; width:650px; height: 40px; font-size: 10.4px; text-align: justify;">
            V souladu s § 38ch a § 35d zákona č. 586/1992 Sb., o daních z příjmů, ve znění pozdějších předpisů (dále jen „zákon“) žádám o pro-
            vedení ročního zúčtování záloh na daň a daňového zvýhodnění za uvedené zdaňovací období a současně prohlašuji, <b>že za uvedené</b>  
            <b>zdaňovací období nejsem povinen(-na) podat přiznání k dani z příjmů fyzických osob.</b></div>

            <div style="left: 41.71px; top: 250px; font-size: 10.4px; "><b>Uvádím, že jsem v uvedeném zdaňovacím období pobíral(-a) příjmy ze závislé činnosti od těchto předchozích plátců daně <sup>1)</sup></b></div>

            <table class="BorderBR BorderRadius" style="left: 41.71px; top: 265px; width: 660px; height: 80px;">
                <tr>
                    <th class="BorderTL BorderTLRadius" style="width: 18%; height: auto">V kalendářních<br/> měsících</th>
                    <th class="BorderTL BorderTRRadius">Identifikace předchozích plátců daně</th>
                </tr>
                <tr style="background-color: white;">                    
                    <td class="BorderTL"> <kspwc:TTextBox ID="P1_mes"	runat="server" Text='<%# Bind("P1_mes") %>' MaxLength="10" Width="26mm" Height="5mm"></kspwc:TTextBox> </td>
                    <td class="BorderTL"> <kspwc:TTextBox ID="P1_nazev"	runat="server" Text='<%# Bind("P1_nazev") %>' MaxLength="250"  Width="140mm" Height="5mm"></kspwc:TTextBox> </td>
                </tr>
                <tr style="background-color: white;">                    
                    <td class="BorderTL"> <kspwc:TTextBox ID="P2_mes"	runat="server" Text='<%# Bind("P2_mes") %>' MaxLength="10" Width="26mm" Height="5mm"></kspwc:TTextBox> </td>
                    <td class="BorderTL"> <kspwc:TTextBox ID="P2_nazev"	runat="server" Text='<%# Bind("P2_nazev") %>' MaxLength="250"  Width="140mm" Height="5mm"></kspwc:TTextBox> </td>
                </tr>
                <tr style="background-color: white;">                    
                    <td class="BorderTL"> <kspwc:TTextBox ID="P3_mes"	runat="server" Text='<%# Bind("P3_mes") %>' MaxLength="10" Width="26mm" Height="5mm"></kspwc:TTextBox> </td>
                    <td class="BorderTL"> <kspwc:TTextBox ID="P3_nazev"	runat="server" Text='<%# Bind("P3_nazev") %>' MaxLength="250"  Width="140mm" Height="5mm"></kspwc:TTextBox> </td>
                </tr>
                <tr style="background-color: white;">
                    <td class="BorderTL BorderBLRadius"> <kspwc:TTextBox ID="P4_mes"	runat="server" Text='<%# Bind("P4_mes") %>' MaxLength="10" Width="26mm" Height="5mm"></kspwc:TTextBox> </td>                    
                    <td class="BorderTL BorderBRRadius"> <kspwc:TTextBox ID="P4_nazev"	runat="server" Text='<%# Bind("P4_nazev") %>' MaxLength="250" Width="140mm" Height="5mm"></kspwc:TTextBox> </td>
                </tr>
            </table>
            <div style="left: 42px; top: 375.71px; font-size: 5.76px; ">1)</div>
            <div style="left: 49.47px; top: 375.27px; font-size: 9.88px; font-style:italic; width:650px; text-align: justify;">
            vyplňuje se pouze v případě, že poplatník pobíral od předchozích plátců daně (u kterých učinil prohlášení k dani) postupně příjmy, které vstupují 
            do ročního zúčtování záloh a daňového zvýhodnění, včetně mezd zúčtovaných nebo vyplacených poplatníkovi těmito plátci dodatečně v době, kdy 
            poplatník pro ně již nevykonával činnost, kromě příjmů zdanitelných srážkou podle zvláštní sazby daně a kromě příjmů, které nejsou předmětem daně
            nebo jsou od daně osvobozeny (§ 38ch odst. 4 zákona)
            </div>

            <div style="left: 41.71px; top: 433.25px; font-size: 10.4px; font-weight: bold; width:650px; text-align: justify;">
            Kromě nároku na slevy na dani a nároku na daňové zvýhodnění uplatněného v Prohlášení poplatníka daně z příjmů fyzických
            osob ze závislé činnosti učiněného podle § 38k odst. 4, případně odst. 7 zákona, uplatňuji za výše uvedené zdaňovací období
            nárok na:</div>

            <div style="left: 41.71px; top: 474.68px; font-size: 15.8px; width: 660px; text-align: center; font-weight: bold;">SLEVY NA DANI</div>
            <div style="left: 41.71px; top: 496.33px; font-size: 10.4px; width:650px; text-align: justify;">
            <b>Slevu na manžela (manželku)</b> podle § 35ba odst. 1 písm. b) zákona, který (která) se mnou žil (žila) v uvedeném zdaňovacím období ve 
            společně hospodařící domácnosti a neměl (neměla) v tomto zdaňovacím období vlastní příjem přesahující 68 000 Kč</div>

            <table class="BorderBR BorderRadius" style="left: 41.71px; top: 530px; width: 660px; height: 62px;">
                <tr>
                    <th class="BorderTL BorderTLRadius" style="width: 20%">Jméno(-a)</th>
                    <th class="BorderTL">Příjmení <br/>(manžela/manželky)</th>
                    <th class="BorderTL">Rodné číslo</th>
                    <th class="BorderTL">Nárok <br/>splněn za <sup>2)</sup></th>
                    <th class="BorderTL">ZTP/P<sup>3)</sup></th>
                    <th class="BorderTL BorderTRRadius">Nárok <br/>splněn za <sup>3a)</sup></th>
                </tr>
                <tr style="background-color: white;">
                    <td class="BorderTL BorderBLRadius"> 
                        <kspwc:TTextBox ID="M_jmeno"	runat="server" Text='<%# Bind("M_jmeno") %>' MaxLength="40" Width="22mm" ReadOnly="true" ToolTip="[%Použij nabídku napravo%]"></kspwc:TTextBox> 
                        <telerik:RadDropDownList ID="DDL_manzelka" runat="server" CssClass="Pad0" Width="8mm" Height="5mm" 
                            DataValueField="rc" DataTextField="cele_jmeno" DropDownWidth="80mm" 
                            OnSelectedIndexChanged="DDL_manzelka_SelectedIndexChanged" AutoPostBack="true" ForeColor="White" ToolTip="[%Chybí osoba?%] [%Požádej o doplnění přes požadavek žádost o změnu osobních údajů.%]">
                        </telerik:RadDropDownList>
                    </td>
                    <td class="BorderTL"> <kspwc:TTextBox ID="M_prijmeni"	runat="server" Text='<%# Bind("M_prijmeni") %>' MaxLength="40" Width="51mm" ReadOnly="true"></kspwc:TTextBox> </td>
                    <td class="BorderTL"> <kspwc:TTextBox ID="M_rc"	runat="server" Text='<%# Bind("M_rc") %>' MaxLength="10" Width="24mm" ReadOnly="true"></kspwc:TTextBox> </td>
                    <td class="BorderTL"> <kspwc:TTextBox ID="M_mes"	runat="server" Text='<%# Bind("M_mes") %>' MaxLength="10" Width="15mm"></kspwc:TTextBox> </td>
                    <td class="BorderTL"> 
                        <telerik:RadDropDownList ID="M_ztp"	runat="server" SelectedValue='<%# Bind("M_ztp") %>' Width="16mm">
                            <Items>
                                <telerik:DropDownListItem Value="" Text="" />
                                <telerik:DropDownListItem Value="X" Text="X" />
                            </Items>
                        </telerik:RadDropDownList>
                    </td>
                    <td class="BorderTL BorderBRRadius"> <kspwc:TTextBox ID="M_ztp_mes"	runat="server" Text='<%# Bind("M_ztp_mes") %>' MaxLength="10" Width="20mm"></kspwc:TTextBox> </td>
                </tr>
            </table>

            <div style="left: 41.71px; top: 596.35px; font-size: 5.76px; font-style:italic;">2) </div>
            <div style="left: 53.56px; top: 595.91px; font-size: 9.88px; font-style:italic;">uveďte kalendářní měsíce, ve kterých byly splněny podmínky pro uplatnění této slevy na dani, např. 9 - 12</div>
            <div style="left: 41.71px; top: 606.89px; font-size: 5.76px; font-style:italic;">3) </div>
            <div style="left: 53.56px; top: 606.45px; font-size: 9.88px; font-style:italic;">označte „X“ pokud byl manželovi (manželce) přiznán nárok na průkaz ZTP/P </div>
            <div style="left: 41.71px; top: 617.42px; font-size: 5.76px; font-style:italic;">3a) </div>
            <div style="left: 53.56px; top: 616.98px; font-size: 9.88px; font-style:italic;">uveďte kalendářní měsíce, ve kterých jsou splněny podmínky pro dvojnásobnou výši této slevy na dani (z titulu průkazu ZTP/P), např. 9 - 12</div>

            <div style="left: 41.71px; top: 650.45px; font-size: 10.4px; width:650px; text-align: justify;">
            <b>Slevu za umístění dítěte</b> v předškolním zařízení podle § 35ba odst. 1 písm. g) zákona, na dítě (děti) které se mnou žilo (žily) v uvedeném
            zdaňovacím období v mé společně hospodařící domácnosti</div>

            <table class="BorderBR BorderRadius" style="left: 41.71px; top: 683px; width: 660px; height: 82px;">
                <tr>
                    <th class="BorderTL BorderTLRadius" style="width: 20%">Jméno(-a)</th>
                    <th class="BorderTL">Příjmení <br/>(dítěte)</th>
                    <th class="BorderTL">Rodné číslo</th>
                    <th class="BorderTL BorderTRRadius">Vynaložená částka (v Kč)</th>
                </tr>
               <tr style="background-color: white;">
                    <td class="BorderTL"> 
                        <kspwc:TTextBox ID="D1_jmeno"	runat="server" Text='<%# Bind("D1_jmeno") %>' MaxLength="40" Width="22mm" ReadOnly="true" ToolTip="Použij nabídku napravo"></kspwc:TTextBox> 
                        <telerik:RadDropDownList ID="DDL_dite1" runat="server" CssClass="Pad0" Width="8mm" Height="5mm" 
                            DataValueField="rc" DataTextField="cele_jmeno" DropDownWidth="80mm" 
                            OnSelectedIndexChanged="DDL_dite_SelectedIndexChanged" AutoPostBack="true" ForeColor="White" ToolTip="[%Chybí dítě?%] [%Požádej o doplnění přes požadavek žádost o změnu osobních údajů.%]">
                        </telerik:RadDropDownList>
                    </td>
                    <td class="BorderTL"> <kspwc:TTextBox ID="D1_prijmeni"	runat="server" Text='<%# Bind("D1_prijmeni") %>' MaxLength="40" Width="38mm" ReadOnly="true"></kspwc:TTextBox> </td>
                    <td class="BorderTL"> <kspwc:TTextBox ID="D1_rc"	runat="server" Text='<%# Bind("D1_rc") %>' MaxLength="10" Width="34mm" ReadOnly="true"></kspwc:TTextBox> </td>
                    <td class="BorderTL"> <kspwc:TTextBox ID="D1_castka"	runat="server" Text='<%# Bind("D1_castka") %>' MaxLength="10" Width="60mm"></kspwc:TTextBox> </td>
                </tr>
                <tr style="background-color: white;">
                    <td class="BorderTL BorderBLRadius"> 
                        <kspwc:TTextBox ID="D2_jmeno"	runat="server" Text='<%# Bind("D2_jmeno") %>' MaxLength="40" Width="22mm" ReadOnly="true"></kspwc:TTextBox> 
                        <telerik:RadDropDownList ID="DDL_dite2" runat="server" CssClass="Pad0" Width="8mm" Height="5mm" 
                            DataValueField="rc" DataTextField="cele_jmeno" DropDownWidth="80mm" 
                            OnSelectedIndexChanged="DDL_dite_SelectedIndexChanged" AutoPostBack="true" ForeColor="White">
                        </telerik:RadDropDownList>
                    </td>
                    <td class="BorderTL"> <kspwc:TTextBox ID="D2_prijmeni"	runat="server" Text='<%# Bind("D2_prijmeni") %>' MaxLength="40" Width="38mm" ReadOnly="true"></kspwc:TTextBox> </td>
                    <td class="BorderTL"> <kspwc:TTextBox ID="D2_rc"	runat="server" Text='<%# Bind("D2_rc") %>' MaxLength="10" Width="34mm" ReadOnly="true"></kspwc:TTextBox> </td>
                    <td class="BorderTL BorderBRRadius"> <kspwc:TTextBox ID="D2_castka"	runat="server" Text='<%# Bind("D2_castka") %>' MaxLength="10" Width="60mm"></kspwc:TTextBox> </td>
                </tr>
            </table>

            <div style="left: 41.71px; top: 773.54px; font-size: 10.4px; "><b>Zároveň prohlašuji</b>, že na výše uvedené dítě (děti) neuplatňuje tuto slevu jiný poplatník žijící v téže společně hospodařící domácnosti</div>

            <div style="left: 41.71px; top: 805.59px; font-size: 15.8px; width: 660px; text-align: center; font-weight: bold;">NEZDANITELNÉ ČÁSTI ZÁKLADU DANĚ</div>
            
            <table class="BorderBR BorderRadius" style="left: 41.71px; top: 828px; width: 660px; height: 171px;">
                <tr>
                    <th class="BorderTL BorderTLRadius" style="width: 17%">Uplatňuji<sup>4)</sup></th>
                    <th class="BorderTL">Nezdanitelné části základu daně podle § 15 zákona</th>
                    <th class="BorderTL BorderTRRadius" style="width: 17%">Uplatňovaná částka<br/> (v Kč)</th>
                </tr>
               <tr style="background-color: white;">
                    <td class="BorderTL">
                        <telerik:RadDropDownList ID="N_dar_x"	runat="server" SelectedValue='<%# Bind("N_dar_x") %>' Width="27mm">
                            <Items>
                                <telerik:DropDownListItem Value="" Text="" />
                                <telerik:DropDownListItem Value="X" Text="X" />
                            </Items>
                        </telerik:RadDropDownList></td>
                    <td class="BorderTL">Bezúplatná plnění - dary (odst. 1)</td>
                    <td class="BorderTL"> <kspwc:TTextBox ID="N_dar_c"	runat="server" Text='<%# Bind("N_dar_c") %>' MaxLength="10" Width="27mm"></kspwc:TTextBox> </td>
                </tr>
               <tr style="background-color: white;">
                    <td class="BorderTL">
                        <telerik:RadDropDownList ID="N_uroky_x"	runat="server" SelectedValue='<%# Bind("N_uroky_x") %>' Width="27mm">
                            <Items>
                                <telerik:DropDownListItem Value="" Text="" />
                                <telerik:DropDownListItem Value="X" Text="X" />
                            </Items>
                        </telerik:RadDropDownList>
                    </td>
                    <td class="BorderTL">Úroky z úvěru na financování bytových potřeb (odst. 3 a 4)</td>
                    <td class="BorderTL"> <kspwc:TTextBox ID="N_uroky_c"	runat="server" Text='<%# Bind("N_uroky_c") %>' MaxLength="10" Width="27mm"></kspwc:TTextBox> </td>
                </tr>
               <tr style="background-color: white;">
                    <td class="BorderTL">
                        <telerik:RadDropDownList ID="N_penz_x"	runat="server" SelectedValue='<%# Bind("N_penz_x") %>' Width="27mm">
                            <Items>
                                <telerik:DropDownListItem Value="" Text="" />
                                <telerik:DropDownListItem Value="X" Text="X" />
                            </Items>
                        </telerik:RadDropDownList>
                    </td>
                    <td class="BorderTL">Penzijní připojištění nebo penzijní pojištění nebo doplňkové penzijní spoření (odst. 5)</td>
                    <td class="BorderTL"> <kspwc:TTextBox ID="N_penz_c"	runat="server" Text='<%# Bind("N_penz_c") %>' MaxLength="10" Width="27mm"></kspwc:TTextBox> </td>
                </tr>
               <tr style="background-color: white;">
                    <td class="BorderTL">
                        <telerik:RadDropDownList ID="N_zivp_x"	runat="server" SelectedValue='<%# Bind("N_zivp_x") %>' Width="27mm">
                            <Items>
                                <telerik:DropDownListItem Value="" Text="" />
                                <telerik:DropDownListItem Value="X" Text="X" />
                            </Items>
                        </telerik:RadDropDownList>
                    </td>
                    <td class="BorderTL">Pojistné na soukromé životní pojištění (odst. 6)</td>
                    <td class="BorderTL"> <kspwc:TTextBox ID="N_zivp_c"	runat="server" Text='<%# Bind("N_zivp_c") %>' MaxLength="10" Width="27mm"></kspwc:TTextBox> </td>
                </tr>
               <tr style="background-color: white;">
                    <td class="BorderTL">
                        <telerik:RadDropDownList ID="N_odbp_x"	runat="server" SelectedValue='<%# Bind("N_odbp_x") %>' Width="27mm">
                            <Items>
                                <telerik:DropDownListItem Value="" Text="" />
                                <telerik:DropDownListItem Value="X" Text="X" />
                            </Items>
                        </telerik:RadDropDownList>
                    </td>
                    <td class="BorderTL">Členské příspěvky člena odborové organizace (odst. 7)</td>
                    <td class="BorderTL"> <kspwc:TTextBox ID="N_odbp_c"	runat="server" Text='<%# Bind("N_odbp_c") %>' MaxLength="10" Width="27mm"></kspwc:TTextBox> </td>
                </tr>
                <tr style="background-color: white;">
                    <td class="BorderTL BorderBLRadius">
                        <telerik:RadDropDownList ID="N_zkouska_x"	runat="server" SelectedValue='<%# Bind("N_zkouska_x") %>' Width="27mm">
                            <Items>
                                <telerik:DropDownListItem Value="" Text="" />
                                <telerik:DropDownListItem Value="X" Text="X" />
                            </Items>
                        </telerik:RadDropDownList>
                    </td>
                    <td class="BorderTL">Úhrada za zkoušky ověřující výsledky dalšího vzdělávání (odst. 8)<sup>4a)</sup></td>
                    <td class="BorderTL BorderBRRadius"> <kspwc:TTextBox ID="N_zkouska_c"	runat="server" Text='<%# Bind("N_zkouska_c") %>' MaxLength="10" Width="27mm"></kspwc:TTextBox> </td>
                </tr>
            </table>

            <div style="left: 41.71px; top: 1008.14px; font-size: 5.76px; font-style:italic;">4)</div>
            <div style="left: 53.56px; top: 1007.71px; font-size: 9.88px; font-style:italic;">označte „X“ nezdanitelnou část základu daně, kterou uplatňujete</div>
            <div style="left: 41.71px; top: 1018.68px; font-size: 5.76px; font-style:italic;">4a)</div>
            <div style="left: 53.56px; top: 1018.24px; font-size: 9.88px; font-style:italic;">podle zákona č. 179/2006 Sb., o ověřování a uznávání výsledků dalšího vzdělávání a o změně některých zákonů</div>

            <div style="left: 41.84px; top: 1038.16px; font-size: 7.9px; ">25  5457/B  MFin  5457/B  -  vzor č.  1</div>
            <div style="left: 364.24px; top: 1038.17px; font-size: 7.9px; ">1</div>
        </div>
    </div>
    <span class="tiskHide">
        <asp:CustomValidator runat="server" ID="ValidPg1"  OnServerValidate="ValidPg1_ServerValidate" ></asp:CustomValidator>
    </span>
    <div class="HTMLpageOkraj">
        <div class="HTMLpage">
            <div style="left: 24.6px; top: 3.86px; font-size: 10.4px; font-weight: bold;">Prohlášení poplatníka podle § 38k odst. 5 písm. e) zákona k nezdanitelné části základu daně podle § 15 odst. 3 a 4 zákona:</div>
            <div style="left: 24.6px; top: 20.82px; font-size: 10.4px; ">odpočet úroků ze základu daně, na které uplatňuji nárok z důvodu zaplacených úroků z úvěru použitého na financování bytových potřeb ze</div>
            <div style="left: 24.6px; top: 33.99px; font-size: 10.4px; ">stavebního spoření, úroků z hypotečního úvěru anebo z jiného úvěru poskytnutého v souvislosti s těmito úvěry, poskytovatelem stavebního</div>
            <div style="left: 24.6px; top: 47.15px; font-size: 10.4px; ">spoření, bankou, za uvedené zdaňovací období <b>neuplatňuje</b> jiná osoba / <b>uplatňují</b> tyto osoby: <sup>4b)</sup></div>

            <table class="BorderBR BorderRadius" style="left: 24.6px; top: 71px; width: 660px; height: 70px;">
                <tr>
                    <th class="BorderTL BorderTLRadius" style="width: 20%">Jméno(-a)</th>
                    <th class="BorderTL" style="width: 25%">Příjmení</th>
                    <th class="BorderTL" style="width: 20%">Rodné číslo</th>
                    <th class="BorderTL BorderTRRadius">Adresa bydliště (místo trvalého pobytu)</th>
                </tr>
               <tr style="background-color: white;">
                    <td class="BorderTL"> 
                        <kspwc:TTextBox ID="U1_jmeno" runat="server" Text='<%# Bind("U1_jmeno") %>' MaxLength="40" Width="22mm"></kspwc:TTextBox> 
                        <telerik:RadDropDownList ID="DDL_rodprisl1" runat="server" CssClass="Pad0" Width="8mm" Height="5mm" 
                            DataValueField="rc" DataTextField="cele_jmeno" DropDownWidth="80mm" 
                            OnSelectedIndexChanged="DDL_rodprisl_SelectedIndexChanged" AutoPostBack="true" ForeColor="White">
                        </telerik:RadDropDownList>
                    </td>
                    <td class="BorderTL"> <kspwc:TTextBox ID="U1_prijmeni" runat="server" Text='<%# Bind("U1_prijmeni") %>' MaxLength="40" Width="41mm"></kspwc:TTextBox> </td>
                    <td class="BorderTL"> <kspwc:TTextBox ID="U1_rc" runat="server" Text='<%# Bind("U1_rc") %>' MaxLength="10" Width="32mm"></kspwc:TTextBox> </td>
                    <td class="BorderTL"> <kspwc:TTextBox ID="U1_adresa" runat="server" Text='<%# Bind("U1_adresa") %>' MaxLength="60" Width="60mm"></kspwc:TTextBox> </td>
                </tr>
                <tr style="background-color: white;">
                    <td class="BorderTL BorderBLRadius"> 
                        <kspwc:TTextBox ID="U2_jmeno" runat="server" Text='<%# Bind("U2_jmeno") %>' MaxLength="40" Width="22mm"></kspwc:TTextBox> 
                        <telerik:RadDropDownList ID="DDL_rodprisl2" runat="server" CssClass="Pad0" Width="8mm" Height="5mm" 
                            DataValueField="rc" DataTextField="cele_jmeno" DropDownWidth="80mm" 
                            OnSelectedIndexChanged="DDL_rodprisl_SelectedIndexChanged" AutoPostBack="true" ForeColor="White">
                        </telerik:RadDropDownList>
                    </td>
                    <td class="BorderTL"> <kspwc:TTextBox ID="U2_prijmeni" runat="server" Text='<%# Bind("U2_prijmeni") %>' MaxLength="40" Width="41mm"></kspwc:TTextBox> </td>
                    <td class="BorderTL"> <kspwc:TTextBox ID="U2_rc" runat="server" Text='<%# Bind("U2_rc") %>' MaxLength="10" Width="32mm"></kspwc:TTextBox> </td>
                    <td class="BorderTL BorderBRRadius"> <kspwc:TTextBox ID="U2_adresa" runat="server" Text='<%# Bind("U2_adresa") %>' MaxLength="60" Width="60mm"></kspwc:TTextBox> </td>
                </tr>
            </table>

            <div style="left: 25.72px; top: 146.44px; font-size: 5.76px; font-style:italic;">4b) </div>
            <div style="left: 35.64px; top: 146px; font-size: 9.88px; font-style:italic;">tabulku vyplňte pouze v případě, že úroky uplatňuje i jiná osoba/osoby</div>

            <div style="left: 24.6px; top: 168.63px; width: 660px; text-align:justify; font-size: 10.4px; ">
            Prohlašuji, že předmět bytové potřeby podle § 15 odst. 3 zákona, na který uplatňuji odpočet úroků z poskytnutého úvěru, byl užíván v sou-
            ladu s § 15 odst. 4 zákona, a že částka úroků, o kterou si snižuji základ daně podle § 15 odst. 3 a 4 zákona v úhrnu u všech účastníků
            smluv o úvěrech žijících se mnou ve společně hospodařící domácnosti nepřekročila v uplynulém zdaňovacím období částku 300 000 Kč.
            Při placení úroků jen po část roku uplatňovaná částka nepřekročila jednu dvanáctinu této maximální částky za každý měsíc placení úroků.
            </div>

            <div style="left: 24.6px; top: 225.09px; font-size: 10.4px; font-weight: bold;">Uveďte místo (adresu), kde se nachází bytová potřeba, na kterou byl úvěr poskytnut:</div>
            <div class="roundBorder" style="left: 24.61px; top: 243px; width: 660px; height: 20px; background-color: white;">
                 <kspwc:TTextBox ID="U_byt_adresa" runat="server" Text='<%# Bind("U_byt_adresa") %>' MaxLength="150" Width="659px"></kspwc:TTextBox>
            </div>

            <div style="left: 24.6px; top: 280.23px; width: 660px; text-align: center; font-size: 15.8px; font-weight: bold;">Podpisová část</div>
            <div style="left: 24.6px; top: 301.44px; width: 660px; font-size: 10.4px;">
                Potvrzuji pravdivost a úplnost údajů uvedených v této žádosti o roční zúčtování záloh a daňového zvýhodnění a prokazuji je příslušnými
                doklady  podle  §  38l  zákona.
            </div>

            <div style="left: 24.6px; top: 346.95px; width: 660px; text-align: justify; font-size: 10.4px;">
            Prohlašuji, že jsem si vědom(-a) skutečnosti, že případný rozdíl z nesprávně sražené daně z příjmů fyzických osob ze závislé činnosti,
            případně neoprávněně vyplacená částka na daňovém bonusu z poskytnutého daňového zvýhodnění, který(-á) vznikl(-a) mým zaviněním,
            mi bude v plné výši včetně úroku z prodlení sražen(-a) na základě dohody s plátcem daně (§ 38i odst. 5 písm. a) zákona). V případě,
            že k dohodě s plátcem daně o sražení dlužné částky nedojde, bude vzniklý rozdíl v souladu s § 38i odst. 5 písm. b) zákona vybrán
            správcem daně prostřednictvím daňového přiznání podle § 38g odst. 5 zákona.
            </div>

            <div style="left: 24.6px; top: 429.82px; font-size: 10.4px; font-weight: bold;">Současně žádám v souladu s § 38k odst. 7 zákona o dodatečné uplatnění slev na dani / daňového zvýhodnění</div>
            <div class="roundBorder" style="left: 582px; top: 425px; width: 60px; height: 20px; background-color: white;">
                <telerik:RadDropDownList ID="H_dod_priz"	runat="server" SelectedValue='<%# Bind("H_dod_priz") %>' Width="60px" ToolTip="Vyplňte i prohlášení daně s volbou dodatečně činím!">
                    <Items>
                        <telerik:DropDownListItem Value="" Text="" />
                        <telerik:DropDownListItem Value="X" Text="X" />
                    </Items>
                </telerik:RadDropDownList>
            </div>
            <div style="left: 645px; top: 422.39px; font-size: 6.14px; ">5)</div>
            
            <table class="BorderBR BorderRadius" style="left: 24.6px; top: 460px; width: 660px; height: 85px;">
                <tr>
                    <th class="BorderTL BorderTLRadius" style="width: 31%; height: 56%;"></th>
                    <th class="BorderTL" style="width: 35%">Žádost o roční zúčtování záloh a daňového<br />zvýhodnění učiněná<sup>6)</sup><br />(písemně, elektronicky) a datum</th>
                    <th class="BorderTL BorderTRRadius">Ověření plátcem daně<sup>7)</sup><br />(písemně, elektronicky) a datum</th>
                </tr>
                <tr style="background-color: white;">
                    <td class="BorderTL BorderBLRadius" style="text-align: center">Za uvedené zdaňovací období</td>
                    <td class="BorderTL">
                        <kspwc:TTextBox ID="P_zad_kod" runat="server" Text='<%# Bind("P_zad_kod") %>' Width="30mm" ReadOnly="True"></kspwc:TTextBox>
                        <kspwc:TTextBox ID="P_d_zadosti" runat="server" Text='<%# Bind("P_d_zadosti","{0:d}") %>' Width="16mm" ReadOnly="True"></kspwc:TTextBox>
                        <telerik:RadButton ID="btn_podepsat" runat="server" Text="[%Podepsat%]" CommandName="podp_bezne_popl" Font-Size="2.75mm"></telerik:RadButton>
                    </td>
                    <td class="BorderTL BorderBRRadius">
                        <kspwc:TTextBox ID="P_over_kod" runat="server" Text='<%# Bind("P_over_kod") %>' Width="30mm" ReadOnly="True"></kspwc:TTextBox>
                        <kspwc:TTextBox ID="P_d_over" runat="server" Text='<%# Bind("P_d_over","{0:d}") %>' Width="16mm" ReadOnly="True"></kspwc:TTextBox>
                        <telerik:RadButton ID="btn_overeno" runat="server" Text="[%Podepsat%]" CommandName="podp_bezne_over" Font-Size="2.75mm"></telerik:RadButton>
                    </td>
                </tr>
            </table>

            <div style="left: 24.6px; top: 551.78px; font-size: 5.76px; font-style:italic;">5)</div>
            <div style="left: 33.19px; top: 551.34px; width: 650px; text-align: justify; font-size: 9.4px; font-style:italic;">
            v případě, že v souladu s § 38k odst. 7 zákona uplatňujete slevy na dani podle § 35ba odst. 1 písm. a,c,d,e,f) příp. daňové zvýhodnění dodatečně
            v rámci žádosti o roční zúčtování záloh a daňového zvýhodnění, pak označte „X“ a pro uplatnění použijte tiskopis Prohlášení poplatníka daně z příjmů
            fyzických osob ze závislé činnosti na příslušné zdaňovací období a postupujte při vyplnění dle „upozornění“ na str. 2 tohoto tiskopisu MFin 5457 
            </div>
            
            <div style="left: 24.6px; top: 585.25px; font-size: 5.76px; font-style:italic;">6) </div>
            <div style="left: 33.19px; top: 584.81px; font-size: 9.4px; font-style:italic;">rozumí se projev vůle poplatníka, buď písemně (podpis) nebo elektronicky</div>
            <div style="left: 24.6px; top: 597.65px; font-size: 5.76px; font-style:italic;">7) </div>
            <div style="left: 33.19px; top: 597.21px; font-size: 9.4px; font-style:italic;">plátce daně ověřil nárok na slevy na dani podle § 35ba zákona, nárok na nezdanitelné části základu daně podle § 15 zákona</div>

            <div class="roundBorder" style="left: 24.6px; top: 620px; width: 660px; height: 350px; background-color: white;">
            </div>
            <div style="left: 25.6px; top: 625.26px; width: 658px; text-align: center; font-size: 15.8px; ">
                Další záznamy
                <kspwc:TTextBox ID="H_zaznamy" runat="server" Text='<%# Bind("H_zaznamy") %>' MaxLength="999"  Width="659px" Height="320px" TextMode="MultiLine"></kspwc:TTextBox>
            </div>

            <div style="left: 24.6px; top: 1038.17px; width: 660px; text-align: center; font-size: 7.9px; ">2</div>            
        </div>
    </div>    
        <span class="tiskHide">
            <asp:CustomValidator runat="server" ID="ValidPg2" OnServerValidate="ValidPg2_ServerValidate" ></asp:CustomValidator>
        </span>
        </div>
    </ItemTemplate>
</asp:FormView>