﻿<%@ Control Language="C#" AutoEventWireup="true" Inherits="Controls_ZadostOabsence"
    CodeBehind="ZadostOabsence.ascx.cs" %>
<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>
<telerik:RadFormDecorator ID="QsfFromDecorator" runat="server" DecoratedControls="CheckBoxes,RadioButtons,Select,Textarea,Textbox" EnableRoundedCorners="false" DecorationZoneID="FormView1"/>
<style type="text/css">
    .cisPol
    {
        text-align:right;
    }
    .cisPolSum
    {
        text-align:right;
        font-weight:bold;
    }
     .RadInput .riTextBox, .RadInputMgr{
         padding: 4px !important;
     }
</style>
<telerik:RadCodeBlock runat="server" ID="RadCodeBlock1">
    <script type="text/javascript"> 
        KSMaster.os_cislo;
        KSMaster.cislo_pom;
        KSMaster.msg;
        function keyPress(sender, args) {
            var text = sender.get_value() + args.get_keyCharacter();
            if (!text.match('^[0-9]+$'))
                args.set_cancel(true);
        }           
        function calendar_day_click(sender, args) {
            var den = args.get_renderDay()._date;
            var dates = sender.get_selectedDates();
            var os_cislo = KSMaster.os_cislo;
            var cislo_pom = KSMaster.cislo_pom;           

            var dny = sender.get_selectedDates();
            SendData(KSMaster.idPozadavku, os_cislo, cislo_pom, den, dny);
            if (KSMaster.msg != "") {
                args.set_cancel(true);
                radalert(KSMaster.msg, 300, 200, KSMaster.dict.get('Neplatné zadání'), null, null);             
            }            
        }      
        function SendData(id_pozadavku, os_cislo, cislo_pom, den, dny) {
            KSMaster.msg = "";
            var d = [];
            var item = { "id_pozadavku": id_pozadavku }; d.push(item);
            item = { "os_cislo": os_cislo }; d.push(item);   
            item = { "cislo_pom": cislo_pom }; d.push(item);   
            item = { "den": den }; d.push(item);  
            item = { "dny": dny }; d.push(item);           
            var data_send = JSON.stringify(d);
            $.ajax({
                type: "POST",
                url: KSMaster.baseUrl + "/Controls/ZadostOodmenysl_pom.aspx/TestujaSaveDatesToSession",
                data: "{data:'" + data_send + "'}",
                async: false,
                contentType: "application/json",
                dataType: "json",
                error: function (xhr, ajaxOptions, thrownError) {
                    alert(xhr.status);
                    alert(xhr.responseText);
                    alert(thrownError);
                },
                success: function (msg) {
                    if (msg.d === "")
                        return true;
                    else {
                        KSMaster.msg = msg.d;
                        return false;
                    }
                }
            });
        }
    </script>
</telerik:RadCodeBlock>

<asp:ObjectDataSource ID="ObjectDataSource1" runat="server" OldValuesParameterFormatString="original_{0}"
    SelectMethod="Retrieve" TypeName="KSProgram.Pozadavky.Pozadavekabsence" InsertMethod="Insert"
    UpdateMethod="Update" OnUpdated="ObjectDataSource1_Updated" OnUpdating="ObjectDataSource1_Updating"
    OnInserting="ObjectDataSource1_Inserting" OnInserted="ObjectDataSource1_Inserted">
    <UpdateParameters>
        <asp:Parameter Name="id_poz" Type="Int32" />
        <asp:Parameter Name="check_vyber_dnu" Type="Boolean" />
        <asp:Parameter Name="datum_od" Type="DateTime" />
        <asp:Parameter Name="datum_do" Type="DateTime" />
        <asp:Parameter Name="duvod" Type="String" />
        <asp:Parameter Name="vyridit_do" Type="DateTime" />
        <asp:Parameter Name="kod" Type="Int32" />
        <asp:Parameter Name="hod_doba" Type="Int32" />
        <asp:Parameter Name="min_doba" Type="Int32" />
        <asp:Parameter Name="hod_od" Type="Int32" />
        <asp:Parameter Name="min_od" Type="Int32" />
        <asp:Parameter Name="hod_do" Type="Int32" />
        <asp:Parameter Name="min_do" Type="Int32" />
        <asp:Parameter Name="datumy" Type="String" />
        <asp:Parameter Name="pulden" Type="String" />
    </UpdateParameters>
    <SelectParameters>
        <asp:Parameter Name="id_pozadavku" Type="Int32" DefaultValue="" />
    </SelectParameters>
    <InsertParameters>
        <asp:Parameter DefaultValue="0" Name="id_poz" Type="Int32" Direction="InputOutput" />
        <asp:Parameter Name="cislo_pom" Type="Int16" />
        <asp:Parameter Name="kod" Type="Int32" />
        <asp:Parameter Name="hod_doba" Type="Int32" />
        <asp:Parameter Name="min_doba" Type="Int32" />
        <asp:Parameter Name="hod_od" Type="Int32" />
        <asp:Parameter Name="min_od" Type="Int32" />
        <asp:Parameter Name="hod_do" Type="Int32" />
        <asp:Parameter Name="min_do" Type="Int32" />
        <asp:Parameter Name="check_vyber_dnu" Type="Boolean" />
        <asp:Parameter Name="datum_od" Type="DateTime" />
        <asp:Parameter Name="datum_do" Type="DateTime" />        
        <asp:Parameter Name="duvod" Type="String" />
        <asp:Parameter Name="vyridit_do" Type="DateTime" />
        <asp:Parameter Name="adresat" Type="Decimal" />
        <asp:Parameter Name="datumy" Type="String" />
        <asp:Parameter Name="pulden" Type="String" />
        <asp:Parameter Name="novy_stav" Type="String" />
    </InsertParameters>
</asp:ObjectDataSource>
<asp:ObjectDataSource runat="server" ID="ds_pomery" 
    OldValuesParameterFormatString="original_{0}" SelectMethod="GetPomery" 
    TypeName="KSProgram.Funkce.Prac_pom" >
    <SelectParameters>
        <asp:Parameter Name="co" Type="String" DefaultValue="p" />
        <asp:Parameter DefaultValue="0" Name="os_cislo" Type="Decimal" />
    </SelectParameters>
</asp:ObjectDataSource>
<asp:FormView ID="FormView1" runat="server" OnItemInserted="FormView1_ItemInserted" OnPreRender="FormView1_PreRender"
    OnItemUpdated="FormView1_ItemUpdated" OnDataBound="FormView1_DataBound" DataKeyNames="os_cislo" >
    <ItemTemplate>
        <asp:Table runat="server" ID="TableItem" SkinID="RamAPozadi">
            <asp:TableHeaderRow runat="server" ID="TableHeaderRowItem">
                <asp:TableCell runat="server" ColumnSpan="4" ID="TableCellItem14x" SkinID="TitleRowStyle">
                    <asp:Label ID="Label7x" runat="server" Text="[%Požadavek o nepřítomnost na pracovišti%]"></asp:Label><asp:Label CssClass="storno" runat="server" Text='<%#  DataBinder.Eval(Container.DataItem, "storno") %>' ID="lab_storno" ></asp:Label>               
                    <kspwc:TRadButton runat="server" ID="rb_storno" Text="[%Stornovat%]" AutoPostBack="true" Visible='<%#  DataBinder.Eval(Container.DataItem, "stornovatelny") %>' CommandArgument='<%#  DataBinder.Eval(Container.DataItem, "storno_url") %>' OnCommand="rb_storno_Command" CssClass="button-v-headeru-poz" >
                        <Icon PrimaryIconCssClass="fi fi-time-delete"></Icon>
                    </kspwc:TRadButton>               
                </asp:TableCell>
            </asp:TableHeaderRow>
            <asp:TableRow runat="server" ID="TableRow1">
                <asp:TableCell runat="server" ID="TableCell1a" HorizontalAlign="Right" SkinID="DataFieldHeaderStyle">
                    <asp:Label ID="Label8a" runat="server" SkinID="DataFieldHeaderStyle" Text="[%Žadatel%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell ColumnSpan="3" runat="server" SkinID="DataFieldStyle" ID="TableCell2">
                    <asp:Label ID="Label9" runat="server" Text='<%# ( KSProgram.Funkce.Pracovnik.OsCisloPrijmeniJmeno(Convert.ToDecimal(DataBinder.Eval(Container.DataItem, "os_cislo")))) %>'></asp:Label>
                </asp:TableCell>
            </asp:TableRow>

            <asp:TableRow runat="server" ID="row_pomer">
                <asp:TableCell runat="server" ID="TableCell10" HorizontalAlign="Right" SkinID="DataFieldHeaderStyle">
                    <asp:Label ID="Label18" runat="server" SkinID="DataFieldHeaderStyle" Text="[%Druh poměru%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell ColumnSpan="3" runat="server" SkinID="DataFieldStyle" ID="TableCell11">
                  <%--  <asp:Label ID="Label13" runat="server" Text='<%# Bind("cislo_pom") %>'></asp:Label>--%>
                      <asp:Label ID="Label13" runat="server" Text='<%# Bind("pomer_text") %>'></asp:Label>
                </asp:TableCell>
            </asp:TableRow>

           <asp:TableRow runat="server" ID="TableRow2">
                <asp:TableCell runat="server" ID="TableCell5" HorizontalAlign="right" SkinID="DataFieldHeaderStyle">
                    <asp:Label ID="Label12" runat="server" Text="[%Druh nepřítomnosti na pracovišti%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell runat="server" ID="TableCell6" ColumnSpan="3" SkinID="DataFieldStyle">
                    <asp:Label runat="server" ID="Label16" Text='<%# VyplnKod(Container.DataItem,"kod") %>'></asp:Label>                    
                </asp:TableCell>
            </asp:TableRow>

            <asp:TableRow runat="server" ID="TableRow_poznamka">
                <asp:TableCell runat="server" ID="TableCell9" HorizontalAlign="right" SkinID="DataFieldHeaderStyle" ColumnSpan="4">
                    <asp:Label ID="Label17" runat="server" Text="Employees, requesting UnL, are willing to contribute towards Health insurance at a rate of 13.5%."></asp:Label>
                </asp:TableCell>               
            </asp:TableRow>

            <asp:TableRow runat="server" ID="TableRow3">
                <asp:TableCell runat="server" ID="TableCell7" HorizontalAlign="right" SkinID="DataFieldHeaderStyle">
                    <asp:Label ID="Label14" runat="server" Text="[%Čas od - do%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell runat="server" ID="TableCell8" ColumnSpan="3" SkinID="DataFieldStyle">
                    <div style="white-space: nowrap;">                                          
                        <asp:Label runat="server" ID="lab_min_od" Text='<%# KSProgram.Funkce.Cas_na_min.GetCasString(DataBinder.Eval(Container.DataItem, "suma_min_od")) %>'></asp:Label>                                   
                        <asp:Label runat="server" ID="lab_hod_do" Text="-"></asp:Label>
                        <asp:Label runat="server" ID="Label5" Text='<%# KSProgram.Funkce.Cas_na_min.GetCasString(DataBinder.Eval(Container.DataItem, "suma_min_do")) %>'></asp:Label>                   
                    </div>
                </asp:TableCell>
             </asp:TableRow>

            <asp:TableRow runat="server" ID="TableRowInsert2">
                <asp:TableCell runat="server" ID="TCInsert1" HorizontalAlign="right" SkinID="DataFieldHeaderStyle">
                    <asp:Label ID="Label6" runat="server" Text="[%Doba%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell runat="server" ID="TCInsert2" ColumnSpan="3" SkinID="DataFieldStyle">
                    <div style="white-space: nowrap;">
                        <asp:Label runat="server" ID="Label15"  Text='<%# KSProgram.Funkce.Cas_na_min.GetCasString(DataBinder.Eval(Container.DataItem, "suma_min_doba")) %>' ></asp:Label>           
                    </div>
                </asp:TableCell>
            </asp:TableRow>   
            
             <asp:TableRow runat="server" ID="TableRowPulReadonly"> 
                 <asp:TableCell runat="server" ID="TableCell23" ColumnSpan="1" SkinID="DataFieldStyle">                   
                </asp:TableCell>
                <asp:TableCell runat="server" ID="TableCell24" ColumnSpan="3" SkinID="DataFieldStyle">
                     <asp:Label ID="Label24" runat="server" Text='<%# _textPulDen(DataBinder.Eval(Container.DataItem,"pul_den")) %>' ></asp:Label>
                </asp:TableCell>
            </asp:TableRow>


             <asp:TableRow runat="server" ID="table_row_volba">
                <asp:TableCell runat="server" ID="TableCell16" HorizontalAlign="right" SkinID="DataFieldHeaderStyle">
                    <%--<asp:Label ID="Label22" runat="server" Text="[%Výběr dnů%]:"></asp:Label>--%>
                </asp:TableCell>
                <asp:TableCell runat="server" ID="TableCell17" ColumnSpan="3" SkinID="DataFieldStyle">
                    <div style="white-space: nowrap;">
                      <kspwc:TRadButton runat="server" ID="TRB_vyber_dnu" ToggleType="CheckBox" Enabled="false" ButtonType="StandardButton" Text="[%Výběr dnů%]"  Checked='<%# Bind("check_vyber_dnu") %>' OnDataBinding="TRB_vyber_dnu_DataBinding" >
                            <ToggleStates>
                                <telerik:RadButtonToggleState PrimaryIconCssClass="fi fi-checkbox" />
                                <telerik:RadButtonToggleState PrimaryIconCssClass="fi fi-square" />
                            </ToggleStates>
                        </kspwc:TRadButton>                      
                    </div>
                </asp:TableCell>
            </asp:TableRow>

            <asp:TableRow runat="server" ID="TableRowItemDatumy">
                <asp:TableCell runat="server" ID="TableCellItem3" SkinID="DataFieldHeaderStyle" HorizontalAlign="Right">
                    <asp:Label ID="Label1x" SkinID="DataFieldHeaderStyle" runat="server" Text="[%Od%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell runat="server" ID="TableCellItem4" SkinID="DataFieldStyle">
                    <asp:Label ID="LabelOd" runat="server" Text='<%# KSProgram.Funkce.F_DateTime.DateTimeToString(DataBinder.Eval(Container.DataItem,"datum_od"), "d") %>'></asp:Label>
                </asp:TableCell>
                <asp:TableCell runat="server" ID="TableCellItem5" SkinID="DataFieldHeaderStyle" HorizontalAlign="Right">
                    <asp:Label ID="Label2x" runat="server" Text="[%Do%]:"></asp:Label>
                </asp:TableCell>


                <asp:TableCell runat="server" ID="TableCellItem6" SkinID="DataFieldStyle">
                    <asp:Label ID="LabelDo" runat="server" Text='<%# KSProgram.Funkce.F_DateTime.DateTimeToString(DataBinder.Eval(Container.DataItem,"datum_do"), "d") %>'></asp:Label>
                </asp:TableCell>
            </asp:TableRow>


             <asp:TableRow runat="server" ID="TableRowItem_calendar">
                <asp:TableCell runat="server" ID="TableCell18" HorizontalAlign="right" SkinID="DataFieldHeaderStyle">
                    <asp:Label ID="Label23" runat="server" Text="[%Dny k výběru%]"></asp:Label>
                </asp:TableCell>
                <asp:TableCell runat="server" ID="TableCell19" SkinID="DataFieldStyle" ColumnSpan="3">                  
                    <kspwc:TRadCalendar runat="server" ID="calendar" AutoPostBack="false"  OnDayRender="calendarItem_DayRender"  OnDataBinding="calendaritem_DataBinding">   
                        
                    </kspwc:TRadCalendar>
                </asp:TableCell>               
            </asp:TableRow>

              <%-- začatek--%>

             <asp:TableRow runat="server" ID="TableRow_header">
                <asp:TableCell runat="server" ID="TableCell29" HorizontalAlign="Right" SkinID="DataFieldHeaderStyle">                    
                </asp:TableCell>

                <asp:TableCell ColumnSpan="2" runat="server"  ID="hodiny1" SkinID="DataFieldHeaderStyle"  CssClass="cisPol">
                    <asp:Label ID="label_jednotka" runat="server" Text="[%Hodiny%]"></asp:Label>
                </asp:TableCell>                  

                <asp:TableCell ColumnSpan="1" runat="server"  ID="TableCell_datum1" SkinID="DataFieldHeaderStyle">                   
                </asp:TableCell>
            </asp:TableRow>


            <asp:TableRow runat="server" ID="TableRow_zust" >
                <asp:TableCell runat="server" ID="TableCell20" HorizontalAlign="Right" SkinID="DataFieldHeaderStyle">
                    <asp:Label ID="Label_zustatek_ke_dni" runat="server" SkinID="DataFieldHeaderStyle" Text="[%Zůstatek před požadavky%] / [%ke dni%]:"></asp:Label>
                </asp:TableCell>

                <asp:TableCell ColumnSpan="2" runat="server" SkinID="DataFieldStyle" ID="hodiny2"  CssClass="cisPol">
                    <asp:Label ID="label_zustatek" runat="server" ></asp:Label>
                </asp:TableCell>               
<%--                Text='<%# Eval("bv_zustatek", "{0:N2}") %>'--%>
                <asp:TableCell ColumnSpan="1" runat="server" SkinID="DataFieldStyle" ID="TableCell_datum2">
                    <asp:Label ID="label_obdobi" runat="server" ></asp:Label>
                   <%-- Text='<%# KSProgram.Funkce.F_DateTime.DateTimeToString(DataBinder.Eval(Container.DataItem,"bv_obdobi"), "d") %>'--%>
                </asp:TableCell>
            </asp:TableRow>
            <asp:TableRow runat="server" ID="TableRow_zazadano" >
                <asp:TableCell runat="server" ID="TableCell21" HorizontalAlign="Right" SkinID="DataFieldHeaderStyle">
                    <asp:Label ID="Label_zazadano_popisek" runat="server" SkinID="DataFieldHeaderStyle" Text="[%Zažádáno po tomto datu%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell ColumnSpan="2" runat="server" SkinID="DataFieldStyle" ID="hodiny3"  CssClass="cisPol">
                    <asp:Label ID="label_zazadano" runat="server" ></asp:Label>
                   <%-- Text='<%# Eval("bv_zazadano", "{0:N2}") %>'--%>
                </asp:TableCell>
                
                 <asp:TableCell ColumnSpan="1" runat="server" SkinID="DataFieldStyle" ID="TableCell_datum3"  CssClass="cisPol">                  
                </asp:TableCell> 

            </asp:TableRow>
            <asp:TableRow runat="server" ID="TableRow_pozadavky_zust" >
                <asp:TableCell runat="server" ID="TableCell22" HorizontalAlign="Right" SkinID="DataFieldHeaderStyle">
                    <asp:Label ID="Label21" runat="server" SkinID="DataFieldHeaderStyle" Text="[%Zůstatek%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell ColumnSpan="2" runat="server" SkinID="DataFieldStyle" ID="hodiny4"  CssClass="cisPolSum">
                    <asp:Label ID="label_zustatek_celkovy" runat="server"></asp:Label>
                   <%--  Text='<%# Eval("bv_zustatek_celkovy", "{0:N2}") %>'--%>
                </asp:TableCell>               
                <asp:TableCell ColumnSpan="1" runat="server" SkinID="DataFieldStyle" ID="TableCell_datum4">                   
                </asp:TableCell>
            </asp:TableRow>
             <%-- konec--%>


            <asp:TableRow runat="server" ID="TableRowItem3">
                <asp:TableCell runat="server" ID="TableCellItem7" SkinID="DataFieldHeaderStyle" HorizontalAlign="Right">
                    <asp:Label ID="Label3x" runat="server" Text="[%Poznámka%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell ColumnSpan="3" runat="server" ID="TableCellItem8" SkinID="DataFieldStyle">
                    <asp:Label ID="LabelDuvodx" runat="server" Text='<%# Bind("duvod") %>' 
                        Width="200px"></asp:Label>
                </asp:TableCell>
            </asp:TableRow>
            <asp:TableRow runat="server" ID="TableRowItem4">
                <asp:TableCell runat="server" ID="TableCellItem9" SkinID="DataFieldHeaderStyle" HorizontalAlign="Right">
                    <asp:Label ID="Label4x" runat="server" Text="[%Vyřešit do%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell runat="server" ID="TableCellItem10" SkinID="DataFieldStyle" ColumnSpan="3">
                    <asp:Label ID="LabelDatvyrizeni" runat="server" Text='<%# KSProgram.Funkce.F_DateTime.DateTimeToString(DataBinder.Eval(Container.DataItem,"vyridit_do"), "d") %>'></asp:Label>
                </asp:TableCell>
            </asp:TableRow>
            <asp:TableRow runat="server" ID="TableRow6">
                <asp:TableCell runat="server" ID="TableCell1" SkinID="DataFieldHeaderStyle" HorizontalAlign="Right">
                    <asp:Label ID="Label8" runat="server" Text="[%Aktuální stav a datum změny stavu%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell ColumnSpan="2" runat="server" ID="TableCell4" SkinID="DataFieldStyle">
                    <asp:Label ID="Label11" runat="server" Text='<%# DataBinder.Eval(Container.DataItem,"stav") %>'></asp:Label>
                </asp:TableCell>
                <asp:TableCell runat="server" ID="TableCell3" SkinID="DataFieldStyle">
                    <asp:Label ID="Label10" runat="server" Text='<%# KSProgram.Funkce.F_DateTime.DateTimeToString(DataBinder.Eval(Container.DataItem,"vyriz_datum"), "d") %>'></asp:Label>
                </asp:TableCell>
            </asp:TableRow>
            <asp:TableRow runat="server" ID="TableRowItem5">
                <asp:TableCell ColumnSpan="4" runat="server" ID="TableCellItem11">
                </asp:TableCell>
            </asp:TableRow>
        </asp:Table>
    </ItemTemplate>
    <EditItemTemplate>
        <asp:Table runat="server" ID="TableEdit" SkinID="RamAPozadi">
            <asp:TableHeaderRow runat="server" ID="TableHeaderRowEidt">
                <asp:TableCell runat="server" ColumnSpan="4" ID="TableCellItem14" SkinID="TitleRowStyle">
                    <asp:Label ID="Label7" runat="server" Text="[%Úprava požadavku o absenci%]"></asp:Label>
                </asp:TableCell>
            </asp:TableHeaderRow>
            <asp:TableRow runat="server" ID="TableRowEdit1a">
                <asp:TableCell runat="server" ID="TableCell1aedit" HorizontalAlign="Right" SkinID="DataFieldHeaderStyle">
                    <asp:Label ID="Label8aedit" runat="server" SkinID="DataFieldHeaderStyle" Text="[%Žadatel%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell ColumnSpan="3" runat="server" SkinID="DataFieldStyle" ID="TableCell2">
                    <asp:Label ID="Label9" runat="server" Text='<%# ( KSProgram.Funkce.Pracovnik.OsCisloPrijmeniJmeno(Convert.ToDecimal(DataBinder.Eval(Container.DataItem, "os_cislo")))) %>'></asp:Label>
                </asp:TableCell>
            </asp:TableRow>
            
            <asp:TableRow runat="server" ID="row_pomer">
                <asp:TableCell runat="server" ID="TableCell14" HorizontalAlign="Right" SkinID="DataFieldHeaderStyle">
                    <asp:Label ID="Label20" runat="server" SkinID="DataFieldHeaderStyle" Text="[%Druh poměru%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell ColumnSpan="3" runat="server" SkinID="DataFieldStyle" ID="TableCell15">
                   <%-- <asp:Label ID="Label21" runat="server" Text='<%# Bind("cislo_pom") %>'></asp:Label>--%>
                   <asp:Label ID="Label22" runat="server" Text='<%# Bind("pomer_text") %>'></asp:Label>
                </asp:TableCell>
            </asp:TableRow>

            <asp:TableRow runat="server" ID="TableRow2">
                <asp:TableCell runat="server" ID="TableCell5" HorizontalAlign="right" SkinID="DataFieldHeaderStyle">
                    <asp:Label ID="Label12" runat="server" Text="[%Druh nepřítomnosti na pracovišti%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell runat="server" ID="TableCell6" ColumnSpan="3" SkinID="DataFieldStyle">
                    <asp:DropDownList ID="ddlb_druh" runat="server" AutoPostBack="True"  DataValueField="kod" DataTextField="nazev" DataSourceID="ds_druh_absence" OnSelectedIndexChanged="ddlb_druh_SelectedIndexChanged" SelectedValue='<%# Bind("kod") %>' OnDataBinding="ddlb_druh_DataBinding" >
                    </asp:DropDownList>
                    <kspwc:TRequiredValidator runat="server" ID="req_ddlb_druh" ControlToValidate="ddlb_druh"  DataSourceID="ds_druh_absence" Text="[%Povinné pole%]" ErrorMessage="[%Povinné pole%]"></kspwc:TRequiredValidator>                  
                       <asp:ObjectDataSource runat="server" ID="ds_druh_absence" TypeName="KSProgram.Pozadavky.Pozadavekabsence" SelectMethod="NabidkaKodu" >
                        <SelectParameters>
                            <asp:Parameter DbType="Decimal" Name="os_cislo" />
                        </SelectParameters>
                    </asp:ObjectDataSource>
                </asp:TableCell>
            </asp:TableRow>

            <asp:TableRow runat="server" ID="TableRow_poznamka">
                <asp:TableCell runat="server" ID="TableCell9" HorizontalAlign="right" SkinID="DataFieldHeaderStyle" ColumnSpan="4">
                    <asp:Label ID="Label17" runat="server" Text="Employees, requesting UnL, are willing to contribute towards Health insurance at a rate of 13.5%."></asp:Label>
                </asp:TableCell>               
            </asp:TableRow>

            <asp:TableRow runat="server" ID="TableRow3">
                <asp:TableCell runat="server" ID="TableCell7" HorizontalAlign="right" SkinID="DataFieldHeaderStyle">
                    <asp:Label ID="Label14" runat="server" Text="[%Čas od - do%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell runat="server" ID="TableCell8" ColumnSpan="3" SkinID="DataFieldStyle">
                    <div style="white-space: nowrap;">
                        <telerik:RadTextBox runat="server" ID="hod_od"  Width="30" Text='<%# Bind("hod_od") %>' MaxLength="2">
                            <ClientEvents OnKeyPress="keyPress" /> 
                        </telerik:RadTextBox>
                       <%-- <asp:CustomValidator ID="hod_validator" runat="server" ErrorMessage="*" ControlToValidate="hod_od"  OnServerValidate="cas_validate"></asp:CustomValidator>--%>
                        
                        <asp:Label runat="server" ID="lab_min_od" Text=":"></asp:Label>
                        <telerik:RadTextBox runat="server" ID="min_od"  Width="30" Text='<%# Bind("min_od") %>'  MaxLength="2" >
                            <ClientEvents OnKeyPress="keyPress" /> 
                        </telerik:RadTextBox>
                       <%-- <asp:CustomValidator ID="min_validator" runat="server" ErrorMessage="*" ControlToValidate="min_od"   OnServerValidate="cas_validate"></asp:CustomValidator>--%>
                        

                        <asp:Label runat="server" ID="lab_hod_do" Text="-"></asp:Label>
                        <telerik:RadTextBox runat="server" ID="hod_do"  Width="30" Text='<%# Bind("hod_do") %>'  MaxLength="2">
                            <ClientEvents OnKeyPress="keyPress" /> 
                        </telerik:RadTextBox>
                       <%-- <asp:CustomValidator ID="hod_do_validator" runat="server" ErrorMessage="*" ControlToValidate="hod_do"   OnServerValidate="cas_validate"></asp:CustomValidator>--%>
                       
                        <asp:Label runat="server" ID="lab_min_do" Text=":"></asp:Label>
                        <telerik:RadTextBox runat="server" ID="min_do"  Width="30" Text='<%# Bind("min_do") %>'  MaxLength="2">
                            <ClientEvents OnKeyPress="keyPress" /> 
                        </telerik:RadTextBox>
                       <%-- <asp:CustomValidator ID="min_do_validator" runat="server" ErrorMessage="*" ControlToValidate="min_do"    OnServerValidate="cas_validate"></asp:CustomValidator>--%>
                        
                    </div>
                </asp:TableCell>
             </asp:TableRow>

            <asp:TableRow runat="server" ID="TableRowInsert2">
                <asp:TableCell runat="server" ID="TCInsert1" HorizontalAlign="right" SkinID="DataFieldHeaderStyle">
                    <asp:Label ID="Label6" runat="server" Text="[%Doba%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell runat="server" ID="TCInsert2" ColumnSpan="3" SkinID="DataFieldStyle">
                    <div style="white-space: nowrap;">
                        <telerik:RadTextBox runat="server" ID="hod_doba"  Width="30" Text='<%# Bind("hod_doba") %>'  MaxLength="2">
                            <ClientEvents OnKeyPress="keyPress" /> 
                        </telerik:RadTextBox>
                       <%-- <asp:CustomValidator ID="hod_doba_validator" runat="server" ErrorMessage="*"  OnServerValidate="cas_validate"></asp:CustomValidator>--%>
                        <asp:Label runat="server" ID="Label13" Text=":"></asp:Label>
                        <telerik:RadTextBox runat="server" ID="min_doba"  Width="30" Text='<%# Bind("min_doba") %>' MaxLength="2">
                            <ClientEvents OnKeyPress="keyPress" /> 
                        </telerik:RadTextBox>
                       <%--<asp:CustomValidator ID="min_doba_validator" runat="server" ErrorMessage="*"  OnServerValidate="cas_validate"></asp:CustomValidator>--%>
                    </div>
                </asp:TableCell>
            </asp:TableRow>




             <asp:TableRow runat="server" ID="TableRowPulEdit"> 
                  <asp:TableCell runat="server" ID="TableCell23" ColumnSpan="1" SkinID="DataFieldStyle">                   
                </asp:TableCell>
                <asp:TableCell runat="server" ID="TableCell24" ColumnSpan="3" SkinID="DataFieldStyle">
                    <span>
                     <asp:RadioButtonList runat="server" ID="rb_pul_den_Edit" OnSelectedIndexChanged="rb_pul_den_SelectedIndexChanged" >
                        <Items>
                            <asp:ListItem Text="1.[%polovina směny%]" Value="a" />
                            <asp:ListItem Text="2.[%polovina směny%]" Value="d" />
                        </Items>
                    </asp:RadioButtonList>
                       <kspwc:TRequiredValidator runat="server" id="req_pul_den_Edit" Enabled="false" ControlToValidate="rb_pul_den_Edit" Text="[%Povinné pole%]" ErrorMessage="[%Povinné pole%]" ></kspwc:TRequiredValidator>                        
                        </span>
                </asp:TableCell>
            </asp:TableRow>


           

             <asp:TableRow runat="server" ID="table_row_volba">
                <asp:TableCell runat="server" ID="TableCell16" HorizontalAlign="right" SkinID="DataFieldHeaderStyle">
                   <%-- <asp:Label ID="Label22" runat="server" Text="[%Výběr dnů%]:"></asp:Label>--%>
                </asp:TableCell>
                <asp:TableCell runat="server" ID="TableCell17" ColumnSpan="3" SkinID="DataFieldStyle">
                    <div style="white-space: nowrap;">
                      <kspwc:TRadButton runat="server" ID="TRB_vyber_dnu" ToggleType="CheckBox" AutoPostBack="true" CausesValidation="true" ButtonType="StandardButton" Text="[%Výběr dnů%]"   Checked='<%# Bind("check_vyber_dnu") %>' OnClick="TRB_vyber_dnu_Click" OnCheckedChanged="TRB_vyber_dnu_CheckedChanged" OnDataBinding="TRB_vyber_dnu_DataBinding">
                            <ToggleStates>
                                <telerik:RadButtonToggleState PrimaryIconCssClass="fi fi-checkbox" />
                                <telerik:RadButtonToggleState PrimaryIconCssClass="fi fi-square" />
                            </ToggleStates>
                        </kspwc:TRadButton>                      
                    </div>
                </asp:TableCell>
            </asp:TableRow>



            <asp:TableRow runat="server" ID="TableRowEdit_datumy">
                <asp:TableCell runat="server" ID="TableCellEdit4" HorizontalAlign="right" SkinID="DataFieldHeaderStyle">
                    <asp:Label ID="Label1x" runat="server" Text="[%Od%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell runat="server" ID="TableCellEdit5" SkinID="DataFieldStyle">                  
                    <kspwc:TRadDatePicker runat="server" ID="TextBoxOdEdit" DbSelectedDate='<%# Bind("datum_od") %>' OnSelectedDateChanged="TextBoxOd_SelectedDateChanged" ></kspwc:TRadDatePicker>
                </asp:TableCell>
                <asp:TableCell runat="server" ID="TableCellEdit6" SkinID="DataFieldHeaderStyle">
                    <asp:Label ID="Label2x" runat="server" Text="[%Do%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell runat="server" ID="TableCellEdit7" SkinID="DataFieldStyle">                  
                    <kspwc:TRadDatePicker runat="server" ID="TextBoxDoEdit" DbSelectedDate='<%# Bind("datum_do") %>'></kspwc:TRadDatePicker>
                </asp:TableCell>
            </asp:TableRow>


            <asp:TableRow runat="server" ID="TableRowEdit_calendar">
                <asp:TableCell runat="server" ID="TableCell18" HorizontalAlign="right" SkinID="DataFieldHeaderStyle">
                    <asp:Label ID="Label23" runat="server" Text="[%Dny k výběru%]"></asp:Label>
                </asp:TableCell>

                <asp:TableCell runat="server" ID="TableCell19" SkinID="DataFieldStyle">                  
                    <kspwc:TRadCalendar runat="server" ID="calendarEdit" AutoPostBack="false"  EnableMultiSelect="true" OnDayRender="calendarEdit_DayRender" OnDataBinding="calendarEdit_DataBinding">
                        <ClientEvents  OnDateClick="calendar_day_click"  />                            
                        
                    </kspwc:TRadCalendar>
                </asp:TableCell>
               
            </asp:TableRow>

               <%-- začatek--%>
             <asp:TableRow runat="server" ID="TableRow_header">
                <asp:TableCell runat="server" ID="TableCell29" HorizontalAlign="Right" SkinID="DataFieldHeaderStyle">                    
                </asp:TableCell>

                <asp:TableCell ColumnSpan="2" runat="server"  ID="hodiny1" SkinID="DataFieldHeaderStyle"  CssClass="cisPol">
                    <asp:Label ID="label_jednotka" runat="server" Text="[%Hodiny%]"></asp:Label>
                </asp:TableCell>                  

                <asp:TableCell ColumnSpan="1" runat="server"  ID="TableCell_datum1" SkinID="DataFieldHeaderStyle">                   
                </asp:TableCell>
            </asp:TableRow>


            <asp:TableRow runat="server" ID="TableRow_zust" >
                <asp:TableCell runat="server" ID="TableCell20" HorizontalAlign="Right" SkinID="DataFieldHeaderStyle">
                    <asp:Label ID="Label_zustatek_ke_dni" runat="server" SkinID="DataFieldHeaderStyle" Text="[%Zůstatek před požadavky%] / [%ke dni%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell ColumnSpan="2" runat="server" SkinID="DataFieldStyle" ID="hodiny2"  CssClass="cisPol">
                    <asp:Label ID="label_zustatek" runat="server" ></asp:Label>
                    <%--Text='<%# Eval("bv_zustatek", "{0:N2}") %>'--%>
                </asp:TableCell>               

                <asp:TableCell ColumnSpan="1" runat="server" SkinID="DataFieldStyle" ID="TableCell_datum2">
                    <asp:Label ID="label_obdobi" runat="server" ></asp:Label>
                    <%--Text='<%# KSProgram.Funkce.F_DateTime.DateTimeToString(DataBinder.Eval(Container.DataItem,"bv_obdobi"), "d") %>'--%>
                </asp:TableCell>
            </asp:TableRow>
            <asp:TableRow runat="server" ID="TableRow_zazadano" >
                <asp:TableCell runat="server" ID="TableCell21" HorizontalAlign="Right" SkinID="DataFieldHeaderStyle">
                    <asp:Label ID="Label_zazadano_popisek" runat="server" SkinID="DataFieldHeaderStyle" Text="[%Zažádáno po tomto datu%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell ColumnSpan="2" runat="server" SkinID="DataFieldStyle" ID="hodiny3"  CssClass="cisPol">
                    <asp:Label ID="label_zazadano" runat="server" ></asp:Label>
                   <%-- Text='<%# Eval("bv_zazadano", "{0:N2}") %>'--%>
                </asp:TableCell>  
                
                 <asp:TableCell ColumnSpan="1" runat="server" SkinID="DataFieldStyle" ID="TableCell_datum3">                   
                </asp:TableCell>

            </asp:TableRow>
            <asp:TableRow runat="server" ID="TableRow_pozadavky_zust" >
                <asp:TableCell runat="server" ID="TableCell22" HorizontalAlign="Right" SkinID="DataFieldHeaderStyle">
                    <asp:Label ID="Label21" runat="server" SkinID="DataFieldHeaderStyle" Text="[%Zůstatek%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell ColumnSpan="2" runat="server" SkinID="DataFieldStyle" ID="hodiny4"  CssClass="cisPolSum">
                    <asp:Label ID="label_zustatek_celkovy" runat="server" ></asp:Label>
                   <%-- Text='<%# Eval("bv_zustatek_celkovy", "{0:N2}") %>'--%>
                </asp:TableCell>               
               <asp:TableCell ColumnSpan="1" runat="server" SkinID="DataFieldStyle" ID="TableCell_datum4">                   
                </asp:TableCell>
            </asp:TableRow>
             <%-- konec--%>


            <asp:TableRow runat="server" ID="TableRowEdit3">
                <asp:TableCell runat="server" ID="TableCellEdit8" HorizontalAlign="right" SkinID="DataFieldHeaderStyle">
                    <asp:Label ID="Label3x" runat="server" Text="[%Poznámka%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell runat="server" ID="TableCellEdit9" ColumnSpan="3" SkinID="DataFieldStyle">
                    <%--<asp:TextBox ID="LabelDuvodx" runat="server" Text='<%# Bind("duvod") %>' MaxLength="999"
                        TextMode="MultiLine" Width="284px" Height="200" ></asp:TextBox>--%><br />
                    <telerik:RadTextBox ID="LabelDuvodx" runat="server" Text='<%# Bind("duvod") %>' MaxLength="999"
                        TextMode="MultiLine" Width="284px" Height="20"  Resize="Both"></telerik:RadTextBox>
                    <kspwc:TextValidator runat="server" id="val1" ControlToValidate="LabelDuvodx"></kspwc:TextValidator>
                </asp:TableCell>
            </asp:TableRow>
            <asp:TableRow runat="server" ID="TableRowEdit4">
                <asp:TableCell runat="server" ID="TableCellEdit10" HorizontalAlign="right" SkinID="DataFieldHeaderStyle">
                    <asp:Label ID="Label4" runat="server" Text="[%Požadované datum vyřízení%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell runat="server" ID="TableCellEdit11" ColumnSpan="3" SkinID="DataFieldStyle">
                    <%--<asp:TextBox ID="TextBoxDatVyrizeniEdit" runat="server" Text='<%# KSProgram.Funkce.F_DateTime.DateTimeToString(DataBinder.Eval(Container.DataItem,"vyridit_do"), "d") %>'
                        Width="95px"></asp:TextBox>
                    <ajax:CalendarExtender runat="server" ID="CalendarDatVyrizeniEdit" TargetControlID="TextBoxDatVyrizeniEdit"
                        PopupButtonID="ImageButton3">
                    </ajax:CalendarExtender>
                    <asp:ImageButton ID="ImageButton3" runat="server" ImageUrl="~/Images/calendar.png" />--%>
                    <kspwc:TRadDatePicker runat="server" ID="TextBoxDatVyrizeniEdit" DbSelectedDate='<%# Bind("vyridit_do") %>' ></kspwc:TRadDatePicker>
                </asp:TableCell>
            </asp:TableRow>
            <asp:TableRow runat="server" ID="TableRowEdit5">
                <asp:TableCell runat="server" ID="TableCellEdit12" ColumnSpan="4">
                </asp:TableCell>
            </asp:TableRow>
        </asp:Table>
    </EditItemTemplate>
    <InsertItemTemplate>
        <asp:Table runat="server" ID="TableInsert" SkinID="RamAPozadi">
            <asp:TableHeaderRow runat="server" ID="TableHeaderRowInsert">
                <asp:TableCell runat="server" ColumnSpan="4" ID="TableCellItem14" SkinID="TitleRowStyle">
                    <asp:Label ID="Label7" runat="server" Text="[%Nový požadavek o nepřítomnost na pracovišti%]"></asp:Label>
                </asp:TableCell>
            </asp:TableHeaderRow>

            <asp:TableRow runat="server" ID="TableRow1">
                <asp:TableCell runat="server" ID="TableCell1a" HorizontalAlign="Right" SkinID="DataFieldHeaderStyle">
                    <asp:Label ID="Label8a" runat="server" SkinID="DataFieldHeaderStyle" Text="[%Žadatel%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell ColumnSpan="3" runat="server" SkinID="DataFieldStyle" ID="TableCell2">
                    <asp:Label ID="Label_zam" runat="server" Text=""></asp:Label>
                </asp:TableCell>
            </asp:TableRow>

             <asp:TableRow runat="server" ID="row_pomer">
                <asp:TableCell runat="server" ID="TableCell12" HorizontalAlign="Right" SkinID="DataFieldHeaderStyle">
                    <asp:Label ID="Label19" runat="server" SkinID="DataFieldHeaderStyle" Text="[%Číslo poměru%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell ColumnSpan="3" runat="server" SkinID="DataFieldStyle" ID="TableCell13">                    
                    <asp:DropDownList runat="server" ID="ddl_pomery" DataTextField="cislo_druh_nazev" DataValueField="cislo_pom" DataSourceID="ds_pomery" AutoPostBack="true" CausesValidation="false" OnSelectedIndexChanged="ddl_pomery_SelectedIndexChanged" ></asp:DropDownList>
                </asp:TableCell>
            </asp:TableRow>

            <asp:TableRow runat="server" ID="TableRow2">
                <asp:TableCell runat="server" ID="TableCell5" HorizontalAlign="right" SkinID="DataFieldHeaderStyle">
                    <asp:Label ID="Label12" runat="server" Text="[%Druh nepřítomnosti na pracovišti%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell runat="server" ID="TableCell6" ColumnSpan="3" SkinID="DataFieldStyle">
                    <asp:DropDownList ID="ddlb_druh" runat="server" AutoPostBack="True"  DataValueField="kod" DataTextField="nazev" DataSourceID="ds_druh_absence" OnSelectedIndexChanged="ddlb_druh_SelectedIndexChanged" OnDataBinding="ddlb_druh_DataBinding" SelectedValue='<%# Bind("kod") %>' >
                    </asp:DropDownList>
                     <kspwc:TRequiredValidator runat="server" ID="req_ddlb_druh" ControlToValidate="ddlb_druh" Text="[%Povinné pole%]" ErrorMessage="[%Povinné pole%]"></kspwc:TRequiredValidator>           
                        <asp:ObjectDataSource runat="server" ID="ds_druh_absence" TypeName="KSProgram.Pozadavky.Pozadavekabsence" SelectMethod="NabidkaKodu" >
                         <SelectParameters>
                            <asp:Parameter DbType="Decimal" Name="os_cislo" />
                        </SelectParameters>
                    </asp:ObjectDataSource>
                </asp:TableCell>
            </asp:TableRow>

            <asp:TableRow runat="server" ID="TableRow_poznamka">
                <asp:TableCell runat="server" ID="TableCell9" HorizontalAlign="right" SkinID="DataFieldHeaderStyle" ColumnSpan="4">
                    <asp:Label ID="Label17" runat="server" Text="Employees, requesting UnL, are willing to contribute towards Health insurance at a rate of 13.5%."></asp:Label>
                </asp:TableCell>               
            </asp:TableRow>

            <asp:TableRow runat="server" ID="TableRow3">
                <asp:TableCell runat="server" ID="TableCell7" HorizontalAlign="right" SkinID="DataFieldHeaderStyle">
                    <asp:Label ID="Label14" runat="server" Text="[%Čas od - do%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell runat="server" ID="TableCell8" ColumnSpan="3" SkinID="DataFieldStyle">
                    <div style="white-space: nowrap;">
                        <telerik:RadTextBox runat="server" ID="hod_od"  Width="30" Text='<%# Bind("hod_od") %>' MaxLength="2">
                            <ClientEvents OnKeyPress="keyPress" /> 
                        </telerik:RadTextBox>                        
                        <asp:Label runat="server" ID="lab_min_od" Text=":"></asp:Label>
                        <telerik:RadTextBox runat="server" ID="min_od"  Width="30" Text='<%# Bind("min_od") %>'  MaxLength="2">
                            <ClientEvents OnKeyPress="keyPress" /> 
                        </telerik:RadTextBox>                   
                        <asp:Label runat="server" ID="lab_hod_do" Text="-"></asp:Label>
                        <telerik:RadTextBox runat="server" ID="hod_do"  Width="30" Text='<%# Bind("hod_do") %>' MaxLength="2">
                            <ClientEvents OnKeyPress="keyPress" /> 
                        </telerik:RadTextBox>                        
                        <asp:Label runat="server" ID="lab_min_do" Text=":"></asp:Label>
                        <telerik:RadTextBox runat="server" ID="min_do"  Width="30" Text='<%# Bind("min_do") %>' MaxLength="2">
                            <ClientEvents OnKeyPress="keyPress" /> 
                        </telerik:RadTextBox>
                    </div>
                </asp:TableCell>
             </asp:TableRow>

            <asp:TableRow runat="server" ID="TableRowInsert2">
                <asp:TableCell runat="server" ID="TCInsert1" HorizontalAlign="right" SkinID="DataFieldHeaderStyle">
                    <asp:Label ID="Label6" runat="server" Text="[%Doba%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell runat="server" ID="TCInsert2" ColumnSpan="3" SkinID="DataFieldStyle">
                    <div style="white-space: nowrap;">
                        <telerik:RadTextBox runat="server" ID="hod_doba"  Width="30" Text='<%# Bind("hod_doba") %>' MaxLength="2">
                            <ClientEvents OnKeyPress="keyPress" /> 
                        </telerik:RadTextBox>
                        <asp:Label runat="server" ID="Label13" Text=":"></asp:Label>
                        <telerik:RadTextBox runat="server" ID="min_doba"  Width="30" Text='<%# Bind("min_doba") %>' MaxLength="2">
                            <ClientEvents OnKeyPress="keyPress" /> 
                        </telerik:RadTextBox>
                    </div>
                </asp:TableCell>
            </asp:TableRow>


             <asp:TableRow runat="server" ID="TableRowPulInsert">
                  <asp:TableCell runat="server" ID="TableCell23" ColumnSpan="1" SkinID="DataFieldStyle">                   
                </asp:TableCell>
                <asp:TableCell runat="server" ID="TableCell24" ColumnSpan="3" SkinID="DataFieldStyle">
                    <span>
                     <asp:RadioButtonList runat="server" ID="rb_pul_den_Insert" OnSelectedIndexChanged="rb_pul_den_SelectedIndexChanged" >
                        <Items>
                            <asp:ListItem Text="1.[%polovina směny%]" Value="a" />
                            <asp:ListItem Text="2.[%polovina směny%]" Value="d" />
                        </Items>
                    </asp:RadioButtonList>
                       <kspwc:TRequiredValidator runat="server" id="req_pul_den_Insert" Enabled="false" ControlToValidate="rb_pul_den_Insert" Text="[%Povinné pole%]" ErrorMessage="[%Povinné pole%]" ></kspwc:TRequiredValidator>                        
                        </span>
                </asp:TableCell>
            </asp:TableRow>










             <asp:TableRow runat="server" ID="table_row_volba">
                <asp:TableCell runat="server" ID="TableCell16" HorizontalAlign="right" SkinID="DataFieldHeaderStyle">
                    <%--<asp:Label ID="Label22" runat="server" Text="[%Výběr dnů%]:"></asp:Label>--%>
                </asp:TableCell>
                <asp:TableCell runat="server" ID="TableCell17" ColumnSpan="3" SkinID="DataFieldStyle">
                    <div style="white-space: nowrap;">
                      <kspwc:TRadButton runat="server" ID="TRB_vyber_dnu" ToggleType="CheckBox" ButtonType="StandardButton" Text="[%Výběr dnů%]" AutoPostBack="true" CausesValidation="false"  Checked='<%# Bind("check_vyber_dnu") %>' OnClick="TRB_vyber_dnu_Click"   OnDataBinding="TRB_vyber_dnu_DataBinding">
                            <ToggleStates>
                                <telerik:RadButtonToggleState PrimaryIconCssClass="fi fi-checkbox" />
                                <telerik:RadButtonToggleState PrimaryIconCssClass="fi fi-square" />
                            </ToggleStates>
                        </kspwc:TRadButton>                      
                    </div>
                </asp:TableCell>
            </asp:TableRow>


           



            <asp:TableRow runat="server" ID="TableRowInsert_datumy">
                <asp:TableCell runat="server" ID="TCInsert3" HorizontalAlign="right" SkinID="DataFieldHeaderStyle">
                    <asp:Label ID="Label1" runat="server" Text="[%Od%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell runat="server" ID="TCInsert4" SkinID="DataFieldStyle">
                    <%--<asp:TextBox ID="TextBoxOdInsert" runat="server" Text='<%# KSProgram.Funkce.F_DateTime.DateTimeToString(DataBinder.Eval(Container.DataItem,"datum_od"), "d") %>'
                        Width="95px"></asp:TextBox>
                    <ajax:CalendarExtender runat="server" ID="Calendar_dat_od_i" TargetControlID="TextBoxOdInsert"
                        PopupButtonID="ImageButton1i">
                    </ajax:CalendarExtender>
                    <asp:ImageButton ID="ImageButton1i" runat="server" ImageUrl="~/Images/calendar.png" />--%>
                    <kspwc:TRadDatePicker runat="server" ID="TextBoxOdInsert" DbSelectedDate='<%# Bind("datum_od") %>' OnSelectedDateChanged="TextBoxOd_SelectedDateChanged" ></kspwc:TRadDatePicker>
                </asp:TableCell>
                <asp:TableCell runat="server" ID="TCInsert5" SkinID="DataFieldHeaderStyle">
                    <asp:Label ID="Label2" runat="server" Text="[%Do%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell runat="server" ID="TCInsert6" SkinID="DataFieldStyle">
                    <%--<asp:TextBox ID="TextBoxDoInsert" runat="server" Text='<%# KSProgram.Funkce.F_DateTime.DateTimeToString(DataBinder.Eval(Container.DataItem,"datum_do"), "d") %>'
                        Width="95px"></asp:TextBox>
                    <ajax:CalendarExtender runat="server" ID="Calendar_dat_do_i" TargetControlID="TextBoxDoInsert"
                        PopupButtonID="ImageButtonDoInsert">
                    </ajax:CalendarExtender>
                    <asp:ImageButton ID="ImageButtonDoInsert" runat="server" ImageUrl="~/Images/calendar.png" />--%>
                    <kspwc:TRadDatePicker runat="server" ID="TextBoxDoInsert" DbSelectedDate='<%# Bind("datum_do") %>' ></kspwc:TRadDatePicker>
                </asp:TableCell>
            </asp:TableRow>

             <asp:TableRow runat="server" ID="TableRowInsert_calendar">
                <asp:TableCell runat="server" ID="TableCell18" HorizontalAlign="right" SkinID="DataFieldHeaderStyle">
                    <asp:Label ID="Label23" runat="server" Text="[%Dny k výběru%]"></asp:Label>
                </asp:TableCell>

                <asp:TableCell runat="server" ID="TableCell19" SkinID="DataFieldStyle">                  
                    <kspwc:TRadCalendar runat="server" ID="calendarInsert" AutoPostBack="false" EnableMultiSelect="true" >
                        <ClientEvents  OnDateClick="calendar_day_click" /> 
                    </kspwc:TRadCalendar>
                </asp:TableCell>
               
            </asp:TableRow>

             <%-- začatek--%>
             <asp:TableRow runat="server" ID="TableRow_header">
                <asp:TableCell runat="server" ID="TableCell29" HorizontalAlign="Right" SkinID="DataFieldHeaderStyle">                    
                </asp:TableCell>

                <asp:TableCell ColumnSpan="2" runat="server"  ID="hodiny1" SkinID="DataFieldHeaderStyle"  CssClass="cisPol">
                    <asp:Label ID="label_jednotka" runat="server" Text="[%Hodiny%]"></asp:Label>
                </asp:TableCell>                  

                <asp:TableCell ColumnSpan="1" runat="server"  ID="TableCell_datum1" SkinID="DataFieldHeaderStyle">                   
                </asp:TableCell>
            </asp:TableRow>

            <asp:TableRow runat="server" ID="TableRow_zust">
                <asp:TableCell runat="server" ID="TableCell20" HorizontalAlign="Right" SkinID="DataFieldHeaderStyle">
                    <asp:Label ID="Label_zustatek_ke_dni" runat="server" SkinID="DataFieldHeaderStyle" Text="[%Zůstatek před požadavky%] / ke dni%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell ColumnSpan="2" runat="server" SkinID="DataFieldStyle" ID="hodiny2"  CssClass="cisPol">
                    <asp:Label ID="label_zustatek" runat="server" ></asp:Label>
                </asp:TableCell>               

                <asp:TableCell ColumnSpan="1" runat="server" SkinID="DataFieldStyle" ID="TableCell_datum2">
                    <asp:Label ID="label_obdobi" runat="server" ></asp:Label>
                </asp:TableCell>

            </asp:TableRow>
            <asp:TableRow runat="server" ID="TableRow_zazadano">
                <asp:TableCell runat="server" ID="TableCell21" HorizontalAlign="Right" SkinID="DataFieldHeaderStyle">
                    <asp:Label ID="Label_zazadano_popisek" runat="server" SkinID="DataFieldHeaderStyle" Text="[%Zažádáno po tomto datu%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell ColumnSpan="2" runat="server" SkinID="DataFieldStyle" ID="hodiny3"  CssClass="cisPol">
                    <asp:Label ID="label_zazadano" runat="server" ></asp:Label>
                </asp:TableCell> 
                <asp:TableCell ColumnSpan="1" runat="server" SkinID="DataFieldStyle" ID="TableCell_datum3">                   
                </asp:TableCell>

            </asp:TableRow>
            <asp:TableRow runat="server" ID="TableRow_pozadavky_zust">
                <asp:TableCell runat="server" ID="TableCell22" HorizontalAlign="Right" SkinID="DataFieldHeaderStyle">
                    <asp:Label ID="Label21" runat="server" SkinID="DataFieldHeaderStyle" Text="[%Zůstatek%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell ColumnSpan="2" runat="server" SkinID="DataFieldStyle" ID="hodiny4"  CssClass="cisPolSum">
                    <asp:Label ID="label_zustatek_celkovy" runat="server" ></asp:Label>
                </asp:TableCell>               
              <asp:TableCell ColumnSpan="1" runat="server" SkinID="DataFieldStyle" ID="TableCell_datum4">                   
                </asp:TableCell>
            </asp:TableRow>
             <%-- konec--%>

            <asp:TableRow runat="server" ID="TableRowInsert4">
                <asp:TableCell runat="server" ID="TCInsert7" HorizontalAlign="right" SkinID="DataFieldHeaderStyle">
                    <asp:Label ID="Label3" runat="server" Text="[%Poznámka%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell runat="server" ID="TCInsert8" ColumnSpan="3" SkinID="DataFieldStyle">
                    <%--<asp:TextBox ID="LabelDuvod" runat="server" Text='<%# Bind("duvod") %>' MaxLength="999"
                        TextMode="MultiLine" Width="283px" Height="200"></asp:TextBox>--%>
                    <telerik:RadTextBox ID="LabelDuvod" runat="server" Text='<%# Bind("duvod") %>' MaxLength="999"
                        TextMode="MultiLine" Width="283px" Height="20"  Resize="Both"></telerik:RadTextBox>
                    <br />
                     <kspwc:TextValidator runat="server" id="val1" ControlToValidate="LabelDuvod"></kspwc:TextValidator>   
                </asp:TableCell>
            </asp:TableRow>
            <asp:TableRow runat="server" ID="TableRowInsert5">
                <asp:TableCell runat="server" ID="TCInsert9" HorizontalAlign="right" SkinID="DataFieldHeaderStyle">
                    <asp:Label ID="Label4" runat="server" Text="[%Požadované datum vyřízení%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell runat="server" ID="TCInsert10" ColumnSpan="3" SkinID="DataFieldStyle">
                   <%-- <asp:TextBox ID="TextBoxDatVyrizeniInsert" runat="server" Text='<%# KSProgram.Funkce.F_DateTime.DateTimeToString(DataBinder.Eval(Container.DataItem,"vyridit_do"), "d") %>'
                        Width="95px"></asp:TextBox>
                    <ajax:CalendarExtender runat="server" ID="CalendarDatVyrizeni" TargetControlID="TextBoxDatVyrizeniInsert"
                        PopupButtonID="ImageButton3i">
                    </ajax:CalendarExtender>
                    <asp:ImageButton ID="ImageButton3i" runat="server" ImageUrl="~/Images/calendar.png" />--%>
                    <kspwc:TRadDatePicker runat="server" ID="TextBoxDatVyrizeniInsert" DbSelectedDate='<%# Bind("vyridit_do") %>' ></kspwc:TRadDatePicker>
                </asp:TableCell>
            </asp:TableRow>
            <asp:TableRow runat="server" ID="TableRowInsert6">
                <asp:TableCell runat="server" ID="TCInsert11" ColumnSpan="4">
                </asp:TableCell>
            </asp:TableRow>
        </asp:Table>
    </InsertItemTemplate>
    <FooterTemplate>
    <div>
        <asp:CustomValidator ID="PrekrytiIntervaluValidator" runat="server" Display="Dynamic" OnServerValidate="PrekrytiIntervaluValidator_validate"
            ErrorMessage="[%Překrývající požadavky nebo překročen denní fond, nelze pokračovat%]"></asp:CustomValidator>
    </div>

   <%-- <div>
        <asp:CustomValidator ID="UzavrenaDochazkaValidator" runat="server" Display="Dynamic" OnServerValidate="UzavrenaDochazkaValidator_validate"
            ErrorMessage="[%Docházka již byla potvrzena, nelze pokračovat%]"></asp:CustomValidator>
    </div>--%>

    <div>
        <asp:CustomValidator ID="min_validator" runat="server" ErrorMessage="[%Neplatné časové údaje%]" OnServerValidate="cas_validate"></asp:CustomValidator>
    </div>
    </FooterTemplate>
</asp:FormView>
