﻿<%@ Control Language="C#" AutoEventWireup="true" Inherits="Controls_ZadostOskol" Codebehind="ZadostOskol.ascx.cs" %>
<%@ Register Assembly="WebControls" Namespace="KSProgram.WebControls" TagPrefix="cc1" %>
<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>
<style>
    .rqvalid{
        padding-left:5px;
    }
    .rfdTable td{
        border: none;
    }
</style>
<telerik:RadFormDecorator ID="QsfFromDecorator" runat="server" DecoratedControls="CheckBoxes,RadioButtons,Select,Textarea,Textbox" EnableRoundedCorners="false" DecorationZoneID="FormView1"/>
<asp:ObjectDataSource ID="ObjectDataSource1"  runat="server" 
    OldValuesParameterFormatString="original_{0}" SelectMethod="Retrieve" 
    TypeName="KSProgram.Pozadavky.Pozadavekskol" InsertMethod="Insert" 
    oninserting="ObjectDataSource1_Inserting" 
    oninserted="ObjectDataSource1_Inserted" UpdateMethod="Update" 
    onupdating="ObjectDataSource1_Updating">
    <SelectParameters>
        <asp:Parameter Name="id_pozadavku" Type="Int32" DefaultValue="0" />
        <asp:Parameter Name="cislo_akce" Type="Int32" />
    </SelectParameters>
    <InsertParameters>
        <asp:Parameter Name="id_poz" Type="Int32" Direction="InputOutput" />
        <asp:Parameter Name="p_cislo" Type="Int32" />
        <asp:Parameter Name="duvod" Type="String" />
        <asp:Parameter Name="vyridit_do" Type="DateTime" />
        <asp:Parameter Name="adresat" Type="Decimal" />
    </InsertParameters>
    <UpdateParameters>
        <asp:Parameter Direction="InputOutput" Name="id_poz" Type="Int32" />
        <asp:Parameter Name="p_cislo" Type="Int32" />
        <asp:Parameter Name="duvod" Type="String" />
        <asp:Parameter Name="vyridit_do" Type="DateTime" />       
    </UpdateParameters>
</asp:ObjectDataSource>


<asp:FormView runat="server" ID="FormView1"  DataSourceID="ObjectDataSource1" oniteminserted="FormView1_ItemInserted" onitemupdated="FormView1_ItemUpdated"  ondatabound="FormView1_DataBound">
    <ItemTemplate>
        <asp:Table runat="server" ID="tableitem"  SkinID="RamAPozadi">
            <asp:TableHeaderRow runat="server" ID="TableHeaderRowItem">
                <asp:TableCell runat="server" ColumnSpan="3" ID="TableCellItem14x" SkinID="TitleRowStyle">
                    <asp:Label ID="Label7x" runat="server" Text="[%Přihlášení na školící akci%]"></asp:Label>
                </asp:TableCell>
            </asp:TableHeaderRow>
            <asp:TableRow runat="server" ID="tableitem_row1">
                <asp:TableCell runat="server" ID="tableitem_row1_cell1" SkinID="DataFieldHeaderStyle" HorizontalAlign="Right">
                    <asp:Label ID="osv_label" runat="server" SkinID="DataFieldHeaderStyle" Text="[%Vzdělávací aktivita%]:"></asp:Label></asp:TableCell>
                <asp:TableCell runat="server" ID="tableitem_row1_cell2" ColumnSpan="2" SkinID="DataFieldStyle">
                    <asp:Label ID="osv_data" runat="server" SkinID="DataFieldStyle" Text='<%# DataBinder.Eval(Container.DataItem, "nazev")%>'></asp:Label></asp:TableCell>                   
            </asp:TableRow>
            <asp:TableRow runat="server" ID="tableitem_row2">
                <asp:TableCell runat="server" ID="tableitem_row2_cell1" SkinID="DataFieldHeaderStyle" HorizontalAlign="Right">
                    <asp:Label ID="lektor_label" runat="server" SkinID="DataFieldHeaderStyle" Text="[%Lektor%]:"></asp:Label></asp:TableCell>
                <asp:TableCell runat="server" ID="tableitem_row2_cell2" ColumnSpan="2" SkinID="DataFieldStyle">
                    <asp:Label ID="lektor_data" runat="server" SkinID="DataFieldStyle" Text='<%# DataBinder.Eval(Container.DataItem, "lektor")%>'></asp:Label></asp:TableCell>
            </asp:TableRow>
            <asp:TableRow runat="server" ID="TableRow3">
                <asp:TableCell runat="server" ID="TableCell1" SkinID="DataFieldHeaderStyle" HorizontalAlign="Right">
                    <asp:Label ID="dat_od_label" runat="server" SkinID="DataFieldHeaderStyle" Text="[%Datum počátku%]:"></asp:Label></asp:TableCell>
                <asp:TableCell runat="server" ID="TableCell2" SkinID="DataFieldStyle" style="width:75px;">
                    <asp:Label ID="dat_od_data" runat="server" SkinID="DataFieldStyle"  Text='<%# KSProgram.Funkce.F_DateTime.DateTimeToString(DataBinder.Eval(Container.DataItem,"dat_od"), "d")%>'></asp:Label></asp:TableCell>
                <asp:TableCell runat="server" ID="TableCell3" SkinID="DataFieldStyle">
                    <asp:Label ID="cas_od_data" runat="server" SkinID="DataFieldStyle" Text='<%# Bind("cas_od")%>'></asp:Label></asp:TableCell>
            </asp:TableRow>
            <asp:TableRow runat="server" ID="TableRow1">
                <asp:TableCell runat="server" ID="TableCell4" SkinID="DataFieldHeaderStyle" HorizontalAlign="Right">
                    <asp:Label ID="Label2" runat="server" SkinID="DataFieldHeaderStyle" Text="[%Datum konce%]:"></asp:Label></asp:TableCell>
                <asp:TableCell runat="server" ID="TableCell5">
                    <asp:Label ID="dat_do_data" runat="server" style="width:75px;" Text='<%# KSProgram.Funkce.F_DateTime.DateTimeToString(DataBinder.Eval(Container.DataItem,"dat_do"), "d")%>'></asp:Label></asp:TableCell>
                <asp:TableCell runat="server" ID="TableCell6">
                    <asp:Label ID="cas_do_data" runat="server" Text='<%# DataBinder.Eval(Container.DataItem, "cas_do")%>'></asp:Label></asp:TableCell>
            </asp:TableRow>
            <asp:TableRow runat="server" ID="TableRow2">
                <asp:TableCell runat="server" ID="TableCell7" SkinID="DataFieldHeaderStyle" HorizontalAlign="Right">
                    <asp:Label ID="Label5" runat="server" SkinID="DataFieldHeaderStyle" Text="[%Místo%]:"></asp:Label></asp:TableCell>
                <asp:TableCell runat="server" ID="TableCell8" ColumnSpan="2" SkinID="DataFieldStyle">
                    <asp:Label ID="ucebna_data" runat="server" SkinID="DataFieldStyle" Text='<%# DataBinder.Eval(Container.DataItem, "ucebna")%>'></asp:Label></asp:TableCell>
            </asp:TableRow>
            <asp:TableRow runat="server" ID="TableRow4">
                <asp:TableCell runat="server" ID="TableCell9" SkinID="DataFieldHeaderStyle" HorizontalAlign="Right">
                    <asp:Label ID="Label7" runat="server" SkinID="DataFieldHeaderStyle" Text="[%Maximální počet účastníků%]:"></asp:Label></asp:TableCell>
                <asp:TableCell runat="server" ID="TableCell10" ColumnSpan="2" SkinID="DataFieldStyle">
                    <asp:Label ID="max_prihlasenych_data" runat="server" SkinID="DataFieldStyle" Text='<%# DataBinder.Eval(Container.DataItem, "max_prihlasenych")%>'></asp:Label></asp:TableCell>
            </asp:TableRow>
            <asp:TableRow runat="server" ID="TableRow5">
                <asp:TableCell runat="server" ID="TableCell11" SkinID="DataFieldHeaderStyle" HorizontalAlign="Right">
                    <asp:Label ID="Label9" runat="server" SkinID="DataFieldHeaderStyle" Text="[%Dosud přihlášených%]:"></asp:Label></asp:TableCell>
                <asp:TableCell runat="server" ID="TableCell12" ColumnSpan="2" SkinID="DataFieldStyle">
                    <asp:Label ID="prihlasenych_data" runat="server" SkinID="DataFieldStyle" Text='<%# DataBinder.Eval(Container.DataItem, "prihlasenych")%>'></asp:Label></asp:TableCell>
            </asp:TableRow>
            
            <asp:TableRow runat="server" ID="TableRow7">
                <asp:TableCell runat="server" ID="TableCell15" SkinID="DataFieldHeaderStyle" HorizontalAlign="Right">
                    <asp:Label ID="Label16" runat="server" Text="[%Obsah%]:"></asp:Label></asp:TableCell>
                <asp:TableCell runat="server" ID="TableCell16" ColumnSpan="2">
                    <asp:ObjectDataSource ID="ODS_ObsahAkce" runat="server" SelectMethod="ObsahAkce" TypeName="KSProgram.Vzdelavani.SkoliciAkce" OldValuesParameterFormatString="original_{0}">
                        <SelectParameters>
                            <asp:Parameter Name="pCislo" Type="Int32" />
                        </SelectParameters>
                    </asp:ObjectDataSource>
                    <cc1:TGridView ID="TGridView1" runat="server" DataSourceID="ODS_ObsahAkce">
                        <Columns>
                            <asp:BoundField DataField="cislo" HeaderText="[%Číslo%]"  />
                            <asp:BoundField DataField="nazev" HeaderText="[%Název%]"  />
                        </Columns>
                    </cc1:TGridView>
                </asp:TableCell>
            </asp:TableRow>
            
            <asp:TableRow  runat="server" ID="TableRowItem3">
            <asp:TableCell   runat="server" ID="TableCellItem7" SkinID="DataFieldHeaderStyle" HorizontalAlign="Right">
                <asp:Label ID="Label3x" runat="server" Text="[%Důvod%]:"></asp:Label>
            </asp:TableCell>
            <asp:TableCell ColumnSpan="3"   runat="server" ID="TableCellItem8" SkinID="DataFieldStyle">               
                <telerik:RadTextBox ID="Label3" runat="server" Text='<%# DataBinder.Eval(Container.DataItem,"duvod") %>' Height="59" Width="200px" 
                    ReadOnly="true" TextMode="MultiLine" ></telerik:RadTextBox>
            </asp:TableCell>
            </asp:TableRow>
            
            <asp:TableRow runat="server" ID="TableRow11">
                <asp:TableCell runat="server" ID="TableCell23" SkinID="DataFieldHeaderStyle" HorizontalAlign="Right">
                    <asp:Label ID="Label23" runat="server" SkinID="DataFieldHeaderStyle" Text="[%Vyřešit do%]:"></asp:Label></asp:TableCell>
                <asp:TableCell runat="server" ID="TableCell24" ColumnSpan="2" SkinID="DataFieldStyle" style="width:75px;">
                    <asp:Label ID="Label24" runat="server" SkinID="DataFieldStyle" Text='<%# KSProgram.Funkce.F_DateTime.DateTimeToString(DataBinder.Eval(Container.DataItem,"vyridit_do"), "d")%>'></asp:Label></asp:TableCell>
            </asp:TableRow>
            <asp:TableRow runat="server" ID="TableRow9">
                <asp:TableCell runat="server" ID="TableCell19" SkinID="DataFieldHeaderStyle" HorizontalAlign="Right">
                    <asp:Label ID="Label19" runat="server" SkinID="DataFieldHeaderStyle" Text="[%Stav%]:"></asp:Label></asp:TableCell>
                <asp:TableCell runat="server" ID="TableCell20" ColumnSpan="2" SkinID="DataFieldStyle">
                    <asp:Label ID="Label20" runat="server" SkinID="DataFieldStyle" Text='<%# DataBinder.Eval(Container.DataItem, "stav")%>'></asp:Label></asp:TableCell>
            </asp:TableRow>
        </asp:Table>
    </ItemTemplate>
    <InsertItemTemplate>
    
        <asp:Table runat="server" ID="tableitem"  SkinID="RamAPozadi">
            <asp:TableHeaderRow runat="server" ID="TableHeaderRowItem">
                <asp:TableCell runat="server" ColumnSpan="3" ID="TableCellItem14x" SkinID="TitleRowStyle">
                    <asp:Label ID="Label7x" runat="server" Text="[%Přihlášení na školící akci%]"></asp:Label>
                </asp:TableCell>
            </asp:TableHeaderRow>
            <asp:TableRow runat="server" ID="TableRow12">
                <asp:TableCell runat="server" ID="TableCell25" SkinID="DataFieldHeaderStyle" HorizontalAlign="right">
                    <asp:Label ID="Label1" runat="server" SkinID="DataFieldHeaderStyle" Text="[%Školící akce%]:"></asp:Label></asp:TableCell>
                <asp:TableCell runat="server" ID="TableCell26" ColumnSpan="2" SkinID="DataFieldStyle">
                    <asp:ObjectDataSource runat="server" ID="ods_nabidka_akci" OldValuesParameterFormatString="original_{0}" SelectMethod="NabidkaAkci" TypeName="KSProgram.Pozadavky.PozadavekSkol"></asp:ObjectDataSource>
                    <kspwc:TRadComboBox runat="server" ID="ddlb_nabidka"  DataSourceID="ods_nabidka_akci" AutoPostBack="True" DataTextField="nazev" DataValueField="cislo" OnSelectedIndexChanged="ddlb_nabidka_SelectedIndexChanged" DropDownAutoWidth="Enabled" Width="100%">
                    </kspwc:TRadComboBox>
                    <span class="rqvalid">
                    <kspwc:TRequiredValidator runat="server" ID="rv_nabidka_akci" ControlToValidate="ddlb_nabidka"></kspwc:TRequiredValidator>
                    </span>
                </asp:TableCell>
            </asp:TableRow>
            
            <asp:TableRow runat="server" ID="tableinsert_row1">
                <asp:TableCell runat="server" ID="tableinsert_row1_cell1" SkinID="DataFieldHeaderStyle" HorizontalAlign="right">
                    <asp:Label ID="osv_label" runat="server" SkinID="DataFieldHeaderStyle" Text="[%Vzdělávací aktivita%]:"></asp:Label></asp:TableCell>
                <asp:TableCell runat="server" ID="tableinsert_row1_cell2" ColumnSpan="2" SkinID="DataFieldStyle">
                    <asp:Label ID="osv_data" runat="server" SkinID="DataFieldStyle" Text='<%# DataBinder.Eval(Container.DataItem, "osv_nazev")%>'></asp:Label></asp:TableCell>
            </asp:TableRow>
            <asp:TableRow runat="server" ID="tableinsert_row2">
                <asp:TableCell runat="server" ID="tableinsert_row2_cell1" SkinID="DataFieldHeaderStyle" HorizontalAlign="right">
                    <asp:Label ID="lektor_label" runat="server" SkinID="DataFieldHeaderStyle" Text="[%Lektor%]:"></asp:Label></asp:TableCell>
                <asp:TableCell runat="server" ID="tableinsert_row2_cell2" ColumnSpan="2" SkinID="DataFieldStyle">
                    <asp:Label ID="lektor_data" runat="server" SkinID="DataFieldStyle" Text='<%# DataBinder.Eval(Container.DataItem, "lektor")%>'></asp:Label></asp:TableCell>
            </asp:TableRow>
            <asp:TableRow runat="server" ID="TableRow3">
                <asp:TableCell runat="server" ID="TableCell1" SkinID="DataFieldHeaderStyle" HorizontalAlign="right">
                    <asp:Label ID="dat_od_label" runat="server" SkinID="DataFieldHeaderStyle" Text="[%Datum počátku%]:"></asp:Label></asp:TableCell>
                <asp:TableCell runat="server" ID="TableCell2" SkinID="DataFieldStyle" style="width:75px;">
                    <asp:Label ID="dat_od_data" runat="server" SkinID="DataFieldStyle" Text='<%# KSProgram.Funkce.F_DateTime.DateTimeToString(DataBinder.Eval(Container.DataItem,"dat_od"), "d")%>'></asp:Label></asp:TableCell>
                <asp:TableCell runat="server" ID="TableCell3" SkinID="DataFieldStyle" >
                    <asp:Label ID="cas_od_data" runat="server" SkinID="DataFieldStyle" Text='<%# DataBinder.Eval(Container.DataItem, "cas_od")%>'></asp:Label></asp:TableCell>
            </asp:TableRow>
            <asp:TableRow runat="server" ID="TableRow1">
                <asp:TableCell runat="server" ID="TableCell4" SkinID="DataFieldHeaderStyle" HorizontalAlign="right">
                    <asp:Label ID="Label2" runat="server" SkinID="DataFieldHeaderStyle" Text="[%Datum konce%]:"></asp:Label></asp:TableCell>
                <asp:TableCell runat="server" ID="TableCell5" SkinID="DataFieldStyle" style="width:75px;">
                    <asp:Label ID="dat_do_data" runat="server" SkinID="DataFieldStyle" Text='<%# KSProgram.Funkce.F_DateTime.DateTimeToString(DataBinder.Eval(Container.DataItem,"dat_do"), "d")%>'></asp:Label></asp:TableCell>
                <asp:TableCell runat="server" ID="TableCell6" SkinID="DataFieldStyle" >
                    <asp:Label ID="cas_do_data" runat="server" SkinID="DataFieldStyle" Text='<%# DataBinder.Eval(Container.DataItem, "cas_do")%>'></asp:Label></asp:TableCell>
            </asp:TableRow>
            <asp:TableRow runat="server" ID="TableRow2">
                <asp:TableCell runat="server" ID="TableCell7" SkinID="DataFieldHeaderStyle" HorizontalAlign="right">
                    <asp:Label ID="Label5" runat="server" SkinID="DataFieldHeaderStyle" Text="[%Místo%]:"></asp:Label></asp:TableCell>
                <asp:TableCell runat="server" ID="TableCell8" ColumnSpan="2" SkinID="DataFieldStyle">
                    <asp:Label ID="ucebna_data" runat="server" SkinID="DataFieldStyle" Text='<%# DataBinder.Eval(Container.DataItem, "ucebna")%>'></asp:Label></asp:TableCell>
            </asp:TableRow>
            <asp:TableRow runat="server" ID="TableRow4">
                <asp:TableCell runat="server" ID="TableCell9" SkinID="DataFieldHeaderStyle" HorizontalAlign="right">
                    <asp:Label ID="Label7" runat="server" SkinID="DataFieldHeaderStyle" Text="[%Maximální počet účastníků%]:"></asp:Label></asp:TableCell>
                <asp:TableCell runat="server" ID="TableCell10" ColumnSpan="2" SkinID="DataFieldStyle">
                    <asp:Label ID="max_prihlasenych_data" runat="server" SkinID="DataFieldStyle" Text='<%# DataBinder.Eval(Container.DataItem, "max_prihlasenych")%>'></asp:Label></asp:TableCell>
            </asp:TableRow>
            <asp:TableRow runat="server" ID="TableRow5">
                <asp:TableCell runat="server" ID="TableCell11" SkinID="DataFieldHeaderStyle" HorizontalAlign="right">
                    <asp:Label ID="Label9" runat="server" SkinID="DataFieldHeaderStyle" Text="[%Dosud přihlášených%]:"></asp:Label></asp:TableCell>
                <asp:TableCell runat="server" ID="TableCell12" ColumnSpan="2" SkinID="DataFieldStyle">
                    <asp:Label ID="prihlasenych_data" runat="server" SkinID="DataFieldStyle" Text='<%# DataBinder.Eval(Container.DataItem, "prihlasenych")%>'></asp:Label></asp:TableCell>
            </asp:TableRow>           
          
            <asp:TableRow runat="server" ID="TableRow7">
                <asp:TableCell runat="server" ID="TableCell15" SkinID="DataFieldHeaderStyle" HorizontalAlign="right">
                    <asp:Label ID="Label16" runat="server" SkinID="DataFieldHeaderStyle" Text="[%Obsah%]:"></asp:Label></asp:TableCell>
                <asp:TableCell runat="server" ID="TableCell16" ColumnSpan="2">
                    <asp:ObjectDataSource ID="ODS_ObsahAkce" runat="server" SelectMethod="ObsahAkce" TypeName="KSProgram.Vzdelavani.SkoliciAkce" OldValuesParameterFormatString="original_{0}">
                        <SelectParameters>
                            <asp:Parameter Name="pCislo" Type="Int32" />
                        </SelectParameters>
                    </asp:ObjectDataSource>
                    <cc1:TGridView ID="TGridView1" runat="server" DataSourceID="ODS_ObsahAkce" >
                        <Columns>
                            <asp:BoundField DataField="cislo" HeaderText="[%Číslo%]"  />
                            <asp:BoundField DataField="nazev" HeaderText="[%Název%]"  />
                        </Columns>
                    </cc1:TGridView>
                </asp:TableCell>
            </asp:TableRow>
                        
            <asp:TableRow runat="server" ID="TableRow14">
                <asp:TableCell runat="server" ID="TCInsert7" HorizontalAlign="right" SkinID="DataFieldHeaderStyle">
                    <asp:Label ID="Label31" runat="server" Text="[%Důvod%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell runat="server" ID="TCInsert8" ColumnSpan="3" SkinID="DataFieldStyle">
                    <telerik:RadTextBox ID="duvod_data" runat="server" Text='<%# Bind("duvod") %>' MaxLength="990" TextMode="MultiLine" Width="283px" Height="200"></telerik:RadTextBox><br />
                    <kspwc:TextValidator runat="server" id="val1" ControlToValidate="duvod_data"></kspwc:TextValidator>
                </asp:TableCell>
            </asp:TableRow>
            
            <asp:TableRow runat="server" ID="TableRow11">
                <asp:TableCell  runat="server" ID="TCInsert9"  HorizontalAlign="right" SkinID="DataFieldHeaderStyle">
                    <asp:Label ID="Label10" runat="server" Text="[%Požadované datum vyřízení%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell  runat="server" ID="TCInsert10"  ColumnSpan="2" SkinID="DataFieldStyle">                   
                    <kspwc:TRadDatePicker runat="server" ID="TextBoxDatVyrizeniInsert" DbSelectedDate='<%# Bind("vyridit_do") %>' ></kspwc:TRadDatePicker>
                </asp:TableCell>
            </asp:TableRow>
                   
            <asp:TableRow runat="server" ID="TableRow13" >
                <asp:TableCell runat="server" ID="TableCell27" ColumnSpan="3">                 
             </asp:TableCell>
            </asp:TableRow>         
        </asp:Table>
    </InsertItemTemplate>
    <EditItemTemplate>
      <asp:Table runat="server" ID="tableitem"  SkinID="RamAPozadi">
            <asp:TableHeaderRow runat="server" ID="TableHeaderRowItem">
                <asp:TableCell runat="server" ColumnSpan="3" ID="TableCellItem14x" SkinID="TitleRowStyle">
                    <asp:Label ID="Label7x" runat="server" Text="[%Přihlášení na školící akci%]"></asp:Label>
                </asp:TableCell>
            </asp:TableHeaderRow>
            <asp:TableRow runat="server" ID="TableRow12">
                <asp:TableCell runat="server" ID="TableCell25" SkinID="DataFieldHeaderStyle" HorizontalAlign="right">
                    <asp:Label ID="Label1" runat="server" SkinID="DataFieldHeaderStyle" Text="[%Školící akce%]:"></asp:Label></asp:TableCell>
                <asp:TableCell runat="server" ID="TableCell26" ColumnSpan="2" SkinID="DataFieldStyle">
                    <asp:ObjectDataSource runat="server" ID="ods_nabidka_akci" OldValuesParameterFormatString="original_{0}" SelectMethod="NabidkaAkci" TypeName="KSProgram.Pozadavky.PozadavekSkol"></asp:ObjectDataSource>
                    <kspwc:TRadComboBox runat="server" ID="ddlb_nabidka"  DataSourceID="ods_nabidka_akci" AutoPostBack="True" DataTextField="nazev" DataValueField="cislo" OnSelectedIndexChanged="ddlb_nabidka_SelectedIndexChanged" DropDownAutoWidth="Enabled" Width="100%">
                    </kspwc:TRadComboBox>
                    <span class="rqvalid">
                    <kspwc:TRequiredValidator runat="server" ID="rv_nabidka_akci_edit" ControlToValidate="ddlb_nabidka"></kspwc:TRequiredValidator>
                    </span>
                </asp:TableCell>
            </asp:TableRow>
            
            <asp:TableRow runat="server" ID="tableinsert_row1">
                <asp:TableCell runat="server" ID="tableinsert_row1_cell1" SkinID="DataFieldHeaderStyle" HorizontalAlign="right">
                    <asp:Label ID="osv_label" runat="server" SkinID="DataFieldHeaderStyle" Text="[%Vzdělávací aktivita%]:"></asp:Label></asp:TableCell>
                <asp:TableCell runat="server" ID="tableinsert_row1_cell2" ColumnSpan="2" SkinID="DataFieldStyle">
                    <asp:Label ID="osv_data" runat="server" SkinID="DataFieldStyle" Text='<%# DataBinder.Eval(Container.DataItem, "osv_nazev")%>'></asp:Label></asp:TableCell>
            </asp:TableRow>
            <asp:TableRow runat="server" ID="tableinsert_row2">
                <asp:TableCell runat="server" ID="tableinsert_row2_cell1" SkinID="DataFieldHeaderStyle" HorizontalAlign="right">
                    <asp:Label ID="lektor_label" runat="server" SkinID="DataFieldHeaderStyle" Text="[%Lektor%]:"></asp:Label></asp:TableCell>
                <asp:TableCell runat="server" ID="tableinsert_row2_cell2" ColumnSpan="2" SkinID="DataFieldStyle">
                    <asp:Label ID="lektor_data" runat="server" SkinID="DataFieldStyle" Text='<%# DataBinder.Eval(Container.DataItem, "lektor")%>'></asp:Label></asp:TableCell>
            </asp:TableRow>
            <asp:TableRow runat="server" ID="TableRow3">
                <asp:TableCell runat="server" ID="TableCell1" SkinID="DataFieldHeaderStyle" HorizontalAlign="right">
                    <asp:Label ID="dat_od_label" runat="server" SkinID="DataFieldHeaderStyle" Text="[%Datum počátku%]:"></asp:Label></asp:TableCell>
                <asp:TableCell runat="server" ID="TableCell2" SkinID="DataFieldStyle" style="width:75px;">
                    <asp:Label ID="dat_od_data" runat="server" SkinID="DataFieldStyle" Text='<%# KSProgram.Funkce.F_DateTime.DateTimeToString(DataBinder.Eval(Container.DataItem,"dat_od"), "d")%>'></asp:Label></asp:TableCell>
                <asp:TableCell runat="server" ID="TableCell3" SkinID="DataFieldStyle" >
                    <asp:Label ID="cas_od_data" runat="server" SkinID="DataFieldStyle" Text='<%# DataBinder.Eval(Container.DataItem, "cas_od")%>'></asp:Label></asp:TableCell>
            </asp:TableRow>
            <asp:TableRow runat="server" ID="TableRow1">
                <asp:TableCell runat="server" ID="TableCell4" SkinID="DataFieldHeaderStyle" HorizontalAlign="right">
                    <asp:Label ID="Label2" runat="server" SkinID="DataFieldHeaderStyle" Text="[%Datum konce%]:"></asp:Label></asp:TableCell>
                <asp:TableCell runat="server" ID="TableCell5" SkinID="DataFieldStyle" style="width:75px;">
                    <asp:Label ID="dat_do_data" runat="server" SkinID="DataFieldStyle" Text='<%# KSProgram.Funkce.F_DateTime.DateTimeToString(DataBinder.Eval(Container.DataItem,"dat_do"), "d")%>'></asp:Label></asp:TableCell>
                <asp:TableCell runat="server" ID="TableCell6" SkinID="DataFieldStyle" >
                    <asp:Label ID="cas_do_data" runat="server" SkinID="DataFieldStyle" Text='<%# DataBinder.Eval(Container.DataItem, "cas_do")%>'></asp:Label></asp:TableCell>
            </asp:TableRow>
            <asp:TableRow runat="server" ID="TableRow2">
                <asp:TableCell runat="server" ID="TableCell7" SkinID="DataFieldHeaderStyle" HorizontalAlign="right">
                    <asp:Label ID="Label5" runat="server" SkinID="DataFieldHeaderStyle" Text="[%Místo%]:"></asp:Label></asp:TableCell>
                <asp:TableCell runat="server" ID="TableCell8" ColumnSpan="2" SkinID="DataFieldStyle">
                    <asp:Label ID="ucebna_data" runat="server" SkinID="DataFieldStyle" Text='<%# DataBinder.Eval(Container.DataItem, "ucebna")%>'></asp:Label></asp:TableCell>
            </asp:TableRow>
            <asp:TableRow runat="server" ID="TableRow4">
                <asp:TableCell runat="server" ID="TableCell9" SkinID="DataFieldHeaderStyle" HorizontalAlign="right">
                    <asp:Label ID="Label7" runat="server" SkinID="DataFieldHeaderStyle" Text="[%Maximální počet účastníků%]:"></asp:Label></asp:TableCell>
                <asp:TableCell runat="server" ID="TableCell10" ColumnSpan="2" SkinID="DataFieldStyle">
                    <asp:Label ID="max_prihlasenych_data" runat="server" SkinID="DataFieldStyle" Text='<%# DataBinder.Eval(Container.DataItem, "max_prihlasenych")%>'></asp:Label></asp:TableCell>
            </asp:TableRow>
            <asp:TableRow runat="server" ID="TableRow5">
                <asp:TableCell runat="server" ID="TableCell11" SkinID="DataFieldHeaderStyle" HorizontalAlign="right">
                    <asp:Label ID="Label9" runat="server" SkinID="DataFieldHeaderStyle" Text="[%Dosud přihlášených%]:"></asp:Label></asp:TableCell>
                <asp:TableCell runat="server" ID="TableCell12" ColumnSpan="2" SkinID="DataFieldStyle">
                    <asp:Label ID="prihlasenych_data" runat="server" SkinID="DataFieldStyle" Text='<%# DataBinder.Eval(Container.DataItem, "prihlasenych")%>'></asp:Label></asp:TableCell>
            </asp:TableRow>            
            <asp:TableRow runat="server" ID="TableRow7">
                <asp:TableCell runat="server" ID="TableCell15" SkinID="DataFieldHeaderStyle" HorizontalAlign="right">
                    <asp:Label ID="Label16" runat="server" SkinID="DataFieldHeaderStyle" Text="[%Obsah%]:"></asp:Label></asp:TableCell>
                <asp:TableCell runat="server" ID="TableCell16" ColumnSpan="2">
                    <asp:ObjectDataSource ID="ODS_ObsahAkce" runat="server" SelectMethod="ObsahAkce" TypeName="KSProgram.Vzdelavani.SkoliciAkce" OldValuesParameterFormatString="original_{0}">
                        <SelectParameters>
                            <asp:Parameter Name="pCislo" Type="Int32" />
                        </SelectParameters>
                    </asp:ObjectDataSource>
                    <cc1:TGridView ID="TGridView1" runat="server" DataSourceID="ODS_ObsahAkce" >
                        <Columns>
                            <asp:BoundField DataField="cislo" HeaderText="[%Číslo%]"  />
                            <asp:BoundField DataField="nazev" HeaderText="[%Název%]"  />
                        </Columns>
                    </cc1:TGridView>
                </asp:TableCell>
            </asp:TableRow>
                        
            <asp:TableRow runat="server" ID="TableRow14">
                <asp:TableCell runat="server" ID="TCInsert7" HorizontalAlign="right" SkinID="DataFieldHeaderStyle">
                    <asp:Label ID="Label31" runat="server" Text="[%Důvod%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell runat="server" ID="TCInsert8" ColumnSpan="3" SkinID="DataFieldStyle">
                    <telerik:RadTextBox ID="duvod_data" runat="server" Text='<%# Bind("duvod") %>' MaxLength="990" TextMode="MultiLine" Width="283px" Height="200"></telerik:RadTextBox><br />
                    <kspwc:TextValidator runat="server" id="val2" ControlToValidate="duvod_data"></kspwc:TextValidator>
                </asp:TableCell>
            </asp:TableRow>
            
            <asp:TableRow runat="server" ID="TableRow11">
                <asp:TableCell  runat="server" ID="TCInsert9"  HorizontalAlign="right" SkinID="DataFieldHeaderStyle">
                    <asp:Label ID="Label10" runat="server" Text="[%Požadované datum vyřízení%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell  runat="server" ID="TCInsert10"  ColumnSpan="2" SkinID="DataFieldStyle">                   
                    <kspwc:TRadDatePicker runat="server" ID="TextBoxDatVyrizeniInsert" DbSelectedDate='<%# Bind("vyridit_do") %>'></kspwc:TRadDatePicker>
                </asp:TableCell>                        
            </asp:TableRow>
                   
            <asp:TableRow runat="server" ID="TableRow13" >
                <asp:TableCell runat="server" ID="TableCell27" ColumnSpan="3">                 
             </asp:TableCell>
            </asp:TableRow>           
            
            
        </asp:Table>
    </EditItemTemplate>
</asp:FormView>
 <asp:CustomValidator ID="OpakovanePrihlaseniValidator" runat="server" OnServerValidate="OpakovanePrihlaseni_validate"></asp:CustomValidator>