﻿<%@ Page Language="C#" MasterPageFile="~/Main.Master" AutoEventWireup="true" Inherits="Zamestnanec_DokumentyPrijate"
    CodeBehind="DokumentyPrijate.aspx.cs" %>

<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>
<%@ Register Assembly="WebControls" Namespace="KSProgram.WebControls" TagPrefix="wc" %>
<%@ Register Assembly="WebControlsAlone" Namespace="KSProgram.WebControlsAlone" TagPrefix="wca" %>
<%@ Register Src="~/Dokumenty/PdfViewer.ascx" TagName="PdfViewer" TagPrefix="pdf" %>
<asp:Content ID="Content1" ContentPlaceHolderID="HlavniOblast" runat="Server">
    <style type="text/css">
        .RadForm_Metro {
            background: var(--kscolor2);
            color: var(--kscolor2text);
        }
    </style>
    <telerik:RadAjaxManagerProxy ID="RadAjaxManagerProxy1" runat="server">
        <AjaxSettings>
            <telerik:AjaxSetting AjaxControlID="RadGrid2">
                <UpdatedControls>
                    <telerik:AjaxUpdatedControl ControlID="RadGrid2"></telerik:AjaxUpdatedControl>
                    <telerik:AjaxUpdatedControl ControlID="RW_Dokument" />
                </UpdatedControls>
            </telerik:AjaxSetting>
        </AjaxSettings>
    </telerik:RadAjaxManagerProxy>

    <asp:ObjectDataSource ID="ODS_DocType" runat="server" OldValuesParameterFormatString="original_{0}"
        SelectMethod="TypyDokumentu" TypeName="KSProgram.Dokument.DokumentyPrijate"></asp:ObjectDataSource>

    <asp:ObjectDataSource ID="ODS_typy" runat="server" OldValuesParameterFormatString="original_{0}"
        SelectMethod="TypyDokumentu" TypeName="KSProgram.Dokument.DokumentyPrijate">
        <SelectParameters>
            <asp:Parameter Type="Int16" Name="vych_hodn_portal" DefaultValue="1" />
        </SelectParameters>
    </asp:ObjectDataSource>

    <kspwc:TRadGrid ID="RadGrid2" runat="server" AutoGenerateColumns="False" OnNeedDataSource="RadGrid2_NeedDataSource"
        AllowSorting="True" OnItemCommand="RadGrid2_ItemCommand" OnInsertCommand="RadGrid2_InsertCommand" ExportSettings-ExportOnlyData="false"
        OnItemCreated="RadGrid2_ItemCreated"
        OnItemDataBound="RadGrid2_ItemDataBound" IdPravaEditace="343">
        <MasterTableView DataKeyNames="id,id_blob,nazev_souboru,uloziste" AutoGenerateColumns="false" Caption="[%Dokumenty přijaté%]"
            CommandItemDisplay="Top" AllowFilteringByColumn="False">
            <EditFormSettings>
                <EditColumn ButtonType="ImageButton"></EditColumn>
            </EditFormSettings>
            <Columns>
                <telerik:GridTemplateColumn UniqueName="typ_dokumentu" AllowSorting="true" AllowFiltering="true" SortExpression="nazev_typu" DataType="System.String" HeaderText="[%Typ dokumentu%]"
                    DataField="nazev_typu">
                    <ItemTemplate>
                        <%# Eval("nazev_typu") %>
                    </ItemTemplate>
                    <InsertItemTemplate>
                        <kspwc:TRadComboBox runat="server" ID="TRCB_item" DataSourceID="ODS_typy" EnableAutomaticLoadOnDemand="true" EnableVirtualScrolling="true"
                            DataValueField="id" DataTextField="nazev">
                        </kspwc:TRadComboBox>
                        <kspwc:TRequiredValidator runat="server" ID="TRV" ControlToValidate="TRCB_item"></kspwc:TRequiredValidator>
                    </InsertItemTemplate>
                </telerik:GridTemplateColumn>
                <telerik:GridDateTimeColumn UniqueName="datum_prijeti" PickerType="DatePicker" HeaderText="[%Datum přijetí%]" DataType="System.DateTime"
                    DataField="datum_prijeti" DataFormatString="{0:d.M.yyyy}" EditDataFormatString="d.M.yyyy"
                    InsertVisiblityMode="AlwaysHidden">
                </telerik:GridDateTimeColumn>
                <telerik:GridBoundColumn UniqueName="vystavil" HeaderText="[%Vystavil%]" DataField="vystavil"
                    MaxLength="50">
                </telerik:GridBoundColumn>
                <telerik:GridDateTimeColumn UniqueName="datum_vystaveni" PickerType="DatePicker" DataType="System.DateTime"
                    HeaderText="[%Datum vystavení%]" DataField="datum_vystaveni" DataFormatString="{0:d.M.yyyy}"
                    EditDataFormatString="d.M.yyyy">
                </telerik:GridDateTimeColumn>
                <telerik:GridBoundColumn UniqueName="poznamka" HeaderText="[%Poznámka%]" DataField="poznamka"
                    MaxLength="50">
                </telerik:GridBoundColumn>
                <telerik:GridAttachmentColumn UploadControlType="RadAsyncUpload" EditFormHeaderTextFormat="Nahrát soubor:"
                    HeaderText="[%Dokument%]" FileNameTextField="nazev_souboru" DataTextField="nazev_souboru"
                    UniqueName="dokument" AllowedFileExtensions="txt,bmp,jpg,png,doc,docx,xml,csv,xls,xlsx,ods,odt,pdf,emf,oxps"
                    AttachmentKeyFields="id" ButtonCssClass="no-block-ui">
                </telerik:GridAttachmentColumn>
                <telerik:GridButtonColumn UniqueName="nahled" ImageUrl="../css/images/go_search.png" ButtonType="ImageButton" Text="[%Náhled%]" CommandName="preview"></telerik:GridButtonColumn>
            </Columns>
            <CommandItemTemplate>
                <kspwc:GridCommandItemControl ID="GCIC" runat="server" FilterButton-Visible="false" ExportButton-Visible="false">
                    <AddNewItemButton runat="server" IdPrava="343" Visible="true"></AddNewItemButton>
                    <ContentTemplate>
                        <telerik:RadDropDownList ID="RDDL_TypDoc" runat="server" DataTextField="nazev" Width="270px"
                            DataValueField="id" ToolTip="[%Typ dokumentu%]" AppendDataBoundItems="true"
                            AutoPostBack="true" DataSourceID="ODS_DocType"
                            OnLoad="RDDL_TypDoc_Load"
                            OnSelectedIndexChanged="RDDL_TypDoc_SelectedIndexChanged">
                            <Items>
                                <telerik:DropDownListItem Value="" Text="- [%Vše%] -" />
                            </Items>
                        </telerik:RadDropDownList>
                    </ContentTemplate>
                </kspwc:GridCommandItemControl>
            </CommandItemTemplate>
        </MasterTableView>
    </kspwc:TRadGrid>

    <telerik:RadWindow ID="RW_Dokument" runat="server" Behaviors="Close,Resize,Move,Pin" Modal="false"
        Title="[%Dokument%]" VisibleOnPageLoad="false" Height="1024px" Width="800px" Top="60">
        <ContentTemplate>
            <pdf:PdfViewer runat="server" ID="PV_viewer" Height="100%" Width="100%" ParentWindowPozice="Right" EnableDownload="true"></pdf:PdfViewer>
        </ContentTemplate>
    </telerik:RadWindow>
</asp:Content>
