﻿<%@ Page Language="C#" MasterPageFile="~/Main.Master" AutoEventWireup="true"
    Inherits="Sestavy_Hodnoceni" Codebehind="Hodnoceni.aspx.cs" %>

<%@ Register Assembly="WebControls" Namespace="KSProgram.WebControls" TagPrefix="wc" %>
<asp:Content ID="Content1" ContentPlaceHolderID="HlavniOblast" runat="Server">
    <asp:ObjectDataSource ID="DS_hlavicka" runat="server" OldValuesParameterFormatString="original_{0}"
        SelectMethod="Hlavicka" TypeName="KSProgram.Hodnoceni.Hodnoceni">
        <SelectParameters>
            <asp:Parameter Name="Id" Type="Int32" />
        </SelectParameters>
    </asp:ObjectDataSource>
    <asp:FormView ID="FV_hlavicka" runat="server" DataSourceID="DS_hlavicka" OnDataBinding="FV_hlavicka_DataBinding"
        DataKeyNames="os_cislo,datum_od,datum_do" OnDataBound="FV_hlavicka_DataBound">
        <ItemTemplate>
            <table style="border-color: #000000; border-collapse: collapse; border-style: solid;
                border-width: thin" width="640px">
                <tr style="border-color: #000000; border-collapse: collapse; border-style: solid;
                    border-width: thin">
                    <td style="padding: 5px; background-color: #C0C0C0;" align="center">
                        <asp:Label ID="LabelNazevAkce" runat="server" Font-Bold="True" Font-Size="Large"
                            Text="[%Záznamový list hodnocení%]"></asp:Label><br />
                        <asp:Label ID="LabelDbNazevAkce" runat="server" Font-Bold="True" Font-Size="Larger"
                            Text='<%# Bind("nazev_akce") %>'></asp:Label>
                    </td>
                </tr>
            </table>
            <br />
            <table style="border-color: #000000; border-collapse: collapse; border-style: solid;
                border-width: thin" width="640px">
                <tr style="border-color: #000000; border-collapse: collapse; border-style: solid;
                    border-width: thin">
                    <td style="padding: 5px; border-bottom-style: solid; border-bottom-width: thin; border-bottom-color: #000000;">
                        <asp:Label ID="LabelJmeno" runat="server" Text="[%Hodnocený zaměstnanec%]: "></asp:Label>
                    </td>
                    <td style="padding: 5px; border-bottom-style: solid; border-bottom-width: thin; border-bottom-color: #000000;">
                        <asp:Label ID="LabelDbJmeno" runat="server" Font-Bold="True" Font-Size="Larger" Text='<%# Bind("zamestnanec") %>'></asp:Label>
                    </td>
                    <td style="padding: 5px; border-left-style: solid; border-left-width: thin; border-left-color: #000000;
                        border-bottom-style: solid; border-bottom-width: thin; border-bottom-color: #000000;">
                        <asp:Label ID="LabelOsCislo" runat="server" Text="[%Os. číslo%]: "></asp:Label>
                    </td>
                    <td style="padding: 5px; border-bottom-style: solid; border-bottom-width: thin; border-bottom-color: #000000;">
                        <asp:Label ID="LabelDbOsCislo" runat="server" Text='<%# Bind("os_cislo") %>'></asp:Label>
                    </td>
                </tr>
                <tr style="border-color: #000000; border-collapse: collapse; border-style: solid;
                    border-width: thin">
                    <td style="padding: 5px; border-bottom-style: solid; border-bottom-width: thin; border-bottom-color: #000000;">
                        <asp:Label ID="LabelNazevMista" runat="server" Text="[%Název pracovního místa%]: "></asp:Label>
                    </td>
                    <td style="padding: 5px; border-bottom-style: solid; border-bottom-width: thin; border-bottom-color: #000000;">
                        <asp:Label ID="LabelDbNazevMista" runat="server" Text='<%# Bind("prac_misto") %>'></asp:Label>
                    </td>
                    <td style="padding: 5px; border-left-style: solid; border-left-width: thin; border-left-color: #000000;
                        border-bottom-style: solid; border-bottom-width: thin; border-bottom-color: #000000;">
                        <asp:Label ID="LabelCisloMista" runat="server" Text="[%Číslo pr. místa%]: "></asp:Label>
                    </td>
                    <td style="padding: 5px; border-bottom-style: solid; border-bottom-width: thin; border-bottom-color: #000000;">
                        <asp:Label ID="LabelDbCisloMista" runat="server" Text='<%# Bind("cislo_PM") %>'></asp:Label>
                    </td>
                </tr>
                <tr style="border-color: #000000; border-collapse: collapse; border-style: solid;
                    border-width: thin">
                    <td style="padding: 5px; border-bottom-style: solid; border-bottom-width: thin; border-bottom-color: #000000;">
                        <asp:Label ID="LabelOdbor" runat="server" Text="[%Středisko%]: "></asp:Label>
                    </td>
                    <td style="padding: 5px; border-bottom-style: solid; border-bottom-width: thin; border-bottom-color: #000000;"
                        colspan="3">
                        <asp:Label ID="LabelDbOdbor" runat="server" Text='<%# Bind("stredisko") %>'></asp:Label>
                    </td>
                </tr>
                <tr style="border-color: #000000; border-collapse: collapse; border-style: solid;
                    border-width: thin">
                    <td style="padding: 5px">
                        <asp:Label ID="LabelObdobi" runat="server" Text="[%Hodnocené období%]: "></asp:Label>
                    </td>
                    <td style="padding: 5px" colspan="3">
                        <asp:Label ID="LabelDbObdobiOd" runat="server" Text='<%# Eval("datum_od", "{0:d}") %>'></asp:Label>
                        -
                        <asp:Label ID="LabelDbObdobiDo" runat="server" Text='<%# Eval("datum_do", "{0:d}") %>'></asp:Label>
                    </td>
                </tr>
            </table>
            <br />
            <table style="border: 1px solid #000000; width: 100%; border-collapse: collapse;">
                <tr>
                    <td>
                        [%Obeznámen%]:</td>
                    <td style="border-right-style: solid; border-right-width: 1px; border-right-color: #000000">
                        <wc:TLabel ID="TL_obeznamen" runat="server"></wc:TLabel>
                    </td>
                    <td>
                        [%Hodnotil%]:</td>
                    <td>
                        <wc:TLabel ID="TL_hodnotil" runat="server" Text='<%# Eval("hodnotil") %>'></wc:TLabel>
                    </td>
                </tr>
                <tr>
                    <td>
                        [%Souhlasil%]:</td>
                    <td style="border-right-style: solid; border-right-width: 1px; border-right-color: #000000">
                        <wc:TLabel ID="TL_souhlasil" runat="server"></wc:TLabel>
                    </td>
                    <td>
                        [%Schválil%]:</td>
                    <td>
                        <wc:TLabel ID="TL_schvalil" runat="server" Text='<%# Eval("schvalil") %>'></wc:TLabel>
                    </td>
                </tr>
                <tr>
                    <td>
                        [%Zamknuto%]:
                    </td>
                    <td style="border-right-style: solid; border-right-width: 1px; border-right-color: #000000">
                        <wc:TLabel ID="TL_zamknuto" runat="server"></wc:TLabel>
                    </td>
                    <td>
                        [%Datum%]:
                    </td>
                    <td>
                        <wc:TLabel ID="TL_datum" runat="server" Text='<%# Eval("datum", "{0:d}") %>'></wc:TLabel>
                    </td>
                </tr>
            </table>
        </ItemTemplate>
    </asp:FormView>
    <br />
    <div runat="server" id="DIV_kom">
        <table style="border-collapse: collapse; border-style: none;" width="640px">
            <tr style="border-collapse: collapse; border-style: none; border-width: 0px">
                <td style="background-color: #C0C0C0" align="left">
                    <asp:Label ID="LabelNadpisKompetence" runat="server" Font-Bold="True" Font-Size="Larger"
                        Text="[%Hodnocení kompetencí%]"></asp:Label><br />
                </td>
            </tr>
        </table>
        <br />
        <asp:ObjectDataSource ID="ODS_typy_kompetenci" runat="server" OldValuesParameterFormatString="original_{0}"
            SelectMethod="Typy_kompetenci" TypeName="KSProgram.Hodnoceni.Hodnoceni">
            <SelectParameters>
                <asp:Parameter Name="Id" Type="Int32" />
                <asp:Parameter Name="sta_edt" Type="Int16" />
            </SelectParameters>
        </asp:ObjectDataSource>
        <asp:Repeater ID="REP_typy_kompetenci" runat="server" OnDataBinding="REP_typy_kompetenci_DataBinding"
            OnItemDataBound="REP_typy_kompetenci_ItemDataBound">
            <ItemTemplate>
                <asp:ObjectDataSource ID="ODS_kompetence" runat="server" SelectMethod="Kompetence"
                    TypeName="KSProgram.Hodnoceni.Hodnoceni">
                    <SelectParameters>
                        <asp:Parameter Name="Id" Type="Int32" />
                        <asp:Parameter Name="typ_kompetenci" Type="Int32" />
                        <asp:Parameter Name="sta_edt" Type="Int16" />
                    </SelectParameters>
                </asp:ObjectDataSource>
                <wc:TGridView ID="TGV_kompetence" runat="server" ShowTitleRow="True" DataKeyNames="idp,sta_edt,pozadavek"
                    Width="640px" AllowSorting="False" OnDataBinding="TGV_kompetence_DataBinding"
                    OnRowDataBound="TGV_kompetence_RowDataBound">
                    <Columns>
                        <asp:BoundField DataField="vyznam" HeaderText="[%Kompetence%]" HeaderStyle-HorizontalAlign="Left"
                            ItemStyle-BackColor="White" ItemStyle-BorderColor="Black" ItemStyle-BorderStyle="Solid"
                            ItemStyle-BorderWidth="1px" ItemStyle-ForeColor="Black" HeaderStyle-BorderColor="Black"
                            HeaderStyle-BorderWidth="1px" HeaderStyle-ForeColor="Black" FooterStyle-BorderColor="Black"
                            FooterStyle-BorderStyle="Solid" FooterStyle-BorderWidth="1px" FooterStyle-ForeColor="Black" />
                        <asp:BoundField DataField="popis" HeaderText="[%Popis%]" ItemStyle-HorizontalAlign="Left"
                            HeaderStyle-HorizontalAlign="Left" ItemStyle-BackColor="White" ItemStyle-BorderColor="Black"
                            ItemStyle-BorderStyle="Solid" ItemStyle-BorderWidth="1px" ItemStyle-ForeColor="Black"
                            HeaderStyle-BorderColor="Black" HeaderStyle-BorderWidth="1px" HeaderStyle-ForeColor="Black"
                            FooterStyle-BorderColor="Black" FooterStyle-BorderStyle="Solid" FooterStyle-BorderWidth="1px"
                            FooterStyle-ForeColor="Black" />
                        <asp:BoundField DataField="vaha" HeaderText="[%Váha%]" ItemStyle-HorizontalAlign="Center"
                            HeaderStyle-HorizontalAlign="Center" ItemStyle-BackColor="White" ItemStyle-BorderColor="Black"
                            ItemStyle-BorderStyle="Solid" ItemStyle-BorderWidth="1px" ItemStyle-ForeColor="Black"
                            HeaderStyle-BorderColor="Black" HeaderStyle-BorderWidth="1px" HeaderStyle-ForeColor="Black"
                            FooterStyle-BorderColor="Black" FooterStyle-BorderStyle="Solid" FooterStyle-BorderWidth="1px"
                            FooterStyle-ForeColor="Black" />
                        <asp:TemplateField HeaderText="[%Hodnocení%]" ItemStyle-HorizontalAlign="Left" HeaderStyle-HorizontalAlign="Center"
                            ItemStyle-BackColor="White" ItemStyle-BorderColor="Black" ItemStyle-BorderStyle="Solid"
                            ItemStyle-BorderWidth="1px" ItemStyle-ForeColor="Black" HeaderStyle-BorderColor="Black"
                            HeaderStyle-BorderWidth="1px" HeaderStyle-ForeColor="Black" FooterStyle-BorderColor="Black"
                            FooterStyle-BorderStyle="Solid" FooterStyle-BorderWidth="1px" FooterStyle-ForeColor="Black">
                            <ItemTemplate>
                                <asp:Label ID="LabelDbHodnoceni" runat="server"></asp:Label>
                            </ItemTemplate>
                        </asp:TemplateField>
                        <asp:TemplateField HeaderText="[%Požadováno%]" ItemStyle-HorizontalAlign="Left"
                            HeaderStyle-HorizontalAlign="Center" ItemStyle-BackColor="White" ItemStyle-BorderColor="Black"
                            ItemStyle-BorderStyle="Solid" ItemStyle-BorderWidth="1px" ItemStyle-ForeColor="Black"
                            HeaderStyle-BorderColor="Black" HeaderStyle-BorderWidth="1px" HeaderStyle-ForeColor="Black"
                            FooterStyle-BorderColor="Black" FooterStyle-BorderStyle="Solid" FooterStyle-BorderWidth="1px"
                            FooterStyle-ForeColor="Black">
                            <ItemTemplate>
                                <asp:Label ID="LabelDbPozadavek" runat="server"></asp:Label>
                            </ItemTemplate>
                        </asp:TemplateField>
                        <asp:TemplateField HeaderText="[%Poznámka%]" HeaderStyle-HorizontalAlign="Left"
                            ItemStyle-BackColor="White" ItemStyle-BorderColor="Black" ItemStyle-BorderStyle="Solid"
                            ItemStyle-BorderWidth="1px" ItemStyle-ForeColor="Black" HeaderStyle-BorderColor="Black"
                            HeaderStyle-BorderWidth="1px" HeaderStyle-ForeColor="Black" FooterStyle-BorderColor="Black"
                            FooterStyle-BorderStyle="Solid" FooterStyle-BorderWidth="1px" FooterStyle-ForeColor="Black">
                            <ItemTemplate>
                                <asp:Label ID="L_komp_poznamka" runat="server"></asp:Label>
                            </ItemTemplate>
                        </asp:TemplateField>
                    </Columns>
                </wc:TGridView>
                <br />
            </ItemTemplate>
            <FooterTemplate>
                <div runat="server" id="DIV_kom_footer">
                    <asp:Label ID="L_komp_sum" runat="server" Text=""></asp:Label>
                    <br />
                    <br />
                </div>
                <div runat="server" id="DIV_chart_footer">
                    <asp:ObjectDataSource ID="ODS_chart" runat="server" OldValuesParameterFormatString="original_{0}"
                        SelectMethod="Retrieve" TypeName="KSProgram.Sestavy.DefSestavy_HodnKompetence">
                        <SelectParameters>
                            <asp:Parameter Name="Id_ha" Type="String" />
                            <asp:Parameter Name="cis_divize" Type="Int32" />
                            <asp:Parameter Name="skup_str" Type="Int32" />
                            <asp:Parameter Name="str" Type="String" />
                            <asp:Parameter Name="os_cislo" Type="String" />
                            <asp:Parameter Name="typ_kompetenci" Type="String" />
                            <asp:Parameter Name="kompetence" Type="String" />
                            <asp:Parameter Name="groupZam" Type="String" />
                            <asp:Parameter Name="groupKom" Type="String" />
                            <asp:Parameter Name="zamceno" Type="Int16" />
                            <asp:Parameter Name="procenta" Type="Boolean" />
                            <asp:Parameter Name="columns" Type="String" />
                            <asp:Parameter Name="use_casch" Type="Boolean" DefaultValue="False" />
                        </SelectParameters>
                    </asp:ObjectDataSource>
                    <asp:Chart ID="ChartKompetence" runat="server" DataSourceID="" Height="400px" Width="640px"
                        OnDataBound="ChartKompetence_DataBound">
                        <Series>
                            <asp:Series ChartType="Radar" Name="SeriesIDTypKompetenci" ChartArea="ChartArea1"
                                CustomProperties="AreaDrawingStyle=Polygon" XValueMember="kompetence" YValueMembers="id_typ_kompetenci"
                                Legend="LegendUroven" IsVisibleInLegend="False">
                            </asp:Series>
                            <asp:Series ChartType="Radar" Name="SeriesBodyPoz" ChartArea="ChartArea1" BorderWidth="4"
                                Color="Transparent" BorderColor="Green" CustomProperties="AreaDrawingStyle=Polygon"
                                XValueMember="kompetence" YValueMembers="body_poz" Legend="LegendUroven" LegendText="[%Požadovaná úroveň%]">
                            </asp:Series>
                            <asp:Series ChartType="Radar" Name="SeriesBodyObd" ChartArea="ChartArea1" BorderWidth="4"
                                Color="Transparent" BorderColor="Red" CustomProperties="AreaDrawingStyle=Polygon"
                                XValueMember="kompetence" Legend="LegendUroven" LegendText="[%Dosažená úroveň%]">
                            </asp:Series>
                            <asp:Series ChartType="Radar" Name="SeriesVaha" ChartArea="ChartArea1" BorderWidth="3"
                                Color="Transparent" BorderColor="Green" Enabled="false" CustomProperties="AreaDrawingStyle=Polygon"
                                XValueMember="kompetence" YValueMembers="vaha" Legend="LegendUroven">
                            </asp:Series>
                        </Series>
                        <ChartAreas>
                            <asp:ChartArea Name="ChartArea1">
                                <AxisY Interval="1">
                                    <MajorTickMark Enabled="false" />
                                </AxisY>
                            </asp:ChartArea>
                        </ChartAreas>
                        <Legends>
                            <asp:Legend Name="LegendUroven" Enabled="false" Title="Úrovně" BorderColor="Transparent"
                                Docking="Bottom" TitleAlignment="Near">
                            </asp:Legend>
                            <asp:Legend Name="LegendTypKompetenci" Enabled="false" Title="Typy kompetencí" BorderColor="Transparent"
                                Docking="Bottom" TitleAlignment="Near">
                            </asp:Legend>
                        </Legends>
                    </asp:Chart>
                    <br />
                </div>
            </FooterTemplate>
        </asp:Repeater>
    </div>
    <div runat="server" id="DIV_cil">
        <table style="border-collapse: collapse; border-style: none;" width="640px">
            <tr style="border-collapse: collapse; border-style: none; border-width: 0px">
                <td style="background-color: #C0C0C0" align="left">
                    <asp:Label ID="Label3" runat="server" Font-Bold="True" Font-Size="Larger" Text="[%Hodnocení cílů%]"></asp:Label><br />
                </td>
            </tr>
        </table>
        <br />
        <asp:ObjectDataSource ID="ODS_cile" runat="server" OldValuesParameterFormatString="original_{0}"
            SelectMethod="Cile" TypeName="KSProgram.Hodnoceni.Hodnoceni">
            <SelectParameters>
                <asp:Parameter Name="Id" Type="Int32" />
                <asp:Parameter Name="Druh" Type="Int32" DefaultValue="1" />
            </SelectParameters>
        </asp:ObjectDataSource>
        <wc:TGridView ID="TGV_cile" runat="server" DataKeyNames="idp,druh,cil" ShowFooterWhenEmpty="True"
            ShowTitleRow="False" OnRowDataBound="TGV_cile_RowDataBound" OnDataBinding="TGV_cile_DataBinding"
            AllowSorting="False" ShowFooter="True" Width="640px" >
            <Columns>
                <asp:BoundField DataField="cil_nazev" HeaderText="[%Cíle%]" ItemStyle-BackColor="White"
                    ItemStyle-BorderColor="Black" ItemStyle-BorderStyle="Solid" ItemStyle-BorderWidth="1px"
                    ItemStyle-ForeColor="Black" HeaderStyle-BorderColor="Black" HeaderStyle-BorderWidth="1px"
                    HeaderStyle-ForeColor="Black" FooterStyle-BorderColor="Black" FooterStyle-BorderStyle="Solid"
                    FooterStyle-BorderWidth="1px" FooterStyle-ForeColor="Black" />
                <asp:BoundField DataField="text" HeaderText="[%Cíle%]" HeaderStyle-HorizontalAlign="Left"
                    ItemStyle-BackColor="White" ItemStyle-BorderColor="Black" ItemStyle-BorderStyle="Solid"
                    ItemStyle-BorderWidth="1px" ItemStyle-ForeColor="Black" HeaderStyle-BorderColor="Black"
                    HeaderStyle-BorderWidth="1px" HeaderStyle-ForeColor="Black" FooterStyle-BorderColor="Black"
                    FooterStyle-BorderStyle="Solid" FooterStyle-BorderWidth="1px" FooterStyle-ForeColor="Black" />
                <asp:BoundField DataField="popis" HeaderText="[%Popis%]" HeaderStyle-HorizontalAlign="Left"
                    ItemStyle-BackColor="White" ItemStyle-BorderColor="Black" ItemStyle-BorderStyle="Solid"
                    ItemStyle-BorderWidth="1px" ItemStyle-ForeColor="Black" HeaderStyle-BorderColor="Black"
                    HeaderStyle-BorderWidth="1px" HeaderStyle-ForeColor="Black" FooterStyle-BorderColor="Black"
                    FooterStyle-BorderStyle="Solid" FooterStyle-BorderWidth="1px" FooterStyle-ForeColor="Black" />
                <asp:BoundField DataField="vaha" HeaderText="[%Váha%]" ItemStyle-BackColor="White"
                    ItemStyle-BorderColor="Black" ItemStyle-BorderStyle="Solid" ItemStyle-BorderWidth="1px"
                    ItemStyle-ForeColor="Black" HeaderStyle-BorderColor="Black" HeaderStyle-BorderWidth="1px"
                    HeaderStyle-ForeColor="Black" FooterStyle-BorderColor="Black" FooterStyle-BorderStyle="Solid"
                    FooterStyle-BorderWidth="1px" FooterStyle-ForeColor="Black" />
                <asp:BoundField DataField="hodnota" HeaderText="[%Množství%]" ItemStyle-BackColor="White"
                    ItemStyle-BorderColor="Black" ItemStyle-BorderStyle="Solid" ItemStyle-BorderWidth="1px"
                    ItemStyle-ForeColor="Black" HeaderStyle-BorderColor="Black" HeaderStyle-BorderWidth="1px"
                    HeaderStyle-ForeColor="Black" FooterStyle-BorderColor="Black" FooterStyle-BorderStyle="Solid"
                    FooterStyle-BorderWidth="1px" FooterStyle-ForeColor="Black" />
                <asp:TemplateField HeaderText="[%Hodnocení%]" ItemStyle-BackColor="White" ItemStyle-BorderColor="Black"
                    ItemStyle-BorderStyle="Solid" ItemStyle-BorderWidth="1px" ItemStyle-ForeColor="Black"
                    HeaderStyle-BorderColor="Black" HeaderStyle-BorderWidth="1px" HeaderStyle-ForeColor="Black"
                    FooterStyle-BorderColor="Black" FooterStyle-BorderStyle="Solid" FooterStyle-BorderWidth="1px"
                    FooterStyle-ForeColor="Black">
                    <ItemTemplate>
                        <asp:Label ID="L_hodnoceni_cile" runat="server" Text='<%# Bind("hodnoceni") %>'></asp:Label>
                        <asp:Label ID="L_hodnoceni_cile_text" runat="server"></asp:Label>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:BoundField DataField="termin" HeaderText="[%Termín%]" DataFormatString="{0:d/M/yyyy}"
                    HtmlEncode="False" ItemStyle-BackColor="White" ItemStyle-BorderColor="Black"
                    ItemStyle-BorderStyle="Solid" ItemStyle-BorderWidth="1px" ItemStyle-ForeColor="Black"
                    HeaderStyle-BorderColor="Black" HeaderStyle-BorderWidth="1px" HeaderStyle-ForeColor="Black"
                    FooterStyle-BorderColor="Black" FooterStyle-BorderStyle="Solid" FooterStyle-BorderWidth="1px"
                    FooterStyle-ForeColor="Black" />
                <asp:TemplateField HeaderText="[%Poznámka%]" HeaderStyle-HorizontalAlign="Left"
                    ItemStyle-BackColor="White" ItemStyle-BorderColor="Black" ItemStyle-BorderStyle="Solid"
                    ItemStyle-BorderWidth="1px" ItemStyle-ForeColor="Black" HeaderStyle-BorderColor="Black"
                    HeaderStyle-BorderWidth="1px" HeaderStyle-ForeColor="Black" FooterStyle-BorderColor="Black"
                    FooterStyle-BorderStyle="Solid" FooterStyle-BorderWidth="1px" FooterStyle-ForeColor="Black">
                    <ItemTemplate>
                        <wc:TLabel ID="L_cil_poznamka" runat="server" FormatHtml="True" Text='<%# Bind("poznamka") %>'></wc:TLabel>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="[%Očekávaný výstup%]" HeaderStyle-HorizontalAlign="Left"
                    ItemStyle-BackColor="White" ItemStyle-BorderColor="Black" ItemStyle-BorderStyle="Solid"
                    ItemStyle-BorderWidth="1px" ItemStyle-ForeColor="Black" HeaderStyle-BorderColor="Black"
                    HeaderStyle-BorderWidth="1px" HeaderStyle-ForeColor="Black" FooterStyle-BorderColor="Black"
                    FooterStyle-BorderStyle="Solid" FooterStyle-BorderWidth="1px" FooterStyle-ForeColor="Black">
                    <ItemTemplate>
                        <wc:TLabel ID="L_cil_ocek" runat="server" FormatHtml="True" Text='<%# Bind("ocek_vystup") %>'></wc:TLabel>
                    </ItemTemplate>
                </asp:TemplateField>
            </Columns>
        </wc:TGridView>
        <br />
    </div>
    <div runat="server" id="DIV_ncil">
        <table style="border-collapse: collapse; border-style: none;" width="640px">
            <tr style="border-collapse: collapse; border-style: none; border-width: 0px">
                <td style="background-color: #C0C0C0" align="left">
                    <asp:Label ID="Label7" runat="server" Font-Bold="True" Font-Size="Larger" Text="[%Následné cíle%]"></asp:Label><br />
                </td>
            </tr>
        </table>
        <br />
        <asp:ObjectDataSource ID="ODS_naslcile" runat="server" OldValuesParameterFormatString="original_{0}"
            SelectMethod="Cile" TypeName="KSProgram.Hodnoceni.Hodnoceni" UpdateMethod="Update_cile"
            DeleteMethod="Delete_cile">
            <SelectParameters>
                <asp:Parameter Name="Id" Type="Int32" />
                <asp:Parameter DefaultValue="2" Name="Druh" Type="Int32" />
            </SelectParameters>
        </asp:ObjectDataSource>
        <wc:TGridView ID="TGV_naslcile" runat="server" DataKeyNames="idp,druh,cil" ShowFooterWhenEmpty="True"
            ShowTitleRow="False" OnRowDataBound="TGV_naslcile_RowDataBound" ShowFooter="True"
            OnDataBinding="TGV_naslcile_DataBinding" AllowSorting="False" Width="640px" >
            <Columns>
                <asp:BoundField DataField="cil_nazev" HeaderText="[%Následné cíle%]" ItemStyle-BackColor="White"
                    ItemStyle-BorderColor="Black" ItemStyle-BorderStyle="Solid" ItemStyle-BorderWidth="1px"
                    ItemStyle-ForeColor="Black" HeaderStyle-BorderColor="Black" HeaderStyle-BorderWidth="1px"
                    HeaderStyle-ForeColor="Black" FooterStyle-BorderColor="Black" FooterStyle-BorderStyle="Solid"
                    FooterStyle-BorderWidth="1px" FooterStyle-ForeColor="Black" />
                <asp:BoundField DataField="text" HeaderText="[%Následné cíle%]" HeaderStyle-HorizontalAlign="Left"
                    ItemStyle-BackColor="White" ItemStyle-BorderColor="Black" ItemStyle-BorderStyle="Solid"
                    ItemStyle-BorderWidth="1px" ItemStyle-ForeColor="Black" HeaderStyle-BorderColor="Black"
                    HeaderStyle-BorderWidth="1px" HeaderStyle-ForeColor="Black" FooterStyle-BorderColor="Black"
                    FooterStyle-BorderStyle="Solid" FooterStyle-BorderWidth="1px" FooterStyle-ForeColor="Black" />
                <asp:BoundField DataField="popis" HeaderText="[%Popis%]" HeaderStyle-HorizontalAlign="Left"
                    ItemStyle-BackColor="White" ItemStyle-BorderColor="Black" ItemStyle-BorderStyle="Solid"
                    ItemStyle-BorderWidth="1px" ItemStyle-ForeColor="Black" HeaderStyle-BorderColor="Black"
                    HeaderStyle-BorderWidth="1px" HeaderStyle-ForeColor="Black" FooterStyle-BorderColor="Black"
                    FooterStyle-BorderStyle="Solid" FooterStyle-BorderWidth="1px" FooterStyle-ForeColor="Black" />
                <asp:BoundField DataField="vaha" HeaderText="[%Váha%]" ItemStyle-BackColor="White"
                    ItemStyle-BorderColor="Black" ItemStyle-BorderStyle="Solid" ItemStyle-BorderWidth="1px"
                    ItemStyle-ForeColor="Black" HeaderStyle-BorderColor="Black" HeaderStyle-BorderWidth="1px"
                    HeaderStyle-ForeColor="Black" FooterStyle-BorderColor="Black" FooterStyle-BorderStyle="Solid"
                    FooterStyle-BorderWidth="1px" FooterStyle-ForeColor="Black" />
                <asp:BoundField DataField="hodnota" HeaderText="[%Množství%]" ItemStyle-BackColor="White"
                    ItemStyle-BorderColor="Black" ItemStyle-BorderStyle="Solid" ItemStyle-BorderWidth="1px"
                    ItemStyle-ForeColor="Black" HeaderStyle-BorderColor="Black" HeaderStyle-BorderWidth="1px"
                    HeaderStyle-ForeColor="Black" FooterStyle-BorderColor="Black" FooterStyle-BorderStyle="Solid"
                    FooterStyle-BorderWidth="1px" FooterStyle-ForeColor="Black" />
                <asp:BoundField DataField="termin" HeaderText="[%Termín%]" DataFormatString="{0:d/M/yyyy}"
                    HtmlEncode="False" ItemStyle-BackColor="White" ItemStyle-BorderColor="Black"
                    ItemStyle-BorderStyle="Solid" ItemStyle-BorderWidth="1px" ItemStyle-ForeColor="Black"
                    HeaderStyle-BorderColor="Black" HeaderStyle-BorderWidth="1px" HeaderStyle-ForeColor="Black"
                    FooterStyle-BorderColor="Black" FooterStyle-BorderStyle="Solid" FooterStyle-BorderWidth="1px"
                    FooterStyle-ForeColor="Black" />
                <asp:TemplateField HeaderText="[%Poznámka%]" HeaderStyle-HorizontalAlign="Left" ItemStyle-BackColor="White"
                    ItemStyle-BorderColor="Black" ItemStyle-BorderStyle="Solid" ItemStyle-BorderWidth="1px"
                    ItemStyle-ForeColor="Black" HeaderStyle-BorderColor="Black" HeaderStyle-BorderWidth="1px"
                    HeaderStyle-ForeColor="Black" FooterStyle-BorderColor="Black" FooterStyle-BorderStyle="Solid"
                    FooterStyle-BorderWidth="1px" FooterStyle-ForeColor="Black">
                    <ItemTemplate>
                        <wc:TLabel ID="L_cil_poznamka" runat="server" FormatHtml="True" Text='<%# Bind("poznamka") %>'></wc:TLabel>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="[%Očekávaný výstup%]" HeaderStyle-HorizontalAlign="Left"
                    ItemStyle-BackColor="White" ItemStyle-BorderColor="Black" ItemStyle-BorderStyle="Solid"
                    ItemStyle-BorderWidth="1px" ItemStyle-ForeColor="Black" HeaderStyle-BorderColor="Black"
                    HeaderStyle-BorderWidth="1px" HeaderStyle-ForeColor="Black" FooterStyle-BorderColor="Black"
                    FooterStyle-BorderStyle="Solid" FooterStyle-BorderWidth="1px" FooterStyle-ForeColor="Black">
                    <ItemTemplate>
                        <wc:TLabel ID="L_cil_ocek" runat="server" FormatHtml="True" Text='<%# Bind("ocek_vystup") %>'></wc:TLabel>
                    </ItemTemplate>
                </asp:TemplateField>
            </Columns>
        </wc:TGridView>
        <br />
    </div>
    <div runat="server" id="DIV_slo">
        <table style="border-collapse: collapse; border-style: none;" width="640px">
            <tr style="border-collapse: collapse; border-style: none; border-width: 0px">
                <td style="background-color: #C0C0C0" align="left">
                    <asp:Label ID="Label2" runat="server" Font-Bold="True" Font-Size="Larger" Text="[%Hodnocení slovní%]"></asp:Label><br />
                </td>
            </tr>
        </table>
        <br />
        <asp:ObjectDataSource ID="ODS_slovni" runat="server" OldValuesParameterFormatString="original_{0}"
            SelectMethod="Slovni" TypeName="KSProgram.Hodnoceni.Hodnoceni">
            <SelectParameters>
                <asp:Parameter Name="Id" Type="Int32" />
                <asp:Parameter Name="sta_edt" Type="Int16" />
            </SelectParameters>
        </asp:ObjectDataSource>
        <asp:Repeater ID="REP_slovni" runat="server" OnDataBinding="REP_slovni_DataBinding"
            OnItemDataBound="REP_slovni_ItemDataBound">
            <ItemTemplate>
                <table style="border-color: #000000; border-collapse: collapse; border-style: solid;
                    border-width: thin" width="640px">
                    <tr style="border-color: #000000; border-collapse: collapse; border-style: solid;
                        border-width: thin">
                        <td style="padding: 5px; height: 150px; vertical-align: top;">
                            <asp:Label ID="Label1" runat="server" Text='<%# Bind("vyznam") %>' Font-Bold="True"></asp:Label><br />
                            <asp:Label ID="L_slovni_popis" runat="server" Text='<%# Bind("popis") %>'></asp:Label><br />
                            <asp:Label ID="TB_poznamka" runat="server" BorderWidth="1px" BorderStyle="Solid"
                                BorderColor="#666666" BackColor="White" Font-Size="Larger"></asp:Label>
                        </td>
                    </tr>
                </table>
                <br />
            </ItemTemplate>
        </asp:Repeater>
    </div>
    <div runat="server" id="DIV_mot">
        <table style="border-collapse: collapse; border-style: none;" width="640px">
            <tr style="border-collapse: collapse; border-style: none; border-width: 0px">
                <td style="background-color: #C0C0C0" align="left">
                    <asp:Label ID="Label4" runat="server" Font-Bold="True" Font-Size="Larger" Text="[%Osobní motivace%]"></asp:Label><br />
                </td>
            </tr>
        </table>
        <br />
        <asp:ObjectDataSource ID="ODS_Motivace" runat="server" OldValuesParameterFormatString="original_{0}"
            TypeName="KSProgram.Hodnoceni.Hodnoceni" SelectMethod="Motivace">
            <SelectParameters>
                <asp:Parameter Name="Id" Type="Int32" />
            </SelectParameters>
        </asp:ObjectDataSource>
        <wc:TGridView ID="TGV_Motivace" runat="server" DataKeyNames="idp,pozadavek" ShowTitleRow="False"
            Width="640px" OnRowDataBound="TGV_Motivace_RowDataBound" 
            AllowSorting="False" ondatabinding="TGV_Motivace_DataBinding">
            <Columns>
                <asp:BoundField DataField="vyznam" HeaderText="[%Motivační faktor%]" ItemStyle-BackColor="White"
                    ItemStyle-BorderColor="Black" ItemStyle-BorderStyle="Solid" ItemStyle-BorderWidth="1px"
                    ItemStyle-ForeColor="Black" HeaderStyle-BorderColor="Black" HeaderStyle-BorderWidth="1px"
                    HeaderStyle-ForeColor="Black" FooterStyle-BorderColor="Black" FooterStyle-BorderStyle="Solid"
                    FooterStyle-BorderWidth="1px" FooterStyle-ForeColor="Black" />
                <asp:TemplateField HeaderText="[%Stanovisko%]" ItemStyle-BackColor="White" ItemStyle-BorderColor="Black"
                    ItemStyle-BorderStyle="Solid" ItemStyle-BorderWidth="1px" ItemStyle-ForeColor="Black"
                    HeaderStyle-BorderColor="Black" HeaderStyle-BorderWidth="1px" HeaderStyle-ForeColor="Black"
                    FooterStyle-BorderColor="Black" FooterStyle-BorderStyle="Solid" FooterStyle-BorderWidth="1px"
                    FooterStyle-ForeColor="Black">
                    <ItemTemplate>
                        <asp:Label ID="L_stanovisko" runat="server"></asp:Label>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="[%Zdůvodnění, připomínky, návrhy%]" ItemStyle-BackColor="White"
                    ItemStyle-BorderColor="Black" ItemStyle-BorderStyle="Solid" ItemStyle-BorderWidth="1px"
                    ItemStyle-ForeColor="Black" HeaderStyle-BorderColor="Black" HeaderStyle-BorderWidth="1px"
                    HeaderStyle-ForeColor="Black" FooterStyle-BorderColor="Black" FooterStyle-BorderStyle="Solid"
                    FooterStyle-BorderWidth="1px" FooterStyle-ForeColor="Black">
                    <ItemTemplate>
                        <asp:Label ID="L_mot_poznamka" runat="server"></asp:Label>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:BoundField DataField="termin" HeaderText="[%Termín%]" DataFormatString="{0:d.M.yyyy}"
                    ItemStyle-BackColor="White" ItemStyle-BorderColor="Black" ItemStyle-BorderStyle="Solid"
                    ItemStyle-BorderWidth="1px" ItemStyle-ForeColor="Black" HeaderStyle-BorderColor="Black"
                    HeaderStyle-BorderWidth="1px" HeaderStyle-ForeColor="Black" FooterStyle-BorderColor="Black"
                    FooterStyle-BorderStyle="Solid" FooterStyle-BorderWidth="1px" FooterStyle-ForeColor="Black" />
            </Columns>
        </wc:TGridView>
        <br />
    </div>
    <div runat="server" id="DIV_sko">
        <table style="border-collapse: collapse; border-style: none;" width="640px">
            <tr style="border-collapse: collapse; border-style: none; border-width: 0px">
                <td style="background-color: #C0C0C0" align="left">
                    <asp:Label ID="Label5" runat="server" Font-Bold="True" Font-Size="Larger" Text="[%Hodnocení vzdělávacích akcí%]"></asp:Label><br />
                </td>
            </tr>
        </table>
        <br />
        <asp:ObjectDataSource ID="ODS_Skoleni" runat="server" TypeName="KSProgram.Hodnoceni.Hodnoceni"
            SelectMethod="Skoleni">
            <SelectParameters>
                <asp:Parameter Name="Id" Type="Int32" />
            </SelectParameters>
        </asp:ObjectDataSource>
        <wc:TGridView ID="TGV_Skoleni" runat="server" ShowTitleRow="False" Width="640px"
            AllowSorting="False" OnDataBinding="TGV_Skoleni_DataBinding" OnRowDataBound="TGV_Skoleni_RowDataBound">
            <Columns>
                <asp:BoundField DataField="nazev" HeaderText="[%Název%]" ItemStyle-BackColor="White"
                    ItemStyle-BorderColor="Black" ItemStyle-BorderStyle="Solid" ItemStyle-BorderWidth="1px"
                    ItemStyle-ForeColor="Black" HeaderStyle-BorderColor="Black" HeaderStyle-BorderWidth="1px"
                    HeaderStyle-ForeColor="Black" FooterStyle-BorderColor="Black" FooterStyle-BorderStyle="Solid"
                    FooterStyle-BorderWidth="1px" FooterStyle-ForeColor="Black" />
                <asp:TemplateField HeaderText="[%Absolvováno%]" HeaderStyle-HorizontalAlign="Center"
                    ItemStyle-HorizontalAlign="Center" ItemStyle-BackColor="White" ItemStyle-BorderColor="Black"
                    ItemStyle-BorderStyle="Solid" ItemStyle-BorderWidth="1px" ItemStyle-ForeColor="Black"
                    HeaderStyle-BorderColor="Black" HeaderStyle-BorderWidth="1px" HeaderStyle-ForeColor="Black"
                    FooterStyle-BorderColor="Black" FooterStyle-BorderStyle="Solid" FooterStyle-BorderWidth="1px"
                    FooterStyle-ForeColor="Black">
                    <ItemTemplate>
                        <asp:Label ID="LabelDbSplneno" runat="server"></asp:Label>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:BoundField DataField="ziskal" HeaderText="[%Splněno%]" HeaderStyle-HorizontalAlign="Center"
                    ItemStyle-HorizontalAlign="Center" ItemStyle-BackColor="White" ItemStyle-BorderColor="Black"
                    ItemStyle-BorderStyle="Solid" ItemStyle-BorderWidth="1px" ItemStyle-ForeColor="Black"
                    HeaderStyle-BorderColor="Black" HeaderStyle-BorderWidth="1px" HeaderStyle-ForeColor="Black"
                    FooterStyle-BorderColor="Black" FooterStyle-BorderStyle="Solid" FooterStyle-BorderWidth="1px"
                    FooterStyle-ForeColor="Black" />
                <asp:TemplateField HeaderText="[%Splnilo očekávání%]" HeaderStyle-HorizontalAlign="Center"
                    ItemStyle-HorizontalAlign="Center" ItemStyle-BackColor="White" ItemStyle-BorderColor="Black"
                    ItemStyle-BorderStyle="Solid" ItemStyle-BorderWidth="1px" ItemStyle-ForeColor="Black"
                    HeaderStyle-BorderColor="Black" HeaderStyle-BorderWidth="1px" HeaderStyle-ForeColor="Black"
                    FooterStyle-BorderColor="Black" FooterStyle-BorderStyle="Solid" FooterStyle-BorderWidth="1px"
                    FooterStyle-ForeColor="Black">
                    <ItemTemplate>
                        <asp:Label ID="LabelDbSplnilo" runat="server"></asp:Label>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="[%Poznámky%]" ItemStyle-BackColor="White" ItemStyle-BorderColor="Black"
                    ItemStyle-BorderStyle="Solid" ItemStyle-BorderWidth="1px" ItemStyle-ForeColor="Black"
                    HeaderStyle-BorderColor="Black" HeaderStyle-BorderWidth="1px" HeaderStyle-ForeColor="Black"
                    FooterStyle-BorderColor="Black" FooterStyle-BorderStyle="Solid" FooterStyle-BorderWidth="1px"
                    FooterStyle-ForeColor="Black">
                    <ItemTemplate>
                        <asp:Label ID="L_sko_poznamka" runat="server"></asp:Label>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:BoundField DataField="zpusob" HeaderText="[%Způsob%]" ItemStyle-BackColor="White"
                    ItemStyle-BorderColor="Black" ItemStyle-BorderStyle="Solid" ItemStyle-BorderWidth="1px"
                    ItemStyle-ForeColor="Black" HeaderStyle-BorderColor="Black" HeaderStyle-BorderWidth="1px"
                    HeaderStyle-ForeColor="Black" FooterStyle-BorderColor="Black" FooterStyle-BorderStyle="Solid"
                    FooterStyle-BorderWidth="1px" FooterStyle-ForeColor="Black" />
            </Columns>
        </wc:TGridView>
        <br />
    </div>
    <div runat="server" id="DIV_roz">
        <table style="border-collapse: collapse; border-style: none;" width="640px">
            <tr style="border-collapse: collapse; border-style: none; border-width: 0px">
                <td style="background-color: #C0C0C0" align="left">
                    <asp:Label ID="Label6" runat="server" Font-Bold="True" Font-Size="Larger" Text="[%Doporučené vzdělávání%]"></asp:Label><br />
                </td>
            </tr>
        </table>
        <br />
        <asp:ObjectDataSource ID="ODS_Vzdelavani" runat="server" TypeName="KSProgram.Hodnoceni.Hodnoceni"
            SelectMethod="Vzdelavani">
            <SelectParameters>
                <asp:Parameter Name="Id" Type="Int32" />
            </SelectParameters>
        </asp:ObjectDataSource>
        <wc:TGridView ID="TGV_DopVzde" runat="server" ShowTitleRow="False" Width="640px"
            AllowSorting="False" OnDataBinding="TGV_DopVzde_DataBinding" OnRowDataBound="TGV_DopVzde_RowDataBound">
            <Columns>
                <asp:BoundField DataField="nazev" HeaderText="[%Cíl%]" ItemStyle-BackColor="White"
                    ItemStyle-BorderColor="Black" ItemStyle-BorderStyle="Solid" ItemStyle-BorderWidth="1px"
                    ItemStyle-ForeColor="Black" HeaderStyle-BorderColor="Black" HeaderStyle-BorderWidth="1px"
                    HeaderStyle-ForeColor="Black" FooterStyle-BorderColor="Black" FooterStyle-BorderStyle="Solid"
                    FooterStyle-BorderWidth="1px" FooterStyle-ForeColor="Black" />
                <asp:BoundField DataField="termin" HeaderText="[%Termín%]" DataFormatString="{0:d/M/yyyy}"
                    HtmlEncode="False" HeaderStyle-HorizontalAlign="Center" ItemStyle-HorizontalAlign="Center"
                    ItemStyle-BackColor="White" ItemStyle-BorderColor="Black" ItemStyle-BorderStyle="Solid"
                    ItemStyle-BorderWidth="1px" ItemStyle-ForeColor="Black" HeaderStyle-BorderColor="Black"
                    HeaderStyle-BorderWidth="1px" HeaderStyle-ForeColor="Black" FooterStyle-BorderColor="Black"
                    FooterStyle-BorderStyle="Solid" FooterStyle-BorderWidth="1px" FooterStyle-ForeColor="Black" />
                <asp:TemplateField HeaderText="[%Poznámka%]" HeaderStyle-HorizontalAlign="Left" ItemStyle-BackColor="White"
                    ItemStyle-BorderColor="Black" ItemStyle-BorderStyle="Solid" ItemStyle-BorderWidth="1px"
                    ItemStyle-ForeColor="Black" HeaderStyle-BorderColor="Black" HeaderStyle-BorderWidth="1px"
                    HeaderStyle-ForeColor="Black" FooterStyle-BorderColor="Black" FooterStyle-BorderStyle="Solid"
                    FooterStyle-BorderWidth="1px" FooterStyle-ForeColor="Black">
                    <ItemTemplate>
                        <asp:Label ID="L_vzde_poznamka" runat="server"></asp:Label>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="[%Způsob%]" HeaderStyle-HorizontalAlign="Center" ItemStyle-HorizontalAlign="Center"
                    ItemStyle-BackColor="White" ItemStyle-BorderColor="Black" ItemStyle-BorderStyle="Solid"
                    ItemStyle-BorderWidth="1px" ItemStyle-ForeColor="Black" HeaderStyle-BorderColor="Black"
                    HeaderStyle-BorderWidth="1px" HeaderStyle-ForeColor="Black" FooterStyle-BorderColor="Black"
                    FooterStyle-BorderStyle="Solid" FooterStyle-BorderWidth="1px" FooterStyle-ForeColor="Black">
                    <ItemTemplate>
                        <asp:Label ID="L_rozv_zpusob" runat="server"></asp:Label>
                    </ItemTemplate>
                </asp:TemplateField>
            </Columns>
        </wc:TGridView>
        <br />
    </div>
    <div runat="server" id="DIV_cel">
        <table style="border-collapse: collapse; border-style: none;" width="640px">
            <tr style="border-collapse: collapse; border-style: none; border-width: 0px">
                <td style="background-color: #C0C0C0" align="left">
                    <asp:Label ID="Label8" runat="server" Font-Bold="True" Font-Size="Larger" Text="[%Celkové hodnocení%]"></asp:Label><br />
                </td>
            </tr>
        </table>
        <br />
        <asp:ObjectDataSource ID="ODS_celkove" runat="server" OldValuesParameterFormatString="original_{0}"
            SelectMethod="CelkoveHodnoceni" TypeName="KSProgram.Hodnoceni.Hodnoceni">
            <SelectParameters>
                <asp:Parameter Name="Id" Type="Int32" />
                <asp:Parameter Name="sta_edt" Type="Int16" />
                <asp:Parameter Name="sloucit" Type="Boolean" />
            </SelectParameters>
        </asp:ObjectDataSource>
        <wc:TGridView ID="TGV_celkove" runat="server" ShowTitleRow="False" 
            Width="640px" AllowSorting="False" onrowdatabound="TGV_celkove_RowDataBound" >
            <Columns>
                <asp:BoundField DataField="vyznam" HeaderText="[%Význam%]" SortExpression="vyznam"
                    ItemStyle-BackColor="White" ItemStyle-BorderColor="Black" ItemStyle-BorderStyle="Solid"
                    ItemStyle-BorderWidth="1px" ItemStyle-ForeColor="Black" HeaderStyle-BorderColor="Black"
                    HeaderStyle-BorderWidth="1px" HeaderStyle-ForeColor="Black" FooterStyle-BorderColor="Black"
                    FooterStyle-BorderStyle="Solid" FooterStyle-BorderWidth="1px" FooterStyle-ForeColor="Black" />
                <asp:TemplateField HeaderText="[%Popis%]" SortExpression="popis" Visible="False"
                    HeaderStyle-HorizontalAlign="Left" ItemStyle-BackColor="White" ItemStyle-BorderColor="Black"
                    ItemStyle-BorderStyle="Solid" ItemStyle-BorderWidth="1px" ItemStyle-ForeColor="Black"
                    HeaderStyle-BorderColor="Black" HeaderStyle-BorderWidth="1px" HeaderStyle-ForeColor="Black"
                    FooterStyle-BorderColor="Black" FooterStyle-BorderStyle="Solid" FooterStyle-BorderWidth="1px"
                    FooterStyle-ForeColor="Black">
                    <ItemTemplate>
                        <wc:TLabel ID="L_celk_popis" runat="server" Text='<%# Bind("popis") %>' FormatHtml="True"></wc:TLabel>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:BoundField DataField="popis_stupne" HeaderText="[%Hodnocení%]" SortExpression="popis_stupne"
                    ItemStyle-BackColor="White" ItemStyle-BorderColor="Black" ItemStyle-BorderStyle="Solid"
                    ItemStyle-BorderWidth="1px" ItemStyle-ForeColor="Black" HeaderStyle-BorderColor="Black"
                    HeaderStyle-BorderWidth="1px" HeaderStyle-ForeColor="Black" FooterStyle-BorderColor="Black"
                    FooterStyle-BorderStyle="Solid" FooterStyle-BorderWidth="1px" FooterStyle-ForeColor="Black" />
                <asp:TemplateField HeaderText="[%Poznámka%]" HeaderStyle-HorizontalAlign="Left" ItemStyle-BackColor="White"
                    ItemStyle-BorderColor="Black" ItemStyle-BorderStyle="Solid" ItemStyle-BorderWidth="1px"
                    ItemStyle-ForeColor="Black" HeaderStyle-BorderColor="Black" HeaderStyle-BorderWidth="1px"
                    HeaderStyle-ForeColor="Black" FooterStyle-BorderColor="Black" FooterStyle-BorderStyle="Solid"
                    FooterStyle-BorderWidth="1px" FooterStyle-ForeColor="Black">
                    <ItemTemplate>
                        <wc:TLabel ID="L_celk_poznamka" runat="server" FormatHtml="True" Text='<%# Bind("poznamka") %>'></wc:TLabel>
                    </ItemTemplate>
                </asp:TemplateField>
            </Columns>
        </wc:TGridView>
        <br />
    </div>
    <table style="border-color: #000000; border-collapse: collapse; border-style: solid;
        border-width: thin" width="640px">
        <tr style="border-color: #000000; border-collapse: collapse; border-style: solid;
            border-width: thin">
            <td style="padding: 5px">
                <asp:Label ID="LabelPodpisHodnoceneho" runat="server" Text="[%Datum a podpis hodnoceného%]:"></asp:Label>
            </td>
        </tr>
        <tr style="border-color: #000000; border-collapse: collapse; border-style: solid;
            border-width: thin">
            <td style="padding: 5px">
                <asp:Label ID="LabelPodpisHodnotitele" runat="server" Text="[%Datum a podpis hodnotitele%]:"></asp:Label>
            </td>
        </tr>
    </table>
</asp:Content>
