﻿<%@ Page Language="C#" MasterPageFile="~/Main.Master" AutoEventWireup="true" Inherits="Obecne_RadPravaVyj"
    CodeBehind="RadPravaVyj.aspx.cs" %>
<%@ Register Assembly="WebControls" Namespace="KSProgram.WebControls" TagPrefix="cc1" %>
<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>
<asp:Content ID="Content1" ContentPlaceHolderID="HlavniOblast" runat="Server">
    <asp:ObjectDataSource ID="ODS_Prava" runat="server" DeleteMethod="Smaz" InsertMethod="Vloz"
        SelectMethod="Nacti" TypeName="KSProgram.Prava.RadkovePravaVyjimky" UpdateMethod="Uprav">
        <DeleteParameters>
            <asp:Parameter Name="os_cislo" Type="Decimal" />
        </DeleteParameters>
        <UpdateParameters>
            <asp:Parameter Name="os_cislo" Type="Decimal" />
            <asp:Parameter Name="typ_prav" Type="Int32" />
        </UpdateParameters>
        <InsertParameters>
            <asp:Parameter Name="os_cislo" Type="Decimal" />
            <asp:Parameter Name="typ_prav" Type="Int32" />
        </InsertParameters>
    </asp:ObjectDataSource>
    <asp:ObjectDataSource ID="ODS_TypyPrav" runat="server" SelectMethod="TypyPrav" TypeName="KSProgram.Prava.RadkovePravaVyjimky">
    </asp:ObjectDataSource>
    <cc1:TRadGrid ID="TRadGrid1" runat="server" AllowAutomaticInserts="True" AutoGenerateColumns="False"
        AllowAutomaticDeletes="True" AllowAutomaticUpdates="True" DataSourceID="ODS_Prava" ValidateRequestMode="Enabled"
         GroupPanelPosition="Top" AllowPaging="True" AllowSorting="True"
        OnItemCommand="TRadGrid1_ItemCommand">
        <GroupingSettings CaseSensitive="False"></GroupingSettings>
        <MasterTableView CommandItemDisplay="Top" DataSourceID="ODS_Prava" DataKeyNames="os_cislo" CommandItemSettings-AddNewRecordText="[%Přidat nový záznam%]"
            Caption="[%Výjimky řádkových práv%]">
            <Columns>
                <telerik:GridEditCommandColumn ButtonType="ImageButton" UniqueName="EditCommandColumn">
                </telerik:GridEditCommandColumn>
                <telerik:GridNumericColumn DataField="os_cislo" DataType="System.Decimal" DecimalDigits="0"
                    FilterControlAltText="Filter os_cislo column" HeaderText="[%Os. číslo%]" UniqueName="os_cislo"
                    SortExpression="os_cislo">
                    <ColumnValidationSettings EnableRequiredFieldValidation="true">
                        <RequiredFieldValidator ForeColor="Red" Text="*"></RequiredFieldValidator>
                    </ColumnValidationSettings>
                </telerik:GridNumericColumn>
                <kspwc:GridFotoZamColumn UniqueName="foto" DataOsCisloField="os_cislo"></kspwc:GridFotoZamColumn>
                <telerik:GridBoundColumn DataField="prijmeni" FilterControlAltText="Filter prijmeni column"
                    HeaderText="[%Příjmení%]" ReadOnly="True" UniqueName="prijmeni" SortExpression="prijmeni">
                </telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="jmeno" FilterControlAltText="Filter jmeno column"
                    HeaderText="[%Jméno%]" ReadOnly="True" UniqueName="jmeno" SortExpression="jmeno">
                </telerik:GridBoundColumn>
                <telerik:GridDropDownColumn DataField="typ_prav" DataSourceID="ODS_TypyPrav" FilterControlAltText="Filter typ_prav column"
                    HeaderText="[%Typ práv%]" ListTextField="value" ListValueField="key" SortExpression="typ_prav"
                    UniqueName="typ_prav" DropDownControlType="DropDownList" Display="False">
                    <ColumnValidationSettings EnableRequiredFieldValidation="true">
                        <RequiredFieldValidator ForeColor="Red" Text="*"></RequiredFieldValidator>
                    </ColumnValidationSettings>
                </telerik:GridDropDownColumn>
                <telerik:GridBoundColumn DataField="typ_prav_text" FilterControlAltText="Filter typ_prav_text column"
                    HeaderText="[%Typ práv%]" ReadOnly="True" SortExpression="typ_prav_text" UniqueName="typ_prav_text">
                </telerik:GridBoundColumn>
                <telerik:GridButtonColumn Text="Delete" CommandName="Delete" ButtonType="ImageButton" />
            </Columns>
            <EditFormSettings>
                <EditColumn FilterControlAltText="Filter EditCommandColumn1 column" UniqueName="EditCommandColumn1"
                    ButtonType="ImageButton">
                </EditColumn>
            </EditFormSettings>
        </MasterTableView>
    </cc1:TRadGrid>   
</asp:Content>
