﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Main.Master" AutoEventWireup="true"
    CodeBehind="LekProhlUskutecnene.aspx.cs" Inherits="KSPortal.Zamestnanec.LekProhlUskutecnene" %>

<%@ Register Assembly="WebControls" Namespace="KSProgram.WebControls" TagPrefix="wc" %>
<%@ Register Assembly="WebControlsAlone" Namespace="KSProgram.WebControlsAlone" TagPrefix="wca" %>
<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>
<asp:Content ID="Content1" ContentPlaceHolderID="HeadContent" runat="server">
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="HlavniOblast" runat="server">
    <telerik:RadAjaxManagerProxy runat="server" ID="ajax_manager">
        <AjaxSettings>
            <telerik:AjaxSetting AjaxControlID="trbAdd">
                <UpdatedControls>
                    <telerik:AjaxUpdatedControl ControlID="trgUskutecneneProhlidky"></telerik:AjaxUpdatedControl>
                </UpdatedControls>
            </telerik:AjaxSetting>
            <telerik:AjaxSetting AjaxControlID="trgUskutecneneProhlidky">
                <UpdatedControls>
                    <telerik:AjaxUpdatedControl ControlID="trgUskutecneneProhlidky"></telerik:AjaxUpdatedControl>
                </UpdatedControls>
            </telerik:AjaxSetting>
        </AjaxSettings>
    </telerik:RadAjaxManagerProxy>
    <telerik:RadScriptBlock runat="server">
        <script>
            var comboTemp1;
            var comboTemp2;
            function comboTemp1_OnClientLoad(sender, args) {
                comboTemp1 = sender;
            }
            function comboTemp2_OnClientLoad(sender, args) {
                comboTemp2 = sender;
            }
            function SelectValues(sender) {

                var id = parseInt(sender._selectedValue);
                //debugger
                $.ajax({
                    type: "POST",
                    url: "LekProhlUskutecnene.aspx/SelectCastka",
                    data: "{id: " + id + "}",
                    async: true,
                    contentType: "application/json",
                    dataType: "json",
                    failure: function (response) {
                        //alert("Chyba: " + JSON.parse(response.responseText).Message);
                        alert("Chyba: " + response.responseText);


                    },
                    error: function (response) {
                        //alert("Chyba: ", JSON.parse(response.responseText).Message);
                        alert("Chyba: " + response.responseText);
                    },
                    success: function (msg) {

                        var castka = msg.d;
                        document.getElementsByClassName("castkaCSS")[0].value = castka;

                    }

                })

                $.ajax({
                    type: "POST",
                    url: "LekProhlUskutecnene.aspx/SelectLekar",
                    data: "{id: " + id + "}",
                    async: true,
                    contentType: "application/json",
                    dataType: "json",
                    failure: function (response) {
                        //alert("Chyba: " + JSON.parse(response.responseText).Message);
                        alert("Chyba: " + response.responseText);
                    },
                    error: function (response) {
                        //alert("Chyba: ", JSON.parse(response.responseText).Message);
                        alert("Chyba: " + response.responseText);
                    },
                    success: function (msg) {
                        var lekar = msg.d;
                        var it = comboTemp1.findItemByValue(lekar);
                        it.select();

                    }
                })

                $.ajax({
                    type: "POST",
                    url: "LekProhlUskutecnene.aspx/SelectCetnost",
                    data: "{id: " + id + "}",
                    async: true,
                    contentType: "application/json",
                    dataType: "json",
                    failure: function (response) {
                        //alert("Chyba: " + JSON.parse(response.responseText).Message);
                        alert("Chyba: " + $response.responseText);
                    },
                    error: function (response) {
                        //alert("Chyba: ", JSON.parse(response.responseText).Message);
                        alert("Chyba: " + response.responseText);
                    },
                    success: function (msg) {

                        var cetnost = msg.d;
                        document.getElementsByClassName("cetnostCSS")[0].value = cetnost;

                    }

                })

                $.ajax({
                    type: "POST",
                    url: "LekProhlUskutecnene.aspx/SelectVstup",
                    data: "{id: " + id + "}",
                    async: true,
                    contentType: "application/json",
                    dataType: "json",
                    failure: function (response) {
                        //alert("Chyba: " + JSON.parse(response.responseText).Message);
                        alert("Chyba: " + $response.responseText);
                    },
                    error: function (response) {
                        //alert("Chyba: ", JSON.parse(response.responseText).Message);
                        alert("Chyba: " + response.responseText);
                    },
                    success: function (msg) {

                        var vstup = msg.d;
                        var it = comboTemp2.findItemByValue(vstup);
                        it.select();

                    }

                })

            }
        </script>
    </telerik:RadScriptBlock>

    <%--<kspwc:TLabel ID="TLabel1" runat="server" Text="[%Uskutečněné lékařské prohlídky%]" CssClass="nadpis1"></kspwc:TLabel>--%>
    <div style="padding-bottom: 30px">
        <kspwc:TRadGrid ID="trgUskutecneneProhlidky" runat="server" AllowPaging="True" ShowFooter="True"
            AllowSorting="True" ShowGroupPanel="true" AutoGenerateColumns="False" MasterTableView-Caption="[%Uskutečněné lékařské prohlídky%]"
            ShowStatusBar="True" PageSize="50" OnNeedDataSource="trgUskutecneneProhlidky_OnNeedDataSource"
            OnInsertCommand="trgUskutecneneProhlidky_OnInsertCommand" OnUpdateCommand="trgUskutecneneProhlidky_OnUpdateCommand"
            OnDeleteCommand="trgUskutecneneProhlidky_OnDeleteCommand" OnItemDataBound="trgUskutecneneProhlidky_OnItemDataBound"
            OnItemUpdated="trgUskutecneneProhlidky_OnItemUpdated">
            <ClientSettings AllowDragToGroup="true">
            </ClientSettings>
            <GroupingSettings ShowUnGroupButton="true"></GroupingSettings>
            <PagerStyle Mode="NextPrevNumericAndAdvanced"></PagerStyle>
            <ExportSettings HideStructureColumns="true" OpenInNewWindow="true">
            </ExportSettings>
            <MasterTableView Width="100%" CommandItemDisplay="Top" HierarchyLoadMode="Conditional"
                DataKeyNames="id,os_cislo,cislo_pom" EditMode="PopUp">
                <EditFormSettings EditFormType="Template">
                    <EditColumn ButtonType="ImageButton" UniqueName="EditCommandColumn1" Exportable="False" 
                        Resizable="False" Reorderable="False" FilterControlAltText="Filter EditCommandColumn1 column">
                    </EditColumn>
                    <FormTemplate>
                        <telerik:RadFormDecorator ID="RadFormDecorator1" runat="server" DecorationZoneID="Panel1" />
                        <asp:Panel ID="Panel1" runat="server">
                            <%--<br />--%>
                            <kspwc:TTextBox ID="tbId" runat="server" CssClass="hidden" Text="Toto je text o který mi jde"></kspwc:TTextBox>
                            <table style="width: 100%; padding: 20px;">
                                <tr>
                                    <td>
                                        <kspwc:TLabel ID="tlDrProh" runat="server" Text="[%Druh prohlídky%]"></kspwc:TLabel>
                                    </td>
                                    <td colspan="2">
                                        <telerik:RadDropDownList ID="rddlDrProh" runat="server" DataSourceID="odsProhlidkyAkt"
                                            CssClass="povinne-pole prohlidkaCSS" DataValueField="cislo" DataTextField="cely_nazev" Width="100%"
                                            AutoPostBack="true" OnItemSelected="rddlDrProh_OnSelectedIndexChanged"
                                            OnSelectedIndexChanged="rddlDrProh_OnSelectedIndexChanged" OnClientSelectedIndexChanged="SelectValues">
                                        </telerik:RadDropDownList>
                                    </td>
                                    <td align="right">
                                        <kspwc:TLabel ID="tlPlatce" runat="server" Text="[%Plátce%]"></kspwc:TLabel>
                                    </td>
                                    <td colspan="2">
                                        <telerik:RadDropDownList ID="rddlPlatce" runat="server" DataSourceID="odsPlatce"
                                            DataValueField="cislo" DataTextField="nazev" Width="100%"
                                            AutoPostBack="False">
                                        </telerik:RadDropDownList>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <kspwc:TLabel ID="tlVysledek" runat="server" Text="[%Výsledek%]"></kspwc:TLabel>
                                    </td>
                                    <td colspan="2">
                                        <telerik:RadDropDownList ID="rddlVysledek" runat="server" DataSourceID="odsVysledek"
                                            CssClass="povinne-pole" DataValueField="zkratka" DataTextField="text" Width="100%">
                                        </telerik:RadDropDownList>
                                    </td>
                                    <td align="right">
                                        <kspwc:TLabel ID="tlLekar" runat="server" Text="[%Lékař%]"></kspwc:TLabel>
                                    </td>
                                    <td colspan="2">
                                        <telerik:RadDropDownList ID="rddlLekar" runat="server" DataSourceID="odsLekar" DataTextField="nazev"
                                            DataValueField="cislo" AutoPostBack="False" Width="100%" CssClass="lekarCSS" OnClientLoad="comboTemp1_OnClientLoad">
                                        </telerik:RadDropDownList>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <kspwc:TLabel ID="tlVstup" runat="server" Text="[%Typ%]"></kspwc:TLabel>
                                    </td>
                                    <td>
                                        <telerik:RadDropDownList ID="rddlVstup" runat="server" DataSourceID="odsTypTest" DataValueField="zkratka" ValidateRequestMode="Enabled"
                                            CssClass="povinne-pole vstupCSS" DataTextField="text" AutoPostBack="true" OnSelectedIndexChanged="rddlVstup_SelectedIndexChanged" OnClientLoad="comboTemp2_OnClientLoad">
                                        </telerik:RadDropDownList>
                                        <asp:RequiredFieldValidator ID="Validator1" ControlToValidate="rddlVstup" CssClass="povinne-pole" ErrorMessage="*Required" runat="server" Display="Dynamic" InitialValue="Select" ForeColor="Red">
                                        </asp:RequiredFieldValidator>
                                    </td>
                                    <td>
                                        <kspwc:TLabel ID="tlPlatna" runat="server" Text="[%Platnost od%]"></kspwc:TLabel>
                                    </td>
                                    <td>
                                        <wc:TRadDatePicker ID="trdpPlatna" SkinID="povinne-pole" runat="server" Width="100px"
                                            DateInput-MaxLength="10" AutoPostBack="True" Validace="true" ValidatorMessage="Povinné pole" OnSelectedDateChanged="trdpPlatna_SelectedDateChanged">
                                        </wc:TRadDatePicker>
                                    </td>
                                    <td>
                                        <kspwc:TLabel ID="tlCastka" runat="server" Text="[%Částka%]"></kspwc:TLabel>
                                    </td>
                                    <td>
                                        <telerik:RadNumericTextBox ID="rntbCastka" ButtonsPosition="Right" MinValue="0" Type="Currency"
                                            Width="50px" runat="server" ShowSpinButtons="false" DataType="System.Decimal" CssClass="castkaCSS">
                                            <NumberFormat AllowRounding="false" DecimalDigits="2" KeepNotRoundedValue="true" />
                                        </telerik:RadNumericTextBox>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <kspwc:TLabel ID="tlCetnost" runat="server" Text="[%Četnost (měsíce/dny)%]"></kspwc:TLabel>
                                    </td>
                                    <td>
                                        <telerik:RadNumericTextBox ID="rntbCetnost" ButtonsPosition="Right" MinValue="0"
                                            Type="Number" runat="server" ShowSpinButtons="false" DataType="System.Int16"
                                            Width="50px" ReadOnly="true" CssClass="cetnostCSS">
                                            <NumberFormat AllowRounding="false" DecimalDigits="0" KeepNotRoundedValue="true" />
                                        </telerik:RadNumericTextBox>
                                    </td>
                                    <td colspan="2">
                                        <kspwc:TRadButton ID="trbPotlPeriody" runat="server" ButtonType="ToggleButton" ToggleType="CheckBox"
                                            Checked="False" Text="[%Potlačení periodicity%]" AutoPostBack="False">
                                        </kspwc:TRadButton>
                                    </td>
                                    <td colspan="2">
                                        <kspwc:TRadButton ID="trbPredNastupem" runat="server" ButtonType="ToggleButton" ToggleType="CheckBox"
                                            Checked="False" Text="[%Před nástupem%]" AutoPostBack="False">
                                        </kspwc:TRadButton>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <kspwc:TLabel ID="tlUskutecnena" runat="server" Text="[%Datum uskutečnění%]"></kspwc:TLabel>
                                    </td>
                                    <td>
                                        <wc:TRadDatePicker ID="trdpUskutecnena" runat="server" SkinID="povinne-pole" Width="100px" DateInput-MaxLength="10"
                                            AutoPostBack="True" Validace="true" ValidatorMessage="Povinné pole">
                                        </wc:TRadDatePicker>
                                    </td>
                                    <td>
                                        <kspwc:TLabel ID="tlVek" runat="server" Text="[%Věk k datu prohlídky%]"></kspwc:TLabel>
                                    </td>
                                    <td>
                                        <telerik:RadNumericTextBox ID="rntbVek" ButtonsPosition="Right" MinValue="0" Type="Number"
                                            Width="50px" runat="server" DataType="System.Decimal" ReadOnly="true">
                                            <NumberFormat AllowRounding="false" DecimalDigits="0" KeepNotRoundedValue="true" />
                                        </telerik:RadNumericTextBox>
                                    </td>
                                    <td></td>
                                    <td></td>
                                </tr>
                                <tr>
                                    <td colspan="6">
                                        <asp:Panel ID="P_popis" runat="server" Style="padding: 0px; margin: 0px">
                                            <fieldset>
                                                <legend>[%Poznámka%]</legend>
                                                <telerik:RadTextBox ID="tbPoznamka" runat="server" EnabledStyle-BorderStyle="None"
                                                    MaxLength="100" Resize="Vertical" Rows="3" TextMode="MultiLine" Width="100%">
                                                </telerik:RadTextBox>
                                                <kspwc:TextValidator runat="server" ID="valPoznamka" ControlToValidate="tbPoznamka"></kspwc:TextValidator>
                                            </fieldset>
                                        </asp:Panel>
                                    </td>
                                </tr>
                            </table>
                            <br />
                            <%--<kspwc:TRadButton ID="RadButton5" runat="server" Text="[%Uložit%]" CausesValidation="False"
                                AutoPostBack="False">
                                <Icon PrimaryIconCssClass="fi fi-disk"></Icon>
                            </kspwc:TRadButton>
                            &nbsp;
                            <kspwc:TRadButton ID="RadButton7" runat="server" Text="[%Zrušit změny%]" CausesValidation="False">
                                <Icon PrimaryIconCssClass="fi fi-ban"></Icon>
                            </kspwc:TRadButton>--%>
                            <div style="float: right; margin-bottom: 25px; margin-right: 25px;">
                                <kspwc:TRadButton ID="trbUloz" runat="server" Text="[%Uložit%]" CausesValidation="true"
                                    CommandName='<%# (Container is GridEditFormInsertItem) ? "PerformInsert" : "Update" %>'
                                    AutoPostBack="True" OnCheckedChanged="trbUloz_OnCheckedChanged">
                                    <Icon PrimaryIconCssClass="fi fi-disk"></Icon>
                                </kspwc:TRadButton>
                                &nbsp;
                            <kspwc:TRadButton ID="trbCancel" runat="server" Text="[%Zrušit změny%]" CausesValidation="False"
                                CommandName="Cancel">
                                <Icon PrimaryIconCssClass="fi fi-ban"></Icon>
                            </kspwc:TRadButton>
                            </div>
                        </asp:Panel>
                    </FormTemplate>

                    <%--<FormStyle BackColor="Red"></FormStyle>
                    <FormCaptionStyle BackColor="Red"></FormCaptionStyle>
                    <FormTableItemStyle BackColor="Red"></FormTableItemStyle>
                    <FormTableAlternatingItemStyle BackColor="Red"></FormTableAlternatingItemStyle>
                    <FormTableButtonRowStyle BackColor="Red"></FormTableButtonRowStyle>--%>
                    <PopUpSettings Modal="true" ShowCaptionInEditForm="True" Width="800px" />
                </EditFormSettings>
                <Columns>
                    <telerik:GridEditCommandColumn ButtonType="ImageButton" UniqueName="editColumn">
                    </telerik:GridEditCommandColumn>
                    <telerik:GridBoundColumn DataField="id" HeaderText="[%Výsledek%]" UniqueName="iId" Display="false">
                    </telerik:GridBoundColumn>
                    <telerik:GridBoundColumn DataField="os_cislo" HeaderText="[%Os.číslo%]" UniqueName="dcOsCislo"
                        Display="false">
                    </telerik:GridBoundColumn>
                    <telerik:GridBoundColumn DataField="cislo_pom" HeaderText="[%Pom.číslo%]" UniqueName="iCisPom"
                        Display="false">
                    </telerik:GridBoundColumn>
                    <telerik:GridDropDownColumn DataField="dr_proh" HeaderText="[%Prohlídka%]" UniqueName="iDrProh"
                        FilterControlAltText="Filter iDrProh column" DataSourceID="odsProhlidkyAll" ListTextField="cely_nazev"
                        ListValueField="cislo" DropDownControlType="RadComboBox">
                        <HeaderStyle HorizontalAlign="Left" />
                        <ItemStyle HorizontalAlign="Left" />
                        <ColumnValidationSettings EnableRequiredFieldValidation="True">
                            <RequiredFieldValidator Display="Dynamic" ErrorMessage="*" ForeColor="Red"></RequiredFieldValidator>
                        </ColumnValidationSettings>
                    </telerik:GridDropDownColumn>
                    <telerik:GridDropDownColumn DataField="vysl" HeaderText="[%Výsledek%]" UniqueName="sVysl"
                        FilterControlAltText="Filter sVysl column" DataSourceID="odsVysledek" ListTextField="text"
                        ListValueField="zkratka" DropDownControlType="DropDownList">
                        <HeaderStyle HorizontalAlign="Left" />
                        <ItemStyle HorizontalAlign="Left" />
                        <ColumnValidationSettings EnableRequiredFieldValidation="True">
                            <RequiredFieldValidator Display="Dynamic" ErrorMessage="*" ForeColor="Red"></RequiredFieldValidator>
                        </ColumnValidationSettings>
                    </telerik:GridDropDownColumn>
                    <telerik:GridBoundColumn DataField="uskutecnena" HeaderText="[%Uskutečněná%]" UniqueName="dtUskutecnena"
                        FilterControlAltText="Filter dtUskutecnena column" DataFormatString="{0:d.M.yyyy}">
                        <HeaderStyle HorizontalAlign="Center" />
                        <ItemStyle HorizontalAlign="Center" />
                    </telerik:GridBoundColumn>
                    <telerik:GridDateTimeColumn DataField="datum" HeaderText="[%Platí od%]" UniqueName="dtDatum"
                        FilterControlAltText="Filter dtDatum column" DataFormatString="{0:d.M.yyyy}">
                        <HeaderStyle HorizontalAlign="Center" />
                        <ItemStyle HorizontalAlign="Center" />
                    </telerik:GridDateTimeColumn>
                    <telerik:GridNumericColumn DataField="cetnost" HeaderText="[%Četnost%]" UniqueName="iCetnost"
                        FilterControlAltText="Filter iCetnost column">
                        <HeaderStyle HorizontalAlign="Center" />
                        <ItemStyle HorizontalAlign="Center" />
                    </telerik:GridNumericColumn>
                    <telerik:GridDropDownColumn DataField="vstup" HeaderText="[%Typ%]" UniqueName="sVstup"
                        FilterControlAltText="Filter sVstup column" DataSourceID="odsTyp" ListTextField="text"
                        ListValueField="zkratka" DropDownControlType="DropDownList" GroupByExpression="text">
                        <HeaderStyle HorizontalAlign="Center" />
                        <ItemStyle HorizontalAlign="Center" />
                        <ColumnValidationSettings EnableRequiredFieldValidation="True">
                            <RequiredFieldValidator Display="Dynamic" ErrorMessage="*" ForeColor="Red"></RequiredFieldValidator>
                        </ColumnValidationSettings>
                    </telerik:GridDropDownColumn>
                    <%--<telerik:GridBoundColumn DataField="vstup" HeaderText="Typ" UniqueName="sVstup" FilterControlAltText="Filter sVstup column">
                        <HeaderStyle HorizontalAlign="Center" />
                        <ItemStyle HorizontalAlign="Center" />
                    </telerik:GridBoundColumn>--%>
                    <telerik:GridDropDownColumn DataField="platce" HeaderText="[%Plátce%]" UniqueName="iPlatce"
                        FilterControlAltText="Filter iLekar column" DataSourceID="odsPlatce" ListTextField="nazev"
                        ListValueField="cislo" DropDownControlType="RadComboBox">
                        <HeaderStyle HorizontalAlign="Left" />
                        <ItemStyle HorizontalAlign="Left" />
                        <ColumnValidationSettings EnableRequiredFieldValidation="True">
                            <RequiredFieldValidator Display="Dynamic" ErrorMessage="*" ForeColor="Red"></RequiredFieldValidator>
                        </ColumnValidationSettings>
                    </telerik:GridDropDownColumn>
                    <telerik:GridDropDownColumn DataField="lekar" HeaderText="[%Lékař%]" UniqueName="iLekar"
                        FilterControlAltText="Filter iLekar column" DataSourceID="odsLekar" ListTextField="nazev"
                        ListValueField="cislo" DropDownControlType="RadComboBox">
                        <HeaderStyle HorizontalAlign="Left" />
                        <ItemStyle HorizontalAlign="Left" />
                        <ColumnValidationSettings EnableRequiredFieldValidation="True">
                            <RequiredFieldValidator Display="Dynamic" ErrorMessage="*" ForeColor="Red"></RequiredFieldValidator>
                        </ColumnValidationSettings>
                    </telerik:GridDropDownColumn>
                    <telerik:GridNumericColumn DataField="castka" HeaderText="[%Částka%]" UniqueName="dcCastka"
                        FilterControlAltText="Filter dcCastka column">
                        <HeaderStyle HorizontalAlign="Center" />
                        <ItemStyle HorizontalAlign="Center" />
                    </telerik:GridNumericColumn>
                    <telerik:GridBoundColumn DataField="potl_period" HeaderText="[%Potl.periody%]" UniqueName="sPotlPeriod"
                        FilterControlAltText="Filter sPotlPeriod">
                        <HeaderStyle HorizontalAlign="Center" />
                        <ItemStyle HorizontalAlign="Center" />
                    </telerik:GridBoundColumn>
                    <telerik:GridBoundColumn DataField="pred_nastup" HeaderText="[%Před nástupem%]" UniqueName="sPredNastup"
                        FilterControlAltText="Filter sPredNastup column">
                        <HeaderStyle HorizontalAlign="Center" />
                        <ItemStyle HorizontalAlign="Center" />
                    </telerik:GridBoundColumn>
                    <%--<telerik:GridBoundColumn DataField="vek" HeaderText="Věk" UniqueName="iVek"
                        FilterControlAltText="Filter iVek column">
                        <HeaderStyle HorizontalAlign="Center" />
                        <ItemStyle HorizontalAlign="Center" />
                    </telerik:GridBoundColumn>--%>
                    <telerik:GridBoundColumn DataField="poznamka" HeaderText="[%Poznámka%]" UniqueName="sPoznamka" FilterControlAltText="Filter sPoznamka column">
                        <HeaderStyle HorizontalAlign="Center" />
                        <ItemStyle HorizontalAlign="Center" />
                    </telerik:GridBoundColumn>
                    <%--Mazání záznamu--%>
                    <telerik:GridButtonColumn UniqueName="deleteColumn" Text="Delete" CommandName="Delete" ButtonType="ImageButton"
                        ConfirmText="[%Opravdu chcete záznam vymazat%]?" ConfirmTitle="[%Mazání záznamu uskutečněné prohlídky%]" ConfirmDialogWidth="400" ConfirmDialogHeight="100">
                    </telerik:GridButtonColumn>
                </Columns>
                <CommandItemTemplate>
                    <kspwc:TRadButton ID="trbAdd" runat="server" Text="[%Vložit nový%]" CommandName="InitInsert" IdPrava="243">
                        <Icon PrimaryIconCssClass="fi fi-add"></Icon>
                    </kspwc:TRadButton>
                    <kspwc:GridCommandItemControl ID="GridCommandItemControl1" runat="server" RebindButton-Enabled="True"
                        RebindButton-Visible="True">
                        <ExportButton ID="ExportButton1" runat="server" ShowExportToExcelMLItem="false" ShowExportToWordItem="false" ShowExportToWordDocxItem="false" />
                    </kspwc:GridCommandItemControl>

                </CommandItemTemplate>
            </MasterTableView>
        </kspwc:TRadGrid>
        <asp:ObjectDataSource ID="odsUskutecneneProhlidky" runat="server" OldValuesParameterFormatString="original_{0}"
            SelectMethod="UskutecneneZam" TypeName="KSProgram.LekarskaEvidence.LekProhlidky">
            <SelectParameters>
                <asp:Parameter Name="Ident" Type="Int32" />
            </SelectParameters>
        </asp:ObjectDataSource>
        <asp:ObjectDataSource ID="odsLekar" runat="server" OldValuesParameterFormatString="original_{0}"
            SelectMethod="CiselnikLekaru" TypeName="KSProgram.LekarskaEvidence.LekProhlidky">
            <SelectParameters>
            </SelectParameters>
        </asp:ObjectDataSource>
        <asp:ObjectDataSource ID="odsPlatce" runat="server" OldValuesParameterFormatString="original_{0}"
            SelectMethod="CiselnikPlatcu" TypeName="KSProgram.LekarskaEvidence.LekProhlidky">
            <SelectParameters>
            </SelectParameters>
        </asp:ObjectDataSource>
        <asp:ObjectDataSource ID="odsVysledek" runat="server" OldValuesParameterFormatString="original_{0}"
            SelectMethod="VysledekLekProhl" TypeName="KSProgram.LekarskaEvidence.UskProhlidky">
            <SelectParameters>
            </SelectParameters>
        </asp:ObjectDataSource>
        <asp:ObjectDataSource ID="odsProhlidkyAll" runat="server" OldValuesParameterFormatString="original_{0}"
            SelectMethod="CiselnikProhlidekAll" TypeName="KSProgram.LekarskaEvidence.LekProhlidky">
            <SelectParameters>
            </SelectParameters>
        </asp:ObjectDataSource>
        <asp:ObjectDataSource ID="odsProhlidkyAkt" runat="server" OldValuesParameterFormatString="original_{0}"
            SelectMethod="CiselnikProhlidekAkt" TypeName="KSProgram.LekarskaEvidence.LekProhlidky">
            <SelectParameters>
            </SelectParameters>
        </asp:ObjectDataSource>
        <asp:ObjectDataSource ID="odsTyp" runat="server" OldValuesParameterFormatString="original_{0}"
            SelectMethod='TypLekProhl' TypeName="KSProgram.LekarskaEvidence.LekProhlidky">
            <SelectParameters>
            </SelectParameters>
        </asp:ObjectDataSource>
        <asp:ObjectDataSource ID="odsTypTest" runat="server" OldValuesParameterFormatString="original_{0}"
            SelectMethod='TypLekProhlTest' TypeName="KSProgram.LekarskaEvidence.LekProhlidky">
            <SelectParameters>
            </SelectParameters>
        </asp:ObjectDataSource>
    </div>
</asp:Content>
