﻿<%@ Control Language="C#" AutoEventWireup="true" CodeBehind="ZadostOpremie.ascx.cs"
    Inherits="KSPortal.Controls.ZadostOpremie" %>
<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>
<style type="text/css">
    table.InnerTableForm > tbody > tr > td
    {
        padding: 5px;
    }
    table.InnerTableFormFieldset > tbody > tr > td, span.InnerTableFormFieldset
    {
        padding: 3px;
    }
</style>
<telerik:RadAjaxManagerProxy ID="RadAjaxManagerProxy365" runat="server">
    <AjaxSettings>
        <telerik:AjaxSetting AjaxControlID="TFormView1">
            <UpdatedControls>
                <telerik:AjaxUpdatedControl ControlID="TFormView1" UpdatePanelCssClass="" />
                <telerik:AjaxUpdatedControl ControlID="TRG_odmeny" UpdatePanelCssClass="" />
            </UpdatedControls>
        </telerik:AjaxSetting>
        <telerik:AjaxSetting AjaxControlID="TRG_odmeny">
            <UpdatedControls>
                <telerik:AjaxUpdatedControl ControlID="TFormView1" UpdatePanelCssClass="" />
                <telerik:AjaxUpdatedControl ControlID="TRG_odmeny" UpdatePanelCssClass="" />
            </UpdatedControls>
        </telerik:AjaxSetting>
    </AjaxSettings>
</telerik:RadAjaxManagerProxy>
<telerik:RadScriptBlock ID="RadScriptBlock1" runat="server">
    <script type="text/javascript" id="telerikClientEvents2">
//<![CDATA[
        function TRCB_edit_os_cislo_ItemsRequesting(sender, args) {
            var context = args.get_context();
            context["UsePrava"] = true;
        }
//]]>
    </script>
</telerik:RadScriptBlock>
<asp:ObjectDataSource ID="ObjectDataSource1" runat="server" InsertMethod="Insert"
    OldValuesParameterFormatString="original_{0}" SelectMethod="Retrieve" TypeName="KSProgram.Pozadavky.Pozadavekpremie"
    OnInserted="ObjectDataSource1_Inserted" OnInserting="ObjectDataSource1_Inserting"
    OnSelected="ObjectDataSource1_Selected">
    <InsertParameters>
        <asp:Parameter Direction="InputOutput" Name="id_poz" Type="Int32" />
        <asp:Parameter Name="vyridit_do" Type="DateTime" />
        <asp:Parameter Name="obdobi" Type="DateTime" />
        <asp:Parameter Name="adresat" Type="Decimal" />
    </InsertParameters>
    <SelectParameters>
        <asp:Parameter Name="id_pozadavku" Type="Int32" />
        <asp:Parameter Name="obdobi" Type="DateTime" Direction="Output" />
    </SelectParameters>
</asp:ObjectDataSource>
<asp:ObjectDataSource ID="ODS_typy_pol" runat="server" OldValuesParameterFormatString="original_{0}"
    SelectMethod="Ciselnik" TypeName="KSProgram.Premie.TypPolozkyPremie"></asp:ObjectDataSource>
<asp:ObjectDataSource ID="ODS_typ_edit" runat="server" OldValuesParameterFormatString="original_{0}"
    SelectMethod="Ciselnik" TypeName="KSProgram.Premie.TypPolozkyPremie">
    <SelectParameters>
        <asp:Parameter DefaultValue="4" Name="skupina" Type="String" />
    </SelectParameters>
</asp:ObjectDataSource>
<asp:ObjectDataSource ID="ODS_zdroje" runat="server" OldValuesParameterFormatString="original_{0}"
    SelectMethod="Prostredky" TypeName="KSProgram.Premie.Premie" OnSelecting="ODS_zdroje_Selecting">
    <SelectParameters>
        <asp:Parameter Name="id" Type="Int32" />
        <asp:Parameter Name="id_zdroj" Type="Int32" />
        <asp:Parameter Name="obdobi" Type="DateTime" />
        <asp:Parameter DefaultValue="0,2,4" Name="whereInTyp" Type="String" />
        <asp:Parameter DefaultValue="true" Name="sloucitZust" Type="Boolean" />
        <asp:Parameter DefaultValue="Zustatek > 0" Name="podminka" Type="String" />
        <asp:Parameter DefaultValue="1" Name="prava" Type="Int16" />
    </SelectParameters>
</asp:ObjectDataSource>
<kspwc:TFormView ID="TFormView1" runat="server">
    <ItemTemplate>
        <table class="InnerTableForm">
            <tr>
                <td>
                    <fieldset id="FS_read_zam">
                        <legend>Požadavek</legend>
                        <table class="InnerTableFormFieldset">
                            <tr>
                                <td>
                                    [%Období%]
                                </td>
                                <td>
                                    <kspwc:TRadMonthYearPicker ID="TRMYP_item_obdobi" runat="server" DropDownAutoWidth="Enabled"
                                        Width="160px" DbSelectedDate='<%# Bind("obdobi") %>' ReadOnly="True">
                                        <DateInput DateFormat="MMMM yyyy" DisplayDateFormat="MMMM yyyy" EmptyMessage="[%Období%]"
                                            ReadOnly="True">
                                        </DateInput>
                                        <DatePopupButton Visible="False" />
                                    </kspwc:TRadMonthYearPicker>
                                </td>
                                <td>
                                    [%Vyřídit do%]
                                </td>
                                <td>
                                    <kspwc:TRadDatePicker ID="TRDP_item_vyriz_datum" runat="server" DropDownAutoWidth="Enabled"
                                        Width="160px" DbSelectedDate='<%# Bind("vyriz_datum") %>' ReadOnly="True">
                                        <DateInput DateFormat="d.M.yyyy" DisplayDateFormat="d.M.yyyy" EmptyMessage="[%Vyřídit do%]"
                                            ReadOnly="True">
                                        </DateInput>
                                        <DatePopupButton Visible="False" />
                                    </kspwc:TRadDatePicker>
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    [%Žadatel%]
                                </td>
                                <td>
                                    <telerik:RadTextBox ID="RTB_item_jmeno" runat="server" EmptyMessage="[%Žadatel%]"
                                        Width="160px"  Text='<%# Bind("jmeno") %>' ReadOnly="True">
                                    </telerik:RadTextBox>
                                </td>
                                <td>
                                    [%Stav%]
                                </td>
                                <td>
                                    <telerik:RadTextBox ID="RTB_item_stav" runat="server" EmptyMessage="[%Stav%]" Width="160px"
                                         Text='<%# Bind("stav") %>' ReadOnly="True">
                                    </telerik:RadTextBox>
                                </td>
                            </tr>
                        </table>
                    </fieldset>
                </td>
            </tr>
        </table>
    </ItemTemplate>
    <EditItemTemplate>
        <table class="InnerTableForm">
            <tr>
                <td>
                    <fieldset id="FS_read_zam">
                        <legend>Požadavek</legend>
                        <table class="InnerTableFormFieldset">
                            <tr>
                                <td>
                                    [%Období%]
                                </td>
                                <td>
                                    <kspwc:TRadMonthYearPicker ID="TRMYP_edit_obdobi" runat="server" DropDownAutoWidth="Enabled"
                                        Width="160px" DbSelectedDate='<%# Bind("obdobi") %>' ReadOnly="True">
                                        <DateInput DateFormat="MMMM yyyy" DisplayDateFormat="MMMM yyyy" EmptyMessage="[%Období%]"
                                            ReadOnly="True">
                                        </DateInput>
                                        <DatePopupButton Visible="False" />
                                    </kspwc:TRadMonthYearPicker>
                                </td>
                                <td>
                                    [%Vyřídit do%]
                                </td>
                                <td>
                                    <kspwc:TRadDatePicker ID="TRDP_edit_vyriz_datum" runat="server" DropDownAutoWidth="Enabled"
                                        Width="160px" DbSelectedDate='<%# Bind("vyriz_datum") %>' ReadOnly="True">
                                        <DateInput DateFormat="d.M.yyyy" DisplayDateFormat="d.M.yyyy" EmptyMessage="[%Vyřídit do%]"
                                            ReadOnly="True">
                                        </DateInput>
                                        <DatePopupButton Visible="False" />
                                    </kspwc:TRadDatePicker>
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    [%Žadatel%]
                                </td>
                                <td>
                                    <telerik:RadTextBox ID="RTB_edit_jmeno" runat="server" EmptyMessage="[%Žadatel%]"
                                        Width="160px"  Text='<%# Bind("jmeno") %>' ReadOnly="True">
                                    </telerik:RadTextBox>
                                </td>
                                <td>
                                    [%Stav%]
                                </td>
                                <td>
                                    <telerik:RadTextBox ID="RTB_edit_stav" runat="server" EmptyMessage="[%Stav%]" Width="160px"
                                         Text='<%# Bind("stav") %>' ReadOnly="True">
                                    </telerik:RadTextBox>
                                </td>
                            </tr>
                        </table>
                    </fieldset>
                </td>
            </tr>
        </table>
    </EditItemTemplate>
    <InsertItemTemplate>
        <table class="InnerTableForm">
            <tr>
                <td>
                    <fieldset id="FS_read_zam">
                        <legend>Požadavek</legend>
                        <table class="InnerTableFormFieldset">
                            <tr>
                                <td>
                                    [%Období%]
                                </td>
                                <td>
                                    <kspwc:TRadMonthYearPicker ID="TRMYP_insert_obdobi" runat="server" DropDownAutoWidth="Enabled"
                                        Width="160px" DbSelectedDate='<%# Bind("obdobi") %>'>
                                        <DateInput DateFormat="MMMM yyyy" DisplayDateFormat="MMMM yyyy" EmptyMessage="[%Období%]">
                                        </DateInput>
                                    </kspwc:TRadMonthYearPicker>
                                </td>
                                <td>
                                    <asp:RequiredFieldValidator ID="RFV_insert_obdobi" runat="server" ControlToValidate="TRMYP_insert_obdobi"
                                        Display="Dynamic" EnableClientScript="True" ErrorMessage="*"></asp:RequiredFieldValidator>
                                </td>
                                <td>
                                    [%Vyřídit do%]
                                </td>
                                <td>
                                    <kspwc:TRadDatePicker ID="TRDP_insert_vyriz_datum" runat="server" DropDownAutoWidth="Enabled"
                                        Width="160px" DbSelectedDate='<%# Bind("vyriz_datum") %>'>
                                        <DateInput DateFormat="d.M.yyyy" DisplayDateFormat="d.M.yyyy" EmptyMessage="[%Vyřídit do%]">
                                        </DateInput>
                                    </kspwc:TRadDatePicker>
                                </td>
                                <td>
                                    <asp:RequiredFieldValidator ID="RFV_insert_vyriz_datum" runat="server" ControlToValidate="TRDP_insert_vyriz_datum"
                                        Display="Dynamic" EnableClientScript="True" ErrorMessage="*"></asp:RequiredFieldValidator>
                                </td>
                            </tr>
                        </table>
                    </fieldset>
                </td>
            </tr>
        </table>
    </InsertItemTemplate>
</kspwc:TFormView>
<kspwc:TRadGrid ID="TRG_odmeny" runat="server" OnNeedDataSource="TRG_odmeny_NeedDataSource"
    AllowPaging="True" AutoGenerateColumns="False" GroupPanelPosition="Top" 
    ShowGroupPanel="True" PageSize="30" AllowSorting="True" OnItemCommand="TRG_odmeny_ItemCommand"
    OnItemDataBound="TRG_odmeny_ItemDataBound">
    <GroupingSettings CaseSensitive="False"></GroupingSettings>
    <ClientSettings AllowDragToGroup="True">
    </ClientSettings>
    <MasterTableView CommandItemDisplay="Top" EditMode="EditForms" DataKeyNames="Id">
        <EditFormSettings EditFormType="Template">
            <EditColumn UniqueName="EditCommandColumn1" FilterControlAltText="Filter EditCommandColumn1 column">
            </EditColumn>
            <FormTemplate>
                <table style="width: 100%;" class="InnerTableFormFieldset">
                    <tr>
                        <td>
                            [%Zaměstnanec%]:
                        </td>
                        <td>
                            <kspwc:TRadComboBox ID="TRCB_edit_os_cislo" runat="server" EnableLoadOnDemand="True"
                                EnableVirtualScrolling="True" Height="150px" ShowMoreResultsBox="True" DropDownAutoWidth="Enabled"
                                EmptyMessage="[%Zaměstnanec%]" AutoPostBack="True" 
                                Enabled='<%# (Container is GridEditFormInsertItem) %>' OnClientItemsRequesting="TRCB_edit_os_cislo_ItemsRequesting"
                                OnTextChanged="TRCB_edit_os_cislo_TextChanged" SelectedValue='<%# Bind("OsCislo") %>'>
                                <WebServiceSettings Method="GetZamestnanci" Path="~/PrivateWebServices/AutoCompleteService.asmx" />
                            </kspwc:TRadComboBox>
                            <kspwc:TTextBox ID="TTextBox1" runat="server" Visible="False" Text='<%# Bind("OsCislo") %>'></kspwc:TTextBox>
                        </td>
                        <td>
                            <%--<asp:RequiredFieldValidator ID="RFV_edit_os_cislo" runat="server" ControlToValidate="TRCB_edit_os_cislo"
                                Display="Dynamic" EnableClientScript="True" ErrorMessage="*"></asp:RequiredFieldValidator>--%>
                        </td>
                        <td>
                            [%Pracovní poměr%]:
                        </td>
                        <td>
                            <asp:ObjectDataSource ID="ODS_prac_pom" runat="server" OldValuesParameterFormatString="original_{0}"
                                SelectMethod="GetPomery" TypeName="KSProgram.Funkce.Prac_pom">
                                <SelectParameters>
                                    <asp:Parameter DefaultValue="" Name="co" Type="String" />
                                    <asp:ControlParameter ControlID="TRCB_edit_os_cislo" DefaultValue="0" Name="os_cislo"
                                        PropertyName="SelectedValue" />
                                </SelectParameters>
                            </asp:ObjectDataSource>
                            <kspwc:TRadComboBox ID="TRCB_edit_pom" runat="server" Enabled='<%# (Container is GridEditFormInsertItem) %>'
                                DataTextField="naz_mist" DataValueField="cislo_pom" Width="300px" DropDownAutoWidth="Enabled"
                                 DataSourceID="ODS_prac_pom" 
                                ondatabinding="TRCB_edit_pom_DataBinding">
                            </kspwc:TRadComboBox>
                            <kspwc:TTextBox ID="TTextBox2" runat="server" Visible="False" Text='<%# Bind("CisloPom") %>'></kspwc:TTextBox>
                        </td>
                        <td>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            [%Typ%]:
                        </td>
                        <td>
                            <kspwc:TRadComboBox ID="TRCB_edit_typ" runat="server" Enabled='<%# (Container is GridEditFormInsertItem) %>'
                                DataSourceID="ODS_typ_edit" DataTextField="Value" DataValueField="Key" SelectedValue='<%# Bind("Typ") %>'>
                            </kspwc:TRadComboBox>
                        </td>
                        <td>
                        </td>
                        <td>
                            [%Částka%]:
                        </td>
                        <td>
                            <telerik:RadNumericTextBox ID="RNTB_edit_castka" runat="server" MinValue="0" MaxValue="1000000"
                                DataType="System.Decimal" DbValue='<%# Bind("Castka") %>'>
                            </telerik:RadNumericTextBox>
                        </td>
                        <td>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            [%Zdroj%]:
                        </td>
                        <td colspan="4">
                            <kspwc:TRadComboBox ID="TRCB_edit_zdroj" runat="server" DataSourceID="ODS_zdroje"
                                DataTextField="OjNazev" DataValueField="Id"  DropDownWidth="600px"
                                Width="300px" HighlightTemplatedItems="True">
                                <HeaderTemplate>
                                    <table>
                                        <tr>
                                            <td style="width: 250px">
                                                [%Jednotka%]
                                            </td>
                                            <td style="width: 250px">
                                                [%Popis%]
                                            </td>
                                            <td style="width: 100px" align="right">
                                                [%Zůstatek%]
                                            </td>
                                        </tr>
                                    </table>
                                </HeaderTemplate>
                                <ItemTemplate>
                                    <table>
                                        <tr>
                                            <td style="width: 250px">
                                                <%# DataBinder.Eval(Container.DataItem, "OjNazev") %>
                                            </td>
                                            <td style="width: 250px">
                                                <%# DataBinder.Eval(Container.DataItem, "Popis")%>
                                            </td>
                                            <td style="width: 100px" align="right">
                                                <%# DataBinder.Eval(Container.DataItem, "Zustatek", "{0:#,##0}")%>
                                            </td>
                                        </tr>
                                    </table>
                                </ItemTemplate>
                            </kspwc:TRadComboBox>
                            <kspwc:TTextBox ID="TTextBox3" runat="server" Visible="False" Text='<%# Bind("IdZdroj") %>'></kspwc:TTextBox>
                        </td>
                        <td>
                        </td>
                    </tr>
                    <tr>
                        <td colspan="6">
                            <fieldset>
                                <legend>[%Popis%]</legend>
                                <telerik:RadTextBox ID="RTB_edit_popis" runat="server" MaxLength="255" Rows="3" TextMode="MultiLine"
                                    Width="100%" Text='<%# Bind("Popis") %>'>
                                </telerik:RadTextBox>
                            </fieldset>
                        </td>
                    </tr>
                </table>
                <br />
                <kspwc:TRadButton ID="TRadButton1" runat="server" Text="[%Uložit%]" CausesValidation="False"
                    CommandName='<%# (Container is GridEditFormInsertItem) ? "PerformInsert" : "Update" %>'
                    AutoPostBack="True">
                    <Icon PrimaryIconCssClass="fi fi-disk"></Icon>
                </kspwc:TRadButton>
                &nbsp;
                <kspwc:TRadButton ID="RadButton7" runat="server" Text="[%Zrušit změny%]" CausesValidation="False"
                    CommandName="Cancel">
                    <Icon PrimaryIconCssClass="fi fi-ban"></Icon>
                </kspwc:TRadButton>
            </FormTemplate>
        </EditFormSettings>
        <PagerStyle AlwaysVisible="True" PageSizes="10,20,30,50,100,150,200" />
        <RowIndicatorColumn Visible="False">
        </RowIndicatorColumn>
        <ExpandCollapseColumn Created="True">
        </ExpandCollapseColumn>
        <Columns>
            <telerik:GridEditCommandColumn ButtonType="ImageButton" />
            <telerik:GridBoundColumn DataField="SkupStrNazev" FilterControlAltText="Filter SkupStrNazev column"
                HeaderText="[%Skup. střed.%]" UniqueName="SkupStrNazev">
            </telerik:GridBoundColumn>
            <telerik:GridBoundColumn DataField="PracStrNazev" FilterControlAltText="Filter PracStrNazev column"
                HeaderText="[%Středisko%]" UniqueName="PracStrNazev">
            </telerik:GridBoundColumn>
            <telerik:GridNumericColumn DataField="OsCislo" DataType="System.Decimal" DecimalDigits="0"
                FilterControlAltText="Filter OsCislo column" HeaderText="[%Os. čislo%]" UniqueName="OsCislo" FilterControlWidth="40">
            </telerik:GridNumericColumn>
            <telerik:GridNumericColumn DataField="CisloPom" DataType="System.Int16" DecimalDigits="0"
                FilterControlAltText="Filter CisloPom column" HeaderText="[%Poměr%]" UniqueName="CisloPom" FilterControlWidth="40">
            </telerik:GridNumericColumn>
            <telerik:GridBoundColumn DataField="Jmeno" FilterControlAltText="Filter Jmeno column"
                HeaderText="[%Jméno%]" UniqueName="Jmeno">
            </telerik:GridBoundColumn>
            <telerik:GridDropDownColumn DataField="Typ" DataType="System.Int16" FilterControlAltText="Filter Typ column"
                HeaderText="[%typ%]" UniqueName="Typ" DataSourceID="ODS_typy_pol" ListValueField="Key"
                ListTextField="Value">
            </telerik:GridDropDownColumn>
            <telerik:GridBoundColumn DataField="TypNazev" FilterControlAltText="Filter TypNazev column"
                HeaderText="[%Typ%]" UniqueName="TypNazev" SortExpression="TypNazev" Display="false">
            </telerik:GridBoundColumn>
            <telerik:GridNumericColumn DataField="Castka" DataType="System.Decimal" DecimalDigits="2"
                FilterControlAltText="Filter Castka column" HeaderText="[%Částka%]" UniqueName="Castka" FilterControlWidth="60">
            </telerik:GridNumericColumn>
            <telerik:GridBoundColumn DataField="OjZdrojNazev" FilterControlAltText="Filter OjZdrojNazev column"
                HeaderText="[%Zdroj%]" UniqueName="OjZdrojNazev">
            </telerik:GridBoundColumn>
            <telerik:GridBoundColumn DataField="Popis" FilterControlAltText="Filter Popis column"
                HeaderText="[%Popis%]" UniqueName="Popis">
            </telerik:GridBoundColumn>
            <telerik:GridButtonColumn ConfirmText="[%Smazat řádek%]?" ConfirmDialogType="RadWindow"
                ConfirmTitle="[%Mazání%]" ButtonType="ImageButton" CommandName="Delete" />
        </Columns>
        <CommandItemTemplate>
            <kspwc:GridCommandItemControl ID="GridCommandItemControl1" runat="server">
                <AddNewItemButton runat="server" Visible="true">
                </AddNewItemButton>
            </kspwc:GridCommandItemControl>
        </CommandItemTemplate>
    </MasterTableView>
</kspwc:TRadGrid>
