﻿<%@ Control Language="C#" AutoEventWireup="true" CodeBehind="ZadostOpremiegum.ascx.cs" Inherits="KSPortal.Controls.ZadostOpremiegum" %>
<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>
<style type="text/css">
    table.InnerTableForm > tbody > tr > td
    {
        padding: 5px;
    }
    table.InnerTableFormFieldset > tbody > tr > td, span.InnerTableFormFieldset
    {
        padding: 3px;
    }
    .thisRg .rgFilterRow .rgFilterBox, .thisRg .rgFilterRow .riSingle
    {
        width: calc(100% - 21px) !important;
    }
    .myGreen
    {
        color: Green !important;
    }
    .myRed
    {
        color: Red !important;
    }
    div.ksPozTelo {
        min-width: 1300px;
    }
</style>
<telerik:RadScriptBlock ID="RadScriptBlock1" runat="server">
    <script type="text/javascript" id="telerikClientEvents1">
                                //<![CDATA[
        function TRadButton1_Clicked(sender, args) {
            var grid = $find("<%=TRG_odmeny.ClientID %>");
            var tableView = grid.get_masterTableView();

            grid.get_batchEditingManager().saveChanges(tableView);

            return false;
        }

        function TRG_odmeny_OnBatchEditGetCellValue(sender, args) {
            if (args.get_columnUniqueName() === "Castka" || args.get_columnUniqueName() === "Zadrzet" ||
                args.get_columnUniqueName() === "Zadrzet_VP" || args.get_columnUniqueName() === "Zadrzet_AP" || args.get_columnUniqueName() === "Zadrzet_KP" ||
                args.get_columnUniqueName() === "VyplatitZad" || args.get_columnUniqueName() == "VyplatitZad_V" ||
                args.get_columnUniqueName() == "VyplatitZad_A" || args.get_columnUniqueName() == "VyplatitZad_K") {
                var cell = args.get_cell();
                if (cell.getElementsByClassName("rlb").length > 0) {
                    var RLB = $get(cell.getElementsByClassName("rlb")[0].id);
                    var value = RLB.innerText;
                    args.set_cancel(true);
                    args.set_value(parseFloat(value).toFixed(2).replace('.', ','));
                }
            }
        }

        function TRG_odmeny_OnBatchEditSetCellValue(sender, args) {
            if (args.get_columnUniqueName() === "Castka" || args.get_columnUniqueName() === "Zadrzet" ||
                args.get_columnUniqueName() === "Zadrzet_VP" || args.get_columnUniqueName() === "Zadrzet_AP" || args.get_columnUniqueName() === "Zadrzet_KP" ||
                args.get_columnUniqueName() === "VyplatitZad" || args.get_columnUniqueName() == "VyplatitZad_V" ||
                args.get_columnUniqueName() == "VyplatitZad_A" || args.get_columnUniqueName() == "VyplatitZad_K") {

                var value = args.get_value();
                value = value ? value : 0;
                var cell = args.get_cell();
                if (cell.getElementsByClassName("rlb").length > 0) {
                    var RLB = $get(cell.getElementsByClassName("rlb")[0].id);
                    args.set_cancel(true);
                    RLB.innerText = value;
                }
            }
        }

        function TRG_odmeny_OnBatchEditGetEditorValue(sender, args) {
            if (args.get_columnUniqueName() === "Castka" || args.get_columnUniqueName() === "Zadrzet" ||
                args.get_columnUniqueName() === "Zadrzet_VP" || args.get_columnUniqueName() === "Zadrzet_AP" || args.get_columnUniqueName() === "Zadrzet_KP" ||
                args.get_columnUniqueName() === "VyplatitZad" || args.get_columnUniqueName() == "VyplatitZad_V" ||
                args.get_columnUniqueName() == "VyplatitZad_A" || args.get_columnUniqueName() == "VyplatitZad_K") {

                var cell = args.get_cell();
                var RNTB;
                if (cell.getElementsByClassName("rntb").length > 0) {
                    args.set_cancel(true);
                    RNTB = $find(cell.getElementsByClassName("rntb")[0].id);
                    var curval = RNTB.get_value();
                    curval = curval.replace ? 0 : curval;
                    //args.set_value(curval);
                    args.set_value(parseFloat(curval).toFixed(2).replace('.', ','));
                }
                //else {
                //    args.set_value(0);
                //}
            }
        }
        function TRG_odmeny_OnBatchEditSetEditorValue(sender, args) {
            if (args.get_columnUniqueName() === "Castka" || args.get_columnUniqueName() === "Zadrzet" ||
                args.get_columnUniqueName() === "Zadrzet_VP" || args.get_columnUniqueName() === "Zadrzet_AP" || args.get_columnUniqueName() === "Zadrzet_KP" ||
                args.get_columnUniqueName() === "VyplatitZad" || args.get_columnUniqueName() === "VyplatitZad_V" ||
                args.get_columnUniqueName() === "VyplatitZad_A" || args.get_columnUniqueName() === "VyplatitZad_K") {

                var value = args.get_value();
                value = value ? value : 0;
                var cell = args.get_cell();
                if (cell.getElementsByClassName("rntb").length > 0) {
                    var RNTB = $find(cell.getElementsByClassName("rntb")[0].id);
                    args.set_cancel(true);
                    RNTB.set_value(value);
                }
            }
        }
        function TRG_odmeny_OnBatchEditOpening(sender, args) {

        }
        function GetGridServerElement(control, serverID, tagName, getMetod) {
            if (!tagName)
                tagName = "*"; //* means all elements 

            var elements = control.getElementsByTagName(tagName);
            for (var i = 0; i < elements.length; i++) {
                var element = elements[i];
                if (element.id.indexOf(serverID) >= 0) {
                    var ret = null;
                    if (!getMetot || getMetot == "find") {
                        ret = $find(element.id);
                    }
                    else {
                        ret = $get(element.id);
                    }
                    if (ret) {
                        return ret;
                    }
                }
            }
            return null;
        }

        function RNTB_OnKeyPress(sender, args) {
            var c = args.get_keyCode();
            if ((c == 13)) {
                args.set_cancel(true);
                sender.blur();
                var grid = $find("<%=TRG_odmeny.ClientID %>");
                var batchManager = grid.get_batchEditingManager();
                var tableView = grid.get_masterTableView();
                setTimeout(function () {
                    batchManager._tryCloseEdits(tableView);
                    setTimeout(function () {
                        batchManager.saveChanges(grid.get_masterTableView());
                    });
                });
            }
        }
                                //]]>
    </script>
</telerik:RadScriptBlock>
<telerik:RadAjaxManagerProxy ID="RadAjaxManagerProxy365" runat="server">
    <AjaxSettings>
        <telerik:AjaxSetting AjaxControlID="TFormView1">
            <UpdatedControls>
                <telerik:AjaxUpdatedControl ControlID="TFormView1" UpdatePanelCssClass="" />
                <telerik:AjaxUpdatedControl ControlID="TRG_odmeny" UpdatePanelCssClass="" />
            </UpdatedControls>
        </telerik:AjaxSetting>
        <telerik:AjaxSetting AjaxControlID="TRG_odmeny">
            <UpdatedControls>
                <telerik:AjaxUpdatedControl ControlID="TFormView1" UpdatePanelCssClass="" />
                <telerik:AjaxUpdatedControl ControlID="TRG_odmeny" UpdatePanelCssClass="" />
            </UpdatedControls>
        </telerik:AjaxSetting>
    </AjaxSettings>
</telerik:RadAjaxManagerProxy>
<asp:ObjectDataSource ID="ObjectDataSource1" runat="server" InsertMethod="Insert"
    OldValuesParameterFormatString="original_{0}" SelectMethod="Retrieve" TypeName="KSProgram.Pozadavky.Pozadavekpremiegum"
    OnInserted="ObjectDataSource1_Inserted" OnInserting="ObjectDataSource1_Inserting"
    OnSelected="ObjectDataSource1_Selected" UpdateMethod="Update" OnUpdated="ObjectDataSource1_Updated"
    OnUpdating="ObjectDataSource1_Updating">
    <InsertParameters>
        <asp:Parameter Direction="InputOutput" Name="id_poz" Type="Int32" />
        <asp:Parameter Name="vyridit_do" Type="DateTime" />
        <asp:Parameter Name="obdobi" Type="DateTime" />
        <asp:Parameter Name="zapsal" Type="Decimal" />
    </InsertParameters>
    <SelectParameters>
        <asp:Parameter Name="id_pozadavku" Type="Int32" />
        <asp:Parameter Name="obdobi" Type="DateTime" Direction="Output" />
    </SelectParameters>
    <UpdateParameters>
        <asp:Parameter Name="id_poz" Type="Int32" />
        <asp:Parameter Name="vyridit_do" Type="DateTime" />
    </UpdateParameters>
</asp:ObjectDataSource>
<kspwc:TFormView ID="TFormView1" runat="server">
    <ItemTemplate>
        <table class="InnerTableForm">
            <tr>
                <td>
                    <fieldset id="FS_read_zam">
                        <legend>Požadavek</legend>
                        <table class="InnerTableFormFieldset">
                            <tr>
                                <td>
                                    [%Období%]
                                </td>
                                <td>
                                    <kspwc:TRadMonthYearPicker ID="TRMYP_item_obdobi" runat="server" DropDownAutoWidth="Enabled"
                                        Width="160px" DbSelectedDate='<%# Bind("obdobi") %>' ReadOnly="True">
                                        <DateInput DateFormat="MMMM yyyy" DisplayDateFormat="MMMM yyyy" EmptyMessage="[%Období%]"
                                            ReadOnly="True">
                                        </DateInput>
                                        <DatePopupButton Visible="False" />
                                    </kspwc:TRadMonthYearPicker>
                                </td>
                                <td>
                                    [%Vyřídit do%]
                                </td>
                                <td>
                                    <kspwc:TRadDatePicker ID="TRDP_item_vyriz_datum" runat="server" DropDownAutoWidth="Enabled"
                                        Width="160px" DbSelectedDate='<%# Bind("vyridit_do") %>' ReadOnly="True">
                                        <DateInput DateFormat="d.M.yyyy" DisplayDateFormat="d.M.yyyy" EmptyMessage="[%Vyřídit do%]"
                                            ReadOnly="True">
                                        </DateInput>
                                        <DatePopupButton Visible="False" />
                                    </kspwc:TRadDatePicker>
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    [%Žadatel%]
                                </td>
                                <td>
                                    <telerik:RadTextBox ID="RTB_item_jmeno" runat="server" EmptyMessage="[%Žadatel%]"
                                        Width="160px"  Text='<%# Bind("jmeno") %>' ReadOnly="True">
                                    </telerik:RadTextBox>
                                </td>
                                <td>
                                    [%Stav%]
                                </td>
                                <td>
                                    <telerik:RadTextBox ID="RTB_item_stav" runat="server" EmptyMessage="[%Stav%]" Width="160px"
                                         Text='<%# Bind("stav") %>' ReadOnly="True">
                                    </telerik:RadTextBox>
                                </td>
                            </tr>
                        </table>
                    </fieldset>
                </td>
            </tr>
        </table>
    </ItemTemplate>
    <EditItemTemplate>
        <table class="InnerTableForm">
            <tr>
                <td>
                    <fieldset id="FS_read_zam">
                        <legend>Požadavek</legend>
                        <table class="InnerTableFormFieldset">
                            <tr>
                                <td>
                                    [%Období%]
                                </td>
                                <td>
                                    <kspwc:TRadMonthYearPicker ID="TRMYP_edit_obdobi" runat="server" DropDownAutoWidth="Enabled"
                                        Width="160px" DbSelectedDate='<%# Bind("obdobi") %>' ReadOnly="True">
                                        <DateInput DateFormat="MMMM yyyy" DisplayDateFormat="MMMM yyyy" EmptyMessage="[%Období%]"
                                            ReadOnly="True">
                                        </DateInput>
                                        <DatePopupButton Visible="False" />
                                    </kspwc:TRadMonthYearPicker>
                                </td>
                                <td>
                                    [%Vyřídit do%]
                                </td>
                                <td>
                                    <kspwc:TRadDatePicker ID="TRDP_edit_vyriz_datum" runat="server" DropDownAutoWidth="Enabled"
                                        Width="160px" DbSelectedDate='<%# Bind("vyridit_do") %>'>
                                        <DateInput DateFormat="d.M.yyyy" DisplayDateFormat="d.M.yyyy" EmptyMessage="[%Vyřídit do%]">
                                        </DateInput>
                                        <DatePopupButton />
                                    </kspwc:TRadDatePicker>
                                    <asp:RequiredFieldValidator ID="RFV_edit_vyriz_datum" runat="server" ControlToValidate="TRDP_edit_vyriz_datum"
                                        Display="Dynamic" EnableClientScript="True" ErrorMessage="*"></asp:RequiredFieldValidator>

                                </td>
                            </tr>
                            <tr>
                                <td>
                                    [%Žadatel%]
                                </td>
                                <td>
                                    <telerik:RadTextBox ID="RTB_edit_jmeno" runat="server" EmptyMessage="[%Žadatel%]"
                                        Width="160px"  Text='<%# Bind("jmeno") %>' ReadOnly="True">
                                    </telerik:RadTextBox>
                                </td>
                                <td>
                                    [%Stav%]
                                </td>
                                <td>
                                    <telerik:RadTextBox ID="RTB_edit_stav" runat="server" EmptyMessage="[%Stav%]" Width="160px"
                                         Text='<%# Bind("stav") %>' ReadOnly="True">
                                    </telerik:RadTextBox>
                                </td>
                            </tr>
                        </table>
                    </fieldset>
                </td>
            </tr>
        </table>
    </EditItemTemplate>
    <InsertItemTemplate>
        <table class="InnerTableForm">
            <tr>
                <td>
                    <fieldset id="FS_read_zam">
                        <legend>Požadavek</legend>
                        <table class="InnerTableFormFieldset">
                            <tr>
                                <td>
                                    [%Období%]
                                </td>
                                <td>
                                    <kspwc:TRadMonthYearPicker ID="TRMYP_insert_obdobi" runat="server" DropDownAutoWidth="Enabled"
                                        Width="160px" DbSelectedDate='<%# Bind("obdobi") %>'>
                                        <DateInput DateFormat="MMMM yyyy" DisplayDateFormat="MMMM yyyy" EmptyMessage="[%Období%]">
                                        </DateInput>
                                    </kspwc:TRadMonthYearPicker>
                                </td>
                                <td>
                                    <asp:RequiredFieldValidator ID="RFV_insert_obdobi" runat="server" ControlToValidate="TRMYP_insert_obdobi"
                                        Display="Dynamic" EnableClientScript="True" ErrorMessage="*"></asp:RequiredFieldValidator>
                                </td>
                                <td>
                                    [%Vyřídit do%]
                                </td>
                                <td>
                                    <kspwc:TRadDatePicker ID="TRDP_insert_vyriz_datum" runat="server" DropDownAutoWidth="Enabled"
                                        Width="160px" DbSelectedDate='<%# Bind("vyridit_do") %>'>
                                        <DateInput DateFormat="d.M.yyyy" DisplayDateFormat="d.M.yyyy" EmptyMessage="[%Vyřídit do%]">
                                        </DateInput>
                                    </kspwc:TRadDatePicker>
                                </td>
                                <td>
                                    <asp:RequiredFieldValidator ID="RFV_insert_vyriz_datum" runat="server" ControlToValidate="TRDP_insert_vyriz_datum"
                                        Display="Dynamic" EnableClientScript="True" ErrorMessage="*"></asp:RequiredFieldValidator>
                                </td>
                            </tr>
                        </table>
                    </fieldset>
                </td>
            </tr>
        </table>
    </InsertItemTemplate>
</kspwc:TFormView>
<asp:Panel ID="Panel1" runat="server">
    <kspwc:TRadButton ID="TRadButton12" runat="server" Text="[%Uložit%]" OnClientClicked="TRadButton1_Clicked"
        AutoPostBack="false" CssClass="hidden">
        <Icon PrimaryIconCssClass="fi fi-disk" />
    </kspwc:TRadButton>
    <telerik:RadTextBox ID="RTB_focus" runat="server" CssClass="hidden">
    </telerik:RadTextBox>
    <kspwc:TRadGrid ID="TRG_odmeny" runat="server" OnNeedDataSource="TRG_odmeny_NeedDataSource"
        AllowPaging="True" AutoGenerateColumns="False" GroupPanelPosition="Top" ShowGroupPanel="True"
        PageSize="30" AllowSorting="True" AutoFilterControlWidth="false" OnBatchEditCommand="TRG_odmeny_BatchEditCommand"
        OnPreRender="TRG_odmeny_PreRender" OnItemDataBound="TRG_odmeny_ItemDataBound"
        IsExporting="False" ShowFooter="True" OnExportCellFormatting="TRG_odmeny_ExportCellFormatting"
        OnDataBound="TRG_odmeny_DataBound" CssClass="thisRg">
        <GroupingSettings CaseSensitive="False" ShowUnGroupButton="True"></GroupingSettings>
        <ClientSettings AllowDragToGroup="False">
            <ClientEvents OnBatchEditOpened="TRG_odmeny_OnBatchEditOpened" OnBatchEditClosing="TRG_odmeny_OnBatchEditClosing"
                OnBatchEditGetCellValue="TRG_odmeny_OnBatchEditGetCellValue" OnBatchEditGetEditorValue="TRG_odmeny_OnBatchEditGetEditorValue"
                OnBatchEditOpening="TRG_odmeny_OnBatchEditOpening" OnBatchEditSetCellValue="TRG_odmeny_OnBatchEditSetCellValue"
                OnBatchEditSetEditorValue="TRG_odmeny_OnBatchEditSetEditorValue" />
        </ClientSettings>
        <MasterTableView CommandItemDisplay="Top" EditMode="Batch"
            DataKeyNames="Id,IdZdroj,OsCislo,CisloPom,Obdobi,Kod,TypOj,Oj,Castka" AllowAutomaticUpdates="False"
            ClientDataKeyNames="Id,IdZdroj,Castka,Zadrzet,Zadrzeno,VyplatitZad" 
            ShowGroupFooter="True" ShowFooter="True">
            <BatchEditingSettings EditType="Row" OpenEditingEvent="Click" />
            <RowIndicatorColumn Visible="False">
            </RowIndicatorColumn>
            <ExpandCollapseColumn Created="True">
            </ExpandCollapseColumn>
            <CommandItemTemplate>
                <table>
                    <tr>
                        <td>
                            <kspwc:GridCommandItemControl ID="GridCommandItemControl1" runat="server">
                                <AddNewItemButton ID="AddNewItemButton1" runat="server" Visible="false">
                                    <Icon PrimaryIconCssClass="fi fi-add" PrimaryIconLeft="4px" PrimaryIconTop="3px" />
                                </AddNewItemButton>
                                <ExportButton ID="ExportGridButton" runat="server" RegistreWithAjaxManager="False"
                                    ShowExportToExcelBIFFItem="False" ShowExportToExcelXlsxItem="False" ShowExportToWordDocxItem="False"
                                    ShowExportToCsvItem="False" />
                            </kspwc:GridCommandItemControl>
                        </td>
                        <td>
                            <kspwc:TRadButton ID="TRadButton1" runat="server" Text="[%Uložit%]" OnClientClicked="TRadButton1_Clicked"
                                AutoPostBack="false">
                                <Icon PrimaryIconCssClass="fi fi-disk" />
                            </kspwc:TRadButton>
                            <telerik:RadScriptBlock ID="RadScriptBlock2" runat="server">
                                <script type="text/javascript" id="telerikClientEvents2">
                                    //<![CDATA[
                                    function TRG_odmeny_OnBatchEditOpened(sender, args) {
                                        if (args.get_columnUniqueName() == "VyplatitZad" || args.get_columnUniqueName() == "VyplatitZad_V" || args.get_columnUniqueName() == "VyplatitZad_A" || args.get_columnUniqueName() == "VyplatitZad_K" || args.get_columnUniqueName() == "Zadrzet") {
                                            var RNTB = $find(args.get_cell().getElementsByClassName("rntb")[0].id);
                                            var max = 1000000000;
                                            var node = args.get_row().childNodes[args.get_cell().cellIndex];
                                            if (node.getElementsByClassName("rlb").length > 0) {
                                                var RLB = $get(node.getElementsByClassName("rlb")[0].id);
                                                max = RLB.innerText;
                                            }
                                            else {
                                                max = node.innerText;
                                            }
                                            if (max.replace) {
                                                max = max.replace(',', '.');
                                            }
                                            if (args.get_columnUniqueName() == "Zadrzet") {
                                                RNTB.set_maxValue(parseFloat(max));
                                            }
                                            else {
                                                //var curval = args.get_cell().innerText;
                                                var curval = 0;
                                                if (args.get_cell().getElementsByClassName("rlb").length > 0) {
                                                    var RLB = $get(args.get_cell().getElementsByClassName("rlb")[0].id);
                                                    curval = RLB.innerText;
                                                }
                                                else {
                                                    curval = args.get_cell().innerText;
                                                }
                                                if (curval.replace) {
                                                    curval = curval.replace(',', '.');
                                                    RNTB.set_maxValue(parseFloat(max) + parseFloat(curval));
                                                }
                                            }
                                        }
                                    }
                                    function TRG_odmeny_OnBatchEditClosing(sender, args) {
                                        if (args.get_columnUniqueName() == "VyplatitZad" || args.get_columnUniqueName() == "VyplatitZad_V" || args.get_columnUniqueName() == "VyplatitZad_A" || args.get_columnUniqueName() == "VyplatitZad_K" || args.get_columnUniqueName() == "Zadrzet") {
                                            var RNTB = $find(args.get_cell().getElementsByClassName("rntb")[0].id);
                                            RNTB.set_maxValue(1000000000);
                                        }
                                    }
//]]>
                                </script>
                            </telerik:RadScriptBlock>
                        </td>
                    </tr>
                </table>
            </CommandItemTemplate>
            <Columns>
                <telerik:GridBoundColumn DataField="SkupStrNazev" FilterControlAltText="Filter SkupStrNazev column"
                    HeaderText="[%Skup. střed.%]" UniqueName="SkupStrNazev" ReadOnly="True" Visible="false">
                    <%--<HeaderStyle Width="170px"></HeaderStyle>--%>
                </telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="PracStr" FilterControlAltText="Filter PracStr column"
                    HeaderText="[%Číslo střed.%]" UniqueName="PracStr" ReadOnly="True">
                    <%--<HeaderStyle Width="95px"></HeaderStyle>--%>
                </telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="PracStrNazev" FilterControlAltText="Filter PracStrNazev column"
                    HeaderText="[%Středisko%]" UniqueName="PracStrNazev" ReadOnly="True">
                    <%--<HeaderStyle Width="120px"></HeaderStyle>--%>
                </telerik:GridBoundColumn>
                <telerik:GridNumericColumn DataField="OsCislo" DataType="System.Decimal" DecimalDigits="0"
                    FilterControlAltText="Filter OsCislo column" HeaderText="[%Os. čislo%]" UniqueName="OsCislo"
                    ReadOnly="True" ColumnGroupName="zam">
                    <%--<HeaderStyle Width="95px"></HeaderStyle>--%>
                </telerik:GridNumericColumn>
                <telerik:GridNumericColumn DataField="CisloPom" DataType="System.Int16" DecimalDigits="0"
                    FilterControlAltText="Filter CisloPom column" HeaderText="[%Poměr%]" UniqueName="CisloPom"
                    ReadOnly="True" ColumnGroupName="zam" Visible="false">
                    <%--<HeaderStyle Width="95px"></HeaderStyle>--%>
                </telerik:GridNumericColumn>
                <telerik:GridBoundColumn DataField="Jmeno" FilterControlAltText="Filter Jmeno column"
                    HeaderText="[%Jméno%]" UniqueName="Jmeno" ReadOnly="True" ColumnGroupName="zam">
                    <HeaderStyle Width="150px"></HeaderStyle>
                </telerik:GridBoundColumn>
                <telerik:GridNumericColumn DataField="Narok" DataType="System.Decimal" DecimalDigits="2"
                    FilterControlAltText="Filter Narok column" HeaderText="[%Nárok%]" UniqueName="Narok"
                    ReadOnly="True" ColumnGroupName="prem" Aggregate="Sum">
                    <HeaderStyle BackColor="#F0FCF0" />
                </telerik:GridNumericColumn>
                <telerik:GridNumericColumn DataField="ZtohoZad" DataType="System.Decimal" DecimalDigits="2"
                    FilterControlAltText="Filter ZtohoZad column" HeaderText="[%Z toho zádržné%]" UniqueName="ZtohoZad"
                    ReadOnly="True" ColumnGroupName="prem" Aggregate="Sum">
                    <HeaderStyle BackColor="#F0FCF0" />
                </telerik:GridNumericColumn>
                <telerik:GridTemplateColumn FilterControlAltText="Filter Castka column" UniqueName="Castka"
                    DataField="Castka" DataType="System.Decimal" HeaderText="[%Prémie%]" ColumnGroupName="prem" Aggregate="Sum">
                    <EditItemTemplate>
                        <telerik:RadNumericTextBox ID="RNTB_Castka" runat="server" DbValue='<%# Bind("Castka") %>'
                            MinValue="0" ShowSpinButtons="True" Width="100%" CssClass="rntb">
                            <IncrementSettings Step="100" InterceptMouseWheel="False" />
                            <ClientEvents OnKeyPress="RNTB_OnKeyPress" />
                        </telerik:RadNumericTextBox>
                    </EditItemTemplate>
                    <ItemTemplate>
                        <telerik:RadLabel ID="RL_Castka" runat="server" Text='<%# Eval("Castka") %>' CssClass="rlb">
                        </telerik:RadLabel>
                    </ItemTemplate>
                    <%--<HeaderStyle Width="95px"></HeaderStyle>--%>
                    <ItemStyle Font-Bold="True" />
                    <HeaderStyle BackColor="#F0FCF0" />
                </telerik:GridTemplateColumn>
                <telerik:GridTemplateColumn FilterControlAltText="Filter Zadrzet column" UniqueName="Zadrzet"
                    DataField="Zadrzet" DataType="System.Decimal" HeaderText="[%Zadržet%]" ColumnGroupName="prem" Aggregate="Sum">
                    <EditItemTemplate>
                        <telerik:RadNumericTextBox ID="RNTB_Zadrzet" runat="server" DbValue='<%# Bind("Zadrzet") %>'
                            MinValue="0" ShowSpinButtons="True" Width="100%" CssClass="rntb">
                            <IncrementSettings Step="100" InterceptMouseWheel="False" />
                            <ClientEvents OnKeyPress="RNTB_OnKeyPress" />
                        </telerik:RadNumericTextBox>
                    </EditItemTemplate>
                    <ItemTemplate>
                        <telerik:RadLabel ID="RadLabel2" runat="server" Text='<%# Eval("Zadrzet") %>' CssClass="rlb">
                        </telerik:RadLabel>
                    </ItemTemplate>
                    <HeaderStyle BackColor="#F0FCF0" />
                </telerik:GridTemplateColumn>
                <telerik:GridTemplateColumn FilterControlAltText="Filter Zadrzet_VP column" UniqueName="Zadrzet_VP"
                    DataField="Zadrzet_VP" DataType="System.Decimal" HeaderText="[%%%]" ColumnGroupName="zadrzetv" Aggregate="Avg" FooterAggregateFormatString="Avg: {0:F}">
                    <EditItemTemplate>
                        <telerik:RadNumericTextBox ID="RNTB_Zadrzet_VP" runat="server" DbValue='<%# Bind("Zadrzet_VP") %>'
                            MinValue="0" MaxValue="100" ShowSpinButtons="True" Width="100%" CssClass="rntb">
                            <IncrementSettings Step="5" InterceptMouseWheel="False" />
                            <ClientEvents OnKeyPress="RNTB_OnKeyPress" />
                        </telerik:RadNumericTextBox>
                    </EditItemTemplate>
                    <ItemTemplate>
                        <telerik:RadLabel ID="RL_Zadrzet_VP" runat="server" Text='<%# Eval("Zadrzet_VP") %>' CssClass="rlb">
                        </telerik:RadLabel>
                    </ItemTemplate>
                    <%--<HeaderStyle Width="95px"></HeaderStyle>--%>
                    <HeaderStyle BackColor="#E0FFFF" />
                </telerik:GridTemplateColumn>
                <telerik:GridNumericColumn DataField="Zadrzet_V" DataType="System.Decimal" DecimalDigits="2"
                    FilterControlAltText="Filter Zadrzet_V column" HeaderText="[%Zadržet%]" UniqueName="Zadrzet_V"
                    ReadOnly="True" ColumnGroupName="zadrzetv" Aggregate="Sum">
                    <%--<HeaderStyle Width="60px"></HeaderStyle>--%>
                    <HeaderStyle BackColor="#E0FFFF" />
                </telerik:GridNumericColumn>
                <telerik:GridTemplateColumn FilterControlAltText="Filter Zadrzet_AP column" UniqueName="Zadrzet_AP"
                    DataField="Zadrzet_AP" DataType="System.Decimal" HeaderText="[%%%]" ColumnGroupName="zadrzeta" Aggregate="Avg" FooterAggregateFormatString="Avg: {0:F}">
                    <EditItemTemplate>
                        <telerik:RadNumericTextBox ID="RNTB_Zadrzet_AP" runat="server" DbValue='<%# Bind("Zadrzet_AP") %>'
                            MinValue="0" MaxValue="100" ShowSpinButtons="True" Width="100%" CssClass="rntb">
                            <IncrementSettings Step="5" InterceptMouseWheel="False" />
                            <ClientEvents OnKeyPress="RNTB_OnKeyPress" />
                        </telerik:RadNumericTextBox>
                    </EditItemTemplate>
                    <ItemTemplate>
                        <telerik:RadLabel ID="RL_Zadrzet_AP" runat="server" Text='<%# Eval("Zadrzet_AP") %>' CssClass="rlb">
                        </telerik:RadLabel>
                    </ItemTemplate>
                    <%--<HeaderStyle Width="95px"></HeaderStyle>--%>
                    <HeaderStyle BackColor="#E0FFFF" />
                </telerik:GridTemplateColumn>
                <telerik:GridNumericColumn DataField="Zadrzet_A" DataType="System.Decimal" DecimalDigits="2"
                    FilterControlAltText="Filter Zadrzet_A column" HeaderText="[%Zadržet%]" UniqueName="Zadrzet_A"
                    ReadOnly="True" ColumnGroupName="zadrzeta" Aggregate="Sum">
                    <%--<HeaderStyle Width="60px"></HeaderStyle>--%>
                    <HeaderStyle BackColor="#E0FFFF" />
                </telerik:GridNumericColumn>
                <telerik:GridTemplateColumn FilterControlAltText="Filter Zadrzet_KP column" UniqueName="Zadrzet_KP"
                    DataField="Zadrzet_KP" DataType="System.Decimal" HeaderText="[%%%]" ColumnGroupName="zadrzetk" Aggregate="Avg" FooterAggregateFormatString="Avg: {0:F}">
                    <EditItemTemplate>
                        <telerik:RadNumericTextBox ID="RNTB_Zadrzet_KP" runat="server" DbValue='<%# Bind("Zadrzet_KP") %>'
                            MinValue="0" MaxValue="100" ShowSpinButtons="True" Width="100%" CssClass="rntb">
                            <IncrementSettings Step="5" InterceptMouseWheel="False" />
                            <ClientEvents OnKeyPress="RNTB_OnKeyPress" />
                        </telerik:RadNumericTextBox>
                    </EditItemTemplate>
                    <ItemTemplate>
                        <telerik:RadLabel ID="RL_Zadrzet_KP" runat="server" Text='<%# Eval("Zadrzet_KP") %>' CssClass="rlb">
                        </telerik:RadLabel>
                    </ItemTemplate>
                    <%--<HeaderStyle Width="95px"></HeaderStyle>--%>
                    <HeaderStyle BackColor="#E0FFFF" />
                </telerik:GridTemplateColumn>
                <telerik:GridNumericColumn DataField="Zadrzet_K" DataType="System.Decimal" DecimalDigits="2"
                    FilterControlAltText="Filter Zadrzet_K column" HeaderText="[%Zadržet%]" UniqueName="Zadrzet_K"
                    ReadOnly="True" ColumnGroupName="zadrzetk" Aggregate="Sum">
                    <%--<HeaderStyle Width="60px"></HeaderStyle>--%>
                    <HeaderStyle BackColor="#E0FFFF" />
                </telerik:GridNumericColumn>
                <telerik:GridNumericColumn DataField="Zadrzeno" DataType="System.Decimal" DecimalDigits="2"
                    FilterControlAltText="Filter Zadrzeno column" HeaderText="[%Zadrženo%]" UniqueName="Zadrzeno"
                    ReadOnly="True" ColumnGroupName="zad" Aggregate="Sum">
                    <%--<HeaderStyle Width="95px"></HeaderStyle>--%>
                    <HeaderStyle BackColor="#EFEFFF" />
                </telerik:GridNumericColumn>
                <telerik:GridTemplateColumn FilterControlAltText="Filter VyplatitZad column" UniqueName="VyplatitZad"
                    DataField="VyplatitZad" DataType="System.Decimal" HeaderText="[%Vyplatit%]" ColumnGroupName="zad" Aggregate="Sum">
                    <EditItemTemplate>
                        <telerik:RadNumericTextBox ID="RNTB_VyplatitZad" runat="server" DbValue='<%# Bind("VyplatitZad") %>'
                            MinValue="0" ShowSpinButtons="True" Width="100%" CssClass="rntb">
                            <ClientEvents OnKeyPress="RNTB_OnKeyPress" />
                            <IncrementSettings Step="100" InterceptMouseWheel="False" />
                        </telerik:RadNumericTextBox>
                    </EditItemTemplate>
                    <ItemTemplate>
                        <telerik:RadLabel ID="RadLabel1" runat="server" Text='<%# Eval("VyplatitZad") %>' CssClass="rlb">
                        </telerik:RadLabel>
                    </ItemTemplate>
                    <%--<HeaderStyle Width="95px"></HeaderStyle>--%>
                    <HeaderStyle BackColor="#EFEFFF" />
                </telerik:GridTemplateColumn>
                <telerik:GridNumericColumn DataField="Zadrzeno_V" DataType="System.Decimal" DecimalDigits="2"
                    FilterControlAltText="Filter Zadrzeno_V column" HeaderText="[%Zadrženo%]" UniqueName="Zadrzeno_V"
                    ReadOnly="True" ColumnGroupName="zadv" Aggregate="Sum">
                    <%--<HeaderStyle Width="95px"></HeaderStyle>--%>
                    <HeaderStyle BackColor="#EFEFFF" />
                </telerik:GridNumericColumn>
                <telerik:GridTemplateColumn FilterControlAltText="Filter VyplatitZad_V column" UniqueName="VyplatitZad_V"
                    DataField="VyplatitZad_V" DataType="System.Decimal" HeaderText="[%Vyplatit%]" ColumnGroupName="zadv" Aggregate="Sum">
                    <EditItemTemplate>
                        <telerik:RadNumericTextBox ID="RNTB_VyplatitZad_V" runat="server" DbValue='<%# Bind("VyplatitZad_V") %>'
                            MinValue="0" ShowSpinButtons="True" Width="100%" CssClass="rntb">
                            <ClientEvents OnKeyPress="RNTB_OnKeyPress" />
                            <IncrementSettings Step="100" InterceptMouseWheel="False" />
                        </telerik:RadNumericTextBox>
                    </EditItemTemplate>
                    <ItemTemplate>
                        <telerik:RadLabel ID="RL_VyplatitZad_V" runat="server" Text='<%# Eval("VyplatitZad_V") %>' CssClass="rlb">
                        </telerik:RadLabel>
                    </ItemTemplate>
                    <%--<HeaderStyle Width="95px"></HeaderStyle>--%>
                    <HeaderStyle BackColor="#EFEFFF" />
                </telerik:GridTemplateColumn>
                <telerik:GridNumericColumn DataField="Zadrzeno_A" DataType="System.Decimal" DecimalDigits="2"
                    FilterControlAltText="Filter Zadrzeno_A column" HeaderText="[%Zadrženo%]" UniqueName="Zadrzeno_A"
                    ReadOnly="True" ColumnGroupName="zada" Aggregate="Sum">
                    <%--<HeaderStyle Width="95px"></HeaderStyle>--%>
                    <HeaderStyle BackColor="#EFEFFF" />
                </telerik:GridNumericColumn>
                <telerik:GridTemplateColumn FilterControlAltText="Filter VyplatitZad_A column" UniqueName="VyplatitZad_A"
                    DataField="VyplatitZad_A" DataType="System.Decimal" HeaderText="[%Vyplatit%]" ColumnGroupName="zada" Aggregate="Sum">
                    <EditItemTemplate>
                        <telerik:RadNumericTextBox ID="RNTB_VyplatitZad_A" runat="server" DbValue='<%# Bind("VyplatitZad_A") %>'
                            MinValue="0" ShowSpinButtons="True" Width="100%" CssClass="rntb">
                            <ClientEvents OnKeyPress="RNTB_OnKeyPress" />
                            <IncrementSettings Step="100" InterceptMouseWheel="False" />
                        </telerik:RadNumericTextBox>
                    </EditItemTemplate>
                    <ItemTemplate>
                        <telerik:RadLabel ID="RL_VyplatitZad_A" runat="server" Text='<%# Eval("VyplatitZad_A") %>' CssClass="rlb">
                        </telerik:RadLabel>
                    </ItemTemplate>
                    <%--<HeaderStyle Width="95px"></HeaderStyle>--%>
                    <HeaderStyle BackColor="#EFEFFF" />
                </telerik:GridTemplateColumn>
                <telerik:GridNumericColumn DataField="Zadrzeno_K" DataType="System.Decimal" DecimalDigits="2"
                    FilterControlAltText="Filter Zadrzeno_K column" HeaderText="[%Zadrženo%]" UniqueName="Zadrzeno_K"
                    ReadOnly="True" ColumnGroupName="zadk" Aggregate="Sum">
                    <%--<HeaderStyle Width="95px"></HeaderStyle>--%>
                    <HeaderStyle BackColor="#EFEFFF" />
                </telerik:GridNumericColumn>
                <telerik:GridTemplateColumn FilterControlAltText="Filter VyplatitZad_K column" UniqueName="VyplatitZad_K"
                    DataField="VyplatitZad_K" DataType="System.Decimal" HeaderText="[%Vyplatit%]" ColumnGroupName="zadk" Aggregate="Sum">
                    <EditItemTemplate>
                        <telerik:RadNumericTextBox ID="RNTB_VyplatitZad_K" runat="server" DbValue='<%# Bind("VyplatitZad_K") %>'
                            MinValue="0" ShowSpinButtons="True" Width="100%" CssClass="rntb">
                            <ClientEvents OnKeyPress="RNTB_OnKeyPress" />
                            <IncrementSettings Step="100" InterceptMouseWheel="False" />
                        </telerik:RadNumericTextBox>
                    </EditItemTemplate>
                    <ItemTemplate>
                        <telerik:RadLabel ID="RL_VyplatitZad_K" runat="server" Text='<%# Eval("VyplatitZad_K") %>' CssClass="rlb">
                        </telerik:RadLabel>
                    </ItemTemplate>
                    <%--<HeaderStyle Width="95px"></HeaderStyle>--%>
                    <HeaderStyle BackColor="#EFEFFF" />
                </telerik:GridTemplateColumn>
                <telerik:GridCalculatedColumn UniqueName="Celkem" HeaderText="[%Celkem%]"
                    DataFields="Castka, Zadrzet, Zadrzet_V, Zadrzet_A, Zadrzet_K, VyplatitZad, VyplatitZad_V, VyplatitZad_A, VyplatitZad_K" Expression='{0}-{1}-{2}-{3}-{4}+{5}+{6}+{7}+{8}' DataType="System.Decimal"
                    Aggregate="Sum" HeaderStyle-BackColor="#FFEFEF">
                    <%--<HeaderStyle Width="95px" />--%>
                    <ItemStyle Font-Bold="true"/>
                </telerik:GridCalculatedColumn>
                <telerik:GridBoundColumn DataField="Popis" FilterControlAltText="Filter Popis column"
                    HeaderText="[%Popis%]" UniqueName="Popis">
                </telerik:GridBoundColumn>
            </Columns>
            <ColumnGroups>
            <telerik:GridColumnGroup HeaderText="[%Zaměstnanec%]" Name="zam"></telerik:GridColumnGroup>
            <telerik:GridColumnGroup HeaderText="[%Prémie%]" Name="prem" HeaderStyle-BackColor="#F0FCF0"></telerik:GridColumnGroup>
            <telerik:GridColumnGroup HeaderText="[%Prémie%]" Name="premcelkem" HeaderStyle-BackColor="#F0FCF0"></telerik:GridColumnGroup>
            <telerik:GridColumnGroup HeaderText="[%Zádržné%]" Name="zad" HeaderStyle-BackColor="#EFEFFF"></telerik:GridColumnGroup>
            <telerik:GridColumnGroup HeaderText="[%V%]" Name="zadv" ParentGroupName="zad" HeaderStyle-BackColor="#EFEFFF"></telerik:GridColumnGroup>
            <telerik:GridColumnGroup HeaderText="[%A%]" Name="zada" ParentGroupName="zad" HeaderStyle-BackColor="#EFEFFF"></telerik:GridColumnGroup>
            <telerik:GridColumnGroup HeaderText="[%K%]" Name="zadk" ParentGroupName="zad" HeaderStyle-BackColor="#EFEFFF"></telerik:GridColumnGroup>
            <telerik:GridColumnGroup HeaderText="[%Zadržet%]" Name="zadrzet" HeaderStyle-BackColor="#E0FFFF"></telerik:GridColumnGroup>
            <telerik:GridColumnGroup HeaderText="[%V%]" Name="zadrzetv" ParentGroupName="zadrzet" HeaderStyle-BackColor="#E0FFFF"></telerik:GridColumnGroup>
            <telerik:GridColumnGroup HeaderText="[%A%]" Name="zadrzeta" ParentGroupName="zadrzet" HeaderStyle-BackColor="#E0FFFF"></telerik:GridColumnGroup>
            <telerik:GridColumnGroup HeaderText="[%K%]" Name="zadrzetk" ParentGroupName="zadrzet" HeaderStyle-BackColor="#E0FFFF"></telerik:GridColumnGroup>
            </ColumnGroups>
            
        </MasterTableView>
    </kspwc:TRadGrid>
</asp:Panel>
