﻿<%@ Control Language="C#" AutoEventWireup="true" CodeBehind="ZadostOpujcvuz.ascx.cs" Inherits="KSPortal.Controls.ZadostOpujcvuz" %>
<%@ Register assembly="WebControls" namespace="KSProgram.WebControls" tagprefix="kspwc" %>
<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>

<telerik:RadScriptBlock ID="pujcvuz_rsb" runat="server">
    <script type="text/javascript" id="pujcvuz_js">
        function dateSelected(sender, args) {
            var timeView = sender.get_timeView();
            var isTimeSet = false;
            if (timeView.getTime().getHours() != 0)
                isTimeSet = true;
            if (args.get_newDate() && !isTimeSet) {
                args.set_cancel(true);
                if (sender.get_id().toLowerCase().endsWith("do"))
                    timeView.setTime(23, 59, 59, 0);
                else
                    timeView.setTime(8, 0, 0, 0);
            }
        }
    </script>
</telerik:RadScriptBlock>

<asp:ObjectDataSource ID="ObjectDataSource1" runat="server" OldValuesParameterFormatString="original_{0}"
    SelectMethod="Retrieve" TypeName="KSProgram.Pozadavky.Pozadavekpujcvuz" InsertMethod="Insert"
    UpdateMethod="Update" OnInserted="ObjectDataSource1_Inserted" >
    <InsertParameters>
        <asp:Parameter DefaultValue="0" Name="id_poz" Type="Int32" Direction="InputOutput" />
        
        <asp:Parameter Name="adresat" Type="Decimal" />
        <asp:Parameter Name="novy_stav" Type="String" />
        <asp:Parameter Name="duvod" Type="String" />
    </InsertParameters>
    <UpdateParameters>
        <asp:Parameter Name="id_poz" Type="Int32"/>
    </UpdateParameters>
    <SelectParameters>
        <asp:Parameter Name="id_pozadavku" Type="Int32" DefaultValue="0" />
    </SelectParameters>    
</asp:ObjectDataSource>

<asp:FormView ID="FormView1" runat="server" CssClass="noclass" OnItemInserted="FormView1_ItemInserted"
    OnItemUpdated="FormView1_ItemUpdated" OnDataBound="FormView1_DataBound" DataSourceID="ObjectDataSource1">
    <EditItemTemplate>
        <asp:Table runat="server" SkinID="RamAPozadi">
            <asp:TableHeaderRow runat="server" >
                <asp:TableCell runat="server" ColumnSpan="4"  SkinID="TitleRowStyle">
                    <asp:Label ID="Label1" runat="server" Text="[%Zapůjčení služebního vozidla%]"></asp:Label>
                </asp:TableCell>
            </asp:TableHeaderRow>
            
            <asp:TableRow runat="server">                    
                <asp:TableCell runat="server" HorizontalAlign="Right" SkinID="DataFieldHeaderStyle"> 
                    <asp:Label ID="Label2" runat="server" Text="[%Žadatel%]:"></asp:Label> 
                </asp:TableCell>
                <asp:TableCell runat="server" ColumnSpan="3" SkinID="DataFieldStyle"> 
                    <asp:Label ID="LabelZadatel" runat="server" Text='<%#  KSProgram.Funkce.Pracovnik.OsCisloPrijmeniJmeno(KSProgram.Pozadavky.PozadavekZpracovaniAbstract.VydavatelProNovyPoz()) %>'></asp:Label> 
                </asp:TableCell>
            </asp:TableRow>

            <asp:TableRow runat="server">
                <asp:TableCell runat="server" HorizontalAlign="Right" SkinID="DataFieldHeaderStyle"> 
                    <asp:Label ID="datum_od_L" runat="server" Text="[%Datum a čas počátku%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell runat="server" SkinID="DataFieldStyle"> 
                    <telerik:RadDateTimePicker runat="server" ID="datum_od" DbSelectedDate='<%# Bind("datum_od") %>' SkinID="povinne-pole" Width="14em" 
                        DateInput-DateFormat="dd.MM.yyyy HH:mm" DateInput-DisplayDateFormat="dd.MM.yyyy HH:mm" AutoPostBackControl="None">
                        <ClientEvents OnDateSelected="dateSelected" />
                    </telerik:RadDateTimePicker>
                </asp:TableCell>
                <asp:TableCell runat="server" HorizontalAlign="Right" SkinID="DataFieldHeaderStyle"> 
                    <asp:Label ID="odkud_L" runat="server" Text="[%Odkud%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell runat="server" SkinID="DataFieldStyle">
                    <kspwc:TTextBox ID="odkud"	runat="server" Text='<%# Bind("odkud") %>' MaxLength="400"  Width="30em" CssClass="input povinne-pole" ToolTip="[%Místo přistavení%]"></kspwc:TTextBox>
                </asp:TableCell>
            </asp:TableRow>

            <asp:TableRow runat="server">
                <asp:TableCell runat="server" HorizontalAlign="Right" SkinID="DataFieldHeaderStyle">
                    <asp:Label ID="datum_do_L" runat="server" Text="[%Datum a čas ukončení jízdy%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell runat="server" SkinID="DataFieldStyle"> 
                    <telerik:RadDateTimePicker runat="server" ID="datum_do" DbSelectedDate='<%# Bind("datum_do") %>' SkinID="povinne-pole" Width="14em" 
                        DateInput-DateFormat="dd.MM.yyyy HH:mm" DateInput-DisplayDateFormat="dd.MM.yyyy HH:mm" AutoPostBackControl="Both" OnSelectedDateChanged="datum_do_SelectedDateChanged">
                        <ClientEvents OnDateSelected="dateSelected" />
                    </telerik:RadDateTimePicker>
                </asp:TableCell>
                <asp:TableCell runat="server" HorizontalAlign="Right" SkinID="DataFieldHeaderStyle"> 
                    <asp:Label ID="kam_L" runat="server" Text="[%Kam%]:"></asp:Label> 
                </asp:TableCell>
                <asp:TableCell runat="server" SkinID="DataFieldStyle"> 
                    <kspwc:TTextBox ID="kam" runat="server" Text='<%# Bind("kam") %>' MaxLength="400" Width="30em" CssClass="input povinne-pole"></kspwc:TTextBox> 
                </asp:TableCell>
            </asp:TableRow>

            <asp:TableRow runat="server">                    
                <asp:TableCell runat="server" HorizontalAlign="Right" SkinID="DataFieldHeaderStyle"> 
                    <asp:Label ID="osob_L" runat="server" Text="[%Počet osob%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell runat="server" ColumnSpan="3" SkinID="DataFieldStyle"> 
                    <kspwc:TTextBox ID="osob" runat="server" Text='<%# Bind("osob") %>' MaxLength="2" Width="5em" CssClass="input" ></kspwc:TTextBox> 
                </asp:TableCell>
            </asp:TableRow>

            <asp:TableRow runat="server"  >
                <asp:TableCell runat="server" HorizontalAlign="Right" SkinID="DataFieldHeaderStyle"> 
                    <asp:Label ID="spz_L" runat="server" Text="[%Vozidlo%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell runat="server" ColumnSpan="3" SkinID="DataFieldStyle">

                    <asp:ObjectDataSource ID="ODS_SluzVozy" runat="server" 
                        OldValuesParameterFormatString="original_{0}" SelectMethod="Select" 
                        TypeName="KSProgram.Sluzebky.SlcVozidla" EnableCaching="True" CacheExpirationPolicy="Sliding" CacheDuration="60" >
                        <SelectParameters>
                            <asp:Parameter Name="os_cisla" Type="String" DefaultValue="0" /> 
                            <asp:Parameter Name="ev_cislo" Type="Int32" DefaultValue="0" /> 
                            <asp:Parameter Name="druhy" Type="String" DefaultValue="AUS" />  
                            <asp:Parameter Name="jen_dostupna" Type="Boolean" DefaultValue="true" /> 
            
                            <asp:ControlParameter Name="dat_od" Type="DateTime" ControlID="datum_od" PropertyName="SelectedDate" />
                            <asp:Parameter Name="cas_od" Type="String" DefaultValue="-" />
                            <asp:ControlParameter Name="dat_do" Type="DateTime" ControlID="datum_do" PropertyName="SelectedDate" />
                            <asp:Parameter Name="cas_do" Type="String" DefaultValue="-" />
                        </SelectParameters>
                    </asp:ObjectDataSource>

                    <%----%>
                    <kspwc:TRadComboBox ID="spz" runat="server" Width="300px" 
                        DataSourceID="ODS_SluzVozy" DataValueField="spz" DataTextField="cely_nazev" Text='<%# DataBinder.Eval(Container.DataItem, "spz") %>' 
                        DropDownWidth="300px" MaxHeight="250px" MarkFirstMatch="True">
                    </kspwc:TRadComboBox>
                     <%--<telerik:RadDropDownList ID="spz" runat="server" AutoPostBack="False"  SkinID="povinne-pole"
                        DataSourceID="ODS_SluzVozy" DataTextField="cely_nazev" DataValueField="spz" 
                            Width="24em" SelectedValue='<%# DataBinder.Eval(Container.DataItem, "spz") %>' >
                    </telerik:RadDropDownList>--%>
                </asp:TableCell>
            </asp:TableRow>

            <asp:TableRow runat="server">                    
                <asp:TableCell runat="server" HorizontalAlign="Right" SkinID="DataFieldHeaderStyle"> 
                    <asp:Label ID="pzn_L" runat="server" Text="[%Poznámka%]:"></asp:Label> 
                </asp:TableCell>
                <asp:TableCell runat="server" ColumnSpan="3" SkinID="DataFieldStyle"> 
                    <kspwc:TTextBox ID="pzn"	runat="server" Text='<%# Bind("pzn") %>' MaxLength="400" Width="35em" CssClass="input"></kspwc:TTextBox> 
                </asp:TableCell>               
            </asp:TableRow>
            
            <asp:TableRow runat="server">
                <asp:TableCell runat="server" HorizontalAlign="Right" SkinID="DataFieldHeaderStyle"> <asp:Label ID="vyridit_do_L" runat="server" Text="[%Vyřídit do%]:"></asp:Label> </asp:TableCell>
                <asp:TableCell runat="server" ColumnSpan="3" SkinID="DataFieldStyle"> <kspwc:TRadDatePicker runat="server" ID="vyridit_do" DbSelectedDate='<%# Bind("vyridit_do") %>' Width="15em"/> </asp:TableCell>
            </asp:TableRow>
        </asp:Table>
    </EditItemTemplate>
    <ItemTemplate>
        <asp:Table runat="server" SkinID="RamAPozadi">
            <asp:TableHeaderRow runat="server" >
                <asp:TableCell runat="server" ColumnSpan="4"  SkinID="TitleRowStyle">
                    <asp:Label ID="Label1" runat="server" Text="[%Zapůjčení vozidla%]"></asp:Label>
                </asp:TableCell>
            </asp:TableHeaderRow>
            <asp:TableRow runat="server">                    
                <asp:TableCell runat="server" HorizontalAlign="Right" SkinID="DataFieldHeaderStyle"> 
                    <asp:Label ID="Label2" runat="server" Text="[%Žadatel%]:"></asp:Label> 
                </asp:TableCell>
                <asp:TableCell runat="server" ColumnSpan="3" SkinID="DataFieldStyle"> 
                    <asp:Label ID="LabelZadatel" runat="server" Text='<%#  KSProgram.Funkce.Pracovnik.OsCisloPrijmeniJmeno((decimal)Eval("os_cislo")) %>'></asp:Label> 
                </asp:TableCell>
            </asp:TableRow>

            <asp:TableRow runat="server">
                <asp:TableCell runat="server" HorizontalAlign="Right" SkinID="DataFieldHeaderStyle"> 
                    <asp:Label ID="datum_od_L" runat="server" Text="[%Datum a čas počátku%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell runat="server" SkinID="DataFieldStyle"> 
                    <%# Eval("datum_od") %> 
                </asp:TableCell>
                <asp:TableCell runat="server" HorizontalAlign="Right" SkinID="DataFieldHeaderStyle"> 
                    <asp:Label ID="odkud_L" runat="server" Text="[%Odkud%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell runat="server" SkinID="DataFieldStyle"> 
                    <%# Eval("odkud") %> 
                </asp:TableCell>
            </asp:TableRow>

            <asp:TableRow runat="server">
                <asp:TableCell runat="server" HorizontalAlign="Right" SkinID="DataFieldHeaderStyle">
                    <asp:Label ID="datum_do_L" runat="server" Text="[%Datum a čas ukončení%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell runat="server" SkinID="DataFieldStyle"> 
                    <%# Eval("datum_do") %>
                </asp:TableCell>
                <asp:TableCell runat="server" HorizontalAlign="Right" SkinID="DataFieldHeaderStyle"> 
                    <asp:Label ID="kam_L" runat="server" Text="[%Kam%]:"></asp:Label> 
                </asp:TableCell>
                <asp:TableCell runat="server" SkinID="DataFieldStyle"> 
                    <%# Eval("kam") %>
                </asp:TableCell>
            </asp:TableRow>
            
           <asp:TableRow runat="server">                    
                <asp:TableCell runat="server" HorizontalAlign="Right" SkinID="DataFieldHeaderStyle"> 
                    <asp:Label ID="osob_L" runat="server" Text="[%Počet osob%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell runat="server" ColumnSpan="3" SkinID="DataFieldStyle"> 
                    <%# Eval("osob") %>
                </asp:TableCell>
            </asp:TableRow>

            <asp:TableRow runat="server">                    
                <asp:TableCell runat="server" HorizontalAlign="Right" SkinID="DataFieldHeaderStyle"> 
                    <asp:Label ID="pzn_L" runat="server" Text="[%Poznámka%]:"></asp:Label> 
                </asp:TableCell>
                <asp:TableCell runat="server" ColumnSpan="3" SkinID="DataFieldStyle"> 
                    <%# Eval("pzn") %>
                </asp:TableCell>               
            </asp:TableRow>

            <asp:TableRow runat="server">
                <asp:TableCell runat="server" HorizontalAlign="Right" SkinID="DataFieldHeaderStyle"> 
                    <asp:Label ID="spz_L" runat="server" Text="[%Vozidlo%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell runat="server" ColumnSpan="3" SkinID="DataFieldStyle">                    
                    <%# Eval("spz") %>
                </asp:TableCell>
            </asp:TableRow>
            <asp:TableRow runat="server">
                <asp:TableCell runat="server" HorizontalAlign="Right" SkinID="DataFieldHeaderStyle"> <asp:Label ID="vyridit_do_L" runat="server" Text="[%Vyřídit do%]:"></asp:Label> </asp:TableCell>
                <asp:TableCell runat="server" ColumnSpan="3" SkinID="DataFieldStyle"> <%# Eval("vyridit_do") %> </asp:TableCell>
            </asp:TableRow>
        </asp:Table>
    </ItemTemplate>
</asp:FormView>
<span class="tiskHide">
    <asp:CustomValidator runat="server" ID="Validator" OnServerValidate="Validator_ServerValidate" ></asp:CustomValidator>
</span>