﻿<%@ Control Language="C#" AutoEventWireup="true" CodeBehind="ZadostOzmuctu.ascx.cs" Inherits="KSPortal.Controls.ZadostOzmuctu" %>
<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>
<script src="../Scripts/iban.js" type="text/javascript"></script>
<script src="../Scripts/KSValidator.js" type="text/javascript"></script>

<telerik:RadFormDecorator ID="RadFormDecorator1" runat="server" DecoratedControls="CheckBoxes,RadioButtons,Select,Textarea,Textbox" DecorationZoneID="FormView1" />
<telerik:RadAjaxManagerProxy ID="RadAjaxManagerProxy2" runat="server">
    <AjaxSettings>
        <telerik:AjaxSetting AjaxControlID="inner_panel">
            <UpdatedControls>
                <telerik:AjaxUpdatedControl ControlID="inner_panel" UpdatePanelCssClass="" />
            </UpdatedControls>
        </telerik:AjaxSetting>
    </AjaxSettings>
</telerik:RadAjaxManagerProxy>
<style type="text/css">
    table.InnerTableForm > tbody > tr > td {
        padding: 5px;
        vertical-align: top;
    }

    table.InnerTableFormFieldset > tbody > tr > td, span.InnerTableFormFieldset {
        padding: 3px;
    }

    table.InnerTableFormFieldset > tbody > tr > td {
        white-space: nowrap;
    }

    .povinne-pole {
        color: black !important;
    }

    .tdValidators {
        font-size: large;
        padding: 0px;
        margin: 0px;
        color: red;
    }

    .formsumary {
        padding-top: 5px;
        padding-bottom: 5px;
        display: -webkit-box;
    }

        .formsumary > div > ul {
            float: left !important;
        }

    .zmuctuPanel {
        width: fit-content;
    }
</style>
<telerik:RadScriptBlock ID="RadScriptBlock1" runat="server">
    <script type="text/javascript" id="telerikClientEvents2">
        // přepsání funkce v KSMaster, která je volána z PozadavekDetail.aspx
        var oldPozadavekSaveClicking = !oldPozadavekSaveClicking ? KSMaster.onPozadavekSaveClicking : oldPozadavekSaveClicking;
        KSMaster.onPozadavekSaveClicking = function (sender, args) {
            oldPozadavekSaveClicking.apply(sender, args);

            var isValid = Page_ClientValidate();

            if (!isValid) {
                var RW_Errors = $find('<%= RW_Errors.ClientID %>');
                RW_Errors.show();
                RW_Errors.autoSize();
            }
        };
        KSMaster.onPozadavekSaveClicking.prototype = oldPozadavekSaveClicking.prototype;

        function RW_Errors_close(sender, args) {
            var RW_Errors = $find('<%= RW_Errors.ClientID %>');
            RW_Errors.close();
        }

        function cislo_uctu_validate(source, arguments) {
            arguments.IsValid = KSValidator.validateCisloUctu(arguments.Value);
        }

        function iban_validate(source, arguments) {
            arguments.IsValid = KSValidator.validateIban(arguments.Value);
        }
        function required_validate(sender, args) {
            var RTB_edit_cislo_uctu = $find('<%= RTB_edit_cislo_uctu.ClientID %>');
            var TRCB_edit_kod_banky = $find('<%= TRCB_edit_kod_banky.ClientID %>');
            var RTB_edit_iban = $find('<%= RTB_edit_iban.ClientID %>');
            var TRCB_edit_swift = $find('<%= TRCB_edit_swift.ClientID %>');

            if ((RTB_edit_cislo_uctu.get_value() && TRCB_edit_kod_banky.get_value()) ||
                (RTB_edit_iban.get_value() && TRCB_edit_swift.get_value())) {
                args.IsValid = true;
            }
            else {
                args.IsValid = false;
            }
        }

        function required_vychozi(sender, args) {
            var RTB_cislo_uctu_ro = $find('<%= RTB_cislo_uctu_ro.ClientID %>');
            var RTB_kod_banky_ro = $find('<%= RTB_kod_banky_ro.ClientID %>');
            var RTB_iban_ro = $find('<%= RTB_iban_ro.ClientID %>');
            var RTB_swift_ro = $find('<%= RTB_swift_ro.ClientID %>');

            if ((RTB_cislo_uctu_ro.get_value() && RTB_kod_banky_ro.get_value()) ||
                (RTB_iban_ro.get_value() && RTB_swift_ro.get_value())) {
                args.IsValid = true;
            }
            else {
                args.IsValid = false;
            }
        }
    </script>
</telerik:RadScriptBlock>
<asp:ObjectDataSource ID="ODS_kod_banky" runat="server" OldValuesParameterFormatString="original_{0}"
    SelectMethod="Seznam" TypeName="KSProgram.Ciselniky.CisOsoby">
    <SelectParameters>
        <asp:Parameter DefaultValue="ba" Name="typOsoby" Type="String" />
        <asp:Parameter DefaultValue="nazev,c_pole1" Name="pole" Type="String" />
        <asp:Parameter DefaultValue="{c_pole1} - {nazev}" Name="cely_nazev_format_string" Type="String" />
        <asp:Parameter DefaultValue="c_pole1" Name="order_by" Type="String" />
        <asp:Parameter DefaultValue="c_pole1 IS NOT NULL" Name="where" Type="String" />
    </SelectParameters>
</asp:ObjectDataSource>
<asp:ObjectDataSource ID="ODS_swift" runat="server" OldValuesParameterFormatString="original_{0}"
    SelectMethod="Seznam" TypeName="KSProgram.Ciselniky.CisOsoby">
    <SelectParameters>
        <asp:Parameter DefaultValue="ba" Name="typOsoby" Type="String" />
        <asp:Parameter DefaultValue="nazev,c_pole2" Name="pole" Type="String" />
        <asp:Parameter DefaultValue="{c_pole2} - {nazev}" Name="cely_nazev_format_string" Type="String" />
        <asp:Parameter DefaultValue="c_pole2" Name="order_by" Type="String" />
        <asp:Parameter DefaultValue="c_pole2 IS NOT NULL" Name="where" Type="String" />
    </SelectParameters>
</asp:ObjectDataSource>
<asp:Panel runat="server" ID="inner_panel" CssClass="zmuctuPanel">
    <fieldset id="Fieldset1" runat="server" class="ksprvek">
        <legend>[%Aktuální účet%]</legend>
        <table class="InnerTableFormFieldset" runat="server" id="table1">
            <tr>
                <td>[%Číslo účtu%]
                </td>
                <td>
                    <telerik:RadTextBox ID="RTB_cislo_uctu_ro" runat="server" EmptyMessage="[%Číslo účtu%]"
                        Width="200px" LabelWidth="120px" Resize="None"
                        ReadOnly="true">
                    </telerik:RadTextBox>
                    <telerik:RadTextBox ID="RTB_kod_banky_ro" runat="server" EmptyMessage="[%Kód banky%]"
                        Width="100px" LabelWidth="120px" Resize="None"
                        ReadOnly="true">
                    </telerik:RadTextBox>
                </td>
                <td class="tdValidators">
                    <asp:CustomValidator ID="CustomValidator1" runat="server" Display="Dynamic" ErrorMessage="[%Nebyl nalezen výchozí účet, o jehož změnu by bylo možné zažádat. V aplikaci KS mzdy označte výchozí účet zaměstnance nebo spusťte jednorázovou funkci%]" Text="*" ControlToValidate="RTB_edit_cislo_uctu" ClientValidationFunction="required_vychozi" ValidateEmptyText="true"></asp:CustomValidator>
                </td>
            </tr>
            <tr>
                <td>[%IBAN%]
                </td>
                <td>
                    <telerik:RadTextBox ID="RTB_iban_ro" runat="server" EmptyMessage="[%IBAN%]"
                        Width="150px" LabelWidth="120px" Resize="None" ReadOnly="true">
                    </telerik:RadTextBox>
                    <telerik:RadTextBox ID="RTB_swift_ro" runat="server" EmptyMessage="[%SWIFT%]"
                        Width="150px" LabelWidth="120px" Resize="None" ReadOnly="true">
                    </telerik:RadTextBox>
                </td>
                <td class="tdValidators"></td>
            </tr>
            <tr>
                <td>[%Variabilní symbol%]
                </td>
                <td>
                    <telerik:RadTextBox ID="RTB_var_symbol_ro" runat="server" EmptyMessage="[%Variabilní symbol%]"
                        Width="150px" LabelWidth="120px" Resize="None"
                        ReadOnly="true">
                    </telerik:RadTextBox>
                </td>
                <td></td>
            </tr>
            <tr>
                <td>[%Specifický symbol%]
                </td>
                <td>
                    <telerik:RadTextBox ID="RTB_spec_symbol_ro" runat="server" EmptyMessage="[%Specifický symbol%]"
                        Width="150px" LabelWidth="120px" Resize="None"
                        ReadOnl="true">
                    </telerik:RadTextBox>
                </td>
                <td></td>
            </tr>
        </table>
    </fieldset>
    <fieldset id="FS_insert_kontakt" runat="server" class="ksprvek" style="margin-top: 25px">
        <legend>[%Nový účet%]</legend>
        <table class="InnerTableFormFieldset" runat="server" id="table_insert_kontakt">
            <tr>
                <td>[%Číslo účtu%]
                </td>
                <td>
                    <telerik:RadTextBox ID="RTB_edit_cislo_uctu" runat="server" EmptyMessage="[%Číslo účtu%]"
                        Width="200px" LabelWidth="120px" Resize="None" CssClass="povinne-pole"
                        MaxLength="17">
                    </telerik:RadTextBox>
                    <kspwc:TRadComboBox ID="TRCB_edit_kod_banky" runat="server" DataSourceID="ODS_kod_banky"
                        DataTextField="cely_nazev" DataValueField="c_pole1" DropDownAutoWidth="Enabled"
                        EmptyMessage="[%Kód banky%]" Height="150px" CssClass="povinne-pole"
                        Width="100px">
                    </kspwc:TRadComboBox>
                </td>
                <td class="tdValidators">
                    <asp:CustomValidator ID="CV_edit_cislo_uctu" runat="server" ClientValidationFunction="cislo_uctu_validate"
                        Display="Dynamic" ErrorMessage="[%Číslo účtu není platné%]" Text="*" ControlToValidate="RTB_edit_cislo_uctu"></asp:CustomValidator>
                    <asp:CustomValidator ID="CV_reqired_cislo_uctu" runat="server" Display="Dynamic" ErrorMessage="[%Číslo účtu a kód banky nebo IBAN a SWIFT jsou povinné údaje%]" Text="*" ControlToValidate="RTB_edit_cislo_uctu" ClientValidationFunction="required_validate" ValidateEmptyText="true"></asp:CustomValidator>
                </td>
            </tr>
            <tr>
                <td>[%IBAN%]
                </td>
                <td>
                    <telerik:RadTextBox ID="RTB_edit_iban" runat="server" EmptyMessage="[%IBAN%]"
                        Width="150px" LabelWidth="120px" Resize="None" CssClass="povinne-pole"
                        MaxLength="50">
                    </telerik:RadTextBox>
                    <kspwc:TRadComboBox ID="TRCB_edit_swift" runat="server" DataSourceID="ODS_swift"
                        DataTextField="cely_nazev" DataValueField="c_pole2" DropDownAutoWidth="Enabled"
                        EmptyMessage="[%SWIFT%]" Height="150px" CssClass="povinne-pole"
                        Width="150px">
                    </kspwc:TRadComboBox>
                </td>
                <td class="tdValidators">
                    <asp:CustomValidator ID="CV_edit_iban" runat="server" ClientValidationFunction="iban_validate"
                        Display="Dynamic" ErrorMessage="[%IBAN není platný%]" Text="*" ControlToValidate="RTB_edit_iban"></asp:CustomValidator>
                </td>
            </tr>
            <tr id="tr_var_symbol">
                <td>[%Variabilní symbol%]
                </td>
                <td>
                    <%--<telerik:RadNumericTextBox ID="RTB_var_symbol" runat="server" EmptyMessage="[%Variabilní symbol%]"
                        Width="150px" LabelWidth="120px" Resize="None"
                        MaxLength="10">
                        <NumberFormat DecimalDigits="0" GroupSizes="9" />
                    </telerik:RadNumericTextBox>--%>
                    <telerik:RadTextBox ID="RTB_var_symbol" runat="server" EmptyMessage="[%Variabilní symbol%]"
                        Width="150px" LabelWidth="120px" Resize="None"
                        MaxLength="10">
                    </telerik:RadTextBox>
                </td>
                <td>
                    <asp:RequiredFieldValidator ID="RFV_var_symbol" runat="server" ControlToValidate="RTB_var_symbol" Enabled="false"
                        Display="Static" Text="*" ErrorMessage="[%Variabilní symbol je povinný údaj%]">
                    </asp:RequiredFieldValidator>
                </td>
            </tr>
            <tr id="tr_spec_symbol">
                <td>[%Specifický symbol%]
                </td>
                <td>
                    <%--<telerik:RadNumericTextBox ID="RTB_spec_symbol" runat="server" EmptyMessage="[%Specifický symbol%]"
                        Width="150px" LabelWidth="120px" Resize="None"
                        MaxLength="10">
                        <NumberFormat DecimalDigits="0" GroupSizes="9" />
                    </telerik:RadNumericTextBox>--%>
                    <telerik:RadTextBox ID="RTB_spec_symbol" runat="server" EmptyMessage="[%Specifický symbol%]"
                        Width="150px" LabelWidth="120px" Resize="None"
                        MaxLength="10">
                    </telerik:RadTextBox>
                </td>
                <td>
                    <asp:RequiredFieldValidator ID="RFV_spec_symbol" runat="server" ControlToValidate="RTB_spec_symbol" Enabled="false"
                        Display="Static" Text="*" ErrorMessage="[%Specifický symbol je povinný údaj%]">
                    </asp:RequiredFieldValidator>
                </td>
            </tr>
            <tr>
                <td>[%Změna platí od mzdového období%]
                </td>
                <td>
                    <kspwc:TRadMonthYearPicker runat="server" ID="TRMYP_plati_od" Width="160">
                        <DateInput DateFormat="MMMM yyyy" DisplayDateFormat="MMMM yyyy" EmptyMessage="[%Platí od%]"></DateInput>
                    </kspwc:TRadMonthYearPicker>
                </td>
                <td></td>
            </tr>
            <tr>
                <td>[%Požadované datum vyřízení%]
                </td>
                <td>
                    <kspwc:TRadDatePicker ID="TRDP_edit_vyriz_datum" runat="server" DropDownAutoWidth="Enabled"
                        Width="160px" DbSelectedDate='<%# Bind("vyridit_do") %>'>
                        <DateInput DateFormat="d.M.yyyy" DisplayDateFormat="d.M.yyyy" EmptyMessage="[%Vyřídit do%]" CssClass="povinne-pole">
                        </DateInput>
                    </kspwc:TRadDatePicker>
                </td>
                <td class="tdValidators">
                    <asp:RequiredFieldValidator ID="RFV_edit_vyriz_datum" runat="server" ControlToValidate="TRDP_edit_vyriz_datum"
                        Display="Static" Text="*" ErrorMessage="[%Požadované datum vyřízení je povinný údaj%]"></asp:RequiredFieldValidator></td>
            </tr>
        </table>
    </fieldset>
    <telerik:RadWindow runat="server" Title="[%Chyby ve formuláři%]" ID="RW_Errors" AutoSizeBehaviors="Height, Width" MaxHeight="600px" Behaviors="Close, Move, Pin" InitialBehaviors="Close, Move" KeepInScreenBounds="True" Modal="False" VisibleStatusbar="False">
        <ContentTemplate>
            <telerik:RadFormDecorator ID="RFD_decor" runat="server" DecoratedControls="All"
                DecorationZoneID="formsumary" EnableRoundedCorners="False" />
            <div id="formsumary" class="formsumary">
                <asp:ValidationSummary ID="ValidationSummary1" Width="380px" runat="server" />
            </div>
            <kspwc:TRadButton ID="TRB_vs_close" runat="server" AutoPostBack="false" OnClientClicked="RW_Errors_close" Text="[%Zavřít%]">
                <Icon PrimaryIconCssClass="fi fi-ban"></Icon>
            </kspwc:TRadButton>
        </ContentTemplate>
    </telerik:RadWindow>
</asp:Panel>
