﻿<%@ Control Language="C#" AutoEventWireup="true" CodeBehind="DashBoardPanel_NovyPozadavek.ascx.cs" Inherits="KSPortal.DashBoard.DashBoardPanel_NovyPozadavek" %>

<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>



<style type="text/css">
    #ctl00_HlavniOblast_DB_NovyPozadavek_C > div {
        display: flex;
        flex-direction: row;
        flex-wrap: wrap;
        justify-content: center;
    }

    #ctl00_HlavniOblast_DB_NovyPozadavek_C fieldset {
        border: none;
        width: 29%;
        margin: 0;
    }

    .novy {
        text-decoration: none;
        width: 100%;
        display: flex;
        flex-direction: column;
        transition: 0.4s;
        margin: auto;
        padding: 10px 2px;
        text-align: center;
        border: 1px var(--kscolor2) solid;
        border-radius: 10px;
        color: var(--kscolor2text);
    }

        .novy:hover {
            /*background: #e6e5e5;*/
            border: 1px solid var(--kscolor1);
            box-shadow: rgba(0, 0, 0, 0.15) 0px 15px 15px;
        }

        .novy i {
            margin: auto;
        }

        .novy label {
            cursor: pointer !important;
            font-size: 16px;
            margin: auto;
        }


    p .novy {
        display: none;
    }
</style>

<telerik:RadScriptBlock ID="RSB_links" runat="server">
    <script type="text/javascript">

        function _emptyNovePoz() {
            return '<%=KSProgram.Obecne.ReadGlobalResource.ZmenaTextu("[%Nemůžete založit žádný požadavek%]")%>';
        }

        function ParseNovePoz(sender, args) {
            var response = args.get_response().d;
            if (response) {
                args.set_parsedData(response.Data);
            }
        }

    </script>
</telerik:RadScriptBlock>

<telerik:RadListView runat="server" ID="RLV_novePoz" AllowPaging="false" ItemPlaceholderID="ItemsPlaceHolder" ClientDataSourceID="ODS_NovePoz">
    <LayoutTemplate>
        <div id="ItemsPlaceHolder" runat="server">
        </div>
    </LayoutTemplate>
    <ClientSettings>
        <DataBinding>
            <ItemTemplate>
                <fieldset>
                    <div>
                        <p><a href="#= url #" class="novy"><div><i class="#= ikona #"></i><label>#= nazev #</label></div></a></p>
                    </div>
                </fieldset>
            </ItemTemplate>
            <EmptyDataTemplate>
            <fieldset class="ksDbLiFs" style="border: none;">
                <div>
                    <p class="zadneBull">
                        <i class="fi fi-umbrella-beach"></i>
                        <label>#=_emptyNovePoz()#</label>
                    </p>
                </div>
            </fieldset>
            </EmptyDataTemplate>
        </DataBinding>
    </ClientSettings>
</telerik:RadListView>

<telerik:RadClientDataSource ID="ODS_NovePoz" runat="server" AllowBatchOperations="false">
    <ClientEvents OnDataParse="ParseNovePoz" />
    <DataSource>
        <WebServiceDataSourceSettings>
            <Select Url="DashBoard/WebMethods.aspx/GetNovePoz" DataType="JSON" RequestType="Post" ContentType="application/json; charset=utf-8" />
        </WebServiceDataSourceSettings>
    </DataSource>
    <Schema>
        <Model>
            <telerik:ClientDataSourceModelField FieldName="nazev" DataType="String" Editable="False" />
            <telerik:ClientDataSourceModelField FieldName="url" DataType="String" Editable="False" />
            <telerik:ClientDataSourceModelField FieldName="ikona" DataType="String" Editable="False" />
        </Model>
    </Schema>
</telerik:RadClientDataSource>

