﻿<%@ Control Language="C#" AutoEventWireup="true" CodeBehind="DashBoardPanel_SchvaleneNepritomnosti.ascx.cs" Inherits="KSPortal.DashBoard.DashBoardPanel_SchvaleneNepritomnosti" %>

<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>

<style type="text/css">
    div.ksDbpNepRg .rgCaption{
        display: none;
    }

    div.ksDbpNepRg th.rgHeader{
        font-weight: 300;
    }

    div.ksDbpNepRg th.rgHeader.ksSobota,
    div.ksDbpNepRg th.rgHeader.ksNedele{
        font-weight: 800 !important;
    } 
</style>
<telerik:RadScriptBlock ID="RSB2_nepr" runat="server">
    <script type="text/javascript">
        //<![CDATA[

        function RD_SchvaleneNepritomnosti_ClientDockPositionChanged(sender, args) {

        }

        function ParseSNep(sender, args) {
            var response = args.get_response().d;
            if (response) {
                args.set_parsedData(response.Data);
            }
        }
        function TRG_neprit_ColumnCreated(sender, args) {
            var column = args.get_column();
            var name = column.get_uniqueName();
            if (name >= 1 && name <= 10) {
                var date = new Date((new Date()).valueOf() + (1000 * 3600 * 24 * (name - 1)));
                column.get_element().innerHTML = date.getDate() + "." + kendo.toString(date, 'ddd');
                if (date.getDay() == 0) {
                    column.get_element().classList.add("ksNedele");
                }
                else if (date.getDay() == 6) {
                    column.get_element().classList.add("ksSobota");
                }
            }
        }

        function TRG_neprit_RowDataBound(sender, args) {
            for (var i = 1; i <= 10; i++) {
                var date = new Date((new Date()).valueOf() + (1000 * 3600 * 24 * (i - 1)));
                if (date.getDay() == 0) {
                    var cell = args.get_item().get_cell(i);
                    cell.classList.add("ksNedele");
                }
                else if (date.getDay() == 6) {
                    var cell = args.get_item().get_cell(i);
                    cell.classList.add("ksSobota");
                }
            }
        }

        function TRG_neprit_GridCreated(sender, args) {
            resizeColumnsDashNep(sender);
        }

        function TRG_neprit_DataBound(sender, args) {
            resizeColumnsDashNep(sender);
        }

        function resizeColumnsDashNep(grid) {
            var columns = grid.get_masterTableView().get_columns();
            for (var i = 0; i < columns.length; i++) {
                columns[i].resizeToFit(false, false);
            }
            grid.repaint();
        }
    </script>
</telerik:RadScriptBlock>

<kspwc:TRadGrid runat="server" ID="TRG_neprit" CssClass="ksDbpNepRg" ClientDataSourceID="RCDS_neprit" AllowPaging="true" AllowSorting="true" AutoFilterWidth="true"
     AutoMasterGridWidth="true" CaptionVisible="false">
    <ClientSettings>
        <Resizing AllowColumnResize="true" ResizeGridOnColumnResize="true" AllowResizeToFit="true" />
        <Scrolling AllowScroll="True" UseStaticHeaders="True" SaveScrollPosition="true"/>
        <ClientEvents OnColumnCreated="TRG_neprit_ColumnCreated" OnRowDataBound="TRG_neprit_RowDataBound" OnGridCreated="TRG_neprit_GridCreated" OnDataBound="TRG_neprit_DataBound" />
    </ClientSettings>
    <MasterTableView Caption="" CommandItemDisplay="None" PageSize="10" >
        <CommandItemSettings ShowAddNewRecordButton="false" ShowRefreshButton="false" />
        <PagerStyle Mode="NextPrevAndNumeric" PageSizes="5,10,20,30,50"/>
        <%--<CommandItemTemplate>
            <kspwc:GridCommandItemControl runat="server" ID="GCIC_neprit" RebindButton-Visible="false" ExportButton-Visible="false">
                <FilterButton runat="server" AutoPostBack="false"></FilterButton>
            </kspwc:GridCommandItemControl>
        </CommandItemTemplate>--%>
        <Columns>
            <telerik:GridBoundColumn DataField="jmeno" HeaderText="[%Jméno%]" DataType="System.String"></telerik:GridBoundColumn>
            <telerik:GridNumericColumn DataField="os_cislo" HeaderText="[%Os. číslo%]" DataType="System.Decimal"></telerik:GridNumericColumn>
            <telerik:GridNumericColumn DataField="cislo_pom" HeaderText="[%Poměr%]" DataType="System.Int16"></telerik:GridNumericColumn>
            <telerik:GridBoundColumn UniqueName="1" DataField="d_1" HeaderText="d_1" DataType="System.String" AllowSorting="false" AllowFiltering="false"></telerik:GridBoundColumn>
            <telerik:GridBoundColumn UniqueName="2" DataField="d_2" HeaderText="d_2" DataType="System.String" AllowSorting="false" AllowFiltering="false"></telerik:GridBoundColumn>
            <telerik:GridBoundColumn UniqueName="3" DataField="d_3" HeaderText="d_3" DataType="System.String" AllowSorting="false" AllowFiltering="false"></telerik:GridBoundColumn>
            <telerik:GridBoundColumn UniqueName="4" DataField="d_4" HeaderText="d_4" DataType="System.String" AllowSorting="false" AllowFiltering="false"></telerik:GridBoundColumn>
            <telerik:GridBoundColumn UniqueName="5" DataField="d_5" HeaderText="d_5" DataType="System.String" AllowSorting="false" AllowFiltering="false"></telerik:GridBoundColumn>
            <telerik:GridBoundColumn UniqueName="6" DataField="d_6" HeaderText="d_6" DataType="System.String" AllowSorting="false" AllowFiltering="false"></telerik:GridBoundColumn>
            <telerik:GridBoundColumn UniqueName="7" DataField="d_7" HeaderText="d_7" DataType="System.String" AllowSorting="false" AllowFiltering="false"></telerik:GridBoundColumn>
            <telerik:GridBoundColumn UniqueName="8" DataField="d_8" HeaderText="d_8" DataType="System.String" AllowSorting="false" AllowFiltering="false"></telerik:GridBoundColumn>
            <telerik:GridBoundColumn UniqueName="9" DataField="d_9" HeaderText="d_9" DataType="System.String" AllowSorting="false" AllowFiltering="false"></telerik:GridBoundColumn>
            <telerik:GridBoundColumn UniqueName="10" DataField="d_10" HeaderText="d_10" DataType="System.String" AllowSorting="false" AllowFiltering="false"></telerik:GridBoundColumn>
        </Columns>
    </MasterTableView>
</kspwc:TRadGrid>

<telerik:RadClientDataSource ID="RCDS_neprit" runat="server" AllowBatchOperations="false">
    <ClientEvents OnDataParse="ParseSNep" />
    <DataSource>
        <WebServiceDataSourceSettings>
            <Select Url="DashBoard/WebMethods.aspx/GetNepritomnosti" DataType="JSON" RequestType="Post" ContentType="application/json; charset=utf-8" />
        </WebServiceDataSourceSettings>
    </DataSource>
    <Schema>
        <Model>
            <telerik:ClientDataSourceModelField FieldName="os_cislo" DataType="Number" Editable="False" />
            <telerik:ClientDataSourceModelField FieldName="cislo_pom" DataType="Number" Editable="False" />
            <telerik:ClientDataSourceModelField FieldName="jmeno" DataType="String" Editable="False" />
            <telerik:ClientDataSourceModelField FieldName="d_1" DataType="String" Editable="False" />
            <telerik:ClientDataSourceModelField FieldName="d_2" DataType="String" Editable="False" />
            <telerik:ClientDataSourceModelField FieldName="d_3" DataType="String" Editable="False" />
            <telerik:ClientDataSourceModelField FieldName="d_4" DataType="String" Editable="False" />
            <telerik:ClientDataSourceModelField FieldName="d_5" DataType="String" Editable="False" />
            <telerik:ClientDataSourceModelField FieldName="d_6" DataType="String" Editable="False" />
            <telerik:ClientDataSourceModelField FieldName="d_7" DataType="String" Editable="False" />
            <telerik:ClientDataSourceModelField FieldName="d_8" DataType="String" Editable="False" />
            <telerik:ClientDataSourceModelField FieldName="d_9" DataType="String" Editable="False" />
            <telerik:ClientDataSourceModelField FieldName="d_10" DataType="String" Editable="False" />
        </Model>
    </Schema>
</telerik:RadClientDataSource>
