﻿<%@ Control Language="C#" AutoEventWireup="true" CodeBehind="PdfViewer.ascx.cs" Inherits="KSPortal.Dokumenty.PdfViewer" %>

<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>
<style type="text/css">
    .ksPdfViewer select {
        min-width: initial;
    }

    .ksPdfViewerDebugIcon {
        min-height: auto !important;
        font-size: 16px;
    }
</style>

<asp:Panel runat="server" ID="P_PdfViewer" CssClass="ksPdfViewer">
</asp:Panel>

<asp:HiddenField ID="HF_pdfcontext" runat="server" />
<asp:HiddenField ID="HF_pdfalign" runat="server" />
<asp:HiddenField ID="HF_autoAppend" runat="server" />

<asp:Label ID="L_lokalizace" runat="server" Visible="false">
'PdfViewer': {
  'PdfViewer': '[%Prohlížeč PDF%]',
  'Cancel': '[%Zrušit%]',
  'Download file': '[%Stáhnout soubor%]',
  'Download': '[%Stáhnout%]',
  'Enter Password': '[%Tento dokument je chráněn heslem. Zadejte heslo.%]',
  'File Corrupted': '[%Soubor poškozen%]',
  'File Corrupted Content': '[%Soubor je poškozen a nelze jej otevřít.%]',
  'Fit Page': '[%Na stránku%]',
  'Fit Width': '[%Na šířku%]',
  'Automatic': '[%Automaticky%]',
  'Go To First Page': '[%Zobrazit první stránku%]',
  'Invalid Password': '[%Nesprávné heslo. Zkuste to prosím znovu.%]',
  'Next Page': '[%Zobrazit další stránku%]',
  'OK': 'OK',
  'Open': '[%Otevřít soubor%]',
  'Page Number': '[%Číslo aktuální stránky%]',
  'Previous Page': '[%Zobrazit předchozí stránku%]',
  'Go To Last Page': '[%Zobrazit poslední stránku%]',
  'Zoom': 'Zoom',
  'Zoom In': '[%Přiblížit%]',
  'Zoom Out': '[%Oddálit%]',
  'Page Thumbnails': '[%Miniatury stránek%]',
  'Bookmarks': '[%Záložky%]',
  'Print': '[%Vytisknout dokument%]',
  'Password Protected': '[%Vyžadováno heslo%]',
  'Copy': '[%Kopírovat%]',
  'Text Selection': '[%Nástroj pro výběr textu%]',
  'Panning': '[%Režim posouvání%]',
  'Text Search': '[%Najít text%]',
  'Find in document': '[%Najít v dokumentu%]',
  'Match case': '[%Shodná velikost písmen%]',
  'Apply': '[%Použít%]',
  'GoToPage': '[%Přejít na stránku%]',
  'No matches': '[%Prohlížeč dokončil vyhledávání dokumentu. Nebyly nalezeny žádné další shody%]',
  'No Text Found': '[%Nenalezen žádný text%]',
  'Undo': '[%Vrátit zpět%]',
  'Redo': '[%Znovu%]',
  'Annotation': '[%Přidat nebo upravit anotaci%]',
  'FormDesigner': '[%Přidat a upravit pole formuláře%]',
  'Highlight': '[%Zvýrazněný text%]',
  'Underline': '[%Podtržený text%]',
  'Strikethrough': '[%Přeškrtnutý text%]',
  'Delete': '[%Smazat anotaci%]',
  'Opacity': '[%Krytí%]',
  'Color edit': '[%Změnit barvu%]',
  'Opacity edit': '[%Změnit krytí%]',
  'Highlight context': '[%Zvýraznění%]',
  'Underline context': '[%Podtržení%]',
  'Strikethrough context': '[%Přeškrtnout%]',
  'Server error': '[%Webová služba neposlouchá. Prohlížeč PDF závisí na webové službě pro všechny její funkce. Chcete-li pokračovat, spusťte prosím webovou službu.%]',
  'Client error': '[%Byla nalezena chyba na straně klienta. Zkontrolujte prosím vlastní záhlaví poskytnutá ve vlastnosti AjaxRequestSettings a metody webové akce ve vlastnosti ServerActionSettings.%]',
  'Open text': '[%Otevřít%]',
  'First text': '[%První strana%]',
  'Previous text': '[%První strana%]',
  'Next text': '[%Další strana%]',
  'Last text': '[%Poslední strana%]',
  'Zoom in text': '[%Přiblížit%]',
  'Zoom out text': '[%Oddálit%]',
  'Selection text': '[%Výběr%]',
  'Pan text': '[%Posouvat%]',
  'Print text': '[%Tisk%]',
  'Search text': '[%Hledat%]',
  'Annotation Edit text': '[%Upravit anotaci%]',
  'FormDesigner Edit text': '[%Přidat a upravit pole formuláře%]',
  'Line Thickness': '[%Tloušťka čáry%]',
  'Line Properties': '[%Vlastnosti čáry%]',
  'Start Arrow': '[%Začátek šipky%]',
  'End Arrow': '[%Konec šipky%]',
  'Line Style': '[%Styl čáry%]',
  'Fill Color': '[%Barva výplně%]',
  'Line Color': '[%Barva čáry%]',
  'None': '[%Žádná%]',
  'Open Arrow': '[%Otevřená%]',
  'Closed Arrow': '[%Uzavřená%]',
  'Round Arrow': '[%Kulatá%]',
  'Square Arrow': '[%Čtverec%]',
  'Diamond Arrow': '[%Diamant%]',
  'Butt': 'Butt',
  'Cut': '[%Vyjmout%]',
  'Paste': '[%Vložit%]',
  'Delete Context': '[%Smazat%]',
  'Properties': '[%Vlastnosti%]',
  'Add Stamp': '[%Přidat razítko%]',
  'Add Shapes': '[%Přidat tvary%]',
  'Stroke edit': '[%Změnit barvu tahu%]',
  'Change thickness': '[%Změnit tloušťku okraje%]',
  'Add line': '[%Přidat řádek%]',
  'Add arrow': '[%Přidat šipku%]',
  'Add rectangle': '[%Přidat obdélník%]',
  'Add circle': '[%Přidat kruh%]',
  'Add polygon': '[%Přidat mnohoúhelník%]',
  'Add Comments': '[%Přidat komentáře%]',
  'Comments': '[%Komentáře%]',
  'SubmitForm': 'Submit Form',
  'No Comments Yet': '[%Zatím žádné komentáře%]',
  'Accepted': '[%Přijato%]',
  'Completed': '[%Dokončeno%]',
  'Cancelled': '[%Zrušeno%]',
  'Rejected': '[%Odmítnuto%]',
  'Leader Length': '[%Délka vodítka%]',
  'Scale Ratio': '[%Poměr měřítka%]',
  'Calibrate': '[%Kalibrovat%]',
  'Calibrate Distance': '[%Kalibrovat vzdálenost%]',
  'Calibrate Perimeter': '[%Kalibrovat obvod%]',
  'Calibrate Area': '[%Kalibrovat plochu%]',
  'Calibrate Radius': '[%Kalibrovat poloměr%]',
  'Calibrate Volume': '[%Kalibrovat objem%]',
  'Depth': '[%Tloušťka%]',
  'Closed': '[%Uzavřená%]',
  'Round': '[%Kulatá%]',
  'Square': '[%Hranatá%]',
  'Diamond': '[%Diamant%]',
  'Edit': '[%Upravit%]',
  'Comment': '[%Komentář%]',
  'Comment Panel': '[%Panel komentářů%]',
  'Set Status': '[%Nastavit stav%]',
  'Post': '[%Zařadit%]',
  'Page': '[%Stránka%]',
  'Add a comment': '[%Přidat komentář%]',
  'Add a reply': '[%Přidat odpověď%]',
  'Import Annotations': '[%Importovat anotace ze souboru JSON%]',
  'Export Annotations': '[%Exportovat anotaci do souboru JSON%]',
  'Export XFDF': '[%Exportovat anotaci do souboru XFDF%]',
  'Import XFDF': '[%Importovat anotace ze souboru XFDF%]',
  'Add': '[%Přidat%]',
  'Clear': '[%Vymazat%]',
  'Bold': '[%Tučné%]',
  'Italic': '[%Kurzíva%]',
  'Strikethroughs': '[%Přeškrtnuté%]',
  'Underlines': '[%Podtržení%]',
  'Superscript': '[%Horní index%]',
  'Subscript': '[%Dolní index%]',
  'Align left': '[%Zarovnat doleva%]',
  'Align right': '[%Zarovnat doprava%]',
  'Center': '[%Vycentrovat%]',
  'Justify': '[%Vyrovnat%]',
  'Font color': '[%Barva písma%]',
  'Text Align': '[%Zarovnání textu%]',
  'Text Properties': '[%Styl písma%]',
  'SignatureFieldDialogHeaderText': '[%Přidat podpis%]',
  'HandwrittenSignatureDialogHeaderText': '[%Přidat podpis%]',
  'InitialFieldDialogHeaderText': 'Add Initial',
  'HandwrittenInitialDialogHeaderText': 'Add Initial',
  'Draw Ink': 'Draw Ink',
  'Create': '[%Vytvořit%]',
  'Font family': '[%Rodina písem%]',
  'Font size': '[%Velikost písma%]',
  'Free Text': 'Free Text',
  'Import Failed': '[%Neplatný typ souboru JSON nebo název souboru; vyberte prosím platný soubor JSON%]',
  'Import PDF Failed': '[%Neplatný typ souboru PDF nebo soubor PDF nebyl nalezen. Vyberte prosím platný soubor PDF%]',
  'File not found': '[%Importovaný soubor JSON nebyl nalezen v požadovaném umístění%]',
  'Export Failed': '[%Akce exportu anotací se nezdařila. Ujistěte se prosím, že jsou anotace přidány správně%]',
  'of': '[%z%] ',
  'Dynamic': '[%Dynamické%]',
  'Standard Business': 'Standard Business',
  'Sign Here': '[%Sem podepište%]',
  'Custom Stamp': '[%Vlastní razítko%]',
  'Enter Signature as Name': '[%Zadejte své jméno%]',
  'Draw-hand Signature': '[%Kreslit%]',
  'Type Signature': '[%Psát%]',
  'Upload Signature': '[%Nahrát%]',
  'Browse Signature Image': '[%Vybrat%]',
  'Save Signature': '[%Uložit podpis%]',
  'Save Initial': 'Save Initial',
  'Textbox': 'Textbox',
  'Password': '[%Heslo%]',
  'Check Box': 'Checkbox',
  'Radio Button': 'Radio Button',
  'Dropdown': 'Drop Down',
  'List Box': 'List Box',
  'Signature': '[%Podpis%]',
  'Delete FormField': '[%Smazat pole formuláře%]',
  'Textbox Properties': '[%Vlastnosti textového pole%]',
  'Name': '[%Název%]',
  'Tooltip': '[%Nápověda%]',
  'Value': '[%Hodnota%]',
  'Form Field Visibility': '[%Viditelnost pole formuláře%]',
  'Read Only': '[%Pouze pro čtení%]',
  'Required': '[%Povinné%]',
  'Checked': 'Checked',
  'Show Printing': '[%Zobrazit v tisku%]',
  'Formatting': '[%Formátovat%]',
  'Fill': '[%Vyplnit%]',
  'Border': '[%Ohraničení%]',
  'Border Color': '[%Barva ohraničení%]',
  'Thickness': '[%Tloušťka%]',
  'Max Length': '[%Max. délka%]',
  'List Item': '[%Název položky%]',
  'Export Value': '[%Hodnota položky%]',
  'Dropdown Item List': '[%Rozbalovací seznam položek%]',
  'List Box Item List': '[%Seznam položek%]',
  'General': '[%Obecné%]',
  'Appearance': '[%Vzhled%]',
  'Options': '[%Možnosti%]',
  'Delete Item': '[%Smazat%]',
  'Up': '[%Nahoru%]',
  'Down': '[%Dolů%]',
  'Multiline': '[%Víceřádkový%]',
  'Revised': '[%Revidováno%]',
  'Reviewed': '[%Recenzováno%]',
  'Received': '[%Přijato%]',
  'Confidential': '[%Důvěrné%]',
  'Approved': '[%Schváleno%]',
  'Not Approved': '[%Neschváleno%]',
  'Witness': '[%Svědek%]',
  'Initial Here': 'Initial Here',
  'Draft': '[%Návrh%]',
  'Final': 'Final',
  'For Public Release': '[%Pro veřejné vydání%]',
  'Not For Public Release': '[%Není pro veřejné vydání%]',
  'For Comment': '[%Pro komentář%]',
  'Void': 'Void',
  'Preliminary Results': '[%Předběžné výsledky%]',
  'Information Only': 'Information Only',
  'in': 'in',
  'm': 'm',
  'ft_in': 'ft_in',
  'ft': 'ft',
  'p': 'p',
  'cm': 'cm',
  'mm': 'mm',
  'pt': 'pt',
  'cu': 'cu',
  'sq': 'sq',
  'Initial': '[%Počáteční%]'
}
</asp:Label>

<telerik:RadScriptBlock ID="RSB_mt2" runat="server">
    <script type="text/javascript">
        //24.1460.41.0
        //ej.base.registerLicense('Ngo9BigBOggjHTQxAR8/V1NAaF5cWWJCf1FpRmJGdld5fUVHYVZUTXxaS00DNHVRdkdgWH1feXRTRGNcUEx/Vkc=');

        function pdfParentWindowShow(sender, args) {
            var wndBounds = sender.getWindowBounds();
            var newHeight = wndBounds.height;
            var newWidth = wndBounds.height;
            var newX = wndBounds.x;
            var newY = wndBounds.y;
            var browserWidth = $(window).width();
            var browserHeight = $(window).height();
            var scrollleft = $(window).scrollLeft();
            var scrollTop = $(window).scrollTop();
            var hf_halign = $get('<%= HF_pdfalign.ClientID %>');

            if (newWidth > browserWidth) {
                newWidth = browserWidth;
            }

            if (newHeight > browserHeight) {
                newHeight = browserHeight;
            }

            var absY = newY - scrollTop;
            if (newHeight + absY > browserHeight) {
                absY = absY - (newHeight + absY - browserHeight);
                if (absY < 0) {
                    newHeight = newHeight + absY;
                    absY = 0;
                }
                newY = absY + scrollTop;
            }
            if (hf_halign) {
                if (hf_halign.value == '1') {
                    newX = 0;
                }
                else if (hf_halign.value == '2') {
                    newX = scrollleft + browserWidth - newWidth;
                }
                else if (hf_halign.value == '3') {
                    newX = scrollleft + ((browserWidth - newWidth) / 2);
                }
            }

            sender.setSize(newWidth, newHeight);
            sender.moveTo(newX, newY);

            KSMaster.PdfViewerAppend();
        }

        function pdfParentWindowShowResizeEnd(sender, args) {
            if (KSMaster && KSMaster.PdfViewer && KSMaster.PdfViewer.isRendered && KSMaster.PdfViewer.element && KSMaster.PdfViewer.element.innerHTML != '') {
                KSMaster.PdfViewer.updateViewerContainer();
            }
        }

        function pdfParentWindowCommand(sender, args) {
            if (args.get_commandName() == 'Maximize' || args.get_commandName() == 'Restore') {
                setTimeout(function () {
                    debugger;
                    pdfParentWindowShowResizeEnd(sender, args);
                }, 0);
            }
        }

        if (!'<%= System.Threading.Thread.CurrentThread.CurrentUICulture.Name %>'.startsWith('en-')) {
            ej.base.L10n.load({
                '<%= System.Threading.Thread.CurrentThread.CurrentUICulture.Name %>': {
                <%= L_lokalizace.Text %>
                }
            });
        }
        Sys.Application.add_load(function () {
            KSMaster.PdfViewer = new ej.pdfviewer.PdfViewer({
                locale: '<%= System.Threading.Thread.CurrentThread.CurrentUICulture.Name %>',
                interactionMode: 'Pan',
                documentPath: 'fromSession',
                serviceUrl: KSMaster.baseUrl + "/api/PdfViewer"
            });
            if (KSMaster.PdfViewer) {
                KSMaster.PdfViewer.toolbarSettings = {
                    toolbarItems: [
                        "PageNavigationTool",
                        "MagnificationTool",
                        "PanTool",
                        "SelectionTool",
                        "SearchOption",
                    <%= EnablePrint ? "\"PrintOption\"," : ""%>
                    <%= EnableDownload ? "\"DownloadOption\"," : ""%>
                    <%= EnableOpen ? "\"OpenOption\"," : ""%>
                    <%= EnableUndoRedoTool ? "\"UndoRedoTool\"," : ""%>
                    <%= EnableAnnotationEditTool ? "\"AnnotationEditTool\"," : ""%>
                    <%= EnableFormDesignerEditTool ? "\"FormDesignerEditTool\"," : ""%>
                    ],
                };
            }
            KSMaster.PdfViewer.documentLoad = function (args) {
                var hf = $get('<%= HF_pdfcontext.ClientID %>');
                if (hf && hf.value && hf.value != '') {
                    var context = JSON.parse(hf.value);
                    var name = context.nazev;
                    if (!name.toUpperCase().endsWith(".PDF")) {
                        name += ".pdf";
                    }
                    KSMaster.PdfViewer.downloadFileName = name;
                }
            };

            KSMaster.PdfViewerAppend = function () {
                var pdfParentWindowID = '<%= ParentRadWindow != null ? ParentRadWindow.ClientID : "" %>';
            var pdfParentWindow = $find(pdfParentWindowID);
            if (KSMaster.PdfViewer && !(KSMaster.PdfViewer.isRendered && KSMaster.PdfViewer.element && KSMaster.PdfViewer.element.innerHTML != '') && (pdfParentWindowID == '' || (pdfParentWindow && pdfParentWindow.isVisible()))) {
                window.setTimeout(function () {
                    KSMaster.PdfViewer.appendTo('#<%= P_PdfViewer.ClientID %>');

                    //přidání tlačítka Test;
                    var toolbar = KSMaster.PdfViewer.element.getElementsByClassName('e-toolbar-right')[0];
                    var debugButtonHtml =
                        '<div class="e-toolbar-item">' +
                        '<button class="e-tbar-btn e-tbtn-txt e-control e-btn e-lib e-pv-tbar-btn e-tooltip" title="Test" type="button" ' +
                        'onclick="KSMaster.PdfViewer.debug();" tabindex="-1" data-tabindex="-1" aria-label="Test" aria-disabled="true">' +
                        '<span class="fi fi-gears ksPdfViewerDebugIcon"></span>' +
                        '<span class="e-tbar-btn-text">Test</span>' +
                        '</button>' +
                        '</div>';
                    $(toolbar).append($(debugButtonHtml));
                }, 100);
                }
            };

            KSMaster.PdfViewer.debug = function () {
                $.ajax({
                    type: "Get",
                    url: KSMaster.baseUrl + "/api/PdfViewer/Test",
                    data: "",
                    async: false,
                    contentType: "application/json",
                    dataType: "json",
                    failure: function (response) {
                        KSMaster.showError(response.responseText, response.statusText);
                    },
                    error: function (response) {
                        KSMaster.showError(response.responseText, response.statusText);
                    },
                    success: function (data) {
                        var statut = JSON.parse(data);
                        if (statut && statut.Status && statut.Status == true) {
                            radalert(data, 0, 0, "Server response", null, null);
                            KSMaster.PdfViewer.load('test');
                        }
                        else {
                            KSMaster.showError(statut.Message + '<br><br>ReferencePath: ' + statut.ReferencePath + '<br><br>Chyba:<br><br>' + statut.Exceptions.join('<br><br>'), 'Chyba ze serveru');
                        }
                    }
                });
            };

        });

        var oldPageLoadPdfv = !oldPageLoadPdfv ? KSMaster.onPageLoad : oldPageLoadPdfv;
        KSMaster.onPageLoad = function () {
            oldPageLoadPdfv.apply();
            var hfappend = $get('<%= HF_autoAppend.ClientID %>');
            if (hfappend.value != 'False') {
                KSMaster.PdfViewerAppend();
            }
        };
        KSMaster.onPageLoad.prototype = oldPageLoadPdfv.prototype;

    </script>
</telerik:RadScriptBlock>
