﻿<%@ Page Title="Sestava doporučeného vzdělávání" Language="C#" MasterPageFile="~/Main.Master"
    AutoEventWireup="true" Inherits="Sestavy_HodnoceniVzdelavani" Codebehind="HodnoceniVzdelavani.aspx.cs" %>

<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>

<asp:Content ID="Content1" ContentPlaceHolderID="HlavniOblast" runat="Server">
    <telerik:RadAjaxManagerProxy ID="RadAjaxManagerProxy1" runat="server">
        <AjaxSettings>
            <telerik:AjaxSetting AjaxControlID="TRadGrid_sestava">
                <UpdatedControls>
                    <telerik:AjaxUpdatedControl ControlID="TRadGrid_sestava" />
                </UpdatedControls>
            </telerik:AjaxSetting>
        </AjaxSettings>
    </telerik:RadAjaxManagerProxy>
    <asp:Label ID="Label1" runat="server" Text="[%Doporučené vzdělávání%]" CssClass="nadpis1"></asp:Label>
    <div>
        <table style="border: 1px solid #808080; border-collapse: collapse;" class="ksprvek HodnoceniToolbar">
            <tr>
                <td style="border-width: 1px; border-color: #808080; font-weight: bold; border-right-style: solid;">
                    [%Filtr hodnotících akcí%]:
                </td>
                <td colspan="2" style="border-width: 1px; border-color: #808080; font-weight: bold;
                    border-right-style: solid;">
                    [%Filtr zaměstnanců%]:
                </td>
                <td style="font-weight: bold">
                    [%Filtr vzd. aktivity%]:
                </td>
                <td style="border-width: 1px; border-color: #808080; font-weight: bold; border-left-style: solid;">
                    [%Školící akce%]:
                </td>
            </tr>
            <tr>
                <td rowspan="2" style="border-right-style: solid; border-width: 1px; border-color: #808080">
                    <asp:Panel ID="Panel2" runat="server" Width="100%" Height="100px" ScrollBars="Auto">
                        <asp:ObjectDataSource ID="ODS_akce" runat="server" OldValuesParameterFormatString="original_{0}"
                            SelectMethod="HodnoticiAkce" TypeName="KSProgram.Hodnoceni.Hodnoceni">
                            <SelectParameters>
                                <asp:Parameter Name="zamceno" DbType="Int16" />
                                <asp:Parameter Name="jen_primi" Type="Boolean" DefaultValue="false" />
                                <asp:Parameter Name="existujeOdkazDo" Type="String" DefaultValue="hz_hod_roz.idp;" />
                            </SelectParameters>
                        </asp:ObjectDataSource>
                        <kspwc:TGridView ID="TGV_akce" runat="server" DataSourceID="ODS_akce" DataKeyNames="id"
                            AutoGenerateCheckBoxColumn="True" BorderColor="White" AutoPostBack="True">
                            <Columns>
                                <asp:BoundField DataField="id" Visible="False" />
                                <asp:BoundField DataField="nazev" HeaderText="[%Název akce%]" SortExpression="nazev" />
                                <asp:BoundField DataField="obdobi_od" HeaderText="[%Období od%]" SortExpression="obdobi_od"
                                    DataFormatString="{0:d}" />
                                <asp:BoundField DataField="obdobi_do" HeaderText="[%Do%]" SortExpression="obdobi_do"
                                    DataFormatString="{0:d}" />
                            </Columns>
                        </kspwc:TGridView>
                    </asp:Panel>
                </td>
                <td>
                    <asp:Label ID="L_divize" runat="server" Text="[%Divize%]:"></asp:Label>
                    <br />
                    <asp:ObjectDataSource ID="ODS_divize" runat="server" OldValuesParameterFormatString="original_{0}"
                        SelectMethod="cislDivize" TypeName="KSProgram.Sestavy.DefSestavy_HodnKompetence">
                        <SelectParameters>
                            <asp:ControlParameter ControlID="TGV_akce" Name="Id_ha" PropertyName="CheckedKeyValuesWhereIn[0]"
                                Type="String" />
                            <asp:Parameter Name="zamceno" Type="Int16" DefaultValue="2" />
                        </SelectParameters>
                    </asp:ObjectDataSource>
                    <kspwc:TDropDown ID="TDD_divize" runat="server" DataSourceID="ODS_divize" DataTextField="naz_divize"
                        DataValueField="cis_divize" AutoPostBack="True">
                    </kspwc:TDropDown>
                </td>
                <td style="border-right-style: solid; border-width: 1px; border-color: #808080">
                    <asp:Label ID="L_stredisko" runat="server" Text="[%Středisko%]:"></asp:Label>
                    <br />
                    <asp:ObjectDataSource ID="ODS_Stredisko" runat="server" OldValuesParameterFormatString="original_{0}"
                        SelectMethod="cislStredisko" TypeName="KSProgram.Sestavy.DefSestavy_HodnKompetence">
                        <SelectParameters>
                            <asp:ControlParameter ControlID="TGV_akce" Name="Id_ha" PropertyName="CheckedKeyValuesWhereIn[0]"
                                Type="String" />
                            <asp:ControlParameter ControlID="TDD_divize" Name="cis_divize" PropertyName="SelectedValue"
                                Type="String" />
                            <asp:ControlParameter ControlID="TDD_skupinaStred" Name="skup_str" PropertyName="SelectedValue"
                                Type="String" />
                            <asp:Parameter Name="zamceno" DefaultValue="2" Type="Int16" />
                        </SelectParameters>
                    </asp:ObjectDataSource>
                    <kspwc:TDropDown ID="TDD_stredisko" runat="server" DataSourceID="ODS_Stredisko" DataTextField="nazev"
                        DataValueField="str" AutoPostBack="True">
                    </kspwc:TDropDown>
                </td>
                <td>
                    <asp:Label ID="L_typ_osve" runat="server" Text="[%Typ vzd. aktivity%]:"></asp:Label>
                    <br />
                    <asp:ObjectDataSource ID="ODS_typy_akci" runat="server" OldValuesParameterFormatString="original_{0}"
                        SelectMethod="cislTypySkolAkci" TypeName="KSProgram.Sestavy.DefSestavy_HodnVzdelavani">
                        <SelectParameters>
                            <asp:ControlParameter ControlID="TGV_akce" Name="Id_ha" PropertyName="CheckedKeyValuesWhereIn[0]"
                                Type="String" />
                            <asp:ControlParameter ControlID="TDD_divize" Name="cis_divize" PropertyName="SelectedValue"
                                Type="String" />
                            <asp:ControlParameter ControlID="TDD_skupinaStred" Name="skup_str" PropertyName="SelectedValue"
                                Type="String" />
                            <asp:ControlParameter ControlID="TDD_stredisko" Name="str" PropertyName="SelectedValue"
                                Type="String" />
                            <asp:ControlParameter ControlID="TDD_zamestnanec" Name="os_cislo" PropertyName="SelectedValue"
                                Type="String" />
                        </SelectParameters>
                    </asp:ObjectDataSource>
                    <kspwc:TDropDown ID="TDD_typy_skoleni" runat="server" DataSourceID="ODS_typy_akci" DataTextField="nazev_typu"
                        DataValueField="typ_akce" AutoPostBack="True">
                    </kspwc:TDropDown>
                </td>
                <td rowspan="2" style="border-left-style: solid; border-width: 1px; border-color: #808080">
                    <kspwc:TRadioButtonList ID="TRBL_skolAkce" runat="server" UseSaveSetting="True">
                        <asp:ListItem Selected="True" Value="0">[%Poslední%]</asp:ListItem>
                        <asp:ListItem Value="1">[%Všechny%]</asp:ListItem>
                    </kspwc:TRadioButtonList>
                </td>
            </tr>
            <tr>
                <td>
                    <asp:Label ID="L_skupinaStred" runat="server" Text="[%Skup. středisek%]:"></asp:Label>
                    <br />
                    <asp:ObjectDataSource ID="ODS_SkupinaStred" runat="server" OldValuesParameterFormatString="original_{0}"
                        SelectMethod="cislSkupinaStred" TypeName="KSProgram.Sestavy.DefSestavy_HodnKompetence">
                        <SelectParameters>
                            <asp:ControlParameter ControlID="TGV_akce" Name="Id_ha" PropertyName="CheckedKeyValuesWhereIn[0]"
                                Type="String" />
                            <asp:Parameter Name="zamceno" Type="Int16" DefaultValue="2" />
                        </SelectParameters>
                    </asp:ObjectDataSource>
                    <kspwc:TDropDown ID="TDD_skupinaStred" runat="server" DataSourceID="ODS_SkupinaStred"
                        DataTextField="skup_nazev" DataValueField="skup_str" AutoPostBack="True">
                    </kspwc:TDropDown>
                </td>
                <td style="border-right-style: solid; border-width: 1px; border-color: #808080">
                    <asp:Label ID="L_zamestnanec" runat="server" Text="[%Zaměstnanec%]:"></asp:Label>
                    <br />
                    <asp:ObjectDataSource ID="ODS_Zamestnanec" runat="server" OldValuesParameterFormatString="original_{0}"
                        SelectMethod="cislZamestnanec" TypeName="KSProgram.Sestavy.DefSestavy_HodnKompetence">
                        <SelectParameters>
                            <asp:ControlParameter ControlID="TGV_akce" Name="Id_ha" PropertyName="CheckedKeyValuesWhereIn[0]"
                                Type="String" />
                            <asp:ControlParameter ControlID="TDD_divize" Name="cis_divize" PropertyName="SelectedValue"
                                Type="String" />
                            <asp:ControlParameter ControlID="TDD_skupinaStred" Name="skup_str" PropertyName="SelectedValue"
                                Type="String" />
                            <asp:ControlParameter ControlID="TDD_stredisko" Name="str" PropertyName="SelectedValue"
                                Type="String" />
                            <asp:Parameter Name="zamceno" DefaultValue="2" Type="Int16" />
                        </SelectParameters>
                    </asp:ObjectDataSource>
                    <kspwc:TDropDown ID="TDD_zamestnanec" runat="server" DataSourceID="ODS_Zamestnanec"
                        DataTextField="jmeno" DataValueField="os_cislo" AutoPostBack="True">
                    </kspwc:TDropDown>
                </td>
                <td>
                    <asp:Label ID="L_osvedceni" runat="server" Text="[%Vzdělávací aktivita%]:"></asp:Label>
                    <br />
                    <asp:ObjectDataSource ID="ODS_osvedceni" runat="server" OldValuesParameterFormatString="original_{0}"
                        SelectMethod="cislOsvedceni" TypeName="KSProgram.Sestavy.DefSestavy_HodnVzdelavani">
                        <SelectParameters>
                            <asp:ControlParameter ControlID="TGV_akce" Name="Id_ha" PropertyName="CheckedKeyValuesWhereIn[0]"
                                Type="String" />
                            <asp:ControlParameter ControlID="TDD_divize" Name="cis_divize" PropertyName="SelectedValue"
                                Type="String" />
                            <asp:ControlParameter ControlID="TDD_skupinaStred" Name="skup_str" PropertyName="SelectedValue"
                                Type="String" />
                            <asp:ControlParameter ControlID="TDD_stredisko" Name="str" PropertyName="SelectedValue"
                                Type="String" />
                            <asp:ControlParameter ControlID="TDD_zamestnanec" Name="os_cislo" PropertyName="SelectedValue"
                                Type="String" />
                            <asp:ControlParameter ControlID="TDD_typy_skoleni" Name="TypOsvedceni" PropertyName="SelectedValue"
                                Type="String" />
                        </SelectParameters>
                    </asp:ObjectDataSource>
                    <kspwc:TDropDown ID="TDD_osvedceni" runat="server" DataSourceID="ODS_osvedceni" DataTextField="text_osve"
                        DataValueField="cislo">
                    </kspwc:TDropDown>
                </td>
            </tr>
            <tr>
                <td colspan="5" style="border-top-style: solid; border-width: 1px; border-color: #808080">
                    <asp:Label ID="Label4" runat="server" Text="[%Sloupce%]:"></asp:Label>
                    <kspwc:TCheckBoxList ID="CBL_show" runat="server" RepeatDirection="Horizontal" 
                        UseSaveSetting="True" onprerender="CBL_show_PreRender">
                    </kspwc:TCheckBoxList>
                </td>
            </tr>
        </table>
        <br />
        <kspwc:TLinkButton runat="server" ID="lb_nacist" Text="[%Vytvořit%]" CssClass="kstlacitko"
            SkinID="button" OnCommand="lb_nacist_Command"></kspwc:TLinkButton>
        <br />
        <br />
        <asp:ObjectDataSource ID="ODS_sestava" runat="server" OldValuesParameterFormatString="original_{0}"
            SelectMethod="Retrieve" TypeName="KSProgram.Sestavy.DefSestavy_HodnVzdelavani">
            <SelectParameters>
                <asp:Parameter Name="Id_ha" Type="String" />
                <asp:Parameter Name="cis_divize" Type="Int32" />
                <asp:Parameter Name="skup_str" Type="Int32" />
                <asp:Parameter Name="str" Type="String" />
                <asp:Parameter Name="os_cislo" Type="String" />
                <asp:Parameter Name="typ_osvedceni" Type="String" />
                <asp:Parameter Name="osvedceni" Type="String" />
                <asp:Parameter Name="posledni" Type="String" />
                <asp:Parameter Name="columns" Type="String" />
            </SelectParameters>
        </asp:ObjectDataSource>
        <%--
        <kspwc:TGridView ID="TGV_sestava" runat="server" AllowMultiColumnSorting="True" PovolFiltraci="True"
            ShowTitleRow="True" TitleText="[%Doporučené vzdělávání%]" ControlPanelPosition="TitleRow"
            PovolExport="True" OnRowDataBound="TGV_sestava_RowDataBound" AllowPaging="True">
            <Columns>
                <asp:BoundField DataField="os_cislo" HeaderText="[%Os. číslo%]" SortExpression="os_cislo" />
                <asp:BoundField DataField="jmeno" HeaderText="[%Jméno%]" SortExpression="jmeno" />
                <asp:BoundField DataField="prac_misto" HeaderText="[%Prac. místo%]" SortExpression="prac_misto" />
                <asp:BoundField DataField="divize" HeaderText="[%Divize%]" SortExpression="divize" />
                <asp:BoundField DataField="skup_str" HeaderText="[%Skup. středisek%]" SortExpression="skup_str" />
                <asp:BoundField DataField="str" HeaderText="[%Středisko%]" SortExpression="str" />
                <asp:BoundField DataField="hod_akce" HeaderText="Hodn. akce" SortExpression="hod_akce" />
                <asp:BoundField DataField="typ_osvedceni" HeaderText="[%Typ vzd. aktivity%]" SortExpression="typ_osvedceni" />
                <asp:BoundField DataField="osvedceni" HeaderText="[%Vzdělávací aktivita%]" SortExpression="osvedceni" />
                <asp:BoundField DataField="termin" HeaderText="[%Termín%]" SortExpression="termin"
                    DataFormatString="{0:d}" />
                <asp:BoundField DataField="dat_od" HeaderText="[%Datum%]" SortExpression="dat_od"
                    DataFormatString="{0:d}" />
                <asp:BoundField DataField="akce" HeaderText="[%Název akce%]" SortExpression="akce" />
                <asp:BoundField DataField="plati_do" HeaderText="[%Platí do%]" SortExpression="plati_do"
                    DataFormatString="{0:d}" />
                <asp:BoundField DataField="zpusob" HeaderText="[%Způsob%]" SortExpression="zpusob" />
                <asp:TemplateField HeaderText="[%Poznámka%]" SortExpression="poznamka">
                    <ItemTemplate>
                        <kspwc:TLabel runat="server" ID="TL_poznamka" Text='<%# Bind("poznamka") %>' FormatHtml="True"></kspwc:TLabel>
                    </ItemTemplate>
                </asp:TemplateField>
            </Columns>
            <PagerTemplate>
                <kspwc:PagerNavigationBar runat="server" ID="page_nastaveni" />
            </PagerTemplate>
        </kspwc:TGridView>
            --%>
        <%-- NEW --%>
        <kspwc:TRadGrid ID="TRadGrid_sestava" runat="server" ShowGroupPanel="True" AllowPaging="True" 
                         AllowSorting="true" AutoGenerateColumns="false"
                        AutoFilterControlWidth="false" OnItemDataBound="TRadGrid_sestava_ItemDataBound" >
            <ClientSettings AllowDragToGroup="True">
            </ClientSettings>
            <GroupingSettings ShowUnGroupButton="true"></GroupingSettings>
            <PagerStyle Mode="NextPrevNumericAndAdvanced"></PagerStyle>
            <ExportSettings HideStructureColumns="true" OpenInNewWindow="true">
            </ExportSettings>
            <MasterTableView CommandItemDisplay="Top">
                <Columns>
                    <telerik:GridNumericColumn DataType="System.Decimal" DataField="os_cislo" HeaderText="[%Os. číslo%]" SortExpression="os_cislo" FilterControlWidth="45"/>
                    <kspwc:GridFotoZamColumn UniqueName="foto" DataOsCisloField="os_cislo"></kspwc:GridFotoZamColumn>
                    <telerik:GridBoundColumn DataField="jmeno" HeaderText="[%Jméno%]" SortExpression="jmeno" />
                    <telerik:GridBoundColumn DataField="prac_misto" HeaderText="[%Prac. místo%]" SortExpression="prac_misto" />
                    <telerik:GridBoundColumn DataField="divize" HeaderText="[%Divize%]" SortExpression="divize" />
                    <telerik:GridBoundColumn DataField="skup_str" HeaderText="[%Skup. středisek%]" SortExpression="skup_str" />
                    <telerik:GridBoundColumn DataField="str" HeaderText="[%Středisko%]" SortExpression="str" />
                    <telerik:GridBoundColumn DataField="hod_akce" HeaderText="Hodn. akce" SortExpression="hod_akce" />
                    <telerik:GridBoundColumn DataField="typ_osvedceni" HeaderText="[%Typ vzd. aktivity%]" SortExpression="typ_osvedceni" />
                    <telerik:GridBoundColumn DataField="osvedceni" HeaderText="[%Vzdělávací aktivita%]" SortExpression="osvedceni" />
                    <telerik:GridDateTimeColumn DataField="termin" HeaderText="[%Termín%]" SortExpression="termin"
                        DataFormatString="{0:d.M.yyyy}" />
                    <telerik:GridDateTimeColumn DataField="dat_od" HeaderText="[%Datum%]" SortExpression="dat_od"
                        DataFormatString="{0:d.M.yyyy}" />
                    <telerik:GridBoundColumn DataField="akce" HeaderText="[%Název akce%]" SortExpression="akce" />
                    <telerik:GridDateTimeColumn DataField="plati_do" HeaderText="[%Platí do%]" SortExpression="plati_do"
                        DataFormatString="{0:d.M.yyyy}" />
                    <telerik:GridBoundColumn DataField="zpusob" HeaderText="[%Způsob%]" SortExpression="zpusob" />
                    <telerik:GridBoundColumn DataField="poznamka" HeaderText="[%Poznámka%]" SortExpression="poznamka" />
                </Columns>
                <CommandItemTemplate>
                    <kspwc:GridCommandItemControl ID="GridCommandItemControl1" runat="server" RebindButton-Enabled="False" RebindButton-Visible="False">
                </kspwc:GridCommandItemControl> 
                </CommandItemTemplate>
            </MasterTableView>
        </kspwc:TRadGrid>
        <%-- NEW END --%>
    </div>
</asp:Content>
