﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Main.Master" AutoEventWireup="true" CodeBehind="MailTest.aspx.cs" Inherits="KSPortal.Obecne.MailTest" %>

<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>

<asp:Content ID="Content1" ContentPlaceHolderID="HeadContent" runat="server">
    <style type="text/css">
        .rcbHeader ul,
        .rcbFooter ul,
        .rcbItem ul,
        .rcbHovered ul,
        .rcbDisabled ul {
            margin: 0;
            padding: 0;
            width: 100%;
            display: inline-block;
            list-style-type: none;
        }

        .exampleRadComboBox.RadComboBoxDropDown .rcbHeader {
            padding: 5px 27px 4px 7px;
        }

        .rcbScroll {
            overflow: scroll !important;
            overflow-x: hidden !important;
        }

        .col1 {
            margin: 0;
            padding: 0 5px 0 0;
            width: 10%;
            line-height: 14px;
            float: left;
        }

        .col2 {
            margin: 0;
            padding: 0 5px 0 0;
            width: 20%;
            line-height: 14px;
            float: left;
        }

        .col3 {
            margin: 0;
            padding: 0 5px 0 0;
            width: 60%;
            line-height: 14px;
            float: left;
        }

        .prefer {
            font-weight: bold;
        }

        tr.ks-oauth2 {
            <%= KSProgram.Email.MailKitClient.Oauth2Enabled ? "" : "display: none;" %>
        }

        tr.ksIsNotCloud {
            <%= KSProgram.Email.TMailClientConfig.UseCloud ? "display: none;" : ""%>
        }

        div.KScert{
            overflow: scroll;
            height: 150px;
            width: 450px;
            border-top: 1px solid lightgray;
            border-left: 1px solid lightgray;
            color: black;
            font-weight: normal;
        }
        .MTfieldset{
            border: none;
            padding: 15px;
        }
        .ksTooltip {
            font-size: 12px !important;
        }
    </style>
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="HlavniOblast" runat="server">
    <telerik:RadAjaxManagerProxy runat="server" ID="RAMP_manag">
        <AjaxSettings>
            <telerik:AjaxSetting AjaxControlID="RadButton1">
                <UpdatedControls>
                    <telerik:AjaxUpdatedControl ControlID="P_ajax" />
                </UpdatedControls>
            </telerik:AjaxSetting>
            <telerik:AjaxSetting AjaxControlID="RadButton2">
                <UpdatedControls>
                    <telerik:AjaxUpdatedControl ControlID="P_ajax" />
                </UpdatedControls>
            </telerik:AjaxSetting>
            <telerik:AjaxSetting AjaxControlID="RadButton3">
                <UpdatedControls>
                    <telerik:AjaxUpdatedControl ControlID="P_ajax" />
                </UpdatedControls>
            </telerik:AjaxSetting>
            <telerik:AjaxSetting AjaxControlID="RB_from_14">
                <UpdatedControls>
                    <telerik:AjaxUpdatedControl ControlID="P_ajax" />
                </UpdatedControls>
            </telerik:AjaxSetting>
            <telerik:AjaxSetting AjaxControlID="RB_to_14">
                <UpdatedControls>
                    <telerik:AjaxUpdatedControl ControlID="P_ajax" />
                </UpdatedControls>
            </telerik:AjaxSetting>
            <telerik:AjaxSetting AjaxControlID="TRB_as">
                <UpdatedControls>
                    <telerik:AjaxUpdatedControl ControlID="P_ajax" />
                </UpdatedControls>
            </telerik:AjaxSetting>
            <telerik:AjaxSetting AjaxControlID="RTB_ping">
                <UpdatedControls>
                    <telerik:AjaxUpdatedControl ControlID="P_ajax" />
                </UpdatedControls>
            </telerik:AjaxSetting>
            <telerik:AjaxSetting AjaxControlID="RB_connect">
                <UpdatedControls>
                    <telerik:AjaxUpdatedControl ControlID="P_ajax" />
                    <telerik:AjaxUpdatedControl ControlID="RL_info" />
                </UpdatedControls>
            </telerik:AjaxSetting>
            <telerik:AjaxSetting AjaxControlID="RB_authenticate">
                <UpdatedControls>
                    <telerik:AjaxUpdatedControl ControlID="P_ajax" />
                    <telerik:AjaxUpdatedControl ControlID="RL_info" />
                </UpdatedControls>
            </telerik:AjaxSetting>
            <telerik:AjaxSetting AjaxControlID="TRBL_ssl">
                <UpdatedControls>
                    <telerik:AjaxUpdatedControl ControlID="P_ajax" />
                </UpdatedControls>
            </telerik:AjaxSetting>
            <telerik:AjaxSetting AjaxControlID="TRBL_ssl_options">
                <UpdatedControls>
                    <telerik:AjaxUpdatedControl ControlID="P_ajax" />
                </UpdatedControls>
            </telerik:AjaxSetting>
            <telerik:AjaxSetting AjaxControlID="TCBL_ssl_protocols">
                <UpdatedControls>
                    <telerik:AjaxUpdatedControl ControlID="P_ajax" />
                </UpdatedControls>
            </telerik:AjaxSetting>
        </AjaxSettings>
    </telerik:RadAjaxManagerProxy>
    <asp:ObjectDataSource ID="ODS_kodovani" runat="server" OldValuesParameterFormatString="original_{0}" TypeName="KSProgram.Funkce.F_String" SelectMethod="AllEncodings"></asp:ObjectDataSource>

    <asp:Panel runat="server" ID="P_ajax" BackColor="White" CssClass="ksprvek marginBottom">
        <telerik:RadWindow runat="server" ID="RW_info" AutoSizeBehaviors="HeightProportional" Width="400" AutoSize="true" Behaviors="Close,Move"
            VisibleStatusbar="false" >
            <ContentTemplate>
                <div style="padding: 5px">
                    <telerik:RadLabel runat="server" ID="RL_info"></telerik:RadLabel>
                </div>
            </ContentTemplate>
        </telerik:RadWindow>
        <div style="padding: 10px; text-align: center; width: 100%"><label class="nadpis1">[%Testování E-mailové komunikace%]</label></div>
        <fieldset class="ksprvek MTfieldset">
            <table cellpadding="2">
                <tr>
                    <td colspan="2">
                        <kspwc:TRadButton ID="RadButton2" runat="server" Text="[%Předvyplnit z parametrů aplikace KS portál%]" OnClick="RadButton2_Click" UseSubmitBehavior="false" CausesValidation="false">
                            <Icon PrimaryIconCssClass="fi fi-arrow-alt-to-right" />
                        </kspwc:TRadButton>
                        <kspwc:TRadButton ID="RadButton3" runat="server" Text="[%Zapsat do parametrů aplikace KS portál%]" OnClick="RadButton3_Click" UseSubmitBehavior="false" IdPrava="-1" CausesValidation="false">
                            <Icon PrimaryIconCssClass="fi fi-disk" />
                        </kspwc:TRadButton>
                    </td>
                </tr>
                <tr>
                    <td colspan="2">
                        <kspwc:TRadButton ID="RB_from_14" runat="server" Text="[%Předvyplnit z parametrů aplikace KS mzdy%]" OnClick="RB_from_14_Click" UseSubmitBehavior="false" CausesValidation="false" CssClass="kstlacitko">
                            <Icon PrimaryIconCssClass="fi fi-arrow-alt-to-right" />
                        </kspwc:TRadButton>
                        <kspwc:TRadButton ID="RB_to_14" runat="server" Text="[%Zapsat do parametrů aplikace KS mzdy%]" OnClick="RB_to_14_Click" UseSubmitBehavior="false" IdPrava="-1" CausesValidation="false">
                            <Icon PrimaryIconCssClass="fi fi-disk" />
                        </kspwc:TRadButton>
                    </td>
                </tr>
                <tr>
                    <td colspan="2">
                        <telerik:RadButton ID="RadButton1" runat="server" Text="[%Odeslat%]" OnClick="RadButton1_Click" UseSubmitBehavior="false" ValidationGroup="send" CssClass="kstlacitko">
                            <Icon PrimaryIconCssClass="fi fi-envelope" />
                        </telerik:RadButton>
                    </td>
                </tr>
                <tr class="ksIsNotCloud">
                    <td><u>
                        <asp:Label runat="server" ID="L_smtp">SMTP</asp:Label></u>
                        <telerik:RadToolTip runat="server" CssClass="ksTooltip" ID="RadToolTip4" ShowEvent="onmouseover" HideEvent="LeaveTargetAndToolTip"
                            Position="MiddleRight" RelativeTo="Element" Animation="None" ShowDelay="0" TargetControlID="L_smtp" AutoCloseDelay="0">
                            [%Adresa SMTP serveru pro odesílání%]
                        </telerik:RadToolTip>
                    </td>
                    <td>
                        <telerik:RadTextBox ID="RTB_smpt" runat="server" Width="300px">
                        </telerik:RadTextBox>
                        <b><asp:RequiredFieldValidator runat="server" ID="RFV_smpt_ping" ControlToValidate="RTB_smpt" Display="Dynamic" ValidationGroup="ping"></asp:RequiredFieldValidator></b>
                        <b><asp:RequiredFieldValidator runat="server" ID="RFV_smpt_auth" ControlToValidate="RTB_smpt" Display="Dynamic" ValidationGroup="auth"></asp:RequiredFieldValidator></b>
                        <b><asp:RequiredFieldValidator runat="server" ID="RFV_smpt_send" ControlToValidate="RTB_smpt" Display="Dynamic" ValidationGroup="send"></asp:RequiredFieldValidator></b>
                        <telerik:RadButton ID="RTB_ping" runat="server" Text="Ping" OnClick="RTB_ping_Click" UseSubmitBehavior="false" ValidationGroup="ping" CssClass="kstlacitko">
                            <Icon PrimaryIconCssClass="fi fi-network" />
                        </telerik:RadButton>
                    </td>
                </tr>
                <tr class="ksIsNotCloud">
                    <td><u>
                        <asp:Label runat="server" ID="L_port">Port</asp:Label></u>
                        <telerik:RadToolTip runat="server" ID="RadToolTip3" CssClass="ksTooltip" ShowEvent="onmouseover" HideEvent="LeaveTargetAndToolTip"
                            Position="MiddleRight" RelativeTo="Element" Animation="None" ShowDelay="0" TargetControlID="L_port" AutoCloseDelay="0">
                            [%Port pro komunikaci se SMTP serverem%]<br />
                            [%Příklady:%]<br />
                            [%Bez SSL%] - 25<br />
                            SSL - 465, 587
                        </telerik:RadToolTip>
                    </td>
                    <td>
                        <telerik:RadNumericTextBox ID="RTB_port" runat="server" Width="300px" Type="Number" MinValue="0" MaxValue='<%# Int32.MaxValue %>' >
                            <NumberFormat DecimalDigits="0" GroupSeparator=""/>
                        </telerik:RadNumericTextBox>
                        <b><asp:RequiredFieldValidator runat="server" ID="RFV_port_auth" ControlToValidate="RTB_port" Display="Dynamic" ValidationGroup="auth"></asp:RequiredFieldValidator></b>
                        <b><asp:RequiredFieldValidator runat="server" ID="RFV_port_send" ControlToValidate="RTB_port" Display="Dynamic" ValidationGroup="send"></asp:RequiredFieldValidator></b>
                    </td>
                </tr>
                <tr class="ksIsNotCloud">
                    <td>[%Uživatel%]</td>
                    <td>
                        <telerik:RadTextBox ID="RTB_user" runat="server" Width="300px">
                        </telerik:RadTextBox>
                    </td>
                </tr>
                <tr class="ksIsNotCloud">
                    <td>
                        <u>
                            <asp:Label runat="server" ID="L_pass">[%Heslo%]</asp:Label>
                        </u>
                        <telerik:RadToolTip runat="server" ID="RadToolTip6" CssClass="ksTooltip" Width="210" ShowEvent="onmouseover" HideEvent="LeaveTargetAndToolTip"
                            Position="MiddleRight" RelativeTo="Element" Animation="None" ShowDelay="0" TargetControlID="L_pass" AutoCloseDelay="0">
                            <%= KSProgram.Parametry.VychoziSlovnik["Email Heslo"].Popis %>
                        </telerik:RadToolTip>
                    </td>
                    <td>
                        <telerik:RadTextBox ID="RTB_pass" runat="server" Width="300px" DisplayText="[%Kliknutím zobrazíte heslo%]">
                        </telerik:RadTextBox>
                    </td>
                </tr>
                <tr class="ksIsNotCloud">
                    <td>Domain</td>
                    <td>
                        <telerik:RadTextBox ID="RTB_domena" runat="server" Width="300px">
                        </telerik:RadTextBox>
                    </td>
                </tr>
                <tr class="ksIsNotCloud">
                    <td>SSL</td>
                    <td>
                        <kspwc:TRadioButtonList ID="TRBL_ssl" runat="server" RepeatDirection="Horizontal" AutoPostBack="true" OnSelectedIndexChanged="TRBL_ssl_SelectedIndexChanged">
                            <asp:ListItem Text="[%Ano%]" Value="true">
                            </asp:ListItem>
                            <asp:ListItem Text="[%Ne%]" Value="false" Selected="True">
                            </asp:ListItem>
                        </kspwc:TRadioButtonList>
                    </td>
                </tr>
                <tr class="ksIsNotCloud">
                    <td>
                        <u><asp:Label runat="server" ID="L_ssl_protocols">SSL Protocols</asp:Label></u>&nbsp
                        <a target="_blank" href='https://docs.microsoft.com/en-us/dotnet/api/system.security.authentication.sslprotocols'>?</a>
                        <telerik:RadToolTip runat="server" ID="RadToolTip1" CssClass="ksTooltip" Width="300px" ShowEvent="onmouseover" HideEvent="LeaveTargetAndToolTip"
                            Position="MiddleRight" RelativeTo="Element" Animation="None" ShowDelay="0" TargetControlID="L_ssl_protocols" AutoCloseDelay="0">
                            <%= KSProgram.Parametry.VychoziSlovnik["Email SSL Protocols"].Popis %>
                        </telerik:RadToolTip>
                    </td>
                    <td>
                        <asp:ObjectDataSource ID="ODS_ssl_protocols" runat="server" SelectMethod="GetSSLProtocols" TypeName="KSProgram.Email.MailKitClient"></asp:ObjectDataSource>
                        <kspwc:TCheckBoxList ID="TCBL_ssl_protocols" runat="server" RepeatDirection="Horizontal" DataSourceID="ODS_ssl_protocols" AutoPostBack="true"
                            OnSelectedIndexChanged="TCBL_ssl_protocols_SelectedIndexChanged"
                            DataTextField="item2" DataValueField="item1">
                        </kspwc:TCheckBoxList>
                    </td>
                </tr>
                <tr class="ksIsNotCloud">
                    <td>
                        <u><asp:Label runat="server" ID="L_ssl_options">SSL Options</asp:Label></u>&nbsp
                        <a target="_blank" href='http://www.mimekit.net/docs/html/T_MailKit_Security_SecureSocketOptions.htm'>?</a>
                        <telerik:RadToolTip runat="server" ID="RadToolTip2" CssClass="ksTooltip" Width="300px" ShowEvent="onmouseover" HideEvent="LeaveTargetAndToolTip"
                            Position="MiddleRight" RelativeTo="Element" Animation="None" ShowDelay="0" TargetControlID="L_ssl_options" AutoCloseDelay="0">
                            <%= KSProgram.Parametry.VychoziSlovnik["Email SSL Options"].Popis %>
                        </telerik:RadToolTip>
                    </td>
                    <td>
                        <asp:ObjectDataSource ID="ODS_ssl_options" runat="server" SelectMethod="GetSSLOptions" TypeName="KSProgram.Email.MailKitClient"></asp:ObjectDataSource>
                        <kspwc:TRadioButtonList ID="TRBL_ssl_options" runat="server" RepeatDirection="Horizontal" DataSourceID="ODS_ssl_options" AutoPostBack="true"
                            DataTextField="item2" DataValueField="item1" OnSelectedIndexChanged="TRBL_ssl_options_SelectedIndexChanged">
                        </kspwc:TRadioButtonList>
                    </td>
                </tr>
                <tr class="ksIsNotCloud">
                    <td>Use Default Credencials</td>
                    <td>
                        <kspwc:TRadioButtonList ID="TRBL_def_cred" runat="server" RepeatDirection="Horizontal">
                            <asp:ListItem Text="[%Ano%]" Value="true">
                            </asp:ListItem>
                            <asp:ListItem Text="[%Ne%]" Value="false" Selected="True">
                            </asp:ListItem>
                        </kspwc:TRadioButtonList>
                    </td>
                </tr>
                <tr class="ks-oauth2 ksIsNotCloud">
                    <td>OAuth</td>
                    <td>
                        <asp:ObjectDataSource ID="ODS_oauth" runat="server" SelectMethod="GetOAuthMethods" TypeName="KSProgram.Email.MailKitClient"></asp:ObjectDataSource>
                        <kspwc:TRadioButtonList ID="TRBL_oauth" runat="server" RepeatDirection="Horizontal" DataSourceID="ODS_oauth" AutoPostBack="true"
                            DataTextField="item2" DataValueField="item1" DefaultValue="0" OnSelectedIndexChanged="TRBL_oauth_SelectedIndexChanged">
                        </kspwc:TRadioButtonList>
                    </td>
                </tr>
                <tr class="ks-oauth2 ksIsNotCloud">
                    <td>OAuth ClientId</td>
                    <td>
                        <telerik:RadTextBox ID="RTB_clientId" runat="server" Width="300px">
                        </telerik:RadTextBox>
                    </td>
                </tr>
                <tr class="ks-oauth2 ksIsNotCloud">
                    <td>OAuth ClientSecret</td>
                    <td>
                        <telerik:RadTextBox ID="RTB_clientSecret" runat="server" Width="300px" DisplayText="[%Kliknutím zobrazíte kód%]">
                        </telerik:RadTextBox>
                    </td>
                </tr>
                <tr class="ks-oauth2 ksIsNotCloud">
                    <td>OAuth TenantId</td>
                    <td>
                        <telerik:RadTextBox ID="RTB_tenantId" runat="server" Width="300px">
                        </telerik:RadTextBox>
                    </td>
                </tr>
                <tr class="ks-oauth2 ksIsNotCloud">
                    <td>OAuth Scopes</td>
                    <td>
                        <telerik:RadTextBox ID="RTB_csopes" runat="server" Width="300px">
                        </telerik:RadTextBox>
                    </td>
                </tr>
                <tr>
                    <td></td>
                    <td>
                        <telerik:RadButton ID="RB_connect" runat="server" Text="[%Připojení%]" UseSubmitBehavior="false" OnClick="RB_connect_Click" ValidationGroup="auth" CssClass="kstlacitko">
                            <Icon PrimaryIconCssClass="fi fi-network" />
                        </telerik:RadButton>
                        <telerik:RadToolTip runat="server" ID="RadToolTip7" CssClass="ksTooltip" Width="210" ShowEvent="onmouseover" HideEvent="LeaveTargetAndToolTip"
                            Position="MiddleRight" RelativeTo="Element" Animation="None" ShowDelay="0" TargetControlID="RB_connect" AutoCloseDelay="0">
                            [%Otestuje připojení se serverem a zobrazí získané informace%]
                        </telerik:RadToolTip>
                        <telerik:RadButton ID="RB_authenticate" runat="server" Text="[%Ověření%]" UseSubmitBehavior="false" OnClick="RB_authenticate_Click" ValidationGroup="auth" CssClass="kstlacitko">
                            <Icon PrimaryIconCssClass="fi fi-key" />
                        </telerik:RadButton>
                        <telerik:RadToolTip runat="server" ID="RadToolTip8" CssClass="ksTooltip" Width="210" ShowEvent="onmouseover" HideEvent="LeaveTargetAndToolTip"
                            Position="MiddleRight" RelativeTo="Element" Animation="None" ShowDelay="0" TargetControlID="RB_authenticate" AutoCloseDelay="0">
                            [%Otestuje připojení včetně ověření a zobrazí získané informace%]
                        </telerik:RadToolTip>
                    </td>
                </tr>
                <tr>
                    <td>Encoding</td>
                    <td>
                        <kspwc:TRadComboBox runat="server" ID="RCB_codepages" DataTextField="DisplayName" DataValueField="CodePage" OnItemDataBound="RCB_codepages_ItemDataBound" EnableLoadOnDemand="true" DataSourceID="ODS_kodovani" DropDownCssClass="exampleRadComboBox" Width="460px" HighlightTemplatedItems="true">
                            <HeaderTemplate>
                                <ul>
                                    <li class="col1">[%Číslo%]</li>
                                    <li class="col2">[%Název%]</li>
                                    <li class="col3">[%Popis%]</li>
                                </ul>
                            </HeaderTemplate>
                            <ItemTemplate>
                                <ul>
                                    <li class="col1">
                                        <%# DataBinder.Eval(Container.DataItem, "CodePage") %></li>
                                    <li class="col2">
                                        <%# DataBinder.Eval(Container.DataItem, "Name") %></li>
                                    <li class="col3">
                                        <%# DataBinder.Eval(Container.DataItem, "DisplayName") %></li>
                                </ul>
                            </ItemTemplate>
                        </kspwc:TRadComboBox>
                    </td>
                </tr>
                <tr>
                    <td>[%Tělo je HTML%]</td>
                    <td>
                        <kspwc:TRadioButtonList ID="TRBL_isBodyHtml" runat="server" RepeatDirection="Horizontal">
                            <asp:ListItem Text="[%Ano%]" Value="true" Selected="True">
                            </asp:ListItem>
                            <asp:ListItem Text="[%Ne%]" Value="false">
                            </asp:ListItem>
                        </kspwc:TRadioButtonList>
                    </td>
                </tr>
                <tr>
                    <td>[%Podpisový certifikát%]</td>
                    <td>
                        <telerik:RadTextBox ID="RTB_cert" runat="server" Width="300px" EmptyMessage="[%Cesta k uloženému podpisovému certifikátu (.p12)%]">
                        </telerik:RadTextBox>
                    </td>
                </tr>
                <tr>
                    <td>[%Heslo certifikátu%]</td>
                    <td>
                        <telerik:RadTextBox ID="RTB_cert_pass" runat="server" Width="300px" DisplayText="[%Kliknutím zobrazíte heslo%]">
                        </telerik:RadTextBox>
                    </td>
                </tr>
                <tr>
                    <td><u>
                        <asp:Label runat="server" ID="L_useAS">[%Použij aplikační server%]</asp:Label></u>
                        <telerik:RadToolTip runat="server" ID="RadToolTip5" CssClass="ksTooltip" Width="210" ShowEvent="onmouseover" HideEvent="LeaveTargetAndToolTip"
                            Position="MiddleRight" RelativeTo="Element" Animation="None" ShowDelay="0" TargetControlID="L_useAS" AutoCloseDelay="0">
                            [%Zda má být E-mail pouze uložen pro pozdější odeslání aplikačním serverem nebo přímo odeslán bez využití aplikačního serveru%]
                        </telerik:RadToolTip>
                    </td>
                    <td>
                        <kspwc:TRadioButtonList ID="TRB_as" runat="server" RepeatDirection="Horizontal" AutoPostBack="true" OnSelectedIndexChanged="TRB_as_SelectedIndexChanged">
                            <asp:ListItem Text="[%Ano%]" Value="true">
                            </asp:ListItem>
                            <asp:ListItem Text="[%Ne%]" Value="false">
                            </asp:ListItem>
                        </kspwc:TRadioButtonList>
                    </td>
                </tr>
                <tr>
                    <td>[%Adresa od%]</td>
                    <td>
                        <telerik:RadTextBox ID="RTB_from" runat="server" Width="300px">
                        </telerik:RadTextBox>
                        <b><asp:RequiredFieldValidator runat="server" ID="FRV_from" ControlToValidate="RTB_from" Display="Dynamic" ValidationGroup="send"></asp:RequiredFieldValidator></b>
                    </td>
                </tr>
                <tr>
                    <td>[%Adresa komu%]</td>
                    <td>
                        <telerik:RadTextBox ID="RTB_to" runat="server" Width="300px">
                        </telerik:RadTextBox>
                        <b><asp:RequiredFieldValidator runat="server" ID="RFV_to" ControlToValidate="RTB_to" Display="Dynamic" ValidationGroup="send"></asp:RequiredFieldValidator></b>
                    </td>
                </tr>
                <tr>
                    <td>[%Předmět%]</td>
                    <td>
                        <telerik:RadTextBox ID="RTB_sub" runat="server" Width="300px">
                        </telerik:RadTextBox>
                        <b><asp:RequiredFieldValidator runat="server" ID="RFV_sub_send" ControlToValidate="RTB_sub" Display="Dynamic" ValidationGroup="send"></asp:RequiredFieldValidator></b>
                    </td>
                </tr>
                <tr>
                    <td colspan="2">
                        <telerik:RadButton ID="RadButton4" runat="server" Text="[%Odeslat%]" OnClick="RadButton1_Click" UseSubmitBehavior="false" ValidationGroup="send" CssClass="kstlacitko">
                            <Icon PrimaryIconCssClass="fi fi-envelope" />
                        </telerik:RadButton>
                    </td>
                </tr>
                <tr>
                    <td colspan="2">
                        <telerik:RadEditor ID="RadEditor1" runat="server" ToolbarMode="RibbonBar" ToolsFile="MailTestEditorTools.xml"
                            ContentFilters="DefaultFilters,RemoveScripts,EncodeScripts,StripCssExpressions,StripDomEventAttributes">
                        </telerik:RadEditor>
                    </td>
                </tr>
                <tr>
                    <td>[%Přílohy%]
                    </td>
                    <td>
                        <telerik:RadAsyncUpload runat="server" ID="AsyncUpload1" PostbackTriggers="RadButton1,RadButton4" TemporaryFolder="~/Temp" OnFileUploaded="AsyncUpload1_FileUploaded" />
                    </td>
                </tr>
            </table>
        </fieldset>
    </asp:Panel>
</asp:Content>
