﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Main.Master" AutoEventWireup="true"
    CodeBehind="Uzivatele.aspx.cs" Inherits="KSPortal.Obecne.Uzivatele" %>

<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>
<asp:Content ID="Content1" ContentPlaceHolderID="HeadContent" runat="server">
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="HlavniOblast" runat="server">
    <asp:Label ID="Lb_warn" runat="server" ForeColor="Red" />
    <telerik:RadAjaxManagerProxy runat="server" ID="RAMP">
        <AjaxSettings>
            <telerik:AjaxSetting AjaxControlID="RG_Users">
                <UpdatedControls>
                    <telerik:AjaxUpdatedControl ControlID="RG_Users" />
                </UpdatedControls>
            </telerik:AjaxSetting>
        </AjaxSettings>
    </telerik:RadAjaxManagerProxy>
    <telerik:RadPersistenceManagerProxy runat="server" ID="RPMP">
        <PersistenceSettings>
            <telerik:PersistenceSetting ControlID="RG_Users" />
        </PersistenceSettings>
    </telerik:RadPersistenceManagerProxy>
    <asp:ObjectDataSource ID="ODS_Users" runat="server" OldValuesParameterFormatString="original_{0}"
        SelectMethod="GetAllUsers" TypeName="KSProgram.Prava.PortalUsers" InsertMethod="InsertUser"
        UpdateMethod="UpdateUser" DeleteMethod="DeleteUser" ConflictDetection="OverwriteChanges">
        <SelectParameters>
            <asp:Parameter Name="ZdrojOsCisla" Type="Boolean" DefaultValue="false" />
        </SelectParameters>
        <InsertParameters>
            <asp:Parameter Name="hesloOd" Type="DateTime" />
        </InsertParameters>
        <UpdateParameters>
            <asp:Parameter Name="hesloOd" Type="DateTime" />
            <%--<asp:Parameter Name="original_hesloOd" Type="DateTime" />--%>
        </UpdateParameters>
        <DeleteParameters>
            <%--<asp:Parameter Name="original_hesloOd" Type="DateTime" />--%>
        </DeleteParameters>
    </asp:ObjectDataSource>
    <kspwc:TRadGrid ID="RG_Users" runat="server" DataSourceID="ODS_Users" GroupPanelPosition="Top"
        AutoGenerateColumns="False" AllowAutomaticDeletes="True" OnItemCommand="RG_Users_ItemCommand"
        AllowAutomaticInserts="True" AllowAutomaticUpdates="True" EnableHeaderContextFilterMenu="True"
        EnableHeaderContextMenu="True" AllowFilteringByColumn="True"
        AllowSorting="True" MasterTableView-CommandItemSettings-AddNewRecordText="[%Přidat nový záznam%]" AllowPaging="true" AutoFilterWidth="false" AutoFilterControlWidth="true">
        <MasterTableView DataSourceID="ODS_Users" DataKeyNames="osCislo,login" CommandItemDisplay="Top"
            Caption="[%Uživatelé s KS účtem%]" PageSize="20">
            <PagerStyle PageSizes="10,20,50,100,200,500,1000" />
            <CommandItemTemplate>
                <kspwc:GridCommandItemControl runat="server" ID="GCIC">
                    <AddNewItemButton runat="server" Visible="true"></AddNewItemButton>
                </kspwc:GridCommandItemControl>
                 <kspwc:TRadButton ID="TRB_Generovat" runat="server" Text="[%Generovat všem%]" Icon-PrimaryIconCssClass="fi fi-shield" CssClass="kstlacitko"
                     Style="margin-top: 2px;" AutoPostBack="true" ToolTip="[%Všem zaměstnancům bez authenticatoru vygeneruje a odešle kód na email%]"
                     Visible="<%# DvouFaktAuthenticator() %>" OnClick="TRB_Generovat_Click"></kspwc:TRadButton>
            </CommandItemTemplate>
            <Columns>
                <telerik:GridEditCommandColumn ButtonType="ImageButton" UniqueName="EditCommandColumn" Exportable="false">
                </telerik:GridEditCommandColumn>
                <telerik:GridNumericColumn DataField="osCislo" FilterControlAltText="Filter osCislo column"
                    HeaderText="[%Os. číslo%]" SortExpression="osCislo" UniqueName="osCislo" DecimalDigits="0"
                    MaxLength="10" ReadOnly="True">
                    <ColumnValidationSettings EnableRequiredFieldValidation="true">
                        <RequiredFieldValidator ForeColor="Red" ErrorMessage="*"></RequiredFieldValidator>
                    </ColumnValidationSettings>
                </telerik:GridNumericColumn>
                <telerik:GridTemplateColumn DataField="osCislo" HeaderText="[%Uživatel%]" UniqueName="insertOsCilo"
                    Display="False">
                    <ItemTemplate>
                        <%# Eval("osCislo") %>
                        <%# Eval("prijmeni") %>
                        <%# Eval("jmeno") %>
                    </ItemTemplate>
                    <InsertItemTemplate>
                        <kspwc:TRadComboBox ID="TRCB_insert_os_cislo" runat="server" EnableLoadOnDemand="True"
                            EnableVirtualScrolling="True" Height="150px" ShowMoreResultsBox="True" DropDownAutoWidth="Enabled"
                            EmptyMessage="[%Uživatel%]" AutoPostBack="True"
                            SelectedValue='<%# Bind("osCislo") %>'>
                            <WebServiceSettings Method="GetZamestnanci" Path="~/PrivateWebServices/AutoCompleteService.asmx" />
                        </kspwc:TRadComboBox>
                        <asp:RequiredFieldValidator ID="RFV_insert_os_cislo" runat="server" ControlToValidate="TRCB_insert_os_cislo"
                            Display="Dynamic" EnableClientScript="True" ErrorMessage="*"></asp:RequiredFieldValidator>
                        <asp:CustomValidator ID="CV_dupl_osc" runat="server" ControlToValidate="TRCB_insert_os_cislo" OnServerValidate="CV_dupl_osc_ServerValidate"></asp:CustomValidator>
                    </InsertItemTemplate>
                </telerik:GridTemplateColumn>
                <kspwc:GridFotoZamColumn UniqueName="foto" DataOsCisloField="osCislo"></kspwc:GridFotoZamColumn>
                <telerik:GridBoundColumn DataField="prijmeni" FilterControlAltText="Filter prijmeni column"
                    HeaderText="[%Příjmení%]" ReadOnly="True" SortExpression="prijmeni" UniqueName="prijmeni">
                </telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="jmeno" FilterControlAltText="Filter jmeno column"
                    HeaderText="[%Jméno%]" ReadOnly="True" SortExpression="jmeno" UniqueName="jmeno">
                </telerik:GridBoundColumn>
                <%--<telerik:GridBoundColumn DataField="login" FilterControlAltText="Filter login column"
                    HeaderText="[%Login%]" SortExpression="login" UniqueName="login" MaxLength="128">
                    <ColumnValidationSettings EnableRequiredFieldValidation="true">
                        <RequiredFieldValidator ForeColor="Red" ErrorMessage="*"></RequiredFieldValidator>
                    </ColumnValidationSettings>
                </telerik:GridBoundColumn>--%>
                <telerik:GridTemplateColumn DataField="login" FilterControlAltText="Filter login column"
                    HeaderText="[%Login%]" SortExpression="login" UniqueName="login">
                    <ItemTemplate>
                        <%# Eval("login") %>
                    </ItemTemplate>
                    <EditItemTemplate>
                        <telerik:RadTextBox ID="RTB_login" runat="server" Text='<%# Bind("login") %>' MaxLength="128"></telerik:RadTextBox>
                        <asp:RequiredFieldValidator ID="RFV_insert_login" runat="server" ControlToValidate="RTB_login"
                            Display="Dynamic" EnableClientScript="True" ErrorMessage="*"></asp:RequiredFieldValidator>
                        <asp:CustomValidator ID="CV_dupl_login" runat="server" ControlToValidate="RTB_login" OnServerValidate="CV_dupl_login_ServerValidate"></asp:CustomValidator>
                    </EditItemTemplate>
                </telerik:GridTemplateColumn>
                <%--<telerik:GridBoundColumn DataField="heslo" FilterControlAltText="Filter heslo column"
                    HeaderText="[%Heslo%]" SortExpression="heslo" UniqueName="heslo" Display="False"
                    Exportable="False" MaxLength="44">
                </telerik:GridBoundColumn>--%>
                <telerik:GridTemplateColumn DataField="heslo" FilterControlAltText="Filter heslo column"
                    HeaderText="[%Heslo%]" SortExpression="heslo" UniqueName="heslo" Display="False"
                    Exportable="False">
                    <EditItemTemplate>
                        <telerik:RadTextBox ID="RTB_heslo" runat="server" Text='<%# Bind("heslo") %>' MaxLength="44"></telerik:RadTextBox>
                        <asp:CustomValidator ID="CV_heslo" runat="server" ControlToValidate="RTB_heslo" OnServerValidate="CV_heslo_ServerValidate"></asp:CustomValidator>
                    </EditItemTemplate>
                </telerik:GridTemplateColumn>
                <telerik:GridDateTimeColumn DataField="hesloOd" FilterControlAltText="Filter hesloOd column"
                    HeaderText="[%Heslo platné od%]" SortExpression="hesloOd" UniqueName="hesloOd"
                    DataFormatString="{0:d}" DataType="System.DateTime">
                </telerik:GridDateTimeColumn>
                <telerik:GridBoundColumn DataField="spatneHeslo" FilterControlAltText="Filter spatneHeslo column"
                    HeaderText="[%Neplatné ověření hesla%]" ReadOnly="True" SortExpression="spatneHeslo"
                    UniqueName="spatneHeslo">
                </telerik:GridBoundColumn>
                <telerik:GridCheckBoxColumn DataField="zamek" FilterControlAltText="Filter zamek column"
                    HeaderText="[%Zamknuto%]" SortExpression="zamek" UniqueName="zamek">
                </telerik:GridCheckBoxColumn>
                <telerik:GridCheckBoxColumn DataField="aktivovan" FilterControlAltText="Filter aktivovan column"
                    HeaderText="[%Aktivován%]" SortExpression="aktivovan" UniqueName="aktivovan" DefaultInsertValue="true">
                </telerik:GridCheckBoxColumn>
                <telerik:GridTemplateColumn HeaderText="Authenticator" AllowFiltering="false" AllowSorting="true" ItemStyle-HorizontalAlign="Center" UniqueName="authenticator" Visible="true">
                    <ItemTemplate>
                        <%# GetIcon(Container.DataItem) %>
                    </ItemTemplate>
                </telerik:GridTemplateColumn>
                <telerik:GridTemplateColumn HeaderText="[%Generovat%]" AllowFiltering="false" AllowSorting="false" ItemStyle-HorizontalAlign="Center" UniqueName="generovat" Visible="true">
                    <ItemTemplate>
                        <kspwc:TRadButton runat="server" ID="SendQR" Icon-PrimaryIconCssClass="fi fi-paper-plane" ToolTip="[%Vygenerovat a odeslat nový kód pro Authenticator%]" CommandName="send"></kspwc:TRadButton>
                    </ItemTemplate>
                </telerik:GridTemplateColumn>
                <telerik:GridButtonColumn Text="Delete" CommandName="Delete" ButtonType="ImageButton" Exportable="false" />
            </Columns>
            <EditFormSettings>
                <EditColumn UniqueName="EditCommandColumn1" FilterControlAltText="Filter EditCommandColumn1 column" ButtonType="ImageButton">
                </EditColumn>
            </EditFormSettings>
        </MasterTableView>
    </kspwc:TRadGrid>
</asp:Content>
