﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Main.Master" AutoEventWireup="true" Inherits="Pozadavky_Workflow" CodeBehind="Workflow.aspx.cs" ValidateRequest="false" %>

<%@ Register Assembly="WebControls" Namespace="KSProgram.WebControls" TagPrefix="wc" %>
<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>
<%@ Register TagPrefix="uc" TagName="workfl_settings" Src="~/Controls/workfl_settings.ascx" %>
<asp:Content ID="Content1" ContentPlaceHolderID="HeadContent" runat="Server">
    <style type="text/css">
        .ruBrowse {
            width: 120px !important;
        }

        .DropZone, .DropZone2 {
            background-color: lightblue !important;
            padding: 10px;
        }

        .ruFakeInput {
            display: none;
            visibility: hidden;
        }

        .WFStep, .WFSideBar {
            padding: 10px;
        }

            .WFSideBar tr, .WFKroky tr {
                height: 40px;
            }

            .WFSideBar > a {
                display: none;
            }

        .WFKroky tr {
            height: 35px;
        }

        .WFKrokButton {
            padding: 5px;
            margin: 5px;
            border: #e0dfdf 1px solid;
            text-decoration: none;
            background: #fefefe;
            text-align: center;
            width: 100%;
            white-space: nowrap;
        }

        .WFSideBar a {
            white-space: nowrap;
        }

        .WFSaveButton {
            position: absolute !important;
            margin-left: 11px;
            margin-top: 214px;
        }
    </style>
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="HlavniOblast" runat="Server">
    <asp:HiddenField ID="HF_ScreenWidth" runat="server" />
    <telerik:RadScriptBlock runat="server" ID="wfjs">
        <script type="text/javascript">
            //<![CDATA[
            var diagram;

            function diagramLoad(sender) {
                diagram = sender.get_kendoWidget();

                //diagram.layout({
                //    type: "tree",
                //    subtype: "left",
                //    roots: [diagram.getShapeById("nadal_winner")],
                //    verticalSeparation: 20,
                //    horizontalSeparation: 30
                //});
            }

            function diagExportToImage() {
                diagram.exportImage().done(function (data) {
                    kendo.saveAs({
                        dataURI: data,
                        fileName: "diagram.png"
                    });
                });
            }

            function diagExportToSVG() {
                diagram.exportSVG().done(function (data) {
                    kendo.saveAs({
                        dataURI: data,
                        fileName: "diagram.svg"
                    });
                });
            }

            function diagExportToPDF() {
                //diagram.exportPDF({
                //    paperSize: "A4",
                //    landscape: true
                //}).done(function (data) {
                //    kendo.saveAs({
                //        dataURI: data,
                //        fileName: "diagram.pdf"
                //    });
                //});
                diagram.saveAsPDF();
            }

            function getScreenWidth() {
                var width = window.Width;
                document.getElementById('<%= HF_ScreenWidth.ClientID %>').value = width;
            }

            $(document).ready(getScreenWidth);
            //]]>
        </script>
    </telerik:RadScriptBlock>
    <telerik:RadClientExportManager runat="server" ID="RadClientExportManager1"></telerik:RadClientExportManager>

    <telerik:RadAjaxManagerProxy runat="server" ID="ajax_manager">
        <AjaxSettings>
            <telerik:AjaxSetting AjaxControlID="rg_sestava">
                <UpdatedControls>
                    <telerik:AjaxUpdatedControl ControlID="rg_sestava"></telerik:AjaxUpdatedControl>
                </UpdatedControls>
            </telerik:AjaxSetting>
        </AjaxSettings>
    </telerik:RadAjaxManagerProxy>
    <kspwc:TRadButton runat="server" ID="TRB_Save" OnClick="TRB_Save_Click" Visible="false" Text="[%Uložit%]" Icon-PrimaryIconCssClass="fi fi-disk" CssClass="WFSaveButton kstlacitko"></kspwc:TRadButton>
    <asp:Wizard ID="wizm" runat="server" ActiveStepIndex="1"
        OnActiveStepChanged="wizm_ActiveStepChanged"
        OnFinishButtonClick="wizm_FinishButtonClick" CssClass="ksprvek"
        FinishCompleteButtonText="Uložit" FinishPreviousButtonText="Zpět"
        StartNextButtonText="Následující" StepNextButtonText="Následující"
        StepPreviousButtonText="Zpět">
        <HeaderStyle BackColor="#E0E0E0"></HeaderStyle>
        <HeaderTemplate>
            <table>
                <tr>
                    <td>
                        <asp:Label ID="Label_header" Text="Konfigurace workflow" runat="Server" Font-Size="12pt" Font-Bold="True" CssClass="tiskHide" />
                    </td>
                    <td>
                        <asp:Label ID="Label_druh" Text="" runat="Server" Font-Size="12pt" Font-Bold="True" CssClass="tiskHide" />
                    </td>
                </tr>
            </table>
        </HeaderTemplate>
        <NavigationStyle BackColor="#E0E0E0" CssClass="tiskHide WFNavigation"></NavigationStyle>
        <SideBarStyle VerticalAlign="Top" BackColor="#E0E0E0" Width="150" CssClass="tiskHide WFSideBar"></SideBarStyle>
        <StepStyle VerticalAlign="Top" HorizontalAlign="Left" Width="1400" Height="300" CssClass="WFStep"></StepStyle>

        <WizardSteps>
            <asp:WizardStep ID="WizardStep0" runat="server" Title="Typ workflow">
                <table style="border-collapse: collapse">
                    <tr>
                        <td>
                            <asp:Label runat="server" ID="lab_start_info" Text="Vyberte prosím typ workflow"></asp:Label>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            <asp:ObjectDataSource ID="ds_typ" runat="server" OldValuesParameterFormatString="original_{0}"
                                SelectMethod="GetTypy" TypeName="KSProgram.Pozadavky.PozadavkyTypy">
                                <SelectParameters>
                                    <asp:Parameter DefaultValue="false" Name="vcetne_vse" Type="Boolean" />
                                    <asp:Parameter DefaultValue="true" Name="vcetne_dochazka" Type="Boolean" />
                                    <asp:Parameter DefaultValue="false" Name="emptyRow" Type="Boolean" />
                                </SelectParameters>
                            </asp:ObjectDataSource>
                            <asp:DropDownList ID="ddl_typ" runat="server" DataSourceID="ds_typ" DataTextField="typ_text"
                                DataValueField="typ" OnSelectedIndexChanged="ddl_typ_SelectedIndexChanged"
                                AutoPostBack="True" OnDataBound="ddl_typ_DataBound">
                            </asp:DropDownList>
                        </td>
                        <%-- <td style="padding-left:30px;">
                           
                       </td>--%>
                    </tr>
                </table>
                <br />
                <br />
                <fieldset id="Fieldset2" runat="server">
                    <legend>[%Export definice nastavení%]</legend>
                    <table class="InnerTableFormFieldset" runat="server" id="table1">
                        <tr>
                            <td>
                                <telerik:RadAjaxPanel ID="RadAjaxPanel1" PostBackControls="export" runat="server">
                                    <kspwc:TCheckBox runat="server" ID="rb_all" Text="[%Všechny definice%]" />
                                    <kspwc:TRadButton runat="server" ID="export" Text="[%Generování XML souboru%]" OnClick="export_Click" Icon-PrimaryIconCssClass="fi fi-file-export"></kspwc:TRadButton>
                                </telerik:RadAjaxPanel>
                            </td>
                        </tr>
                    </table>
                </fieldset>


            </asp:WizardStep>
            <asp:WizardStep ID="wizm1" runat="server" Title="Org. struktura">
                <table>
                    <tr>
                        <td>
                            <asp:Label runat="server" ID="Label_os" Text="Organizační strukturu pro schvalování"></asp:Label>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            <asp:ObjectDataSource ID="ds_stromy" runat="server" TypeName="KSProgram.OrgStru.OrgStruktura" SelectMethod="SeznamStruktur">
                                <SelectParameters>
                                    <asp:Parameter Name="keDni" Type="DateTime" />
                                    <asp:Parameter Name="addEmtpyRow" Type="Boolean" DefaultValue="true" />
                                </SelectParameters>
                            </asp:ObjectDataSource>
                            <asp:DropDownList ID="ddl_stromy" runat="server" DataSourceID="ds_stromy"
                                DataTextField="nazev" DataValueField="kod" OnDataBound="ddl_stromy_DataBound">
                            </asp:DropDownList>
                        </td>
                    </tr>
                </table>
            </asp:WizardStep>
            <asp:WizardStep ID="wizm2" runat="server" Title="Fáze">
                <%--//PR 12.9.2017 pokud je ve stránce 20 objektů workfl_settings, viewstate má přes 10 MB.
                    Proto předěláno, workfl_settings zůstává jen 1x, hodnoty pro jednotlivé kroky se ukládají do session, než se uloží--%>
                <table style="" cellpadding="0" cellspacing="0">
                    <tr>
                        <td style="vertical-align: top; width: fit-content; padding: 10px;" class="WFKroky">
                            <asp:DataList ID="DL_Kroky" runat="server">
                                <ItemTemplate>
                                    <asp:LinkButton ID="btn_krok" runat="server" Text='<%# Eval("faze_text") %>' CommandName="setkrok" CommandArgument='<%# Eval("faze") %>' OnCommand="btn_krok_Command" CssClass="WFKrokButton" />
                                </ItemTemplate>
                                <FooterTemplate>
                                    <asp:Label ID="lb_pocK" runat="server" Text="[%Počet kroků%]" Font-Bold="True" />
                                    <wc:TTextBox ID="TB_PocetKroku" runat="server" OnTextChanged="TB_PocetKroku_TextChanged" AutoPostBack="True" Width="30px" />
                                </FooterTemplate>
                            </asp:DataList>
                        </td>
                        <td>
                            <uc:workfl_settings runat="server" ID="WfSet" Krok="1" />
                            <asp:Button Text="[%Vložit dalších 5 prázdných řádků%]" runat="server" ID="rb_add5rows" OnCommand="rb_add5rows_Command" Style="margin: 4px;" />

                        </td>
                    </tr>
                    <tr style="background-color: #808080">
                        <td></td>
                        <td style="padding: 10px; text-align: right">
                            <asp:Button ID="btn_krok_prev" runat="server" Text="Předchozí" CommandName="setkrok" CommandArgument="prev" OnCommand="btn_krok_Command" CssClass="kstlacitko" />
                            <asp:Button ID="btn_krok_next" runat="server" Text="Následující" CommandName="setkrok" CommandArgument="next" OnCommand="btn_krok_Command" CssClass="kstlacitko" />
                        </td>
                    </tr>
                </table>
                <%--<asp:Wizard ID="wiz_step" runat="server" SideBarStyle-VerticalAlign="Top" 
                    StepStyle-VerticalAlign="Top" ActiveStepIndex="-1" 
                    FinishCompleteButtonText="Hotovo" FinishPreviousButtonText="Zpět" 
                    StartNextButtonText="Následující" StepNextButtonText="Následující" 
                    StepPreviousButtonText="Zpět" 
                    OnInit="wiz_step_Init"
                    OnActiveStepChanged="wiz_step_ActiveStepChanged" >
                    <NavigationStyle BackColor="Gray" />
                    <SideBarButtonStyle ForeColor="White" BorderStyle="Solid" BorderColor="#999999" BackColor="Gray" BorderWidth="1px" />
                    <SideBarStyle VerticalAlign="Top" BackColor="Gray" ForeColor="White" 
                        HorizontalAlign="Center" Width="400"></SideBarStyle>
                    <StepStyle VerticalAlign="Top"></StepStyle>
                    <WizardSteps>
                        <asp:WizardStep ID="step1" runat="server" Title="Krok 1">
                            <uc:workfl_settings runat="server" ID="ws1" Krok="1" />
                        </asp:WizardStep>
                        <asp:WizardStep ID="step2" runat="server" Title="Krok 2">
                            <uc:workfl_settings runat="server" ID="ws2" Krok="2" Visible="false" />
                        </asp:WizardStep>
                        <asp:WizardStep ID="step3" runat="server" Title="Krok 3">
                            <uc:workfl_settings runat="server" ID="ws3" Krok="3" Visible="false" />
                        </asp:WizardStep>
                        <asp:WizardStep ID="step4" runat="server" Title="Krok 4">
                            <uc:workfl_settings runat="server" ID="ws4" Krok="4" Visible="false" />
                        </asp:WizardStep>
                        <asp:WizardStep ID="step5" runat="server" Title="Krok 5">
                            <uc:workfl_settings runat="server" ID="ws5" Krok="5" Visible="false" />
                        </asp:WizardStep>
                        <asp:WizardStep ID="step6" runat="server" Title="Krok 6">
                            <uc:workfl_settings runat="server" ID="ws6" Krok="6" Visible="false" />
                        </asp:WizardStep>
                        <asp:WizardStep ID="step7" runat="server" Title="Krok 7">
                            <uc:workfl_settings runat="server" ID="ws7" Krok="7" Visible="false" />
                        </asp:WizardStep>
                        <asp:WizardStep ID="step8" runat="server" Title="Krok 8">
                            <uc:workfl_settings runat="server" ID="ws8" Krok="8" Visible="false" />
                        </asp:WizardStep>
                        <asp:WizardStep ID="step9" runat="server" Title="Krok 9">
                            <uc:workfl_settings runat="server" ID="ws9" Krok="9" Visible="false" />
                        </asp:WizardStep>
                        <asp:WizardStep ID="step10" runat="server" Title="Krok 10">
                            <uc:workfl_settings runat="server" ID="ws10" Krok="10" Visible="false" />
                        </asp:WizardStep>
                        <asp:WizardStep ID="step11" runat="server" Title="Krok 11">
                            <uc:workfl_settings runat="server" ID="ws11" Krok="11" Visible="false" />
                        </asp:WizardStep>
                        <asp:WizardStep ID="step12" runat="server" Title="Krok 12">
                            <uc:workfl_settings runat="server" ID="ws12" Krok="12" Visible="false" />
                        </asp:WizardStep>                       
                        <asp:WizardStep ID="step13" runat="server" Title="Krok 13">
                            <uc:workfl_settings runat="server" ID="ws13" Krok="13" Visible="false" />
                        </asp:WizardStep>        
                        <asp:WizardStep ID="step14" runat="server" Title="Krok 14">
                            <uc:workfl_settings runat="server" ID="ws14" Krok="14" Visible="false" />
                        </asp:WizardStep>        
                        <asp:WizardStep ID="step15" runat="server" Title="Krok 15">
                            <uc:workfl_settings runat="server" ID="ws15" Krok="15" Visible="false" />
                        </asp:WizardStep>        
                        <asp:WizardStep ID="step16" runat="server" Title="Krok 16">
                            <uc:workfl_settings runat="server" ID="ws16" Krok="16" Visible="false" />
                        </asp:WizardStep>        
                        <asp:WizardStep ID="step17" runat="server" Title="Krok 17">
                            <uc:workfl_settings runat="server" ID="ws17" Krok="17" Visible="false" />
                        </asp:WizardStep>        
                        <asp:WizardStep ID="step18" runat="server" Title="Krok 18">
                            <uc:workfl_settings runat="server" ID="ws18" Krok="18" Visible="false" />
                        </asp:WizardStep>        
                        <asp:WizardStep ID="step19" runat="server" Title="Krok 19">
                            <uc:workfl_settings runat="server" ID="ws19" Krok="19" Visible="false" />
                        </asp:WizardStep>        
                        <asp:WizardStep ID="step20" runat="server" Title="Krok 20">
                            <uc:workfl_settings runat="server" ID="ws20" Krok="20" Visible="false" />
                        </asp:WizardStep>                       
                         
                            //PR 21.4.2017 PŘIDAL JSEM PODMÍNKY A VIEWSTATE UŽ PŘETÉKÁ PŘES <requestLimits maxAllowedContentLength="10485760"/>‭‬
                           
                        <asp:WizardStep ID="step21" runat="server" Title="Krok 21">
                            <uc:workfl_settings runat="server" ID="ws21" Krok="21" Visible="false" />
                        </asp:WizardStep>               
                         <asp:WizardStep ID="step22" runat="server" Title="Krok 22">
                            <uc:workfl_settings runat="server" ID="ws22" Krok="22" Visible="false" />
                        </asp:WizardStep>               
                         <asp:WizardStep ID="step23" runat="server" Title="Krok 23">
                            <uc:workfl_settings runat="server" ID="ws23" Krok="23" Visible="false" />
                        </asp:WizardStep>               
                         <asp:WizardStep ID="step24" runat="server" Title="Krok 24">
                            <uc:workfl_settings runat="server" ID="ws24" Krok="24" Visible="false" />
                        </asp:WizardStep>               
                         <asp:WizardStep ID="step25" runat="server" Title="Krok 25">
                            <uc:workfl_settings runat="server" ID="ws25" Krok="25" Visible="false" />
                        </asp:WizardStep>                                         
                    </WizardSteps>
                </asp:Wizard>--%>
            </asp:WizardStep>
            <asp:WizardStep ID="wizm3" Title="Společná nastavení">
                <table>
                    <tr>
                        <td>
                            <asp:Label runat="server" ID="lab_service1" Text="[%Počet hodin, pro začátek odesílání upozornění o vypršení požadavku%]:"></asp:Label>
                        </td>
                        <td>
                            <asp:TextBox runat="server" ID="text_start" Width="30" MaxLength="3" Text='<%# _zacatek() %>'></asp:TextBox>
                            <asp:RegularExpressionValidator ID="RegularExpressionValidator1" runat="server" ControlToValidate="text_start" ErrorMessage="[%Prosím zadávejte jen číslice%]" ValidationExpression="^\d+$"></asp:RegularExpressionValidator>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            <asp:Label runat="server" ID="Label1" Text="[%Interval (v hodinách) odesílání upozornění o vypršení požadavku%]:"></asp:Label>
                        </td>
                        <td>
                            <asp:TextBox runat="server" ID="text_interval" Width="30" MaxLength="3" Text='<%# _interval() %>'></asp:TextBox>
                            <asp:RegularExpressionValidator ID="RegularExpressionValidator2" runat="server" ControlToValidate="text_interval" ErrorMessage="[%Prosím zadávejte jen číslice%]" ValidationExpression="^\d+$"></asp:RegularExpressionValidator>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            <asp:Label runat="server" ID="Label2" Text="[%Zapnutí/vypnutí automatického uzavírání požadavků po vypršení data 'Vyřešit do'%]:"></asp:Label>
                        </td>
                        <td align="left">
                            <asp:CheckBox runat="server" ID="check_zapnuti"></asp:CheckBox>
                        </td>
                    </tr>
                </table>
            </asp:WizardStep>
            <asp:WizardStep ID="wizm4" Title="Náhled">
                <div class="tiskHide">
                    <asp:RadioButton runat="server" ID="rb_sestava" GroupName="nahled" Text="[%Sestava%]" AutoPostBack="true" OnCheckedChanged="rb_nahled_CheckedChanged"></asp:RadioButton>
                    <asp:RadioButton runat="server" ID="rb_diagram" GroupName="nahled" Text="[%Diagram%]" AutoPostBack="true" OnCheckedChanged="rb_nahled_CheckedChanged"></asp:RadioButton>
                    <span>&nbsp;</span>
                    <kspwc:TRadButton runat="server" ID="RB_diag_svg" Text="[%Ulož jako SVG%]" OnClientClicked="diagExportToSVG" AutoPostBack="false" Visible="false" Icon-PrimaryIconCssClass="fi fi-picture"></kspwc:TRadButton>
                    <kspwc:TRadButton runat="server" ID="RB_diag_png" Text="[%Ulož jako PNG%]" OnClientClicked="diagExportToImage" AutoPostBack="false" Visible="false" Icon-PrimaryIconCssClass="fi fi-picture"></kspwc:TRadButton>
                    <kspwc:TRadButton runat="server" ID="RB_diag_pdf" Text="[%Ulož jako PDF%]" OnClientClicked="diagExportToPDF" AutoPostBack="false" Visible="false" Icon-PrimaryIconCssClass="fi fi-file-pdf"></kspwc:TRadButton>
                </div>

                <%--Pdf-PaperSize="A4" Pdf-PageWidth="297mm" Pdf-PageHeight="210mm" Pdf-PageBottomMargin="5mm" Pdf-PageTopMargin="5mm" Pdf-PageRightMargin="5mm" Pdf-PageLeftMargin="5mm"--%>
                <wc:TRadGrid ID="rg_sestava" Visible="false" GridLines="Both" runat="server" AllowAutomaticDeletes="False"
                    AllowAutomaticInserts="False" AllowAutomaticUpdates="False" AllowPaging="False" AllowSorting="false"
                    AutoGenerateColumns="False" Width='<%# _sirka(300) %>' OnNeedDataSource="rg_sestava_NeedDataSource" OnItemDataBound="rg_sestava_ItemDataBound" OnPreRender="rg_sestava_PreRender"
                    PovolExport="True" CaptionVisible="false">
                    <ExportSettings HideStructureColumns="false" OpenInNewWindow="true" FileName="WFExport"
                        Excel-Format="Xlsx" Excel-FileExtension="xlsx">
                    </ExportSettings>
                    <MasterTableView CommandItemDisplay="Top" HorizontalAlign="NotSet" EditMode="InPlace" AutoGenerateColumns="False">
                        <CommandItemSettings ShowAddNewRecordButton="False" ShowExportToExcelButton="True" ShowExportToPdfButton="False" ShowPrintButton="False" ShowRefreshButton="False" />
                        <GroupByExpressions>
                            <telerik:GridGroupByExpression>
                                <SelectFields>
                                    <telerik:GridGroupByField FieldName="faze" HeaderText="[%Krok%]"></telerik:GridGroupByField>
                                    <telerik:GridGroupByField FieldName="faze_nazev" HeaderText="[%Název%]"></telerik:GridGroupByField>
                                </SelectFields>
                                <GroupByFields>
                                    <telerik:GridGroupByField FieldName="faze"></telerik:GridGroupByField>
                                </GroupByFields>
                            </telerik:GridGroupByExpression>
                            <telerik:GridGroupByExpression>
                                <SelectFields>
                                    <telerik:GridGroupByField FieldName="stav" HeaderText="[%Stav%]"></telerik:GridGroupByField>
                                    <telerik:GridGroupByField FieldName="stav_popis" HeaderText="[%Název%]"></telerik:GridGroupByField>
                                </SelectFields>
                                <GroupByFields>
                                    <telerik:GridGroupByField FieldName="stav"></telerik:GridGroupByField>
                                </GroupByFields>
                            </telerik:GridGroupByExpression>
                        </GroupByExpressions>
                        <Columns>
                            <telerik:GridBoundColumn DataField="faze" UniqueName="faze" HeaderStyle-Width="100px" HeaderText="[%Krok%]" ReadOnly="True" DataType="System.Int16" Visible="false">
                            </telerik:GridBoundColumn>
                            <telerik:GridBoundColumn DataField="faze_nazev" UniqueName="faze_nazev" HeaderStyle-Width="100px" HeaderText="[%Název kroku%]" ReadOnly="True" Visible="false">
                            </telerik:GridBoundColumn>
                            <telerik:GridBoundColumn DataField="stav" UniqueName="stav" HeaderStyle-Width="40px" HeaderText="[%Stav%]" ReadOnly="True" Visible="false">
                            </telerik:GridBoundColumn>
                            <telerik:GridBoundColumn DataField="stav_popis" UniqueName="stav_popis" HeaderStyle-Width="100px" HeaderText="[%Název stavu%]" ReadOnly="True" Visible="false">
                            </telerik:GridBoundColumn>
                            <%--Viditelné sloupce--%>
                            <telerik:GridBoundColumn DataField="sys_stav" UniqueName="sys_stav" HeaderStyle-Width="25px" HeaderText="[%Systémový stav%]" ReadOnly="True">
                            </telerik:GridBoundColumn>
                            <telerik:GridBoundColumn DataField="pristup" UniqueName="pristup" HeaderStyle-Width="40px" HeaderText="[%Přístup%]" ReadOnly="True">
                            </telerik:GridBoundColumn>
                            <telerik:GridBoundColumn DataField="poradi" UniqueName="poradi" HeaderStyle-Width="20px" HeaderText="Pořadí" ReadOnly="True">
                            </telerik:GridBoundColumn>
                            <telerik:GridBoundColumn DataField="vyraz" UniqueName="vyraz" HeaderStyle-Width="180px" HeaderText="[%Podmínka%]" ReadOnly="True">
                            </telerik:GridBoundColumn>
                            <telerik:GridBoundColumn DataField="validace" UniqueName="validace" HeaderStyle-Width="100px" HeaderText="[%Validace%]" ReadOnly="True">
                            </telerik:GridBoundColumn>
                            <telerik:GridBoundColumn DataField="next_faze" UniqueName="next_faze" HeaderStyle-Width="20px" HeaderText="[%Následující krok%]" ReadOnly="True">
                            </telerik:GridBoundColumn>
                            <telerik:GridBoundColumn DataField="adresat" UniqueName="adresat" HeaderStyle-Width="100px" HeaderText="[%Řešitel%]" ReadOnly="True">
                            </telerik:GridBoundColumn>
                            <telerik:GridBoundColumn DataField="oznam" UniqueName="oznam" HeaderStyle-Width="100px" HeaderText="[%Oznámení%]" ReadOnly="True">
                            </telerik:GridBoundColumn>
                            <telerik:GridBoundColumn DataField="akce" UniqueName="akce" HeaderStyle-Width="100px" HeaderText="[%Akce%]" ReadOnly="True">
                            </telerik:GridBoundColumn>
                        </Columns>

                    </MasterTableView>
                </wc:TRadGrid>


                <div class="tiskHide">
                    <asp:Label runat="server" ID="Lab_diag_tip" Text="[%Nápověda%]: [%Použij kolečko myši pro přiblížení/oddálení oblasti pod ukazatelem myši%]" Visible="false"></asp:Label>
                </div>
                <telerik:RadDiagram ID="diag" runat="server" Width="1300" Height="1300" Editable="False" Visible="false" Selectable="False">
                    <ClientEvents OnLoad="diagramLoad" />
                    <PdfSettings FileName="WFdiagram.pdf" Title="Workflow Diagram"></PdfSettings>
                    <PannableSettings Key="None" />
                    <%--How to pan with the mouse only--%>
                    <ConnectionDefaultsSettings Type="Polyline">
                        <StrokeSettings Width="1.5" />
                    </ConnectionDefaultsSettings>
                    <ShapeDefaultsSettings>
                        <StrokeSettings Color="#000000" Width="2" DashType="Solid" />
                        <ContentSettings FontFamily="Arial" FontSize="12" />
                    </ShapeDefaultsSettings>
                    <ShapesCollection>
                    </ShapesCollection>
                    <ConnectionsCollection>
                    </ConnectionsCollection>
                </telerik:RadDiagram>

            </asp:WizardStep>
             <asp:WizardStep ID="wizm5" Title="Uložení">
                <br />
                <asp:Label runat="server" ID="lab_oznameni" Text="Použitím tlačítka Uložit se provedené změny zapíší do databáze a stanou se platným nastavením"></asp:Label>
            </asp:WizardStep>
        </WizardSteps>
    </asp:Wizard>
    <fieldset id="FS_upload" runat="server" class="ksprvek" style="padding: 20px; width: fit-content; margin-top: 25px; border: none">
        <h3>[%Import definice nastavení%]</h3>
        <table class="InnerTableFormFieldset" runat="server" id="table_edit_zam">
            <tr>
                <td style="width: 100px !important;">
                    <%--      --%>
                    <div class="DropZone">
                        <telerik:RadAsyncUpload PostbackTriggers="import" DropZones=".DropZone,.DropZone2" TemporaryFolder="~/Temp" runat="server" ID="RadAsyncUpload1" MultipleFileSelection="Disabled" AllowedMimeTypes="xml" AllowedFileExtensions="xml" AutoAddFileInputs="true" ManualUpload="false" OnFileUploaded="RadAsyncUpload1_FileUploaded">
                            <Localization Select="[%Výběr XML souboru%]" DropZone="[%Zde pusťte soubor%]" Remove="[%Odstranit%]" />
                        </telerik:RadAsyncUpload>
                    </div>
                    <%--<div class="DropZone2">
                        <p>[%Sem přetáhněte soubor%]</p>
                    </div>--%>
                </td>
            </tr>
            <tr>
                <td style="padding-top: 20px;">
                    <kspwc:TRadButton runat="server" ID="import" Text="[%Provést%]" AutoPostBack="true" Width="270"></kspwc:TRadButton>
                </td>
            </tr>
        </table>
    </fieldset>

</asp:Content>


