﻿<%@ Page Title="" Language="C#" MasterPageFile="~/PublicPage.Master" AutoEventWireup="true" CodeBehind="CVUchFormV2.aspx.cs" Inherits="KSPortal.Public.CVUchFormV2" MaintainScrollPositionOnPostback="true" %>

<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>
<%@ Register Assembly="WebControls" Namespace="KSProgram.WebControls" TagPrefix="wc" %>
<asp:Content ID="Content1" ContentPlaceHolderID="head" runat="server">
    <%--max-width : 768px--%>
    <style type="text/css">
        @media (max-width : 768px) {
            .RadTabStrip .rtsLevel1 .rtsLI {
                width: 50%;
                text-align: left;
            }
        }

        @media (max-width : 320px) {
            .RadTabStrip .rtsLevel1 .rtsLI {
                width: 100%;
                text-align: left;
            }
        }

        fieldset {
            border: 1px solid var(--kscolor1);
            padding: 15px;
            margin: auto;
        }

        .FieldSetLegend {
            color: #213D71;
            font-weight: bold;
        }

        .StarRequired {
            color: red;
            font-size: large;
            height: 17px;
            vertical-align: middle;
        }

        .DoprovodnyText {
            max-height: 100px;
            min-height: 50px;
            max-width: 600px;
            min-width: 400px;
        }

        .RadGrid_Metro {
            margin: 20px;
            width: calc(100% - 40px) !important;
        }

        .rgMasterTable {
            border: 1px solid lightgrey;
        }

        #FS_Odeslat button {
            background: var(--kscolor1) !important;
            color: var(--kscolor1text) !important;
        }

            #FS_Odeslat button:hover {
                background: var(--kscolor1text) !important;
                color: var(--kscolor1) !important;
            }
    </style>
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="HlavniOblast" runat="server">
    <script src="../Scripts/iban.js" type="text/javascript"></script>
    <script src="../Scripts/KSValidator.js" type="text/javascript"></script>
    <telerik:RadCodeBlock ID="RadCodeBlock1" runat="server">
        <script type="text/javascript">
            function OnSelecting(sender, args) {
                $get("<%= PreviousTabHidden.ClientID%>").value = sender.get_selectedTab().get_text();
            }

            function PhoneValidation(sender, args) {
                args.IsValid = true;
                var val = args.Value;
                var ks_args = KSValidator.getArgs();
                if (KSValidator.validateTelefon(val, ks_args, '<%= (KSProgram.Zakaznik.IsSR() ? "421" : "420") %>')) {
                    if (ks_args.newValue != "") {
                        var txbox = $telerik.findControl(document, "TB_Telefon");
                        //var txbox = $telerik.$("[id$='TB_Telefon']").get(0);
                        txbox.set_value(ks_args.newValue);
                    }
                    args.IsValid = true;
                    return;
                }
                args.IsValid = false;
            }
        </script>
    </telerik:RadCodeBlock>
    <telerik:RadAjaxManagerProxy runat="server" ID="RAMP_Manager">
        <AjaxSettings>
            <telerik:AjaxSetting AjaxControlID="P_SendOK">
                <UpdatedControls>
                    <telerik:AjaxUpdatedControl ControlID="P_SendOK" />
                </UpdatedControls>
            </telerik:AjaxSetting>
            <%-- <telerik:AjaxSetting AjaxControlID="RTS_Zalozky">
                <UpdatedControls><telerik:AjaxUpdatedControl ControlID="P_OsobniUdaje" /></UpdatedControls>
                <UpdatedControls><telerik:AjaxUpdatedControl ControlID="P_Vzdelani"  /></UpdatedControls>
                <UpdatedControls><telerik:AjaxUpdatedControl ControlID="P_Praxe"  /></UpdatedControls>
                <UpdatedControls><telerik:AjaxUpdatedControl ControlID="P_ZnalostiDovednosti"  /></UpdatedControls>
                <UpdatedControls><telerik:AjaxUpdatedControl ControlID="P_HledanaPrace"  /></UpdatedControls>
                <UpdatedControls><telerik:AjaxUpdatedControl ControlID="P_Odeslani"  /></UpdatedControls>
            </telerik:AjaxSetting>--%>
            <telerik:AjaxSetting AjaxControlID="P_OsobniUdaje">
                <UpdatedControls>
                    <telerik:AjaxUpdatedControl ControlID="P_OsobniUdaje" />
                </UpdatedControls>
            </telerik:AjaxSetting>
            <telerik:AjaxSetting AjaxControlID="P_Vzdelani">
                <UpdatedControls>
                    <telerik:AjaxUpdatedControl ControlID="P_Vzdelani" />
                </UpdatedControls>
            </telerik:AjaxSetting>
            <telerik:AjaxSetting AjaxControlID="P_Praxe">
                <UpdatedControls>
                    <telerik:AjaxUpdatedControl ControlID="P_Praxe" />
                </UpdatedControls>
            </telerik:AjaxSetting>
            <telerik:AjaxSetting AjaxControlID="P_ZnalostiDovednosti">
                <UpdatedControls>
                    <telerik:AjaxUpdatedControl ControlID="P_ZnalostiDovednosti" />
                </UpdatedControls>
            </telerik:AjaxSetting>
            <telerik:AjaxSetting AjaxControlID="P_HledanaPrace">
                <UpdatedControls>
                    <telerik:AjaxUpdatedControl ControlID="P_HledanaPrace" />
                </UpdatedControls>
            </telerik:AjaxSetting>
            <telerik:AjaxSetting AjaxControlID="P_VyberovaRizeni">
                <UpdatedControls>
                    <telerik:AjaxUpdatedControl ControlID="P_VyberovaRizeni" />
                </UpdatedControls>
            </telerik:AjaxSetting>
            <%--<telerik:AjaxSetting AjaxControlID="P_Odeslani">
                <UpdatedControls><telerik:AjaxUpdatedControl ControlID="P_Odeslani" /></UpdatedControls>
            </telerik:AjaxSetting>--%>
        </AjaxSettings>
    </telerik:RadAjaxManagerProxy>
    <table>
        <tr>
            <td align="center">
                <asp:Label ID="L_NazevForm" runat="server" Text="Formulář uchazeče o zaměstnání" Font-Bold="True"
                    Font-Size="Large" ForeColor="#213D71"></asp:Label>
            </td>
        </tr>
        <tr>
            <td align="center" style="padding-bottom: 10px">
                <asp:Label ID="L_NazevVR" runat="server" Text="" Visible="true" Font-Size="Medium"></asp:Label>
            </td>
        </tr>
        <tr>
            <td>
                <asp:Panel ID="P_Hlavni" runat="server" Visible="true">
                    <%--<div style="max-width: 850px; float: left;">--%>
                    <div style="max-width: 880px; align-content: center">
                        <asp:HiddenField ID="PreviousTabHidden" runat="Server" />
                        <telerik:RadTabStrip ID="RTS_Zalozky" runat="server" MultiPageID="RadMultiPage1" RenderMode="Lightweight" OnTabClick="RTS_Zalozky_TabClick" SelectedIndex="0"
                            CausesValidation="true" ValidationGroup="VG_OsobniUdaje" OnPreRender="RTS_Zalozky_PreRender" OnClientTabSelecting="OnSelecting" Width="100%">
                            <Tabs>
                                <%--!!!!! Pokud by se měnilo pořadí záložek, je potřeba upravit indexy v 'RadTabStrip1_PreRender' !!!!!--%>
                                <%--<telerik:RadTab Text="Osobní údaje" ImageUrl="~/Images/AccessAllow.png">--%>
                                <telerik:RadTab Text="Osobní údaje" Value="OsobniUdaje">
                                </telerik:RadTab>
                                <telerik:RadTab Text="Vzdělání" Value="Vzdelani">
                                </telerik:RadTab>
                                <telerik:RadTab Text="Praxe" Value="Praxe">
                                </telerik:RadTab>
                                <telerik:RadTab Text="Znalosti a dovednosti" Value="Znalosti">
                                </telerik:RadTab>
                                <telerik:RadTab Text="Hledaná práce" Value="HledanaPrace">
                                </telerik:RadTab>
                                <telerik:RadTab Text="Dokumenty" Value="Dokumenty">
                                </telerik:RadTab>
                                <telerik:RadTab Text="ODESLÁNÍ FORMULÁŘE" Font-Bold="true" Value="OdeslaniFormulare">
                                </telerik:RadTab>
                                <telerik:RadTab Text="Výběrová řízení" Value="VyberovaRizeni" Visible="false">
                                </telerik:RadTab>
                                <%--<telerik:RadTab Text="Dokumenty" Value="Dokumenty_MSK" Visible="false">
                                </telerik:RadTab>--%>
                                <telerik:RadTab Text="ODESLÁNÍ FORMULÁŘE" Font-Bold="true" Value="OdeslaniFormulare_MSK" Visible="false">
                                </telerik:RadTab>
                            </Tabs>
                        </telerik:RadTabStrip>
                        <%--<asp:Panel ID="PanelHlavni" HorizontalAlign="Left" BackColor="White" BorderColor="LightGray"
                            runat="Server" BorderStyle="Solid" BorderWidth="1px">--%>
                        <asp:CustomValidator ID="CV_NotNull" runat="server" ValidationGroup="VG_OsobniUdaje" OnServerValidate="CV_NotNull_ServerValidate" Display="None" ErrorMessage="Nějaká chyba"></asp:CustomValidator>
                        <telerik:RadMultiPage runat="server" ID="RadMultiPage1" SelectedIndex="0">
                            <%--*********************************************************************************************--%>
                            <%--********** 1. Osobní údaje ******************************************************************--%>
                            <%--*********************************************************************************************--%>
                            <telerik:RadPageView runat="server" ID="RPV_OsobniUdaje" BackColor="White" Style="min-height: 350px" OnPreRender="RPV_OsobniUdaje_PreRender">
                                <div style="float: none;">
                                    <asp:ValidationSummary ID="VS_OsobniUdaje" runat="server" ValidationGroup="VG_OsobniUdaje" ForeColor="Red" />
                                </div>
                                <asp:Panel ID="P_OsobniUdaje" runat="server">
                                    <%--Osobní údaje--%>
                                    <div style="padding: 10px;">
                                        <fieldset id="FS_OsobniUdaje" class="FieldSet" style="min-width: 280px">
                                            <legend class="FieldSetLegend">OSOBNÍ ÚDAJE</legend>
                                            <asp:ObjectDataSource ID="ODS_StPrisl" runat="server" SelectMethod="Seznam" TypeName="KSProgram.Ciselniky.CisStatniPrisl" OnSelecting="ODS_StPrisl_Selecting">
                                                <SelectParameters>
                                                    <asp:Parameter Name="pridat_prazdny_radek" DefaultValue="true" Type="Boolean" />
                                                    <asp:Parameter Name="nazev_format_string" DefaultValue="{cesky}" Type="String" />
                                                    <asp:Parameter Name="clen_eu" DefaultValue="" Type="Object" />
                                                    <asp:Parameter Name="order_by" DefaultValue="cesky" Type="String" />
                                                </SelectParameters>
                                            </asp:ObjectDataSource>
                                            <table width="100%" style="max-width: 400px">
                                                <tr>
                                                    <td style="width: 10px">
                                                        <asp:Label ID="L_Jmeno" runat="server" Text="Jméno"></asp:Label>
                                                    </td>
                                                    <td>
                                                        <wc:TextBoxCVUch ID="TB_Jmeno" runat="server" MaxLength="40" PovinnePole="true"
                                                            PopisPole="Jméno" ValidationGroup="VG_OsobniUdaje" Width="100%" />
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td>
                                                        <asp:Label ID="L_Prijmeni" runat="server" Text="Příjmení"></asp:Label>
                                                    </td>
                                                    <td>
                                                        <wc:TextBoxCVUch ID="TB_Prijmeni" runat="server" MaxLength="40" PovinnePole="true"
                                                            PopisPole="Příjmení" ValidationGroup="VG_OsobniUdaje" Width="100%" />
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td>
                                                        <asp:Label ID="L_Titul" runat="server" Text="Titul před"></asp:Label>
                                                    </td>
                                                    <td>
                                                        <wc:TextBoxCVUch ID="TB_Titul" runat="server" MaxLength="25" PovinnePoleParametrem="Titul" PopisPole="Titul před" ValidationGroup="VG_OsobniUdaje" Width="100%" />
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td>
                                                        <asp:Label ID="L_TitulZa" runat="server" Text="Titul za"></asp:Label>
                                                    </td>
                                                    <td>
                                                        <wc:TextBoxCVUch ID="TB_TitulZa" runat="server" MaxLength="15" PovinnePoleParametrem="TitulZa" PopisPole="Titul za" ValidationGroup="VG_OsobniUdaje" Width="100%" />
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td style="white-space: nowrap">
                                                        <asp:Label ID="L_DatNar" runat="server" Text="Datum narození"></asp:Label>
                                                    </td>
                                                    <td>
                                                        <table cellpadding="0px" cellspacing="0px">
                                                            <tr>
                                                                <td>
                                                                    <wc:TRadDatePicker runat="server" ID="RDP_RodneCislo"
                                                                        DateInput-MinDate="1.1.1900 0:00:00" MinDate="1.1.1900 0:00:00" MaxDate="<%# GetMaxDatumNarozeni()%>">
                                                                    </wc:TRadDatePicker>
                                                                </td>
                                                                <td>
                                                                    <asp:Label ID="L_RodneCisloStar" runat="server" Text="*" CssClass="StarRequired" Height="20" Visible="<%# IsRequired(KSProgram.Uchazeci.PovinneUdaje.NarozeniDatum) %>"></asp:Label>
                                                                    <asp:RequiredFieldValidator ID="RFV_DatNar" runat="server" ErrorMessage="Není zadána povinná hodnota pole: <b>Datum narození</b>"
                                                                        ControlToValidate="RDP_RodneCislo" Display="None" ValidationGroup="VG_OsobniUdaje" Enabled="false"></asp:RequiredFieldValidator>
                                                                </td>
                                                            </tr>
                                                        </table>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td style="white-space: nowrap">
                                                        <asp:Label ID="L_MistoNarozeni" runat="server" Text="Místo narození"></asp:Label>
                                                    </td>
                                                    <td>
                                                        <wc:TextBoxCVUch ID="TB_MistoNarozeni" runat="server" MaxLength="48" PovinnePoleParametrem="NarozeniMisto" PopisPole="Místo narození" ValidationGroup="VG_OsobniUdaje" Width="100%" />
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td>
                                                        <asp:Label ID="L_Pohlavi" runat="server" Text="Pohlaví"></asp:Label>
                                                    </td>
                                                    <td>
                                                        <wc:DropDownListCVUch ID="DDL_Pohlavi" runat="server" PovinnePoleParametrem="Pohlavi" PopisPole="Pohlaví" ValidationGroup="VG_OsobniUdaje" Width="100%">
                                                            <asp:ListItem Enabled="true" Value="" Text=""></asp:ListItem>
                                                            <asp:ListItem Value="m" Text="muž"></asp:ListItem>
                                                            <asp:ListItem Value="z" Text="žena"></asp:ListItem>
                                                        </wc:DropDownListCVUch>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td style="white-space: nowrap">
                                                        <asp:Label ID="L_RodinStav" runat="server" Text="Rodinný stav"></asp:Label>
                                                    </td>
                                                    <td>
                                                        <wc:DropDownListCVUch ID="DDL_RodinStav" runat="server" PovinnePoleParametrem="RodinStav" PopisPole="Rodinný stav" ValidationGroup="VG_OsobniUdaje" Width="100%">
                                                            <asp:ListItem Enabled="true" Value="" Text=""></asp:ListItem>
                                                            <asp:ListItem Value="1" Text="svobodný(á)"></asp:ListItem>
                                                            <asp:ListItem Value="2" Text="ženatý(vdaná)"></asp:ListItem>
                                                            <asp:ListItem Value="3" Text="rozvedený(á)"></asp:ListItem>
                                                            <asp:ListItem Value="4" Text="ovdovělý(á)"></asp:ListItem>
                                                            <asp:ListItem Value="5" Text="partner(ka)"></asp:ListItem>
                                                        </wc:DropDownListCVUch>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td style="white-space: nowrap">
                                                        <asp:Label ID="L_StPrisl" runat="server" Text="Státní příslušnost"></asp:Label>
                                                    </td>
                                                    <td>
                                                        <wc:DropDownListCVUch ID="DDL_StPrisl" runat="server" DataSourceID="ODS_StPrisl" DataTextField="cesky" DataValueField="kod_ciselny"
                                                            PovinnePoleParametrem="StPrisl" PopisPole="Státní příslušnost" ValidationGroup="VG_OsobniUdaje" Width="100%">
                                                        </wc:DropDownListCVUch>
                                                    </td>
                                                </tr>
                                                <tr runat="server" visible="<%# _isMorSlezKraj %>">
                                                    <td>
                                                        <asp:Label ID="L_CisloOP" runat="server" Text="Číslo OP"></asp:Label>
                                                    </td>
                                                    <td>
                                                        <wc:TextBoxCVUch ID="TB_CisloOP" runat="server" MaxLength="25" Width="100%" />
                                                    </td>
                                                </tr>
                                                <tr runat="server" visible="<%# _isMorSlezKraj %>" style="white-space: nowrap">
                                                    <td>
                                                        <asp:Label ID="L_PovoleniKPobytu" runat="server" Text="Č. dokladu <br/>o povolení k pobytu"></asp:Label>
                                                    </td>
                                                    <td>
                                                        <wc:TextBoxCVUch ID="TB_PovoleniKPobytu" runat="server" MaxLength="25" Width="100%" />
                                                    </td>
                                                </tr>
                                            </table>
                                            <asp:Label runat="server" ID="L_CisloOP_Info" Visible="false" ForeColor="Red" Text="Jelikož se jedná o úřednickou pozici je podmínkou vyplněné pole <b>Číslo OP</b> nebo <b>Č. dokladu o povolení k pobytu</b>."></asp:Label>
                                        </fieldset>
                                    </div>
                                    <%--Trvalé bydliště--%>
                                    <div style="float: left; padding: 10px; display: block">
                                        <fieldset id="FS_TrvaleBydliste" class="FieldSet" style="min-width: 280px">
                                            <legend class="FieldSetLegend">TRVALÉ BYDLIŠTĚ</legend>
                                            <table width="100%" style="max-width: 300px">
                                                <tr>
                                                    <td style="width: 50px">
                                                        <asp:Label ID="L_TrAdrUlice" runat="server" Text="Ulice"></asp:Label>
                                                    </td>
                                                    <td>
                                                        <wc:TextBoxCVUch ID="TB_TrAdrUlice" runat="server" MaxLength="30" PovinnePoleParametrem="TrAdrUlice" PopisPole="Ulice" ValidationGroup="VG_OsobniUdaje"
                                                            Width="100%" />
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td>
                                                        <asp:Label ID="L_TrAdrCislo" runat="server" Text="Číslo"></asp:Label>
                                                    </td>
                                                    <td>
                                                        <wc:TextBoxCVUch ID="TB_TrAdrCislo" runat="server" MaxLength="14"
                                                            PovinnePoleParametrem="TrAdrCislo" PopisPole="Číslo" ValidationGroup="VG_OsobniUdaje" Width="100%" />
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td style="white-space: nowrap">
                                                        <asp:Label ID="L_TrAdrMesto" runat="server" Text="Město / Obec"></asp:Label>
                                                    </td>
                                                    <td>
                                                        <wc:TextBoxCVUch ID="TB_TrAdrMesto" runat="server" MaxLength="48"
                                                            PovinnePoleParametrem="TrAdrMesto" PopisPole="Město / Obec" ValidationGroup="VG_OsobniUdaje" BorderColor="Red" Width="100%" />
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td>
                                                        <asp:Label ID="L_TrAdrPSC" runat="server" Text="PSČ"></asp:Label>
                                                    </td>
                                                    <td>
                                                        <wc:TextBoxCVUch ID="TB_TrAdrPSC" runat="server" MaxLength="5"
                                                            PovinnePoleParametrem="TrAdrPSC" PopisPole="PSČ" ValidationGroup="VG_OsobniUdaje" Type="Number" Width="80px" />
                                                    </td>
                                                </tr>
                                            </table>
                                        </fieldset>
                                    </div>
                                    <%--Doručovací adresa--%>
                                    <div style="padding: 10px; display: block">
                                        <fieldset id="FS_DorucovaciAdresa" class="FieldSet" style="min-width: 280px;">
                                            <legend class="FieldSetLegend">DORUČOVACÍ ADRESA</legend>
                                            <table width="100%" style="max-width: 300px">
                                                <tr>
                                                    <td style="width: 50px">
                                                        <asp:Label ID="L_PrAdrUlice" runat="server" Text="Ulice"></asp:Label>
                                                    </td>
                                                    <td>
                                                        <wc:TextBoxCVUch ID="TB_PrAdrUlice" runat="server" MaxLength="30" PovinnePoleParametrem="PrAdrUlice" PopisPole="Ulice" ValidationGroup="VG_OsobniUdaje"
                                                            Width="100%" />
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td>
                                                        <asp:Label ID="L_PrAdrCislo" runat="server" Text="Číslo"></asp:Label>
                                                    </td>
                                                    <td>
                                                        <wc:TextBoxCVUch ID="TB_PrAdrCislo" runat="server" MaxLength="14"
                                                            PovinnePoleParametrem="PrAdrCislo" PopisPole="Číslo" ValidationGroup="VG_OsobniUdaje" Width="100%" />
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td style="white-space: nowrap">
                                                        <asp:Label ID="L_PrAdrMesto" runat="server" Text="Město / Obec"></asp:Label>
                                                    </td>
                                                    <td>
                                                        <wc:TextBoxCVUch ID="TB_PrAdrMesto" runat="server" MaxLength="48"
                                                            PovinnePoleParametrem="PrAdrMesto" PopisPole="Město / Obec" ValidationGroup="VG_OsobniUdaje" BorderColor="Red" Width="100%" />
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td>
                                                        <asp:Label ID="L_PrAdrPSC" runat="server" Text="PSČ"></asp:Label>
                                                    </td>
                                                    <td>
                                                        <wc:TextBoxCVUch ID="TB_PrAdrPSC" runat="server" MaxLength="5"
                                                            PovinnePoleParametrem="PrAdrPSC" PopisPole="PSČ" ValidationGroup="VG_OsobniUdaje" Type="Number" Width="80px" />
                                                    </td>
                                                </tr>
                                            </table>
                                        </fieldset>
                                    </div>
                                    <%--Kontakty--%>
                                    <div style="float: left; padding: 10px; display: block;">
                                        <fieldset id="FS_Kontakty" class="FieldSet" style="min-width: 280px; min-height: 70px;">
                                            <legend class="FieldSetLegend">KONTAKTY</legend>
                                            <table width="100%">
                                                <tr>
                                                    <td style="width: 10px">
                                                        <asp:Label ID="L_Telefon" runat="server" Text="Telefon"></asp:Label>
                                                    </td>
                                                    <td style="white-space: nowrap; padding-right: 13px;">
                                                        <%--<wc:TextBoxCVUch ID="TB_Telefon" runat="server" MaxLength="50"
                                                            PovinnePoleParametrem="Telefon" PopisPole="Telefon" Type="PhoneNumber" ValidationGroup="VG_OsobniUdaje" Width="100%" />--%>
                                                        <%--<table style="width:100%;border-collapse:collapse;" cellpadding="0px" cellspacing="0px"><tr><td>
                                                            <telerik:RadTextBox runat="server" ID="TB_Telefon" CssClass="povinne-pole" MaxLength="50"></telerik:RadTextBox>
                                                            <kspwc:TCustomValidator runat="server" ID="CV_Telefon" ValidationGroup="VG_OsobniUdaje" Display="None" EnableClientScript="true" ControlToValidate="TB_Telefon" ClientValidationFunction="PhoneValidation" ErrorMessage="Není zadán platný telefon v poli: <b>Telefon</b>"></kspwc:TCustomValidator>
                                                            </td>
                                                            <td>
                                                        <asp:Label ID="L_TelefonStar" runat="server" Text="&nbsp;*" CssClass="StarRequired"></asp:Label>
                                                                </td></tr></table>--%>
                                                        <telerik:RadTextBox runat="server" ID="TB_Telefon" MaxLength="50" Width="100%"></telerik:RadTextBox>
                                                        <kspwc:TCustomValidator runat="server" ID="CV_Telefon" ValidationGroup="VG_OsobniUdaje" Display="None" EnableClientScript="true" ControlToValidate="TB_Telefon" ClientValidationFunction="PhoneValidation" ErrorMessage="Není zadán platný telefon v poli: <b>Telefon</b>"></kspwc:TCustomValidator>
                                                        <asp:RequiredFieldValidator ID="RFV_Telefon" runat="server" Enabled="<%# IsRequired(KSProgram.Uchazeci.PovinneUdaje.Telefon) %>" ErrorMessage="Není zadána povinná hodnota pole: <b>Telefon</b>"
                                                            ControlToValidate="TB_Telefon" Display="None" ValidationGroup="VG_OsobniUdaje"></asp:RequiredFieldValidator>
                                                        <asp:Label ID="L_TelefonStar" runat="server" Text="*" CssClass="StarRequired" Height="17px" Visible="<%# IsRequired(KSProgram.Uchazeci.PovinneUdaje.Telefon) %>"></asp:Label>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td>
                                                        <asp:Label ID="L_Email" runat="server" Text="E-mail"></asp:Label>
                                                    </td>
                                                    <td>
                                                        <wc:TextBoxCVUch ID="TB_Email" runat="server" MaxLength="50"
                                                            PovinnePoleParametrem="Email" PopisPole="E-mail" Type="EmailAddress" ValidationGroup="VG_OsobniUdaje" Width="100%" />
                                                    </td>
                                                </tr>
                                            </table>
                                        </fieldset>
                                    </div>
                                    <%--Doprovodný text--%>
                                    <div style="padding: 10px;">
                                        <fieldset id="FS_DoprovodnyText" class="FieldSet" style="min-width: 280px; min-height: 70px;">
                                            <legend class="FieldSetLegend">DOPROVODNÝ TEXT</legend>
                                            <wc:TextBoxCVUch ID="TB_DoprovodnyText" runat="server" TextMode="MultiLine" Resize="Vertical" PovinnePoleParametrem="DoprovodnyText" PopisPole="Doprovodný text" MaxLength="250" ValidationGroup="VG_OsobniUdaje" CssClass="DoprovodnyText" Width="100%" />
                                        </fieldset>
                                    </div>
                                    <%--<div style="padding: 10px; float:unset"> 
                                        <fieldset id="FS_DoprovodnyText" class="FieldSet" style="width: 250px;">
                                            <legend class="FieldSetLegend">DOPROVODNÝ TEXT</legend>
                                            <wc:TextBoxCVUch ID="TB_DoprovodnyText" runat="server" TextMode="MultiLine" Resize="Both" PopisPole="Doprovodný text" MaxLength="10" ValidationGroup="VG_OsobniUdaje" CssClass="DoprovodnyText" />
                                        </fieldset>
                                    </div>--%>
                                </asp:Panel>
                                <%--<div style="float: none; padding-bottom: 5px">
                                    <asp:ValidationSummary ID="VS_OsobniUdaje" runat="server" ValidationGroup="VG_OsobniUdaje" ForeColor="Red" />
                                </div>--%>
                            </telerik:RadPageView>
                            <%--*********************************************************************************************--%>
                            <%--********** 2. Vzdělání **********************************************************************--%>
                            <%--*********************************************************************************************--%>
                            <telerik:RadPageView runat="server" ID="RPV_Vzdelani" BackColor="White" Style="min-height: 160px">
                                <div style="float: none;">
                                    <asp:ValidationSummary ID="VS_Vzdelani" runat="server" ValidationGroup="VG_Vzdelani" ForeColor="Red" />
                                </div>
                                <asp:Panel ID="P_Vzdelani" runat="server">
                                    <div style="padding: 10px;">
                                        <fieldset id="FS_Skola" class="FieldSet" style="max-width: 450px;">
                                            <legend class="FieldSetLegend">ŠKOLA</legend>
                                            <asp:ObjectDataSource ID="ODS_StupVzdel" runat="server" SelectMethod="StupenSeznam"
                                                TypeName="KSProgram.Ciselniky.CisVzdelani">
                                                <SelectParameters>
                                                    <asp:Parameter DefaultValue="true" Name="pridatPrazdnyRadek" Type="Boolean" />
                                                </SelectParameters>
                                            </asp:ObjectDataSource>
                                            <asp:ObjectDataSource ID="ODS_OborVzdel" runat="server" SelectMethod="OborSeznam"
                                                TypeName="KSProgram.Ciselniky.CisVzdelani" OldValuesParameterFormatString="original_{0}">
                                                <SelectParameters>
                                                    <asp:Parameter DefaultValue="true" Name="pridatPrazdnyRadek" Type="Boolean" />
                                                    <asp:Parameter DefaultValue="ORDER BY vyznam" Name="expression_OrderBy" Type="String" />
                                                </SelectParameters>
                                            </asp:ObjectDataSource>
                                            <telerik:RadListView ID="RLV_Vzdelani" runat="server" ItemPlaceholderID="VzdelaniContainer" OnNeedDataSource="RLV_Vzdelani_NeedDataSource" DataKeyNames="id">
                                                <LayoutTemplate>
                                                    <asp:PlaceHolder runat="server" ID="VzdelaniContainer" />
                                                    <kspwc:TRadButton ID="BTN_SmazatZaznam" runat="server" Text="[%Smazat záznam%]" AutoPostBack="true" OnClick="BTN_SmazatZaznam_Click">
                                                        <Icon PrimaryIconCssClass="fi fi-trash"></Icon>
                                                    </kspwc:TRadButton>
                                                    <kspwc:TRadButton ID="BTN_NovyZaznam" runat="server" Text="[%Nový záznam%]" AutoPostBack="true" OnClick="BTN_NovyZaznam_Click">
                                                        <Icon PrimaryIconCssClass="fi fi-add"></Icon>
                                                    </kspwc:TRadButton>
                                                </LayoutTemplate>
                                                <ItemTemplate>
                                                    <table style="border-bottom-width: 1px; border-bottom-style: solid; border-bottom-color: lightgray; padding-bottom: 6px; width: 100%; max-width: 450px">
                                                        <tr>
                                                            <td style="width: 10px">
                                                                <asp:Label ID="L_Stupen" runat="server" Text="Stupeň"></asp:Label>
                                                            </td>
                                                            <td style="white-space: nowrap">
                                                                <wc:DropDownListCVUch ID="DDL_Stupen" runat="server" SelectedValue='<%# Bind("stupen") %>'
                                                                    DataSourceID="ODS_StupVzdel" DataTextField="vyznam" DataValueField="stupen" PopisPole="Stupeň vzdělání"
                                                                    PovinnePoleParametrem="VzdelStupen" ValidationGroup="VG_Vzdelani" Width="100%">
                                                                </wc:DropDownListCVUch>
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td style="white-space: nowrap">
                                                                <asp:Label ID="L_Obor" runat="server" Text="Obor vzdělání"></asp:Label>
                                                            </td>
                                                            <td style="white-space: nowrap">
                                                                <wc:DropDownListCVUch ID="DDL_Obor" runat="server" SelectedValue='<%# Bind("obor") %>'
                                                                    DataSourceID="ODS_OborVzdel" DataTextField="vyznam" DataValueField="obor" PovinnePoleParametrem="VzdelObor"
                                                                    ValidationGroup="VG_Vzdelani" PopisPole="Obor vzdělání" Width="100%">
                                                                </wc:DropDownListCVUch>
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td style="white-space: nowrap">
                                                                <asp:Label ID="L_Skola" runat="server" Text="Název školy"></asp:Label>
                                                            </td>
                                                            <td>
                                                                <wc:TextBoxCVUch ID="TB_Skola" runat="server" Text='<%# Bind("skola") %>' MaxLength="100" PovinnePoleParametrem="VzdelNazevSkoly" PopisPole="Název školy" ValidationGroup="VG_Vzdelani"
                                                                    Width="100%" />
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td style="white-space: nowrap">
                                                                <asp:Label ID="L_RokZahaj" runat="server" Text="Rok zahájení"></asp:Label>
                                                            </td>
                                                            <td>
                                                                <wc:TTextBox ID="TB_RokZahaj" runat="server" Text='<%# Bind("rok_zahaj") %>' Width="60" />
                                                                <asp:RangeValidator ID="RV_SkolaRokZahaj" runat="server" ControlToValidate="TB_RokZahaj"
                                                                    Display="None" ErrorMessage="Rok zahájení není platný!" MaximumValue="2200" MinimumValue="1"
                                                                    ValidationGroup="VG_Vzdelani" Type="Integer"></asp:RangeValidator>
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td style="white-space: nowrap">
                                                                <asp:Label ID="L_RokUkonc" runat="server" Text="Rok ukončení"></asp:Label>
                                                            </td>
                                                            <td>
                                                                <wc:TTextBox ID="TB_RokUkonc" runat="server" Text='<%# Bind("rok_ukonc") %>' Width="60" />
                                                                <asp:RangeValidator ID="RV_SkolaRokUkonc" runat="server" ControlToValidate="TB_RokUkonc"
                                                                    Display="None" ErrorMessage="Rok ukončení není platný!" MaximumValue="2200" MinimumValue="1"
                                                                    ValidationGroup="VG_Vzdelani" Type="Integer"></asp:RangeValidator>
                                                            </td>
                                                        </tr>
                                                    </table>
                                                    <div style="padding: 10px;">
                                                    </div>
                                                </ItemTemplate>
                                            </telerik:RadListView>
                                        </fieldset>
                                    </div>
                                </asp:Panel>
                                <%--<div style="float: none; padding-bottom: 5px">
                                    <asp:ValidationSummary ID="VS_Vzdelani" runat="server" ValidationGroup="VG_Vzdelani" ForeColor="Red" />
                                </div>--%>
                            </telerik:RadPageView>
                            <%--*********************************************************************************************--%>
                            <%--********** 3. Praxe *************************************************************************--%>
                            <%--*********************************************************************************************--%>
                            <telerik:RadPageView runat="server" ID="RPV_Praxe" BackColor="White" Style="min-height: 160px">
                                <div style="float: none;">
                                    <asp:ValidationSummary ID="VS_Praxe" runat="server" ValidationGroup="VG_Praxe" ForeColor="Red" />
                                </div>
                                <asp:Panel ID="P_Praxe" runat="server">
                                    <div style="padding: 10px;">
                                        <fieldset id="FS_Praxe" class="FieldSet" style="max-width: 450px;">
                                            <legend class="FieldSetLegend">PRAXE</legend>
                                            <asp:ObjectDataSource ID="ODS_Profese" runat="server" SelectMethod="ProfeseSeznam"
                                                TypeName="KSProgram.Ciselniky.CisProfese" OldValuesParameterFormatString="original_{0}">
                                                <SelectParameters>
                                                    <asp:Parameter DefaultValue="nazev" Name="sort" Type="String" />
                                                    <asp:Parameter DefaultValue="true" Name="pridatPrazdnyRadek" Type="Boolean" />
                                                </SelectParameters>
                                            </asp:ObjectDataSource>
                                            <telerik:RadListView ID="RLV_Praxe" runat="server" ItemPlaceholderID="PraxeContainer" OnNeedDataSource="RLV_Praxe_NeedDataSource" DataKeyNames="id">
                                                <LayoutTemplate>
                                                    <asp:PlaceHolder runat="server" ID="PraxeContainer" />
                                                    <kspwc:TRadButton ID="BTN_Praxe_SmazatZaznam" runat="server" Text="[%Smazat záznam%]" AutoPostBack="true" OnClick="BTN_Praxe_SmazatZaznam_Click">
                                                        <Icon PrimaryIconCssClass="fi fi-trash"></Icon>
                                                    </kspwc:TRadButton>
                                                    <kspwc:TRadButton ID="BTN_Praxe_NovyZaznam" runat="server" Text="[%Nový záznam%]" AutoPostBack="true" OnClick="BTN_Praxe_NovyZaznam_Click">
                                                        <Icon PrimaryIconCssClass="fi fi-add"></Icon>
                                                    </kspwc:TRadButton>
                                                </LayoutTemplate>
                                                <ItemTemplate>
                                                    <table width="100%" style="border-bottom-width: 1px; border-bottom-style: solid; border-bottom-color: lightgray; padding-bottom: 6px; max-width: 450px">
                                                        <tr>
                                                            <td style="white-space: nowrap; width: 10px">
                                                                <asp:Label ID="L_NazOrg" runat="server" Text="Název organizace"></asp:Label>
                                                            </td>
                                                            <td>
                                                                <wc:TextBoxCVUch ID="TB_NazOrg" runat="server" Text='<%# Bind("naz_org") %>' Width="100%"
                                                                    MaxLength="100" PovinnePoleParametrem="PraxeNazevOrg" PopisPole="Název organizace" ValidationGroup="VG_Praxe" />
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td>
                                                                <asp:Label ID="L_Pozice" runat="server" Text="Pozice"></asp:Label>
                                                            </td>
                                                            <td>
                                                                <wc:TextBoxCVUch ID="TB_Pozice" runat="server" Text='<%# Bind("pozice") %>' Width="100%"
                                                                    MaxLength="100" PovinnePoleParametrem="PraxePozice" PopisPole="Pozice" ValidationGroup="VG_Praxe" />
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td>
                                                                <asp:Label ID="L_PraxeProfese" runat="server" Text="Profese"></asp:Label>
                                                            </td>
                                                            <td>
                                                                <wc:DropDownListCVUch ID="DDL_Profese" runat="server" SelectedValue='<%# Bind("profese") %>'
                                                                    DataSourceID="ODS_Profese" DataTextField="nazev" DataValueField="cislo" PovinnePoleParametrem="PraxeProfese" PopisPole="Profese" ValidationGroup="VG_Praxe" Width="100%">
                                                                </wc:DropDownListCVUch>
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td>
                                                                <asp:Label ID="L_Nastup" runat="server" Text="Nástup"></asp:Label>
                                                            </td>
                                                            <td>
                                                                <wc:TRadDatePicker runat="server" ID="RDP_PraxeNastup" DbSelectedDate='<%# Bind("datum_nastupu") %>'
                                                                    DateInput-MinDate="1.1.1900 0:00:00" MinDate="1.1.1900 0:00:00">
                                                                </wc:TRadDatePicker>
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td>
                                                                <asp:Label ID="L_Ukonceni" runat="server" Text="Ukončení"></asp:Label>
                                                            </td>
                                                            <td>
                                                                <wc:TRadDatePicker runat="server" ID="RDP_PraxeUkonc" DbSelectedDate='<%# Bind("datum_ukonc") %>'
                                                                    DateInput-MinDate="1.1.1900 0:00:00" MinDate="1.1.1900 0:00:00">
                                                                </wc:TRadDatePicker>
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td style="white-space: nowrap">
                                                                <asp:Label ID="L_MistVykPrace" runat="server" Text="Místo výkonu práce"></asp:Label>
                                                            </td>
                                                            <td>
                                                                <wc:TextBoxCVUch ID="TB_MistVykPrace" runat="server" Text='<%# Bind("mist_vyk_prace") %>'
                                                                    Width="100%" MaxLength="30" />
                                                            </td>
                                                        </tr>
                                                    </table>
                                                    <div style="padding: 10px;">
                                                    </div>
                                                </ItemTemplate>
                                            </telerik:RadListView>
                                        </fieldset>
                                    </div>
                                </asp:Panel>
                                <%--<div style="float: none; padding-bottom: 5px">
                                    <asp:ValidationSummary ID="VS_Praxe" runat="server" ValidationGroup="VG_Praxe" ForeColor="Red" />
                                </div>--%>
                            </telerik:RadPageView>
                            <%--*********************************************************************************************--%>
                            <%--********** 4. Znalosti a dovednosti *********************************************************--%>
                            <%--*********************************************************************************************--%>
                            <telerik:RadPageView runat="server" ID="RPV_ZnalostiDovednosti" BackColor="White" Style="min-height: 160px">
                                <div style="float: none;">
                                    <asp:ValidationSummary ID="VS_ZnalostiDovednosti" runat="server" ValidationGroup="VG_ZnalostiDovednosti" ForeColor="Red" />
                                </div>
                                <asp:Panel ID="P_ZnalostiDovednosti" runat="server">
                                    <div style="padding: 10px; display: block;">
                                        <fieldset id="FS_Jazyky" class="FieldSet" style="max-width: 450px;">
                                            <legend class="FieldSetLegend">JAZYKOVÉ ZNALOSTI</legend>
                                            <asp:ObjectDataSource ID="ODS_Jazyky" runat="server" SelectMethod="JazykySeznam" TypeName="KSProgram.Ciselniky.CisJazyku"
                                                OldValuesParameterFormatString="original_{0}">
                                                <SelectParameters>
                                                    <asp:Parameter DefaultValue="true" Name="pridatPrazdnyRadek" Type="Boolean" />
                                                    <asp:Parameter DefaultValue="ORDER BY nazev" Name="expression_OrderBy" Type="String" />
                                                </SelectParameters>
                                            </asp:ObjectDataSource>
                                            <asp:ObjectDataSource ID="ODS_JazykStupen" runat="server" SelectMethod="StupenZnalostiSeznam"
                                                TypeName="KSProgram.Ciselniky.CisJazyku">
                                                <SelectParameters>
                                                    <asp:Parameter DefaultValue="true" Name="pridatPrazdnyRadek" Type="Boolean" />
                                                </SelectParameters>
                                            </asp:ObjectDataSource>
                                            <telerik:RadListView ID="RLV_Jazyky" runat="server" ItemPlaceholderID="JazykyContainer" OnNeedDataSource="RLV_Jazyky_NeedDataSource" DataKeyNames="id">
                                                <LayoutTemplate>
                                                    <asp:PlaceHolder runat="server" ID="JazykyContainer" />
                                                    <kspwc:TRadButton ID="BTN_Jazyk_SmazatZaznam" runat="server" Text="[%Smazat záznam%]" AutoPostBack="true" OnClick="BTN_Jazyky_SmazatZaznam_Click">
                                                        <Icon PrimaryIconCssClass="fi fi-trash"></Icon>
                                                    </kspwc:TRadButton>
                                                    <kspwc:TRadButton ID="BTN_Jazyk_NovyZaznam" runat="server" Text="[%Nový záznam%]" AutoPostBack="true" OnClick="BTN_Jazyky_NovyZaznam_Click">
                                                        <Icon PrimaryIconCssClass="fi fi-add"></Icon>
                                                    </kspwc:TRadButton>
                                                </LayoutTemplate>
                                                <ItemTemplate>
                                                    <table width="100%" style="border-bottom-width: 1px; border-bottom-style: solid; border-bottom-color: lightgray; padding-bottom: 6px; max-width: 450px">
                                                        <tr>
                                                            <td style="width: 10px">
                                                                <asp:Label ID="L_Jazyk" runat="server" Text="Jazyk"></asp:Label>
                                                            </td>
                                                            <td>
                                                                <wc:DropDownListCVUch ID="DDL_Jazyky" runat="server" SelectedValue='<%# Bind("jazyk") %>'
                                                                    DataSourceID="ODS_Jazyky" DataTextField="nazev" DataValueField="jazyk" PovinnePoleParametrem="Jazyk" ValidationGroup="VG_ZnalostiDovednosti" PopisPole="Jazyk"
                                                                    Width="170px">
                                                                </wc:DropDownListCVUch>
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td style="white-space: nowrap">
                                                                <asp:Label ID="L_JazykStupen" runat="server" Text="Stupeň znalosti"></asp:Label>
                                                            </td>
                                                            <td>
                                                                <wc:DropDownListCVUch ID="DDL_JazykStupen" runat="server" SelectedValue='<%# Bind("Stupen") %>'
                                                                    DataSourceID="ODS_JazykStupen" DataTextField="vyznam" DataValueField="cislo" PovinnePoleParametrem="JazykStupen" ValidationGroup="VG_ZnalostiDovednosti"
                                                                    Width="170px" PopisPole="Stupeň znalosti">
                                                                </wc:DropDownListCVUch>
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td style="white-space: nowrap">
                                                                <asp:Label ID="L_JazykDruhZkousky" runat="server" Text="Druh zkoušky"></asp:Label>
                                                            </td>
                                                            <td>
                                                                <wc:DropDownListCVUch ID="DDL_JazykDruhZkousky" runat="server" SelectedValue='<%# Bind("druh_zkousky")%>' PovinnePoleParametrem="JazykDruhZkousky"
                                                                    Width="170px" ValidationGroup="VG_ZnalostiDovednosti" PopisPole="Druh zkoušky">
                                                                    <asp:ListItem Text="" Value=""></asp:ListItem>
                                                                    <asp:ListItem Text="kurs" Value="kurs"></asp:ListItem>
                                                                    <asp:ListItem Text="maturita" Value="maturita"></asp:ListItem>
                                                                    <asp:ListItem Text="státnice" Value="státnice"></asp:ListItem>
                                                                    <asp:ListItem Text="jiné" Value="jiné"></asp:ListItem>
                                                                </wc:DropDownListCVUch>
                                                            </td>
                                                        </tr>
                                                    </table>
                                                    <div style="padding: 10px;">
                                                    </div>
                                                </ItemTemplate>
                                            </telerik:RadListView>
                                        </fieldset>
                                    </div>
                                    <div style="padding: 10px">
                                        <fieldset id="FS_Kurzy" class="FieldSet" style="max-width: 450px;">
                                            <legend class="FieldSetLegend">ABSOLVOVANÉ KURZY</legend>
                                            <asp:ObjectDataSource ID="ODS_CisOsve" runat="server" SelectMethod="SkoCislSeznam"
                                                TypeName="KSProgram.Ciselniky.CisSkoCisl" OldValuesParameterFormatString="original_{0}">
                                                <SelectParameters>
                                                    <asp:Parameter DefaultValue="text_osve" Name="sort" Type="String" />
                                                    <asp:Parameter DefaultValue=" AND (nenabizet IS NULL OR nenabizet = 3)" Name="podminka"
                                                        Type="String" />
                                                    <asp:Parameter DefaultValue="true" Name="pridatPrazdnyRadek" Type="Boolean" />
                                                </SelectParameters>
                                            </asp:ObjectDataSource>
                                            <telerik:RadListView ID="RLV_Kurzy" runat="server" ItemPlaceholderID="KurzyContainer" OnNeedDataSource="RLV_Kurzy_NeedDataSource" DataKeyNames="id">
                                                <LayoutTemplate>
                                                    <asp:PlaceHolder runat="server" ID="KurzyContainer" />
                                                    <kspwc:TRadButton ID="BTN_Kurz_SmazatZaznam" runat="server" Text="[%Smazat záznam%]" AutoPostBack="true" OnClick="BTN_Kurz_SmazatZaznam_Click">
                                                        <Icon PrimaryIconCssClass="fi fi-trash"></Icon>
                                                    </kspwc:TRadButton>
                                                    <kspwc:TRadButton ID="BTN_Kurz_NovyZaznam" runat="server" Text="[%Nový záznam%]" AutoPostBack="true" OnClick="BTN_Kurz_NovyZaznam_Click">
                                                        <Icon PrimaryIconCssClass="fi fi-add"></Icon>
                                                    </kspwc:TRadButton>
                                                </LayoutTemplate>
                                                <ItemTemplate>
                                                    <table width="100%" style="border-bottom-width: 1px; border-bottom-style: solid; border-bottom-color: lightgray; padding-bottom: 6px; max-width: 450px">
                                                        <tr>
                                                            <td style="white-space: nowrap; width: 10px">
                                                                <asp:Label ID="L_Kurz" runat="server" Text="Osvědčení / Kurz"></asp:Label>
                                                            </td>
                                                            <td>
                                                                <wc:DropDownListCVUch ID="DDL_Kurz" runat="server" SelectedValue='<%# Bind("cis_osve") %>'
                                                                    DataSourceID="ODS_CisOsve" DataTextField="text_osve" DataValueField="cislo" Width="100%">
                                                                </wc:DropDownListCVUch>
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td style="white-space: nowrap">
                                                                <asp:Label ID="L_NazevAkce" runat="server" Text="Název akce"></asp:Label>
                                                            </td>
                                                            <td>
                                                                <wc:TextBoxCVUch ID="TB_NazevAkce" runat="server" Text='<%# Bind("skoleni") %>' MaxLength="100"
                                                                    Width="100%"></wc:TextBoxCVUch>
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td style="white-space: nowrap">
                                                                <asp:Label ID="L_KurzPlatiDo" runat="server" Text="Platí do"></asp:Label>
                                                            </td>
                                                            <td>
                                                                <wc:TRadDatePicker runat="server" ID="RDP_KurzPlatiDo" DbSelectedDate='<%# Bind("plati_do") %>'
                                                                    DateInput-MinDate="1.1.1900 0:00:00" MinDate="1.1.1900 0:00:00">
                                                                </wc:TRadDatePicker>
                                                                <td></td>
                                                        </tr>
                                                    </table>
                                                    <div style="padding: 10px;">
                                                    </div>
                                                </ItemTemplate>
                                            </telerik:RadListView>
                                        </fieldset>
                                    </div>
                                    <div style="padding: 10px;">
                                        <fieldset id="FS_Ridic" class="FieldSet" style="max-width: 450px;">
                                            <legend class="FieldSetLegend">ŘIDIČSKÝ PRŮKAZ</legend>

                                            <%--<asp:Label ID="L_Ridicaky" runat="server" Text="Skupina"></asp:Label>--%>
                                            <asp:CheckBox ID="CHB_RidicA" runat="server" Text="A" />
                                            <asp:CheckBox ID="CHB_RidicB" runat="server" Text="B" />
                                            <asp:CheckBox ID="CHB_RidicC" runat="server" Text="C" />
                                            <asp:CheckBox ID="CHB_RidicD" runat="server" Text="D" />
                                            <asp:CheckBox ID="CHB_RidicE" runat="server" Text="E" />
                                            <asp:CheckBox ID="CHB_RidicT" runat="server" Text="T" />
                                            <div style="display: inline-block">
                                                <asp:CheckBox ID="CHB_RidicNone" runat="server" Text="Nemám" OnCheckedChanged="CHB_RidicNone_CheckedChanged" AutoPostBack="true" />
                                            </div>
                                            <asp:Label ID="L_RidicakyStar" runat="server" Text="*" CssClass="StarRequired" Visible="<%# IsRequired(KSProgram.Uchazeci.PovinneUdaje.Ridicak) %>"></asp:Label>
                                            <asp:CustomValidator ID="CV_Ridicak" runat="server" ErrorMessage="Není zadaná povinná hodnota pole: <b>Řidičský průkaz</b>" OnServerValidate="CV_Ridicak_ServerValidate"
                                                ValidationGroup="VG_ZnalostiDovednosti" Display="None" Enabled="<%# IsRequired(KSProgram.Uchazeci.PovinneUdaje.Ridicak) %>"></asp:CustomValidator>
                                        </fieldset>
                                    </div>
                                </asp:Panel>
                                <%--<div style="float: none; padding-bottom: 5px">
                                    <asp:ValidationSummary ID="VS_ZnalostiDovednosti" runat="server" ValidationGroup="VG_ZnalostiDovednosti" ForeColor="Red" />
                                </div>--%>
                            </telerik:RadPageView>
                            <%--*********************************************************************************************--%>
                            <%--********** 5. Hledaná práce *****************************************************************--%>
                            <%--*********************************************************************************************--%>
                            <telerik:RadPageView runat="server" ID="RPV_HledanaPrace" BackColor="White" Style="min-height: 160px">
                                <div style="float: none;">
                                    <asp:ValidationSummary ID="VS_HledanaPrace" runat="server" ValidationGroup="VG_HledanaPrace" ForeColor="Red" />
                                </div>
                                <asp:Panel ID="P_HledanaPrace" runat="server">
                                    <div style="padding: 10px;">
                                        <fieldset id="FS_HledanaPrace" class="FieldSet" style="max-width: 450px;">
                                            <legend id="FSL_HledanaPrace" runat="server" class="FieldSetLegend">HLEDANÁ PRÁCE</legend>
                                            <telerik:RadListView ID="RLV_HledanaPrace" runat="server" ItemPlaceholderID="HledanaPraceContainer" OnNeedDataSource="RLV_HledanaPrace_NeedDataSource" DataKeyNames="id">
                                                <LayoutTemplate>
                                                    <asp:PlaceHolder runat="server" ID="HledanaPraceContainer" />
                                                    <kspwc:TRadButton ID="BTN_HledanaPrace_SmazatZaznam" runat="server" Text="[%Smazat záznam%]" AutoPostBack="true" OnClick="BTN_HledanaPrace_SmazatZaznam_Click">
                                                        <Icon PrimaryIconCssClass="fi fi-trash"></Icon>
                                                    </kspwc:TRadButton>
                                                    <kspwc:TRadButton ID="BTN_HledanaPrace_NovyZaznam" runat="server" Text="[%Nový záznam%]" AutoPostBack="true" OnClick="BTN_HledanaPrace_NovyZaznam_Click">
                                                        <Icon PrimaryIconCssClass="fi fi-add"></Icon>
                                                    </kspwc:TRadButton>
                                                </LayoutTemplate>
                                                <ItemTemplate>
                                                    <table width="100%" style="border-bottom-width: 1px; border-bottom-style: solid; border-bottom-color: lightgray; padding-bottom: 6px; max-width: 450px">
                                                        <tr>
                                                            <td style="width: 10px">
                                                                <asp:Label ID="L_HPProfese" runat="server" Text="Profese"></asp:Label>
                                                            </td>
                                                            <td>
                                                                <wc:DropDownListCVUch ID="DDL_HPProfese" runat="server" SelectedValue='<%# Bind("profese") %>'
                                                                    DataSourceID="ODS_Profese" DataTextField="nazev" DataValueField="cislo" PovinnePoleParametrem="HledanaPraceProfese" PopisPole="Profese"
                                                                    Width="100%" ValidationGroup="VG_HledanaPrace">
                                                                </wc:DropDownListCVUch>
                                                            </td>
                                                        </tr>
                                                        <%--<tr runat="server" visible='<%#_isMorSlezKraj %>'>
                                                            <td style="width: 10px">
                                                                <asp:Label ID="L_VyberoveRizeni" runat="server" Text="Výběrové řízení"></asp:Label>
                                                            </td>
                                                            <td>
                                                                <wc:DropDownListCVUch ID="DDL_VyberoveRizeni" runat="server" SelectedValue='<%# Bind("id_vybriz") %>'
                                                                    DataSourceID="ODS_VR_Publikovane" DataTextField="nazev" DataValueField="id_vybriz" PovinnePoleParametrem="HledanaPraceProfese" PopisPole="Profese"
                                                                    Width="100%"  ValidationGroup="VG_HledanaPrace">
                                                                </wc:DropDownListCVUch>
                                                            </td>
                                                        </tr>--%>
                                                        <tr>
                                                            <td style="white-space: nowrap">
                                                                <asp:Label ID="L_Plat" runat="server" Text="Očekávaný plat"></asp:Label>
                                                            </td>
                                                            <td>
                                                                <wc:TextBoxCVUch ID="TB_Plat" runat="server" Text='<%# Bind("plat") %>' MaxLength="10" Type="Number" ValidationGroup="VG_HledanaPrace"
                                                                    PopisPole="Očekávaný plat" Width="100%"></wc:TextBoxCVUch>
                                                            </td>
                                                        </tr>
                                                    </table>
                                                    <div style="padding: 10px;">
                                                    </div>
                                                </ItemTemplate>
                                            </telerik:RadListView>
                                        </fieldset>
                                    </div>
                                </asp:Panel>
                                <%--<div style="float: none; padding-bottom: 5px">
                                    <asp:ValidationSummary ID="VS_HledanaPrace" runat="server" ValidationGroup="VG_HledanaPrace" ForeColor="Red" />
                                </div>--%>
                            </telerik:RadPageView>
                            <%--*********************************************************************************************--%>
                            <%--********** 6. Dokumenty *********************************************************************--%>
                            <%--*********************************************************************************************--%>
                            <telerik:RadPageView runat="server" ID="RPV_Dokumenty" BackColor="White" Style="min-height: 160px" OnPreRender="RPV_Dokumenty_PreRender">
                                <div style="float: none;">
                                    <asp:ValidationSummary ID="VS_Dokumenty" runat="server" ValidationGroup="VG_Dokumenty" ForeColor="Red" />
                                </div>
                                <asp:Panel ID="P_Dokumenty" runat="server">
                                    <div style="padding: 10px;">
                                        <fieldset id="FS_Dokumenty" class="FieldSet" style="max-width: 650px;">
                                            <legend class="FieldSetLegend">DOKUMENTY</legend>
                                            <asp:ObjectDataSource ID="ODS_DruhyDok" runat="server" SelectMethod="TypyDokumentu_uch"
                                                TypeName="KSProgram.Ciselniky.CisDruhyDokumentu">
                                                <SelectParameters>
                                                    <asp:Parameter DefaultValue="true" Name="pridatPrazdnyRadek" Type="Boolean" />
                                                </SelectParameters>
                                            </asp:ObjectDataSource>
                                            <asp:Label ID="L_PovinneDokumenty" runat="server" Text="" Visible="false"></asp:Label>
                                            <kspwc:TRadGrid ID="RG_Dokumenty" runat="server" AutoGenerateColumns="False" CssClass=""
                                                AllowSorting="True" AllowAutomaticInserts="false" OnItemCommand="RG_Dokumenty_ItemCommand" ExportSettings-ExportOnlyData="false"
                                                OnNeedDataSource="RG_Dokumenty_NeedDataSource" CaptionVisible="false"
                                                AutoMasterGridWidth="true" Width="100%">
                                                <MasterTableView DataKeyNames="id_int" AutoGenerateColumns="false"
                                                    CommandItemDisplay="Bottom" AllowFilteringByColumn="False">
                                                    <Columns>
                                                        <telerik:GridTemplateColumn UniqueName="delete" AllowFiltering="False" Groupable="False" Reorderable="False" AllowSorting="false" HeaderStyle-Width="50">
                                                            <ItemTemplate>
                                                                <wc:TRadButton ID="RB_delete" runat="server" ConfirmText="[%Opravdu si přejete smazat vybraný záznam?%]"
                                                                    ConfirmTitle="[%Mazání dokumentu%]" CommandName="delete" ToolTip="[%Smazat dokument%]" Text="[%Smazat záznam%]">
                                                                    <%--<Icon PrimaryIconCssClass="rbCancel" PrimaryIconLeft="5px"></Icon>--%>
                                                                    <Icon PrimaryIconCssClass="fi fi-trash"></Icon>
                                                                </wc:TRadButton>
                                                            </ItemTemplate>
                                                        </telerik:GridTemplateColumn>
                                                        <telerik:GridDropDownColumn DataSourceID="ODS_DruhyDok" ListTextField="nazev" ListValueField="id"
                                                            UniqueName="typ_dokumentu" SortExpression="typ_dokumentu" HeaderText="[%Typ dokumentu%]"
                                                            DataField="typ_dokumentu" AllowAutomaticLoadOnDemand="true" AllowVirtualScrolling="true">
                                                        </telerik:GridDropDownColumn>
                                                        <telerik:GridBoundColumn UniqueName="nazev_soubor" HeaderText="Název souboru" DataField="nazev_soubor"
                                                            MaxLength="50">
                                                        </telerik:GridBoundColumn>
                                                        <%--<telerik:GridAttachmentColumn UploadControlType="RadAsyncUpload" EditFormHeaderTextFormat="Upload File:"
                                                        HeaderText="[%Dokument%]" FileNameTextField="nazev_soubor" DataTextField="nazev_soubor"
                                                        UniqueName="dokument" AllowedFileExtensions="txt,bmp,jpg,png,doc,docx,xml,csv,xls,xlsx,ods,odt,pdf"
                                                        AttachmentKeyFields="id" ButtonCssClass="no-block-ui" HeaderStyle-Width="80">
                                                    </telerik:GridAttachmentColumn>--%>
                                                    </Columns>
                                                    <EditFormSettings EditFormType="Template">
                                                        <FormTemplate>
                                                            <div style="padding: 10px;">
                                                                <asp:Label ID="L_MaxSoubor" runat="server" Text="[%Maximální velikost dokumentu%]: 1 MB!" ForeColor="#213D71"></asp:Label>
                                                            </div>
                                                            <table width="100%" style="padding: 10px; max-width: 650px;" cellpadding="5px">
                                                                <tr>
                                                                    <td style="width: 10px;">
                                                                        <asp:Label ID="L_DokumentSoubor" runat="server" Text="Soubor"></asp:Label>
                                                                    </td>
                                                                    <td>
                                                                        <asp:FileUpload ID="FU_Dokument" runat="server" Width="100%" />
                                                                        <asp:RequiredFieldValidator ID="RequiredFieldValidatorDokumenty" runat="server" ErrorMessage="Soubor není vyplněn!"
                                                                            ControlToValidate="FU_Dokument" Display="None" ValidationGroup="VG_Dokumenty"></asp:RequiredFieldValidator>
                                                                    </td>
                                                                </tr>
                                                                <tr>
                                                                    <td style="white-space: nowrap">
                                                                        <asp:Label ID="L_TypDok" runat="server" Text="Typ dokumentu"></asp:Label>
                                                                    </td>
                                                                    <td>
                                                                        <wc:DropDownListCVUch ID="DDL_TypDok" runat="server" SelectedValue='<%# Bind("typ_dokumentu") %>'
                                                                            DataSourceID="ODS_DruhyDok" DataTextField="nazev" DataValueField="id" PovinnePoleParametrem="DokTyp" PopisPole="Typ dokumentu"
                                                                            Width="100%" ValidationGroup="VG_Dokumenty">
                                                                        </wc:DropDownListCVUch>
                                                                    </td>
                                                                </tr>
                                                                <tr style="padding-top: 20px">
                                                                    <td align="left" colspan="2" style="padding-top: 20px">
                                                                        <wc:TRadButton ID="BTN_Update" Text='<%# (Container is GridEditFormInsertItem) ? "Vložit" : "Aktualizovat" %>' Icon-PrimaryIconCssClass="fi fi-add"
                                                                            runat="server" CommandName='<%# (Container is GridEditFormInsertItem) ? "PerformInsert" : "Update" %>' ValidationGroup="VG_Dokumenty">
                                                                        </wc:TRadButton>
                                                                        <wc:TRadButton ID="BTN_Cancel" Text="Zrušit" runat="server" CausesValidation="False" Icon-PrimaryIconCssClass="fi fi-ban"
                                                                            CommandName="Cancel">
                                                                        </wc:TRadButton>
                                                                    </td>
                                                                </tr>
                                                            </table>
                                                        </FormTemplate>
                                                    </EditFormSettings>
                                                    <CommandItemTemplate>
                                                        <kspwc:GridCommandItemControl ID="GCIC" runat="server" AddNewItemButton-Visible="true" FilterButton-Visible="false" ExportButton-Visible="false" RebindButton-Visible="false">
                                                        </kspwc:GridCommandItemControl>
                                                    </CommandItemTemplate>
                                                </MasterTableView>

                                            </kspwc:TRadGrid>
                                        </fieldset>
                                    </div>
                                </asp:Panel>
                                <%--<div style="float: none; padding-bottom: 5px">
                                    <asp:ValidationSummary ID="VS_Dokumenty" runat="server" ValidationGroup="VG_Dokumenty" ForeColor="Red" />
                                </div>--%>
                            </telerik:RadPageView>
                            <%--*********************************************************************************************--%>
                            <%--********** 7. Odeslání formuláře ************************************************************--%>
                            <%--*********************************************************************************************--%>
                            <telerik:RadPageView runat="server" ID="RPV_Odeslani" BackColor="White">
                                <asp:Panel ID="P_Odeslani" runat="server">
                                    <div style="padding: 10px">
                                        <fieldset id="FS_Souhlas101" class="FieldSet">
                                            <legend class="FieldSetLegend">SOUHLAS S EVIDENCÍ</legend>
                                            <table cellpadding="10">
                                                <tr>
                                                    <td align="justify">
                                                        <asp:Label ID="L_Souhlas101" runat="server" Text="*" CssClass="StarRequired"></asp:Label>
                                                        <asp:CheckBox ID="CHB_Souhlas101" runat="server" Text="" />
                                                        <asp:CustomValidator ID="CV_Souhlas101" runat="server" ErrorMessage="Údaje nemohou být odeslány bez souhlasu se zpracováním osobních údajů!"
                                                            OnServerValidate="Validate101" ValidationGroup="VG_Souhlas101" ValidateEmptyText="True"
                                                            Display="None"></asp:CustomValidator>
                                                        <asp:Label ID="L_Souhlas" runat="server" Text=""></asp:Label>
                                                    </td>
                                                </tr>
                                            </table>
                                        </fieldset>
                                    </div>
                                    <div style="padding: 10px">
                                        <fieldset id="FS_Odeslat" class="FieldSet">
                                            <legend class="FieldSetLegend">ODESLÁNÍ</legend>
                                            <table cellpadding="10" style="margin: auto">
                                                <tr>
                                                    <td>
                                                        <asp:Label ID="L_NotValidTabs" runat="server" Text="Nelze odeslat, nejsou vyplněny všechny záložky označené symbolem: " ForeColor="Red"></asp:Label>
                                                        <asp:Image ID="IMG_NotValidTabs" runat="server" ImageUrl="~/Images/Attention_red.png" />
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td align="center">
                                                        <telerik:RadCaptcha ID="RC_Captcha" runat="server" EnableRefreshImage="True" Display="None"
                                                            ValidatedTextBoxID="TB_Captcha" ValidationGroup="VG_Souhlas101">
                                                            <CaptchaImage LineNoise="Extreme" BackgroundColor="White" BackgroundNoise="Extreme"
                                                                TextColor="black" FontWarp="Extreme" RenderImageOnly="True" />
                                                        </telerik:RadCaptcha>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td>
                                                        <asp:Label ID="L_Captcha" runat="server"></asp:Label>
                                                        <asp:TextBox ID="TB_Captcha" runat="server" MaxLength="10" BorderColor="LightGray" BorderStyle="Solid" BorderWidth="1px" />
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td>
                                                        <wc:TRadButton ID="BTN_Odeslat" Text="Odeslat" runat="server" Visible="True" OnClick="BTN_Odeslat_Click"
                                                            ValidationGroup="VG_Souhlas101" BorderColor="LightGray" Width="100%" Height="50px" Font-Size="20px" />
                                                    </td>
                                                </tr>
                                            </table>
                                        </fieldset>
                                    </div>
                                </asp:Panel>
                                <div style="float: none; padding-bottom: 5px">
                                    <asp:ValidationSummary ID="VS_Souhlas101" runat="server" ValidationGroup="VG_Souhlas101" ForeColor="Red" />
                                </div>
                            </telerik:RadPageView>
                            <%--*********************************************************************************************--%>
                            <%--********** 8. Výběrová řízení ***************************************************************--%>
                            <%--*********************************************************************************************--%>
                            <%--Specialita pro 'MOR SLEZ KRAJ'--%>
                            <telerik:RadPageView runat="server" ID="RPV_VyberovaRizení" BackColor="White" Style="min-height: 160px">
                                <div style="float: none;">
                                    <asp:ValidationSummary ID="VS_VyberovaRizeni" runat="server" ValidationGroup="VG_VyberovaRizeni" ForeColor="Red" />
                                </div>
                                <asp:Panel ID="P_VyberovaRizeni" runat="server">
                                    <div style="padding: 10px;">
                                        <fieldset id="FS_VyberovaRizeni" class="FieldSet" style="max-width: 450px;">
                                            <legend id="FSL_VyberovaRizeni" runat="server" class="FieldSetLegend">VÝBĚROVÁ ŘÍZENÍ</legend>
                                            <asp:ObjectDataSource ID="ODS_VR_Publikovane" runat="server" SelectMethod="Publikovane"
                                                TypeName="KSProgram.VyberovaRizeni.VyberovaRizeni" OldValuesParameterFormatString="original_{0}">
                                                <SelectParameters>
                                                    <asp:Parameter DefaultValue="false" Name="interni" Type="Boolean" />
                                                    <asp:Parameter DefaultValue="true" Name="externi" Type="Boolean" />
                                                    <asp:Parameter DefaultValue="true" Name="pridatPrazdnyRadek" Type="Boolean" />
                                                </SelectParameters>
                                            </asp:ObjectDataSource>
                                            <br />
                                            <asp:Label ID="L_VR_Text" runat="server" Text="<b>Je umožněno doplnit více výběrových řízení, do kterých budete odesláním formuláře zařazeni.</b>"></asp:Label>
                                            <br />
                                            <br />
                                            <telerik:RadListView ID="RLV_VyberovaRizeni" runat="server" ItemPlaceholderID="VyberovaRizeniContainer" OnNeedDataSource="RLV_VyberovaRizeni_NeedDataSource" OnPreRender="RLV_VyberovaRizeni_PreRender" DataKeyNames="id">
                                                <LayoutTemplate>
                                                    <asp:PlaceHolder runat="server" ID="VyberovaRizeniContainer" />
                                                    <kspwc:TRadButton ID="BTN_VyberovaRizeni_SmazatZaznam" runat="server" Text="[%Smazat záznam%]" AutoPostBack="true" OnClick="BTN_VyberovaRizeni_SmazatZaznam_Click">
                                                        <Icon PrimaryIconCssClass="fi fi-trash"></Icon>
                                                    </kspwc:TRadButton>
                                                    <kspwc:TRadButton ID="BTN_VyberovaRizeni_NovyZaznam" runat="server" Text="[%Nový záznam%]" AutoPostBack="true" OnClick="BTN_VyberovaRizeni_NovyZaznam_Click">
                                                        <Icon PrimaryIconCssClass="fi fi-add"></Icon>
                                                    </kspwc:TRadButton>
                                                </LayoutTemplate>
                                                <ItemTemplate>
                                                    <table width="100%" style="border-bottom-width: 1px; border-bottom-style: solid; border-bottom-color: lightgray; padding-bottom: 6px; max-width: 450px">
                                                        <tr>
                                                            <td style="width: 10px; white-space: nowrap">
                                                                <asp:Label ID="L_VyberoveRizeni" runat="server" Text="Výběrové řízení"></asp:Label>
                                                            </td>
                                                            <td>
                                                                <wc:DropDownListCVUch ID="DDL_VyberoveRizeni" runat="server" SelectedValue='<%# Bind("id_vybriz") %>'
                                                                    DataSourceID="ODS_VR_Publikovane" DataTextField="nazev" DataValueField="id_vybriz" PovinnePole="true" PopisPole="Výběrové řízení"
                                                                    Width="100%" ValidationGroup="VG_VyberovaRizeni">
                                                                </wc:DropDownListCVUch>
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td style="white-space: nowrap">
                                                                <asp:Label ID="L_Plat_MSK" runat="server" Text="Očekávaný plat"></asp:Label>
                                                            </td>
                                                            <td>
                                                                <wc:TextBoxCVUch ID="TB_Plat_MSK" runat="server" Text='<%# Bind("poznamka_1") %>' MaxLength="10" Type="Number" ValidationGroup="VG_VyberovaRizeni"
                                                                    PopisPole="Očekávaný plat" Width="100%"></wc:TextBoxCVUch>
                                                            </td>
                                                        </tr>
                                                    </table>
                                                    <div style="padding: 10px;">
                                                    </div>
                                                </ItemTemplate>
                                            </telerik:RadListView>
                                        </fieldset>
                                    </div>
                                </asp:Panel>
                                <%--<div style="float: none; padding-bottom: 5px">
                                    <asp:ValidationSummary ID="VS_VyberovaRizeni" runat="server" ValidationGroup="VG_VyberovaRizeni" ForeColor="Red" />
                                </div>--%>
                            </telerik:RadPageView>
                            <%--*********************************************************************************************--%>
                            <%--********** 9. Dokumenty MSK *****************************************************************--%>
                            <%--*********************************************************************************************--%>
                            <%--                            <telerik:RadPageView runat="server" ID="RPV_Dokumenty_MSK" BackColor="White" Style="min-height: 160px">
                                <asp:Panel ID="P_Dokumenty_MSK" runat="server">
                                    <div style="padding: 10px;">
                                        <fieldset id="FS_Dokumenty_MSK" class="FieldSet" style="max-width: 650px;">
                                            <legend class="FieldSetLegend">DOKUMENTY</legend>
                                            <table width="100%" style="max-width: 400px">
                                                <tr>
                                                    <td style="width:10px">
                                                        <asp:Label ID="Label1" runat="server" Text="Jméno"></asp:Label>
                                                    </td>
                                                    <td>
                                                        <asp:FileUpload ID="FU_Dokument1_MSK" runat="server" Width="100%" />
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td style="white-space:nowrap">Dokument 1</td>
                                                    <td>
                                                        <telerik:RadAsyncUpload ID="RAU_Dokument1_MSK" runat="server" MaxFileInputsCount="1" OnFileUploaded="RAU_Dokument1_MSK_FileUploaded" HideFileInput="true" on></telerik:RadAsyncUpload>
                                                        <kspwc:TRadButton ID="btnTest" runat="server" Text="Test" OnClick="btnTest_Click"></kspwc:TRadButton>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td style="white-space:nowrap">Dokument 2</td>
                                                    <td>
                                                        <telerik:RadUpload ID="RFU_Dokument2_MSK" runat="server" ControlObjectsVisibility="ClearButtons"></telerik:RadUpload>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td style="white-space:nowrap">Dokument 3</td>
                                                    <td>
                                                        <telerik:RadUpload ID="RFU_Dokument3_MSK" runat="server" ControlObjectsVisibility="ClearButtons" OnClientFileSelected="FileSelected"></telerik:RadUpload>
                                                    </td>
                                                </tr>
                                            </table>
                                        </fieldset>
                                    </div>
                                </asp:Panel>
                                <div style="float: none; padding-bottom: 5px">
                                    <asp:ValidationSummary ID="VS_Dokumenty_MSK" runat="server" ValidationGroup="VG_Dokumenty_MSK" ForeColor="Red" />
                                </div>
                            </telerik:RadPageView>--%>

                            <%--*********************************************************************************************--%>
                            <%--********** 10. Odeslání formuláře MSK *******************************************************--%>
                            <%--*********************************************************************************************--%>
                            <telerik:RadPageView runat="server" ID="RPV_Odeslani_MSK" BackColor="White">
                                <asp:Panel ID="P_Odeslani_MSK" runat="server">
                                    <asp:CustomValidator ID="CV_Souhlas_MSK" runat="server" ErrorMessage="Údaje nemohou být odeslány bez vyplnění povinných údajů!"
                                        OnServerValidate="ValidateSouhlas_MSK" ValidationGroup="VG_Souhlas_MSK" ValidateEmptyText="True"
                                        Display="None"></asp:CustomValidator>
                                    <%--===== Úředník =====--%>
                                    <asp:Panel ID="P_SouhlasUrednik_MSK" runat="server">
                                        <div style="padding: 10px">
                                            <fieldset id="FS_SouhlasUrednik_MSK" class="FieldSet">
                                                <legend class="FieldSetLegend">SOUHLAS S EVIDENCÍ</legend>
                                                <table cellpadding="10">
                                                    <tr>
                                                        <td align="justify">
                                                            <asp:Label ID="L_SouhlasUrednik_MSK" runat="server" Text=""></asp:Label>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td align="justify">
                                                            <asp:CheckBox ID="CHB_SouhlasUrednik2_MSK" runat="server" Text="" />
                                                            <asp:Label ID="L_SouhlasUrednik2Star_MSK" runat="server" Text="* " CssClass="StarRequired"></asp:Label>
                                                            <asp:Label ID="L_SouhlasUrednik2_MSK" runat="server" Text=""></asp:Label>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td align="justify">
                                                            <asp:CheckBox ID="CHB_SouhlasUrednik3_MSK" runat="server" Text="" />
                                                            <asp:Label ID="L_SouhlasUrednik3_MSK" runat="server" Text=""></asp:Label>
                                                            <br />
                                                            <a href="https://www.msk.cz/assets/volna_mista/souhlas-gdpr-vr-5-2018.pdf" target="_blank">(https://www.msk.cz/assets/volna_mista/souhlas-gdpr-vr-5-2018.pdf)</a>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td align="justify">
                                                            <asp:CheckBox ID="CHB_SouhlasUrednik4_MSK" runat="server" Text="" />
                                                            <asp:Label ID="L_SouhlasUrednik4Star_MSK" runat="server" Text="* " CssClass="StarRequired"></asp:Label>
                                                            <asp:Label ID="L_SouhlasUrednik4_MSK" runat="server" Text=""></asp:Label>
                                                        </td>
                                                    </tr>
                                                </table>
                                            </fieldset>
                                        </div>
                                        <%--===== Neúředník (zaměstnanec) =====--%>
                                    </asp:Panel>
                                    <asp:Panel ID="P_SouhlasZam_MSK" runat="server">
                                        <div style="padding: 10px">
                                            <fieldset id="FS_SouhlasZam_MSK" class="FieldSet">
                                                <legend class="FieldSetLegend">SOUHLAS S EVIDENCÍ</legend>
                                                <table cellpadding="10">
                                                    <tr>
                                                        <td align="justify">
                                                            <asp:Label ID="L_SouhlasZam_MSK" runat="server" Text=""></asp:Label>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td align="justify">
                                                            <asp:CheckBox ID="CHB_SouhlasZam2_MSK" runat="server" Text="" />
                                                            <asp:Label ID="L_SouhlasZam2_MSK" runat="server" Text=""></asp:Label>
                                                            <br />
                                                            <a href="https://www.msk.cz/assets/volna_mista/souhlas-gdpr-vr-5-2018.pdf" target="_blank">(https://www.msk.cz/assets/volna_mista/souhlas-gdpr-vr-5-2018.pdf)</a>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td align="justify">
                                                            <asp:CheckBox ID="CHB_SouhlasZam3_MSK" runat="server" Text="" />
                                                            <asp:Label ID="L_SouhlasZam3Star_MSK" runat="server" Text="* " CssClass="StarRequired"></asp:Label>
                                                            <asp:Label ID="L_SouhlasZam3_MSK" runat="server" Text=""></asp:Label>
                                                        </td>
                                                    </tr>
                                                </table>
                                            </fieldset>
                                        </div>
                                    </asp:Panel>
                                    <div style="padding: 10px">
                                        <fieldset id="FS_Odeslat_MSK" class="FieldSet">
                                            <legend class="FieldSetLegend">ODESLÁNÍ</legend>
                                            <table cellpadding="10">
                                                <tr>
                                                    <td>
                                                        <asp:Label ID="L_NotValidTabs_MSK" runat="server" Text="Nelze odeslat, nejsou vyplněny všechny záložky označené symbolem: " ForeColor="Red"></asp:Label>
                                                        <asp:Image ID="IMG_NotValidTabs_MSK" runat="server" ImageUrl="~/Images/Attention_red.png" />
                                                        <div style="float: none; padding-bottom: 5px">
                                                            <asp:ValidationSummary ID="ValidationSummary1" runat="server" ValidationGroup="VG_Souhlas_MSK" ForeColor="Red" />
                                                        </div>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td align="center">
                                                        <telerik:RadCaptcha ID="RC_Captcha_MSK" runat="server" EnableRefreshImage="True" Display="None"
                                                            ValidatedTextBoxID="TB_Captcha_MSK" ValidationGroup="VG_Souhlas_MSK">
                                                            <CaptchaImage LineNoise="Extreme" BackgroundColor="White" BackgroundNoise="Extreme"
                                                                TextColor="black" FontWarp="Extreme" RenderImageOnly="True" />
                                                        </telerik:RadCaptcha>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td>
                                                        <asp:Label ID="L_Captcha_MSK" runat="server"></asp:Label>
                                                        <asp:TextBox ID="TB_Captcha_MSK" runat="server" MaxLength="10" BorderColor="LightGray" BorderStyle="Solid" BorderWidth="1px" />
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td>
                                                        <wc:TRadButton ID="BTN_Odeslat_MSK" Text="Odeslat" runat="server" Visible="True" OnClick="BTN_Odeslat_Click"
                                                            ValidationGroup="VG_Souhlas_MSK" BorderColor="LightGray" />
                                                    </td>
                                                </tr>
                                            </table>
                                        </fieldset>
                                    </div>
                                </asp:Panel>
                                <%--<div style="float: none; padding-bottom: 5px">
                                    <asp:ValidationSummary ID="VS_Souhlas101_MSK" runat="server" ValidationGroup="VG_Souhlas_MSK" ForeColor="Red" />
                                </div>--%>
                            </telerik:RadPageView>
                        </telerik:RadMultiPage>
                        <%--</asp:Panel>--%>
                    </div>

                </asp:Panel>
                <asp:Panel ID="P_SendOK" runat="Server" Visible="false">
                    <asp:Panel ID="P_V1" runat="server" Visible="false">
                        <kspwc:TLabel ID="L_SendOK_V1" runat="server" Text="" Font-Size="Medium" EnableViewState="True"></kspwc:TLabel>
                    </asp:Panel>
                    <asp:Panel ID="P_V2" runat="server" Visible="false">
                        <table width="700">
                            <tr>
                                <td align="justify">
                                    <asp:Label ID="L_SendOK_V2" runat="server" Text="" Font-Size="Small" EnableViewState="True"></asp:Label>
                                    <asp:Panel ID="P_Odkazy" HorizontalAlign="Left" runat="server" Visible="false">
                                        <br />
                                        <a href="http://verejna-sprava.kr-moravskoslezsky.cz/zip/vm_prihlaska.odt">Přihláška
                                    k výběrovému řízení ke stažení ve formátu OpenDocument</a> , <a href="http://verejna-sprava.kr-moravskoslezsky.cz/zip/vm_prihlaska.pdf">přihláška k výběrovému řízení ke stažení ve formátu PDF</a> a <a href="http://verejna-sprava.kr-moravskoslezsky.cz/zip/vm_prihlaska.doc">přihláška k výběrovému řízení ke stažení ve formátu MS Word</a>
                                    </asp:Panel>
                                </td>
                            </tr>
                        </table>
                    </asp:Panel>
                </asp:Panel>
            </td>
        </tr>
        <tr style="height: 25px"></tr>
    </table>

</asp:Content>
