﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Main.Master" AutoEventWireup="true" CodeBehind="OsobniPozadavky.aspx.cs" Inherits="KSPortal.Zamestnanec.OsobniPozadavky" %>
<%@ Register assembly="Telerik.Web.UI" namespace="Telerik.Web.UI" tagprefix="telerik" %>
<asp:Content ID="Content1" ContentPlaceHolderID="HeadContent" runat="server">
        <style type="text/css">
        .displayBlock {
            display: block !important;
        }
        .displayNone {
            display: none !important;
        }
        .displayInlineBlock {
            display: inline-block !important;
        }
        .floatNone {
            float: none !important;
        }
    </style>
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="HlavniOblast" runat="server">
    <%--<span class="nadpis1">[%Osobní požadavky%]</span>--%>
        <telerik:RadAjaxManagerProxy runat="server" ID="RAMP_manager">
            <AjaxSettings>
                <telerik:AjaxSetting AjaxControlID="TRG_osobni_pozadavky">
                    <UpdatedControls>
                        <telerik:AjaxUpdatedControl ControlID="TRG_osobni_pozadavky" />
                    </UpdatedControls>
                </telerik:AjaxSetting>
            </AjaxSettings>
        </telerik:RadAjaxManagerProxy>

    <telerik:RadPersistenceManagerProxy ID="RadPersistenceManagerProxy1" runat="server">
    </telerik:RadPersistenceManagerProxy>

        <telerik:RadCodeBlock ID="RadCodeBlock2" runat="server">
        <script type="text/javascript">
            //<![CDATA[
            function ParameterMap(sender, args) {
                //If you want to send a parameter to the select call you can modify the if 
                //statement to check whether the request type is 'read':
                if (args.get_type() == "read") {
                    grid = $find("<%=TRG_osobni_pozadavky.ClientID %>");
                    var datum = grid.get_element().getAttribute('datumOd');
                    if (!datum) {
                        var f = grid.get_element().getElementsByClassName("ks_datumPicker");
                        if (f.length > 0) {
                            var datumInput = $find(f[0].id);
                            if (datumInput.get_value()) {
                                datumInput.clear();
                                return;
                            }
                        }
                    }
                    args.set_parameterFormat("{ 'ke_dni': '" + datum + "' }");
                }
                if (args.get_type() != "read" && args.get_data()) {
                    args.set_parameterFormat("{ 'pozadavky': " + kendo.stringify(args.get_data().models) + " }");
                }
            }

            function Parse(sender, args) {
                var response = args.get_response().d;
                if (response) {
                    args.set_parsedData(response.Data);
                }
            }

            function OnRebindButton(sender, args) {
                var gridv = $find("<%=TRG_osobni_pozadavky.ClientID %>").get_masterTableView();
                gridv.rebind();
            }

            function datum_ValueChanged(sender, args) {
                OnRebindButton(sender, args);
            }

            function TRG_DataBound(sender, args) {
                resizePozadavkyColumns();
            }

            function TRG_BatchEditOpening(sender, args) {
                var item = $find(args.get_row().id);
                var dataItem = item.get_dataItem();
                if(dataItem)
                    args.set_cancel(!dataItem["editacni"]);
            }

            function TRG_BatchEditOpened(sender, args) {
                //resizePozadavkyColumns();
            }

            function resizePozadavkyColumns() {
                var grid = $find('<%= TRG_osobni_pozadavky.ClientID %>');
                var columns = grid.get_masterTableView().get_columns();
                for (var i = 0; i < columns.length; i++) {
                    grid.get_masterTableView().resizeColumn(i, 0);
                    if ("text_osve" == columns[i].get_uniqueName()) {
                        grid.get_masterTableView().resizeColumn(i, 320);
                    }
                    else if ("text_druh" == columns[i].get_uniqueName()) {
                        grid.get_masterTableView().resizeColumn(i, 150);
                    }
                    else if ("datum_od" == columns[i].get_uniqueName()) {
                        grid.get_masterTableView().resizeColumn(i, 125);
                    }
                    else if ("datum_do" == columns[i].get_uniqueName()) {
                        grid.get_masterTableView().resizeColumn(i, 125);
                    }
                    else if ("termin" == columns[i].get_uniqueName()) {
                        grid.get_masterTableView().resizeColumn(i, 110);
                    }
                    else if ("delete" == columns[i].get_uniqueName()) {
                        grid.get_masterTableView().resizeColumn(i, 50);
                    }
                    else {
                        columns[i].resizeToFit(true, false);
                    }
                }
                grid.repaint();
            }

            function OnSaveButton_Clicked(sender, args) {
                var grid = $find("<%=TRG_osobni_pozadavky.ClientID %>");
                var batchManager = grid.get_batchEditingManager();
                batchManager._tryCloseEdits(grid.get_masterTableView());
                setTimeout(function () {
                    batchManager.saveChanges(grid.get_masterTableView());
                });
                setTimeout(function () {
                    grid.get_masterTableView().rebind();
                });
            }

            function OnAddNewButton_Clicked(sender, args) {
                var grid = $find("<%=TRG_osobni_pozadavky.ClientID %>");
                var masterTable = grid.get_masterTableView();
                var batchManager = grid.get_batchEditingManager();
                batchManager.addNewRecord(masterTable);
            }

            function deleteRow(sender, args) {
                var r_id = sender.parentElement.parentElement.id;
                var item = $find(r_id);
                if (item) {
                    var grid = $find("<%=TRG_osobni_pozadavky.ClientID %>");
                    var masterTable = grid.get_masterTableView();
                    var batchManager = grid.get_batchEditingManager();

                    batchManager._deleteRecord(masterTable._data.ClientID, r_id);
                    
                }
            }

            function Grid_GetCellValue(sender, args) {
                var name = args.get_columnUniqueName();
                if (name === "text_osve" || name === "text_druh") {
                    var cell = args.get_cell();
                    if (cell.getElementsByClassName("hodnota").length > 0) {
                        args.set_cancel(true);
                        var element = cell.getElementsByClassName("hodnota")[0];
                        var value = element.innerHTML;

                        args.set_value(value);
                    }
                }
                else if (name === "datum_od" || name === "datum_do" || name === "termin")
                {
                    var cell = args.get_cell();
                    if (cell.getElementsByClassName("hodnota").length > 0) {
                        args.set_cancel(true);
                        var element = cell.getElementsByClassName("hodnota")[0];
                        var value = element.innerHTML;

                        args.set_value(kendo.parseDate(value, "d.M.yyyy"));
                    }
                }
            }
            var lastText;
            function Grid_SetCellValue(sender, args) {
                var name = args.get_columnUniqueName();
                if (name === "text_osve" || name === "text_druh") {
                    args.set_cancel(true);
                    var cell = args.get_cell();
                    if (cell.getElementsByClassName("hodnota").length > 0 || cell.getElementsByClassName("popis").length > 0) {
                        if (cell.getElementsByClassName("hodnota").length > 0) {
                            var value = args.get_value();
                            var element = cell.getElementsByClassName("hodnota")[0];

                            element.innerHTML = value;
                        }
                        if (cell.getElementsByClassName("popis").length > 0) {
                            var element = cell.getElementsByClassName("popis")[0];

                            element.innerHTML = lastText;
                        }
                    }
                    else
                    {
                        var value = args.get_value();
                        cell.childNodes[0].innerHTML = "<span class=\"hodnota hidden\">" + value + "</span><span class=\"popis\">" + lastText + "</span>";
                    }
                }
                else if (name === "datum_od" || name === "datum_do" || name === "termin") {
                    var cell = args.get_cell();
                    if (cell.getElementsByClassName("hodnota").length > 0) {
                        args.set_cancel(true);
                        var value = args.get_value();
                        var element = cell.getElementsByClassName("hodnota")[0];

                        element.innerHTML = kendo.toString(value, "d.M.yyyy");
                    }
                    else {
                        var value = args.get_value();
                        cell.childNodes[0].innerHTML = "<span class=\"hodnota\">" + kendo.toString(value, "d.M.yyyy") + "</span>";
                    }
                }
            }
            function Grid_GetEditorValue(sender, args) {
                var name = args.get_columnUniqueName();
                if (name === "text_osve" || name === "text_druh") {
                    var cell = args.get_cell();
                    if (cell.getElementsByClassName("kontrol").length > 0) {
                        args.set_cancel(true);
                        var dropdown = $find(cell.getElementsByClassName("kontrol")[0].id);
                        var item = dropdown.get_selectedItem();
                        lastText = item.get_text();

                        args.set_value(item.get_value());
                    }
                }
                else if (name === "datum_od" || name === "datum_do" || name === "termin") {
                    var cell = args.get_cell();
                    if (cell.getElementsByClassName("kontrol").length > 0) {
                        args.set_cancel(true);
                        var picker = $find(cell.getElementsByClassName("kontrol")[0].id);

                        args.set_value(picker.get_selectedDate());
                    }
                }
            }
            function Grid_SetEditorValue(sender, args) {
                var name = args.get_columnUniqueName();
                if (name === "text_osve" || name === "text_druh") {
                    var cell = args.get_cell();
                    if (cell.getElementsByClassName("kontrol").length > 0) {
                        args.set_cancel(true);
                        var dropdown = $find(cell.getElementsByClassName("kontrol")[0].id);
                        var value = args.get_value();
                        if (value) {
                            var item = dropdown.findItemByValue(value);

                            item.set_selected(true);
                        }
                    }
                }
                else if (name === "datum_od" || name === "datum_do" || name === "termin") {
                    var cell = args.get_cell();
                    if (cell.getElementsByClassName("kontrol").length > 0) {
                        args.set_cancel(true);
                        var picker = $find(cell.getElementsByClassName("kontrol")[0].id);
                        var value = args.get_value();
                        var orig_perform = performDatumSelected;
                        performDatumSelected = false;
                        picker.set_selectedDate(value);
                        performDatumSelected = orig_perform;
                    }
                }
            }
            var performDatumSelected = true;
            function Grid_DatumSelected(sender, args) {
                if (performDatumSelected) {
                    var datum_od_p, datum_do_p;
                    if (sender.get_id().indexOf("datum_od") !== -1) {
                        datum_od_p = sender;
                        var cntrls = $find(sender.get_owner().get_element().parentElement.parentElement.parentElement.parentElement.id).get_cell("datum_do").getElementsByClassName("kontrol");
                        if (cntrls.length > 0) {
                            datum_do_p = $find(cntrls[0].id);
                            var datum_od = datum_od_p.get_selectedDate();
                            var datum_do = datum_do_p.get_selectedDate();

                            if (datum_od && datum_do && datum_do < datum_od) {
                                performDatumSelected = false;
                                datum_do_p.set_selectedDate(datum_od);
                                performDatumSelected = true;
                            }
                        }
                    }
                    else {
                        datum_do_p = sender;
                        var cntrls = $find(sender.get_owner().get_element().parentElement.parentElement.parentElement.parentElement.id).get_cell("datum_od").getElementsByClassName("kontrol");
                        if (cntrls.length > 0) {
                            datum_od_p = $find(cntrls[0].id);

                            var datum_od = datum_od_p.get_selectedDate();
                            var datum_do = datum_do_p.get_selectedDate();

                            if (datum_od && datum_do && datum_od > datum_do) {
                                performDatumSelected = false;
                                datum_od_p.set_selectedDate(datum_do);
                                performDatumSelected = true;
                            }
                        }
                    }
                }
            }

            function DS_Change(sender, args) {
                var items = args.get_items();
                for (var i = 0; i < items.length; i++) {
                    if (!items[i].c_skol) {
                        items[i].c_skol = '';
                    }
                    if (!items[i].druh) {
                        items[i].druh = 0;
                    }
                }
                    
            }
            function DS_Command(sender, args) {
                if (args.get_commandName() === "insert") {
                    var item = args.get_commandArgument();
                    
                    if (item.values.text_osve) {
                        item.values.c_skol = item.values.text_osve;
                        //delete item.values.text_osve;
                    }
                    if (item.values.text_druh) {
                        item.values.druh = item.values.text_druh;
                    }
                    if (!item.values.termin) {
                        item.values.termin = null;
                    }
                    item.values.editacni = true;
                }
                else if (args.get_commandName() === "update") {
                    var item = args.get_commandArgument();

                    if (item.newValues.text_osve) {
                        item.newValues.c_skol = item.newValues.text_osve;
                    }
                    if (item.newValues.text_druh) {
                        item.newValues.druh = item.newValues.text_druh;
                    }
                    
                    item.newValues.editacni = true;
                }
            }

            function DateInput_KeyPress(sender, args) {
                var c = args.get_keyCode();
                if (c === 13) {
                    OnSaveButton_Clicked();
                    args.set_cancel(true);
                }
                else if (!(c === 46 || (c > 47 && c < 58))) {
                    args.set_cancel(true);
                }
            }

            //*************************************************** zde začíná persistance frameWork
            
            function grid_OnGridCreateHandler(sender, args) {
                sender.add_command(grid_OnCommandHandler);
                //sender.add_dataBinding(grid_OnDataBinding);

                loadGridState(sender);

                // nepatří do obecného persist framnework
                sender.get_element().setAttribute('datumOd', '');
                sender.get_element().setAttribute('datumDo', '');
            }

            function CancelEventHandler(sender, args) {//handler zastaví event způsobený načítáním uloženého nastavení gridu
                args.set_cancel(true);
            }

            function grid_OnCommandHandler(sender, args) {
                var table = sender.get_masterTableView();
                var com = args.get_commandName();
                if (com == "PageSize") {
                    saveGridState(sender);
                    //args.set_cancel(true);
                }
                if (com == "Filter" || com == "Sort") {
                    saveGridState(sender);
                }
            }

            function showHideFilter(sender, args) {
                var grid = $find("<%=TRG_osobni_pozadavky.ClientID %>");
                var gridv = grid.get_masterTableView();
                if (args.get_checked()) {
                    gridv.showFilterItem();
                }
                else {
                    gridv.hideFilterItem();
                    gridv.get_filterExpressions().clear();//smazání filtrů

                    var columns = gridv.get_columns();//smazání filter textboxů
                    for (var i = 0; i < columns.length; i++) {
                        gridv._updateFilterControlValue("", columns[i].get_uniqueName(), "");
                    }

                    saveGridState(grid);
                    gridv.rebind();

                }
            }

            function getGridState() {
                var stateStr = KSMaster.HF_TRadGridStateHolder.value;
                if (stateStr) {
                    try {
                        return $telerik.$.parseJSON(stateStr);
                    }
                    catch (e) { }
                }
                return null;
            }

            var saveGridStateTimeOut;
            function saveGridState(grids) { // metoda uloží 
                var states = getGridState();
                states = states ? states : [];
                for (var gridi = 0; gridi < arguments.length; gridi++) {
                    var grid = arguments[gridi];
                    var table = grid.get_masterTableView();

                    var stateIndex = -1;
                    $.each(states, function (i, val) {
                        if (val.ID == grid.ClientID) {
                            stateIndex = i;
                            return;
                        }
                    });

                    var collvisible = {};
                    var collorder = [];
                    var columns = table.get_columns();
                    for (var i = 0; i < columns.length; i++) {
                        collvisible[columns[i].get_uniqueName()] = columns[i].get_visible();
                        collorder.push(columns[i].get_uniqueName());
                    }
                    
                    gridState =
                        {
                            ID: grid.ClientID,
                            ColumnVisible: collvisible,
                            ColumnOrder: collorder,
                            PageSize: table.get_pageSize(),
                            //PageIndex: table.get_pageIndex(),
                            CurrentPageIndex: table.get_currentPageIndex(),
                            FilterExpression: table._filterExpressions,
                            SortExpression: table.get_sortExpressions()
                        }

                    if (stateIndex == -1)
                        states.push(gridState);
                    else
                        states[stateIndex] = gridState;
                }
                var json = kendo.stringify(states);

                if (KSMaster.HF_TRadGridStateHolder) {
                    KSMaster.HF_TRadGridStateHolder.value = json;
                }
                if (saveGridStateTimeOut)
                    clearTimeout(saveGridStateTimeOut);
                saveGridStateTimeOut = setTimeout(function () { PageMethods.SaveTRadGridClientSetting(json); }, 500);
            }

            gridStateLoading = false;

            function loadGridState(grids) {
                gridStateLoading = true;
                var states = getGridState();
                if (states) {
                    for (var gridi = 0; gridi < arguments.length; gridi++) {
                        var grid = arguments[gridi];
                        for (var statei = 0; statei < states.length; statei++) {
                            var gridState = states[statei];
                            if (grid.ClientID == gridState.ID) {
                                var table = grid.get_masterTableView();
                                var cols = table.get_columns();

                                // pořadí sloupců
                                if (gridState && gridState.ColumnOrder) {
                                    grid.add_columnSwapping(CancelEventHandler);
                                    for (var i in gridState.ColumnOrder) {
                                        var from = gridState.ColumnOrder[i];
                                        if (cols[i]) {
                                            var to = cols[i].get_uniqueName();
                                            if (from != to) {
                                                tableView.reorderColumns(from, to);
                                                cols = tableView.get_columns();
                                            }
                                        }
                                    }
                                    grid.remove_columnSwapping(CancelEventHandler);
                                }

                                //viditelnost sloupců
                                if (gridState && gridState.ColumnVisible) {
                                    for (var key in gridState.ColumnVisible) {
                                        if (gridState.ColumnVisible.hasOwnProperty(key)) {
                                            var colum = table.getColumnByUniqueName(key);
                                            if (colum) {
                                                var index = 0;
                                                for (var i = 0; i < cols.length; i++) {
                                                    if (cols[i].get_uniqueName() == key) {
                                                        index = i;
                                                    }
                                                }

                                                if (colum.get_visible() != gridState.ColumnVisible[key]) {
                                                    if (gridState.ColumnVisible[key]) {
                                                        grid.add_columnShowing(CancelEventHandler);
                                                        table.showColumn(index);
                                                        grid.remove_columnShowing(CancelEventHandler);
                                                    }
                                                    else {
                                                        grid.add_columnHiding(CancelEventHandler);
                                                        table.hideColumn(index);
                                                        grid.remove_columnHiding(CancelEventHandler);
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }

                                if (gridState && gridState.FilterExpression) {
                                    grid.remove_command(grid_OnCommandHandler);
                                    for (var i in gridState.FilterExpression._array) {
                                        var fexpr = gridState.FilterExpression._array[i];
                                        addGridFilterExpression(grid, fexpr.ColumnUniqueName, fexpr.FieldName, fexpr.FilterFunction, fexpr.DataTypeName, fexpr.FieldValue);
                                    }
                                    var f = grid.get_element().getElementsByClassName("ks_filterButton");
                                    if (f.length > 0) {
                                        var filterButton = $find(f[0].id);
                                        if (gridState.FilterExpression._array.length > 0) {
                                            //filterButton.set_checked(true);
                                        }
                                        else {
                                            if (filterButton.get_checked()) {
                                                table.showFilterItem();
                                            }
                                            else {
                                                table.hideFilterItem();
                                            }
                                        }
                                    }

                                    grid.add_command(grid_OnCommandHandler);
                                }

                                if (gridState && gridState.SortExpression) {
                                    grid.remove_command(grid_OnCommandHandler);
                                    for (var i in gridState.SortExpression._array) {
                                        var sortexpr = gridState.SortExpression._array[i];
                                        addGridSortExpression(grid, sortexpr.FieldName, sortexpr.SortOrder);
                                        var column = table.getColumnByUniqueName(sortexpr.FieldName);
                                        if (column)
                                            column.get_element().classList.add("rgSorted");
                                    }
                                    grid.add_command(grid_OnCommandHandler);
                                }

                                //velikost stránky
                                if (gridState && gridState.PageSize && table.get_pageSize() != gridState.PageSize) {
                                    grid.remove_command(grid_OnCommandHandler); 
                                    grid.add_command(CancelEventHandler);
                                    table.set_pageSize(gridState.PageSize);
                                    grid.remove_command(CancelEventHandler);
                                    grid.add_command(grid_OnCommandHandler);
                                }

                                //page index
                                if (gridState && gridState.PageIndex && table.get_pageIndex() != gridState.PageIndex) {
                                    table.set_pageIndex(gridState.PageIndex);
                                }
                            }
                        }
                    }
                }
                gridStateLoading = false;
            }

            function addGridFilterExpression(grid, columnUniqueName, dataField, filterFunction, filterDataType, filterValue) {
                var filterExpression = new Telerik.Web.UI.GridFilterExpression();
                var founded = 0;
                var foundExp = $.grep(grid.get_masterTableView()._filterExpressions._array, function (e) { return e.FieldName == dataField; });
                founded = foundExp.length;
                if (founded != 0) {
                    filterExpression = foundExp[0];
                }

                var column = grid.get_masterTableView().getColumnByUniqueName(columnUniqueName);
                if (column != null)
                    column.set_filterFunction("Contains");
                filterExpression.set_fieldName(dataField);
                filterExpression.set_fieldValue(filterValue);
                filterExpression.set_dataTypeName(filterDataType);
                filterExpression.set_filterFunction(filterFunction);
                filterExpression.set_columnUniqueName(columnUniqueName);
                if (column != null) {
                    if (column.get_dataType() =="System.DateTime" && column._data.ColumnType == "GridTemplateColumn") {
                        //var cell = grid.get_masterTableView()._getFilterCellByColumnUniqueName(columnUniqueName);
                        //if (cell) {
                        //    if (cell.getElementsByClassName("filter").length > 0) {
                        //        var dateInput = $find(cell.getElementsByClassName("filter")[0].id);
                        //        dateInput.set_selectedDate(kendo.parseDate(filterValue));
                        //    }
                        //    if (cell.getElementsByClassName("rgFilter").length > 0) {
                        //        var filterbutton = $get(cell.getElementsByClassName("rgFilter")[0].id);

                        //    }
                        //}
                    }
                    else
                        grid.get_masterTableView()._updateFilterControlValue(filterValue, columnUniqueName, filterFunction);
                }
                if (founded == 0) {
                    grid.get_masterTableView()._filterExpressions.add(filterExpression);
                }
            }

            function addGridSortExpression(grid, fieldName, sortOrder) {
                var sortExpression = new Telerik.Web.UI.GridSortExpression();
                sortExpression.set_fieldName(fieldName);
                sortExpression.set_sortOrder(sortOrder);
                grid.get_masterTableView()._sortExpressions.add(sortExpression);
                grid.get_masterTableView()._showSortIconForField(fieldName, sortOrder);
            }
                        //]]>
        </script>
        </telerik:RadCodeBlock>
    <kspwc:TRadGrid ID="TRG_osobni_pozadavky" runat="server" AllowPaging="True" AllowSorting="True" UseSaveSetting="False" ShowGroupPanel="True" MasterTableView-Caption="[%Osobní požadavky%]"
        AutoFilterWidth="True" AutoGenerateColumns="False" ClientDataSourceID="RCDS_osobni_pozadavky" IdPravaEditace="306" Width="1020">
        <GroupingSettings ShowUnGroupButton="True"></GroupingSettings>
        <ClientSettings AllowDragToGroup="True">
            <Resizing AllowColumnResize="true" AllowResizeToFit="true"/>
            <ClientEvents OnDataBound="TRG_DataBound" OnBatchEditOpening="TRG_BatchEditOpening" OnBatchEditOpened="TRG_BatchEditOpened"
                OnBatchEditGetCellValue="Grid_GetCellValue" OnBatchEditSetCellValue="Grid_SetCellValue"
                OnBatchEditGetEditorValue="Grid_GetEditorValue" OnBatchEditSetEditorValue="Grid_SetEditorValue"
                OnGridCreated="grid_OnGridCreateHandler"/>
        </ClientSettings>
        <MasterTableView CommandItemDisplay="Top" EditMode="Batch" DataKeyNames="id" ClientDataKeyNames="id" AllowSorting="True" AllowFilteringByColumn="true" TableLayout="Fixed" >
            <BatchEditingSettings EditType="Row" HighlightDeletedRows="true"/>
            <Columns>
                <telerik:GridTemplateColumn DataField="text_osve" FilterControlAltText="Filter text_osve column" AllowSorting="true" SortExpression="text_osve" HeaderText="[%Vzdělávací aktivita%]" UniqueName="text_osve">
                    <ClientItemTemplate>
                        <span class="hodnota hidden">#=c_skol #</span>
                        <span class="popis">#=text_osve #</span>
                    </ClientItemTemplate>
                    <EditItemTemplate>
                        <telerik:RadDropDownList runat="server" ID="RDDL_text_osve" CssClass="kontrol" DataValueField="cislo"
                            DataTextField="text_osve" DataSourceID="ODS_sko_cisl" DropDownWidth="300" Width="300">
                        </telerik:RadDropDownList>
                    </EditItemTemplate>
                </telerik:GridTemplateColumn>
                <telerik:GridTemplateColumn DataField="text_druh" FilterControlAltText="Filter text_druh column" AllowSorting="true" SortExpression="text_druh" HeaderText="[%Druh%]" UniqueName="text_druh">
                    <ClientItemTemplate>
                        <span class="hodnota hidden">#=druh #</span>
                        <span class="popis">#=text_druh #</span>
                    </ClientItemTemplate>
                    <EditItemTemplate>
                        <telerik:RadDropDownList runat="server" ID="RDDL_text_druh" CssClass="kontrol" DataValueField="Key"
                            DataTextField="Value" DataSourceID="ODS_druh_ciselnik" DropDownWidth="140" Width="140">
                        </telerik:RadDropDownList>
                    </EditItemTemplate>
                </telerik:GridTemplateColumn>
                <telerik:GridTemplateColumn DataField="datum_od" DataType="System.DateTime" AllowSorting="true" SortExpression="datum_od" FilterControlAltText="Filter datum_od column" HeaderText="[%Požadavkem od%]" UniqueName="datum_od">
                    <ClientItemTemplate>
                        <span class="hodnota">#=datum_od?kendo.toString(datum_od, "d.M.yyyy"):''#</span>
                    </ClientItemTemplate>
                    <EditItemTemplate>
                        <kspwc:TRadDatePicker runat="server" ID="TRDP_datum_od">
                            <DateInput CssClass="kontrol">
                                <ClientEvents OnValueChanged="Grid_DatumSelected" OnKeyPress="DateInput_KeyPress" />
                            </DateInput>
                        </kspwc:TRadDatePicker>
                    </EditItemTemplate>
                    <FilterTemplate>
                        <%--<kspwc:TRadDatePicker runat="server" ID="TRDP_datum_od_filter">
                            <DateInput CssClass="filter">
                                <ClientEvents OnKeyPress="DateInput_KeyPress" />
                            </DateInput>
                        </kspwc:TRadDatePicker>
                        <input type="button" name="Filter_datum_od" value="" onclick="$find('ctl00_HlavniOblast_TRG_osobni_pozadavky')._showFilterMenu('ctl00_HlavniOblast_TRG_osobni_pozadavky_ctl00', 'datum_od', event); return false" id="Filter_datum_od" title="Filtr" class="rgFilter">--%>
                    </FilterTemplate>
                </telerik:GridTemplateColumn>
                <telerik:GridTemplateColumn DataField="datum_do" DataType="System.DateTime" AllowSorting="true" SortExpression="datum_do" FilterControlAltText="Filter datum_do column" HeaderText="[%Požadavkem do%]" UniqueName="datum_do">
                    <ClientItemTemplate>
                        <span class="hodnota">#=datum_do?kendo.toString(datum_do, "d.M.yyyy"):''#</span>
                    </ClientItemTemplate>
                    <EditItemTemplate>
                        <kspwc:TRadDatePicker runat="server" ID="TRDP_datum_do">
                            <DateInput CssClass="kontrol">
                                <ClientEvents OnValueChanged="Grid_DatumSelected" OnKeyPress="DateInput_KeyPress" />
                            </DateInput>
                        </kspwc:TRadDatePicker>
                    </EditItemTemplate>
                    <FilterTemplate>
                        <%--<kspwc:TRadDatePicker runat="server" ID="TRDP_datum_do_filter">
                            <DateInput CssClass="filter">
                                <ClientEvents OnKeyPress="DateInput_KeyPress" />
                            </DateInput>
                        </kspwc:TRadDatePicker>
                        <input type="button" name="Filter_datum_do" value="" onclick="$find('ctl00_HlavniOblast_TRG_osobni_pozadavky')._showFilterMenu('ctl00_HlavniOblast_TRG_osobni_pozadavky_ctl00', 'datum_do', event); return false" id="Filter_datum_od" title="Filtr" class="rgFilter">--%>
                    </FilterTemplate>
                </telerik:GridTemplateColumn>
                <telerik:GridTemplateColumn DataField="termin" DataType="System.DateTime" AllowSorting="true" SortExpression="termin" ReadOnly="true" FilterControlAltText="Filter termin column" HeaderText="[%Předpokládaný termín%]" UniqueName="termin">
                    <ClientItemTemplate>
                        <span class="hodnota">#=termin?kendo.toString(termin, "d.M.yyyy"):''#</span>
                    </ClientItemTemplate>
                    <EditItemTemplate>
                        <kspwc:TRadDatePicker runat="server" ID="TRDP_termin">
                            <DateInput CssClass="kontrol">
                                <ClientEvents OnValueChanged="Grid_DatumSelected" OnKeyPress="DateInput_KeyPress" />
                            </DateInput>
                        </kspwc:TRadDatePicker>
                    </EditItemTemplate>
                    <FilterTemplate>
                        <%--<kspwc:TRadDatePicker runat="server" ID="TRDP_termin_filter">
                            <DateInput CssClass="filter">
                                <ClientEvents OnKeyPress="DateInput_KeyPress" />
                            </DateInput>
                        </kspwc:TRadDatePicker>
                        <input type="button" name="Filter_termin" value="" onclick="$find('ctl00_HlavniOblast_TRG_osobni_pozadavky')._showFilterMenu('ctl00_HlavniOblast_TRG_osobni_pozadavky_ctl00', 'termin', event); return false" id="Filter_termin" title="Filtr" class="rgFilter">--%>
                    </FilterTemplate>
                </telerik:GridTemplateColumn>
                <telerik:GridTemplateColumn  UniqueName="delete" AllowFiltering="False" DataType="System.Boolean" AllowSorting="true" SortExpression="editacni" ReadOnly="true" FilterControlAltText="Filter editacni column" HeaderText="[%Smazat%]">
                    <ClientItemTemplate>
                        <span class="fi fi-trash floatNone #=editacni?'displayBlock':'displayNone'#" onclick="deleteRow(this); return false"></span>
                    </ClientItemTemplate>
                </telerik:GridTemplateColumn>
            </Columns>
            <CommandItemTemplate>
                <kspwc:GridCommandItemControl runat="server" DateControl="TRadDatePicker">
                    <TRadDatePicker runat="server" ShowPopupOnFocus="True">
                        <ClientEvents OnDateSelected="datum_ValueChanged" />
                    </TRadDatePicker>
                    <FilterButton runat="server" AutoPostBack="false" OnClientCheckedChanged="showHideFilter"></FilterButton>
                    <RebindButton runat="server" AutoPostBack="false" OnClientClicked="OnRebindButton"></RebindButton>
                    <ExportButton runat="server" Visible="false"/>
                    <AddNewItemButton runat="server" Visible="true" AutoPostBack="false" OnClientClicked="OnAddNewButton_Clicked"></AddNewItemButton>
                    <SaveButton runat="server" Visible="true" OnClientClicked="OnSaveButton_Clicked"></SaveButton>
                </kspwc:GridCommandItemControl>
            </CommandItemTemplate>
        </MasterTableView>
    </kspwc:TRadGrid>
    <telerik:RadClientDataSource ID="RCDS_osobni_pozadavky" runat="server" AllowBatchOperations="true">
        <ClientEvents OnCustomParameter="ParameterMap" OnDataParse="Parse" OnChange="DS_Change" OnCommand="DS_Command" />
        <DataSource>
            <WebServiceDataSourceSettings BaseUrl="../Zamestnanec/OsobniPozadavky.aspx/">
                <Select Url="GetOsobniPozadavky" DataType="JSON" RequestType="Post" ContentType="application/json; charset=utf-8" />
                <Update Url="UpdateOsobniPozadavky" DataType="JSON" RequestType="Post" ContentType="application/json; charset=utf-8" />
                <Insert Url="InsertOsobniPozadavky" DataType="JSON" RequestType="Post" ContentType="application/json; charset=utf-8" />
                <Delete Url="DeleteOsobniPozadavky" DataType="JSON" RequestType="Post" ContentType="application/json; charset=utf-8" />
            </WebServiceDataSourceSettings>
        </DataSource>
        <Schema>
            <Model ID="id">
                <telerik:ClientDataSourceModelField FieldName="id" DataType="String" Nullable="False" Editable="False" />
                <telerik:ClientDataSourceModelField FieldName="c_skol" DataType="String" Editable="True" />
                <telerik:ClientDataSourceModelField FieldName="os_cislo" DataType="Number" Editable="True"/>
                <telerik:ClientDataSourceModelField FieldName="datum_od" DataType="Date" Nullable="True" Editable="True" />
                <telerik:ClientDataSourceModelField FieldName="datum_do" DataType="Date" Nullable="True" Editable="True"/>
                <telerik:ClientDataSourceModelField FieldName="druh" DataType="Number" Editable="True"/>
                <telerik:ClientDataSourceModelField FieldName="termin" DataType="Date" Nullable="True" Editable="True"/>
                <telerik:ClientDataSourceModelField FieldName="navedeno_z_ppm" DataType="Number" Nullable="True" Editable="False" />
                <telerik:ClientDataSourceModelField FieldName="id_ext_vazby" DataType="Number" Nullable="True" Editable="False" />
                <telerik:ClientDataSourceModelField FieldName="new_ref" DataType="Number" Nullable="True" Editable="False" />
                <telerik:ClientDataSourceModelField FieldName="upresneni" DataType="String" Nullable="True" Editable="True" />
                <telerik:ClientDataSourceModelField FieldName="text_osve" DataType="String" Nullable="True" Editable="True" />
                <telerik:ClientDataSourceModelField FieldName="text_druh" DataType="String" Nullable="True" Editable="True" />
                <telerik:ClientDataSourceModelField FieldName="editacni" DataType="Boolean" Nullable="True" Editable="false" />
            </Model>
        </Schema>
    </telerik:RadClientDataSource>
    <asp:ObjectDataSource runat="server" ID="ODS_druh_ciselnik" OldValuesParameterFormatString="original_{0}" SelectMethod="CiselnikEditovatelnychZdrojuPozadavku" TypeName="KSProgram.Vzdelavani.OsobniPozadavky">
    </asp:ObjectDataSource>
    <asp:ObjectDataSource runat="server" ID="ODS_sko_cisl" OldValuesParameterFormatString="original_{0}" SelectMethod="SkoCislSeznam" TypeName="KSProgram.Ciselniky.CisSkoCisl">
    </asp:ObjectDataSource>
</asp:Content>
