﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Main.Master" AutoEventWireup="true" CodeBehind="PracovniPostup.aspx.cs" Inherits="KSPortal.Zamestnanec.PracovniPostup" %>
<%@ Register assembly="Telerik.Web.UI" namespace="Telerik.Web.UI" tagprefix="telerik" %>
<asp:Content ID="Content1" ContentPlaceHolderID="HeadContent" runat="server">
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="HlavniOblast" runat="server">
    <telerik:RadAjaxManagerProxy ID="RadAjaxManagerProxy1" runat="server">
        <AjaxSettings>
            <telerik:AjaxSetting AjaxControlID="TRG_postup">
                <UpdatedControls>
                    <telerik:AjaxUpdatedControl ControlID="TRG_postup" UpdatePanelCssClass="" />
                    <telerik:AjaxUpdatedControl ControlID="RadHtmlChart1" UpdatePanelCssClass="" />
                </UpdatedControls>
            </telerik:AjaxSetting>
        </AjaxSettings>
    </telerik:RadAjaxManagerProxy>
    <telerik:RadScriptBlock ID="RadScriptBlock1" runat="server">
        <script type="text/javascript" id="telerikClientEvents2">
//<![CDATA[
            function onRowOver(sender, args) {

            }
            function onSeriesOver(sender, args) {
                var id = args.get_dataItem()["id"];
                var grid = $find("<%=TRG_postup.ClientID %>");
            var dataItems = grid.get_masterTableView().get_dataItems();

            for (var i = 0; i < dataItems.length; i++) {
                var row = dataItems[i];
                if (row.getDataKeyValue("id") == id) {
                    row.addCssClass("rgHoveredRow");
                }
                else {
                    row.removeCssClass("rgHoveredRow");
                }
            }
        }
//]]>
        </script>
</telerik:RadScriptBlock>
    <%--<label class="nadpis1">[%Pracovní postup%]</label>--%>
    <kspwc:TRadGrid ID="TRG_postup" runat="server" AllowPaging="True" MasterTableView-Caption="[%Pracovní postup%]"
        AllowSorting="True" GroupPanelPosition="Top" PageSize="30" 
         onneeddatasource="TRG_postup_NeedDataSource" 
        AutoGenerateColumns="False" onitemdatabound="TRG_postup_ItemDataBound">
        <ExportSettings>
            <Pdf PageWidth="">
            </Pdf>
        </ExportSettings>
        <ClientSettings AllowColumnHide="True" EnableRowHoverStyle="True">
            <ClientEvents OnRowMouseOver="onRowOver" />
        </ClientSettings>
        <MasterTableView CommandItemDisplay="Top" EnableHeaderContextMenu="True" ClientDataKeyNames="id">
            <RowIndicatorColumn Visible="False">
            </RowIndicatorColumn>
            <ExpandCollapseColumn Created="True">
            </ExpandCollapseColumn>
            <PagerStyle AlwaysVisible="True" PageSizes="10;20;30;50;100;150;200" />
            <CommandItemTemplate>
                <kspwc:GridCommandItemControl ID="GridCommandItemControl1" runat="server">
                    <FilterButton runat="server" Visible="False"></FilterButton>
                </kspwc:GridCommandItemControl>
            </CommandItemTemplate>
            <Columns>
                <telerik:GridDateTimeColumn DataField="platnost_od" DataType="System.DateTime" 
                    FilterControlAltText="Filter platnost_od column" Groupable="False" DataFormatString="{0:d.M.yyyy}"
                    HeaderText="[%Od%]" UniqueName="platnost_od">
                </telerik:GridDateTimeColumn>
                <telerik:GridDateTimeColumn DataField="platnost_do" DataType="System.DateTime" 
                    FilterControlAltText="Filter platnost_do column" Groupable="False" DataFormatString="{0:d.M.yyyy}"
                    HeaderText="[%Do%]" UniqueName="platnost_do">
                </telerik:GridDateTimeColumn>
                <telerik:GridBoundColumn FilterControlAltText="Filter column2 column" 
                    UniqueName="naz_str" DataField="naz_str" HeaderText="[%Prac. středisko%]">
                </telerik:GridBoundColumn>
                <telerik:GridBoundColumn FilterControlAltText="Filter column3 column" 
                    UniqueName="naz_pracmist" DataField="naz_pracmist" 
                    HeaderText="[%Prac. místo%]">
                </telerik:GridBoundColumn>
                <telerik:GridNumericColumn DecimalDigits="0" 
                    FilterControlAltText="Filter column4 column" UniqueName="trida" 
                    DataField="trida" DataType="System.Int16" HeaderText="[%Třída%]">
                </telerik:GridNumericColumn>
                <telerik:GridNumericColumn DecimalDigits="0" 
                    FilterControlAltText="Filter column5 column" UniqueName="mzd_stup" 
                    DataField="mzd_stup" DataType="System.Int16" HeaderText="[%Stupeň||level%]">
                </telerik:GridNumericColumn>
                <telerik:GridNumericColumn DataField="tarif" DataType="System.Decimal" 
                    DecimalDigits="2" FilterControlAltText="Filter tarif column" 
                    HeaderText="[%Tarif%]" UniqueName="tarif" NumericType="Currency">
                </telerik:GridNumericColumn>
                <telerik:GridNumericColumn DataField="os_hodn" DataType="System.Decimal" 
                    DecimalDigits="2" FilterControlAltText="Filter os_hodn column" 
                    HeaderText="[%Osobní%]" UniqueName="os_hodn" NumericType="Currency">
                </telerik:GridNumericColumn>
                <telerik:GridNumericColumn DataField="prem_cast" DataType="System.Decimal" 
                    DecimalDigits="2" FilterControlAltText="Filter prem_cast column" 
                    HeaderText="[%Č. prémií%]" UniqueName="prem_cast" NumericType="Currency">
                </telerik:GridNumericColumn>
                <telerik:GridBoundColumn DataField="typ_mzdy_n" 
                    FilterControlAltText="Filter typ_mzdy_n column" HeaderText="[%Typ mzdy%]" 
                    UniqueName="typ_mzdy_n">
                </telerik:GridBoundColumn>
                <telerik:GridNumericColumn DataField="hod_uvazek" DataType="System.Decimal" 
                    DecimalDigits="2" FilterControlAltText="Filter hod_uvazek column" 
                    HeaderText="[%Skuteč. úv.%]" UniqueName="hod_uvazek">
                </telerik:GridNumericColumn>
                <telerik:GridBoundColumn DataField="jkz_n" 
                    FilterControlAltText="Filter jkz_n column" HeaderText="[%CZ-ISCO%]" 
                    UniqueName="jkz_n">
                </telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="prac_kateg_n" 
                    FilterControlAltText="Filter prac_kateg_n column" HeaderText="[%Pr. kateg.%]" 
                    UniqueName="prac_kateg_n">
                </telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="typ_kal_n" 
                    FilterControlAltText="Filter typ_kal_n column" HeaderText="[%Typ kal.%]" 
                    UniqueName="typ_kal_n">
                </telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="smena_n" 
                    FilterControlAltText="Filter smena_n column" HeaderText="[%Rozvrh%]" 
                    UniqueName="smena_n">
                </telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="poznamka"
                    FilterControlAltText="Filter poznamka column" HeaderText="[%Poznámka%]" 
                    UniqueName="poznamka">
                </telerik:GridBoundColumn>
            </Columns>    
        </MasterTableView>
    </kspwc:TRadGrid>
    <telerik:RadHtmlChart ID="RadHtmlChart1" runat="server" CssClass="whiteBack"
        Width="100%" Height="500" OnClientSeriesHovered="onSeriesOver">
        <Legend>
            <Appearance Position="Bottom">
            </Appearance>
        </Legend>
        <%--<Navigator Visible="true">
            <SelectionHint Visible="true" DataFormatString="From {0:d} to {1:d}" />
            <Series>
                <telerik:AreaSeries DataFieldY="tarif">
                    <LineAppearance LineStyle="Step" />
                </telerik:AreaSeries>
                <telerik:AreaSeries DataFieldY="os_hodn">
                    <LineAppearance LineStyle="Step" />
                </telerik:AreaSeries>
                <telerik:AreaSeries DataFieldY="prem_cast">
                    <LineAppearance LineStyle="Step" />
                </telerik:AreaSeries>
            </Series>
            <XAxis Color="#aaaaaa">
                <LabelsAppearance>
                    <TextStyle Color="#666666" />
                </LabelsAppearance>
            </XAxis>
        </Navigator>--%>
        <PlotArea>
            <Series>
                <telerik:LineSeries DataFieldY="tarif" Name="[%Tarif%]">
                    <LineAppearance LineStyle="Step" Width="3"/>
                    <Appearance>
                        <FillStyle BackgroundColor="OrangeRed" />
                    </Appearance>
                    <TooltipsAppearance>
                        <ClientTemplate>
                                #=(dataItem.platnost_od.getDate()+"."+(dataItem.platnost_od.getMonth()+1)+"."+dataItem.platnost_od.getFullYear() +" - "+(dataItem.platnost_do==null?("?"):(dataItem.platnost_do.getDate()+"."+(dataItem.platnost_do.getMonth()+1)+"."+dataItem.platnost_do.getFullYear())))#
                                <br />
                                #=Intl.NumberFormat().format(dataItem.tarif)#
                        </ClientTemplate>
                    </TooltipsAppearance>
                    <LabelsAppearance DataFormatString="{0:N0}" RotationAngle="295" Position="Above">
                        <TextStyle Bold="true" />
                    </LabelsAppearance>
                </telerik:LineSeries>
                <telerik:LineSeries DataFieldY="os_hodn" Name="[%Osobní ohodnocení%]">
                    <LineAppearance LineStyle="Step" Width="3" />
                    <Appearance>
                        <FillStyle BackgroundColor="LightSeaGreen" />
                    </Appearance>
                    <TooltipsAppearance>
                        <ClientTemplate>
                                #=(dataItem.platnost_od.getDate()+"."+(dataItem.platnost_od.getMonth()+1)+"."+dataItem.platnost_od.getFullYear() +" - "+(dataItem.platnost_do==null?("?"):(dataItem.platnost_do.getDate()+"."+(dataItem.platnost_do.getMonth()+1)+"."+dataItem.platnost_do.getFullYear())))#
                                <br />
                                #=Intl.NumberFormat().format(dataItem.os_hodn)#
                        </ClientTemplate>
                    </TooltipsAppearance>
                    <LabelsAppearance DataFormatString="{0:N0}" RotationAngle="295" Position="Above">
                        <TextStyle Bold="true" />
                    </LabelsAppearance>
                </telerik:LineSeries>
                <telerik:LineSeries DataFieldY="prem_cast" Name="[%Prémie%]">
                    <LineAppearance LineStyle="Step" Width="3" />
                    <Appearance>
                        <FillStyle BackgroundColor="DodgerBlue" />
                    </Appearance>
                    <TooltipsAppearance>
                        <ClientTemplate>
                                #=(dataItem.platnost_od.getDate()+"."+(dataItem.platnost_od.getMonth()+1)+"."+dataItem.platnost_od.getFullYear() +" - "+(dataItem.platnost_do==null?("?"):(dataItem.platnost_do.getDate()+"."+(dataItem.platnost_do.getMonth()+1)+"."+dataItem.platnost_do.getFullYear())))#
                                <br />
                                #=Intl.NumberFormat().format(dataItem.prem_cast)#
                        </ClientTemplate>
                    </TooltipsAppearance>
                    <LabelsAppearance DataFormatString="{0:N0}" RotationAngle="295" Position="Above">
                        <TextStyle Bold="true" />
                    </LabelsAppearance>
                </telerik:LineSeries>
            </Series>
            <YAxis Width="3">
                <LabelsAppearance DataFormatString="{0:N0}">
                </LabelsAppearance>
            </YAxis>
            <XAxis DataLabelsField="platnost_od" Type="Date" BaseUnit="Months" MajorTickType="None" Width="3">
                <TitleAppearance>
                </TitleAppearance>
                <LabelsAppearance DataFormatString="MMMM yyyy" Step="12" RotationAngle="45" Position="Start" >
                </LabelsAppearance>
                <MajorGridLines Visible="false"  />
                <MinorGridLines Visible="false" />
                <AxisCrossingPoints>
                    <telerik:AxisCrossingPoint Value="0" />
                    <telerik:AxisCrossingPoint Value="10" />
                </AxisCrossingPoints>
            </XAxis>
        </PlotArea>
    </telerik:RadHtmlChart>
</asp:Content>
