﻿<%@ Page Language="C#" MasterPageFile="~/Main.Master" AutoEventWireup="true" Inherits="Zamestnanec_VyplatniListek"
    CodeBehind="VyplatniListek.aspx.cs" %>

<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>

<%@ Register Assembly="AjaxControlToolkit" Namespace="AjaxControlToolkit" TagPrefix="cc3" %>
<%@ Register Assembly="WebControls" Namespace="KSProgram.WebControls" TagPrefix="cc1" %>
<%@ Register Src="~/Dokumenty/PdfViewer.ascx" TagName="PdfViewer" TagPrefix="pdf" %>

<asp:Content ID="Content1" ContentPlaceHolderID="HlavniOblast" runat="Server">

    <style type="text/css">
        .VLHeslo {
            margin-top: 15px;
            padding: 15px;
        }

            .VLHeslo td {
                padding: 10px;
            }

                .VLHeslo td button {
                    margin: auto;
                    margin-top: 5px;
                    width: 50px;
                }

                .VLHeslo td input {
                    text-align: center;
                }

        .VLtlacitko {
            border: 1px solid #e0dfdf;
            margin-top: 10px;
            width: 148px;
        }

        a {
            color: inherit;
        }
    </style>

    <telerik:RadAjaxManagerProxy ID="RadAjaxManagerProxy1" runat="server">
        <AjaxSettings>
            <telerik:AjaxSetting AjaxControlID="TLinkButton2">
                <UpdatedControls>
                    <telerik:AjaxUpdatedControl ControlID="TLinkButton2"></telerik:AjaxUpdatedControl>
                </UpdatedControls>
            </telerik:AjaxSetting>
        </AjaxSettings>
    </telerik:RadAjaxManagerProxy>

    <asp:Label ID="Label1" runat="server" Width="265px" CssClass="nadpis1 tiskHide"
        Height="32px" Text="[%Seznam výplatních lístků%]">
    </asp:Label>
    <br />
    <div class="tiskHide">
        <kspwc:TRadRok ID="tradrok_vyber" runat="server" AutoPostBack="true"></kspwc:TRadRok>
    </div>
    <asp:Panel ID="Panel1" runat="server">

        <table style="height: 125px">
            <tbody>
                <tr>
                    <td style="width: 200px; height: 467px; padding-right: 15px;" valign="top" align="left" class="tiskHide">
                        <div>
                            <cc3:Accordion ID="ldjfla" runat="server">
                            </cc3:Accordion>
                            <br />
                            <div class="rgCaption">[%Seznam výplatních lístků%]</div>
                            <cc1:TGridView ID="tgv_SeznamVyplatnichListku" runat="server" CssClass="tiskHide ksprvek"
                                DataKeyNames="id,code_page,zip" OnRowCommand="tgv_SeznamVyplatnichListku_RowCommand"
                                OnRowCreated="tgv_SeznamVyplatnichListku_RowCreated" OnSelectedIndexChanged="tgv_SeznamVyplatnichListku_SelectedIndexChanged"
                                ShowHeader="False" ShowTitleRow="false" SortAscImageUrl="" SortDescImageUrl="" ForeColor="Black"
                                TitleText="[%Seznam výplatních lístků%]" Width="100%" OnDataBound="tgv_SeznamVyplatnichListku_DataBound">
                                <Columns>
                                    <asp:TemplateField HeaderText="Období">
                                        <EditItemTemplate>
                                            <asp:TextBox ID="TextBox2" runat="server" Text='<%# Bind("obdobi") %>'></asp:TextBox>
                                        </EditItemTemplate>
                                        <ItemStyle HorizontalAlign="Left"></ItemStyle>
                                        <ItemTemplate>
                                            <asp:LinkButton ID="LinkButton1" runat="server" __designer:wfdid="w2"
                                                Text='<%# Bind("obdobi", "{0:MM-yyyy}") %>'></asp:LinkButton>
                                        </ItemTemplate>
                                    </asp:TemplateField>
                                    <asp:BoundField DataField="code_page" Visible="False"></asp:BoundField>
                                    <asp:BoundField DataField="zip" Visible="False" />
                                </Columns>
                                <RowStyle Height="30px" HorizontalAlign="Right"></RowStyle>
                            </cc1:TGridView>

                        </div>
                        <div style="padding-top: 10px; width: 80%; margin: auto;">
                            <kspwc:TRadButton ID="TLinkButton2" runat="server" CssClass="no-block-ui kstlacitko" ButtonType="StandardButton" Text="[%PDF Formát%]" OnClick="vCard_button_Click" AutoPostBack="true" Width="150px" Icon-PrimaryIconCssClass="fi fi-download"></kspwc:TRadButton>

                            <cc1:TLinkButton ID="LinkButton2" runat="server" OnClientClick="window.print();return false;" CssClass="kstlacitko VLtlacitko"
                                SkinID="button" Width="130px" DisableProgressBar="True" Text="[%Tisk výpl. lístků%]"></cc1:TLinkButton>
                        </div>
                    </td>
                    <td valign="top">&nbsp;                        
                        <div id="textpom" runat="server" style="font-size: 130%; color: black; background: white; padding: 10px;">
                        </div>

                    </td>
                </tr>
            </tbody>
        </table>
        <telerik:RadWindow ID="RadWindowListek" runat="server" Behaviors="Close,Resize,Move" Modal="true" KeepInScreenBounds="true"
            Title="[%Výplatní lístek%]" VisibleOnPageLoad="false" OnItemCommand="WindowClosed" AutoSize="false" Height="800" Width="800">
            <ContentTemplate>
                <pdf:PdfViewer runat="server" ID="PV_viewer" Height="100%" Width="100%" EnableDownload="false"></pdf:PdfViewer>
            </ContentTemplate>
        </telerik:RadWindow>
        <br />
        <br />
        <asp:ObjectDataSource ID="ds_NabidkaRoku" runat="server" TypeName="KSProgram.Personal.VyplatniListek"
            SelectMethod="NabidkaRoku" OldValuesParameterFormatString="original_{0}"></asp:ObjectDataSource>
        <asp:ObjectDataSource ID="ds_SeznamVyplatnichListku" runat="server" TypeName="KSProgram.Personal.VyplatniListek"
            SelectMethod="VyplatniListekZamestnance" OldValuesParameterFormatString="original_{0}">
            <SelectParameters>
                <%--<asp:ControlParameter ControlID="VyberRoku1" Name="Obdobi" PropertyName="SelectedValue"
                        Type="String" /> --%>
                <asp:ControlParameter ControlID="tradrok_vyber" Name="Obdobi" PropertyName="SelectedYearToString" Type="String" />

            </SelectParameters>
        </asp:ObjectDataSource>
    </asp:Panel>
    <asp:Panel ID="Panel_heslo" runat="server" DefaultButton="RadButPass" Visible="false">
        <table class="VLHeslo ksprvek">
            <tbody>
                <tr>
                    <td>&nbsp;</td>
                </tr>
                <tr>
                    <td>
                        <asp:Label ID="Label7" runat="server" AssociatedControlID="VyplListekPass"
                            Text="[%Pro zobrazení výplatních lístků zadejte heslo (PIN) pro výplatní lístky:%]"></asp:Label>
                    </td>

                </tr>
                <tr>
                    <td style="display: flex; flex-direction: column;">
                        <cc1:TTextBox ID="VyplListekPass" runat="server" TextMode="Password" class="input" DisableEnterKey="False">
                        </cc1:TTextBox>

                        <telerik:RadButton ID="RadButPass" runat="server" Text="OK" OnClick="RadButPassOnClick" CssClass="kstlacitko">
                        </telerik:RadButton>

                        <asp:CustomValidator runat="server" ID="PassValidator"></asp:CustomValidator>
                    </td>
                </tr>
            </tbody>
        </table>
    </asp:Panel>
</asp:Content>
