/**
 * Kendo UI v2022.3.913 (http://www.telerik.com/kendo-ui)
 * Copyright 2022 Progress Software Corporation and/or one of its subsidiaries or affiliates. All rights reserved.
 *
 * Kendo UI commercial licenses may be obtained at
 * http://www.telerik.com/purchase/license-agreement/kendo-ui-complete
 * If you do not own a commercial license, this file shall be governed by the trial license terms.
 */
!function(define){define("kendo.gantt.timeline.min",["kendo.dom.min","kendo.touch.min","kendo.draganddrop.min"],function(){var e={id:"gantt.timeline",name:"Gantt Timeline",category:"web",description:"The Gantt Timeline",depends:["dom","touch","draganddrop"],hidden:true},m=window.kendo.jQuery,a=kendo.ui.Widget,T=kendo.dom.element,f=kendo.dom.text,c=kendo.dom.html,l=m.isPlainObject,u=kendo._outerWidth,_=kendo._outerHeight,d=m.extend,D=false,n=kendo.keys,i=kendo.data.Query,h="string",r=".kendoGanttTimeline",o="click",p="dblclick",v="mousemove",t="mouseenter",y="mouseleave",w="keydown",k=".",s=kendo.template("#=kendo.toString(start, 't')#"),H=kendo.template("#=kendo.toString(start, 'ddd M/dd')#"),W=kendo.template("#=kendo.toString(start, 'ddd M/dd')# - #=kendo.toString(kendo.date.addDays(end, -1), 'ddd M/dd')#"),M=kendo.template("#=kendo.toString(start, 'MMM')#"),S=kendo.template("#=kendo.toString(start, 'yyyy')#"),x=kendo.template('<div class="#=styles.marquee#">'+'<div class="#=styles.marqueeColor#"></div>'+"</div>"),z=kendo.template('<div style="z-index: 100002;" class="#=styles.tooltipWrapper# k-gantt-resize-hint">'+'<div class="#=styles.tooltipContent#">'+"<div>#=messages.start#: #=kendo.toString(start, format)#</div>"+"<div>#=messages.end#: #=kendo.toString(end, format)#</div>"+"</div>"+"</div>"),P=kendo.template('<div style="z-index: 100002;" class="#=styles.tooltipWrapper#" >'+'<div class="#=styles.tooltipContent#">#=text#%</div>'+'<div class="#=styles.tooltipCallout#" style="left:13px;"></div>'+"</div>"),C=kendo.template('<div class="#=kendo.htmlEncode(styles.taskDetails)#">'+"<strong>#=kendo.htmlEncode(task.title)#</strong>"+'<div class="#=styles.taskDetailsPercent#">#=kendo.toString(task.percentComplete, "p0")#</div>'+'<ul class="#=styles.reset#">'+'<li>#=messages.start#: #=kendo.toString(task.start, "h:mm tt ddd, MMM d")#</li>'+'<li>#=messages.end#: #=kendo.toString(task.end, "h:mm tt ddd, MMM d")#</li>'+"</ul>"+"</div>"),E=kendo.template("<span>#=offsetPrefix#: #=offsetText#</span>"),N=kendo.template('<div class="k-task-content">'+"<div>#=plannedStart#: #=startDate#</div>"+"<div>#=plannedEnd#: #=endDate#</div>"+"</div>"),I="<table style='visibility: hidden;'>"+"<tbody>"+"<tr style='height:{0}'>"+"<td>&nbsp;</td>"+"</tr>"+"</tbody>"+"</table>",R={day:{type:"kendo.ui.GanttDayView"},week:{type:"kendo.ui.GanttWeekView"},month:{type:"kendo.ui.GanttMonthView"},year:{type:"kendo.ui.GanttYearView"}};function O(e){delete e.name;delete e.prefix;delete e.views;return e}function V(e){var t=[];var a=e.workWeekStart;t.push(a);while(e.workWeekEnd!=a){if(a>6)a-=7;else a++;t.push(a)}return t}function F(){var e=kendo._activeElement();if(e&&e.nodeName.toLowerCase()!=="body")m(e).trigger("blur")}var L={alt:"k-alt",reset:"k-reset",nonWorking:"k-nonwork-hour",header:"k-header",gridHeader:"k-grid-header",gridHeaderWrap:"k-grid-header-wrap",gridContent:"k-grid-content",tasksWrapper:"k-gantt-tables",rowsTable:"k-gantt-rows",columnsTable:"k-gantt-columns",tasksTable:"k-gantt-tasks",dependenciesWrapper:"k-gantt-dependencies",resource:"k-resource",resourceAlt:"k-resource k-alt",task:"k-task",taskSingle:"k-task-single",taskMilestone:"k-task-milestone",taskSummary:"k-task-summary",taskWrap:"k-task-wrap",taskMilestoneWrap:"k-milestone-wrap",taskSummaryWrap:"k-summary-wrap",taskPlanned:"k-task-planned",taskPlannedMoment:"k-task-moment",taskPlannedDuration:"k-task-duration",taskPlannedMomentLeft:"k-moment-left",taskAdvanced:"k-task-advanced",taskDelayed:"k-task-delayed",taskOffset:"k-task-offset",taskOffsetWrap:"k-task-offset-wrap",taskInnerWrap:"k-task-inner-wrap",resourcesWrap:"k-resources-wrap",taskDot:"k-task-dot",taskDotStart:"k-task-start",taskDotEnd:"k-task-end",taskDragHandle:"k-task-draghandle",taskContent:"k-task-content",taskTemplate:"k-task-template",taskActions:"k-task-actions",taskDelete:"k-task-delete",taskComplete:"k-task-complete",taskDetails:"k-task-details",taskDetailsPercent:"k-task-pct",link:"k-link",icon:"k-icon",iconDelete:"k-i-close",taskResizeHandle:"k-resize-handle",taskResizeHandleWest:"k-resize-w",taskResizeHandleEast:"k-resize-e",taskSummaryProgress:"k-task-summary-progress",taskSummaryComplete:"k-task-summary-complete",line:"k-gantt-line",lineHorizontal:"k-gantt-line-h",lineVertical:"k-gantt-line-v",arrowWest:"k-arrow-w",arrowEast:"k-arrow-e",dragHint:"k-drag-hint",dependencyHint:"k-gantt-dependency-hint",tooltipWrapper:"k-tooltip",tooltipContent:"k-tooltip-content",tooltipCallout:"k-callout k-callout-s",callout:"k-callout",marquee:"k-marquee k-gantt-marquee",marqueeColor:"k-marquee-color",offsetTooltipAdvanced:"k-offset-tooltip-advanced",offsetTooltipDelay:"k-offset-tooltip-delayed",plannedTooltip:"k-planned-tooltip"},b=kendo.ui.GanttView=a.extend({init:function(e,t){a.fn.init.call(this,e,t);this.title=this.options.title||this.options.name;this.header=this.element.find(k+b.styles.gridHeader);this.content=this.element.find(k+b.styles.gridContent);this.contentWidth=this.content.width();this._workDays=V(this.options);this._headerTree=t.headerTree;this._taskTree=t.taskTree;this._taskTemplate=t.taskTemplate?kendo.template(t.taskTemplate,d({},kendo.Template,t.templateSettings)):null;this._dependencyTree=t.dependencyTree;this._taskCoordinates={};this._currentTime()},destroy:function(){a.fn.destroy.call(this);clearTimeout(this._tooltipTimeout);this.headerRow=null;this.header=null;this.content=null;this._dragHint=null;this._resizeHint=null;this._resizeTooltip=null;this._taskTooltip=null;this._percentCompleteResizeTooltip=null;this._headerTree=null;this._taskTree=null;this._dependencyTree=null},options:{showWorkHours:false,showWorkDays:false,workDayStart:new Date(1980,1,1,8,0,0),workDayEnd:new Date(1980,1,1,17,0,0),workWeekStart:1,workWeekEnd:5,hourSpan:1,slotSize:100,currentTimeMarker:{updateInterval:1e4}},renderLayout:function(){this._slots=this._createSlots();this._tableWidth=this._calculateTableWidth();this.createLayout(this._layout());this._slotDimensions();this._adjustHeight();this.content.find(k+b.styles.dependenciesWrapper).width(this._tableWidth)},_adjustHeight:function(){if(this.content)this.content.height(this.element.height()-_(this.header))},createLayout:function(e){var t=this._headers(e);var a=this._colgroup();var s=this._headerTree;var n=T("tbody",null,t);var i=T("table",{style:{width:this._tableWidth+"px"},role:"presentation"},[a,n]);s.render([i]);this.headerRow=this.header.find("table").first().find("tr").last()},_slotDimensions:function(){var e=this.headerRow[0].children;var t=this._timeSlots();var a;var s;for(var n=0,i=e.length;n<i;n++){s=e[n];a=t[n];a.offsetLeft=s.offsetLeft;a.offsetWidth=s.offsetWidth}},render:function(e){var t=e.length;var a=b.styles;var s;var n=this._rowsTable(t);var i=this._columnsTable(t);var r=this._tasksTable(e);var o=this.options.currentTimeMarker;var l=this.options.calculatedSize;var d;this._taskTree.render([n,i,r]);s=this.content.find(k+a.rowsTable);if(l){d=l.row*e.length;this.content.find(k+a.tasksTable).height(d);s.height(d)}this._contentHeight=s.height();this._rowHeight=l?l.row:this._contentHeight/s.find("tr").length;this.content.find(k+a.columnsTable).height(this._contentHeight);if(o!==false&&o.updateInterval!==undefined)this._renderCurrentTime()},_rowsTable:function(e){var t=[];var a;var s=b.styles;var n=[null,{className:s.alt}];for(var i=0;i<e;i++){a=T("tr",n[i%2],[T("td",null,[f(" ")])]);t.push(a)}return this._createTable(1,t,{className:s.rowsTable})},_columnsTable:function(){var e=[];var t;var a=b.styles;var s=this._timeSlots();var n=s.length;var i;var r;var o=0;var l;for(var d=0;d<n;d++){i=s[d];l={};r=i.span;o+=r;if(r!==1)l.colspan=r;if(i.isNonWorking)l.className=a.nonWorking;e.push(T("td",l,[f(" ")]))}t=T("tr",null,e);return this._createTable(o,[t],{className:a.columnsTable})},_tasksTable:function(e){var h=[];var t;var a;var s;var n;var i;var r=b.styles;var p=this._taskCoordinates={};var f=this._calculateMilestoneWidth();var c=Math.round(f.width);var v=this.options.resourcesField;var u=[r.resource,r.resourceAlt];var k=this.options.calculatedSize;var o;var g=this._calculateResourcesMargin();var m=this._calculateTaskBorderWidth();var l;var _=this.options.showPlannedTasks;var y=function(e){var t;var a;t=s.left;a=t+s.width;if(i.isMilestone()){t-=c/2;a=t+c}p[i.id]={start:t,end:a,rowIndex:e}};for(var d=0,w=e.length;d<w;d++){i=e[d];s=this._taskPosition(i);if(_){n=this._taskPositionPlanned(i);n.borderWidth=m}s.borderWidth=m;t=T("tr",null);a=T("td");if(i.start<=this.end&&i.end>=this.start){a.children.push(this._renderTask(e[d],s,n));if(i[v]&&i[v].length){if(D)o=this._tableWidth-s.left;else o=Math.max(s.width||f.clientWidth,0)+s.left;l={width:this._tableWidth-(o+g)+"px"};l[D?"right":"left"]=o+"px";if(k)l.height=k.cell+"px";a.children.push(T("div",{className:r.resourcesWrap,style:l},this._renderResources(i[v],u[d%2])))}y(d)}t.children.push(a);h.push(t)}return this._createTable(1,h,{className:b.styles.tasksTable})},_createTable:function(e,t,a){var s=[];var n;var i;for(var r=0;r<e;r++)s.push(T("col"));n=T("colgroup",null,s);i=T("tbody",null,t);if(!a.style)a.style={};a.style.width=this._tableWidth+"px";a.role="presentation";return T("table",a,[n,i])},_calculateTableWidth:function(){var e=this._timeSlots();var t=0;var a=0;var s;var n;for(var i=0,r=e.length;i<r;i++){s=e[i].span;a+=s;if(s>t)t=s}n=Math.round(a*this.options.slotSize/t);return n},_calculateMilestoneWidth:function(){var e;var t=b.styles.task+" "+b.styles.taskMilestone;var a=m("<div class='"+t+"' style='visibility: hidden; position: absolute'>");var s;this.content.append(a);s=a[0].getBoundingClientRect();e={width:s.right-s.left,clientWidth:a[0].clientWidth};a.remove();return e},_calculateResourcesMargin:function(){var e;var t=m("<div class='"+b.styles.resourcesWrap+"' style='visibility: hidden; position: absolute'>");this.content.append(t);e=parseInt(t.css(D?"margin-right":"margin-left"),10);t.remove();return e},_calculateTaskBorderWidth:function(){var e;var t=b.styles.task+" "+b.styles.taskSingle;var a=m("<div class='"+t+"' style='visibility: hidden; position: absolute'>");var s;this.content.append(a);s=kendo.getComputedStyles(a[0],["border-left-width"]);e=parseFloat(s["border-left-width"],10);a.remove();return e},_renderTask:function(e,t,a){var s=this.options.editable;var h=t.left;var n=b.styles;var p=n.taskWrap;var f=this.options.calculatedSize;var c={};var i={className:p,style:{left:h+"px"}};var r=[];var v=0;var u=t.width;var o,l,k,g;var m,_,d,y;if(f)i.style.height=f.cell+"px";if(a){if(e.isMilestone())g=this._renderPlannedMilestone(t,a);else g=this._renderPlannedSingleTask(t,a,e);r.push(g);if(D&&a.left<=t.left)i.style.left=a.left+"px"}if(e.summary){l=this._renderSummary(e,t,a);i.className+=" "+n.taskSummaryWrap}else if(e.isMilestone()){l=this._renderMilestone(e,t);i.className+=" "+n.taskMilestoneWrap}else l=this._renderSingleTask(e,t,a);if(a&&!e.isMilestone()&&e.plannedStart<e.end&&e.plannedEnd>e.start&&e.plannedEnd<e.end){if(D)u=t.left+t.width-a.left;else u=a.left+a.width-t.left;if(D)y=a.left-t.left;else y=t.left+t.width-(a.left+a.width);d=T("div",{className:n.taskOffset,style:{width:y-2*a.borderWidth+"px"}});if(s&&s.resize!==false&&s.update!==false&&!e.summary){if(s.destroy!==false)d.children.push(T("span",{className:n.taskActions},[T("a",{className:n.link+" "+n.taskDelete,href:"#","aria-label":"Delete"},[T("span",{className:n.icon+" "+n.iconDelete})])]));if(D)d.children.push(T("span",{className:n.taskResizeHandle+" "+n.taskResizeHandleWest,style:{right:t.width-5+"px"}}));else d.children.push(T("span",{className:n.taskResizeHandle+" "+n.taskResizeHandleEast}))}_=T("div",{className:n.taskOffsetWrap+" "+n.taskInnerWrap},[l,d]);r.push(_)}else if(a)r.push(T("div",{className:n.taskInnerWrap},[l]));else r.push(l);o=T("div",i,r);if(s&&s.dependencyCreate!==false){if(a&&e.plannedEnd>e.end)v=a.left+a.width-t.left-t.width-3+"px";o.children.push(T("div",{className:n.taskDot+" "+n.taskDotStart}));if(D){v="auto";if(a&&e.plannedEnd>e.end)m=t.left-a.left+"px"}o.children.push(T("div",{className:n.taskDot+" "+n.taskDotEnd,style:{right:v,left:m}}))}if(!e.summary&&!e.isMilestone()&&s&&s.dragPercentComplete!==false&&s.update!==false&&this._taskTemplate===null){k=Math.round(u*e.percentComplete);c[D?"right":"left"]=k+"px";o.children.push(T("div",{className:n.taskDragHandle,style:c}))}return o},_renderSingleTask:function(e,t,a){var s=b.styles;var h;var n=[];var i;var r=this.options.editable;var o=s.task+" "+s.taskSingle;var l=t.width;if(a)if(e.plannedEnd&&e.plannedEnd<=e.start)o+=" "+s.taskDelayed;else if(e.plannedEnd&&e.plannedEnd>e.end)o+=" "+s.taskAdvanced;else if(e.plannedEnd&&e.plannedEnd<e.end)if(!D)l=l-(t.left+t.width-a.left-a.width);else l=l+t.left-a.left;h=Math.round(l*e.percentComplete);if(this._taskTemplate!==null)i=c(this._taskTemplate(e));else{i=f(e.title);n.push(T("div",{className:s.taskComplete,style:{width:h+"px"}}))}var d=T("div",{className:s.taskContent},[T("div",{className:s.taskTemplate},[i])]);n.push(d);if(r){if(r.destroy!==false&&(!a||!e.plannedEnd||(e.end<=e.plannedEnd||e.start>=e.plannedEnd)))d.children.push(T("span",{className:s.taskActions},[T("a",{className:s.link+" "+s.taskDelete,href:"#","aria-label":"Delete"},[T("span",{className:s.icon+" "+s.iconDelete})])]));if(r.resize!==false&&r.update!==false){d.children.push(T("span",{className:s.taskResizeHandle+" "+s.taskResizeHandleWest}));d.children.push(T("span",{className:s.taskResizeHandle+" "+s.taskResizeHandleEast}))}}var p=T("div",{className:o,"data-uid":e.uid,style:{width:Math.max(l-t.borderWidth*2,0)+"px"}},n);return p},_renderMilestone:function(e){var t=b.styles;var a=t.task+" "+t.taskMilestone;var s=this.options.showPlannedTasks;if(s&&e.plannedEnd&&e.plannedEnd<e.start)a+=" "+t.taskDelayed;else if(e.plannedStart&&e.plannedStart>e.end)a+=" "+t.taskAdvanced;return T("div",{className:a,"data-uid":e.uid})},_renderSummary:function(e,t,a){var s=b.styles;var n=t.width;var i;var r=s.task+" "+s.taskSummary;if(a)if(e.plannedEnd&&e.plannedEnd<=e.start)r+=" "+s.taskDelayed;else if(e.plannedEnd&&e.plannedEnd>e.end)r+=" "+s.taskAdvanced;else if(e.plannedEnd&&e.plannedEnd<e.end)if(!D)n=n-(t.left+t.width-a.left-a.width);else n=n+t.left-a.left;i=Math.round(n*e.percentComplete);var o=T("div",{className:r,"data-uid":e.uid,style:{width:n+"px"}},[T("div",{className:s.taskSummaryProgress,style:{width:i+"px"}},[T("div",{className:s.taskSummaryComplete,style:{width:t.width+"px"}})])]);return o},_renderPlannedSingleTask:function(e,t,a){var s=b.styles;var n=[];var i={};if(a.plannedStart&&a.plannedEnd){n.push(T("div",{className:s.taskPlannedMoment+" "+s.taskPlannedMomentLeft}));n.push(T("div",{className:s.taskPlannedDuration,style:{width:Math.max(t.width-t.borderWidth*2-16,0)+"px"}}));n.push(T("div",{className:s.taskPlannedMoment}))}else if(a.plannedStart)n.push(T("div",{className:s.taskPlannedMoment+" "+s.taskPlannedMomentLeft}));else if(a.plannedEnd)n.push(T("div",{className:s.taskPlannedMoment,style:{"margin-left":Math.max(t.width-5,0)+"px"}}));if(D)i={"margin-right":e.left-t.left+e.width-t.width+"px"};else i={"margin-left":t.left-e.left+"px"};var r=T("div",{className:s.taskPlanned,style:i},n);return r},_renderPlannedMilestone:function(e,t){var a=b.styles;var s={};var n;if(D)s={"margin-right":e.left-t.left+"px"};else s={"margin-left":t.left-e.left+"px"};n=T("div",{className:a.taskPlanned,style:s},[T("div",{className:a.taskPlannedMoment})]);return n},_renderResources:function(e,t){var a=[];var s;for(var n=0,i=e.length;n<i;n++){s=e[n];a.push(T("span",{className:t,style:{color:s.get("color")}},[f(s.get("name"))]))}if(D)a.reverse();return a},_taskPosition:function(e){var t=Math.round;var a=t(this._offset(D?e.end:e.start));var s=t(this._offset(D?e.start:e.end));return{left:a,width:s-a}},_taskPositionPlanned:function(e){var t=Math.round;var a=t(this._offset(D?e.plannedEnd:e.plannedStart));var s=t(this._offset(D?e.plannedStart:e.plannedEnd));return{left:a,width:s-a}},_offset:function(e){var t=this._timeSlots();var a;var s;var n;var i=0;var r;if(!t.length)return 0;r=this._slotIndex("start",e);a=t[r];if(a.end<e)i=a.offsetWidth;else if(a.start<=e){s=e-a.start;n=a.end-a.start;i=s/n*a.offsetWidth}if(D)i=a.offsetWidth+1-i;return a.offsetLeft+i},_slotIndex:function(e,t,a){var s=this._timeSlots();var n=0;var i=s.length-1;var r;if(a)s=[].slice.call(s).reverse();do{r=Math.ceil((i+n)/2);if(s[r][e]<t)n=r;else{if(r===i)r--;i=r}}while(n!==i);if(a)n=s.length-1-n;return n},_timeByPosition:function(e,t,a){var s=this._slotByPosition(e);if(t)return a?s.end:s.start;var n=e-this.element.find(k+b.styles.tasksTable).offset().left;var i=s.end-s.start;var r=n-s.offsetLeft;if(D)r=s.offsetWidth-r;return new Date(s.start.getTime()+i*(r/s.offsetWidth))},_slotByPosition:function(e){var t=e-this.element.find(k+b.styles.tasksTable).offset().left;var a=this._slotIndex("offsetLeft",t,D);return this._timeSlots()[a]},_renderDependencies:function(e){var t=[];var a=this._dependencyTree;for(var s=0,n=e.length;s<n;s++)t.push.apply(t,this._renderDependency(e[s]));a.render(t)},_renderDependency:function(e){var t=this._taskCoordinates[e.predecessorId];var a=this._taskCoordinates[e.successorId];var s;var n;if(!t||!a)return[];n="_render"+["FF","FS","SF","SS"][D?3-e.type:e.type];s=this[n](t,a);for(var i=0,r=s.length;i<r;i++)s[i].attr["data-uid"]=e.uid;return s},_renderFF:function(e,t){var a=this._dependencyFF(e,t,false);a[a.length-1].children[0]=this._arrow(true);return a},_renderSS:function(e,t){var a=this._dependencyFF(t,e,true);a[0].children[0]=this._arrow(false);return a.reverse()},_renderFS:function(e,t){var a=this._dependencyFS(e,t,false);a[a.length-1].children[0]=this._arrow(false);return a},_renderSF:function(e,t){var a=this._dependencyFS(t,e,true);a[0].children[0]=this._arrow(true);return a.reverse()},_dependencyFF:function(h,p,e){var f=this;var c=[];var t=0;var a=0;var s=0;var n=0;var i=e?"start":"end";var v;var r=2;var u=1;var o=this._rowHeight;var k=10;var g=h.rowIndex*o+Math.floor(o/2)-1;var l=p.rowIndex*o+Math.floor(o/2)-1;var d=b.styles;var m=function(){c.push(f._line(d.line+" "+d.lineHorizontal,{left:t+"px",top:a+"px",width:s+"px"}))};var _=function(){c.push(f._line(d.line+" "+d.lineVertical,{left:t+"px",top:a+"px",height:n+"px"}))};t=h[i];a=g;s=k;v=p[i]-h[i];if(v>0!==e)s=Math.abs(v)+k;if(e){t-=s;s-=u;m()}else{m();t+=s-r}if(l<a){n=a-l;n+=r;a=l;_()}else{n=l-a;n+=r;_();a+=n-r}s=Math.abs(t-p[i]);if(!e){s-=u;t-=s}m();return c},_dependencyFS:function(e,t,h){var p=this;var f=[];var a=0;var s=0;var n=0;var i=0;var r=this._rowHeight;var c=Math.floor(r/2);var o=10;var v=2*o;var u=t.start-e.end;var l=2;var k=1;var g=e.rowIndex*r+Math.floor(r/2)-1;var d=t.rowIndex*r+Math.floor(r/2)-1;var m=b.styles;var _=function(){f.push(p._line(m.line+" "+m.lineHorizontal,{left:a+"px",top:s+"px",width:n+"px"}))};var y=function(){f.push(p._line(m.line+" "+m.lineVertical,{left:a+"px",top:s+"px",height:i+"px"}))};a=e.end;s=g;n=o;if(h){a+=k;if(u>v)n=u-(o-l);n-=k}_();a+=n-l;if(u<=v){i=h?Math.abs(d-g)-c:c;if(d<g){s-=i;i+=l;y()}else{y();s+=i}n=e.end-t.start+v;if(n<o)n=o;a-=n-l;_()}if(d<g){i=s-d;s=d;i+=l;y()}else{i=d-s;y();s+=i}n=t.start-a;if(!h)n-=k;_();return f},_line:function(e,t){return T("div",{className:e,style:t})},_arrow:function(e){return T("span",{className:e?b.styles.arrowWest:b.styles.arrowEast})},_colgroup:function(){var e=this._timeSlots();var t=e.length;var a=[];for(var s=0;s<t;s++)for(var n=0,i=e[s].span;n<i;n++)a.push(T("col"));return T("colgroup",null,a)},_createDragHint:function(e){var t=b.styles;var a;this._dragHint=e.clone().addClass(t.dragHint).css({cursor:"move"});a=this._dragHint.find(k+t.taskPlanned);a.css({visibility:"hidden"});if(D&&e.find(k+t.taskAdvanced).length>0){a.css({"margin-right":"auto",width:0});this._dragHint.find(k+t.taskDotEnd).css({left:0})}e.closest("td").append(this._dragHint)},_updateDragHint:function(e){var t=this._offset(e);this._dragHint.css({left:t})},_removeDragHint:function(){this._dragHint.remove();this._dragHint=null},_createResizeHint:function(e){var t=b.styles;var a=this._taskCoordinates[e.id].rowIndex*this._rowHeight;var s;var n;var i=this.options;var r=i.messages;this._resizeHint=m(x({styles:t})).css({top:0,height:this._contentHeight});this.content.append(this._resizeHint);this._resizeTooltip=m(z({styles:t,start:e.start,end:e.end,messages:r.views,format:i.resizeTooltipFormat})).css({top:0,left:0});this.content.append(this._resizeTooltip);this._resizeTooltipWidth=u(this._resizeTooltip);s=_(this._resizeTooltip);n=a-s;if(n<0)n=a+this._rowHeight;this._resizeTooltipTop=n},_updateResizeHint:function(e,t,a){var s=this._offset(D?t:e);var n=this._offset(D?e:t);var h=n-s;var i=a!==D?s:n;var r=this._tableWidth-kendo.support.scrollbar();var o=this._resizeTooltipWidth;var l=this.options;var p=l.messages;var d=this.element.find(k+b.styles.tasksTable).offset().left-this.element.find(k+b.styles.tasksWrapper).offset().left;if(D)s+=d;this._resizeHint.css({left:s,width:h});if(this._resizeTooltip)this._resizeTooltip.remove();i-=Math.round(o/2);if(i<0)i=0;else if(i+o>r)i=r-o;if(D)i+=d;this._resizeTooltip=m(z({styles:b.styles,start:e,end:t,messages:p.views,format:l.resizeTooltipFormat})).css({top:this._resizeTooltipTop,left:i,"min-width":o}).appendTo(this.content)},_removeResizeHint:function(){this._resizeHint.remove();this._resizeHint=null;this._resizeTooltip.remove();this._resizeTooltip=null},_updatePercentCompleteTooltip:function(e,t,a){this._removePercentCompleteTooltip();var s=this._percentCompleteResizeTooltip=m(P({styles:b.styles,text:a})).appendTo(this.element);var n=Math.round(u(s)/2);var i=s.find(k+b.styles.callout);var r=Math.round(u(i)/2);s.css({top:e-(_(s)+r),left:t-n});i.css("left",n-r)},_removePercentCompleteTooltip:function(){if(this._percentCompleteResizeTooltip)this._percentCompleteResizeTooltip.remove();this._percentCompleteResizeTooltip=null},_updateDependencyDragHint:function(e,t){this._removeDependencyDragHint();this._creteDependencyDragHint(e,t)},_creteDependencyDragHint:function(e,t){var a=b.styles;var s=t.x-e.x;var n=t.y-e.y;var i=Math.sqrt(s*s+n*n);var r=Math.atan(n/s);if(s<0)r+=Math.PI;m("<div class='"+a.line+" "+a.lineHorizontal+" "+a.dependencyHint+"'></div>").css({top:e.y,left:e.x,width:i,"transform-origin":"0% 0","-ms-transform-origin":"0% 0","-webkit-transform-origin":"0% 0",transform:"rotate("+r+"rad)","-ms-transform":"rotate("+r+"rad)","-webkit-transform":"rotate("+r+"rad)"}).appendTo(this.content)},_removeDependencyDragHint:function(){this.content.find(k+b.styles.dependencyHint).remove()},_createTaskTooltip:function(h,p,e){var t=b.styles;var a=this.options;var s=this.content;var n=s.offset();var i=kendo.scrollLeft(s);var r=m(p).parents("tr").first();var o=r.offset();var f=a.tooltip&&a.tooltip.template?kendo.template(a.tooltip.template):C;var l=D?e-(n.left+i+kendo.support.scrollbar()):e-(n.left-i);var c=o.top+_(r)-n.top+s.scrollTop();var d=this._taskTooltip=m('<div style="z-index: 100002;" class="'+t.tooltipWrapper+'" >'+'<div class="'+t.taskContent+'"></div></div>');d.css({left:l,top:c}).appendTo(s).find(k+t.taskContent).append(f({styles:t,task:h,messages:a.messages.views}));this._adjustTooltipDimensions(d,o,n,l,i)},_removeTaskTooltip:function(){if(this._taskTooltip)this._taskTooltip.remove();this._taskTooltip=null},_createOffsetTooltip:function(e,h,t){var p=b.styles;var a=this.content;var s=a.offset();var n=kendo.scrollLeft(a);var f=h.parents("tr").first();var c=f.offset();var v=D?t-(s.left+n+kendo.support.scrollbar()):t-(s.left-n);var u=c.top+_(f)-s.top+a.scrollTop();var k=this._offsetTooltip=m('<div style="z-index: 100002;" class="'+p.tooltipWrapper+'" ></div>');var i=Math.round((e.end.getTime()-e.plannedEnd.getTime())/6e4);var r=this.options.messages.plannedTasks;var o=i%60;var l=o+" "+r.minutes;var d,g;if(i>=60){d=i=Math.floor(i/60);l=d+" "+r.hours;if(o!==0)l+=" "+o+" "+r.minutes;if(i>=24){d=i%24;g=i=Math.floor(i/24);l=g+" "+r.days;if(d!==0)l+=" "+d+" "+r.hours}}k.css({left:v,top:u}).addClass(p.offsetTooltipDelay).appendTo(a).append(E({offsetPrefix:r.offsetTooltipDelay,offsetText:l}));this._adjustTooltipDimensions(k,c,s,v,n)},_removeOffsetTooltip:function(){if(this._offsetTooltip)this._offsetTooltip.remove();this._offsetTooltip=null},_createPlannedTooltip:function(e,h,t){var a=b.styles;var s=this.content;var n=s.offset();var i=kendo.scrollLeft(s);var r=h.parents("tr").first();var o=r.offset();var l=D?t-(n.left+i+kendo.support.scrollbar()):t-(n.left-i);var p=o.top+_(r)-n.top+s.scrollTop();var d=this._plannedTooltip=m('<div style="z-index: 100002;" class="'+a.tooltipWrapper+" "+a.plannedTooltip+'" ></div>');var f=this.options.messages.editor;d.css({left:l,top:p}).appendTo(s).append(N({plannedStart:f.plannedStart,startDate:kendo.toString(e.plannedStart,"H:mm tt ddd, MMM dd"),plannedEnd:f.plannedEnd,endDate:kendo.toString(e.plannedEnd,"H:mm tt ddd, MMM dd")}));this._adjustTooltipDimensions(d,o,n,l,i)},_removePlannedTooltip:function(){if(this._plannedTooltip)this._plannedTooltip.remove();this._plannedTooltip=null},_adjustTooltipDimensions:function(e,t,a,s,n){var i=this.content;var r=i.width();var o;if(_(e)<t.top-a.top)e.css("top",t.top-a.top-_(e)+i.scrollTop());o=u(e);if(o+s-n>r){s-=o;if(s<n)s=n+r-(o+17);e.css("left",s)}},_scrollTo:function(e){var t=e.offset().left;var a=e.width();var s=t+a;var h=e.closest("tr");var n=h.offset().top;var p=h.height();var f=n+p;var i=this.content;var c=i.offset();var r=c.top;var v=i.height();var u=r+v;var o=c.left;var l=i.width();var d=o+l;var k=kendo.support.scrollbar();if(n<r)i.scrollTop(i.scrollTop()+(n-r));else if(f>u)i.scrollTop(i.scrollTop()+(f+k-u));if(t<o&&a>l&&s<d||s>d&&a<l)kendo.scrollLeft(i,kendo.scrollLeft(i)+(s+k-d));else if(s>d&&a>l&&t>o||t<o&&a<l)kendo.scrollLeft(i,kendo.scrollLeft(i)+(t-o))},_scrollToDate:function(e){var t=this.start;var a=this.end;var s;if(e>=t&&e<a){s=this._offset(e);if(kendo.support.isRtl(this.element))s=this._tableWidth-s;kendo.scrollLeft(this.content,s)}},_timeSlots:function(){if(!this._slots||!this._slots.length)return[];return this._slots[this._slots.length-1]},_headers:function(e){var t=[];var a;var s;var n;var i;var r=b.styles;for(var o=0,l=e.length;o<l;o++){a=e[o];s=[];for(var d=0,h=a.length;d<h;d++){n=a[d];i=c(n.text);s.push(T("td",{colspan:n.span,className:r.header+(n.isNonWorking?" "+r.nonWorking:"")},[i]))}t.push(T("tr",null,s))}return t},_hours:function(e,t){var a;var s=[];var n=this.options;var i=n.workDayStart.getHours();var r=n.workDayEnd.getHours();var o;var l;var d=n.hourSpan;e=new Date(e);t=new Date(t);if(n.showWorkHours)e.setHours(i);while(e<t){a=new Date(e);l=a.getHours();o=l>=i&&l<r;a.setHours(a.getHours()+d);if(l==a.getHours())a.setHours(a.getHours()+2*d);if(!n.showWorkHours||o)s.push({start:e,end:a,isNonWorking:!o,span:1});e=a}return s},_days:function(e,t){var a;var s=[];var n;e=new Date(e);t=new Date(t);while(e<t){a=t<kendo.date.nextDay(e)?t:kendo.date.nextDay(e);n=this._isWorkDay(e);if(!this.options.showWorkDays||n)s.push({start:e,end:a,isNonWorking:!n,span:1});e=a}return s},_weeks:function(e,t){var a;var s=[];var n=this.calendarInfo().firstDay;var i;var r;e=new Date(e);t=new Date(t);while(e<t){a=kendo.date.dayOfWeek(kendo.date.addDays(e,1),n,1);if(a>t)a=t;i=this._days(e,a);r=i.length;if(r>0)s.push({start:i[0].start,end:i[r-1].end,span:r});e=a}return s},_months:function(e,t){var a;var s;var n=[];var i;var r;e=new Date(e);t=new Date(t);while(e<t){a=new Date(e);s=kendo.date.firstDayOfMonth(new Date(a.setMonth(a.getMonth()+1)));a=t<s?t:s;i=this._days(e,a);r=i.length;if(r>0)n.push({start:i[0].start,end:i[r-1].end,span:r});e=a}return n},_years:function(e,t){var a;var s;var n;var i=[];e=new Date(e);t=new Date(t);while(e<t){a=new Date(e);a=kendo.date.firstDayOfMonth(new Date(a.setMonth(12)));if(a>=t)a=t;n=a.getMonth()||12;s=n-e.getMonth();i.push({start:e,end:a,span:s});e=a}return i},_slotHeaders:function(e,t){var a=[];var s;for(var n=0,i=e.length;n<i;n++){s=e[n];a.push({text:t(s),isNonWorking:!!s.isNonWorking,span:s.span})}return a},_isWorkDay:function(e){var t=e.getDay();var a=this._workDays;for(var s=0,n=a.length;s<n;s++)if(a[s]===t)return true;return false},calendarInfo:function(){return kendo.getCulture().calendars.standard},_renderCurrentTime:function(){var e=this._getCurrentTime();var t=this._offset(e);var a=m("<div class='k-current-time'></div>");var s=b.styles;var n=this.element.find(k+s.tasksWrapper);var i=this.element.find(k+s.tasksTable);var r;if(!this.content||!this._timeSlots().length)return;this.content.find(".k-current-time").remove();r=this._timeSlots()[this._slotIndex("start",e)];if(e<r.start||e>r.end)return;if(n.length&&i.length)t+=i.offset().left-n.offset().left;a.css({left:t+"px",top:"0px",width:"1px",height:this._contentHeight+"px"}).appendTo(this.content)},_getCurrentTime:function(){return new Date},_currentTime:function(){var e=this.options.currentTimeMarker;if(e!==false&&e.updateInterval!==undefined){this._renderCurrentTime();this._currentTimeUpdateTimer=setInterval(this._renderCurrentTime.bind(this),e.updateInterval)}}}),B=(d(true,b,{styles:L}),kendo.ui.GanttDayView=b.extend({name:"day",options:{timeHeaderTemplate:s,dayHeaderTemplate:H,resizeTooltipFormat:"h:mm tt ddd, MMM d"},range:function(e){var t=this.options.range;this.start=kendo.date.getDate(e.start);this.end=kendo.date.getDate(e.end);if(kendo.date.getMilliseconds(e.end)>0||this.end.getTime()===this.start.getTime())this.end=kendo.date.addDays(this.end,1);if(t&&t.start){this.start=kendo.date.getDate(t.start);this.start.setHours(t.start.getHours())}if(t&&t.end){this.end=kendo.date.getDate(t.end);this.end.setHours(t.end.getHours())}},_createSlots:function(){var e;var t;var a;var s;var n=[];e=this._days(this.start,this.end);a=[];for(var i=0,r=e.length;i<r;i++){t=e[i];s=this._hours(t.start,t.end);t.span=s.length;a.push.apply(a,s)}n.push(e);n.push(a);return n},_layout:function(){var e=[];var t=this.options;e.push(this._slotHeaders(this._slots[0],kendo.template(t.dayHeaderTemplate)));e.push(this._slotHeaders(this._slots[1],kendo.template(t.timeHeaderTemplate)));return e}}),kendo.ui.GanttWeekView=b.extend({name:"week",options:{dayHeaderTemplate:H,weekHeaderTemplate:W,resizeTooltipFormat:"h:mm tt ddd, MMM d"},range:function(e){var t=this.options.range;var a=this.calendarInfo();var s=a.firstDay;var n=e.end;var i;if(s===n.getDay())n.setDate(n.getDate()+7);this.start=kendo.date.getDate(kendo.date.dayOfWeek(e.start,s,-1));this.end=kendo.date.getDate(kendo.date.dayOfWeek(n,s,1));if(t&&t.start)this.start=kendo.date.getDate(t.start);if(t&&t.end){i=new Date(t.end);if(kendo.date.getDate(i)<t.end)this.end=kendo.date.getDate(new Date(i.setDate(i.getDate()+1)));else this.end=kendo.date.getDate(i)}},_createSlots:function(){var e=[];e.push(this._weeks(this.start,this.end));e.push(this._days(this.start,this.end));return e},_layout:function(){var e=[];var t=this.options;e.push(this._slotHeaders(this._slots[0],kendo.template(t.weekHeaderTemplate)));e.push(this._slotHeaders(this._slots[1],kendo.template(t.dayHeaderTemplate)));return e}}),kendo.ui.GanttMonthView=b.extend({name:"month",options:{weekHeaderTemplate:W,monthHeaderTemplate:M,resizeTooltipFormat:"dddd, MMM d, yyyy"},range:function(e){var t=this.options.range;var a;this.start=kendo.date.firstDayOfMonth(e.start);this.end=kendo.date.addDays(kendo.date.getDate(kendo.date.lastDayOfMonth(e.end)),1);if(t&&t.start)this.start=kendo.date.getDate(t.start);if(t&&t.end){a=new Date(t.end);if(kendo.date.getDate(a)<t.end)this.end=kendo.date.getDate(new Date(a.setDate(a.getDate()+1)));else this.end=kendo.date.getDate(a)}},_createSlots:function(){var e=[];e.push(this._months(this.start,this.end));e.push(this._weeks(this.start,this.end));return e},_layout:function(){var e=[];var t=this.options;e.push(this._slotHeaders(this._slots[0],kendo.template(t.monthHeaderTemplate)));e.push(this._slotHeaders(this._slots[1],kendo.template(t.weekHeaderTemplate)));return e}}),kendo.ui.GanttYearView=b.extend({name:"year",options:{yearHeaderTemplate:S,monthHeaderTemplate:M,resizeTooltipFormat:"dddd, MMM d, yyyy"},range:function(e){var t=this.options.range;var a;this.start=kendo.date.firstDayOfMonth(new Date(e.start.setMonth(0)));this.end=kendo.date.firstDayOfMonth(new Date(e.end.setMonth(12)));if(t&&t.start)this.start=kendo.date.firstDayOfMonth(t.start);if(t&&t.end){a=kendo.date.firstDayOfMonth(t.end);this.end=kendo.date.getDate(new Date(a.setMonth(a.getMonth()+1)))}},_createSlots:function(){var e=[];var t=this._months(this.start,this.end);m(t).each(function(e,t){t.span=1});e.push(this._years(this.start,this.end));e.push(t);return e},_layout:function(){var e=[];var t=this.options;e.push(this._slotHeaders(this._slots[0],kendo.template(t.yearHeaderTemplate)));e.push(this._slotHeaders(this._slots[1],kendo.template(t.monthHeaderTemplate)));return e}}),{wrapper:"k-timeline k-grid k-widget",gridHeader:"k-grid-header",gridHeaderWrap:"k-grid-header-wrap",gridContent:"k-grid-content",gridContentWrap:"k-grid-content",tasksWrapper:"k-gantt-tables",dependenciesWrapper:"k-gantt-dependencies",task:"k-task",taskOffset:"k-task-offset",taskOffsetWrap:"k-task-offset-wrap",taskPlanned:"k-task-planned",line:"k-gantt-line",taskResizeHandle:"k-resize-handle",taskResizeHandleWest:"k-resize-w",taskDragHandle:"k-task-draghandle",taskComplete:"k-task-complete",taskDelete:"k-task-delete",taskWrapActive:"k-task-wrap-active",taskWrap:"k-task-wrap",taskDot:"k-task-dot",taskDotStart:"k-task-start",taskDotEnd:"k-task-end",hovered:"k-hover",selected:"k-selected",origin:"k-origin"}),g=kendo.ui.GanttTimeline=a.extend({init:function(e,t){a.fn.init.call(this,e,t);if(!this.options.views||!this.options.views.length)this.options.views=["day","week","month"];D=kendo.support.isRtl(e);this._wrapper();this._domTrees();this._views();this._selectable();this._draggable();this._resizable();this._percentResizeDraggable();this._createDependencyDraggable();this._attachEvents();this._tooltip()},options:{name:"GanttTimeline",messages:{views:{day:"Day",week:"Week",month:"Month",year:"Year",start:"Start",end:"End"}},snap:true,selectable:true,editable:true},destroy:function(){a.fn.destroy.call(this);clearTimeout(this._tooltipTimeout);if(this._currentTimeUpdateTimer)clearInterval(this._currentTimeUpdateTimer);this._unbindView(this._selectedView);if(this._moveDraggable)this._moveDraggable.destroy();if(this._resizeDraggable)this._resizeDraggable.destroy();if(this._percentDraggable)this._percentDraggable.destroy();if(this._dependencyDraggable)this._dependencyDraggable.destroy();if(this.touch)this.touch.destroy();this._headerTree=null;this._taskTree=null;this._dependencyTree=null;this.wrapper.off(r);kendo.destroy(this.wrapper)},_wrapper:function(){var i=g.styles;var r=this;var o=this.options;var e=function(){var e=typeof o.rowHeight===h?o.rowHeight:o.rowHeight+"px";var t=m(kendo.format(I,e));var a;var s;var n=r.wrapper.find(k+i.tasksWrapper);n.append(t);a=_(t.find("tr"));s=t.find("td").height();t.remove();return{row:a,cell:s}};this.wrapper=this.element.addClass(i.wrapper).append("<div class='"+i.gridHeader+"'><div class='"+i.gridHeaderWrap+"'></div></div>").append("<div class='"+i.gridContentWrap+"'><div class='"+i.tasksWrapper+"'></div><div class='"+i.dependenciesWrapper+"'></div></div>");if(o.rowHeight)this._calculatedSize=e()},_domTrees:function(){var e=g.styles;var t=kendo.dom.Tree;var a=this.wrapper;this._headerTree=new t(a.find(k+e.gridHeaderWrap)[0]);this._taskTree=new t(a.find(k+e.tasksWrapper)[0]);this._dependencyTree=new t(a.find(k+e.dependenciesWrapper)[0])},_views:function(){var e=this.options.views;var t;var a;var s;var n;var i;this.views={};for(var r=0,o=e.length;r<o;r++){t=e[r];a=l(t);if(a&&t.selectable===false)continue;s=a?typeof t.type!=="string"?t.title:t.type:t;n=R[s];if(n){if(a)t.type=n.type;n.title=this.options.messages.views[s]}t=d({title:s},n,a?t:{});if(s){this.views[s]=t;if(!i||t.selected)i=s}}if(i)this._selectedViewName=i},view:function(e){if(e){this._selectView(e);this.trigger("navigate",{view:e,action:"changeView"})}return this._selectedView},_selectView:function(e){if(e&&this.views[e]){if(this._selectedView)this._unbindView(this._selectedView);this._selectedView=this._initializeView(e);this._selectedViewName=e}},_viewByIndex:function(e){var t;var a=this.views;for(t in a){if(!e)return t;e--}},_initializeView:function(e){var t=this.views[e];if(t){var a=t.type;if(typeof a==="string")a=kendo.getter(t.type)(window);if(a){var s={};d(s,this.options.range,t.range);var n=t.date||this.options.date;t=new a(this.wrapper,O(d(true,{headerTree:this._headerTree,taskTree:this._taskTree,dependencyTree:this._dependencyTree,calculatedSize:this._calculatedSize},t,this.options,{date:n,range:s})))}else throw new Error("There is no such view")}return t},_unbindView:function(e){if(e)e.destroy()},_range:function(e){var t={field:"start",dir:"asc"};var a={field:"end",dir:"desc"};if(!e||!e.length)return{start:new Date,end:new Date};var s=new i(e).sort(t).toArray()[0].start||new Date;var n=new i(e).sort(a).toArray()[0].end||new Date;return{start:new Date(s),end:new Date(n)}},_render:function(e){var t=this.view();var a=this._range(e);var s=t.options.date;this._tasks=e;t.range(a);t.renderLayout();t.render(e);if(s)t._scrollToDate(s)},_renderDependencies:function(e){this.view()._renderDependencies(e)},_taskByUid:function(e){var t=this._tasks;var a=t.length;var s;for(var n=0;n<a;n++){s=t[n];if(s.uid===e)return s}},_draggable:function(){var n=this;var a;var i;var r;var o;var l=this.options.snap;var s=g.styles;var e=this.options.editable;var t=function(){n.view()._removeDragHint();if(a)a.css("opacity",1);a=null;i=null;n.dragInProgress=false};if(!e||e.move===false||e.update===false)return;this._moveDraggable=new kendo.ui.Draggable(this.wrapper,{distance:0,filter:k+s.task+","+k+s.taskOffset,holdToDrag:kendo.support.mobileOS,ignore:k+s.taskResizeHandle});this._moveDraggable.bind("dragstart",function(e){var t=n.view();a=e.currentTarget.closest(k+s.taskWrap);i=n._taskByUid(e.currentTarget.parent().find(k+s.task).attr("data-uid"));if(n.trigger("moveStart",{task:i})){e.preventDefault();return}r=i.start;o=t._timeByPosition(e.x.location,l)-r;t._createDragHint(a);a.css("opacity",.5);clearTimeout(n._tooltipTimeout);n.dragInProgress=true}).bind("drag",kendo.throttle(function(e){if(!n.dragInProgress)return;var t=n.view();var a=new Date(t._timeByPosition(e.x.location,l)-o);var s=a;if(!n.trigger("move",{task:i,start:a})){r=a;if(D)s=new Date(r.getTime()+i.duration());t._updateDragHint(s)}},15)).bind("dragend",function(){n.trigger("moveEnd",{task:i,start:r});t()}).bind("dragcancel",function(){t()}).userEvents.bind("select",function(){F()})},_resizable:function(){var s=this;var t;var n;var i;var r;var o;var l=this.options.snap;var a=g.styles;var e=this.options.editable;var d=function(){s.view()._removeResizeHint();t=null;n=null;s.dragInProgress=false};if(!e||e.resize===false||e.update===false)return;this._resizeDraggable=new kendo.ui.Draggable(this.wrapper,{distance:0,filter:k+a.taskResizeHandle,holdToDrag:false});this._resizeDraggable.bind("dragstart",function(e){o=e.currentTarget.hasClass(a.taskResizeHandleWest);if(D)o=!o;t=e.currentTarget.closest(k+a.taskWrap).find(k+a.task);n=s._taskByUid(t.attr("data-uid"));if(s.trigger("resizeStart",{task:n})){e.preventDefault();return}i=n.start;r=n.end;s.view()._createResizeHint(n);clearTimeout(s._tooltipTimeout);s.dragInProgress=true}).bind("drag",kendo.throttle(function(e){if(!s.dragInProgress)return;var t=s.view();var a=t._timeByPosition(e.x.location,l,!o);if(o)if(a<r)i=a;else i=r;else if(a>i)r=a;else r=i;if(!s.trigger("resize",{task:n,start:i,end:r}))t._updateResizeHint(i,r,o)},15)).bind("dragend",function(){s.trigger("resizeEnd",{task:n,resizeStart:o,start:i,end:r});d()}).bind("dragcancel",function(){d()}).userEvents.bind("select",function(){F()})},_percentResizeDraggable:function(){var a=this;var t;var s;var n;var i;var r;var o;var l;var p;var d;var h=g.styles;var f;var e=this.options.editable;var c=function(){a.view()._removePercentCompleteTooltip();s=null;t=null;a.dragInProgress=false};var v=function(e){var t=s.siblings(k+h.taskDragHandle);if(!t.length)t=s.closest(k+h.taskWrap).find(k+h.taskDragHandle);t.css(D?"right":"left",e);s.find(k+h.taskComplete).width(e)};if(!e||e.dragPercentComplete===false||e.update===false)return;this._percentDraggable=new kendo.ui.Draggable(this.wrapper,{distance:0,filter:k+h.taskDragHandle,holdToDrag:false});this._percentDraggable.bind("dragstart",function(e){if(a.trigger("percentResizeStart")){e.preventDefault();return}s=e.currentTarget.siblings(k+h.task);if(!s.length)s=e.currentTarget.closest(k+h.taskWrap).find(k+h.task);t=a._taskByUid(s.attr("data-uid"));l=t.percentComplete;n=s.offset();i=this.element.offset();r=s.find(k+h.taskComplete).width();o=u(s);clearTimeout(a._tooltipTimeout);a.dragInProgress=true}).bind("drag",kendo.throttle(function(e){if(!a.dragInProgress)return;f=D?-e.x.initialDelta:e.x.initialDelta;var t=Math.max(0,Math.min(o,r+f));l=Math.round(t/o*100);v(t);p=n.top-i.top;d=n.left+t-i.left;if(D)d+=o-2*t;a.view()._updatePercentCompleteTooltip(p,d,l)},15)).bind("dragend",function(){a.trigger("percentResizeEnd",{task:t,percentComplete:l/100});c()}).bind("dragcancel",function(){v(r);c()}).userEvents.bind("select",function(){F()})},_createDependencyDraggable:function(){var o=this;var l;var d=m();var i=m();var r;var h;var p=g.styles;var e=this.options.editable;var f=function(){l.css("display","").removeClass(p.hovered);l.parent().removeClass(p.origin);l=null;c(false);i=m();d=m();o.view()._removeDependencyDragHint();o.dragInProgress=false};var c=function(e){if(!i.hasClass(p.origin)){i.find(k+p.taskDot).css("display",e?"block":"");d.toggleClass(p.hovered,e)}};if(!e||e.dependencyCreate===false)return;this._dependencyDraggable=new kendo.ui.Draggable(this.wrapper,{distance:0,filter:k+p.taskDot,holdToDrag:false});this._dependencyDraggable.bind("dragstart",function(e){if(o.trigger("dependencyDragStart")){e.preventDefault();return}l=e.currentTarget.css("display","block").addClass(p.hovered);l.parent().addClass(p.origin);var t=l.offset();var a=o.wrapper.find(k+p.tasksWrapper).offset();r=Math.round(t.left-a.left+_(l)/2);h=Math.round(t.top-a.top+u(l)/2);clearTimeout(o._tooltipTimeout);o.dragInProgress=true}).bind("drag",kendo.throttle(function(e){if(!o.dragInProgress)return;o.view()._removeDependencyDragHint();var t=m(kendo.elementUnderCursor(e));var a=o.wrapper.find(k+p.tasksWrapper).offset();var s=e.x.location-a.left;var n=e.y.location-a.top;o.view()._updateDependencyDragHint({x:r,y:h},{x:s,y:n});c(false);d=t.hasClass(p.taskDot)?t:m();i=t.closest(k+p.taskWrap);c(true)},15)).bind("dragend",function(){if(d.length){var e=l.hasClass(p.taskDotStart);var t=d.hasClass(p.taskDotStart);var a=e?t?3:2:t?1:0;var s=l.siblings(k+p.task);if(!s.length)s=l.closest(k+p.taskWrap).find(k+p.task);var n=o._taskByUid(s.attr("data-uid"));var i=d.siblings(k+p.task);if(!i.length)i=d.closest(k+p.taskWrap).find(k+p.task);var r=o._taskByUid(i.attr("data-uid"));if(n!==r)o.trigger("dependencyDragEnd",{type:a,predecessor:n,successor:r})}f()}).bind("dragcancel",function(){f()}).userEvents.bind("select",function(){F()})},_selectable:function(){var a=this;var s=g.styles;if(this.options.selectable)this.wrapper.on(o+r,k+s.task+","+k+s.taskOffset,function(e){e.stopPropagation();var t=m(this).attr("data-uid");if(!t)t=m(this).closest(k+s.taskWrap).find(k+s.task).data("uid");if(!e.ctrlKey)a.trigger("select",{uid:t});else a.trigger("clear")}).on(o+r,k+s.taskWrap,function(e){e.stopPropagation();m(this).css("z-index","0");var t=m(document.elementFromPoint(e.clientX,e.clientY));if(t.hasClass(s.line))t.click();m(this).css("z-index","")}).on(o+r,k+s.tasksWrapper,function(){if(a.selectDependency().length>0)a.clearSelection();else a.trigger("clear")}).on(o+r,k+s.line,function(e){e.stopPropagation();a.selectDependency(this)})},select:function(e){var t=this.wrapper.find(e);var a=g.styles;if(t.length){this.clearSelection();t.addClass(a.selected);if(kendo.support.mobileOS)t.parent().addClass(a.taskWrapActive);return}return this.wrapper.find(k+a.task+k+a.selected)},selectDependency:function(e){var t=this.wrapper.find(e);var a;var s=g.styles;if(t.length){this.clearSelection();this.trigger("clear");a=m(t).attr("data-uid");this.wrapper.find(k+s.line+"[data-uid='"+a+"']").addClass(s.selected);return}return this.wrapper.find(k+s.line+k+s.selected)},clearSelection:function(){var e=g.styles;this.wrapper.find(k+e.selected).removeClass(e.selected);if(kendo.support.mobileOS)this.wrapper.find(k+e.taskWrapActive).removeClass(e.taskWrapActive)},_attachEvents:function(){var s=this;var t=g.styles;var e=this.options.editable;if(e){this._tabindex();this.wrapper.on(o+r,k+t.taskDelete,function(e){s.trigger("removeTask",{uid:m(this).closest(k+t.taskWrap).find(k+t.task).attr("data-uid")});e.stopPropagation();e.preventDefault()}).on(w+r,function(e){var t;var a=s.options.editable;if(e.keyCode===n.DELETE&&a&&a.dependencyDestroy!==false){t=s.selectDependency();if(t.length){s.trigger("removeDependency",{uid:t.attr("data-uid")});s.clearSelection()}}});if(!kendo.support.mobileOS)this.wrapper.on(p+r,k+t.task+","+k+t.taskOffset,function(e){if(s.options.editable.update!==false){s.trigger("editTask",{uid:m(this).closest(k+t.taskWrap).find(k+t.task).attr("data-uid")});e.stopPropagation();e.preventDefault()}});else this.touch=this.wrapper.kendoTouch({filter:k+t.task+","+k+t.taskOffset,doubletap:function(e){if(s.options.editable.update!==false)s.trigger("editTask",{uid:m(e.touch.currentTarget).closest(k+t.taskWrap).find(k+t.task).attr("data-uid")})}}).data("kendoTouch")}},_tooltip:function(){var n=this;var e=this.options.tooltip;var i=g.styles;var a;var s=function(e){a=e.clientX};if(e&&e.visible===false)return;if(!kendo.support.mobileOS)this.wrapper.on(t+r,k+i.task,function(){var e=this;var t=n._taskByUid(m(this).attr("data-uid"));if(n.dragInProgress)return;n._tooltipTimeout=setTimeout(function(){n.view()._createTaskTooltip(t,e,a)},800);m(this).on(v,s)}).on(y+r,k+i.task,function(){clearTimeout(n._tooltipTimeout);n.view()._removeTaskTooltip();m(this).off(v,s)}).on(t+r,k+i.taskOffset,function(){var e=m(this).closest(k+i.taskWrap).find(k+i.task);var t=n._taskByUid(e.attr("data-uid"));if(n.dragInProgress)return;n._offsetTooltipTimeout=setTimeout(function(){n.view()._createOffsetTooltip(t,e,a)},800);m(this).on(v,s)}).on(y+r,k+i.taskOffset,function(){clearTimeout(n._offsetTooltipTimeout);n.view()._removeOffsetTooltip();m(this).off(v,s)}).on(t+r,k+i.taskPlanned,function(){var e=m(this).closest(k+i.taskWrap).find(k+i.task);var t=n._taskByUid(e.attr("data-uid"));n._plannedTooltipTimeout=setTimeout(function(){n.view()._createPlannedTooltip(t,e,a)},800);m(this).on(v,s)}).on(y+r,k+i.taskPlanned,function(){clearTimeout(n._plannedTooltipTimeout);n.view()._removePlannedTooltip();m(this).off(v,s)});else{this.wrapper.on(o+r,k+i.taskDelete,function(e){e.stopPropagation();n.view()._removeTaskTooltip()}).on(y+r,k+i.task,function(e){var t=m(e.relatedTarget).parents(k+i.taskWrap,k+i.task);if(t.length===0)n.view()._removeTaskTooltip()}).on(y+r,k+i.taskOffset,function(e){var t=m(e.relatedTarget).parents(k+i.taskWrap,k+i.task);if(t.length===0)n.view()._removeOffsetTooltip()}).on(y+r,k+i.taskPlanned,function(e){var t=m(e.relatedTarget).parents(k+i.taskWrap,k+i.task);if(t.length===0)n.view()._removePlannedTooltip()});if(this.touch)this.touch.bind("tap",function(e){var t=m(e.touch.target);var a=e.touch.x.client;var s;if(!t.hasClass(i.task)){s=n._taskByUid(t.closest(k+i.taskWrap).find(k+i.task).attr("data-uid"));if(n.view()._offsetTooltip)n.view()._removeOffsetTooltip();n.view()._createOffsetTooltip(s,t,a)}else{s=n._taskByUid(t.attr("data-uid"));if(n.view()._taskTooltip)n.view()._removeTaskTooltip();n.view()._createTaskTooltip(s,t,a)}}).bind("doubletap",function(){n.view()._removeTaskTooltip();n.view()._removeOffsetTooltip()})}},_setPlanned:function(e){this.options.showPlannedTasks=e;this.view().options.showPlannedTasks=e}});return d(true,g,{styles:B}),window.kendo})}("function"==typeof define&&define.amd?define:function(e,t,a){(a||t)()});
//# sourceMappingURL=kendo.gantt.timeline.min.js.map
